/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.couchbase.mock.CouchbaseBucket;
import org.couchbase.mock.CouchbaseMock;
import org.couchbase.mock.MemcacheBucket;
import org.couchbase.mock.memcached.DataStore;
import org.couchbase.mock.memcached.MemcachedServer;

public abstract class Bucket {
    protected final DataStore datastore;
    protected final MemcachedServer[] servers;
    protected final int numVBuckets;
    protected final String poolName = "default";
    protected final String name;
    protected final CouchbaseMock cluster;
    protected final String password;
    protected final ReentrantReadWriteLock configurationRwLock;

    public DataStore getDatastore() {
        return this.datastore;
    }

    public String getBucketUri() {
        return "/pools/default/bucketsStreaming/" + this.name;
    }

    public Bucket(String name, String hostname, int port, int numNodes, int bucketStartPort, int numVBuckets, CouchbaseMock cluster) throws IOException {
        this(name, hostname, port, numNodes, bucketStartPort, numVBuckets, cluster, "");
    }

    public MemcachedServer[] getServers() {
        return this.servers;
    }

    public Bucket(String name, String hostname, int port, int numNodes, int bucketStartPort, int numVBuckets, CouchbaseMock cluster, String password) throws IOException {
        BucketType type;
        this.cluster = cluster;
        this.name = name;
        this.numVBuckets = numVBuckets;
        this.password = password;
        this.datastore = new DataStore(numVBuckets);
        this.servers = new MemcachedServer[numNodes];
        this.configurationRwLock = new ReentrantReadWriteLock();
        if (this.getClass() == MemcacheBucket.class) {
            type = BucketType.MEMCACHE;
        } else if (this.getClass() == CouchbaseBucket.class) {
            type = BucketType.COUCHBASE;
        } else {
            throw new FileNotFoundException("I don't know about this type...");
        }
        for (int ii = 0; ii < this.servers.length; ++ii) {
            this.servers[ii] = new MemcachedServer(this, hostname, bucketStartPort == 0 ? 0 : bucketStartPort + ii, this.datastore);
        }
        this.rebalance();
    }

    public static Bucket create(BucketType type, String name, String hostname, int port, int numNodes, int bucketStartPort, int numVBuckets, CouchbaseMock cluster, String password) throws IOException {
        switch (type) {
            case MEMCACHE: {
                return new MemcacheBucket(name, hostname, port, numNodes, bucketStartPort, numVBuckets, cluster, password);
            }
            case COUCHBASE: {
                return new CouchbaseBucket(name, hostname, port, numNodes, bucketStartPort, numVBuckets, cluster, password);
            }
        }
        throw new FileNotFoundException("I don't know about this type...");
    }

    public abstract BucketType getType();

    public abstract String getJSON();

    public void configReadLock() {
        this.configurationRwLock.readLock().lock();
    }

    public void configReadUnlock() {
        this.configurationRwLock.readLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void failSome(float percentage) {
        this.configurationRwLock.writeLock().lock();
        try {
            for (int ii = 0; ii < this.servers.length; ++ii) {
                if ((float)ii % percentage != 0.0f) continue;
                this.servers[ii].shutdown();
            }
        }
        finally {
            this.configurationRwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fixSome(float percentage) {
        this.configurationRwLock.writeLock().lock();
        try {
            for (int ii = 0; ii < this.servers.length; ++ii) {
                if ((float)ii % percentage != 0.0f) continue;
                this.servers[ii].startup();
            }
        }
        finally {
            this.configurationRwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failover(int index) {
        this.configurationRwLock.writeLock().lock();
        try {
            if (index >= 0 && index < this.servers.length) {
                this.servers[index].shutdown();
            }
            this.rebalance();
        }
        finally {
            this.configurationRwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void respawn(int index) {
        this.configurationRwLock.writeLock().lock();
        try {
            if (index >= 0 && index < this.servers.length) {
                this.servers[index].startup();
            }
            this.rebalance();
        }
        finally {
            this.configurationRwLock.writeLock().unlock();
        }
    }

    void start(List<Thread> threads) {
        for (int ii = 0; ii < this.servers.length; ++ii) {
            Thread t = new Thread((Runnable)this.servers[ii], "mock memcached " + ii);
            t.setDaemon(true);
            t.start();
            threads.add(t);
        }
    }

    public List<MemcachedServer> activeServers() {
        ArrayList<MemcachedServer> active = new ArrayList<MemcachedServer>(this.servers.length);
        for (int ii = 0; ii < this.servers.length; ++ii) {
            if (!this.servers[ii].isActive()) continue;
            active.add(this.servers[ii]);
        }
        return active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rebalance() {
        this.configurationRwLock.writeLock().lock();
        try {
            Random random = new Random();
            List<MemcachedServer> nodes = this.activeServers();
            for (int ii = 0; ii < this.numVBuckets; ++ii) {
                int idx = random.nextInt(nodes.size());
                this.datastore.setOwnership(ii, nodes.get(idx));
            }
        }
        finally {
            this.configurationRwLock.writeLock().unlock();
        }
    }

    public String getPassword() {
        return this.password;
    }

    public String getName() {
        return this.name;
    }

    public static enum BucketType {
        MEMCACHE,
        COUCHBASE;

    }
}

