# Generated by default/object.tt
package Paws::CloudFormation::ModuleInfo;
  use Moose;
  has LogicalIdHierarchy => (is => 'ro', isa => 'Str');
  has TypeHierarchy => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudFormation::ModuleInfo

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudFormation::ModuleInfo object:

  $service_obj->Method(Att1 => { LogicalIdHierarchy => $value, ..., TypeHierarchy => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudFormation::ModuleInfo object:

  $result = $service_obj->Method(...);
  $result->Att1->LogicalIdHierarchy

=head1 DESCRIPTION

Contains information about the module from which the resource was
created, if the resource was created from a module included in the
stack template.

For more information on modules, see Using modules to encapsulate and
reuse resource configurations in the I<CloudFormation User Guide>.

=head1 ATTRIBUTES


=head2 LogicalIdHierarchy => Str

A concantenated list of the logical IDs of the module or modules
containing the resource. Modules are listed starting with the
inner-most nested module, and separated by C</>.

In the following example, the resource was created from a module,
C<moduleA>, that is nested inside a parent module, C<moduleB>.

C<moduleA/moduleB>

For more information, see Referencing resources in a module in the
I<CloudFormation User Guide>.


=head2 TypeHierarchy => Str

A concantenated list of the the module type or types containing the
resource. Module types are listed starting with the inner-most nested
module, and separated by C</>.

In the following example, the resource was created from a module of
type C<AWS::First::Example::MODULE>, that is nested inside a parent
module of type C<AWS::Second::Example::MODULE>.

C<AWS::First::Example::MODULE/AWS::Second::Example::MODULE>



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudFormation>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

