use strict;
use warnings;

use Test::More tests => 37;

BEGIN {#1
    use_ok( 'Graph::Dijkstra' ) || print "Bail out!\n";
}

{# infinity test
	my $PINF = 1e9999;
	ok("$PINF" eq '1.#INF', "positive infinity, $PINF");
}

{#tests 3-7


	my $graph = Graph::Dijkstra->new();
	ok(defined($graph), 'Dijkstra->new()');
	
	my $filename = 't/data/graphML2.xml';
	
	ok(-e $filename, "found $filename");
	
	ok($graph->inputGraphfromGraphML($filename),'$graph->inputGraphfromGraphML($filename)');
	
	my %Solution = (originID=>'1');
	my $solutionCost = $graph->farthestNode(\%Solution);
	
	ok( ($solutionCost == 1.8 and $Solution{path}{1}{destinationID} eq '5'),"GraphML: \$graph->farthestNode(\\\%Solution) for originID='1'");
	
	%Solution = (originID=>'1', destinationID=>'5');
	my $pathCost = $graph->shortestPath(\%Solution);
	
	ok( ($pathCost == 1.8 and $Solution{edges}->[0]->{targetID} eq '3'),"GraphML: \$graph->shortestPath(\\\%Solution) for originID='1', destinationID='5'");
}

{#tests 8-11

	my $graph = Graph::Dijkstra->new();
	
	my $filename = 't/data/graphML2.gml';
	
	ok(-e $filename, "found $filename");
	
	ok($graph->inputGraphfromGML($filename),'$graph->inputGraphfromGML($filename)');
	
	my %Solution = (originID=>'1');
	my $solutionCost = $graph->farthestNode(\%Solution);
	
	ok( ($solutionCost == 1.8 and $Solution{path}{1}{destinationID} eq '5'),"GML: \$graph->farthestNode(\\\%Solution) for originID='1'");
	
	%Solution = (originID=>'1', destinationID=>'5');
	my $pathCost = $graph->shortestPath(\%Solution);
	
	ok( ($pathCost == 1.8 and $Solution{edges}->[0]->{targetID} eq '3'),"GML: \$graph->shortestPath(\\\%Solution) for originID='1', destinationID='5'");

}


{#tests 12-15

	my $graph = Graph::Dijkstra->new();
	
	my $filename = 't/data/graphML2.json';
	
	ok(-e $filename, "found $filename");
	
	ok($graph->inputGraphfromJSON($filename),'$graph->inputGraphfromJSON($filename)');
	
	my %Solution = (originID=>'1');
	my $solutionCost = $graph->farthestNode(\%Solution);
	
	ok( ($solutionCost == 1.8 and $Solution{path}{1}{destinationID} eq '5'),"JSON: \$graph->farthestNode(\\\%Solution) for originID='1'");
	
	%Solution = (originID=>'1', destinationID=>'5');
	my $pathCost = $graph->shortestPath(\%Solution);
	
	ok( ($pathCost == 1.8 and $Solution{edges}->[0]->{targetID} eq '3'),"JSON: \$graph->shortestPath(\\\%Solution) for originID='1', destinationID='5'");

}


{#tests 16-19

	my $graph = Graph::Dijkstra->new();
	
	my $filename = 't/data/graphML2.csv';
	
	ok(-e $filename, "found $filename");
	
	ok($graph->inputGraphfromCSV($filename),'$graph->inputGraphfromCSV($filename)');
	
	my %Solution = (originID=>'1');
	my $solutionCost = $graph->farthestNode(\%Solution);
	
	ok( ($solutionCost == 1.8 and $Solution{path}{1}{destinationID} eq '5'),"CSV: \$graph->farthestNode(\\\%Solution) for originID='1'");
	
	%Solution = (originID=>'1', destinationID=>'5');
	my $pathCost = $graph->shortestPath(\%Solution);
	
	ok( ($pathCost == 1.8 and $Solution{edges}->[0]->{targetID} eq '3'),"CSV: \$graph->shortestPath(\\\%Solution) for originID='1', destinationID='5'");

}

{# 20-25
	my $graph = Graph::Dijkstra->new();
	
	my $filename = 't/data/graphML2.xml';
	$graph->inputGraphfromGraphML($filename);
	
	$filename = 't/data/graphML3.csv';
	$graph->outputGraphtoCSV($filename);
	ok(-e $filename, '$graph->outputGraphtoCSV($filename);');
	
	$filename = 't/data/graphML3.gml';
	$graph->outputGraphtoGML($filename, 'Test Test');
	ok(-e $filename, "\$graph->outputGraphtoGML(\$filename, 'Test Test');");
	
	$filename = 't/data/graphML3.json';
	$graph->outputGraphtoJSON($filename);
	ok(-e $filename, '$graph->outputGraphtoJSON($filename);');
	
	$filename = 't/data/graphML3.graphml.xml';
	$graph->outputGraphtoGraphML($filename, {});
	ok(-e $filename, '$graph->outputGraphtoGraphML($filename, {});');
	
	$filename = 't/data/graphML3.gexf.xml';
	$graph->outputGraphtoGEXF($filename);
	ok(-e $filename, '$graph->outputGraphtoGEXF($filename);');
	
	$filename = 't/data/graphML3.pajek.net';
	$graph->outputGraphtoNET($filename);
	ok(-e $filename, '$graph->outputGraphtoNET($filename);');
	

}

{# 26-27

	my $graph = Graph::Dijkstra->new();
	
	my $filename = 't/data/graphML3.csv';
	ok($graph->inputGraphfromCSV($filename),'$graph->inputGraphfromCSV($filename)');

	my %Solution = (originID=>'1');
	my $solutionCost = $graph->farthestNode(\%Solution);
	
	ok( ($solutionCost == 1.8 and $Solution{path}{1}{destinationID} eq '5'),"CSV: \$graph->farthestNode(\\\%Solution) for originID='1'");
	
	unlink($filename);
}

{# 28-29

	my $graph = Graph::Dijkstra->new();
	
	my $filename = 't/data/graphML3.json';
	ok($graph->inputGraphfromJSON($filename),'$graph->inputGraphfromJSON($filename)');

	my %Solution = (originID=>'1');
	my $solutionCost = $graph->farthestNode(\%Solution);
	
	ok( ($solutionCost == 1.8 and $Solution{path}{1}{destinationID} eq '5'),"JSON: \$graph->farthestNode(\\\%Solution) for originID='1'");
	
	unlink($filename);
}

{# 30-31

	my $graph = Graph::Dijkstra->new();
	
	my $filename = 't/data/graphML3.gexf.xml';
	ok($graph->inputGraphfromGEXF($filename),'$graph->inputGraphfromGEXF($filename)');

	my %Solution = (originID=>'1');
	my $solutionCost = $graph->farthestNode(\%Solution);
	
	ok( ($solutionCost == 1.8 and $Solution{path}{1}{destinationID} eq '5'),"GEXF: \$graph->farthestNode(\\\%Solution) for originID='1'");
	
	unlink($filename);
}

{# 32-33

	my $graph = Graph::Dijkstra->new();
	
	my $filename = 't/data/graphML3.gml';
	ok($graph->inputGraphfromGML($filename),'$graph->inputGraphfromGML($filename)');

	my %Solution = (originID=>'1');
	my $solutionCost = $graph->farthestNode(\%Solution);
	
	ok( ($solutionCost == 1.8 and $Solution{path}{1}{destinationID} eq '5'),"GML: \$graph->farthestNode(\\\%Solution) for originID='1'");
	
	unlink($filename);
}

{# 34-35

	my $graph = Graph::Dijkstra->new();
	
	my $filename = 't/data/graphML3.graphml.xml';
	ok($graph->inputGraphfromGraphML($filename),'$graph->inputGraphfromGraphML($filename)');

	my %Solution = (originID=>'1');
	my $solutionCost = $graph->farthestNode(\%Solution);
	
	ok( ($solutionCost == 1.8 and $Solution{path}{1}{destinationID} eq '5'),"GraphML: \$graph->farthestNode(\\\%Solution) for originID='1'");
	
	unlink($filename);
}


{# 36-37

	my $graph = Graph::Dijkstra->new();
	
	my $filename = 't/data/graphML3.pajek.net';
	ok($graph->inputGraphfromNET($filename),'$graph->inputGraphfromNET($filename)');

	my %Solution = (originID=>'1');
	my $solutionCost = $graph->farthestNode(\%Solution);
	
	ok( ($solutionCost == 1.8 and $Solution{path}{1}{destinationID} eq '5'),"NET: \$graph->farthestNode(\\\%Solution) for originID='1'");
	
	unlink($filename);
}



exit(0);