#!/usr/bin/perl

package eBay::API::XML::DataType::Enum::BidActionCodeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. BidActionCodeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::Enum::BidActionCodeType

=head1 DESCRIPTION

Possible bid action types or states.



=head1 SYNOPSIS

=cut



=head1 Enums:

=cut


=head2 Unknown

Unknown.



=cut


use constant Unknown => scalar('Unknown');


=head2 Bid

Bid. The offer is being or was placed on a competitive-bidding
listing (a Chinese or Dutch auction).



=cut


use constant Bid => scalar('Bid');


=head2 NotUsed

Not used.



=cut


use constant NotUsed => scalar('NotUsed');


=head2 Retraction

The offer was retracted by the user who extended the
offer. (This can only be done on the eBay site, not via API.)



=cut


use constant Retraction => scalar('Retraction');


=head2 AutoRetraction

The offer was automatically retracted. (This can only be done on the eBay site, not via API.)



=cut


use constant AutoRetraction => scalar('AutoRetraction');


=head2 Cancelled

The offer was cancelled. (This can only be done on the eBay site, not via API.)



=cut


use constant Cancelled => scalar('Cancelled');


=head2 AutoCancel

The offer was automatically cancelled. (This can only be done on the eBay site, not via API.)



=cut


use constant AutoCancel => scalar('AutoCancel');


=head2 Absentee

The offer placed was an absentee bid. (This can only be done on the eBay site, not via API.)



=cut


use constant Absentee => scalar('Absentee');


=head2 BuyItNow

The offer resulted in the successful exercise of the Buy It Now option for a Chinese auction.



=cut


use constant BuyItNow => scalar('BuyItNow');


=head2 Purchase

The offer is being or was placed on a fixed-price listing.
This value is used for fixed-price listings (Basic Fixed-Price and
eBay Stores Inventory listings) to purchase an item.
In the case of PlaceOffer, for Chinese items with the BIN option, specify Purchase to buy an item.
In the case of items listed with AutoPay, PlaceOffer can be used to bid, but not to purchase.



=cut


use constant Purchase => scalar('Purchase');


=head2 CustomCode

Reserved for future use.



=cut


use constant CustomCode => scalar('CustomCode');


=head2 Offer

If an item is best-offer enabled, use this value if a buyer is making a best offer on the item.
After a buyer makes a best offer (or counter-offer, etc.),
the buyer can get the status of the best offer (and of a possible seller-counter-offer, etc.)
using the GetBestOffers call.
See the Trading Web Services Guide for information about best-offer enabled items and
about GetBestOffers.



=cut


use constant Offer => scalar('Offer');


=head2 Counter

If an item is best-offer enabled, use this value if a buyer is making a counteroffer
to a seller's counteroffer.



=cut


use constant Counter => scalar('Counter');


=head2 Accept

If an item is best-offer enabled, use this value if a buyer is accepting a counteroffer
of a seller.



=cut


use constant Accept => scalar('Accept');


=head2 Decline

If an item is best-offer enabled, use this value if a buyer is declining a counteroffer
of a seller.



=cut


use constant Decline => scalar('Decline');







1;   
