#!/usr/bin/perl

package eBay::API::XML::DataType::DescriptionTemplateType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. DescriptionTemplateType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::DescriptionTemplateType

=head1 DESCRIPTION

The information for one Theme or one Layout.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::DescriptionTemplateType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::Enum::DescriptionTemplateCodeType;


my @gaProperties = ( [ 'GroupID', 'xs:int', '', '', '' ]
	, [ 'ID', 'xs:int', '', '', '' ]
	, [ 'ImageURL', 'xs:anyURI', '', '', '' ]
	, [ 'Name', 'xs:string', '', '', '' ]
	, [ 'TemplateXML', 'xs:string', '', '', '' ]
	, [ 'Type', 'ns:DescriptionTemplateCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::DescriptionTemplateCodeType', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setGroupID()

Unique identifier for the group in which a Theme falls 
(holidays, special events, etc.). Not returned for Layouts.

#    Argument: 'xs:int'

=cut

sub setGroupID {
  my $self = shift;
  $self->{'GroupID'} = shift
}

=head2 getGroupID()

  Calls: GetDescriptionTemplates
  Returned: Always

#    Returns: 'xs:int'

=cut

sub getGroupID {
  my $self = shift;
  return $self->{'GroupID'};
}


=head2 setID()

Unique identifier for one Theme or Layout.

#    Argument: 'xs:int'

=cut

sub setID {
  my $self = shift;
  $self->{'ID'} = shift
}

=head2 getID()

  Calls: GetDescriptionTemplates
  Returned: Always

#    Returns: 'xs:int'

=cut

sub getID {
  my $self = shift;
  return $self->{'ID'};
}


=head2 setImageURL()

URL for a small (100x120 pixel) image providing a sample of how a Theme or Layout looks.

#    Argument: 'xs:anyURI'

=cut

sub setImageURL {
  my $self = shift;
  $self->{'ImageURL'} = shift
}

=head2 getImageURL()

  Calls: GetDescriptionTemplates
  Returned: Always

#    Returns: 'xs:anyURI'

=cut

sub getImageURL {
  my $self = shift;
  return $self->{'ImageURL'};
}


=head2 setName()

Unique text name of the Theme or Layout.

#    Argument: 'xs:string'

=cut

sub setName {
  my $self = shift;
  $self->{'Name'} = shift
}

=head2 getName()

  Calls: GetDescriptionTemplates
  Returned: Always

#    Returns: 'xs:string'

=cut

sub getName {
  my $self = shift;
  return $self->{'Name'};
}


=head2 setTemplateXML()

XML defining the template. Elements you must include
in your XML: ThemeTop, ThemeUserCellTop, ThemeUserContent, 
ThemeUserCellBottom, ThemeBottom. Not returned for Layouts.

#    Argument: 'xs:string'

=cut

sub setTemplateXML {
  my $self = shift;
  $self->{'TemplateXML'} = shift
}

=head2 getTemplateXML()

  Calls: GetDescriptionTemplates
  Returned: Always

#    Returns: 'xs:string'

=cut

sub getTemplateXML {
  my $self = shift;
  return $self->{'TemplateXML'};
}


=head2 setType()

Either Layout or Theme.

#    Argument: 'ns:DescriptionTemplateCodeType'

=cut

sub setType {
  my $self = shift;
  $self->{'Type'} = shift
}

=head2 getType()

  Calls: GetDescriptionTemplates
  Returned: Always

#    Returns: 'ns:DescriptionTemplateCodeType'

=cut

sub getType {
  my $self = shift;
  return $self->{'Type'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
