use Test::More;

use Data::Object::Signatures;
use Data::Object qw(deduce);

fun greeting (StrObj $name) {
    return "hello, $name";
}

fun meeting (NumObj :$epoch = deduce time) {
    return "our meeting is at $epoch";
}

is greeting(deduce('martian')), 'hello, martian';
ok ! eval { greeting('martian') };
ok $@;

is meeting(epoch => deduce(time)), 'our meeting is at ' . time;
is meeting(epocj => deduce(time)), 'our meeting is at ' . time;

ok 1 and done_testing;
