package Class::Classgen::New;

$VERSION=3.00;

	use strict;
	use Class::Classgen::Comments;			# to remove problems by typing errors

sub new {				# constructor
	my ($self, $ref) = @_;
	my $type = ref($self)||$self;

	# instance-variables
	my $_rAttr;
	my $_type;
	
	$self=bless {
		_ref	=> $_rAttr,
		_type	=> $_type
	}, $type;
	
	$self->set_ref($ref);
	return $self;
}

sub get_ref {
	my ($self) = @_;
	$self->{_ref};
}

sub get_type {
	my ($self) = @_;
	$self->{_type};
}

sub set_ref {
	my ($self, $ref) = @_;
	$self->{_ref} = $ref;
}

sub set_type {
	my ($self, $type) = @_;
	$self->{_type} = $type;
}

sub write_attributes {
	my ($self) = @_;
	my $rl = $self->get_ref();
	my $attr;
	my $s;
	my $var;
	my $com;

	foreach $attr (@$rl) {
	#	$s.= "\tmy ". $attr->get_var() .";\n";
		next unless( $attr->get_var()=~m/[\$\%\@]/ );	# allowed types
		$var = Class::Classgen::Comments::just_var( $attr->get_var() );
		$com = Class::Classgen::Comments::just_comments( $attr->get_var() );
		$s.= "\tmy ". $var .";\t$com\n";
	}
	return $s;
}

sub write_blessing {
	my ($self) = @_;
	my $ral = $self->get_ref();
	my $s;
	
	if( $self->get_type() =~ m/{/ ) {
		my $attr;
		foreach $attr (@$ral) {
			$s.=$attr->generate_blessed_h();
		}
	}
	
	if( $self->get_type() =~ m/\[/ ) {
		print "blessing of anonymous array [] not implemented yet\n";
	}
	return $s;
}

sub write_code {
	my ($self) = @_;
	my $s='';
	my $t='';
	my $u='';
	my $v='';
	my $w='';
	
	$s = "sub new {\n";
	$s.= "\tmy (\$self) = \@_;\n";
	$s.= "\tmy \$type = ref(\$self)||\$self;\n";

	$s.= "\n\t\# instance-variables:\n";

	$t = $self->write_attributes();

	$u = "\n";
	$u.= "\t\$self=bless {\n";
	
	$v = $self->write_blessing();
	
	$w = "\t}, \$type;\n";

	# to put in some default code which supports inheritance
	$w.= "\t\#\$self->inherit_from(\$self->your_base::new());";
	$w.= "\t\# adapt when inheriting\n";

	$w.= "\treturn \$self;\n";
	$w.= "}\n\n";
	
	return $s.$t.$u.$v.$w;
}
	
1;	

__END__


=head1 NAME

New.pm - Creates the new() method for classes generated by classgen.


=head1 VERSION

3.00

=head1 SYNOPSIS

Used within classgen.

=head1 DESCRIPTION

The main purpose of New.pm is to write the new() method for a class generated by classgen. It provides code to derive local instance variables with 'my' for all specified instance variables. It provides code to store them within an anonymous hash (only way in the current version). Finally, this hash is blessed into the desired class.

=head2 Methods generated by New.pm

In the blessing section of the generated new() method:

=over 4

=item *

inherit_from(): copies the entries of the blessed {} from the base class into the blessed {} of the derived class.

=back

=head1 ENVIRONMENT

Nothing special. Just use Perl5.


=head1 DIAGNOSTICS

There is no special diagnostics. New.pm is used within classgen which is called with the B<-w> option.


=head1 BUGS

No bugs known.

=head1 FILES

Please refer to classgen.


=head1 SEE ALSO

perldoc classgen






=head1 AUTHOR

Name:  Michael Schlueter
email: mschlue@cpan.org

=head1 COPYRIGHT

Copyright (c) 2000, Michael Schlueter. All Rights Reserved. This module is free software. It may be used, redistributed and/or modified under the same terms as Perl itself.
