use 5.006;
use strict;
use warnings;
use ExtUtils::MakeMaker;

WriteMakefile(
    NAME                => 'Bio::KBase',
    AUTHOR              => q{Robert Olson <olson@mcs.anl.gov>},
    VERSION             => '0.05',
    ABSTRACT         => 'The KBase perl API.',
    ($ExtUtils::MakeMaker::VERSION >= 6.3002
      ? ('LICENSE'=> 'unrestricted')
      : ()),
    PL_FILES            => {},
    EXE_FILES => [
	'er_scripts/all_entities_AlignmentTree',
	'er_scripts/all_entities_Annotation',
	'er_scripts/all_entities_AtomicRegulon',
	'er_scripts/all_entities_Attribute',
	'er_scripts/all_entities_Biomass',
	'er_scripts/all_entities_BiomassCompound',
	'er_scripts/all_entities_Compartment',
	'er_scripts/all_entities_Complex',
	'er_scripts/all_entities_Compound',
	'er_scripts/all_entities_Contig',
	'er_scripts/all_entities_ContigChunk',
	'er_scripts/all_entities_ContigSequence',
	'er_scripts/all_entities_CoregulatedSet',
	'er_scripts/all_entities_Diagram',
	'er_scripts/all_entities_EcNumber',
	'er_scripts/all_entities_Experiment',
	'er_scripts/all_entities_Family',
	'er_scripts/all_entities_Feature',
	'er_scripts/all_entities_Genome',
	'er_scripts/all_entities_Identifier',
	'er_scripts/all_entities_Media',
	'er_scripts/all_entities_Model',
	'er_scripts/all_entities_ModelCompartment',
	'er_scripts/all_entities_OTU',
	'er_scripts/all_entities_Pairing',
	'er_scripts/all_entities_PairSet',
	'er_scripts/all_entities_ProbeSet',
	'er_scripts/all_entities_ProteinSequence',
	'er_scripts/all_entities_Publication',
	'er_scripts/all_entities_Reaction',
	'er_scripts/all_entities_ReactionRule',
	'er_scripts/all_entities_Reagent',
	'er_scripts/all_entities_Requirement',
	'er_scripts/all_entities_Role',
	'er_scripts/all_entities_Scenario',
	'er_scripts/all_entities_Source',
	'er_scripts/all_entities_SSCell',
	'er_scripts/all_entities_SSRow',
	'er_scripts/all_entities_Subsystem',
	'er_scripts/all_entities_SubsystemClass',
	'er_scripts/all_entities_TaxonomicGrouping',
	'er_scripts/all_entities_Variant',
	'er_scripts/all_entities_Variation',
	'er_scripts/get_entity_AlignmentTree',
	'er_scripts/get_entity_Annotation',
	'er_scripts/get_entity_AtomicRegulon',
	'er_scripts/get_entity_Attribute',
	'er_scripts/get_entity_Biomass',
	'er_scripts/get_entity_BiomassCompound',
	'er_scripts/get_entity_Compartment',
	'er_scripts/get_entity_Complex',
	'er_scripts/get_entity_Compound',
	'er_scripts/get_entity_Contig',
	'er_scripts/get_entity_ContigChunk',
	'er_scripts/get_entity_ContigSequence',
	'er_scripts/get_entity_CoregulatedSet',
	'er_scripts/get_entity_Diagram',
	'er_scripts/get_entity_EcNumber',
	'er_scripts/get_entity_Experiment',
	'er_scripts/get_entity_Family',
	'er_scripts/get_entity_Feature',
	'er_scripts/get_entity_Genome',
	'er_scripts/get_entity_Identifier',
	'er_scripts/get_entity_Media',
	'er_scripts/get_entity_Model',
	'er_scripts/get_entity_ModelCompartment',
	'er_scripts/get_entity_OTU',
	'er_scripts/get_entity_Pairing',
	'er_scripts/get_entity_PairSet',
	'er_scripts/get_entity_ProbeSet',
	'er_scripts/get_entity_ProteinSequence',
	'er_scripts/get_entity_Publication',
	'er_scripts/get_entity_Reaction',
	'er_scripts/get_entity_ReactionRule',
	'er_scripts/get_entity_Reagent',
	'er_scripts/get_entity_Requirement',
	'er_scripts/get_entity_Role',
	'er_scripts/get_entity_Scenario',
	'er_scripts/get_entity_Source',
	'er_scripts/get_entity_SSCell',
	'er_scripts/get_entity_SSRow',
	'er_scripts/get_entity_Subsystem',
	'er_scripts/get_entity_SubsystemClass',
	'er_scripts/get_entity_TaxonomicGrouping',
	'er_scripts/get_entity_Variant',
	'er_scripts/get_entity_Variation',
	'er_scripts/get_relationship_AffectsLevelOf',
	'er_scripts/get_relationship_Aligns',
	'er_scripts/get_relationship_Annotates',
	'er_scripts/get_relationship_Asserts',
	'er_scripts/get_relationship_Comprises',
	'er_scripts/get_relationship_Concerns',
	'er_scripts/get_relationship_Contains',
	'er_scripts/get_relationship_Controls',
	'er_scripts/get_relationship_Describes',
	'er_scripts/get_relationship_Determines',
	'er_scripts/get_relationship_DeterminesFunctionOf',
	'er_scripts/get_relationship_Displays',
	'er_scripts/get_relationship_Encompasses',
	'er_scripts/get_relationship_Formulated',
	'er_scripts/get_relationship_GeneratedLevelsFor',
	'er_scripts/get_relationship_HadResultsProducedBy',
	'er_scripts/get_relationship_HasAsExemplar',
	'er_scripts/get_relationship_HasAsSequence',
	'er_scripts/get_relationship_HasAssertionFrom',
	'er_scripts/get_relationship_HasAsTerminus',
	'er_scripts/get_relationship_HasCompoundAliasFrom',
	'er_scripts/get_relationship_HasCoregulationWith',
	'er_scripts/get_relationship_HasDefaultLocation',
	'er_scripts/get_relationship_HasFunctional',
	'er_scripts/get_relationship_HasIndicatedSignalFrom',
	'er_scripts/get_relationship_HasLevelsFrom',
	'er_scripts/get_relationship_HasMember',
	'er_scripts/get_relationship_HasParticipant',
	'er_scripts/get_relationship_HasPresenceOf',
	'er_scripts/get_relationship_HasProposedLocationIn',
	'er_scripts/get_relationship_HasReactionAliasFrom',
	'er_scripts/get_relationship_HasRealLocationIn',
	'er_scripts/get_relationship_HasRepresentativeOf',
	'er_scripts/get_relationship_HasResultsFor',
	'er_scripts/get_relationship_HasResultsIn',
	'er_scripts/get_relationship_HasRole',
	'er_scripts/get_relationship_HasSection',
	'er_scripts/get_relationship_HasStep',
	'er_scripts/get_relationship_HasUsage',
	'er_scripts/get_relationship_HasValueFor',
	'er_scripts/get_relationship_HasValueIn',
	'er_scripts/get_relationship_Implements',
	'er_scripts/get_relationship_Imported',
	'er_scripts/get_relationship_Includes',
	'er_scripts/get_relationship_IncludesPartOf',
	'er_scripts/get_relationship_IndicatedLevelsFor',
	'er_scripts/get_relationship_IndicatesSignalFor',
	'er_scripts/get_relationship_Involves',
	'er_scripts/get_relationship_IsAffectedIn',
	'er_scripts/get_relationship_IsAlignedBy',
	'er_scripts/get_relationship_IsAlignedIn',
	'er_scripts/get_relationship_IsAlignmentFor',
	'er_scripts/get_relationship_IsAnnotatedBy',
	'er_scripts/get_relationship_IsARequirementIn',
	'er_scripts/get_relationship_IsARequirementOf',
	'er_scripts/get_relationship_IsATopicOf',
	'er_scripts/get_relationship_IsBindingSiteFor',
	'er_scripts/get_relationship_IsBoundBy',
	'er_scripts/get_relationship_IsClassFor',
	'er_scripts/get_relationship_IsCollectedInto',
	'er_scripts/get_relationship_IsCollectionOf',
	'er_scripts/get_relationship_IsComponentOf',
	'er_scripts/get_relationship_IsComposedOf',
	'er_scripts/get_relationship_IsComprisedOf',
	'er_scripts/get_relationship_IsConfiguredBy',
	'er_scripts/get_relationship_IsConsistentTo',
	'er_scripts/get_relationship_IsConsistentWith',
	'er_scripts/get_relationship_IsContainedIn',
	'er_scripts/get_relationship_IsControlledUsing',
	'er_scripts/get_relationship_IsCoregulatedWith',
	'er_scripts/get_relationship_IsCoupledTo',
	'er_scripts/get_relationship_IsCoupledWith',
	'er_scripts/get_relationship_IsDefaultFor',
	'er_scripts/get_relationship_IsDefaultLocationOf',
	'er_scripts/get_relationship_IsDescribedBy',
	'er_scripts/get_relationship_IsDeterminedBy',
	'er_scripts/get_relationship_IsDisplayedOn',
	'er_scripts/get_relationship_IsDividedInto',
	'er_scripts/get_relationship_IsDivisionOf',
	'er_scripts/get_relationship_IsEncompassedIn',
	'er_scripts/get_relationship_IsExemplarOf',
	'er_scripts/get_relationship_IsFamilyFor',
	'er_scripts/get_relationship_IsFormedInto',
	'er_scripts/get_relationship_IsFormedOf',
	'er_scripts/get_relationship_IsFunctionalIn',
	'er_scripts/get_relationship_IsGroupFor',
	'er_scripts/get_relationship_IsImplementedBy',
	'er_scripts/get_relationship_IsInClass',
	'er_scripts/get_relationship_IsIncludedIn',
	'er_scripts/get_relationship_IsInGroup',
	'er_scripts/get_relationship_IsInPair',
	'er_scripts/get_relationship_IsInstanceOf',
	'er_scripts/get_relationship_IsInstantiatedBy',
	'er_scripts/get_relationship_IsInTaxa',
	'er_scripts/get_relationship_IsInvolvedIn',
	'er_scripts/get_relationship_IsLocatedIn',
	'er_scripts/get_relationship_IsLocusFor',
	'er_scripts/get_relationship_IsManagedBy',
	'er_scripts/get_relationship_IsMemberOf',
	'er_scripts/get_relationship_IsModeledBy',
	'er_scripts/get_relationship_IsNamedBy',
	'er_scripts/get_relationship_IsOwnedBy',
	'er_scripts/get_relationship_IsOwnerOf',
	'er_scripts/get_relationship_IsPairOf',
	'er_scripts/get_relationship_IsParticipationOf',
	'er_scripts/get_relationship_IsPresentIn',
	'er_scripts/get_relationship_IsProjectedOnto',
	'er_scripts/get_relationship_IsProposedLocationOf',
	'er_scripts/get_relationship_IsProteinFor',
	'er_scripts/get_relationship_IsRealLocationOf',
	'er_scripts/get_relationship_IsRegulatedIn',
	'er_scripts/get_relationship_IsRegulatedSetOf',
	'er_scripts/get_relationship_IsRelevantFor',
	'er_scripts/get_relationship_IsRelevantTo',
	'er_scripts/get_relationship_IsRepresentedIn',
	'er_scripts/get_relationship_IsRequiredBy',
	'er_scripts/get_relationship_IsRoleFor',
	'er_scripts/get_relationship_IsRoleOf',
	'er_scripts/get_relationship_IsRowOf',
	'er_scripts/get_relationship_IsSectionOf',
	'er_scripts/get_relationship_IsSequenceOf',
	'er_scripts/get_relationship_IsShownOn',
	'er_scripts/get_relationship_IsStepOf',
	'er_scripts/get_relationship_IsSubclassOf',
	'er_scripts/get_relationship_IsSubInstanceOf',
	'er_scripts/get_relationship_IsSuperclassOf',
	'er_scripts/get_relationship_IsTargetOf',
	'er_scripts/get_relationship_IsTaxonomyOf',
	'er_scripts/get_relationship_IsTerminusFor',
	'er_scripts/get_relationship_IsTriggeredBy',
	'er_scripts/get_relationship_IsUsageOf',
	'er_scripts/get_relationship_IsUsedAs',
	'er_scripts/get_relationship_IsUsedBy',
	'er_scripts/get_relationship_IsUseOf',
	'er_scripts/get_relationship_IsUtilizedIn',
	'er_scripts/get_relationship_Manages',
	'er_scripts/get_relationship_Models',
	'er_scripts/get_relationship_Names',
	'er_scripts/get_relationship_OperatesIn',
	'er_scripts/get_relationship_Overlaps',
	'er_scripts/get_relationship_ParticipatesAs',
	'er_scripts/get_relationship_ParticipatesIn',
	'er_scripts/get_relationship_ProducedResultsFor',
	'er_scripts/get_relationship_Produces',
	'er_scripts/get_relationship_ProjectsOnto',
	'er_scripts/get_relationship_Provided',
	'er_scripts/get_relationship_ReflectsStateOf',
	'er_scripts/get_relationship_Requires',
	'er_scripts/get_relationship_RunsByDefaultIn',
	'er_scripts/get_relationship_Shows',
	'er_scripts/get_relationship_Submitted',
	'er_scripts/get_relationship_Targets',
	'er_scripts/get_relationship_Triggers',
	'er_scripts/get_relationship_Uses',
	'er_scripts/get_relationship_UsesAliasForCompound',
	'er_scripts/get_relationship_UsesAliasForReaction',
	'er_scripts/get_relationship_Validates',
	'er_scripts/get_relationship_WasFormulatedBy',
	'er_scripts/get_relationship_WasGeneratedFrom',
	'er_scripts/get_relationship_WasImportedFrom',
	'er_scripts/get_relationship_WasProvidedBy',
	'er_scripts/get_relationship_WasSubmittedBy',
	'scripts/all_roles_used_in_models',
	'scripts/atomic_regulons_to_fids',
	'scripts/co_occurrence_evidence',
	'scripts/complexes_to_complex_data',
	'scripts/complexes_to_roles',
	'scripts/contigs_to_lengths',
	'scripts/contigs_to_md5s',
	'scripts/contigs_to_sequences',
	'scripts/equiv_sequence_assertions',
	'scripts/fids_to_annotations',
	'scripts/fids_to_atomic_regulons',
	'scripts/fids_to_co_occurring_fids',
	'scripts/fids_to_coexpressed_fids',
	'scripts/fids_to_dna_sequences',
	'scripts/fids_to_feature_data',
	'scripts/fids_to_functions',
	'scripts/fids_to_genomes',
	'scripts/fids_to_literature',
	'scripts/fids_to_locations',
	'scripts/fids_to_protein_families',
	'scripts/fids_to_protein_sequences',
	'scripts/fids_to_proteins',
	'scripts/fids_to_regulon_data',
	'scripts/fids_to_roles',
	'scripts/fids_to_subsystem_data',
	'scripts/fids_to_subsystems',
	'scripts/genomes_to_contigs',
	'scripts/genomes_to_fids',
	'scripts/genomes_to_genome_data',
	'scripts/genomes_to_md5s',
	'scripts/genomes_to_subsystems',
	'scripts/genomes_to_taxonomies',
	'scripts/locations_to_dna_sequences',
	'scripts/locations_to_fids',
	'scripts/md5s_to_genomes',
	'scripts/otu_members',
	'scripts/protein_families_to_co_occurring_families',
	'scripts/protein_families_to_fids',
	'scripts/protein_families_to_functions',
	'scripts/protein_families_to_proteins',
	'scripts/proteins_to_fids',
	'scripts/proteins_to_functions',
	'scripts/proteins_to_literature',
	'scripts/proteins_to_protein_families',
	'scripts/proteins_to_roles',
	'scripts/reaction_strings',
	'scripts/reactions_to_complexes',
	'scripts/regulons_to_fids',
	'scripts/representative',
	'scripts/roles_to_complexes',
	'scripts/roles_to_fids',
	'scripts/roles_to_protein_families',
	'scripts/roles_to_proteins',
	'scripts/roles_to_subsystems',
	'scripts/subsystems_to_fids',
	'scripts/subsystems_to_genomes',
	'scripts/subsystems_to_roles',
	'scripts/subsystems_to_spreadsheets',
	'scripts/text_search',
	'scripts/external_ids_to_kbase_ids',
	'scripts/kbase_ids_to_external_ids',
    ],
    PMLIBDIRS => ['lib'],
    PREREQ_PM => {
        'Test::More' => 0,
	'JSON::RPC::Client' => 0,
    },
    BUILD_REQUIRES => {
	'String::Random' => 0,
    },
    dist                => { COMPRESS => 'gzip -9f', SUFFIX => 'gz', },
    clean               => { FILES => 'Bio-KBase-*' },
);
