package Merge::CodeBlock;
our $VERSION = '0.01'; use 5.006; use strict; use warnings;
use Blessed::Merge; our ($bm, $caller);

sub import {
        my ($package, %options) = @_;
        $bm = Blessed::Merge->new(blessed => 0, unique_hash => 1, %options);
	do {
                no strict 'refs';
                $caller = caller();
                *{"${caller}::merge"} = \&merge;
        };
}

sub merge (&@) {
        my ($code, @items) = @_;
	my $out;
	for (my $i = 0; $i <= $#items; $i++) {
		my ($a, $b) = ($out || $items[$i], $out ? $items[$i] : $items[$i++ + 1]);
		no strict 'refs';
                ${"${caller}::a"} = $a;
                ${"${caller}::b"} = $b;
		my $exec = $code->();
		$out = (ref $a || ref $b) 
			? (! defined $exec || $exec < 1) 
				? $bm->merge($a, $b) 
				: $bm->merge($b, $a)
			: ($exec < 1) 
				? $a 
				: $b;
	}
	return $out;
}

=head1 NAME

Merge::CodeBlock - merge via code blocks

=head1 VERSION

Version 0.01

=cut

=head1 SYNOPSIS

Quick summary of what the module does.

Perhaps a little code snippet.

	use Merge::CodeBlock;

	my $highest = merge {
		$b <=> $a
	} 10, 211, 123, 30, 77;

	...

	my $struct = merge {
		$a->{id} <=> $b->{id}
	} { 
		id => 123, 
		name => 'day', 
		truth => 'teller' 
	}, { 
		id => 456, 
		game => 'jesus',
		secret => 'teller',
		reincarnation => 'luck'
	};

=head1 AUTHOR

LNATION, C<< <email at lnation.org> >>

=head1 BUGS

Please report any bugs or feature requests to C<bug-merge-codeblock at rt.cpan.org>, or through
the web interface at L<https://rt.cpan.org/NoAuth/ReportBug.html?Queue=Merge-CodeBlock>.  I will be notified, and then you'll
automatically be notified of progress on your bug as I make changes.

=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Merge::CodeBlock

You can also look for information at:

=over 4

=item * RT: CPAN's request tracker (report bugs here)

L<https://rt.cpan.org/NoAuth/Bugs.html?Dist=Merge-CodeBlock>

=item * CPAN Ratings

L<https://cpanratings.perl.org/d/Merge-CodeBlock>

=item * Search CPAN

L<https://metacpan.org/release/Merge-CodeBlock>

=back

=head1 ACKNOWLEDGEMENTS

=head1 LICENSE AND COPYRIGHT

This software is Copyright (c) 2023 by LNATION.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut

1; # End of Merge::CodeBlock
