/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_update_mfa_challenge.c
 * @brief Implementation of the update_mfa_challenge function for Postgres
 * @author Christian Grothoff
 */
#include "platform.h"
#include <taler/taler_error_codes.h>
#include <taler/taler_dbevents.h>
#include <taler/taler_pq_lib.h>
#include "pg_update_mfa_challenge.h"
#include "pg_helper.h"


enum GNUNET_DB_QueryStatus
TMH_PG_update_mfa_challenge (
  void *cls,
  uint64_t challenge_id,
  const char *code,
  uint32_t retry_counter,
  struct GNUNET_TIME_Absolute expiration_date,
  struct GNUNET_TIME_Absolute retransmission_date)
{
  struct PostgresClosure *pg = cls;
  struct GNUNET_PQ_QueryParam params[] = {
    GNUNET_PQ_query_param_uint64 (&challenge_id),
    GNUNET_PQ_query_param_string (code),
    GNUNET_PQ_query_param_uint32 (&retry_counter),
    GNUNET_PQ_query_param_absolute_time (&expiration_date),
    GNUNET_PQ_query_param_absolute_time (&retransmission_date),
    GNUNET_PQ_query_param_end
  };

  PREPARE (pg,
           "update_mfa_challenge",
           "UPDATE tan_challenges"
           " SET"
           "  code=$2"
           " ,retry_counter=$3"
           " ,expiration_date=$4"
           " ,retransmission_date=$5"
           " WHERE challenge_id = $1;");
  return GNUNET_PQ_eval_prepared_non_select (pg->conn,
                                             "update_mfa_challenge",
                                             params);
}
