/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import { parseDevExperimentUri } from "@gnu-taler/taler-util";
import { WalletApiOperation } from "@gnu-taler/taler-wallet-core";
import { useTranslationContext } from "@gnu-taler/web-util/browser";
import { useAlertContext } from "../../context/alert.js";
import { useBackendContext } from "../../context/backend.js";
import { Props, State } from "./index.js";

export function useComponentState({
  talerExperimentUri,
  onCancel,
  onSuccess,
}: Props): State {
  const api = useBackendContext();
  const { pushAlertOnError } = useAlertContext();
  const { i18n } = useTranslationContext();

  async function doApply(): Promise<void> {
    if (!talerExperimentUri) return;
    await api.wallet.call(WalletApiOperation.ApplyDevExperiment, {
      devExperimentUri: talerExperimentUri
    })
    // const resp = await api.wallet.call(WalletApiOperation.CreateDepositGroup, {
    //   amount: Amounts.stringify(amount),
    //   depositPaytoUri: uri,
    // });
    onSuccess();
  }
  const uri = talerExperimentUri === undefined ? undefined : parseDevExperimentUri(talerExperimentUri);

  if (!uri) {
    return {
      status: "error",
      error: {
        type: "error",
        message: i18n.str`Invalid dev experiment URI.`,
        description: i18n.str`URI: ${talerExperimentUri}`,
        cause: {},
        context: {},
      },
    };
  }
  if (uri.devExperimentId === "insert-denom-loss") {
    return {
      status: "insertLost",
      error: undefined,
      confirm: {
        onClick: pushAlertOnError(doApply),
      },
      cancel: onCancel,
    };
  }
  if (uri.devExperimentId === "insert-pending-refresh") {
    return {
      status: "pendingRefresh",
      error: undefined,
      confirm: {
        onClick: pushAlertOnError(doApply),
      },
      cancel: onCancel,
    };
  }
  return {
    status: "unknown",
    error: undefined,
    experimentId: uri.devExperimentId,
  }
}
