/*
 This file is part of GNU Taler
 (C) 2022-2024 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import { Attention, useTranslationContext } from "@gnu-taler/web-util/browser";
import { VNode, h } from "preact";
import { useBankCoreApiContext } from "@gnu-taler/web-util/browser";
import { useBankState } from "../hooks/bank-state.js";
import { RouteDefinition } from "@gnu-taler/web-util/browser";
import { WithdrawalQRCode } from "./WithdrawalQRCode.js";
import { HostPortPath } from "@gnu-taler/taler-util";
import { TalerUris } from "@gnu-taler/taler-util";

const TALER_SCREEN_ID = 115;

export function WithdrawalOperationPage({
  operationId,
  onOperationAborted,
  routeClose,
  origin,
}: {
  operationId: string;
  origin: "from-bank-ui" | "from-wallet-ui";
  onOperationAborted: () => void;
  routeClose: RouteDefinition;
}): VNode {
  const {
    lib: { bank: api },
  } = useBankCoreApiContext();
  const parsedUri = TalerUris.createTalerWithdraw(
    api.getIntegrationAPI().href as HostPortPath,
    operationId,
  );
  const uri = TalerUris.toString(parsedUri);
  const { i18n } = useTranslationContext();
  const [, updateBankState] = useBankState();

  if (!parsedUri) {
    return (
      <Attention
        type="danger"
        title={i18n.str`The Withdrawal URI is not valid`}
      >
        {uri}
      </Attention>
    );
  }

  return (
    <WithdrawalQRCode
      withdrawUri={parsedUri}
      origin={origin}
      onOperationAborted={() => {
        updateBankState("currentWithdrawalOperationId", undefined);
        onOperationAborted();
      }}
      routeClose={routeClose}
    />
  );
}
