/* -*-C-*-
 * access to the X Window System for Sather
 * (c) 1994/11/11 - 1995/03/09 by Erik Schnetter
 */

#include <alloca.h>
#include <malloc.h>
#include <X11/Xlib.h>
#include "header.h"



BOOL X_AllocColor (Display* display, INT colormap, XColor* color)
{
  return XAllocColor (display, colormap, color);
}


   
BOOL X_AllocNamedColor
  (Display* display, INT colormap, CHAR* color_name,
   XColor* screen_def, XColor* exact_def)
{
  return XAllocNamedColor
    (display, colormap, color_name, screen_def, exact_def);
}



BOOL X_AllocColorCells (Display* display, Colormap colormap, BOOL contig,
			INT* planes, INT nplanes, INT* pixels, INT npixels)
{
  BOOL res;
  unsigned long *pl, *pix;
  
  /* allocate arrays, if necessary */
  if (sizeof(INT) != sizeof(unsigned long)) {
    pl  = (unsigned long*) alloca (nplanes * sizeof(unsigned long));
    pix = (unsigned long*) alloca (npixels * sizeof(unsigned long));
  } else {
    pl  = (unsigned long*) planes;
    pix = (unsigned long*) pixels;
  }
  res = XAllocColorCells
    (display, colormap, contig, pl, nplanes, pix, npixels);
  /* copy arrays, if necessary */
  if (sizeof(INT) != sizeof(unsigned long)) {
    int i;
    for (i=nplanes; i--;) { planes[i] = pl[i]; }
    for (i=npixels; i--;) { pixels[i] = pix[i]; }
  }
  return res;
}



BOOL X_AllocColorPlanes (Display* display, Colormap colormap, BOOL contig,
			 INT* pixels, INT npixels,
			 INT nreds, INT ngreens, INT nblues, INT* ints)
{
  BOOL res;
  unsigned long *pix;
  unsigned long rmask, gmask, bmask;
  
  /* allocate array, if necessary */
  if (sizeof(INT) != sizeof(unsigned long)) {
    pix = (unsigned long*) alloca (npixels * sizeof(unsigned long));
  } else {
    pix = (unsigned long*) pixels;
  }
  res = XAllocColorPlanes (display, colormap, contig, pix, npixels,
			   nreds, ngreens, nblues, &rmask, &gmask, &bmask);
  ints[0] = rmask;
  ints[1] = gmask;
  ints[2] = bmask;
  /* copy array, if necessary */
  if (sizeof(INT) != sizeof(unsigned long)) {
    int i;
    for (i=npixels; i--;) { pixels[i] = pix[i]; }
  }
  return res;
}



void X_FreeColors (Display* display, INT colormap, INT pixels[], INT npixels,
		   INT planes)
{
  unsigned long* p;
  
  /* copy array, if necessary */
  if (sizeof(INT) != sizeof(unsigned long)) {
    int i;
    p = (unsigned long*) alloca (npixels * sizeof(unsigned long));
    for (i=npixels; i--;) p[i]=pixels[i];
  } else {
    p = (unsigned long*) pixels;
  }
  XFreeColors (display, colormap, p, npixels, planes);
}



INT X_CreateColormap (Display* display, INT window, Visual* visual, INT alloc)
{
  return XCreateColormap (display, window, visual, alloc);
}

INT X_CopyColormapAndFree (Display* display, INT colormap)
{
  return XCopyColormapAndFree (display, colormap);
}

void X_FreeColormap (Display* display, INT colormap)
{
  XFreeColormap (display, colormap);
}



void X_QueryColor (Display* display, INT colormap, XColor* def_in_out)
{
  XQueryColor (display, colormap, def_in_out);
}

XColor* X_QueryColors_first (INT ncolors)
{
  return (XColor*) malloc (ncolors * sizeof(XColor));
}

void X_QueryColors_loop1 (XColor ptr[], INT n, XColor* color)
{
  ptr[n] = *color;
}

void X_QueryColors_middle
  (Display* display, INT colormap, XColor ptr[], INT ncolors)
{
  XQueryColors (display, colormap, ptr, ncolors);
}

void X_QueryColors_loop2 (XColor ptr[], INT n, XColor* color)
{
  *color = ptr[n];
}

void X_QueryColors_last (XColor ptr[])
{
  free (ptr);
}



Status X_LookupColor
  (Display* display, INT colormap, char* color_name,
   XColor* exact_def, XColor* screen_def)
{
  return XLookupColor (display, colormap, color_name, exact_def, screen_def);
}

Status X_ParseColor
  (Display* display, INT colormap, char* spec, XColor* exact_def)
{
  return XParseColor (display, colormap, spec, exact_def);
}



void X_StoreColor (Display* display, INT colormap, XColor* def_in_out)
{
  XStoreColor (display, colormap, def_in_out);
}

XColor* X_StoreColors_first (INT ncolors)
{
  return (XColor*) malloc (ncolors * sizeof(XColor));
}

void X_StoreColors_loop1 (XColor ptr[], INT n, XColor* color)
{
  ptr[n] = *color;
}

void X_StoreColors_middle
  (Display* display, INT colormap, XColor ptr[], INT ncolors)
{
  XStoreColors (display, colormap, ptr, ncolors);
}

void X_StoreColors_loop2 (XColor ptr[], INT n, XColor* color)
{
  *color = ptr[n];
}

void X_StoreColors_last (XColor ptr[])
{
  free (ptr);
}

void X_StoreNamedColor
  (Display* display, INT colormap, char* color, INT pixel, INT flags)
{
  XStoreNamedColor (display, colormap, color, pixel, flags);
}
