/* line.c generated by valac 0.50.1.42-81856-dirty, the Vala compiler
 * generated from line.vala, do not modify */

/* Line-oriented editing functions

   Copyright (c) 1997-2020 Free Software Foundation, Inc.

   This file is part of GNU Zile.

   GNU Zile is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Zile is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <https://www.gnu.org/licenses/>.  */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <stdarg.h>
#include <estr.h>

#define TYPE_BUFFER (buffer_get_type ())
#define BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUFFER, Buffer))
#define BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUFFER, BufferClass))
#define IS_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUFFER))
#define IS_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUFFER))
#define BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUFFER, BufferClass))

typedef struct _Buffer Buffer;
typedef struct _BufferClass BufferClass;
typedef struct _BufferPrivate BufferPrivate;

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MARKER, MarkerClass))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define IS_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MARKER))
#define MARKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MARKER, MarkerClass))

typedef struct _Marker Marker;
typedef struct _MarkerClass MarkerClass;

#define TYPE_UNDO (undo_get_type ())
#define UNDO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO, Undo))
#define UNDO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO, UndoClass))
#define IS_UNDO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO))
#define IS_UNDO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO))
#define UNDO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO, UndoClass))

typedef struct _Undo Undo;
typedef struct _UndoClass UndoClass;

#define TYPE_VAR_ENTRY (var_entry_get_type ())
#define VAR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VAR_ENTRY, VarEntry))
#define VAR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VAR_ENTRY, VarEntryClass))
#define IS_VAR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VAR_ENTRY))
#define IS_VAR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VAR_ENTRY))
#define VAR_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VAR_ENTRY, VarEntryClass))

typedef struct _VarEntry VarEntry;
typedef struct _VarEntryClass VarEntryClass;
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _marker_unref0(var) ((var == NULL) ? NULL : (var = (marker_unref (var), NULL)))
#define _immutable_estr_unref0(var) ((var == NULL) ? NULL : (var = (immutable_estr_unref (var), NULL)))
typedef gboolean (*MovementDelegate) (gpointer user_data);
typedef gboolean (*Function) (glong uniarg, GeeQueue* args);

#define TYPE_LISP_FUNC (lisp_func_get_type ())
#define LISP_FUNC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LISP_FUNC, LispFunc))
#define LISP_FUNC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LISP_FUNC, LispFuncClass))
#define IS_LISP_FUNC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LISP_FUNC))
#define IS_LISP_FUNC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LISP_FUNC))
#define LISP_FUNC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LISP_FUNC, LispFuncClass))

typedef struct _LispFunc LispFunc;
typedef struct _LispFuncClass LispFuncClass;
#define _lisp_func_unref0(var) ((var == NULL) ? NULL : (var = (lisp_func_unref (var), NULL)))

struct _Buffer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BufferPrivate * priv;
	gchar* name;
	gchar* filename;
	Buffer* next;
	gsize goalc;
	Marker* mark;
	Marker* markers;
	GList* last_undop;
	GList* next_undop;
	GHashTable* vars;
	gboolean modified;
	gboolean nosave;
	gboolean needname;
	gboolean temporary;
	gboolean readonly;
	gboolean backup;
	gboolean noundo;
	gboolean autofill;
	gboolean isearch;
	gboolean mark_active;
	gchar* dir;
};

struct _BufferClass {
	GTypeClass parent_class;
	void (*finalize) (Buffer *self);
	gsize (*get_length) (Buffer* self);
	const gchar* (*get_eol) (Buffer* self);
};

extern Buffer* cur_bp;

void insert_expanded_tab (void);
gpointer buffer_ref (gpointer instance);
void buffer_unref (gpointer instance);
GParamSpec* param_spec_buffer (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_buffer (GValue* value,
                       gpointer v_object);
void value_take_buffer (GValue* value,
                        gpointer v_object);
gpointer value_get_buffer (const GValue* value);
GType buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Buffer, buffer_unref)
gsize buffer_tab_width (Buffer* self);
void bprintf (const gchar* fmt,
              ...);
gpointer marker_ref (gpointer instance);
void marker_unref (gpointer instance);
GParamSpec* param_spec_marker (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_marker (GValue* value,
                       gpointer v_object);
void value_take_marker (GValue* value,
                        gpointer v_object);
gpointer value_get_marker (const GValue* value);
GType marker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Marker, marker_unref)
gpointer undo_ref (gpointer instance);
void undo_unref (gpointer instance);
GParamSpec* param_spec_undo (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
void value_set_undo (GValue* value,
                     gpointer v_object);
void value_take_undo (GValue* value,
                      gpointer v_object);
gpointer value_get_undo (const GValue* value);
GType undo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Undo, undo_unref)
gpointer var_entry_ref (gpointer instance);
void var_entry_unref (gpointer instance);
GParamSpec* param_spec_var_entry (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
void value_set_var_entry (GValue* value,
                          gpointer v_object);
void value_take_var_entry (GValue* value,
                           gpointer v_object);
gpointer value_get_var_entry (const GValue* value);
GType var_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VarEntry, var_entry_unref)
gboolean insert_tab (void);
gboolean buffer_warn_if_readonly (Buffer* self);
gboolean get_variable_bool (const gchar* name);
gboolean buffer_insert_char (Buffer* self,
                             gchar c);
gboolean intercalate_newline (void);
gboolean insert_newline (void);
gboolean buffer_move_char (Buffer* self,
                           glong offset);
gboolean* fill_break_line (void);
glong* parse_number (const gchar* s);
const gchar* buffer_get_variable (Buffer* self,
                                  const gchar* name);
void minibuf_error (const gchar* fmt,
                    ...);
Marker* marker_point (void);
gsize buffer_get_pt (Buffer* self);
gsize buffer_line_o (Buffer* self);
gchar buffer_get_char (Buffer* self,
                       gsize o);
gsize buffer_end_of_line (Buffer* self,
                          gsize o);
void buffer_goto_offset (Buffer* self,
                         gsize o);
gboolean funcall (const gchar* name,
                  glong* maybe_uniarg,
                  GeeQueue* args);
gsize marker_get_o (Marker* self);
void marker_unchain (Marker* self);
static gboolean* _bool_dup (gboolean* self);
gboolean newline (void);
gboolean buffer_insert_estr (Buffer* self,
                             ImmutableEstr* es);
void previous_nonblank_goalc (void);
gboolean buffer_is_blank_line (Buffer* self);
gboolean buffer_eolp (Buffer* self);
gsize previous_line_indent (void);
gchar buffer_following_char (Buffer* self);
void line_init (void);
static gboolean __lambda102_ (glong uniarg,
                       GeeQueue* args);
gboolean execute_with_uniarg (glong uniarg,
                              MovementDelegate forward,
                              gpointer forward_target,
                              MovementDelegate backward,
                              gpointer backward_target);
static gboolean _insert_tab_movement_delegate (gpointer self);
static gboolean ___lambda102__function (glong uniarg,
                                 GeeQueue* args);
LispFunc* lisp_func_new (const gchar* name,
                         Function func,
                         gboolean interactive,
                         const gchar* doc);
LispFunc* lisp_func_construct (GType object_type,
                               const gchar* name,
                               Function func,
                               gboolean interactive,
                               const gchar* doc);
gpointer lisp_func_ref (gpointer instance);
void lisp_func_unref (gpointer instance);
GParamSpec* param_spec_lisp_func (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
void value_set_lisp_func (GValue* value,
                          gpointer v_object);
void value_take_lisp_func (GValue* value,
                           gpointer v_object);
gpointer value_get_lisp_func (const GValue* value);
GType lisp_func_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LispFunc, lisp_func_unref)
static gboolean __lambda103_ (glong uniarg,
                       GeeQueue* args);
static gboolean _newline_movement_delegate (gpointer self);
static gboolean ___lambda103__function (glong uniarg,
                                 GeeQueue* args);
static gboolean __lambda104_ (glong uniarg,
                       GeeQueue* args);
static gboolean _intercalate_newline_movement_delegate (gpointer self);
static gboolean ___lambda104__function (glong uniarg,
                                 GeeQueue* args);
static gboolean __lambda105_ (glong uniarg,
                       GeeQueue* args);
static gboolean ___lambda105__function (glong uniarg,
                                 GeeQueue* args);
static gboolean __lambda106_ (glong uniarg,
                       GeeQueue* args);
gboolean int_or_uniarg (GeeQueue* args,
                        glong* n,
                        glong uniarg);
gboolean buffer_delete_char (Buffer* self);
static gboolean _buffer_delete_char_movement_delegate (gpointer self);
gboolean buffer_backward_delete_char (Buffer* self);
static gboolean _buffer_backward_delete_char_movement_delegate (gpointer self);
static gboolean ___lambda106__function (glong uniarg,
                                 GeeQueue* args);
static gboolean __lambda107_ (glong uniarg,
                       GeeQueue* args);
static gboolean ___lambda107__function (glong uniarg,
                                 GeeQueue* args);
static gboolean __lambda108_ (glong uniarg,
                       GeeQueue* args);
gboolean buffer_bolp (Buffer* self);
gchar buffer_preceding_char (Buffer* self);
static gboolean ___lambda108__function (glong uniarg,
                                 GeeQueue* args);
static gboolean __lambda109_ (glong uniarg,
                       GeeQueue* args);
static gboolean ___lambda109__function (glong uniarg,
                                 GeeQueue* args);
static gboolean __lambda110_ (glong uniarg,
                       GeeQueue* args);
static gboolean ___lambda110__function (glong uniarg,
                                 GeeQueue* args);
static gboolean __lambda111_ (glong uniarg,
                       GeeQueue* args);
static gboolean ___lambda111__function (glong uniarg,
                                 GeeQueue* args);
static gboolean __lambda112_ (glong uniarg,
                       GeeQueue* args);
static gboolean ___lambda112__function (glong uniarg,
                                 GeeQueue* args);

void
insert_expanded_tab (void)
{
	gsize t = 0UL;
	Buffer* _tmp0_;
	Buffer* _tmp1_;
#line 21 "src/line.vala"
	_tmp0_ = cur_bp;
#line 21 "src/line.vala"
	t = buffer_tab_width (_tmp0_);
#line 22 "src/line.vala"
	_tmp1_ = cur_bp;
#line 22 "src/line.vala"
	bprintf ("%*s", (gint) (t - (_tmp1_->goalc % t)), "", NULL);
#line 322 "line.c"
}

gboolean
insert_tab (void)
{
	Buffer* _tmp0_;
	gboolean result = FALSE;
#line 26 "src/line.vala"
	_tmp0_ = cur_bp;
#line 26 "src/line.vala"
	if (buffer_warn_if_readonly (_tmp0_)) {
#line 27 "src/line.vala"
		result = FALSE;
#line 27 "src/line.vala"
		return result;
#line 338 "line.c"
	}
#line 29 "src/line.vala"
	if (get_variable_bool ("indent-tabs-mode")) {
#line 342 "line.c"
		Buffer* _tmp1_;
#line 30 "src/line.vala"
		_tmp1_ = cur_bp;
#line 30 "src/line.vala"
		buffer_insert_char (_tmp1_, '\t');
#line 348 "line.c"
	} else {
#line 32 "src/line.vala"
		insert_expanded_tab ();
#line 352 "line.c"
	}
#line 34 "src/line.vala"
	result = TRUE;
#line 34 "src/line.vala"
	return result;
#line 358 "line.c"
}

gboolean
intercalate_newline (void)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
#line 42 "src/line.vala"
	if (insert_newline ()) {
#line 368 "line.c"
		Buffer* _tmp1_;
#line 42 "src/line.vala"
		_tmp1_ = cur_bp;
#line 42 "src/line.vala"
		_tmp0_ = buffer_move_char (_tmp1_, (glong) -1);
#line 374 "line.c"
	} else {
#line 42 "src/line.vala"
		_tmp0_ = FALSE;
#line 378 "line.c"
	}
#line 42 "src/line.vala"
	result = _tmp0_;
#line 42 "src/line.vala"
	return result;
#line 384 "line.c"
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
#line 108 "src/line.vala"
	dup = g_new0 (gboolean, 1);
#line 108 "src/line.vala"
	memcpy (dup, self, sizeof (gboolean));
#line 108 "src/line.vala"
	return dup;
#line 397 "line.c"
}

static gpointer
__bool_dup0 (gpointer self)
{
#line 108 "src/line.vala"
	return self ? _bool_dup (self) : NULL;
#line 405 "line.c"
}

gboolean*
fill_break_line (void)
{
	glong* n = NULL;
	Buffer* _tmp0_;
	const gchar* _tmp1_;
	glong* _tmp2_;
	gboolean _tmp3_ = FALSE;
	glong* _tmp4_;
	gsize fillcol = 0UL;
	glong* _tmp6_;
	gboolean break_made = FALSE;
	Buffer* _tmp7_;
	gboolean* _tmp41_;
	gboolean* result = NULL;
#line 54 "src/line.vala"
	_tmp0_ = cur_bp;
#line 54 "src/line.vala"
	_tmp1_ = buffer_get_variable (_tmp0_, "fill-column");
#line 54 "src/line.vala"
	_tmp2_ = parse_number (_tmp1_);
#line 54 "src/line.vala"
	n = _tmp2_;
#line 55 "src/line.vala"
	_tmp4_ = n;
#line 55 "src/line.vala"
	if (_tmp4_ == NULL) {
#line 55 "src/line.vala"
		_tmp3_ = TRUE;
#line 437 "line.c"
	} else {
		glong* _tmp5_;
#line 55 "src/line.vala"
		_tmp5_ = n;
#line 55 "src/line.vala"
		_tmp3_ = (*_tmp5_) < ((glong) 0);
#line 444 "line.c"
	}
#line 55 "src/line.vala"
	if (_tmp3_) {
#line 56 "src/line.vala"
		minibuf_error ("Wrong type argument: number-or-markerp, nil", NULL);
#line 57 "src/line.vala"
		result = NULL;
#line 57 "src/line.vala"
		_g_free0 (n);
#line 57 "src/line.vala"
		return result;
#line 456 "line.c"
	}
#line 59 "src/line.vala"
	_tmp6_ = n;
#line 59 "src/line.vala"
	fillcol = (gsize) (*_tmp6_);
#line 61 "src/line.vala"
	break_made = FALSE;
#line 64 "src/line.vala"
	_tmp7_ = cur_bp;
#line 64 "src/line.vala"
	if (_tmp7_->goalc > fillcol) {
#line 468 "line.c"
		gsize break_col = 0UL;
		Marker* m = NULL;
		Marker* _tmp8_;
		gsize old_col = 0UL;
		Buffer* _tmp9_;
		gsize _tmp10_;
		gsize _tmp11_;
		Buffer* _tmp12_;
		Marker* _tmp40_;
#line 65 "src/line.vala"
		break_col = (gsize) 0;
#line 68 "src/line.vala"
		_tmp8_ = marker_point ();
#line 68 "src/line.vala"
		m = _tmp8_;
#line 71 "src/line.vala"
		_tmp9_ = cur_bp;
#line 71 "src/line.vala"
		_tmp10_ = buffer_get_pt (_tmp9_);
#line 71 "src/line.vala"
		_tmp11_ = _tmp10_;
#line 71 "src/line.vala"
		_tmp12_ = cur_bp;
#line 71 "src/line.vala"
		old_col = _tmp11_ - buffer_line_o (_tmp12_);
#line 72 "src/line.vala"
		while (TRUE) {
#line 496 "line.c"
			Buffer* _tmp13_;
			Buffer* _tmp14_;
#line 72 "src/line.vala"
			_tmp13_ = cur_bp;
#line 72 "src/line.vala"
			if (!(_tmp13_->goalc > (fillcol + 1))) {
#line 72 "src/line.vala"
				break;
#line 505 "line.c"
			}
#line 73 "src/line.vala"
			_tmp14_ = cur_bp;
#line 73 "src/line.vala"
			buffer_move_char (_tmp14_, (glong) -1);
#line 511 "line.c"
		}
		{
			gsize i = 0UL;
			Buffer* _tmp15_;
			gsize _tmp16_;
			gsize _tmp17_;
			Buffer* _tmp18_;
#line 76 "src/line.vala"
			_tmp15_ = cur_bp;
#line 76 "src/line.vala"
			_tmp16_ = buffer_get_pt (_tmp15_);
#line 76 "src/line.vala"
			_tmp17_ = _tmp16_;
#line 76 "src/line.vala"
			_tmp18_ = cur_bp;
#line 76 "src/line.vala"
			i = _tmp17_ - buffer_line_o (_tmp18_);
#line 529 "line.c"
			{
				gboolean _tmp19_ = FALSE;
#line 76 "src/line.vala"
				_tmp19_ = TRUE;
#line 76 "src/line.vala"
				while (TRUE) {
#line 536 "line.c"
					Buffer* _tmp21_;
					Buffer* _tmp22_;
#line 76 "src/line.vala"
					if (!_tmp19_) {
#line 541 "line.c"
						gsize _tmp20_;
#line 76 "src/line.vala"
						_tmp20_ = i;
#line 76 "src/line.vala"
						i = _tmp20_ - 1;
#line 547 "line.c"
					}
#line 76 "src/line.vala"
					_tmp19_ = FALSE;
#line 76 "src/line.vala"
					if (!(i > ((gsize) 0))) {
#line 76 "src/line.vala"
						break;
#line 555 "line.c"
					}
#line 77 "src/line.vala"
					_tmp21_ = cur_bp;
#line 77 "src/line.vala"
					_tmp22_ = cur_bp;
#line 77 "src/line.vala"
					if (g_ascii_isspace (buffer_get_char (_tmp21_, (buffer_line_o (_tmp22_) + i) - 1))) {
#line 78 "src/line.vala"
						break_col = i;
#line 79 "src/line.vala"
						break;
#line 567 "line.c"
					}
				}
			}
		}
#line 85 "src/line.vala"
		if (break_col == ((gsize) 0)) {
#line 574 "line.c"
			{
				gsize i = 0UL;
				Buffer* _tmp23_;
				gsize _tmp24_;
				gsize _tmp25_;
#line 86 "src/line.vala"
				_tmp23_ = cur_bp;
#line 86 "src/line.vala"
				_tmp24_ = buffer_get_pt (_tmp23_);
#line 86 "src/line.vala"
				_tmp25_ = _tmp24_;
#line 86 "src/line.vala"
				i = _tmp25_ + 1;
#line 588 "line.c"
				{
					gboolean _tmp26_ = FALSE;
#line 86 "src/line.vala"
					_tmp26_ = TRUE;
#line 86 "src/line.vala"
					while (TRUE) {
#line 595 "line.c"
						Buffer* _tmp28_;
						Buffer* _tmp29_;
						Buffer* _tmp30_;
#line 86 "src/line.vala"
						if (!_tmp26_) {
#line 601 "line.c"
							gsize _tmp27_;
#line 88 "src/line.vala"
							_tmp27_ = i;
#line 88 "src/line.vala"
							i = _tmp27_ + 1;
#line 607 "line.c"
						}
#line 86 "src/line.vala"
						_tmp26_ = FALSE;
#line 87 "src/line.vala"
						_tmp28_ = cur_bp;
#line 87 "src/line.vala"
						_tmp29_ = cur_bp;
#line 87 "src/line.vala"
						if (!(i < buffer_end_of_line (_tmp28_, buffer_line_o (_tmp29_)))) {
#line 87 "src/line.vala"
							break;
#line 619 "line.c"
						}
#line 89 "src/line.vala"
						_tmp30_ = cur_bp;
#line 89 "src/line.vala"
						if (g_ascii_isspace (buffer_get_char (_tmp30_, i - 1))) {
#line 625 "line.c"
							Buffer* _tmp31_;
#line 90 "src/line.vala"
							_tmp31_ = cur_bp;
#line 90 "src/line.vala"
							break_col = i - buffer_line_o (_tmp31_);
#line 91 "src/line.vala"
							break;
#line 633 "line.c"
						}
					}
				}
			}
		}
#line 94 "src/line.vala"
		if (break_col >= ((gsize) 1)) {
#line 641 "line.c"
			Buffer* _tmp32_;
			Buffer* _tmp33_;
			Buffer* _tmp34_;
			Marker* _tmp35_;
			gsize _tmp36_;
			gsize _tmp37_;
#line 96 "src/line.vala"
			_tmp32_ = cur_bp;
#line 96 "src/line.vala"
			_tmp33_ = cur_bp;
#line 96 "src/line.vala"
			buffer_goto_offset (_tmp32_, buffer_line_o (_tmp33_) + break_col);
#line 97 "src/line.vala"
			funcall ("delete-horizontal-space", NULL, NULL);
#line 98 "src/line.vala"
			insert_newline ();
#line 99 "src/line.vala"
			_tmp34_ = cur_bp;
#line 99 "src/line.vala"
			_tmp35_ = m;
#line 99 "src/line.vala"
			_tmp36_ = marker_get_o (_tmp35_);
#line 99 "src/line.vala"
			_tmp37_ = _tmp36_;
#line 99 "src/line.vala"
			buffer_goto_offset (_tmp34_, _tmp37_);
#line 100 "src/line.vala"
			break_made = TRUE;
#line 670 "line.c"
		} else {
			Buffer* _tmp38_;
			Buffer* _tmp39_;
#line 103 "src/line.vala"
			_tmp38_ = cur_bp;
#line 103 "src/line.vala"
			_tmp39_ = cur_bp;
#line 103 "src/line.vala"
			buffer_goto_offset (_tmp38_, buffer_line_o (_tmp39_) + old_col);
#line 680 "line.c"
		}
#line 105 "src/line.vala"
		_tmp40_ = m;
#line 105 "src/line.vala"
		marker_unchain (_tmp40_);
#line 64 "src/line.vala"
		_marker_unref0 (m);
#line 688 "line.c"
	}
#line 108 "src/line.vala"
	_tmp41_ = __bool_dup0 (&break_made);
#line 108 "src/line.vala"
	result = _tmp41_;
#line 108 "src/line.vala"
	_g_free0 (n);
#line 108 "src/line.vala"
	return result;
#line 698 "line.c"
}

gboolean
newline (void)
{
	gboolean ret = FALSE;
	Buffer* _tmp0_;
	gboolean _tmp3_ = FALSE;
	gboolean result = FALSE;
#line 112 "src/line.vala"
	ret = TRUE;
#line 113 "src/line.vala"
	_tmp0_ = cur_bp;
#line 113 "src/line.vala"
	if (_tmp0_->autofill) {
#line 714 "line.c"
		gboolean* _tmp1_;
		gboolean* _tmp2_;
#line 114 "src/line.vala"
		_tmp1_ = fill_break_line ();
#line 114 "src/line.vala"
		_tmp2_ = _tmp1_;
#line 114 "src/line.vala"
		ret = _tmp2_ != NULL;
#line 114 "src/line.vala"
		_g_free0 (_tmp2_);
#line 725 "line.c"
	}
#line 115 "src/line.vala"
	if (ret) {
#line 115 "src/line.vala"
		_tmp3_ = insert_newline ();
#line 731 "line.c"
	} else {
#line 115 "src/line.vala"
		_tmp3_ = FALSE;
#line 735 "line.c"
	}
#line 115 "src/line.vala"
	result = _tmp3_;
#line 115 "src/line.vala"
	return result;
#line 741 "line.c"
}

void
bprintf (const gchar* fmt,
         ...)
{
	gchar* s = NULL;
	va_list _tmp0_ = {0};
	gchar* _tmp1_;
	gchar* _tmp2_;
	Buffer* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	ImmutableEstr* _tmp6_;
	ImmutableEstr* _tmp7_;
#line 118 "src/line.vala"
	g_return_if_fail (fmt != NULL);
#line 119 "src/line.vala"
	va_start (_tmp0_, fmt);
#line 119 "src/line.vala"
	_tmp1_ = g_strdup_vprintf (fmt, _tmp0_);
#line 119 "src/line.vala"
	_tmp2_ = _tmp1_;
#line 119 "src/line.vala"
	va_end (_tmp0_);
#line 119 "src/line.vala"
	s = _tmp2_;
#line 120 "src/line.vala"
	_tmp3_ = cur_bp;
#line 120 "src/line.vala"
	_tmp4_ = strlen (s);
#line 120 "src/line.vala"
	_tmp5_ = _tmp4_;
#line 120 "src/line.vala"
	_tmp6_ = immutable_estr_of (s, (gsize) _tmp5_, IMMUTABLE_ESTR_eol_lf);
#line 120 "src/line.vala"
	_tmp7_ = _tmp6_;
#line 120 "src/line.vala"
	buffer_insert_estr (_tmp3_, _tmp7_);
#line 120 "src/line.vala"
	_immutable_estr_unref0 (_tmp7_);
#line 118 "src/line.vala"
	_g_free0 (s);
#line 785 "line.c"
}

/***********************************************************************
                         Indentation command
***********************************************************************/
void
previous_nonblank_goalc (void)
{
	gsize cur_goalc = 0UL;
	Buffer* _tmp0_;
#line 130 "src/line.vala"
	_tmp0_ = cur_bp;
#line 130 "src/line.vala"
	cur_goalc = _tmp0_->goalc;
#line 133 "src/line.vala"
	while (TRUE) {
#line 802 "line.c"
		gboolean _tmp1_ = FALSE;
		glong _tmp2_;
#line 133 "src/line.vala"
		_tmp2_ = (glong) -1;
#line 133 "src/line.vala"
		if (funcall ("forward-line", &_tmp2_, NULL)) {
#line 809 "line.c"
			Buffer* _tmp3_;
#line 133 "src/line.vala"
			_tmp3_ = cur_bp;
#line 133 "src/line.vala"
			_tmp1_ = buffer_is_blank_line (_tmp3_);
#line 815 "line.c"
		} else {
#line 133 "src/line.vala"
			_tmp1_ = FALSE;
#line 819 "line.c"
		}
#line 133 "src/line.vala"
		if (!_tmp1_) {
#line 133 "src/line.vala"
			break;
#line 825 "line.c"
		}
	}
#line 136 "src/line.vala"
	while (TRUE) {
#line 830 "line.c"
		gboolean _tmp4_ = FALSE;
		Buffer* _tmp5_;
		Buffer* _tmp7_;
#line 136 "src/line.vala"
		_tmp5_ = cur_bp;
#line 136 "src/line.vala"
		if (!buffer_eolp (_tmp5_)) {
#line 838 "line.c"
			Buffer* _tmp6_;
#line 136 "src/line.vala"
			_tmp6_ = cur_bp;
#line 136 "src/line.vala"
			_tmp4_ = _tmp6_->goalc < cur_goalc;
#line 844 "line.c"
		} else {
#line 136 "src/line.vala"
			_tmp4_ = FALSE;
#line 848 "line.c"
		}
#line 136 "src/line.vala"
		if (!_tmp4_) {
#line 136 "src/line.vala"
			break;
#line 854 "line.c"
		}
#line 137 "src/line.vala"
		_tmp7_ = cur_bp;
#line 137 "src/line.vala"
		buffer_move_char (_tmp7_, (glong) 1);
#line 860 "line.c"
	}
}

gboolean
insert_newline (void)
{
	Buffer* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	ImmutableEstr* _tmp3_;
	ImmutableEstr* _tmp4_;
	gboolean _tmp5_;
	gboolean result = FALSE;
#line 141 "src/line.vala"
	_tmp0_ = cur_bp;
#line 141 "src/line.vala"
	_tmp1_ = strlen ("\n");
#line 141 "src/line.vala"
	_tmp2_ = _tmp1_;
#line 141 "src/line.vala"
	_tmp3_ = immutable_estr_of ("\n", (gsize) _tmp2_, IMMUTABLE_ESTR_eol_lf);
#line 141 "src/line.vala"
	_tmp4_ = _tmp3_;
#line 141 "src/line.vala"
	_tmp5_ = buffer_insert_estr (_tmp0_, _tmp4_);
#line 141 "src/line.vala"
	_immutable_estr_unref0 (_tmp4_);
#line 141 "src/line.vala"
	result = _tmp5_;
#line 141 "src/line.vala"
	return result;
#line 892 "line.c"
}

gsize
previous_line_indent (void)
{
	gsize cur_indent = 0UL;
	Marker* m = NULL;
	Marker* _tmp0_;
	Buffer* _tmp5_;
	Buffer* _tmp6_;
	Marker* _tmp7_;
	gsize _tmp8_;
	gsize _tmp9_;
	Marker* _tmp10_;
	gsize result = 0UL;
#line 146 "src/line.vala"
	_tmp0_ = marker_point ();
#line 146 "src/line.vala"
	m = _tmp0_;
#line 148 "src/line.vala"
	funcall ("previous-line", NULL, NULL);
#line 149 "src/line.vala"
	funcall ("beginning-of-line", NULL, NULL);
#line 152 "src/line.vala"
	while (TRUE) {
#line 918 "line.c"
		gboolean _tmp1_ = FALSE;
		Buffer* _tmp2_;
		Buffer* _tmp4_;
#line 152 "src/line.vala"
		_tmp2_ = cur_bp;
#line 152 "src/line.vala"
		if (!buffer_eolp (_tmp2_)) {
#line 926 "line.c"
			Buffer* _tmp3_;
#line 152 "src/line.vala"
			_tmp3_ = cur_bp;
#line 152 "src/line.vala"
			_tmp1_ = g_ascii_isspace (buffer_following_char (_tmp3_));
#line 932 "line.c"
		} else {
#line 152 "src/line.vala"
			_tmp1_ = FALSE;
#line 936 "line.c"
		}
#line 152 "src/line.vala"
		if (!_tmp1_) {
#line 152 "src/line.vala"
			break;
#line 942 "line.c"
		}
#line 153 "src/line.vala"
		_tmp4_ = cur_bp;
#line 153 "src/line.vala"
		buffer_move_char (_tmp4_, (glong) 1);
#line 948 "line.c"
	}
#line 155 "src/line.vala"
	_tmp5_ = cur_bp;
#line 155 "src/line.vala"
	cur_indent = _tmp5_->goalc;
#line 158 "src/line.vala"
	_tmp6_ = cur_bp;
#line 158 "src/line.vala"
	_tmp7_ = m;
#line 158 "src/line.vala"
	_tmp8_ = marker_get_o (_tmp7_);
#line 158 "src/line.vala"
	_tmp9_ = _tmp8_;
#line 158 "src/line.vala"
	buffer_goto_offset (_tmp6_, _tmp9_);
#line 159 "src/line.vala"
	_tmp10_ = m;
#line 159 "src/line.vala"
	marker_unchain (_tmp10_);
#line 161 "src/line.vala"
	result = cur_indent;
#line 161 "src/line.vala"
	_marker_unref0 (m);
#line 161 "src/line.vala"
	return result;
#line 974 "line.c"
}

static gboolean
_insert_tab_movement_delegate (gpointer self)
{
	gboolean result;
	result = insert_tab ();
#line 169 "src/line.vala"
	return result;
#line 984 "line.c"
}

static gboolean
__lambda102_ (glong uniarg,
              GeeQueue* args)
{
	gboolean result = FALSE;
#line 169 "src/line.vala"
	result = execute_with_uniarg (uniarg, _insert_tab_movement_delegate, NULL, NULL, NULL);
#line 169 "src/line.vala"
	return result;
#line 996 "line.c"
}

static gboolean
___lambda102__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda102_ (uniarg, args);
#line 166 "src/line.vala"
	return result;
#line 1007 "line.c"
}

static gboolean
_newline_movement_delegate (gpointer self)
{
	gboolean result;
	result = newline ();
#line 179 "src/line.vala"
	return result;
#line 1017 "line.c"
}

static gboolean
__lambda103_ (glong uniarg,
              GeeQueue* args)
{
	gboolean result = FALSE;
#line 179 "src/line.vala"
	result = execute_with_uniarg (uniarg, _newline_movement_delegate, NULL, NULL, NULL);
#line 179 "src/line.vala"
	return result;
#line 1029 "line.c"
}

static gboolean
___lambda103__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda103_ (uniarg, args);
#line 176 "src/line.vala"
	return result;
#line 1040 "line.c"
}

static gboolean
_intercalate_newline_movement_delegate (gpointer self)
{
	gboolean result;
	result = intercalate_newline ();
#line 189 "src/line.vala"
	return result;
#line 1050 "line.c"
}

static gboolean
__lambda104_ (glong uniarg,
              GeeQueue* args)
{
	gboolean result = FALSE;
#line 189 "src/line.vala"
	result = execute_with_uniarg (uniarg, _intercalate_newline_movement_delegate, NULL, NULL, NULL);
#line 189 "src/line.vala"
	return result;
#line 1062 "line.c"
}

static gboolean
___lambda104__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda104_ (uniarg, args);
#line 186 "src/line.vala"
	return result;
#line 1073 "line.c"
}

static gboolean
__lambda105_ (glong uniarg,
              GeeQueue* args)
{
	gchar* arg = NULL;
	gpointer _tmp0_;
	const gchar* _tmp1_;
	gboolean result = FALSE;
#line 198 "src/line.vala"
	_tmp0_ = gee_queue_poll (args);
#line 198 "src/line.vala"
	arg = (gchar*) _tmp0_;
#line 199 "src/line.vala"
	_tmp1_ = arg;
#line 199 "src/line.vala"
	if (_tmp1_ != NULL) {
#line 1092 "line.c"
		const gchar* _tmp2_;
#line 200 "src/line.vala"
		_tmp2_ = arg;
#line 200 "src/line.vala"
		bprintf ("%s", _tmp2_, NULL);
#line 1098 "line.c"
	}
#line 201 "src/line.vala"
	result = FALSE;
#line 201 "src/line.vala"
	_g_free0 (arg);
#line 201 "src/line.vala"
	return result;
#line 1106 "line.c"
}

static gboolean
___lambda105__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda105_ (uniarg, args);
#line 195 "src/line.vala"
	return result;
#line 1117 "line.c"
}

static gboolean
_buffer_delete_char_movement_delegate (gpointer self)
{
	gboolean result;
	result = buffer_delete_char ((Buffer*) self);
#line 212 "src/line.vala"
	return result;
#line 1127 "line.c"
}

static gboolean
_buffer_backward_delete_char_movement_delegate (gpointer self)
{
	gboolean result;
	result = buffer_backward_delete_char ((Buffer*) self);
#line 212 "src/line.vala"
	return result;
#line 1137 "line.c"
}

static gboolean
__lambda106_ (glong uniarg,
              GeeQueue* args)
{
	glong n = 0L;
	Buffer* _tmp0_;
	Buffer* _tmp1_;
	gboolean result = FALSE;
#line 210 "src/line.vala"
	n = (glong) 1;
#line 211 "src/line.vala"
	int_or_uniarg (args, &n, uniarg);
#line 212 "src/line.vala"
	_tmp0_ = cur_bp;
#line 212 "src/line.vala"
	_tmp1_ = cur_bp;
#line 212 "src/line.vala"
	result = execute_with_uniarg (n, _buffer_delete_char_movement_delegate, _tmp0_, _buffer_backward_delete_char_movement_delegate, _tmp1_);
#line 212 "src/line.vala"
	return result;
#line 1160 "line.c"
}

static gboolean
___lambda106__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda106_ (uniarg, args);
#line 207 "src/line.vala"
	return result;
#line 1171 "line.c"
}

static gboolean
__lambda107_ (glong uniarg,
              GeeQueue* args)
{
	glong n = 0L;
	Buffer* _tmp0_;
	Buffer* _tmp1_;
	gboolean result = FALSE;
#line 221 "src/line.vala"
	n = (glong) 1;
#line 222 "src/line.vala"
	int_or_uniarg (args, &n, uniarg);
#line 223 "src/line.vala"
	_tmp0_ = cur_bp;
#line 223 "src/line.vala"
	_tmp1_ = cur_bp;
#line 223 "src/line.vala"
	result = execute_with_uniarg (n, _buffer_backward_delete_char_movement_delegate, _tmp0_, _buffer_delete_char_movement_delegate, _tmp1_);
#line 223 "src/line.vala"
	return result;
#line 1194 "line.c"
}

static gboolean
___lambda107__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda107_ (uniarg, args);
#line 218 "src/line.vala"
	return result;
#line 1205 "line.c"
}

static gboolean
__lambda108_ (glong uniarg,
              GeeQueue* args)
{
	gboolean result = FALSE;
#line 232 "src/line.vala"
	while (TRUE) {
#line 1215 "line.c"
		gboolean _tmp0_ = FALSE;
		Buffer* _tmp1_;
		Buffer* _tmp3_;
#line 232 "src/line.vala"
		_tmp1_ = cur_bp;
#line 232 "src/line.vala"
		if (!buffer_eolp (_tmp1_)) {
#line 1223 "line.c"
			Buffer* _tmp2_;
#line 232 "src/line.vala"
			_tmp2_ = cur_bp;
#line 232 "src/line.vala"
			_tmp0_ = g_ascii_isspace (buffer_following_char (_tmp2_));
#line 1229 "line.c"
		} else {
#line 232 "src/line.vala"
			_tmp0_ = FALSE;
#line 1233 "line.c"
		}
#line 232 "src/line.vala"
		if (!_tmp0_) {
#line 232 "src/line.vala"
			break;
#line 1239 "line.c"
		}
#line 233 "src/line.vala"
		_tmp3_ = cur_bp;
#line 233 "src/line.vala"
		buffer_delete_char (_tmp3_);
#line 1245 "line.c"
	}
#line 235 "src/line.vala"
	while (TRUE) {
#line 1249 "line.c"
		gboolean _tmp4_ = FALSE;
		Buffer* _tmp5_;
		Buffer* _tmp7_;
#line 235 "src/line.vala"
		_tmp5_ = cur_bp;
#line 235 "src/line.vala"
		if (!buffer_bolp (_tmp5_)) {
#line 1257 "line.c"
			Buffer* _tmp6_;
#line 235 "src/line.vala"
			_tmp6_ = cur_bp;
#line 235 "src/line.vala"
			_tmp4_ = g_ascii_isspace (buffer_preceding_char (_tmp6_));
#line 1263 "line.c"
		} else {
#line 235 "src/line.vala"
			_tmp4_ = FALSE;
#line 1267 "line.c"
		}
#line 235 "src/line.vala"
		if (!_tmp4_) {
#line 235 "src/line.vala"
			break;
#line 1273 "line.c"
		}
#line 236 "src/line.vala"
		_tmp7_ = cur_bp;
#line 236 "src/line.vala"
		buffer_backward_delete_char (_tmp7_);
#line 1279 "line.c"
	}
#line 238 "src/line.vala"
	result = TRUE;
#line 238 "src/line.vala"
	return result;
#line 1285 "line.c"
}

static gboolean
___lambda108__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda108_ (uniarg, args);
#line 229 "src/line.vala"
	return result;
#line 1296 "line.c"
}

static gboolean
__lambda109_ (glong uniarg,
              GeeQueue* args)
{
	Buffer* _tmp0_;
	gboolean result = FALSE;
#line 247 "src/line.vala"
	funcall ("delete-horizontal-space", NULL, NULL);
#line 248 "src/line.vala"
	_tmp0_ = cur_bp;
#line 248 "src/line.vala"
	buffer_insert_char (_tmp0_, ' ');
#line 249 "src/line.vala"
	result = TRUE;
#line 249 "src/line.vala"
	return result;
#line 1315 "line.c"
}

static gboolean
___lambda109__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda109_ (uniarg, args);
#line 244 "src/line.vala"
	return result;
#line 1326 "line.c"
}

static gboolean
__lambda110_ (glong uniarg,
              GeeQueue* args)
{
	gsize target_goalc = 0UL;
	gsize cur_goalc = 0UL;
	Buffer* _tmp0_;
	gsize t = 0UL;
	Buffer* _tmp1_;
	gboolean ok = FALSE;
	Buffer* _tmp2_;
	Buffer* _tmp3_;
	Buffer* _tmp4_;
	gboolean result = FALSE;
#line 258 "src/line.vala"
	target_goalc = (gsize) 0;
#line 258 "src/line.vala"
	_tmp0_ = cur_bp;
#line 258 "src/line.vala"
	cur_goalc = _tmp0_->goalc;
#line 259 "src/line.vala"
	_tmp1_ = cur_bp;
#line 259 "src/line.vala"
	t = buffer_tab_width (_tmp1_);
#line 261 "src/line.vala"
	ok = FALSE;
#line 263 "src/line.vala"
	_tmp2_ = cur_bp;
#line 263 "src/line.vala"
	if (buffer_warn_if_readonly (_tmp2_)) {
#line 264 "src/line.vala"
		result = FALSE;
#line 264 "src/line.vala"
		return result;
#line 1363 "line.c"
	}
#line 266 "src/line.vala"
	_tmp3_ = cur_bp;
#line 266 "src/line.vala"
	_tmp3_->mark_active = FALSE;
#line 269 "src/line.vala"
	_tmp4_ = cur_bp;
#line 269 "src/line.vala"
	if (buffer_line_o (_tmp4_) != ((gsize) 0)) {
#line 1373 "line.c"
		Marker* m = NULL;
		Marker* _tmp5_;
		gboolean _tmp6_ = FALSE;
		Buffer* _tmp7_;
		Buffer* _tmp17_;
		Buffer* _tmp19_;
		Marker* _tmp20_;
		gsize _tmp21_;
		gsize _tmp22_;
		Marker* _tmp23_;
#line 271 "src/line.vala"
		_tmp5_ = marker_point ();
#line 271 "src/line.vala"
		m = _tmp5_;
#line 273 "src/line.vala"
		previous_nonblank_goalc ();
#line 276 "src/line.vala"
		_tmp7_ = cur_bp;
#line 276 "src/line.vala"
		if (buffer_preceding_char (_tmp7_) == '\t') {
#line 1394 "line.c"
			Buffer* _tmp8_;
#line 276 "src/line.vala"
			_tmp8_ = cur_bp;
#line 276 "src/line.vala"
			_tmp6_ = _tmp8_->goalc > cur_goalc;
#line 1400 "line.c"
		} else {
#line 276 "src/line.vala"
			_tmp6_ = FALSE;
#line 1404 "line.c"
		}
#line 276 "src/line.vala"
		if (!_tmp6_) {
#line 277 "src/line.vala"
			while (TRUE) {
#line 1410 "line.c"
				gboolean _tmp9_ = FALSE;
				Buffer* _tmp10_;
				Buffer* _tmp12_;
#line 277 "src/line.vala"
				_tmp10_ = cur_bp;
#line 277 "src/line.vala"
				if (!buffer_eolp (_tmp10_)) {
#line 1418 "line.c"
					Buffer* _tmp11_;
#line 277 "src/line.vala"
					_tmp11_ = cur_bp;
#line 277 "src/line.vala"
					_tmp9_ = !g_ascii_isspace (buffer_following_char (_tmp11_));
#line 1424 "line.c"
				} else {
#line 277 "src/line.vala"
					_tmp9_ = FALSE;
#line 1428 "line.c"
				}
#line 277 "src/line.vala"
				if (!_tmp9_) {
#line 277 "src/line.vala"
					break;
#line 1434 "line.c"
				}
#line 278 "src/line.vala"
				_tmp12_ = cur_bp;
#line 278 "src/line.vala"
				buffer_move_char (_tmp12_, (glong) 1);
#line 1440 "line.c"
			}
		}
#line 281 "src/line.vala"
		while (TRUE) {
#line 1445 "line.c"
			gboolean _tmp13_ = FALSE;
			Buffer* _tmp14_;
			Buffer* _tmp16_;
#line 281 "src/line.vala"
			_tmp14_ = cur_bp;
#line 281 "src/line.vala"
			if (!buffer_eolp (_tmp14_)) {
#line 1453 "line.c"
				Buffer* _tmp15_;
#line 281 "src/line.vala"
				_tmp15_ = cur_bp;
#line 281 "src/line.vala"
				_tmp13_ = g_ascii_isspace (buffer_following_char (_tmp15_));
#line 1459 "line.c"
			} else {
#line 281 "src/line.vala"
				_tmp13_ = FALSE;
#line 1463 "line.c"
			}
#line 281 "src/line.vala"
			if (!_tmp13_) {
#line 281 "src/line.vala"
				break;
#line 1469 "line.c"
			}
#line 282 "src/line.vala"
			_tmp16_ = cur_bp;
#line 282 "src/line.vala"
			buffer_move_char (_tmp16_, (glong) 1);
#line 1475 "line.c"
		}
#line 285 "src/line.vala"
		_tmp17_ = cur_bp;
#line 285 "src/line.vala"
		if (!buffer_eolp (_tmp17_)) {
#line 1481 "line.c"
			Buffer* _tmp18_;
#line 286 "src/line.vala"
			_tmp18_ = cur_bp;
#line 286 "src/line.vala"
			target_goalc = _tmp18_->goalc;
#line 1487 "line.c"
		}
#line 288 "src/line.vala"
		_tmp19_ = cur_bp;
#line 288 "src/line.vala"
		_tmp20_ = m;
#line 288 "src/line.vala"
		_tmp21_ = marker_get_o (_tmp20_);
#line 288 "src/line.vala"
		_tmp22_ = _tmp21_;
#line 288 "src/line.vala"
		buffer_goto_offset (_tmp19_, _tmp22_);
#line 289 "src/line.vala"
		_tmp23_ = m;
#line 289 "src/line.vala"
		marker_unchain (_tmp23_);
#line 269 "src/line.vala"
		_marker_unref0 (m);
#line 1505 "line.c"
	}
#line 293 "src/line.vala"
	if (target_goalc > ((gsize) 0)) {
#line 1509 "line.c"
		Buffer* _tmp24_;
#line 296 "src/line.vala"
		_tmp24_ = cur_bp;
#line 296 "src/line.vala"
		if (_tmp24_->goalc < target_goalc) {
#line 1515 "line.c"
			{
				gboolean _tmp25_ = FALSE;
#line 297 "src/line.vala"
				_tmp25_ = TRUE;
#line 297 "src/line.vala"
				while (TRUE) {
#line 1522 "line.c"
					gboolean _tmp28_ = FALSE;
					Buffer* _tmp29_;
#line 297 "src/line.vala"
					if (!_tmp25_) {
#line 1527 "line.c"
						gboolean _tmp26_ = FALSE;
#line 302 "src/line.vala"
						if (ok) {
#line 1531 "line.c"
							Buffer* _tmp27_;
#line 302 "src/line.vala"
							_tmp27_ = cur_bp;
#line 302 "src/line.vala"
							_tmp26_ = _tmp27_->goalc < target_goalc;
#line 1537 "line.c"
						} else {
#line 302 "src/line.vala"
							_tmp26_ = FALSE;
#line 1541 "line.c"
						}
#line 302 "src/line.vala"
						if (!_tmp26_) {
#line 302 "src/line.vala"
							break;
#line 1547 "line.c"
						}
					}
#line 297 "src/line.vala"
					_tmp25_ = FALSE;
#line 298 "src/line.vala"
					_tmp29_ = cur_bp;
#line 298 "src/line.vala"
					if ((_tmp29_->goalc % t) == ((gsize) 0)) {
#line 1556 "line.c"
						Buffer* _tmp30_;
#line 298 "src/line.vala"
						_tmp30_ = cur_bp;
#line 298 "src/line.vala"
						_tmp28_ = (_tmp30_->goalc + t) <= target_goalc;
#line 1562 "line.c"
					} else {
#line 298 "src/line.vala"
						_tmp28_ = FALSE;
#line 1566 "line.c"
					}
#line 298 "src/line.vala"
					if (_tmp28_) {
#line 299 "src/line.vala"
						ok = insert_tab ();
#line 1572 "line.c"
					} else {
						Buffer* _tmp31_;
#line 301 "src/line.vala"
						_tmp31_ = cur_bp;
#line 301 "src/line.vala"
						ok = buffer_insert_char (_tmp31_, ' ');
#line 1579 "line.c"
					}
				}
			}
		} else {
#line 304 "src/line.vala"
			ok = insert_tab ();
#line 1586 "line.c"
		}
	} else {
#line 306 "src/line.vala"
		ok = insert_tab ();
#line 1591 "line.c"
	}
#line 307 "src/line.vala"
	result = ok;
#line 307 "src/line.vala"
	return result;
#line 1597 "line.c"
}

static gboolean
___lambda110__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda110_ (uniarg, args);
#line 255 "src/line.vala"
	return result;
#line 1608 "line.c"
}

static gboolean
__lambda111_ (glong uniarg,
              GeeQueue* args)
{
	gboolean result = FALSE;
#line 323 "src/line.vala"
	if (get_variable_bool ("tab-always-indent")) {
#line 324 "src/line.vala"
		result = insert_tab ();
#line 324 "src/line.vala"
		return result;
#line 1622 "line.c"
	} else {
		Buffer* _tmp0_;
#line 325 "src/line.vala"
		_tmp0_ = cur_bp;
#line 325 "src/line.vala"
		if (_tmp0_->goalc < previous_line_indent ()) {
#line 326 "src/line.vala"
			result = funcall ("indent-relative", NULL, NULL);
#line 326 "src/line.vala"
			return result;
#line 1633 "line.c"
		}
	}
#line 327 "src/line.vala"
	result = TRUE;
#line 327 "src/line.vala"
	return result;
#line 1640 "line.c"
}

static gboolean
___lambda111__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda111_ (uniarg, args);
#line 320 "src/line.vala"
	return result;
#line 1651 "line.c"
}

static gboolean
__lambda112_ (glong uniarg,
              GeeQueue* args)
{
	gboolean ok = FALSE;
	Buffer* _tmp0_;
	Buffer* _tmp1_;
	gboolean result = FALSE;
#line 339 "src/line.vala"
	ok = FALSE;
#line 341 "src/line.vala"
	_tmp0_ = cur_bp;
#line 341 "src/line.vala"
	if (buffer_warn_if_readonly (_tmp0_)) {
#line 342 "src/line.vala"
		result = FALSE;
#line 342 "src/line.vala"
		return result;
#line 1672 "line.c"
	}
#line 344 "src/line.vala"
	_tmp1_ = cur_bp;
#line 344 "src/line.vala"
	_tmp1_->mark_active = FALSE;
#line 346 "src/line.vala"
	if (insert_newline ()) {
#line 1680 "line.c"
		Marker* m = NULL;
		Marker* _tmp2_;
		gsize pos = 0UL;
		Buffer* _tmp3_;
		gboolean _tmp4_ = FALSE;
		gboolean indent = FALSE;
		Buffer* _tmp8_;
		Marker* _tmp9_;
		gsize _tmp10_;
		gsize _tmp11_;
		Marker* _tmp12_;
#line 347 "src/line.vala"
		_tmp2_ = marker_point ();
#line 347 "src/line.vala"
		m = _tmp2_;
#line 350 "src/line.vala"
		previous_nonblank_goalc ();
#line 351 "src/line.vala"
		_tmp3_ = cur_bp;
#line 351 "src/line.vala"
		pos = _tmp3_->goalc;
#line 352 "src/line.vala"
		if (pos > ((gsize) 0)) {
#line 352 "src/line.vala"
			_tmp4_ = TRUE;
#line 1706 "line.c"
		} else {
			gboolean _tmp5_ = FALSE;
			Buffer* _tmp6_;
#line 352 "src/line.vala"
			_tmp6_ = cur_bp;
#line 352 "src/line.vala"
			if (!buffer_eolp (_tmp6_)) {
#line 1714 "line.c"
				Buffer* _tmp7_;
#line 352 "src/line.vala"
				_tmp7_ = cur_bp;
#line 352 "src/line.vala"
				_tmp5_ = g_ascii_isspace (buffer_following_char (_tmp7_));
#line 1720 "line.c"
			} else {
#line 352 "src/line.vala"
				_tmp5_ = FALSE;
#line 1724 "line.c"
			}
#line 352 "src/line.vala"
			_tmp4_ = _tmp5_;
#line 1728 "line.c"
		}
#line 352 "src/line.vala"
		indent = _tmp4_;
#line 353 "src/line.vala"
		_tmp8_ = cur_bp;
#line 353 "src/line.vala"
		_tmp9_ = m;
#line 353 "src/line.vala"
		_tmp10_ = marker_get_o (_tmp9_);
#line 353 "src/line.vala"
		_tmp11_ = _tmp10_;
#line 353 "src/line.vala"
		buffer_goto_offset (_tmp8_, _tmp11_);
#line 354 "src/line.vala"
		_tmp12_ = m;
#line 354 "src/line.vala"
		marker_unchain (_tmp12_);
#line 357 "src/line.vala"
		if (indent) {
#line 358 "src/line.vala"
			funcall ("indent-for-tab-command", NULL, NULL);
#line 1750 "line.c"
		}
#line 359 "src/line.vala"
		ok = TRUE;
#line 346 "src/line.vala"
		_marker_unref0 (m);
#line 1756 "line.c"
	}
#line 361 "src/line.vala"
	result = ok;
#line 361 "src/line.vala"
	return result;
#line 1762 "line.c"
}

static gboolean
___lambda112__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda112_ (uniarg, args);
#line 336 "src/line.vala"
	return result;
#line 1773 "line.c"
}

void
line_init (void)
{
	LispFunc* _tmp0_;
	LispFunc* _tmp1_;
	LispFunc* _tmp2_;
	LispFunc* _tmp3_;
	LispFunc* _tmp4_;
	LispFunc* _tmp5_;
	LispFunc* _tmp6_;
	LispFunc* _tmp7_;
	LispFunc* _tmp8_;
	LispFunc* _tmp9_;
	LispFunc* _tmp10_;
	LispFunc* _tmp11_;
	LispFunc* _tmp12_;
	LispFunc* _tmp13_;
	LispFunc* _tmp14_;
	LispFunc* _tmp15_;
	LispFunc* _tmp16_;
	LispFunc* _tmp17_;
	LispFunc* _tmp18_;
	LispFunc* _tmp19_;
	LispFunc* _tmp20_;
	LispFunc* _tmp21_;
#line 166 "src/line.vala"
	_tmp0_ = lisp_func_new ("tab-to-tab-stop", ___lambda102__function, TRUE, "Insert a tabulation at the current point position into the current\n" \
"buffer.");
#line 166 "src/line.vala"
	_tmp1_ = _tmp0_;
#line 166 "src/line.vala"
	_lisp_func_unref0 (_tmp1_);
#line 176 "src/line.vala"
	_tmp2_ = lisp_func_new ("newline", ___lambda103__function, TRUE, "Insert a newline at the current point position into\n" \
"the current buffer.");
#line 176 "src/line.vala"
	_tmp3_ = _tmp2_;
#line 176 "src/line.vala"
	_lisp_func_unref0 (_tmp3_);
#line 186 "src/line.vala"
	_tmp4_ = lisp_func_new ("open-line", ___lambda104__function, TRUE, "Insert a newline and leave point before it.");
#line 186 "src/line.vala"
	_tmp5_ = _tmp4_;
#line 186 "src/line.vala"
	_lisp_func_unref0 (_tmp5_);
#line 195 "src/line.vala"
	_tmp6_ = lisp_func_new ("insert", ___lambda105__function, FALSE, "Insert the argument at point.");
#line 195 "src/line.vala"
	_tmp7_ = _tmp6_;
#line 195 "src/line.vala"
	_lisp_func_unref0 (_tmp7_);
#line 207 "src/line.vala"
	_tmp8_ = lisp_func_new ("delete-char", ___lambda106__function, TRUE, "Delete the following N characters (previous if N is negative).");
#line 207 "src/line.vala"
	_tmp9_ = _tmp8_;
#line 207 "src/line.vala"
	_lisp_func_unref0 (_tmp9_);
#line 218 "src/line.vala"
	_tmp10_ = lisp_func_new ("backward-delete-char", ___lambda107__function, TRUE, "Delete the previous N characters (following if N is negative).");
#line 218 "src/line.vala"
	_tmp11_ = _tmp10_;
#line 218 "src/line.vala"
	_lisp_func_unref0 (_tmp11_);
#line 229 "src/line.vala"
	_tmp12_ = lisp_func_new ("delete-horizontal-space", ___lambda108__function, TRUE, "Delete all spaces and tabs around point.");
#line 229 "src/line.vala"
	_tmp13_ = _tmp12_;
#line 229 "src/line.vala"
	_lisp_func_unref0 (_tmp13_);
#line 244 "src/line.vala"
	_tmp14_ = lisp_func_new ("just-one-space", ___lambda109__function, TRUE, "Delete all spaces and tabs around point, leaving one space.");
#line 244 "src/line.vala"
	_tmp15_ = _tmp14_;
#line 244 "src/line.vala"
	_lisp_func_unref0 (_tmp15_);
#line 255 "src/line.vala"
	_tmp16_ = lisp_func_new ("indent-relative", ___lambda110__function, TRUE, "Space out to under next indent point in previous nonblank line.\n" \
"An indent point is a non-whitespace character following whitespace.\n" \
"The following line shows the indentation points in this line.\n" \
"    ^         ^    ^     ^   ^           ^      ^  ^    ^\n" \
"If the previous nonblank line has no indent points beyond the\n" \
"column point starts at, `tab-to-tab-stop' is done instead, unless\n" \
"this command is invoked with a numeric argument, in which case it\n" \
"does nothing.");
#line 255 "src/line.vala"
	_tmp17_ = _tmp16_;
#line 255 "src/line.vala"
	_lisp_func_unref0 (_tmp17_);
#line 320 "src/line.vala"
	_tmp18_ = lisp_func_new ("indent-for-tab-command", ___lambda111__function, TRUE, "Indent line or insert a tab.\n" \
"Depending on `tab-always-indent', either insert a tab or indent.\n" \
"If initial point was within line's indentation, position after\n" \
"the indentation.  Else stay at same point in text.");
#line 320 "src/line.vala"
	_tmp19_ = _tmp18_;
#line 320 "src/line.vala"
	_lisp_func_unref0 (_tmp19_);
#line 336 "src/line.vala"
	_tmp20_ = lisp_func_new ("newline-and-indent", ___lambda112__function, TRUE, "Insert a newline, then indent.\n" \
"Indentation is done using the `indent-for-tab-command' function.");
#line 336 "src/line.vala"
	_tmp21_ = _tmp20_;
#line 336 "src/line.vala"
	_lisp_func_unref0 (_tmp21_);
#line 1867 "line.c"
}

