# Solfege - free ear training software
# Copyright (C) 2007 Tom Cato Amundsen
# License is GPL, see file COPYING

import unittest
from mpd.parser import Clef, UnknownClefException, parse_to_score_object

class TestClef(unittest.TestCase):
    def test_constructor_ok(self):
        c = Clef("violin")
        self.assertEquals(c.m_octaviation, 0)
        self.assertEquals(c.m_name, "violin")
        c = Clef("violin_8")
        self.assertEquals(c.m_octaviation, -7)
    def test_constructor_unknown_clef(self):
        self.assertRaises(UnknownClefException, lambda : Clef("not a clefname"))
        self.assertRaises(UnknownClefException, lambda : Clef("violin _ 8"))
    def test_octaviation(self):
        self.assertEquals(Clef("violin").steps_to_ylinepos(0), 13)
        self.assertEquals(Clef("violin_8").steps_to_ylinepos(0), 13 - 7)
    def test_steps_to_ylinepos(self):
        for s, c, o, i in (
            ("violin", "violin", 0, 13),
            ("violin_8", "violin", -7, 13 - 7),
            ("violin_15", "violin", -14, 13 - 14),
            ("violin^8", "violin", 7, 13 + 7),
            ("violin^15", "violin", 14, 13 + 14),
            ):
            clef = Clef(s)
            self.assertEquals(clef.m_name, c)
            self.assertEquals(clef.m_octaviation, o)
            self.assertEquals(clef.steps_to_ylinepos(0), i)

class TestMpdParser(unittest.TestCase):
    """
    These tests does not check that the engraving is correct,
    but we at least know that the parser and engraver does not
    crash.
    """
    def test_rest(self):
        score = parse_to_score_object(r"\staff {r}")
        eng = score.get_engravers(20)
    def test_dotted_rest(self):
        score = parse_to_score_object(r"\staff {r.}")
        eng = score.get_engravers(20)
        score = parse_to_score_object(r"\staff {r..}")
        eng = score.get_engravers(20)


suite = unittest.makeSuite(TestClef)
suite.addTest(unittest.makeSuite(TestMpdParser))
