from __future__ import division

import pygtk
pygtk.require("2.0")
import gtk

import i18n
i18n.setup()

import gtk
import sys
import mpd
import mpd.musicdisplayer
import gu
import os
import lessonfile
import dataparser
import htmlwidget
import stock

app_version = "0.1.2"

class HelpWindow(gtk.Window):
    def __init__(self, parent):
        gtk.Window.__init__(self)
        self.set_title("GNU Solfege lesson file editor help")
        self.set_size_request(400, 400)
        self.g_parent = parent
        self.vbox = gtk.VBox()
        self.vbox.set_spacing(8)
        self.add(self.vbox)
        self.connect('delete_event', self.delete_cb)
        self.g_htmlwidget = htmlwidget.HtmlWidget(None, None)
        self.vbox.pack_start(self.g_htmlwidget)
        self.vbox.pack_start(gtk.HSeparator(), False)
        bbox = gtk.HButtonBox()
        bbox.set_border_width(8)
        self.vbox.pack_start(bbox, False)
        b = gtk.Button(stock=gtk.STOCK_CLOSE)
        b.connect('clicked', self.close_cb)
        bbox.pack_start(b)
        self.show_all()
        self.set_focus(b)
    def source(self, html):
        self.g_htmlwidget.source(html)
    def delete_cb(self, *v):
        self.g_parent.g_help_window = None
    def close_cb(self, w):
        self.g_parent.g_help_window = None
        self.destroy()


window_actions = [
    ('FileMenu', None, '_File'),
    ('NewLessonfile', gtk.STOCK_NEW, '_New', '<control>N', 'new file', 'file_new_cb'),
    ('Open', gtk.STOCK_OPEN, '_Open', '<control>O', 'Open lesson file', 'file_open_cb'),
    ('Save', gtk.STOCK_SAVE, '_Save', '<control>S', 'Save the lesson file', 'file_save_cb'),
    ('SaveAs', gtk.STOCK_SAVE_AS, 'Save _as', '', 'Save the lesson file with a new name', 'file_save_as_cb'),
    ('Quit', gtk.STOCK_QUIT, '_Quit', '<control>Q', 'Quit program', 'quit_cb'),
    ('HelpMenu', None, '_Help'),
    ('HelpHelp', gtk.STOCK_HELP, '_Help', '', '', 'help_cb'),
    ('HelpAbout', None, '_About', '', '', 'about_cb'),
]
lessonfile_actions = [
    ('GotoFirstQuestion', gtk.STOCK_GOTO_FIRST, '_Goto first', '<control>i', 'Go to the first question', 'goto_first_question_cb'),
    ('GoBackQuestion', gtk.STOCK_GO_BACK, '_Goto back', '<control>b', 'Go to the previous question', 'go_back_question_cb'),
    ('GoForwardQuestion', gtk.STOCK_GO_FORWARD, '_Goto forward', '<control>f', 'Go to the next question', 'go_forward_question_cb'),
    ('GotoLastQuestion', gtk.STOCK_GOTO_LAST, '_Goto last', '<control>a', 'Go to the last question', 'goto_last_question_cb'),
    ('NewQuestion', gtk.STOCK_ADD, '_New question', '<control>n', 'Add a new question', 'new_question_cb'),
    ('NoteheadCursor', stock.NOTEHEAD, 'Add noteheads', '', 'Select tool to add notehead', 'select_cursor_notehead_cb'),
    ('SharpCursor', stock.SHARP, 'Add accidental to tone', '', 'Select tool to add sharps to tones', 'select_cursor_sharp_cb'),
    ('DoubleSharpCursor', stock.DOUBLE_SHARP, 'Add accidental to tone', '', 'Select tool to add double-sharps to tones', 'select_cursor_2sharp_cb'),
    ('NaturalCursor', stock.NATURAL, 'Add accidental to tone', '', 'Select tool to remove any accidental from tones', 'select_cursor_natural_cb'),
    ('FlatCursor', stock.FLAT, 'Add accidental to tone', '', 'Select tool to add flats to tones', 'select_cursor_flat_cb'),
    ('DoubleFlatCursor', stock.DOUBLE_FLAT, 'Add accidental to tone', '', 'Select tool to add double-flats to tones', 'select_cursor_2flat_cb'),
    ('EraseCursor', stock.ERASE_TOOL, 'Delete', '', 'Select tool to erase tones', 'select_cursor_erase_cb'),
]
ui_string = """<ui>
  <menubar name='Menubar'>
    <menu action='FileMenu'>
      <menuitem action='NewLessonfile'/>
      <menuitem action='Open'/>
      <menuitem action='Save'/>
      <menuitem action='SaveAs'/>
      <separator/>
      <menuitem action='Quit'/>
    </menu>
    <menu action='HelpMenu'>
      <menuitem action='HelpHelp'/>
      <menuitem action='HelpAbout'/>
    </menu>
  </menubar>
  <toolbar name='Toolbar'>
    <toolitem action='GotoFirstQuestion'/>
    <toolitem action='GoBackQuestion'/>
    <toolitem action='GoForwardQuestion'/>
    <toolitem action='GotoLastQuestion'/>
    <toolitem action='NewQuestion'/>
    <separator/>
    <toolitem action='NoteheadCursor'/>
    <toolitem action='DoubleSharpCursor'/>
    <toolitem action='SharpCursor'/>
    <toolitem action='NaturalCursor'/>
    <toolitem action='FlatCursor'/>
    <toolitem action='DoubleFlatCursor'/>
    <toolitem action='EraseCursor'/>
  </toolbar>
</ui>"""
def fix_actions(actions, instance):
    "Helper function to map methods to an instance"
    retval = []
    
    for i in range(len(actions)):
        curr = actions[i]
        if len(curr) > 5:
            curr = list(curr)
            curr[5] = getattr(instance, curr[5])
            curr = tuple(curr)
            
        retval.append(curr)
    return retval

class EditorLessonfile(object):
    def __init__(self):
        self.m_filename = None
        self.m_changed = False
        self.header = lessonfile._Header({'content': ['chord']})
        self._idx = None
        self.m_questions = [dataparser.Question()]
        self.m_questions[-1]['music'] = lessonfile.Music("", "chord")
        self.m_questions[-1]['name'] = ""
        self._idx = 0


class MainWin(gtk.Window):
    def __init__(self, datadir):
        gtk.Window.__init__(self)
        self.icons = stock.IconFactory(self, datadir)
        self.connect('destroy', lambda w: gtk.main_quit())
        self.g_help_window = None
        # toplevel_vbox:
        #   -menubar
        #   -toolbar
        #   -notebook
        #   -statusbar
        self.toplevel_vbox = gtk.VBox()
        self.add(self.toplevel_vbox)
        self.create_menu_and_toolbar()
        self.g_notebook = gtk.Notebook()
        self.toplevel_vbox.pack_start(self.g_notebook)
        self.vbox = gtk.VBox()
        self.toplevel_vbox.pack_start(self.vbox)
        self.create_mainwin_ui()
        self.show_all()
    def create_mainwin_ui(self):
        qbox = gu.hig_dlg_vbox()
        self.g_notebook.append_page(qbox, gtk.Label(_("Questions")))
        gu.bLabel(qbox, "Enter new chord using the mouse", False, False)
        hbox = gu.bHBox(qbox, False, False)
        self.g_displayer = mpd.musicdisplayer.ChordEditor()
        self.g_displayer.connect('clicked', self.on_displayer_clicked)
        self.g_displayer.clear(2)
        gu.bLabel(hbox, "")
        hbox.pack_start(self.g_displayer, False)
        gu.bLabel(hbox, "")
        ##
        self.g_question_name = gtk.Entry()
        qbox.pack_start(gu.hig_label_widget("Question title:", self.g_question_name, None), False)
        self.g_navinfo = gtk.Label("")
        qbox.pack_start(self.g_navinfo, False)

        ##
        self.m_P = EditorLessonfile()
        cvbox = gtk.VBox()
        self.g_notebook.append_page(cvbox, gtk.Label(_("Lessonfile header")))
        ## Header section
        sizegroup = gtk.SizeGroup(gtk.SIZE_GROUP_HORIZONTAL)
        self.g_title = gtk.Entry()
        cvbox.pack_start(gu.hig_label_widget("File title:", self.g_title, 
                        sizegroup))
        self.g_content_chord = gtk.CheckButton("chord")
        self.g_content_chord_voicing = gtk.CheckButton("chord-voicing")
        self.g_content_idbyname = gtk.CheckButton("id-by-name")
        box = gtk.HBox()
        box.pack_start(self.g_content_chord)
        box.pack_start(self.g_content_chord_voicing)
        box.pack_start(self.g_content_idbyname)
        cvbox.pack_start(gu.hig_label_widget("Content:", box, sizegroup))
        self.g_random_transpose = gtk.Entry()
        cvbox.pack_start(gu.hig_label_widget("Random transpose:", 
            self.g_random_transpose, sizegroup))
        #
        #self.g_statusbar = gtk.Statusbar()
        #self.toplevel_vbox.pack_start(self.g_statusbar, False)
        self.update_appwin()
    def proceed_if_changed(self):
        if not self.m_P.m_changed:
            return True
        dialog = gtk.MessageDialog(self, gtk.DIALOG_MODAL, gtk.MESSAGE_QUESTION,
              gtk.BUTTONS_YES_NO, "You have unsaved data. Proceed anyway?")
        dialog.hide()
        if dialog.run() == gtk.RESPONSE_YES:
            dialog.destroy()
            return True
        dialog.destroy()
        return False
    def update_appwin(self):
        self.update_score()
        self.set_navinfo()
        self.g_title.set_text(self.m_P.header.title)
        self.g_random_transpose.set_text(str(self.m_P.header.random_transpose))
        self.g_content_chord.set_active("chord" in self.m_P.header.content)
        self.g_content_chord_voicing.set_active("chord-voicing" in self.m_P.header.content)
        self.g_content_idbyname.set_active("id-by-name" in self.m_P.header.content)
    def set_navinfo(self):
        if self.m_P.m_filename:
            self.set_title(self.m_P.m_filename)
        else:
            self.set_title("No file")
        if self.m_P._idx is None:
            self.g_navinfo.set_text("no question")
            #FIXME does this ever happen? Should it?
        else:
            self.g_navinfo.set_text("question %i of %i" % (self.m_P._idx + 1,
                    len(self.m_P.m_questions)))
            self.g_question_name.set_text(self.m_P.m_questions[self.m_P._idx]['name'])
    def load_file(self, filename):
        self.m_P = lessonfile.ChordLessonfile(filename, None)
        self.m_P.m_changed = False
        if self.m_P.m_questions:
            self.m_P._idx = 0#FIXME what if lesson file has no questions.
            self.set_navinfo()
        self.update_appwin()
    def file_open_cb(self, *v):
        if gtk_api == "2.0":
            dialog = gtk.FileSelection()
        else:
            dialog = gtk.FileChooserDialog("Open..", self,
                                       gtk.FILE_CHOOSER_ACTION_OPEN,
                                       (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,
                                        gtk.STOCK_OPEN, gtk.RESPONSE_OK))
            dialog.set_default_response(gtk.RESPONSE_OK)
            filter = gtk.FileFilter()
            filter.set_name("All files")
            filter.add_pattern("*")
            dialog.add_filter(filter)
        dialog.hide()
        if dialog.run() == gtk.RESPONSE_OK:
            filename = dialog.get_filename()
            try:
                self.load_file(filename)
            except Exception, e:
                dialog.destroy()
                m = gtk.MessageDialog(self, gtk.DIALOG_MODAL, gtk.MESSAGE_ERROR, gtk.BUTTONS_CLOSE,
                                      "Loading file '%s' failed: %s" % (filename, e))
                m.run()
                m.destroy()
            else:
                dialog.destroy()
        else:
            dialog.destroy()
    def file_new_cb(self, action, v=None):
        if self.proceed_if_changed():
            self.m_P = EditorLessonfile()
            self.update_appwin()
    def file_save_as_cb(self, *v):
        self.store_data_from_ui()
        if gtk_api == "2.0":
            dialog = gtk.FileSelection()
        else:
            dialog = gtk.FileChooserDialog("Save as...", self,
                                      gtk.FILE_CHOOSER_ACTION_SAVE,
                                       (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,
                                        gtk.STOCK_SAVE, gtk.RESPONSE_OK))
            dialog.set_default_response(gtk.RESPONSE_OK)
            filter = gtk.FileFilter()
            filter.set_name("All files")
            filter.add_pattern("*")
            dialog.add_filter(filter)
        dialog.hide()

        if dialog.run() == gtk.RESPONSE_OK:
            self.m_P.m_filename = dialog.get_filename()
            self.save_file()
        dialog.destroy()
    def file_save_cb(self, *v):
        self.store_data_from_ui()
        if self.m_P.m_filename is None:
            if gtk_api == "2.0":
                dialog = gtk.FileSelection()
            else:
                dialog = gtk.FileChooserDialog("Save...", self,
                                       gtk.FILE_CHOOSER_ACTION_SAVE,
                                       (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,
                                        gtk.STOCK_SAVE, gtk.RESPONSE_OK))
                dialog.set_default_response(gtk.RESPONSE_OK)
                filter = gtk.FileFilter()
                filter.set_name("All files")
                filter.add_pattern("*")
                dialog.add_filter(filter)
            dialog.hide()

            if dialog.run() == gtk.RESPONSE_OK:
                self.m_P.m_filename = dialog.get_filename()
            dialog.destroy()
        if self.m_P.m_filename:
            self.update_appwin()
            self.save_file()
    def save_file(self):
        if not self.m_P.m_filename:
            raise "No filename. Cannot save."
        ofile = file(self.m_P.m_filename, 'w')
        ofile.write("# Creator: GNU Solfege lesson file editor %s\n\n"
                    % app_version)
        ofile.write("header {\n    content = %s\n" % ", ".join(self.m_P.header.content))
        if type(self.m_P.header.random_transpose) == list:
            ofile.write("    random_transpose = %s, %s, %s\n" % (self.m_P.header.random_transpose[0],
                            self.m_P.header.random_transpose[1], self.m_P.header.random_transpose[2]))
        else:
            ofile.write("    random_transpose = %s\n" % str(self.m_P.header.random_transpose))
        ofile.write('    title = "%s"\n}\n' % self.m_P.header.title)
        for q in self.m_P.m_questions:
            print >> ofile, 'question {'
            print >> ofile, '    name = "%s"' % q['name']
            print >> ofile, '    music = music("%s", chord)' % q['music'].m_musicdata
            print >> ofile, '}'
        ofile.close()
        self.m_P.m_changed = False

    def quit_cb(self, *v):
        if self.proceed_if_changed():
            gtk.main_quit()
    def help_cb(self, *v):
        if not self.g_help_window:
            self.g_help_window = HelpWindow(self)
            self.g_help_window.source("""<html>
<body>
<h2>GNU Solfege lesson file editor %s</h2>
<p>This is the very first unfinished release. Backup the files you
edit, since it can screw up.</p>
<p>The parser can create files for the chord exercise. It can parse more
advanced lesson files than it can write. So you might loose data if you
edit your hand written lesson files with this program.</p>
</body>
</html>
""" % app_version)
            self.g_help_window.show()
        else:
            print "nothing", self.g_help_window
    def about_cb(self, *v):
        dialog = gtk.MessageDialog(self, gtk.DIALOG_MODAL, gtk.MESSAGE_INFO,
            gtk.BUTTONS_CLOSE, "GNU Solfege lesson file editor %s\nCopyright (C) 2004 Tom Cato Amundsen <tca@gnu.org>" % app_version)
        dialog.run()
        dialog.destroy()
    def goto_first_question_cb(self, *v):
        self.store_data_from_ui()
        self.m_P._idx = 0
        self.update_appwin()
    def go_back_question_cb(self, *v):
        self.store_data_from_ui()
        self.m_P._idx = max(0, self.m_P._idx - 1)
        self.update_appwin()
    def go_forward_question_cb(self, *v):
        self.store_data_from_ui()
        self.m_P._idx = min(self.m_P._idx + 1, len(self.m_P.m_questions) - 1)
        self.update_appwin()
    def goto_last_question_cb(self, *v):
        self.store_data_from_ui()
        self.m_P._idx = len(self.m_P.m_questions) - 1
        self.update_appwin()
    def new_question_cb(self, *v):
        self.store_data_from_ui()
        self.m_P.m_questions.append(dataparser.Question())
        self.m_P.m_questions[-1]['music'] = lessonfile.Music("", "chord")
        self.m_P.m_questions[-1]['name'] = ""
        self.m_P._idx = len(self.m_P.m_questions) - 1
        self.update_appwin()
    def select_cursor_2flat_cb(self, *v):
        self.g_displayer.set_cursor("-2")
    def select_cursor_flat_cb(self, *v):
        self.g_displayer.set_cursor(-1)
    def select_cursor_natural_cb(self, *v):
        self.g_displayer.set_cursor(0)
    def select_cursor_sharp_cb(self, *v):
        self.g_displayer.set_cursor("1")
    def select_cursor_2sharp_cb(self, *v):
        self.g_displayer.set_cursor("2")
    def select_cursor_erase_cb(self, *v):
        self.g_displayer.set_cursor("erase")
    def select_cursor_notehead_cb(self, *v):
        self.g_displayer.set_cursor("notehead")
    def update_score(self):
        """
        Set m_chord_tones based on the data in the lesson file.
        Then call g_displayer.display to show the music.
        """
        assert self.m_P
        if self.m_P._idx is None:
            return
        self.m_chord_tones = {}
        for n in self.m_P.m_questions[self.m_P._idx]['music'].m_musicdata.split():
            p = mpd.MusicalPitch.new_from_notename(n)
            self.m_chord_tones[p.steps()] = p
        #
        if self.m_chord_tones:
            s = ""
            for n in self.m_chord_tones.values():
                s += " " + n.get_octave_notename()
            self.g_displayer.display("\staff{ < %s >}\staff{\clef bass}" % s, "20-tight")
        else:
            self.g_displayer.display("\staff{ }\staff{\clef bass}", "20-tight")
        self.g_displayer.set_size_request(200, -1)
    def store_data_from_ui(self):
        self.m_P.m_questions[self.m_P._idx]['name'] = self.g_question_name.get_text()
        self.m_P.header.title = self.g_title.get_text()
        self.m_P.header.random_transpose = eval(self.g_random_transpose.get_text())
        self.m_P.header.content = []
        if self.g_content_chord.get_active():
            self.m_P.header.content.append('chord')
        if self.g_content_chord_voicing.get_active():
            self.m_P.header.content.append('chord-voicing')
        if self.g_content_idbyname.get_active():
            self.m_P.header.content.append('id-by-name')
    def on_displayer_clicked(self, ed, steps):
        self.m_P.m_changed = True
        notename = ("c", "d", "e", "f", "g", "a", "b")[6-(steps % 7)]
        n = mpd.MusicalPitch.new_from_notename(notename)
        n.m_octave_i = 1-(steps // 7)
        if self.g_displayer.m_cursor == 'notehead':
            if n.steps() not in self.m_chord_tones:
                self.m_chord_tones[n.steps()] = n
        elif self.g_displayer.m_cursor == 'erase':
            if n.steps() in self.m_chord_tones:
                del self.m_chord_tones[n.steps()]
        else:
            if n.steps() not in self.m_chord_tones:
                return
            else:
                self.m_chord_tones[n.steps()].m_accidental_i = int(self.g_displayer.m_cursor)
        v = self.m_chord_tones.values()
        v.sort()
        v = [y.get_octave_notename() for y in v]
        self.m_P.m_questions[self.m_P._idx]['music'].m_musicdata = " ".join(v)
        self.update_score()

class ItemFactoryMainWin(MainWin):
    def __init__(self, datadir):
        MainWin.__init__(self, datadir)
    def create_menu_and_toolbar(self):
        ag = gtk.AccelGroup()
        self.add_accel_group(ag)
        menubar = gtk.MenuBar()
        i = gtk.MenuItem(_("_File"))
        menubar.append(i)
        menu = gtk.Menu()
        i.set_submenu(menu)
        i = gu.create_stock_menu_item("gtk-new", _("_New"), self.file_new_cb, ag, gtk.keysyms.N, gtk.gdk.CONTROL_MASK)
        menu.append(i)
        i = gu.create_stock_menu_item("gtk-open", _("_Open"), self.file_open_cb, ag, gtk.keysyms.O, gtk.gdk.CONTROL_MASK)
        menu.append(i)
        i = gu.create_stock_menu_item("gtk-save", _("_Save"), self.file_save_cb, ag, gtk.keysyms.S, gtk.gdk.CONTROL_MASK)
        menu.append(i)
        i = gu.create_stock_menu_item("gtk-save-as", _("Save _as"), self.file_save_as_cb, ag, 0, 0)
        menu.append(i)
        i = gtk.SeparatorMenuItem()
        menu.append(i)
        i = gu.create_stock_menu_item("gtk-quit", _("_Quit"), self.quit_cb, ag, gtk.keysyms.Q, gtk.gdk.CONTROL_MASK)
        menu.append(i)
        ##
        i = gtk.MenuItem(_("_Help"))
        menubar.append(i)
        menu = gtk.Menu()
        i.set_submenu(menu)
        i = gu.create_stock_menu_item("gtk-help", _("_Help"), self.help_cb, ag, 0, 0)
        menu.append(i)
        i = gu.create_stock_menu_item("gtk-about", _("_About"), self.about_cb, ag, 0, 0)
        menu.append(i)
        self.toplevel_vbox.pack_start(menubar, False)
        ##
        self.g_toolbar = gtk.Toolbar()
        self.g_toolbar.set_style(gtk.TOOLBAR_ICONS)
        self.g_toolbar.insert_stock('gtk-goto-first', 'Go to the first question', None, self.goto_first_question_cb, 0, 2)
        self.g_toolbar.insert_stock('gtk-go-back', 'Go to the previous question', None, self.go_back_question_cb, 0, 3)
        self.g_toolbar.insert_stock('gtk-go-forward', 'Go to the next question', None, self.go_forward_question_cb, 0, 4)
        self.g_toolbar.insert_stock('gtk-goto-last', 'Go to the last question', None, self.goto_last_question_cb, 0, 5)
        self.g_toolbar.insert_stock('gtk-add', 'Add a new question', None, self.new_question_cb, 0, 6)
        self.g_toolbar.append_item('', 'Select tool to add notehead', '',
            gtk.image_new_from_stock(stock.NOTEHEAD, gtk.ICON_SIZE_SMALL_TOOLBAR),
            self.select_cursor_notehead_cb, None)
        self.g_toolbar.append_item('', 'Select tool to add sharps to tones', '',
            gtk.image_new_from_stock(stock.SHARP, gtk.ICON_SIZE_SMALL_TOOLBAR),
            self.select_cursor_sharp_cb, None)
        self.g_toolbar.append_item('', 'Select tool to add double-sharps to tones', '',
            gtk.image_new_from_stock(stock.DOUBLE_SHARP, gtk.ICON_SIZE_SMALL_TOOLBAR),
            self.select_cursor_2sharp_cb, None)
        self.g_toolbar.append_item('', 'Select tool to remove any accidentals from tones',
            '', gtk.image_new_from_stock(stock.NATURAL, gtk.ICON_SIZE_SMALL_TOOLBAR),
            self.select_cursor_natural_cb, None)
        self.g_toolbar.append_item('', 'Select tool to add flats to tones', '', 
            gtk.image_new_from_stock(stock.FLAT, gtk.ICON_SIZE_SMALL_TOOLBAR),
            self.select_cursor_flat_cb, None)
        self.g_toolbar.append_item('', 'Select tool to add double-flats to tones', '',
            gtk.image_new_from_stock(stock.DOUBLE_FLAT, gtk.ICON_SIZE_SMALL_TOOLBAR),
            self.select_cursor_2flat_cb, None)
        self.g_toolbar.append_item('', 'Select tol to erase tones', '',
            gtk.image_new_from_stock(stock.ERASE_TOOL, gtk.ICON_SIZE_SMALL_TOOLBAR),
            self.select_cursor_erase_cb, None)
        self.toplevel_vbox.pack_start(self.g_toolbar, False)

class UIManagerMainWin(MainWin):
    def __init__(self, datadir):
        MainWin.__init__(self, datadir)
    def create_menu_and_toolbar(self):
        self.window_ag = gtk.ActionGroup('WindowActions')
        self.lessonfile_ag = gtk.ActionGroup('LessonfileActions')

        self.window_ag.add_actions(fix_actions(window_actions, self))
        self.lessonfile_ag.add_actions(fix_actions(lessonfile_actions, self))
        self.ui = gtk.UIManager()
        self.ui.insert_action_group(self.window_ag, 0)
        self.ui.insert_action_group(self.lessonfile_ag, 1)
        self.ui.add_ui_from_string(ui_string)
        self.add_accel_group(self.ui.get_accel_group())
        self.toplevel_vbox.pack_start(self.ui.get_widget('/Menubar'), False)
        self.ui.get_widget('/Toolbar').set_style(gtk.TOOLBAR_ICONS)
        self.toplevel_vbox.pack_start(self.ui.get_widget('/Toolbar'), False)

def main(datadir):
        global gtk_api
        mpd.engravers.fetadir = os.path.join(datadir, "feta")
        if gtk.pygtk_version < (2, 2, 96):
            gtk_api = "2.0"
        else:
            gtk_api = "2.4"
        if len(sys.argv) > 1 and sys.argv[1] == '--old':
            gtk_api = "2.0"
            del sys.argv[1]

        if gtk_api == "2.0":
            w = ItemFactoryMainWin(datadir)
        else:
            w = UIManagerMainWin(datadir)
            #FIXME
        if len(sys.argv) == 2:
            w.load_file(sys.argv[1])
        w.show()
        gtk.main()
