# GNU Solfege - ear training for GNOME
# Copyright (C) 2000, 2001, 2002, 2003, 2004  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# In addition to be completely useless, the need to be updated
# after we started to use /dev/music. There is no need to take
# care of channels.

__exercise_data__ = {
    'exercise_name': 'intervals',
    'menu_path': '%s/%s' % (_("_Junk"), _("_Intervals")),
    #'icon': 'graphics/chord24.png',
    #'toolbar': 0,
    #'accel_key': gtk.keysyms.F2,
    #'accel_mods': 0,
}
import exercise_setup
exercise_setup.register_exercise(__exercise_data__)


import gtk, gnome
import gu, widgets
import mpd, soundcard
import abstract, const, random

# 0xfff = 100cent
# 0xfff/100 = 1 cent
def Xcalc_cent(x):
    return int(0xfff/100.0*x)

def calc_cent(pitch, cent):
    return pitch + cent / 100, Xcalc_cent(cent - cent / 100 * 100)

class Teacher(abstract.Teacher):
    m_intervals = {}
    m_channels = []
    exercise_data = __exercise_data__
    def play_fifth(self, type):
        self.play_interval(4, 68, 70, 2, 0) # notelen, patch, interval, centadj
    def play_interval(self, notelen, patch, interval, cent, melodic):
        ev = soundcard.Track()
        p, c = calc_cent(interval, cent)
        ev.set_patch(0, patch)
        ev.set_patch(1, patch)
        v = 70;
        ev.bender(0, 0)
        ev.bender(1, 0)
        print interval, p
        if melodic:
            ev.start_note(1, p, v) # notelen-delta, chn pitch, vel
            ev.notelen_time(4)
            ev.stop_note(1, p, v)
            ev.bender(1, c)
            ev.start_note(1, p+interval, v) # notelen-delta, chn pitch, vel
            ev.notelen_time(4)
            ev.stop_note(1, p+interval, v)
        else:
            ev.bender(1, c)
            ev.start_note(0, interval, v) # notelen-delta, chn pitch, vel
            ev.start_note(1, p, v) # notelen-delta, chn pitch, vel
            ev.notelen_time(4)
            ev.stop_note(0, interval, v)
            ev.stop_note(1, p, v)
        soundcard.play_track(ev)
    def toggle_interval(self, cent):
        if not self.m_intervals.has_key(cent):
            self.m_intervals[cent] = -1
        MAXCH = 10
        p, c = calc_cent(60, cent)
        print cent, p, c
        if self.m_intervals[cent] == -1:
            found = 0
            for ch in range(0, MAXCH):
                if not ch in self.m_intervals.values():
                    found = 1
                    break
            if not found:
                print "no more free channels"
                return
            soundcard.solfege_c_midi.seq_set_patch(soundcard.synth.m_devnum, ch, 68)
            soundcard.solfege_c_midi.seq_bender(soundcard.synth.m_devnum, ch, c)
            soundcard.solfege_c_midi.seq_start_note(soundcard.synth.m_devnum, ch, p, 90)
            soundcard.solfege_c_midi.seqbuf_dump()
            self.m_intervals[cent] = ch
        else:
            soundcard.solfege_c_midi.seq_stop_note(soundcard.synth.m_devnum, self.m_intervals[cent], p, 90)
            soundcard.solfege_c_midi.seqbuf_dump()
            self.m_intervals[cent] = -1


class Gui(abstract.Gui):
    def __init__(self, teacher, window):
        abstract.Gui.__init__(self, teacher, window, no_notebook=1)
        def f(box, label, cent, self=self):
            btn = gtk.ToggleButton(label)
            btn.connect('clicked', self.on_A)
            box.pack_start(btn)
            btn.set_data('cent', cent)
        box = gu.bHBox(self.practise_box)
        f(box, "300 minor third", 300)
        box = gu.bHBox(self.practise_box)
        f(box, _("tonika"), 0)
        f(box, "386 major third", 386)
        f(box, "400 major third", 400)
        f(box, "408 major third", 408)
        self.show_all()
    def on_A(self, btn):
        self.m_t.toggle_interval(btn.get_data('cent'))

