/* PSPPIRE - a graphical user interface for PSPP.
   Copyright (C) 2004, 2005, 2006  Free Software Foundation

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>. */

#include <config.h>
#include <gtk/gtk.h>
#include <glade/glade.h>

#include <ctype.h>

#include <gtksheet/gtksheet.h>

#include <gtksheet/gsheet-uniform-row.h>

#include "psppire-dict.h"
#include "psppire-data-store.h"
#include "helper.h"

#include <data/value-labels.h>
#include <data/case.h>
#include <data/data-in.h>

#include "data-sheet.h"


static gboolean
traverse_callback (GtkSheet * sheet,
		   gint row, gint col,
		   gint *new_row, gint *new_column
		   )
{
  gint case_count;
  gint n_vars;

  PsppireDataStore *data_store =
    PSPPIRE_DATA_STORE (gtk_sheet_get_model (sheet));


  g_assert (data_store);

  n_vars = psppire_dict_get_var_cnt (data_store->dict);

  if ( *new_column >= n_vars )
    return FALSE;

  case_count = psppire_case_file_get_case_count (data_store->case_file);

  if ( *new_row >= case_count )
    {
      gint i;

      for ( i = case_count ; i <= *new_row; ++i )
	psppire_data_store_insert_new_case (data_store, i);

      return TRUE;
    }

  return TRUE;
}

extern PsppireDataStore *the_data_store ;


/* Return the width that an  'M' character would occupy when typeset in WIDGET */
static guint
calc_m_width (GtkWidget *widget, const PangoFontDescription *font_desc)
{
  PangoRectangle rect;
  PangoLayout *layout ;
  PangoContext * context;

  context = gtk_widget_create_pango_context (widget);
  g_assert (context);
  layout = pango_layout_new (context);
  g_assert (layout);

  pango_layout_set_text (layout, "M", 1);

  pango_layout_set_font_description (layout, font_desc);

  pango_layout_get_extents (layout, NULL, &rect);

  g_object_unref (G_OBJECT (layout));
  g_object_unref (G_OBJECT (context));

  return PANGO_PIXELS (rect.width);
}



void
font_change_callback (GObject *obj, gpointer data)
{
  GtkWidget *sheet  = data;
  PsppireDataStore *ds = PSPPIRE_DATA_STORE (obj);

  ds->width_of_m = calc_m_width (sheet, ds->font_desc);
}



G_MODULE_EXPORT GtkWidget*
psppire_data_sheet_create (gchar *widget_name, gchar *string1, gchar *string2,
			   gint int1, gint int2)
{
  GtkWidget *sheet;

  sheet = gtk_sheet_new (G_SHEET_ROW (the_data_store),
			G_SHEET_COLUMN (the_data_store), "data sheet", 0);

  the_data_store->width_of_m = calc_m_width (sheet, the_data_store->font_desc);

  g_signal_connect (G_OBJECT (sheet), "traverse",
		    G_CALLBACK (traverse_callback), 0);


  g_signal_connect (G_OBJECT (the_data_store), "font-changed",
		    G_CALLBACK (font_change_callback), sheet);

  gtk_sheet_set_active_cell (GTK_SHEET (sheet), -1, -1);

  gtk_sheet_set_model (GTK_SHEET (sheet), G_SHEET_MODEL (the_data_store));

  gtk_sheet_set_autoscroll (GTK_SHEET (sheet), TRUE);

  gtk_widget_show (sheet);

  return sheet;
}
