/*
  File autogenerated by gengetopt version 2.11
  generated with the following command:
  gengetopt --input gsasl.ggo --file-name gsasl_cmd 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "getopt.h"

#include "gsasl_cmd.h"

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", CMDLINE_PARSER_PACKAGE, CMDLINE_PARSER_VERSION);
}

void
cmdline_parser_print_help (void)
{
  cmdline_parser_print_version ();
  printf("\n"
  "Purpose:\n"
  "  Authenticate user to a server using Simple Authentication and\n"
  "  Security Layer.  Currently only IMAP servers are supported.  This is a\n"
  "  command line interface for the GNU SASL library.\n"
  "\n"
  "Usage: %s [OPTIONS]...\n", CMDLINE_PARSER_PACKAGE);
  printf("\n");
  printf("  -h, --help                          Print help and exit\n");
  printf("  -V, --version                       Print version and exit\n");
  printf("  -c, --client                        Act as client.  (default=off)\n");
  printf("  -s, --server                        Act as server.  (default=off)\n");
  printf("      --client-mechanisms             Write name of supported client \n                                        mechanisms separated by space to \n                                        stdout.  (default=off)\n");
  printf("      --server-mechanisms             Write name of supported server \n                                        mechanisms separated by space to \n                                        stdout.  (default=off)\n");
  printf("      --connect=STRING                Connect to TCP server and negotiate on \n                                        stream instead of stdin/stdout. \n                                        SERVICE is the protocol service, or an \n                                        integer denoting the port, and \n                                        defaults to 143 (imap) if not \n                                        specified. Also sets the --hostname \n                                        default.\n");
  printf("  -d, --application-data              After authentication, read data from \n                                        stdin and run it through the \n                                        mechanism's security layer and print \n                                        it base64 encoded to stdout. The \n                                        default is to terminate after \n                                        authentication.  (default=off)\n");
  printf("      --imap                          Use a IMAP-like logon procedure (client \n                                        only). Also sets the --service default \n                                        to 'imap'.  (default=off)\n");
  printf("      --smtp                          Use a SMTP-like logon procedure (client \n                                        only). Also sets the --service default \n                                        to 'smtp'.  (default=off)\n");
  printf("  -m, --mechanism=STRING              Mechanism to use.\n");
  printf("      --no-client-first               Disallow client to send data first \n                                        (client only).  (default=off)\n");
  printf("  -n, --anonymous-token=STRING        Token for anonymous authentication, \n                                        usually mail address (ANONYMOUS only).\n");
  printf("  -a, --authentication-id=STRING      Identity of credential owner.\n");
  printf("  -z, --authorization-id=STRING       Identity to request service for.\n");
  printf("  -p, --password=STRING               Password for authentication (insecure \n                                        for non-testing purposes).\n");
  printf("  -r, --realm=STRING                  Realm (may be given more than once iff \n                                        server). Defaults to hostname.\n");
  printf("  -x, --maxbuf=INT                    Indicate maximum buffer size (DIGEST-MD5 \n                                        only).\n");
  printf("      --passcode=STRING               Passcode for authentication (SECURID \n                                        only).\n");
  printf("      --service=STRING                Set the requested service name (should \n                                        be a registered GSSAPI host based \n                                        service name).\n");
  printf("      --hostname=STRING               Set the name of the server with the \n                                        requested service.\n");
  printf("      --service-name=STRING           Set the generic server name in case of a \n                                        replicated server (DIGEST-MD5 only).\n");
  printf("      --enable-cram-md5-validate      Validate CRAM-MD5 challenge and response \n                                        interactively.  (default=off)\n");
  printf("      --disable-cleartext-validate    Disable cleartext validate hook, forcing \n                                        server to prompt for password.  \n                                        (default=off)\n");
  printf("      --quality-of-protection=STRING  How application payload will be \n                                        protected.  'auth' means no \n                                        protection, 'auth-int' means integrity \n                                        protection, 'auth-conf' means \n                                        integrity and confidentialiy \n                                        protection.  Currently only used by \n                                        DIGEST-MD5, where the default is \n                                        'auth-conf'.\n");
  printf("      --verbose                       Produce verbose output.  (default=off)\n");
  printf("      --quiet                         Don't produce any diagnostic output.  \n                                        (default=off)\n");
}


static char *gengetopt_strdup (const char *s);

/* gengetopt_strdup() */
/* strdup.c replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  int c;	/* Character of the parsed option.  */
  int i;        /* Counter */
  struct realm_list
  {
    char * realm_arg;
    struct realm_list * next;
  };
  struct realm_list * realm_list = NULL,* realm_new = NULL;
  
  int missing_required_options = 0;

  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->client_given = 0 ;
  args_info->server_given = 0 ;
  args_info->client_mechanisms_given = 0 ;
  args_info->server_mechanisms_given = 0 ;
  args_info->connect_given = 0 ;
  args_info->application_data_given = 0 ;
  args_info->imap_given = 0 ;
  args_info->smtp_given = 0 ;
  args_info->mechanism_given = 0 ;
  args_info->no_client_first_given = 0 ;
  args_info->anonymous_token_given = 0 ;
  args_info->authentication_id_given = 0 ;
  args_info->authorization_id_given = 0 ;
  args_info->password_given = 0 ;
  args_info->realm_given = 0 ;
  args_info->maxbuf_given = 0 ;
  args_info->passcode_given = 0 ;
  args_info->service_given = 0 ;
  args_info->hostname_given = 0 ;
  args_info->service_name_given = 0 ;
  args_info->enable_cram_md5_validate_given = 0 ;
  args_info->disable_cleartext_validate_given = 0 ;
  args_info->quality_of_protection_given = 0 ;
  args_info->verbose_given = 0 ;
  args_info->quiet_given = 0 ;
#define clear_args() { \
  args_info->client_flag = 0;\
  args_info->server_flag = 0;\
  args_info->client_mechanisms_flag = 0;\
  args_info->server_mechanisms_flag = 0;\
  args_info->connect_arg = NULL; \
  args_info->application_data_flag = 0;\
  args_info->imap_flag = 0;\
  args_info->smtp_flag = 0;\
  args_info->mechanism_arg = NULL; \
  args_info->no_client_first_flag = 0;\
  args_info->anonymous_token_arg = NULL; \
  args_info->authentication_id_arg = NULL; \
  args_info->authorization_id_arg = NULL; \
  args_info->password_arg = NULL; \
  args_info->realm_arg = NULL; \
  args_info->passcode_arg = NULL; \
  args_info->service_arg = NULL; \
  args_info->hostname_arg = NULL; \
  args_info->service_name_arg = NULL; \
  args_info->enable_cram_md5_validate_flag = 0;\
  args_info->disable_cleartext_validate_flag = 0;\
  args_info->quality_of_protection_arg = NULL; \
  args_info->verbose_flag = 0;\
  args_info->quiet_flag = 0;\
}

  clear_args();

  optarg = 0;
  optind = 1;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      char *stop_char;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "client",	0, NULL, 'c' },
        { "server",	0, NULL, 's' },
        { "client-mechanisms",	0, NULL, 0 },
        { "server-mechanisms",	0, NULL, 0 },
        { "connect",	1, NULL, 0 },
        { "application-data",	0, NULL, 'd' },
        { "imap",	0, NULL, 0 },
        { "smtp",	0, NULL, 0 },
        { "mechanism",	1, NULL, 'm' },
        { "no-client-first",	0, NULL, 0 },
        { "anonymous-token",	1, NULL, 'n' },
        { "authentication-id",	1, NULL, 'a' },
        { "authorization-id",	1, NULL, 'z' },
        { "password",	1, NULL, 'p' },
        { "realm",	1, NULL, 'r' },
        { "maxbuf",	1, NULL, 'x' },
        { "passcode",	1, NULL, 0 },
        { "service",	1, NULL, 0 },
        { "hostname",	1, NULL, 0 },
        { "service-name",	1, NULL, 0 },
        { "enable-cram-md5-validate",	0, NULL, 0 },
        { "disable-cleartext-validate",	0, NULL, 0 },
        { "quality-of-protection",	1, NULL, 0 },
        { "verbose",	0, NULL, 0 },
        { "quiet",	0, NULL, 0 },
        { NULL,	0, NULL, 0 }
      };

      stop_char = 0;
      c = getopt_long (argc, argv, "hVcsdm:n:a:z:p:r:x:", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          clear_args ();
          cmdline_parser_print_help ();
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          clear_args ();
          cmdline_parser_print_version ();
          exit (EXIT_SUCCESS);

        case 'c':	/* Act as client..  */
          if (args_info->client_given)
            {
              fprintf (stderr, "%s: `--client' (`-c') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->client_given = 1;
          args_info->client_flag = !(args_info->client_flag);
          break;

        case 's':	/* Act as server..  */
          if (args_info->server_given)
            {
              fprintf (stderr, "%s: `--server' (`-s') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->server_given = 1;
          args_info->server_flag = !(args_info->server_flag);
          break;

        case 'd':	/* After authentication, read data from stdin and run it through the mechanism's security layer and print it base64 encoded to stdout. The default is to terminate after authentication..  */
          if (args_info->application_data_given)
            {
              fprintf (stderr, "%s: `--application-data' (`-d') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->application_data_given = 1;
          args_info->application_data_flag = !(args_info->application_data_flag);
          break;

        case 'm':	/* Mechanism to use..  */
          if (args_info->mechanism_given)
            {
              fprintf (stderr, "%s: `--mechanism' (`-m') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->mechanism_given = 1;
          args_info->mechanism_arg = gengetopt_strdup (optarg);
          break;

        case 'n':	/* Token for anonymous authentication, usually mail address (ANONYMOUS only)..  */
          if (args_info->anonymous_token_given)
            {
              fprintf (stderr, "%s: `--anonymous-token' (`-n') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->anonymous_token_given = 1;
          args_info->anonymous_token_arg = gengetopt_strdup (optarg);
          break;

        case 'a':	/* Identity of credential owner..  */
          if (args_info->authentication_id_given)
            {
              fprintf (stderr, "%s: `--authentication-id' (`-a') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->authentication_id_given = 1;
          args_info->authentication_id_arg = gengetopt_strdup (optarg);
          break;

        case 'z':	/* Identity to request service for..  */
          if (args_info->authorization_id_given)
            {
              fprintf (stderr, "%s: `--authorization-id' (`-z') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->authorization_id_given = 1;
          args_info->authorization_id_arg = gengetopt_strdup (optarg);
          break;

        case 'p':	/* Password for authentication (insecure for non-testing purposes)..  */
          if (args_info->password_given)
            {
              fprintf (stderr, "%s: `--password' (`-p') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->password_given = 1;
          args_info->password_arg = gengetopt_strdup (optarg);
          break;

        case 'r':	/* Realm (may be given more than once iff server). Defaults to hostname..  */
          args_info->realm_given++;
          realm_new = (struct realm_list *) malloc (sizeof (struct realm_list));
          realm_new->next = realm_list;
          realm_list = realm_new;
          realm_new->realm_arg = gengetopt_strdup (optarg);
          break;

        case 'x':	/* Indicate maximum buffer size (DIGEST-MD5 only)..  */
          if (args_info->maxbuf_given)
            {
              fprintf (stderr, "%s: `--maxbuf' (`-x') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->maxbuf_given = 1;
          args_info->maxbuf_arg = strtol (optarg,&stop_char,0);
          break;


        case 0:	/* Long option with no short option */
          /* Write name of supported client mechanisms separated by space to stdout..  */
          if (strcmp (long_options[option_index].name, "client-mechanisms") == 0)
          {
            if (args_info->client_mechanisms_given)
              {
                fprintf (stderr, "%s: `--client-mechanisms' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->client_mechanisms_given = 1;
            args_info->client_mechanisms_flag = !(args_info->client_mechanisms_flag);
            break;
          }
          
          /* Write name of supported server mechanisms separated by space to stdout..  */
          else if (strcmp (long_options[option_index].name, "server-mechanisms") == 0)
          {
            if (args_info->server_mechanisms_given)
              {
                fprintf (stderr, "%s: `--server-mechanisms' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->server_mechanisms_given = 1;
            args_info->server_mechanisms_flag = !(args_info->server_mechanisms_flag);
            break;
          }
          
          /* Connect to TCP server and negotiate on stream instead of stdin/stdout. SERVICE is the protocol service, or an integer denoting the port, and defaults to 143 (imap) if not specified. Also sets the --hostname default..  */
          else if (strcmp (long_options[option_index].name, "connect") == 0)
          {
            if (args_info->connect_given)
              {
                fprintf (stderr, "%s: `--connect' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->connect_given = 1;
            args_info->connect_arg = gengetopt_strdup (optarg);
            break;
          }
          
          /* Use a IMAP-like logon procedure (client only). Also sets the --service default to 'imap'..  */
          else if (strcmp (long_options[option_index].name, "imap") == 0)
          {
            if (args_info->imap_given)
              {
                fprintf (stderr, "%s: `--imap' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->imap_given = 1;
            args_info->imap_flag = !(args_info->imap_flag);
            break;
          }
          
          /* Use a SMTP-like logon procedure (client only). Also sets the --service default to 'smtp'..  */
          else if (strcmp (long_options[option_index].name, "smtp") == 0)
          {
            if (args_info->smtp_given)
              {
                fprintf (stderr, "%s: `--smtp' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->smtp_given = 1;
            args_info->smtp_flag = !(args_info->smtp_flag);
            break;
          }
          
          /* Disallow client to send data first (client only)..  */
          else if (strcmp (long_options[option_index].name, "no-client-first") == 0)
          {
            if (args_info->no_client_first_given)
              {
                fprintf (stderr, "%s: `--no-client-first' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->no_client_first_given = 1;
            args_info->no_client_first_flag = !(args_info->no_client_first_flag);
            break;
          }
          
          /* Passcode for authentication (SECURID only)..  */
          else if (strcmp (long_options[option_index].name, "passcode") == 0)
          {
            if (args_info->passcode_given)
              {
                fprintf (stderr, "%s: `--passcode' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->passcode_given = 1;
            args_info->passcode_arg = gengetopt_strdup (optarg);
            break;
          }
          
          /* Set the requested service name (should be a registered GSSAPI host based service name)..  */
          else if (strcmp (long_options[option_index].name, "service") == 0)
          {
            if (args_info->service_given)
              {
                fprintf (stderr, "%s: `--service' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->service_given = 1;
            args_info->service_arg = gengetopt_strdup (optarg);
            break;
          }
          
          /* Set the name of the server with the requested service..  */
          else if (strcmp (long_options[option_index].name, "hostname") == 0)
          {
            if (args_info->hostname_given)
              {
                fprintf (stderr, "%s: `--hostname' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->hostname_given = 1;
            args_info->hostname_arg = gengetopt_strdup (optarg);
            break;
          }
          
          /* Set the generic server name in case of a replicated server (DIGEST-MD5 only)..  */
          else if (strcmp (long_options[option_index].name, "service-name") == 0)
          {
            if (args_info->service_name_given)
              {
                fprintf (stderr, "%s: `--service-name' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->service_name_given = 1;
            args_info->service_name_arg = gengetopt_strdup (optarg);
            break;
          }
          
          /* Validate CRAM-MD5 challenge and response interactively..  */
          else if (strcmp (long_options[option_index].name, "enable-cram-md5-validate") == 0)
          {
            if (args_info->enable_cram_md5_validate_given)
              {
                fprintf (stderr, "%s: `--enable-cram-md5-validate' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->enable_cram_md5_validate_given = 1;
            args_info->enable_cram_md5_validate_flag = !(args_info->enable_cram_md5_validate_flag);
            break;
          }
          
          /* Disable cleartext validate hook, forcing server to prompt for password..  */
          else if (strcmp (long_options[option_index].name, "disable-cleartext-validate") == 0)
          {
            if (args_info->disable_cleartext_validate_given)
              {
                fprintf (stderr, "%s: `--disable-cleartext-validate' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->disable_cleartext_validate_given = 1;
            args_info->disable_cleartext_validate_flag = !(args_info->disable_cleartext_validate_flag);
            break;
          }
          
          /* How application payload will be protected.  'auth' means no protection, 'auth-int' means integrity protection, 'auth-conf' means integrity and confidentialiy protection.  Currently only used by DIGEST-MD5, where the default is 'auth-conf'..  */
          else if (strcmp (long_options[option_index].name, "quality-of-protection") == 0)
          {
            if (args_info->quality_of_protection_given)
              {
                fprintf (stderr, "%s: `--quality-of-protection' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->quality_of_protection_given = 1;
            args_info->quality_of_protection_arg = gengetopt_strdup (optarg);
            break;
          }
          
          /* Produce verbose output..  */
          else if (strcmp (long_options[option_index].name, "verbose") == 0)
          {
            if (args_info->verbose_given)
              {
                fprintf (stderr, "%s: `--verbose' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->verbose_given = 1;
            args_info->verbose_flag = !(args_info->verbose_flag);
            break;
          }
          
          /* Don't produce any diagnostic output..  */
          else if (strcmp (long_options[option_index].name, "quiet") == 0)
          {
            if (args_info->quiet_given)
              {
                fprintf (stderr, "%s: `--quiet' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->quiet_given = 1;
            args_info->quiet_flag = !(args_info->quiet_flag);
            break;
          }
          

        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          exit (EXIT_FAILURE);

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c\n", CMDLINE_PARSER_PACKAGE, c);
          abort ();
        } /* switch */
    } /* while */


  if ( missing_required_options )
    exit (EXIT_FAILURE);

  if (args_info->realm_given)
    {
      args_info->realm_arg = (char * *) malloc (args_info->realm_given * sizeof (char *));
      for (i = 0; i < args_info->realm_given; i++)
        {
          args_info->realm_arg [i] = realm_list->realm_arg;
          realm_list = realm_list->next;
        }
    }
  
  return 0;
}
