.TH groff @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
groff \- front end to the GNU
.I roff
document formatting system
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 1989-2022 Free Software Foundation, Inc.
.\"
.\" This file is part of groff, the GNU roff type-setting system.
.\"
.\" Permission is granted to copy, distribute and/or modify this
.\" document under the terms of the GNU Free Documentation License,
.\" Version 1.3 or any later version published by the Free Software
.\" Foundation; with no Invariant Sections, with no Front-Cover Texts,
.\" and with no Back-Cover Texts.
.\"
.\" A copy of the Free Documentation License is included as a file
.\" called FDL in the main directory of the groff source package.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_groff_1_man_C \n[.cp]
.cp 0
.
.\" Define fallback for groff 1.23's MR macro if the system lacks it.
.nr do-fallback 0
.if !\n(.f           .nr do-fallback 1 \" mandoc
.if  \n(.g .if !d MR .nr do-fallback 1 \" older groff
.if !\n(.g           .nr do-fallback 1 \" non-groff *roff
.if \n[do-fallback]  \{\
.  de MR
.    ie \\n(.$=1 \
.      I \%\\$1
.    el \
.      IR \%\\$1 (\\$2)\\$3
.  .
.\}
.rr do-fallback
.
.\" Define a string for the TeX logo.
.ie t .ds TeX T\h'-.1667m'\v'.224m'E\v'-.224m'\h'-.125m'X
.el   .ds TeX TeX
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY groff
.RB [ \-abcCeEgGijklNpRsStUVXzZ ]
.RB [ \-d\~\c
.IR ctext ]
.RB [ \-d\~\c
.IB string =\c
.IR text ]
.RB [ \-D\~\c
.IR fallback-encoding ]
.RB [ \-f\~\c
.IR font-family ]
.RB [ \-F\~\c
.IR font-directory ]
.RB [ \-I\~\c
.IR inclusion-directory ]
.RB [ \-K\~\c
.IR input-encoding ]
.RB [ \-L\~\c
.IR spooler-argument ]
.RB [ \-m\~\c
.IR macro-package ]
.RB [ \-M\~\c
.IR macro-directory ]
.RB [ \-n\~\c
.IR page-number ]
.RB [ \-o\~\c
.IR page-list ]
.RB [ \-P\~\c
.IR postprocessor-argument ]
.RB [ \-r\~\c
.IR cnumeric-expression ]
.RB [ \-r\~\c
.IB register =\c
.IR numeric-expression ]
.RB [ \-T\~\c
.IR output-device ]
.RB [ \-w\~\c
.IR warning-category ]
.RB [ \-W\~\c
.IR warning-category ]
.RI [ file\~ .\|.\|.]
.YS
.
.
.SY groff
.B \-h
.
.SY groff
.B \-\-help
.YS
.
.
.SY groff
.B \-v
.RI [ option\~ .\|.\|.\&]
.RI [ file\~ .\|.\|.]
.
.SY groff
.B \-\-version
.RI [ option\~ .\|.\|.\&]
.RI [ file\~ .\|.\|.]
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
.I groff
is the primary front end to the GNU
.I roff
document formatting system.
.
.\" BEGIN Keep parallel with groff.texi node "What Is groff?".
.\" This language is slightly expanded from that in the "ANNOUNCE" file
.\" and on the groff home page.
GNU
.I roff
is a typesetting system that reads plain text input files that include
formatting commands to produce output in PostScript,
PDF,
HTML,
DVI,
or other formats,
or for display to a terminal.
.
Formatting commands can be low-level typesetting primitives,
macros from a supplied package,
or user-defined macros.
.
All three approaches can be combined.
.
.
.P
A reimplementation and extension of the typesetter from AT&T Unix,
.I groff
is present on most POSIX systems owing to its long association with Unix
manuals
(including man pages).
.
It and its predecessor are notable for their production of several
best-selling software engineering texts.
.
.I groff
is capable of producing typographically sophisticated documents while
consuming minimal system resources.
.\" END Keep parallel with groff.texi node "What Is groff?".
.
.
.P
The
.I groff
command orchestrates the execution of preprocessors,
the transformation of input documents into a device-independent page
description language,
and the production of output from that language.
.
.
.\" ====================================================================
.SH Options
.\" ====================================================================
.
.B \-h
and
.B \-\-help
display a usage message and exit.
.
.
.P
Because
.I groff
is intended to subsume most users' direct invocations of the
.MR @g@troff @MAN1EXT@
formatter,
the two programs share a set of options.
.
However,
.I groff
has some options that
.I @g@troff
does not share,
and others which
.I groff
interprets differently.
.
At the same time,
not all valid
.I @g@troff
options can be given to
.IR groff .
.
.
.\" ====================================================================
.SS "\f[I]groff\f[]-specific options"
.\" ====================================================================
.
The following options either do not exist for
.I @g@troff
or are interpreted differently by
.IR groff .
.
.
.TP
.BI \-D\~ enc
Set fallback input encoding used by
.MR preconv @MAN1EXT@
to
.IR enc ;
implies
.BR \-k .
.
.
.TP
.B \-e
Run
.MR @g@eqn @MAN1EXT@
preprocessor.
.
.
.TP
.B \-g
Run
.MR @g@grn @MAN1EXT@
preprocessor.
.
.
.TP
.B \-G
Run
.MR grap 1
preprocessor;
implies
.BR \-p .
.
.
.TP
.BI \-I\~ dir
Works as
.IR @g@troff 's
option
(see below),
but also implies
.B \-g
and
.BR \-s .
.
It is passed to
.MR @g@soelim @MAN1EXT@
and the output driver,
and
.I @g@grn
is passed an
.B \-M
option with
.I dir
as its argument.
.
.
.TP
.B \-j
Run
.MR @g@chem @MAN1EXT@
preprocessor;
implies
.BR \-p .
.
.
.TP
.B \-k
Run
.MR preconv @MAN1EXT@
preprocessor.
.
Refer to its man page for its behavior if neither of
.IR groff 's
.B \-K
or
.B \-D
options is also specified.
.
.
.TP
.BI \-K\~ enc
Set input encoding used by
.MR preconv @MAN1EXT@
to
.IR enc ;
implies
.BR \-k .
.
.
.TP
.B \-l
Send the output to a spooler program for printing.
.
The
.RB \[lq] print \[rq]
directive in the device description file
specifies the default command to be used;
see
.MR groff_font @MAN5EXT@ .
.
If no such directive is present for the output device,
.ie '@PSPRINT@'' \{\
this option is ignored.
.\}
.el \{\
output is piped to
.MR @PSPRINT@ 1 .
.\}
.
See options
.B \-L
and
.BR \-X .
.
.
.TP
.BI \-L\~ arg
Pass
.I arg
to the print spooler program.
.
If multiple
.IR arg s
are required,
pass each with a separate
.B \-L
option.
.
.I groff
does not prefix an option dash to
.I arg
before passing it to the spooler program.
.
.
.TP
.B \-M
Works as
.IR @g@troff 's
option
(see below),
but is also passed to
.MR @g@eqn @MAN1EXT@ ,
.MR grap @MAN1EXT@ ,
and
.MR @g@grn @MAN1EXT@ .
.
.
.TP
.B \-N
Prohibit newlines between
.I eqn \" language
delimiters:
pass
.B \-N
to
.MR @g@eqn @MAN1EXT@ .
.
.
.TP
.B \-p
Run
.MR @g@pic @MAN1EXT@
preprocessor.
.
.
.TP
.BI \-P\~ arg
Pass
.I arg
to the postprocessor.
.
If multiple
.IR arg s
are required,
pass each with a separate
.B \-P
option.
.
.I groff
does not prefix an option dash to
.I arg
before passing it to the postprocessor.
.
.
.TP
.B \-R
Run
.MR @g@refer @MAN1EXT@
preprocessor.
.
No mechanism is provided for passing arguments to
.I @g@refer
because most
.I @g@refer
options have equivalent language elements that can be specified within
the document.
.
.
.TP
.B \-s
Run
.MR @g@soelim @MAN1EXT@
preprocessor.
.
.
.TP
.B \-S
Operate in \[lq]safer\[rq] mode;
see
.B \-U
below for its opposite.
.
For security reasons,
safer mode is enabled by default.
.
.
.TP
.B \-t
Run
.MR @g@tbl @MAN1EXT@
preprocessor.
.
.
.TP
.BI \-T\~ dev
Direct
.I @g@troff
to format the input for the output device
.IR dev .
.
.I groff
then calls an output driver to convert
.IR @g@troff 's
output to a form appropriate for
.IR dev ;
see subsection \[lq]Output devices\[rq] below.
.
.
.TP
.B \-U
Operate in unsafe mode:
pass the
.B \-U
option to
.I @g@pic
and
.IR @g@troff .
.
.
.TP
.B \-v
.TQ
.B \-\-version
Write version information for
.I groff
and all programs run by it to the standard output stream;
that is,
the given command line is processed in the usual way,
passing
.B \-v
to the formatter and any pre- or postprocessors invoked.
.
.
.TP
.B \-V
Output the pipeline that would be run by
.I groff
(as a wrapper program)
to the standard output stream,
but do not execute it.
.
If given more than once,
the pipeline is both written to the standard error stream and run.
.
.
.TP
.B \-X
Use
.MR gxditview @MAN1EXT@
instead of the usual postprocessor to (pre)view a document on an X11
display.
.
Combining this option with
.B \-Tps
uses the font metrics of the PostScript device,
whereas the
.B \-TX75
and
.B \-TX100
options use the metrics of X11 fonts.
.
.
.TP
.B \-Z
Disable postprocessing.
.
.I @g@troff
output will appear on the standard output stream
(unless suppressed with
.BR \-z );
see
.MR groff_out @MAN5EXT@
for a description of this format.
.
.
.\" ====================================================================
.SS "Transparent options"
.\" ====================================================================
.
The following options are passed as-is to the formatter program
.MR @g@troff @MAN1EXT@
and described in more detail in its man page.
.
.
.TP
.B \-a
Generate a plain text approximation of the typeset output.
.
.
.TP
.B \-b
Write a backtrace to the standard error stream on each error or warning.
.
.
.TP
.B \-c
Start with color output disabled.
.
.
.TP
.B \-C
Enable AT&T
.I troff \" AT&T
compatibility mode;
implies
.BR \-c .
.
.
.TP
.BI \-d\~ cs
.TQ
.BI \-d\~ name = string
Define string.
.
.
.TP
.B \-E
Inhibit
.I @g@troff
error messages;
implies
.BR \-Ww .
.
.
.TP
.BI \-f\~ fam
Set default font family.
.
.
.TP
.BI \-F\~ dir
Search in directory
.I dir
for the selected output device's directory of device and font
description files.
.
.
.TP
.B \-i
Process standard input after the specified input files.
.
.
.TP
.BI \-I\~ dir
Search
.I dir
for input files.
.
.
.TP
.BI \-m\~ name
Process
.RI name .tmac
before input files.
.
.
.TP
.BI \-M\~ dir
Search directory
.I dir
for macro files.
.
.
.TP
.BI \-n\~ num
Number the first page
.IR num .
.
.
.TP
.BI \-o\~ list
Output only pages in
.IR list .
.
.
.TP
.BI \-r\~ cnumeric-expression
.TQ
.BI \-r\~ register = numeric-expression
Define register.
.
.
.TP
.BI \-w\~ name
.TQ
.BI \-W\~ name
Enable
.RB ( \-w )
or inhibit
.RB ( \-W )
emission of warnings in category
.IR name .
.
.
.TP
.B \-z
Suppress formatted device-independent output of
.IR @g@troff .
.
.
.\" ====================================================================
.SH Usage
.\" ====================================================================
.
The architecture of the GNU
.I roff
system
follows that of other device-independent
.I roff
implementations,
comprising preprocessors,
macro packages,
output drivers
(or \[lq]postprocessors\[rq]),
a suite of utilities,
and the formatter
.I @g@troff
at its heart.
.
See
.MR roff @MAN7EXT@
for a survey of how a
.I roff
system works.
.
.
.P
The front end programs available in the GNU
.I roff
system make it easier to use than traditional
.IR roff s
that required the construction of pipelines or use of temporary files to
carry a source document from maintainable form to device-ready output.
.
The discussion below summarizes the constituent parts of the GNU
.I roff
system.
.
It complements
.MR roff @MAN7EXT@
with
.IR groff -specific
information.
.
.
.\" ====================================================================
.SS "Getting started"
.\" ====================================================================
.
Those who prefer to learn by experimenting or are desirous of rapid
feedback from the system may wish to start with a \[lq]Hello,
world!\&\[rq] document.
.
.
.P
.EX
$ \c
.B echo \[dq]Hello, world!\[dq] | groff \-Tascii \
| sed \[aq]/\[ha]$/d\[aq]
Hello, world!
.EE
.
.
.P
We used a
.I sed
command only to eliminate the 65 blank lines that would otherwise flood
the terminal screen.
.
.RI ( roff
systems were developed in the days of paper-based terminals with 66
lines to a page.)
.
.
.P
Today's users may prefer output to a UTF-8-capable terminal.
.
.
.P
.EX
$ \c
.B echo \[dq]Hello, world!\[dq] | groff \-Tutf8 \
| sed \[aq]/\[ha]$/d\[aq]
.EE
.
.
.P
Producing PDF,
HTML,
or \*[TeX]'s DVI is also straightforward.
.
The hard part may be selecting a viewer program for the output.
.
.
.P
.EX
$ \c
.B echo \[dq]Hello, world!\[dq] | groff \-Tpdf > hello.pdf
$ \c
.B evince hello.pdf
$ \c
.B echo \[dq]Hello, world!\[dq] | groff \-Thtml > hello.html
$ \c
.B firefox hello.html
$ \c
.B echo \[dq]Hello, world!\[dq] | groff \-Tdvi > hello.dvi
$ \c
.B xdvi hello.html
.EE
.
.
.\" ====================================================================
.SS "Using \f[I]groff\f[] as a REPL"
.\" ====================================================================
.
Those with a programmer's bent may be pleased to know that they can use
.I groff
in a read-evaluate-print loop (REPL).
.
Doing so can be handy to verify one's understanding of the formatter's
behavior and/or the syntax it accepts.
.
Turning on all warnings with
.B \-ww
can aid this goal.
.
.
.P
.EX
$ \c
.B groff \-ww \-Tutf8
.B \[rs]# This is a comment.  Let\[aq]s define a register.
.B .nr a 1
.B \[rs]# Do integer arithmetic with operators evaluated left-to-right.
.B .nr b \[rs]n[a]+5/2
.B \[rs]# Let\[aq]s get the result on the standard error stream.
.B .tm \[rs]n[b]
3
.B \[rs]# Now we\[aq]ll define a string.
.B .ds name Leslie\[rs]" This is another form of comment.
.B .nr b (\[rs]n[a] + (7/2))
.B \[rs]# Center the next two text input lines.
.B .ce 2
.B Hi, \[rs]*[name].
.B Your secret number is \[rs]n[b].
.B \[rs]# We will see that the division rounded toward zero.
.B It is
.B \[rs]# Here\[aq]s an if-else control structure.
.B .ie (\[rs]n[b] % 2) odd.
.B .el even.
.B \[rs]# This trick sets the page length to the current vertical
.B \[rs]# position, so that blank lines don\[aq]t spew when we\[aq]re \
done.
.B .pl \[rs]n[nl]u
.I <Control-D>
                           Hi, Leslie.
                    Your secret number is 4.
It is even.
.EE
.
.
.\" ====================================================================
.SS "Paper format"
.\" ====================================================================
.
In GNU
.IR roff ,
the page dimensions for the formatter
.I @g@troff
and for output devices are handled separately.
.
In the formatter,
requests are used to set the page length
.RB ( .pl ),
page offset
(or left margin,
.BR .po ),
and line length
.RB ( .ll ).
.
The right margin is not explicitly configured;
the combination of page offset and line length provides the information
necessary to derive it.
.
The
.I papersize
macro package,
automatically loaded by
.IR @g@troff ,
provides an interface for configuring page dimensions by convenient
names,
like \[lq]letter\[rq] or
\[lq]A4\[rq];
see
.MR groff_tmac @MAN5EXT@ .
.
The default used by the formatter depends on its build configuration;
in this installation,
it is
.RB \[lq] @PAGE@ \[rq].
.
.
.P
It is up to each macro package to respect the page dimensions configured
in this way.
.
Some offer alternative mechanisms.
.
.
.P
For each output device,
the size of the output medium can be set in its
.I DESC
file.
.
Most output drivers also recognize a command-line option
.B \-p
to override the default dimensions and an option
.B \-l
to use landscape orientation.
.
See
.MR groff_font @MAN5EXT@
for a description of the
.B papersize
directive,
which takes an argument of the same form as
.BR \-p .
.
The output driver's man page,
such as
.MR grops @MAN1EXT@ ,
may also be helpful.
.
.I groff
uses the command-line option
.B \-P
to pass options to output devices;
for example,
use the following for PostScript output on A4 paper in landscape
orientation.
.
.
.IP
.EX
groff \-Tps \-dpaper=a4l \-P\-pa4 \-P\-l \-ms foo.ms > foo.ps
.EE
.
.
.\" ====================================================================
.SS "Front end"
.\" ====================================================================
.
The
.I groff
program is a wrapper around the
.MR @g@troff @MAN1EXT@
program.
.
It allows one to specify preprocessors via command-line options and
automatically runs the appropriate postprocessor for the selected
output device.
.
Doing so,
the manual construction of pipelines or management of temporary files
required of users of traditional
.MR roff @MAN7EXT@
systems can be avoided.
.
The
.MR grog @MAN1EXT@
program can be used to infer an appropriate
.I groff
command line to format a document.
.
.
.\" ====================================================================
.SS Language
.\" ====================================================================
.
Input to a
.I roff
system is in plain text interleaved with control lines and escape
sequences.
.
The combination constitutes a document in one of a family of languages
we also call
.IR roff ;
see
.MR roff @MAN7EXT@
for background.
.
An overview of GNU
.I roff
language syntax and features,
including lists of all supported escape sequences,
requests,
and predefined registers,
can be found in
.MR groff @MAN7EXT@ .
.
GNU
.I roff
extensions to the AT&T
.I troff
language,
a common subset of
.I roff
dialects extant today,
are detailed in
.MR groff_diff @MAN7EXT@ .
.
.
.\" ====================================================================
.SS Preprocessors
.\" ====================================================================
.
A preprocessor interprets a domain-specific language that produces
.I roff
language output.
.
Frequently,
such input is confined to sections or regions of a
.I roff
input file
(bracketed with macro calls specific to each preprocessor),
which it replaces.
.
Preprocessors therefore often interpret a subset of
.I roff
syntax along with their own language.
.
GNU
.I roff
provides reimplementations of most preprocessors familiar to users of
AT&T
.IR troff ; \" AT&T
these routinely have extended features and/or require GNU
.I troff \" GNU
to format their output.
.
.
.br
.ne 10v
.P
.RS
.TS
tab($);
Li Lx.
@g@tbl$lays out tables;
@g@eqn$typesets mathematics;
@g@pic$draws diagrams;
@g@refer$processes bibliographic references;
@g@soelim$preprocesses \[lq]sourced\[rq] input files;
@g@grn$T{
renders
.MR gremlin 1
diagrams;
T}
@g@chem$T{
draws chemical structural formul\[ae]
using
.IR pic ; \" generic
T}
gperl$T{
populates
.I groff
registers and strings using
.MR perl 1 ;
T}
glilypond$T{
embeds
.I LilyPond
sheet music;
and
T}
gpinyin$T{
eases Mandarin Chinese input using Hanyu Pinyin.
T}
.TE
.RE
.
.
.P
A preprocessor unique to GNU
.I roff
is
.MR preconv @MAN1EXT@ ,
which converts various input encodings to something GNU
.I troff \" GNU
can understand.
.
When used,
it is run before any other preprocessors.
.
.
.P
Most preprocessors enclose content between a pair of characteristic
tokens.
.
Such a token must occur at the beginning of an input line and use the
dot control character.
.
Spaces and tabs must not follow the control character or precede the
end of the input line.
.
Deviating from these rules defeats a token's recognition by the
preprocessor.
.
Tokens are generally preserved in preprocessor output and interpreted as
macro calls subsequently by
.IR @g@troff .
.
The
.I @g@ideal
preprocessor is not yet available in
.IR groff .
.
.
.P
.TS
box, center, tab (^);
c | c | c
CfCR | CfCR | CfCR.
preprocessor^starting token^ending token
=
@g@chem^.cstart^.cend
@g@eqn^.EQ^.EN
grap^.G1^.G2
@g@grn^.GS^.GE
.\" Keep the .IF line below the @g@ideal line.
@g@ideal^.IS^.IE
^^.IF
.\" Keep the .PF line below the @g@pic line.
@g@pic^.PS^.PE
^^.PF
^^.PY
@g@refer^.R1^.R2
@g@tbl^.TS^.TE
_
glilypond^.lilypond start^.lilypond stop
gperl^.Perl start^.Perl stop
gpinyin^.pinyin start^.pinyin stop
.TE
.
.
.\" ====================================================================
.SS "Macro packages"
.\" ====================================================================
.
Macro files are
.I roff
input files designed to produce no output themselves but instead ease
the preparation of other
.I roff
documents.
.
When a macro file is installed at a standard location and suitable for
use by a general audience,
it is termed a
.IR "macro package" .
.
.
.P
Macro packages can be loaded prior to any
.I roff
input documents with the
.BR \-m \~option.
.
The GNU
.I roff
system implements most well-known macro packages for AT&T
.I troff \" AT&T
.\" exceptions: mpm, mv
in a compatible way and extends them.
.
These have one- or two-letter names arising from intense practices of
naming economy in early Unix culture,
a laconic approach that led to many of the packages being identified in
general usage with the
.I nroff
and
.I troff
option letter used to invoke them,
sometimes to punning effect,
as with \[lq]man\[rq]
(short for \[lq]manual\[rq]),
and even with the option dash,
as in the case of the
.I s
package,
much better known as
.I ms
or even
.IR \-ms .
.
.
.P
Macro packages serve a variety of purposes.
.
Some are \[lq]full-service\[rq] packages,
adopting responsibility for page layout among other fundamental tasks,
and defining their own lexicon of macros for document composition;
each such package stands alone and a given document can use at most one.
.
.
.TP
.I an
is used to compose man pages in the format originating in Version\~7
Unix (1979);
see
.MR groff_man @MAN7EXT@ .
.
It can be specified on the command line as
.BR \-man .
.
.
.TP
.I doc
is used to compose man pages in the format originating in 4.3BSD-Reno
(1990);
see
.MR groff_mdoc @MAN7EXT@ .
.
It can be specified on the command line as
.BR \-mdoc .
.
.
.TP
.I e
is the Berkeley general-purpose macro suite,
developed as an alternative to AT&T's
.IR s ;
see
.MR groff_me @MAN7EXT@ .
.
It can be specified on the command line as
.BR \-me .
.
.
.TP
.I m
implements the format used by the
second-generation AT&T macro suite for general documents,
a successor to
.IR s ;
see
.MR groff_mm @MAN7EXT@ .
.
It can be specified on the command line as
.BR \-mm .
.
.
.TP
.I om
(invariably called \[lq]mom\[rq])
is a modern package written by Peter Schaffter specifically for GNU
.IR roff .
.
Consult the
.UR file://\:@HTMLDOCDIR@/\:mom/\:toc\:.html
.I mom
HTML manual
.UE
for extensive documentation.
.
She\[em]for
.I mom
takes the female pronoun\[em]can be specified on the command line as
.BR \-mom .
.
.
.TP
.I s
is the original AT&T general-purpose document format;
see
.MR groff_ms @MAN7EXT@ .
.
It can be specified on the command line as
.BR \-ms .
.
.
.P
Others are supplemental.
.
For instance,
.
.I \%andoc
is a wrapper package specific to GNU
.I roff
that recognizes whether a document uses
.I man
or
.I mdoc
format and loads the corresponding macro package.
.
It can be specified on the command line as
.BR \%\-mandoc .
.
A
.MR man 1
librarian program \" such as man-db, since 2001
may use this macro file to delegate loading of the correct macro
package;
it is thus unnecessary for
.I man
itself to scan the contents of a document to decide the issue.
.
.
.P
Many macro files augment the function of the full-service packages,
or of
.I roff
documents that do not employ such a package\[em]the latter are sometimes
characterized as \[lq]raw\[rq].
.
These auxiliary packages are described,
along with
details of macro file naming and placement,
in
.MR groff_tmac @MAN5EXT@ .
.
.
.\" ====================================================================
.SS Formatters
.\" ====================================================================
.
The formatter,
the program that interprets
.I roff
language input,
is
.MR @g@troff @MAN1EXT@ .
.
It provides the features of the AT&T
.I troff \" AT&T
and
.I nroff \" AT&T
programs as well as many extensions.
.
The command-line option
.B \-C
switches
.I @g@troff
into
.IR "compatibility mode" ,
which tries to emulate AT&T
.I troff \" AT&T
as closely as is practical to enable the formatting of documents written
for the older system.
.
.
.P
A shell script,
.MR @g@nroff @MAN1EXT@ ,
emulates the behavior of AT&T
.IR nroff . \" AT&T
.
It attempts to correctly encode the output based on the locale,
relieving the user of the need to specify an output device with the
.B \-T
option and is therefore convenient for use with terminal output devices,
described in the next subsection.
.
.
.P
The formatter generates device-independent,
but not device-agnostic,
.I intermediate output
in a page description language whose syntax is detailed in
.MR groff_out @MAN5EXT@ .
.
.
.\" ====================================================================
.SS "Output devices"
.\" ====================================================================
.
.I @g@troff
output is formatted for a particular
.IR "output device" ,
typically specified by the
.B \-T
option to the formatter or a front end.
.
If neither this option nor the
.I \%GROFF_TYPESETTER
environment variable is used,
the default output device is
.BR @DEVICE@ .
.
An output device may be any of the following.
.
.
.TP 9n \" to fit "X100\-12" even on troff devices
.B ascii
for terminals using the ISO 646 1991:IRV character set and encoding,
also known as US-ASCII.
.
.
.TP
.B cp1047
for terminals using the IBM code page 1047 character set and encoding.
.
.
.TP
.B dvi
for TeX DVI format.
.
.
.TP
.B html
.TQ
.B xhtml
for HTML and XHTML output,
respectively.
.
.
.TP
.B latin1
for terminals using the ISO Latin-1
(ISO 8859-1)
character set and encoding.
.
.
.TP
.B lbp
for Canon CaPSL printers
(LBP-4 and LBP-8 series laser printers).
.
.
.TP
.B lj4
for HP LaserJet4-compatible
(or other PCL5-compatible)
printers.
.
.
.TP
.B pdf
for PDF output.
.
.
.TP
.B ps
for PostScript output.
.
.
.TP
.B utf8
for terminals using the ISO 10646 (\[lq]Unicode\[rq]) character set in
UTF-8 encoding.
.
.
.TP
.B X75
for previewing with
.I \%gxditview
using
75 dpi resolution and a
10-point base type size.
.
.
.TP
.B X75\-12
for previewing with
.I \%gxditview
using
75 dpi resolution and a
12-point base type size.
.
.
.TP
.B X100
for previewing with
.I \%gxditview
using
100 dpi resolution and a
10-point base type size.
.
.
.TP
.B X100\-12
for previewing with
.I \%gxditview
using
100 dpi resolution
and a
12-point base type size.
.
.
.\" ====================================================================
.SS Postprocessors
.\" ====================================================================
.
Any program that interprets the output of
.I @g@troff
is a GNU
.I roff
postprocessor.
.
All of the postprocessors provided by GNU
.I roff
are
.IR "output drivers" ,
which prepare a document for viewing or printing.
.
Postprocessors for other purposes,
such as page resequencing or statistical measurement of a document,
are conceivable.
.
.
.P
An output driver supports one or more output devices,
each with its own device description file.
.
A device determines its postprocessor with the
.B postpro
directive in its device description file;
see
.MR groff_font @MAN5EXT@ .
.
The
.B \-X
option overrides this selection,
causing
.I \%gxditview
to serve as the output driver.
.
.
.TP
.MR grodvi @MAN1EXT@
provides
.BR dvi .
.
.
.TP
.MR grohtml @MAN1EXT@
provides
.B html
and
.BR xhtml .
.
.
.TP
.MR grolbp @MAN1EXT@
provides
.BR lbp .
.
.
.TP
.MR grolj4 @MAN1EXT@
provides
.BR lj4 .
.
.
.TP
.MR gropdf @MAN1EXT@
provides
.BR pdf .
.
.
.TP
.MR grops @MAN1EXT@
provides
.BR ps .
.
.
.TP
.MR grotty @MAN1EXT@
provides
.BR ascii ,
.BR cp1047 ,
.BR latin1 ,
and
.BR utf8 .
.
.
.TP
.MR gxditview @MAN1EXT@
provides
.BR X75 ,
.BR X75\-12 ,
.BR X100 ,
and
.BR X100\-12 ,
and additionally can preview
.BR ps .
.
.
.\" ====================================================================
.SS Utilities
.\" ====================================================================
.
GNU
.I roff
includes a suite of utilities.
.
.
.TP
.MR gdiffmk @MAN1EXT@
marks differences between a pair of
.I roff
input files.
.
.
.TP
.MR grog @MAN1EXT@
infers the
.I groff
command a document requires.
.
.
.P
Several utilities prepare descriptions of fonts,
enabling the formatter to use them when producing output for a given
device.
.
.
.TP
.MR addftinfo @MAN1EXT@
adds information to AT&T
.I troff \" AT&T
font description files to enable their use with
GNU
.IR troff .\" GNU
.
.
.TP
.MR afmtodit @MAN1EXT@
creates font description files for PostScript Type\~1 fonts.
.
.
.TP
.MR pfbtops @MAN1EXT@
translates a PostScript Type\~1 font in PFB
(Printer Font Binary)
format to PFA
(Printer Font ASCII),
which can then be interpreted by
.IR \%afmtodit .
.
.
.TP
.MR hpftodit @MAN1EXT@
creates font description files for the HP LaserJet\~4 family of
printers.
.
.
.TP
.MR tfmtodit @MAN1EXT@
creates font description files for the TeX DVI device.
.
.
.TP
.MR xtotroff @MAN1EXT@
creates font description files for X Window System core fonts.
.
.
.P
A trio of tools transform material constructed using
.I roff
preprocessor languages into graphical image files.
.
.
.TP
.MR eqn2graph @MAN1EXT@
converts an
.I eqn
equation into a cropped image.
.
.
.TP
.MR grap2graph @MAN1EXT@
converts a
.I grap
diagram into a cropped image.
.
.
.TP
.MR pic2graph @MAN1EXT@
converts a
.I pic
diagram into a cropped image.
.
.
.P
Another set of programs works with the bibliographic data files used
by the
.MR refer @MAN1EXT@
preprocessor.
.
.
.TP
.MR @g@indxbib @MAN1EXT@
makes inverted indices for bibliographic databases,
speeding lookup operations on them.
.
.
.TP
.MR lkbib @MAN1EXT@
searches the databases.
.
.
.TP
.MR @g@lookbib @MAN1EXT@
interactively searches
the databases.
.
.
.\" ====================================================================
.SH "Exit status"
.\" ====================================================================
.
.I groff
exits with a failure status if there was a problem parsing its arguments
and a successful status if either of the options
.B \-h
or
.B \-\-help
was specified.
.
Otherwise,
.I groff
runs a pipeline to process its input;
if all commands within the pipeline exit successfully,
.I groff
does likewise.
.
If not,
.IR groff 's
exit status encodes a summary of problems encountered,
setting bit\~0 if a command exited with a failure status,
bit\~1 if a command was terminated with a signal,
and bit\~2 if a command could not be executed.
.
(Thus,
if all three misfortunes befell one's pipeline,
.I groff
would exit with status 2\[ha]0 + 2\[ha]1 + 2\[ha]2 = 1+2+4 = 7.)
.
To troubleshoot pipeline problems,
you may wish to re-run the
.I groff
command with the
.B \-V
option and break the reported pipeline down into separate stages,
inspecting the exit status of and diagnostic messages emitted by each
command.
.
.
.\" ====================================================================
.SH Environment
.\" ====================================================================
.
Normally,
the path separator in environment variables ending with
.I PATH
is the colon;
this may vary depending on the operating system.
.
For example,
Windows uses a semicolon instead.
.
.
.TP
.I GROFF_BIN_PATH
This search path,
followed by
.IR PATH ,
is used to locate commands executed by
.IR groff .
.
If it is not set,
the installation directory of the GNU
.I roff
executables,
.IR @BINDIR@ ,
is searched before
.IR PATH .
.
.
.TP
.I GROFF_COMMAND_PREFIX
GNU
.I roff
can be configured at compile time to apply a prefix to the names of the
programs it provides that had a counterpart in AT&T
.IR troff , \" AT&T
so that name collisions are avoided at run time.
.
The default prefix is empty.
.
.
.IP
When used,
this prefix is conventionally the letter \[lq]g\[rq].
.
For example,
GNU
.I troff \" GNU
would be installed as
.IR gtroff .
.
Besides
.IR troff , \" GNU
the prefix applies to
the formatter
.IR nroff ; \" GNU
the preprocessors
.IR eqn , \" generic
.IR grn , \" generic
.IR pic , \" generic
.IR \%refer , \" generic
.IR tbl , \" generic
and
.IR \%soelim ; \" generic
and the utilities
.I \%indxbib \" generic
and
.IR \%lookbib . \" generic
.
.
.TP
.I GROFF_ENCODING
The value of this variable is passed to the
.IR preconv (@MAN1EXT@)
preprocessor's
.B \-e
option to select the character encoding of input files.
.
This variable's existence implies
the
.I groff
option
.BR \-k .
.
If set but empty,
.I groff
calls
.I preconv
without an
.B \-e
option.
.
.IR groff 's
.B \-K
option overrides
.IR \%GROFF_ENCODING .
.
.
.TP
.I GROFF_FONT_PATH
Seek the selected output device's directory of device and font
description files in this list of directories.
.
See
.MR @g@troff @MAN1EXT@
and
.MR groff_font @MAN5EXT@ .
.
.
.TP
.I GROFF_TMAC_PATH
Seek macro files in this list of directories.
.
See
.MR @g@troff @MAN1EXT@
and
.MR groff_tmac @MAN5EXT@ .
.
.
.TP
.I GROFF_TMPDIR
Create temporary files in this directory.
.
If not set,
but the environment variable
.I \%TMPDIR
is set,
temporary files are created there instead.
.
On Windows systems,
if neither of the foregoing are set,
the environment variables
.I TMP
and
.I TEMP
(in that order)
are checked also.
.
Otherwise,
temporary files are created in
.IR /tmp .
.
The
.MR @g@refer @MAN1EXT@ ,
.MR grohtml @MAN1EXT@ ,
and
.MR grops @MAN1EXT@
commands use temporary files.
.
.
.TP
.I GROFF_TYPESETTER
Set the default output device.
.
If empty or not set,
.B @DEVICE@
is used.
.
The
.B \-T
option overrides
.IR \%GROFF_TYPESETTER .
.
.
.TP
.I SOURCE_DATE_EPOCH
A time stamp
(expressed as seconds since the Unix epoch)
to use as the output creation time stamp in place of the current time.
.
The time is converted to human-readable form using
.MR localtime 3
when the formatter starts up and stored in registers usable by documents
and macro packages.
.
.
.TP
.I TZ
The time zone to use when converting the current time
(or value of
.IR SOURCE_DATE_EPOCH )
to human-readable form;
see
.MR tzset 3 .
.
.
.\" ====================================================================
.SH Examples
.\" ====================================================================
.
.I roff
systems are best known for formatting man pages.
.
Once a
.MR man 1
librarian program has located a man page,
it may execute a
.I groff
command much like the following.
.
.RS
.EX
groff \-t \-man \-Tutf8 /usr/share/man/man1/groff.1
.EE
.RE
.
The librarian will also pipe the output through a pager,
which might not interpret the SGR terminal escape sequences
.I groff
emits for boldface,
underlining,
or italics;
see section \[lq]Limitations\[rq] below.
.
.
.P
To process a
.I roff
input file using the preprocessors
.I @g@tbl
and
.I @g@pic
and the
.I me
macro package in the way to which AT&T
.I troff \" AT&T
users were accustomed,
one would type
(or script)
a pipeline.
.
.
.IP
.EX
@g@pic foo.me | @g@tbl | @g@troff \-me \-Tutf8 | grotty
.EE
.
.
.P
Using
.IR groff ,
this pipe can be shortened to an equivalent command.
.
.IP
.EX
groff \-p \-t \-me \-T utf8 foo.me
.EE
.
.
.P
An even easier way to do this is to use
.MR grog @MAN1EXT@
to guess the preprocessor and macro options and execute the result by
using the command substitution feature of the shell.
.
.IP
.EX
$(grog \-Tutf8 foo.me)
.EE
.
.
.P
Each command-line option to a postprocessor must be specified with any
required leading dashes
.RB \[lq] \- \[rq]
.\" No GNU roff postprocessor uses long options for anything except
.\" --help or --version.
.\"or
.\".RB \[lq] \-\- \[rq]
because
.I groff
passes the arguments as-is to the postprocessor;
this permits arbitrary arguments to be transmitted.
.
For example,
to pass a title to the
.I gxditview
postprocessor,
the shell commands
.
.RS
.EX
groff \-X \-P \-title \-P \[aq]trial run\[aq] mydoc.t
.EE
.RE
.
and
.
.RS
.EX
groff \-X \-Z mydoc.t | gxditview \-title \[aq]trial run\[aq] \-
.EE
.RE
.
are equivalent.
.
.
.\" ====================================================================
.SH Limitations
.\" ====================================================================
.
When paging output for the
.BR ascii ,
.BR cp1047 ,
.BR latin1 ,
and
.B utf8
devices,
programs like
.MR more 1
and
.MR less 1
may require command-line options to correctly handle some terminal
escape sequences;
see
.MR grotty @MAN1EXT@ .
.
.
.P
On EBCDIC hosts such as OS/390 Unix,
the output devices
.B ascii
and
.B latin1
aren't available.
.
Conversely,
the output device
.B cp1047
is not available on systems based on the ISO\~646 or ISO\~8859 character
encoding standards.
.
.
.\" ====================================================================
.SH "Installation directories"
.\" ====================================================================
.
GNU
.I roff
installs files in varying locations depending on its compile-time
configuration.
.
On this installation,
the following locations are used.
.
.
.if !'@APPDEFDIR@'' \{\
.TP
.I @APPDEFDIR@
Application defaults directory for
.MR gxditview @MAN1EXT@ .
.\}
.
.
.TP
.I @BINDIR@
Directory containing
.IR groff 's
executable commands.
.
.
.TP
.I @COMMON_WORDS_FILE@
List of common words for
.MR indxbib @MAN1EXT@ .
.
.
.TP
.I @DATASUBDIR@
Directory for data files.
.
.
.TP
.I @DEFAULT_INDEX@
Default index for
.MR lkbib @MAN1EXT@
and
.MR refer @MAN1EXT@ .
.
.
.TP
.I @DOCDIR@
Documentation directory.
.
.
.TP
.I @EXAMPLEDIR@
Example directory.
.
.
.TP
.I @FONTDIR@
Font directory.
.
.
.TP
.I @HTMLDOCDIR@
HTML documentation directory.
.
.
.TP
.I @LEGACYFONTDIR@
Legacy font directory.
.
.
.TP
.I @LOCALFONTDIR@
Local font directory.
.
.
.TP
.I @LOCALMACRODIR@
Local macro package
.RI ( tmac
file) directory.
.
.
.TP
.I @MACRODIR@
Macro package
.RI ( tmac
file) directory.
.
.
.TP
.I @OLDFONTDIR@
Font directory for compatibility with old versions of
.IR groff ;
see
.MR grops @MAN1EXT@ .
.
.
.TP
.I @PDFDOCDIR@
PDF documentation directory.
.
.
.if !'@COMPATIBILITY_WRAPPERS@'no' \{\
.TP
.I @SYSTEMMACRODIR@
System macro package
.RI ( tmac
file) directory.
.\}
.
.
.\" ====================================================================
.SS "\f[I]groff\f[] macro directory"
.\" ====================================================================
.
Most macro files supplied with GNU
.I roff
are stored in
.I @MACRODIR@
for the installation corresponding to this document.
.
As a rule,
multiple directories are searched for macro files;
see
.MR @g@troff @MAN1EXT@ .
.
For a catalog of macro files GNU
.I roff
provides,
see
.MR groff_tmac @MAN5EXT@ .
.
.
.\" ====================================================================
.SS "\f[I]groff\f[] device and font description directory"
.\" ====================================================================
.
Device and font description files supplied with GNU
.I roff
are stored in
.I @FONTDIR@
for the installation corresponding to this document.
.
As a rule,
multiple directories are searched for device and font description files;
see
.MR @g@troff @MAN1EXT@ .
.
For the formats of these files,
see
.MR groff_font @MAN5EXT@ .
.
.
.\" ====================================================================
.SH Availability
.\" ====================================================================
.
Obtain links to
.I groff
releases for download,
its source repository,
discussion mailing lists,
a support ticket tracker,
and further information from the
.UR http://\:www\:.gnu\:.org/\:software/\:groff
.I groff
page of the GNU website
.UE .
.
.
.P
A free implementation of the
.I grap
preprocessor,
written by
.MT faber@\:lunabase\:.org
Ted Faber
.ME ,
can be found at the
.UR http://\:www\:.lunabase\:.org/\:\[ti]faber/\:Vault/\:software/\
\:grap/
.I grap
website
.UE .
.
.I groff
supports only this
.IR grap .
.
.
.\" ====================================================================
.SH Authors
.\" ====================================================================
.
.I groff
(both the front-end command and the overall system)
was primarily written by
.MT jjc@\:jclark\:.com
James Clark
.ME .
.
Contributors to this document include Clark,
Trent A.\& Fisher,
.MT wl@gnu.org
Werner Lemberg
.ME ,
.MT groff\-bernd.warken\-72@\:web\:.de
Bernd Warken
.ME ,
and
.MT g.branden\:.robinson@\:gmail\:.com
G.\& Branden Robinson
.ME .
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
.IR "Groff: The GNU Implementation of troff" ,
by Trent A.\& Fisher and Werner Lemberg,
is the primary
.I groff
manual.
.
You can browse it interactively with \[lq]info groff\[rq].
.
.
.\" groff ships 59 man pages generated from 58 source files.  The
.\" numbered comments refer to their sorting order in the source tree,
.\" so that it is easier to tell that we've enumerated all of them.
.TP
Introduction, \c
history, \c
and further reading:
.MR roff @MAN7EXT@ \" #23
.
.
.TP
.RI "Viewer for\~" groff "\~(and AT&T device-independent\~" troff \
)\~documents:
.MR gxditview @MAN1EXT@ \" #33
.
.
.TP
Preprocessors:
.MR @g@chem @MAN1EXT@ , \" #1
.MR @g@eqn @MAN1EXT@ , \" #34
.MR @g@neqn @MAN1EXT@ , \" #35
.MR glilypond @MAN1EXT@ , \" #4
.MR @g@grn @MAN1EXT@ , \" #36
.MR preconv @MAN1EXT@ , \" #38
.MR gperl @MAN1EXT@ , \" #5
.MR @g@pic @MAN1EXT@ , \" #37
.MR gpinyin @MAN1EXT@ , \" #6
.MR @g@refer @MAN1EXT@ , \" #39
.MR @g@soelim @MAN1EXT@ , \" #40
.MR @g@tbl @MAN1EXT@ \" #41
.
.
.TP
Macro packages and package-specific utilities:
.MR groff_hdtbl @MAN7EXT@ , \" #9
.MR groff_man @MAN7EXT@ , \" #55a
.MR groff_man_style @MAN7EXT@ , \" #55b
.MR groff_mdoc @MAN7EXT@ , \" #56
.MR groff_me @MAN7EXT@ , \" #57
.MR groff_mm @MAN7EXT@ , \" # 10
.MR groff_mmse @MAN7EXT@ , \" # 11
.MR mmroff @MAN1EXT@ , \" #12
.MR groff_mom @MAN7EXT@ , \" #13
.MR pdfmom @MAN1EXT@ , \" #30
.MR groff_ms @MAN7EXT@ , \" #58
.MR groff_rfc1345 @MAN7EXT@ , \" 16
.MR groff_trace @MAN7EXT@ , \" #59
.MR groff_www @MAN7EXT@ \" #60
.
.
.TP
Bibliographic database management tools:
.MR @g@indxbib @MAN1EXT@ , \" #49
.MR lkbib @MAN1EXT@ , \" #50
.MR @g@lookbib @MAN1EXT@ \" #51
.
.
.TP
Language, \c
conventions, \c
and GNU extensions:
.MR groff @MAN7EXT@ , \" #17
.MR groff_char @MAN7EXT@ , \" #18
.MR groff_diff @MAN7EXT@ , \" #19
.MR groff_font @MAN5EXT@ , \" #20
.MR groff_tmac @MAN5EXT@ \" #22
.
.
.TP
Intermediate output language:
.MR groff_out @MAN5EXT@ \" #21
.
.
.TP
Formatter program:
.MR @g@troff @MAN1EXT@ \" #45
.
.
.TP
Formatter wrappers:
.\".MR groff @MAN1EXT@ , \" 42 -- this page
.MR @g@nroff @MAN1EXT@ , \" #44
.MR pdfroff @MAN1EXT@ \" #14
.
.
.TP
Postprocessors for output devices:
.MR grodvi @MAN1EXT@ , \" #24
.MR grohtml @MAN1EXT@ , \" #25
.MR grolbp @MAN1EXT@ , \" #26
.MR grolj4 @MAN1EXT@ , \" #27
.MR gropdf @MAN1EXT@ , \" #29
.MR grops @MAN1EXT@ , \" #31
.MR grotty @MAN1EXT@ \" #32
.
.
.TP
Font support utilities:
.MR addftinfo @MAN1EXT@ , \" #46
.MR afmtodit @MAN1EXT@ , \" #47
.MR hpftodit @MAN1EXT@ , \" #48
.MR pfbtops @MAN1EXT@ , \" #52
.MR tfmtodit @MAN1EXT@ , \" #53
.MR xtotroff @MAN1EXT@ \" #54
.
.
.TP
Graphics conversion utilities:
.MR eqn2graph @MAN1EXT@ , \" #2
.MR grap2graph @MAN1EXT@ , \" #7
.MR pic2graph @MAN1EXT@ \" #15
.
.
.TP
Difference-marking utility:
.MR gdiffmk @MAN1EXT@ \" #3
.
.
.TP
\[lq]groff guess\[rq] utility:
.MR grog @MAN1EXT@ \" #43
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_groff_1_man_C]
.do rr *groff_groff_1_man_C
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
