.TH groff_www @MAN7EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
groff_www \- GNU roff macros for authoring web pages
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 2000-2020 Free Software Foundation, Inc.
.\"
.\" This file is part of groff, the GNU roff type-setting system.
.\"
.\" This program is free software: you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation, either version 3 of the License, or
.\" (at your option) any later version.
.\"
.\" This program is distributed in the hope that it will be useful, but
.\" WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
.\" General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see
.\" <http://www.gnu.org/licenses/>.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_groff_www_7_man_C \n[.cp]
.cp 0
.do mso www.tmac
.
.
.\" we need the .LK here as we use it in the middle as an example --
.\" once the user requests .LK then the automatic generation of links
.\" at the top of the document is suppressed.
.LK
.
.HR
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY "groff \-m www"
.RI [ option
\&.\|.\|.\&]
.RI [ input-file
\&.\|.\|.\&]
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
This manual page describes the GNU
.I www
macro package,
which is part of the
.I groff
document formatting system.
.
The manual page is very a basic guide, and the HTML device driver
.RI ( \%grohtml )
has been completely rewritten but still remains as in an alpha state.
.
It has been included into the distribution so that a lot of people have
a chance to test it.
.
Note that this macro file is automatically called (via the
.I troffrc
file) if you use
.B \-Thtml
or
.BR \-Txhtml .
.
.
.PP
To see the hyperlinks in action, please format this man page with the
.I \%grohtml
device.
.
.
.PP
Here is a summary of the functions found in this macro set.
.TS
tab(@);
l l.
\&.JOBNAME@split output into multiple files
\&.HX@automatic heading level cut off
\&.BCL@specify colours on a web page
\&.BGIMG@specify background image
\&.URL@create a URL using two parameters
\&.FTP@create an FTP reference
\&.MTO@create an HTML email address
\&.TAG@generate an HTML name
\&.IMG@include an image file
\&.PIMG@include PNG image
\&.MPIMG@place PNG on the margin and wrap text around it
\&.HnS@begin heading
\&.HnE@end heading
\&.LK@emit automatically collected links.
\&.HR@produce a horizontal rule
\&.NHR@suppress automatic generation of rules.
\&.HTL@only generate HTML title
\&.HEAD@add data to <head> block
\&.ULS@unorder list begin
\&.ULE@unorder list end
\&.OLS@ordered list begin
\&.OLE@ordered list end
\&.DLS@definition list begin
\&.DLE@definition list end
\&.LI@insert a list item
\&.DC@generate a drop capital
\&.HTML@pass an HTML raw request to the device driver
\&.CDS@code example begin
\&.CDE@code example end
\&.ALN@place links on left of main text.
\&.LNS@start a new two-column table with links in the left.
\&.LNE@end the two-column table.
\&.LINKSTYLE@initialize default URL attributes.
.TE
.
.
.PP
Output of the
.BR pic ,
.BR eqn ,
.BR refer ,
and
.B tbl
preprocessors is acceptable as input.
.
.
.\" ====================================================================
.SH Requests
.\" ====================================================================
.
.TP
.B .JOBNAME filename
Split output into multiple HTML files.
.
A file is split whenever a \&.SH or \&.NH\ 1 is encountered.
.
Its argument is the file stem name for future output files.
.
This option is equivalent to
.IR \%grohtml 's
.B \-j
option.
.
.TP
.B .HX n
Specify the cut off depth when generating links from section headings.
.
For example, a parameter of\~2 would cause
.I \%grohtml
to generate a list of links for
.B .NH\ 1
and
.B .NH\ 2
but not for
.BR .NH\ 3 .
.
Whereas
.
.
.RS
.IP
.EX
\&.HX 0
.EE
.RE
.
.
.IP
tells
.I \%grohtml
that no heading links should be created at all.
.
Another method for turning automatic headings off is by issuing the
command-line switch
.B \-P\-l
to
.BR groff .
.
.TP
.B .BCL foreground background active not-visited visited
This macro takes five parameters:
foreground,
background,
active hypertext link,
hypertext link not yet visited,
and visited hypertext link colour.
.
.TP
.B .BGIMG imagefile
the only parameter to this macro is the background image file.
.
.TP
.B .URL url [description] [after]
generates
.TAG URL
a URL using either one, two or three arguments.
.
The first parameter is the actual URL, the second is the name of the
link, and the third is optional stuff to be printed immediately
afterwards.
.
If
.B description
and
.B after
are absent then the
.B URL
becomes the anchor text.
.
Hyphenation is disabled while printing the actual URL;
explicit breakpoints should be inserted with the
.B \[rs]:
escape.
.
Here is how to encode
.UR http://\:foo\:.org/
foo
.UE :
.RS
.IP
.B .URL http://\[rs]:foo\[rs]:.org/ "foo" :
.RE
.
.IP
If this is processed by a device other than
.B \-Thtml
or
.B \-Txhtml
it appears as:
.RS
.IP
foo \[la]\f[CR]http://\:foo\:.org\f[]\[ra]:
.RE
.
.IP
The URL macro can be of any type;
for example, we can reference
.UR pic\:.html
Eric Raymond's
.I pic
guide
.UE
by:
.RS
.IP
.B .URL pic\[rs]:.html \[dq]Eric Raymond\[aq]s pic guide\[dq]
.RE
.
.TP
.B .MTO address [description] [after]
Generate an email HTML reference.
.
The first argument is mandatory as the email address.
.
The optional second argument is the text you see in your browser.
.
If an empty argument is given,
.B address
is used instead.
.
An optional third argument is stuff printed immediately afterwards.
.
Hyphenation is disabled while printing the actual email address.
.
For example,
.MT joe@user.org
Joe User
.ME
can be achieved by the following macro:
.RS
.IP
.B .MTO joe@user.org \[dq]Joe User\[dq]
.RE
.
.IP
Note that all the URLs actually are treated as consuming no textual
space in groff.
.
This could be considered as a bug since it causes some problems.
.
To circumvent this,
.B www.tmac
inserts a zero-width character which expands to a harmless space (only
if run with
.B \-Thtml
or
.BR \-Txhtml ).
.
.TP
.B .FTP url [description] [after]
indicates that data can be obtained via FTP.
.
The first argument is the URL and the second is the browser text.
.
A third argument, similar to the macros above, is intended for stuff
printed immediately afterwards.
.
The second and the third parameter are optional.
.
Hyphenation is disabled while printing the actual URL.
.
As an example, here is the location of the
.UR ftp://\:ftp\:.gnu\:.org/
GNU FTP server
.UE .
.
The macro example above can be specified as:
.RS
.IP
.B .FTP ftp://\[rs]:ftp\[rs]:.gnu\[rs]:.org/ \[dq]GNU FTP server\[dq] .
.RE
.
.TP
.B .TAG name
Generates an HTML name tag from its argument.
.
This can then be referenced using the
.UR #URL
URL
.UE
macro.
.
As you can see, you must precede the tag name with
.B #
since it is a local reference.
.
This link was achieved via placing a TAG in the URL description above;
the source looks like this:
.
.
.RS
.IP
.EX
\&.TP
\&.B URL
generates
\&.TAG URL
a URL using either two or three arguments.
\&.\|.\|.
.EE
.RE
.
.
.TP
.B .IMG [\-R|\-L|\-C] filename [width] [height]
Include a picture into the document.
.
The first argument is the horizontal location: right, left, or center
.RB ( \-R ,
.BR \-L ,
or
.BR \-C ).
.
Alignment is centered by default
.RB ( \-C ).
.
The second argument is the filename.
.
The optional third and fourth arguments are the width and height.
.
If the width is absent it defaults to 1\~inch.
.
If the height is absent it defaults to the width.
.
This maps onto an HTML img tag.
.
If you are including a PNG image then it is advisable to use the
.B PIMG
macro.
.
.TP
.B .PIMG [\-R|\-L|\-C] filename [width [height]]
Include an image in PNG format.
.
This macro takes exactly the same parameters as the
.B IMG
macro; it has the advantage of working with PostScript and HTML devices
also since it can automatically convert the image into the EPS format,
using the following programs of the
.B netpbm
package:
.BR pngtopnm ,
.BR pnmcrop ,
and
.BR pnmtops .
.
If the document isn't processed with
.B \-Thtml
or
.B \-Txhtml
it is necessary to use the
.B \-U
option of groff.
.
.TP
.B .MPIMG [\-R|\-L] [\-G gap] filename [width [height]]
Place a PNG image on the margin and wrap text around it.
.
The first parameters are optional.
.
The alignment: left or right
.RB ( \-L
or
.BR \-R )
specifies the margin where the picture is placed at.
.
The default alignment is left
.RB ( \-L ).
.
Optionally,
.BI \-G \~gap
can be used to arrange a gap between the picture and the text that
wraps around it.
.
The default gap width is zero.
.
.br
The first non-optional argument is the filename.
.
The optional following arguments are the width and height.
.
If the width is absent it defaults to 1\~inch.
.
If the height is absent it defaults to the width.
.
Example:
.
.
.RS
.IP
.EX
\&.MPIMG \-L \-G 2c foo.png 3c 1.5c
.EE
.RE
.
.
.IP
The height and width may also be given as percentages.
.
The PostScript device calculates the width from the
.B .l
register and the height from the
.B .p
register.
.
For example:
.
.
.RS
.IP
.EX
\&.MPIMG \-L \-G 2c foo.png 15%
.EE
.RE
.
.
.TP
.B .HnS n
Begin heading.
.
The numeric heading level
.I n
is specified by the first parameter.
.
Use this macro if your headings contain URL, FTP or MTO macros.
.
Example:
.
.
.RS
.IP
.EX
\&.HnS 1
\&.HR
GNU Troff
\&.URL https://\[rs]:www\[rs]:.gnu\[rs]:.org/\[rs]:software/\[rs]:groff/
\&\[rs][em]a
\&.URL http://www\[rs]:.gnu\[rs]:.org/ GNU
\&project.
\&.HR
\&.HnE
.EE
.RE
.
.
.IP
In this case you might wish to disable automatic links to headings.
.
This can be done via
.B \-P\-l
from the command line.
.\" or by using a call to \[lq].HX 0\[rq].
.
.
.TP
.B .HnE
End heading.
.
.
.TP
.B .LK
.TAG LK
Force
.I \%grohtml
to place the automatically generated links at this position.
.
If this manual page has been processed with
.B \-Thtml
or
.B \-Txhtml
those links can be seen right here.
.
.LK
.
.TP
.B .HR
Generate a full-width horizontal rule for
.B \-Thtml
and
.BR \-Txhtml .
.
No effect for all other devices.
.
.TP
.B .NHR
Suppress generation of the top and bottom rules which
.I \%grohtml
emits by default.
.
.TP
.B .HTL
Generate an HTML title only.
.
This differs from the
.B TL
macro of the
.B ms
macro package which generates both an HTML title and an <H1> heading.
.
Use it to provide an HTML title as search engine fodder but a graphic
title in the document.
.
The macro terminates when a space or break is seen (.sp, \&.br).
.
.TP
.B .HEAD
Add arbitrary HTML data to the <head> block.
.
Ignored if not processed with
.B \-Thtml
or
.BR \-Txhtml .
.
Example:
.
.
.RS
.IP
.EX
\&.HEAD \[dq]<link \[rs]
  rel=\[dq]\[dq]icon\[dq]\[dq] \[rs]
  type=\[dq]\[dq]image/png\[dq]\[dq] \[rs]
  href=\[dq]\[dq]http://foo.org//bar.png\[dq]\[dq]/>\[dq]
.EE
.RE
.
.
.TP
.B .HTML
All text after this macro is treated as raw HTML.
.
If the document is processed without
.B \-Thtml
or
.B \-Txhtml
then the macro is ignored.
.
Internally, this macro is used as a building block for other
higher-level macros.
.
.IP
For example, the
.B BGIMG
macro is defined as
.
.
.RS
.IP
.EX
\&.de BGIMG
\&.   HTML <body background=\[rs]\[rs]$1>
\&..
.EE
.RE
.
.
.TP
.B .DC l text [color]
Produce a drop capital.
.
The first parameter is the letter to be dropped and enlarged, the second
parameter
.B text
is the adjoining text whose height the first letter should not exceed.
.
The optional third parameter is the color of the dropped letter.
.
It defaults to black.
.
.TP
.B ".CDS"
Start displaying a code section in constant width font.
.
.TP
.B ".CDE"
End code display
.
.TP
.B ".ALN [color] [percentage]"
Place section heading links automatically to the left of the main text.
.
The color argument is optional and if present indicates which HTML
background color is to be used under the links.
.
The optional percentage indicates the amount of width to devote to
displaying the links.
.
The default values are #eeeeee and 30 for color and percentage width,
respectively.
.
This macro should only be called once at the beginning of the document.
.
After calling this macro each section heading emits an HTML table
consisting of the links in the left and the section text on the right.
.
.TP
.B ".LNS"
Start a new two-column table with links in the left column.
.
This can be called if the document has text before the first \&.SH and
if \&.ALN is used.
.
Typically this is called just before the first paragraph and after the
main title as it indicates that text after this point should be
positioned to the right of the left-hand navigational links.
.
.TP
.B ".LNE"
End a two-column table.
.
This should be called at the end of the document if \&.ALN was used.
.
.TP
.B ".LINKSTYLE color [ fontstyle [ openglyph closeglyph ] ]"
Initialize default URL attributes to be used if this macro set is not
used with the HTML device.
.
The macro set initializes itself with the following call
.
.
.RS
.IP
.EX
\&.LINKSTYLE blue CR \e[la] \e[ra]
.EE
.RE
.
.
.IP
but these values will be superseded by a user call to LINKSTYLE.
.
.
.\" ====================================================================
.SH "Section Heading Links"
.\" ====================================================================
.
By default
.I \%grohtml
generates links to all section headings and places these at the top of
the HTML document.
.
(See
.UR #LK
LINKS
.UE
for details of how to switch this off or alter the position).
.
.
.\" ====================================================================
.SH "Limitations of grohtml"
.\" ====================================================================
.
.LP
.B tbl
information is currently rendered as a PNG image.
.
.
.\" ====================================================================
.SH Files
.\" ====================================================================
.
.I @MACRODIR@/www.tmac
.
.
.\" ====================================================================
.SH Authors
.\" ====================================================================
.
The
.I www
macro package
was written by
.MT gaius@\:glam\:.ac\:.uk
Gaius Mulley
.ME ,
with additions by
.MT wl@\:gnu\:.org
Werner Lemberg
.ME
and
.MT groff\-bernd\:.warken\-72@\:web\:.de
Bernd Warken
.ME .
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
.IR groff (@MAN1EXT@),
.IR \%@g@troff (@MAN1EXT@),
.IR \%grohtml (@MAN1EXT@),
.IR netpbm (1)
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_groff_www_7_man_C]
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
