.TH xtotroff @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
xtotroff \- convert X font metrics into groff font metrics
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 2004-2020 Free Software Foundation, Inc.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_xtotroff_1_man_C \n[.cp]
.cp 0
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY xtotroff
.OP \-r resolution
.OP \-s point-size
.I font-map
.YS
.
.
.SY xtotroff
.B \-\-help
.YS
.
.
.SY xtotroff
.B \-v
.
.SY xtotroff
.B \-\-version
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
.I xtotroff
uses
.I font-map
to create
.IR groff (@MAN1EXT@)
font description files from X11 fonts.
.
Each line in
.I font-map
consists of a
.I groff
font name and an X font name as a X Logical Font Description (XLFD)
pattern,
separated by whitespace.
.
Example:
.
.
.PP
.RS
.EX
TB \-adobe\-times\-bold\-r\-normal\-\-*\-*\-*\-*\-p\-*\-iso8859\-1
.EE
.RE
.
.
.PP
The wildcards in the patterns are filled with the arguments to the
.B \-r
and
.B \-s
switches.
.
If a font name is still ambiguous,
.I xtotroff
aborts.
.
.
.\" ====================================================================
.SH Options
.\" ====================================================================
.
.B \-\-help
displays a usage message,
while
.B \-v
and
.B \-\-version
show version information;
all exit afterward.
.
.
.TP
.BI \-r\~ resolution
Set the resolution for all font patterns in
.IR font-map .
.
The value is used for both the horizontal and vertical resolution.
.
If not specified,
a resolution of 75dpi is assumed.
.
.
.TP
.BI \-s\~ point-size
Set the point size for all font patterns in
.IR font-map .
.
If not specified,
a size of 10 points is assumed.
.
.
.\" ====================================================================
.SH Bugs
.\" ====================================================================
.
The only supported font encodings are \[lq]iso8859\-1\[rq] and
\%\[lq]adobe\-\:fontspecific\[rq].
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
.IR groff (@MAN1EXT@),
.IR gxditview (@MAN1EXT@),
.IR troff (@MAN1EXT@)
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_xtotroff_1_man_C]
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
