.TH tfmtodit @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
tfmtodit \- adapt TeX Font Metrics files for groff \-Tdvi
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 1989-2020 Free Software Foundation, Inc.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_tfmtodit_1_man_C \n[.cp]
.cp 0
.
.
.\" ====================================================================
.\" Definitions
.\" ====================================================================
.
.ie t .ds tx T\h'-.1667m'\v'.224m'E\v'-.224m'\h'-.125m'X
.el .ds tx TeX
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY tfmtodit
.OP \-s
.OP \-g gf-file
.OP \-k skew-char
.I tfm-file
.I map-file
.I font
.YS
.
.
.SY tfmtodit
.B \-\-help
.YS
.
.
.SY tfmtodit
.B \-v
.
.SY tfmtodit
.B \-\-version
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
.I tfmtodit
creates a font file for use with the
.B dvi
output driver of
.IR groff (@MAN1EXT@).
.
.I tfm-file
is the name of the \*(tx font metric file for the font.
.
.I map-file
is a file giving the
.I groff
names for characters in the font;
this file should consist of a sequence of lines of the form
.
.RS
.IR "i c1" \~\&.\|.\|.\&\~ cn
.RE
.
where
.I i
is a decimal integer giving the position of the character in the font,
and
.I c1
through
.I cn
are
are the
.I groff
names of the character.
.
If a character has no
.I groff
names but exists in
.IR tfm-file ,
then it will be put in the
.I groff
font file as an unnamed character.
.
The
.I groff
font file is written to
.IR font .
.
.
.LP
The
.B \-s
option should be given if the font is \[lq]special\[rq],
meaning that
.I groff
should search it whenever a character is not found in the current font.
.
In that case,
.I font
should be listed as an argument to the
.B fonts
directive in the
.I DESC
file;
if it is not special,
there is no need to list it,
since
.I groff
can automatically mount it when it is first used.
.
.
.LP
To do a good job of math typesetting,
.I groff
requires font metric information not present in
.IR tfm-file .
.
This is because \*(tx has separate math italic fonts,
whereas
.I groff
uses normal italic fonts for math.
.
The additional information required by
.I groff
is given by the two arguments to the
.B math_fit
macro in the Metafont programs for the Computer Modern fonts.
.
In a text font (a font for which
.B math_fit
is false),
Metafont normally ignores these two arguments.
.
Metafont can be made to put this information into the GF
(\[lq]generic font\[rq])
files it produces by loading the following definition after
.B cmbase
when creating
.IR cm.base .
.
.RS
.EX
def ignore_math_fit(expr left_adjustment,right_adjustment) =
    special "adjustment";
    numspecial left_adjustment*16/designsize;
    numspecial right_adjustment*16/designsize;
    enddef;
.EE
.RE
.
.
.LP
For the EC font family,
load the following definition after
.BR exbase \[em]it
is probably easiest to patch
.I exbase.mf
locally.
.
.RS
.EX
def ignore_math_fit(expr left_adjustment,right_adjustment) =
    ori_special "adjustment";
    ori_numspecial left_adjustment*16/designsize;
    ori_numspecial right_adjustment*16/designsize;
    enddef;
.EE
.RE
.
The only difference from the previous example is the \[lq]ori_\[rq]
prefix to \[lq]special\[rq] and \[lq]numspecial\[rq].
.
.
.LP
The GF file created using this modified
.I cm.base
or
.I exbase.mf
should be specified with the
.B \-g
option,
which should
.I not
be given for a font for which
.B math_fit
is true.
.
.
.\" ====================================================================
.SH Options
.\" ====================================================================
.
.B \-\-help
displays a usage message,
while
.B \-v
and
.B \-\-version
show version information;
all exit afterward.
.
.
.TP
.BI \-g \~gf-file
Use the
.I gf-file
produced by Metafont containing
.RB \[lq] special \[rq]
and
numspecial
commands to obtain additional font metric information.
.
.
.TP
.BI \-k \~skew-char
The skew charcter of this font is at position
.IR skew-char .
.
.I skew-char
should be an integer;
it may be given in decimal,
with a leading 0 in octal,
or with a leading 0x in hexadecimal.
.
Any kerns whose second component is
.I skew-char
are ignored.
.
.
.TP
.B \-s
Add the
.B special
directive to the generated file
.IR font .
.
.
.\" ====================================================================
.SH Files
.\" ====================================================================
.
.TP
.I @FONTDIR@/devdvi/DESC
Device description file.
.
.TP
.IR @FONTDIR@/devdvi/ F
Font description file for font
.IR F .
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
.IR groff (@MAN1EXT@),
.IR grodvi (@MAN1EXT@),
.IR groff_font (@MAN5EXT@)
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_tfmtodit_1_man_C]
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
