.TH @g@indxbib @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
@g@indxbib \- make inverted index for bibliographic databases
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 1989-2020 Free Software Foundation, Inc.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_indxbib_1_man_C \n[.cp]
.cp 0
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY @g@indxbib
.OP \-w
.OP \-c common-words-file
.OP \-d dir
.OP \-f list-file
.OP \-h n
.OP \-i string
.OP \-k n
.OP \-l n
.OP \-n n
.OP \-o file
.OP \-t n
.RI [ file
\&.\|.\|.\&]
.YS
.
.
.SY @g@indxbib
.B \-\-help
.YS
.
.
.SY @g@indxbib
.B \-v
.
.SY @g@indxbib
.B \-\-version
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
.I \%@g@indxbib
makes an inverted index for the bibliographic databases in each
.I file
for use with
.IR \%@g@refer (@MAN1EXT@),
.IR \%@g@lookbib (@MAN1EXT@),
and
.IR \%lkbib (@MAN1EXT@).
.
Each created index is named
.RI file @INDEX_SUFFIX@ ;
writing is done to a temporary file which is then renamed to this.
.
If no
.I file
operands are given on the command line because the
.B \-f
option has been used,
and no
.B \-o
option is given,
the index will be named
.IR \%@DEFAULT_INDEX_NAME@@INDEX_SUFFIX@ .
.
.
.LP
Bibliographic databases are divided into records by blank lines.
.
Within a record,
each field starts with a
.B %
character at the beginning of a line.
.
Fields have a one letter name that follows the
.B %
character.
.
.
.LP
The values set by the
.BR \-c ,
.BR \-n ,
.BR \-l ,
and
.B \-t
options are stored in the index:
when the index is searched,
keys will be discarded and truncated in a
manner appropriate to these options;
the original keys will be used for verifying that any record
found using the index actually contains the keys.
.
This means that a user of an index need not know whether these
options were used in the creation of the index,
provided that not all the keys to be searched for
would have been discarded during indexing
and that the user supplies at least the part of each key
that would have remained after being truncated during indexing.
.
The value set by the
.B \-i
option is also stored in the index
and will be used in verifying records found using the index.
.
.
.\" ====================================================================
.SH Options
.\" ====================================================================
.
.B \-\-help
displays a usage message,
while
.B \-v
and
.B \-\-version
show version information;
all exit afterward.
.
.
.TP
.BI \-c\~ common-words-file
Read the list of common words from
.I file
instead of
.IR \%@COMMON_WORDS_FILE@ .
.
.
.TP
.BI \-d\~ dir
Use
.I dir
as the pathname of the current working directory to store in the index,
instead of the path printed by
.IR pwd (1).
.
Usually
.I dir
will be a symbolic link that points to the directory printed by
.IR pwd (1).
.
.
.TP
.BI \-f\~ list-file
Read the files to be indexed from
.IR file .
.
If
.I file
is
.BR \- ,
files will be read from the standard input.
.
The
.B \-f
option can be given at most once.
.
.
.TP
.BI \-i\~ string
Don't index the contents of fields whose names are in
.IR string .
.
Field names are one character each.
.
Initially,
.I string
is
.BR XYZ .
.
.
.TP
.BI \-h\~ n
Use the first prime greater than or equal to
.I n
for the size of the hash table.
.
Larger values of
.I n
will usually make searching faster,
but will make the index larger
and
.I \%@g@indxbib
use more memory.
.
Initially,
.I n
is 997.
.
.
.TP
.BI \-k\~ n
Use at most
.I n
keys per input record.
.
Initially,
.I n
is 100.
.
.
.TP
.BI \-l\~ n
Discard keys that are shorter than
.IR n .
.
Initially,
.I n
is 3.
.
.
.TP
.BI \-n\~ n
Discard the
.I n
most common words.
.
Initially,
.I n
is 100.
.
.
.TP
.BI \-o\~ basename
The index should be named
.RI basename @INDEX_SUFFIX@ .
.
.
.TP
.BI \-t\~ n
Truncate keys to
.IR n .
.
Initially,
.I n
is 6.
.
.
.TP
.B \-w
Index whole files.
.
Each file is a separate record.
.
.
.\" ====================================================================
.SH Files
.\" ====================================================================
.
.TP
.RI \%file @INDEX_SUFFIX@
Index.
.
.
.TP
.I \%@DEFAULT_INDEX_NAME@@INDEX_SUFFIX@
Default index name.
.
.
.TP
.I \%@COMMON_WORDS_FILE@
List of common words.
.
The traditional name,
.RI \[lq] eign \[rq],
is an abbreviation of \[lq]English ignored [word list]\[rq].
.
.
.TP
.IR \%indxbib XXXXXX
Temporary file.
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
\[lq]Some Applications of Inverted Indexes on the Unix System\[rq],
by M.\& E.\& Lesk,
1978,
AT&T Bell Laboratories Computing Science Technical Report No.\& 69.
.
.
.LP
.IR \%@g@refer (@MAN1EXT@),
.IR \%lkbib (@MAN1EXT@),
.IR \%@g@lookbib (@MAN1EXT@)
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_indxbib_1_man_C]
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
