'\" t
.TH @g@troff @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
@g@troff \- GNU troff document formatter
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 1989-2020 Free Software Foundation, Inc.
.\"
.\" This file is part of groff, the GNU roff type-setting system.
.\"
.\" Permission is granted to copy, distribute and/or modify this
.\" document under the terms of the GNU Free Documentation License,
.\" Version 1.3 or any later version published by the Free Software
.\" Foundation; with no Invariant Sections, with no Front-Cover Texts,
.\" and with no Back-Cover Texts.
.\"
.\" A copy of the Free Documentation License is included as a file
.\" called FDL in the main directory of the groff source package.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_troff_1_man_C \n[.cp]
.cp 0
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY @g@troff
.OP \-abcizCERU
.OP \-d cs
.OP \-f fam
.OP \-F dir
.OP \-I dir
.OP \-m name
.OP \-M dir
.OP \-n num
.OP \-o list
.OP \-r cn
.OP \-T name
.OP \-w name
.OP \-W name
.RI [ file
\&.\|.\|.\&]
.YS
.
.
.SY @g@troff
.B \-\-help
.YS
.
.
.SY @g@troff
.B \-v
.
.SY @g@troff
.B \-\-version
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
This manual page describes the GNU version of
.BR troff .
.
It is part of the groff document formatting system.
.
It is functionally compatible with Unix troff, but has many
extensions, see
.BR \%groff_diff (@MAN7EXT@).
.
Usually it should be invoked using the
.BR groff (@MAN1EXT@)
command which will also run preprocessors and postprocessors in the
appropriate order and with the appropriate options.
.
.
.\" ====================================================================
.SH Options
.\" ====================================================================
.
.
.TP
.B \-a
Generate an ASCII
(Unicode basic Latin)
approximation of the typeset output.
.
The read-only register
.B .A
is set to\~1.
.
On a system using the
.I man\-db
manual page formatter and that installs man pages compressed with
.IR gzip (1),
one might use the shell command
.
.RS
.RS
.EX
zcat $(man \-w troff) | groff \-a \-t \-man \-Tdvi | less
.EE
.RE
to observe how lines are broken for the DVI device.
.RE
.
.
.TP
.B \-b
Print a backtrace with each warning or error message.
.
This backtrace should help track down the cause of the error.
.
The line numbers given in the backtrace may not always be correct, for
.IR \%@g@troff 's
idea of line numbers gets confused by
.B .as
or
.B .am
requests.
.
.
.TP
.B \-c
Disable color output;
also disable SGR escape output to
.IR grotty (@MAN1EXT@)
devices.
.
.
.TP
.B \-C
Enable compatibility mode;
implies \-c.
.
.
.TP
.BI \-d cs
.TQ
.BI \-d name = s
Define
.I c
or
.I name
to be a string
.IR s ;
.I c
must be a one letter name.
.
.TP
.B \-E
Inhibit
.I \%@g@troff
error messages;
implies
.B \-Ww.
.
Note that this doesn't suppress messages sent to the standard error
stream by documents or macro packages using
.B .tm
or related requests.
.
.
.TP
.BI \-f fam
Use
.I fam
as the default font family.
.
.TP
.BI \-F dir
Search in directory (or directory path)
.I dir
for subdirectories
.IR dev name
.RI ( name
is the name of the device) and there for the
.I DESC
file and font files.
.
.I dir
is scanned before all other font directories.
.
.TP
.B \-i
Read the standard input after all the named input files have been
processed.
.
.TP
.BI \-I\~ dir
Search
.I dir
for files
(those on the command line,
those named in
.B .psbb
and
.B .so
requests,
and
those named in
.RB \[lq] "\[rs]X\[aq]ps: import\[aq]" \[rq],
.RB \[lq] "\[rs]X\[aq]ps: file\[aq]" \[rq],
and
.RB \[lq] "\[rs]X\[aq]pdf: pdfpic\[aq]" \[rq]
escapes).
.
This option may be specified more than once;
the directories are then searched in the order specified.
.
If you want to search the current directory before others,
add
.RB \[lq] "\-I .\&" \[rq]
at the appropriate place.
.
The current working directory is otherwise searched last.
.
.B \-I
works similarly to,
and is named for,
the \[lq]include\[rq]
option of Unix C compilers.
.
No directory search is performed for files specified using an absolute
file name.
.
.
.TP
.BI \-m name
Read in the file
.RI name .tmac .
.
If it isn't found, try
.IR tmac. name
instead.
.
It will be first searched for in directories given with the
.B \-M
command-line option, then in directories given in the
.I GROFF_TMAC_PATH
environment variable, then in the current directory (only if in unsafe
mode), the home directory,
.IR @SYSTEMMACRODIR@ ,
.IR @LOCALMACRODIR@ ,
and
.IR @MACRODIR@ .
.
.TP
.BI \-M dir
Search directory (or directory path)
.I dir
for macro files.
.
This is scanned before all other macro directories.
.
.TP
.BI \-n num
Number the first page
.IR num .
.
.TP
.BI \-o list
Output only pages in
.IR list ,
which is a comma-separated list of page ranges;
.I n
means print page
.IR n ,
.IB m \- n
means print every page between
.I m
and
.IR n ,
.BI \- n
means print every page up to
.IR n ,
.IB n \-
means print every page from
.IR n .
.
.I \%@g@troff
will exit after printing the last page in the list.
.
.TP
.BI \-r cn
.TQ
.BI \-r name = n
Set number register
.I c
or
.I name
to
.IR n ;
.I c
must be a one character name;
.I n
can be any
.I roff
numeric expression.
.
.TP
.B \-R
Don't load
.I troffrc
and
.IR troffrc\-end .
.
.
.TP
.BI \-T name
Prepare output for device
.IR name ,
rather than the default
.RB \[lq] @DEVICE@ \[rq];
see
.IR groff (@MAN1EXT@)
for a more detailed description.
.
.
.TP
.B \-U
Unsafe mode;
enables the
.BR .open ,
.BR .opena ,
.BR .pso ,
.BR .sy ,
and
.B .pi
requests.
.
For security reasons,
these potentially dangerous requests are disabled otherwise.
.
It will also add the current directory to the macro search path;
see
.B \-m
above.
.
.
.TP
.BI \-w name
Enable warning
.IR  name .
.
Available warnings are described in section \(lqWarnings\(rq below.
.
To enable most useful warnings use
.B \-w
.BR all .
To enable absolutely all warnings use
.B \-w w
instead.
Multiple
.B \-w
options are allowed.
.
.TP
.BI \-W name
Inhibit warning
.IR name .
.
Multiple
.B \-W
options are allowed.
.
.TP
.B \-z
Suppress formatted output.
.
.
.\" ====================================================================
.SH Warnings
.\" ====================================================================
.
The warnings that can be given by
.I \%@g@troff
are divided into the following categories.
.
The name associated with each warning is used by the
.B \-w
and
.B \-W
options; the number is used by the
.B warn
request, and by the
.B .warn
register; it is always a power of 2 to allow bitwise composition.
.
.P
.TS
tab(@), center, box;
c c c | c c c
r rI lB | r rI lB.
Bit@Code@Warning@Bit@Code@Warning
_
0@1@char@10@1024@reg
1@2@number@11@2048@tab
2@4@break@12@4096@right-brace
3@8@delim@13@8192@missing
4@16@el@14@16384@input
5@32@scale@15@32768@escape
6@64@range@16@65536@space
7@128@syntax@17@131072@font
8@256@di@18@262144@ig
9@512@mac@19@524288@color
@@@20@1048576@file
.TE
.
.P
.nr x \w'\fBright-brace'+1n+\w'00000'u
.ta \nxuR
.
.TP \nxu+3n
.BR break "\t4"
In fill mode, lines which could not be broken so that their length was
less than the line length.
.
This is enabled by default.
.
.TP
.BR char "\t1"
Non-existent characters.
.
This is enabled by default.
.
.TP
.BR color "\t524288"
Color-related warnings.
.
.TP
.BR delim "\t8"
Missing or mismatched closing delimiters.
.
.TP
.BR di "\t256"
Use of
.B di
or
.B da
without an argument when there is no current diversion.
.
.TP
.BR el "\t16"
Use of the
.B el
request with no matching
.B ie
request.
.
.TP
.BR escape "\t32768"
Unrecognized escape sequences.
.
When an unrecognized escape sequence is encountered, the escape
character is ignored.
.
.TP
.BR file "\t1048576"
Indicates a missing file for the
.B mso
request.
.
Enabled by default.
.
.TP
.BR font "\t131072"
Non-existent fonts.
.
This is enabled by default.
.
.TP
.BR ig "\t262144"
Invalid escapes in text ignored with the
.B ig
request.
.
These are conditions that are errors when they do not occur in ignored
text.
.
.TP
.BR input "\t16384"
Invalid input characters.
.
.TP
.BR mac "\t512"
Use of undefined strings, macros and diversions.
.
When an undefined string, macro or diversion is used, that string is
automatically defined as empty.
.
So, in most cases, at most one warning will be given for each name.
.
.TP
.BR missing "\t8192"
Requests that are missing non-optional arguments.
.
.TP
.BR number "\t2"
Invalid numeric expressions.
.
This is enabled by default.
.
.TP
.BR range "\t64"
Out of range arguments.
.
.TP
.BR reg "\t1024"
Use of undefined number registers.
.
When an undefined number register is used, that register is
automatically defined to have a value of\~0.
.
So, in most cases, at most one warning will be given for use of a
particular name.
.
.TP
.BR right-brace "\t4096"
Use of
.B \(rs}
where a number was expected.
.
.TP
.BR scale "\t32"
Meaningless scaling indicators.
.
.TP
.BR space "\t65536"
Missing space between a request or macro and its argument.
.
This warning will be given when an undefined name longer than two
characters is encountered, and the first two characters of the name
make a defined name.
.
The request or macro will not be invoked.
.
When this warning is given, no macro is automatically defined.
.
This is enabled by default.
.
This warning will never occur in compatibility mode.
.
.TP
.BR syntax "\t128"
Invalid syntax.
.
.TP
.BR tab "\t2048"
Inappropriate use of a tab character.
.
Either use of a tab character where a number was expected, or use of tab
character in an unquoted macro argument.
.
.P
There are also names that can be used to refer to groups of warnings:
.
.TP
.B all
All warnings except
.BR di ,
.BR mac ,
and
.BR reg .
.
It is intended that this covers all warnings that are useful with
traditional macro packages.
.
.TP
.B w
All warnings.
.
.
.\" ====================================================================
.SH Environment
.\" ====================================================================
.
.TP
.I GROFF_TMAC_PATH
A colon separated list of directories in which to search for
macro files.
.
.I \%@g@troff
will scan directories given in the
.B \-M
option before these, and in standard directories (current directory if
in unsafe mode, home directory,
.IR @SYSTEMMACRODIR@ ,
.IR @LOCALMACRODIR@ ,
.IR @MACRODIR@ )
after these.
.
.TP
.I GROFF_TYPESETTER
Default device.
.
.TP
.I GROFF_FONT_PATH
A colon separated list of directories in which to search for the
.IR dev name
directory.
.
.I \%@g@troff
will scan directories given in the
.B \-F
option before these, and in standard directories
.RI ( @LOCALFONTDIR@ ,
.IR @FONTDIR@ ,
.IR @LEGACYFONTDIR@ )
after these.
.
.
.\" ====================================================================
.SH Files
.\" ====================================================================
.
.TP
.I @MACRODIR@/troffrc
Initialization file (called before any other macro package).
.
.TP
.I @MACRODIR@/troffrc\-end
Initialization file (called after any other macro package).
.
.TP
.IR @MACRODIR@/ name .tmac
.TQ
.IR @MACRODIR@/tmac. name
Macro files
.
.TP
.IR @FONTDIR@/dev name /DESC
Device description file for device
.IR name .
.
.TP
.IR @FONTDIR@/dev name / F
Font file for font
.I F
of device
.IR name .
.
.
.P
Note that
.I troffrc
and
.I troffrc\-end
are searched for neither in the current nor the home directory by
default for security reasons (even if the
.B \-U
option is given).
.
Use the
.B \-M
command-line option or the
.I GROFF_TMAC_PATH
environment variable to add these directories to the search path if
necessary.
.
.
.\" ====================================================================
.SH Authors
.\" ====================================================================
.
The GNU version of
.I troff \" generic
was originally written by James Clark;
he also wrote the original version of this document,
which was modified by
.MT wl@\:gnu\:.org
Werner Lemberg
.ME
and
.MT groff\-bernd\:.warken\-72@\:web\:.de
Bernd Warken
.ME .
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
.TP
.BR groff (@MAN1EXT@)
The main program of the
.I groff
system, a wrapper around
.IR @g@troff .
.
.
.TP
.BR groff (@MAN7EXT@)
A description of the
.I groff
language, including a short but complete reference of all predefined
requests, registers, and escapes of plain
.IR groff .
.
From the command line, this is called by
.RS
.IP
.B man 7 groff
.RE
.
.TP
.IR groff_diff (@MAN7EXT@)
The differences of the
.I groff
language and the
.I classical troff
language.
.
Currently, this is the most actual document of the
.I groff
system.
.
.TP
.IR roff (@MAN7EXT@)
An overview over
.I groff
and other
.I roff
systems, including pointers to further related documentation.
.
.
.P
.IR "Groff: The GNU Implementation of troff" ,
by Trent A.\& Fisher and Werner Lemberg,
is the primary
.I groff
manual.
.
You can browse it interactively with \(lqinfo groff\(rq.
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_troff_1_man_C]
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
