.TH @g@nroff @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
@g@nroff \- format documents with groff for TTY (terminal) devices
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 1989-2020 Free Software Foundation, Inc.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_nroff_1_man_C \n[.cp]
.cp 0
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY @g@nroff
.RB [ \-cCEhipStUV ]
[\c
.BI \-d cs\c
]
[\c
.BI \-m name\c
]
[\c
.BI \-M dir\c
]
[\c
.BI \-n num\c
]
[\c
.BI \-o list\c
]
[\c
.BI \-P post-proc-option\c
]
[\c
.BI \-r cn\c
]
[\c
.BI \-T name\c
]
[\c
.BI \-w warning\c
]
[\c
.BI \-W warning\c
]
.RI [ file
\&.\|.\|.\&]
.YS
.
.
.SY @g@nroff
.B \-\-help
.YS
.
.
.SY @g@nroff
.B \-v
.
.SY @g@nroff
.B \-\-version
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
.I \%@g@nroff
formats documents written in the
.IR roff (@MAN7EXT@)
language for typewriter-like devices such as terminal emulators.
.
GNU
.I nroff \" GNU
emulates the AT&T
.I nroff \" AT&T
command using
.IR groff (@MAN1EXT@).
.
.I \%@g@nroff
generates output via
.IR grotty (@MAN1EXT@),
.IR groff 's
terminal output driver,
which needs to know the character encoding scheme used by the device.
.
Consequently,
acceptable arguments to the
.B \-T
option are
.BR ascii ,
.BR latin1 ,
.BR utf8 ,
and
.BR cp1047 ;
any others are ignored.
.
If neither the
.I \%GROFF_TYPESETTER
environment variable nor the
.B \-T
command-line option
(which overrides the environment variable)
specifies a (valid) device,
.I \%@g@nroff
consults the locale to select an appropriate output device.
.
It first tries the
.IR locale (1)
program,
then checks several locale-related environment variables;
see section \[lq]Environment\[rq], below.
.
If all of the foregoing fail,
.B \-Tascii
is implied.
.
.
.P
Whitespace is
.I not
permitted between an option and its argument.
.
The
.BR \-C ,
.BR \-d ,
.BR \-E ,
.BR \-i ,
.BR \-m ,
.BR \-M ,
.BR \-n ,
.BR \-o ,
.BR \-P ,
.BR \-r ,
.BR \-w ,
and
.B \-W
options have the effect described in
.IR \%@g@troff (@MAN1EXT@).
.
.B \-c
and
.B \-h
are equivalent to
.RB \[lq] \-P\-c \[rq]
and
.RB \[lq] \-P\-h \[rq],
respectively.
.
In addition,
this implementation ignores the AT&T
.I nroff \" AT&T
options
.BR \-e ,
.BR \-q ,
and
.B \-s
(which are not implemented in
.IR groff ).
.
The options
.B \-p
(pic),
.B \-t
.RB ( tbl ),
.B \-S
(safer),
and
.B \-U
(unsafe) are passed to
.IR groff .
.
.B \-V
causes
.I \%@g@nroff
to display the constructed
.I groff
command on the standard output,
but does not execute it.
.
.B \-v
and
.B \-\-version
show version information,
while
.B \-\-help
displays a usage message;
all exit afterward.
.
.
.\" ====================================================================
.SH Environment
.\" ====================================================================
.
.TP
.I GROFF_BIN_PATH
is a colon-separated list of directories in which to search for the
.I groff
executable before searching in
.IR PATH .
.
If unset,
.I \%@BINDIR@
is used.
.
.
.TP
.I GROFF_TYPESETTER
specifies the default output device for
.IR groff .
.
.
.TP
.I LC_ALL
.TQ
.I LC_CTYPE
.TQ
.I LANG
.TQ
.I LESSCHARSET
are pattern-matched in this order for contents matching standard
character encodings supported by
.I groff
in the event no
.B \-T
option is given and
.I \%GROFF_TYPESETTER
is unset.
.
.
.\" ====================================================================
.SH Notes
.\" ====================================================================
.
.P
Pager programs like
.IR more (1)
and
.IR less (1)
may require command-line options to correctly handle some output
sequences;
see
.IR \%grotty (@MAN1EXT@).
.
.
.P
Character definitions in the file
.I \%@MACRODIR@/\:tty\-char\:.tmac
are loaded to replace unrepresentable glyphs.
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
.IR groff (@MAN1EXT@),
.IR \%@g@troff (@MAN1EXT@),
.IR grotty (@MAN1EXT@),
.IR locale (1),
.IR roff (@MAN7EXT@)
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_nroff_1_man_C]
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
