.TH grog @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
grog \- \(lqgroff guess\(rq\(eminfer a document's groff command
.
.
.\" TODO: This page needs a thorough edit by a fluent English speaker.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 1989-2020 Free Software Foundation, Inc.
.\"
.\" This file is part of grog, which is part of groff, a free software
.\" project.  You can redistribute it and/or modify it under the terms
.\" of the GNU General Public License version 2 (GPL2) as published by
.\" the Free Software Foundation.
.\"
.\" groff is distributed in the hope that it will be useful, but WITHOUT
.\" ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
.\" or FITNESS FOR A PARTICULAR PURPOSE.
.\"
.\" The text for GPL2 is available in the internet at
.\" <http://www.gnu.org/licenses/gpl2.0.txt>.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_grog_1_man_C \n[.cp]
.cp 0
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY grog
.OP \-C
.OP \-T device
.OP \-\-run
.OP \-\-warnings
.OP \-\-ligatures
.RI [ groff-option
\&.\|.\|.\&]
.OP \-\-
.RI [ file
\&.\|.\|.]
.YS
.
.
.SY grog
.B \-h
.
.SY grog
.B \-\-help
.YS
.
.
.SY grog
.B \-v
.
.SY grog
.B \-\-version
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
.I grog
reads the input (file names or standard input) and guesses which of
the
.IR groff (@MAN1EXT@)
options are needed to perform the input with the
.I groff
program.
.
.
.P
If no operands are given,
or if
.I file
is
.RB \[lq] \- \[rq],
.I @g@chem
reads the standard input stream.
.
.
.P
A suitable device is now always written as
.BI \-T device
including the
.I groff
default of
.BR "\-T ps" .
.
.
.P
The corresponding
.I groff
command is usually displayed in standard output.
.
With the option
.BR \-\-run ,
the generated line is output into standard error and the generated
.I groff
command is run on the
.IR "standard output" .
.
.
.\" ====================================================================
.SH Options
.\" ====================================================================
.
.B \-h
and
.B \-\-help
display a usage message,
whereas
.B \-v
and
.B \-\-version
display version information;
all exit afterward.
.
.
.TP
.B \-C
this option means enabling the
.I groff
compatibility mode, which is also transfered to the generated
.I groff
command line.
.
.TP
.B \-\-ligatures
this option forces to include the arguments
.B \-P\-y \-PU
within the generated
.B groff
command line.
.
.
.TP
.B \-\-run
with this option, the command line is output at standard error and
then run on the computer.
.
.
.TP
.B \-\-warnings
with this option, some more warnings are output to standard error.
.
.
.P
All other specified short options (words starting with one minus
character
.BR \- )
are interpreted as
.I groff
options or option clusters with or without argument.
.
No space is allowed between options and their argument.
.
Except from the
.BI \-m arg
options, all options will be passed on, i.e.\& they are included
unchanged in the command for the output without effecting the work of
.IR grog .
.
.
.\" ====================================================================
.SH Details
.\" ====================================================================
.
.I grog
reads all
.I file
parameters as a whole.
.
It tries to guess which of the following
.I groff
options are required for running the input under
.IR groff :
.BR \-e ,
.BR \-g ,
.BR \-G ,
.BR \-j ,
.\" gideal is not implemented yet.
.\" .BR \-J ,
.BR \-p ,
.BR \-R ,
.BR \-s ,
.B \-t
(preprocessors); and
.BR \-man ,
.BR \-mdoc ,
.BR \-mdoc\-old ,
.BR \-me ,
.BR \-mm ,
.BR \-mom ,
and
.B \-ms
(macro packages).
.
.
.P
The guessed
.I groff
command including those options and the found
.I file
parameters is put on the standard output.
.
.
.P
It is possible to specify arbitrary
.I groff
options on the command line.
.
These are passed on the output without change, except for the
.BI \-m arg
options.
.
.
.P
The
.I groff
program has trouble when the wrong
.BI \-m arg
option or several of these options are specified.
.
In these cases,
.I grog
will print an error message and exit with an error code.
.
It is better to specify no
.BI \-m arg
option.
.
Because such an option is only accepted and passed when
.B grog
does not find any of these options or the same option is found.
.
.
.P
If several different
.BI \-m arg
options are found by
.I grog
an error message is produced and the program is terminated with an
error code.
.
But the output is written with the wrong options nevertheless.
.
.
.P
Remember that it is not necessary to determine a macro package.
.
A
.I roff
file can also be written in the
.I groff
language without any macro package.
.
.I grog
will produce an output without an
.BI \-m arg
option.
.
.
.P
As
.I groff
also works with pure text files without any
.I roff
requests,
.B grog
cannot be used to identify a file to be a
.I roff
file.
.
.
.P
.\" ====================================================================
.SH Example
.\" ====================================================================
.
Calling
.RS
.EX
grog meintro.me
.EE
.RE
results in
.RS
.EX
groff \-me meintro.me
.EE
.RE
.
So
.I grog
recognized that the file
.B meintro.me
is written with the
.B \-me
macro package.
.RE
.
.
On the other hand,
.RS
.EX
grog pic.ms
.EE
.RE
.
outputs
.
.RS
.EX
groff \-p \-t \-e \-ms pic.ms
.EE
.RE
.
Besides determining the macro package
.BR \-ms ,
.I grog
recognized that the file
.B pic.ms
additionally needs
.BR \-pte ,
the combination of
.B \-p
for
.IR pic ,
.B \-t
for
.IR tbl ,
and
.B \-e
for
.IR eqn .
.RE
.
.
If both of the former example files are combined by the command
.
.RS
.EX
grog meintro.me pic.ms
.EE
.RE
.
an error message is sent to standard error because
.I groff
cannot work with two different macro packages:
.
.RS
.ft CR
grog: error: there are several macro packages: \-me \-ms
.ft
.RE
.
Additionally the corresponding output with the wrong options is printed
to standard output:
.
.RS
.EX
groff \-pte \-me \-ms meintro.me pic.ms
.EE
.RE
.
But the program is terminated with an error code.
.
.
The call of
.
.RS
.EX
grog \-ksS \-Tdvi grnexmpl.g
.EE
.RE
.
contains several
.I groff
options that are just passed on the output without any interface to
.IR grog .
These are the option cluster
.B \-ksS
consisting of
.BR \-k ,
.BR \-s ,
and
.BR \-S ;
and the option
.B \-T
with argument
.BR dvi .
The output is
.
.RS
.EX
groff \-k \-s \-S \-Tdvi grnexmpl.g
.EE
.RE
.
so no additional option was added by
.IR grog .
As no option
.BI \-m arg
was found by
.I grog
this file does not use a macro package.
.
.
.\" ====================================================================
.SH Authors
.\" ====================================================================
.
.I grog
was originally written by James Clark.
.
The current Perl implementation was written by
.MT groff\-bernd\:.warken\-72@\:web\:.de
Bernd Warken
.ME
with contributions from Ralph Corderoy.
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
.IR groff (@MAN1EXT@)
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_grog_1_man_C]
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
