.TH groff @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
groff \- front-end for the GNU roff document formatting system
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 1989-2020 Free Software Foundation, Inc.
.\"
.\" This file is part of groff, the GNU roff type-setting system.
.\"
.\" Permission is granted to copy, distribute and/or modify this
.\" document under the terms of the GNU Free Documentation License,
.\" Version 1.3 or any later version published by the Free Software
.\" Foundation; with no Invariant Sections, with no Front-Cover Texts,
.\" and with no Back-Cover Texts.
.\"
.\" A copy of the Free Documentation License is included as a file
.\" called FDL in the main directory of the groff source package.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_groff_1_man_C \n[.cp]
.cp 0
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY groff
.OP \-abcegijklpstzCEGNRSUVXZ
.OP \-d cs
.OP \-D arg
.OP \-f fam
.OP \-F dir
.OP \-I dir
.OP \-K arg
.OP \-L arg
.OP \-m name
.OP \-M dir
.OP \-n num
.OP \-o list
.OP \-P arg
.OP \-r cn
.OP \-T dev
.OP \-w name
.OP \-W name
.RI [ file
\&.\|.\|.\&]
.YS
.
.
.SY groff
.B \-h
.
.SY groff
.B \-\-help
.YS
.
.
.SY groff
.B \-v
.RI [ option
\&.\|.\|.\&]
.
.SY groff
.B \-\-version
.RI [ option
\&.\|.\|.\&]
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
This document describes the
.B groff
program, the main front-end for the
.I groff
document formatting system.
.
The
.I groff
program and macro suite is the implementation of a
.BR roff (@MAN7EXT@)
system within the free software collection
.UR http://\:www\:.gnu\:.org/
GNU
.UE .
.
The
.I groff
system has all features of the classical
.IR roff ,
but adds many extensions.
.
.
.P
The
.B groff
program allows control of the whole
.I groff
system by command-line options.
.
This is a great simplification in comparison to the classical case
(which uses pipes only).
.
.
.\" ====================================================================
.SH Options
.\" ====================================================================
.
.B \-\-help
displays a usage message and exits.
.
.
.P
As
.B groff
is a wrapper program for
.I \%@g@troff
both programs share a set of options.
.
But the
.B groff
program has some additional, native options and gives a new meaning to
some
.I \%@g@troff
options.
.
On the other hand, not all
.I \%@g@troff
options can be fed into
.BR groff .
.
.
.\" ====================================================================
.SS "Native groff options"
.\" ====================================================================
.
The following options either do not exist for
.I \%@g@troff
or are differently interpreted by
.BR groff .
.
.
.TP
.BI \-D\  arg
Set default input encoding used by
.B preconv
to
.IR arg .
.
Implies
.BR \-k .
.
.
.TP
.B \-e
Preprocess with
.IR \%@g@eqn .
.
.
.TP
.B \-g
Preprocess with
.IR \%@g@grn .
.
.
.TP
.B \-G
Preprocess with
.BR grap .
.
Implies
.BR \-p .
.
.
.TP
.BI \-I\~ dir
Works as
.IR \%@g@troff 's
option
(see below),
but also implies
.B \-s
and passes the
.B \-I
options to
.IR soelim .
.
.
.TP
.B \-j
Preprocess with
.IR \%@g@chem .
.
Implies
.BR \-p .
.
.
.TP
.B \-k
Preprocess with
.BR preconv .
.
This is run before any other preprocessor.
.
Please refer to
.BR preconv 's
manual page for its behaviour if no
.B \-K
(or
.BR \-D )
option is specified.
.
.
.TP
.BI \-K\  arg
Set input encoding used by
.B preconv
to
.IR arg .
.
Implies
.BR \-k .
.
.
.TP
.B \-l
Send the output to a spooler program for printing.
.
The command that should be used for this is specified by the
.B print
command in the device description file, see
.BR \%groff_font (@MAN5EXT@).
.
If this command is not present, the output is piped into the
.BR lpr (1)
program by default.
.
See options
.B \-L
and
.BR \-X .
.
.
.TP
.BI \-L\  arg
Pass
.I arg
to the spooler program.
.
Several arguments should be passed with a separate
\-L
option each.
.
Note that
.B groff
does not prepend
\[oq]\-\[cq]
(a minus sign) to
.I arg
before passing it to the spooler program.
.
.
.TP
.B \-N
Don't allow newlines within
.I eqn
delimiters.
.
This is the same as the
.B \-N
option in
.IR \%@g@eqn .
.
.
.TP
.B \-p
Preprocess with
.IR \%@g@pic .
.
.
.TP
.BI \-P\~ arg
.TQ
.BI "\-P \-" option
.TQ
.BI "\-P \-" option\~ \-P\~ arg
Pass arguments to the postprocessor.
.
.
.IP
Each command-line
.I option
to a postprocessor must be specified with any required leading dashes
.RB \[lq] \- \[rq]
.\" No GNU roff postprocessor uses long options for anything except
.\" --help or --version.
.\"or
.\".RB \[lq] \-\- \[rq]
because
.I groff
passes the arguments as-is to the postprocessor;
this permits arbitrary arguments to be transmitted.
.
For example,
to pass a title to the
.I gxditview
postprocessor,
the shell command
.
.RS
.RS
.EX
.B groff \-X \-P \-title \-P \[aq]trial run\[aq] mydoc.t
.EE
.RE
.
is equivalent to
.
.RS
.EX
.B groff \-X \-Z mydoc.t | gxditview \-title \[aq]trial run\[aq] \-
.EE
.RE
.RE
.
.
.TP
.B \-R
Preprocess with
.IR \%@g@refer .
.
No mechanism is provided for passing arguments to
.I \%@g@refer
because most
.I \%@g@refer
options have equivalent language elements that can be specified within
the document.
.
See
.BR \%@g@refer (@MAN1EXT@)
for more details.
.
.
.TP
.B \-s
Preprocess with
.IR \%@g@soelim .
.
.
.TP
.B \-S
Safer mode.
.
Pass the
.B \-S
option to
.I \%@g@pic
and disable the following
.I \%@g@troff
requests:
.BR .open ,
.BR .opena ,
.BR .pso ,
.BR .sy ,
and
.BR .pi .
.
For security reasons, safer mode is enabled by default.
.
.
.TP
.B \-t
Preprocess with
.IR \%@g@tbl .
.
.
.TP
.BI \-T\  dev
Set output device to
.IR dev .
.
For this device,
.I \%@g@troff
generates the
.I intermediate
.IR output ;
see
.BR \%groff_out (@MAN5EXT@).
.
Then
.B groff
calls a postprocessor to convert
.IR \%@g@troff 's
.I intermediate output
to its final format.
.
Real devices in
.B groff
are
.
.RS
.RS
.TP
dvi
TeX DVI format (postprocessor is
.BR grodvi ).
.
.TP
html
.TQ
xhtml
HTML and XHTML output (preprocessors are
.I \%@g@soelim
and
.BR \%pre-grohtml ,
postprocessor is
.BR \%post-grohtml ).
.
.TP
lbp
Canon CAPSL printers (\%LBP-4 and \%LBP-8 series laser printers;
postprocessor is
.BR grolbp ).
.
.TP
lj4
HP LaserJet4-compatible
(or other PCL5-compatible)
printers
(postprocessor
is
.BR grolj4 ).
.
.TP
ps
PostScript output (postprocessor is
.BR grops ).
.
.TP
pdf
Portable Document Format (PDF) output (postprocessor is
.BR gropdf ).
.RE
.RE
.
.
.IP
For the following TTY output devices (postprocessor is always
.BR grotty ),
.B \-T
selects the output encoding:
.
.RS
.RS
.TP
ascii
7bit \f[CR]ASCII\f[].
.
.TP
cp1047
\%Latin-1 character set for EBCDIC hosts.
.
.TP
latin1
ISO \%8859-1.
.
.TP
utf8
Unicode character set in \%UTF-8 encoding.
.
This mode has the most useful fonts for TTY mode, so it is the best
mode for TTY output.
.RE
.RE
.
.
.IP
The following arguments select
.B \%gxditview
as the \[oq]postprocessor\[cq] (it is rather a viewing program):
.
.RS
.RS
.TP
X75
75\|dpi resolution, 10\|pt document base font.
.TP
X75\-12
75\|dpi resolution, 12\|pt document base font.
.TP
X100
100\|dpi resolution, 10\|pt document base font.
.TP
X100\-12
100\|dpi resolution, 12\|pt document base font.
.RE
.RE
.
.IP
The default device is
.BR @DEVICE@ .
.
.
.TP
.B \-U
Unsafe mode.
.
Reverts to the (old) unsafe behaviour; see option
.BR \-S .
.
.
.TP
.B \-v
.TQ
.B \-\-version
Output version information of
.B groff
and of all programs that are run by it; that is, the given command line
is parsed in the usual way, passing
.B \-v
to all subprograms.
.
.
.TP
.B \-V
Output the pipeline that would be run by
.B groff
(as a wrapper program) on the standard output, but do not execute it.
.
If given more than once,
the commands are both printed on the standard error and run.
.
.
.TP
.B \-X
Use
.B \%gxditview
instead of using the usual postprocessor to (pre)view a document.
.
The printing spooler behavior as outlined with options
.B \-l
and
.B \-L
is carried over to
.BR \%gxditview (@MAN1EXT@)
by determining an argument for the
.B \-printCommand
option of
.BR \%gxditview (@MAN1EXT@).
.
This sets the default
.B Print
action and the corresponding menu entry to that value.
.
.B \-X
only produces good results with
.BR \-Tps ,
.BR \-TX75 ,
.BR \-TX75\-12 ,
.BR \-TX100 ,
and
.BR \-TX100\-12 .
.
The default resolution for previewing
.B \-Tps
output is 75\|dpi; this can be changed by passing the
.B \-resolution
option to
.BR \%gxditview ,
for example
.
.RS
.IP
.EX
groff \-X \-P\-resolution \-P100 \-man foo.1
.EE
.RE
.
.
.TP
.B \-z
Suppress output generated by
.IR \%@g@troff .
.
Only error messages are printed.
.
.
.TP
.B \-Z
Do not automatically postprocess
.I groff intermediate output
in the usual manner.
.
This will cause the
.I \%@g@troff
.I output
to appear on standard output,
replacing the usual postprocessor output; see
.BR \%groff_out (@MAN5EXT@).
.
.
.\" ====================================================================
.SS "Transparent options"
.\" ====================================================================
.
The following options are transparently handed over to the formatter
program
.I \%@g@troff
that is called by
.B groff
subsequently.
.
These options are described in more detail in
.IR \%@g@troff (@MAN1EXT@).
.
.TP
.B \-a
Generate an ASCII
(Unicode basic Latin)
approximation of the typeset output.
.
.
.TP
.B \-b
Backtrace on error or warning.
.
.TP
.B \-c
Disable color output.
.
Please consult the
.BR \%grotty (@MAN1EXT@)
man page for more details.
.
.TP
.B \-C
Enable compatibility mode.
.
.TP
.BI \-d\  cs
.TQ
.BI \-d\  name = s
Define string.
.
.TP
.B \-E
Inhibit
.I \%@g@troff
error messages;
implies
.BR \-Ww .
.
.
.TP
.BI \-f\  fam
Set default font family.
.
.TP
.BI \-F\  dir
Set path for device
.I DESC
files.
.
.TP
.BI \-I\~ dir
Search
.I dir
for files
(those on the command line,
those named in
.B .psbb
and
.B .so
requests,
and
those named in certain device commands issued with the
.B \[rs]X
escape).
.
.
.TP
.B \-i
Process standard input after the specified input files.
.
.TP
.BI \-m\  name
Include macro file
.RI name .tmac
(or
.IR tmac. name);
see also
.BR \%groff_tmac (@MAN5EXT@).
.
.TP
.BI \-M\  dir
Path for macro files.
.
.TP
.BI \-n\  num
Number the first page
.IR num .
.
.TP
.BI \-o\  list
Output only pages in
.IR list .
.
.TP
.BI \-r\  cn
.TQ
.BI \-r\  name = n
Set number register.
.
.TP
.BI \-w\  name
Enable warning
.IR name .
.
See
.IR \%@g@troff (@MAN1EXT@)
for names.
.
.TP
.BI \-W\  name
disable warning
.IR name .
.
See
.IR \%@g@troff (@MAN1EXT@)
for names.
.
.
.\" ====================================================================
.SH "Using groff"
.\" ====================================================================
.
The
.I groff system
implements the infrastructure of classical roff; see
.BR roff (@MAN7EXT@)
for a survey on how a
.I roff
system works in general.
.
Due to the front-end programs available within the
.I groff
system, using
.I groff
is much easier than
.IR "classical roff" .
.
This section gives an overview of the parts that constitute the
.I groff
system.
.
It complements
.BR roff (@MAN7EXT@)
with
.IR groff -specific
features.
.
This section can be regarded as a guide to the documentation around
the
.I groff
system.
.
.
.\" ====================================================================
.SS "Paper size"
.\" ====================================================================
.
The
.I virtual
paper size used by
.B troff
to format the input is controlled globally with the requests
.BR .po ,
.BR .pl ,
and
.BR .ll .
.
See
.BR groff_tmac (@MAN5EXT@)
for the \[oq]papersize\[cq] macro package which provides a convenient
interface.
.
.
.P
The
.I physical
paper size, giving the actual dimensions of the paper sheets, is
controlled by output devices like
.B grops
with the command-line options
.B \-p
and
.BR \-l .
.
See
.BR groff_font (@MAN5EXT@)
and the man pages of the output devices for more details.
.
.B groff
uses the command-line option
.B \-P
to pass options to output devices; for example, the following selects
A4 paper in landscape orientation for the PS device:
.
.IP
.EX
groff \-Tps \-P\-pa4 \-P\-l ...
.EE
.
.
.\" ====================================================================
.SS Front-ends
.\" ====================================================================
.
The
.B groff
program is a wrapper around the
.IR \%@g@troff (@MAN1EXT@)
program.
.
It allows one to specify the preprocessors by command-line options and
automatically runs the postprocessor that is appropriate for the
selected device.
.
Doing so, the sometimes tedious piping mechanism of classical
.BR roff (@MAN7EXT@)
can be avoided.
.
.
.P
The
.BR grog (@MAN1EXT@)
program can be used for guessing the correct
.I groff
command line to format a file.
.
.
.\" ====================================================================
.SS Preprocessors
.\" ====================================================================
.
The
.I groff
preprocessors are reimplementations of the classical preprocessors
with moderate extensions.
.
The standard preprocessors distributed with the
.I groff
package are
.
.TP
.IR \%@g@eqn (@MAN1EXT@)
for mathematical formulae,
.
.TP
.IR \%@g@grn (@MAN1EXT@)
for including
.BR gremlin (1)
pictures,
.
.TP
.IR \%@g@pic (@MAN1EXT@)
for drawing diagrams,
.
.TP
.IR \%@g@chem (@MAN1EXT@)
for chemical structure diagrams,
.
.TP
.BR \%@g@refer (@MAN1EXT@)
for bibliographic references,
.
.TP
.BR \%@g@soelim (@MAN1EXT@)
for including macro files from standard locations,
.
.P
and
.
.TP
.IR \%@g@tbl (@MAN1EXT@)
for tables.
.
.P
A new preprocessor not available in classical
.I troff
is
.BR \%preconv (@MAN1EXT@)
which converts various input encodings to something
.B groff
can understand.
.
It is always run first before any other preprocessor.
.
.P
Besides these, there are some internal preprocessors that are
automatically run with some devices.
.
These aren't visible to the user.
.
.
.\" ====================================================================
.SS "Macro packages"
.\" ====================================================================
.
Macro packages can be included in a
.I roff
document by using option
.BR \-m .
.
The
.I groff
system implements most well-known macro packages for AT&T
.I troff
.\" exceptions: mpm, mv
in a compatible way,
extends them,
and adds some packages of its own.
.
Several of them have one- or two-letter names due to the intense sense
of naming economy practiced in early Unix culture.
.
This laconic approach led to many of the packages being identified in
general usage with the
.I nroff
and
.I troff
option letter used to invoke them,
sometimes to punning effect,
as with \[lq]man\[rq]
(short for \[lq]manual\[rq])
and even with the option dash,
as in the case of the
.I s
package,
much better known as
.I ms
or even
.IR \-ms .
.
.
.P
Available macro packages include:
.
.
.TP
.I an
is the man page formatter originating in Version\~7 Unix (1979);
see
.IR groff_man (@MAN7EXT@).
.
It can be specified on the command line as
.B \-man
or
.BR \-m\~man .
.
.
.TP
.I doc
is the man page formatter originating in 4.3BSD-Reno (1990);
see
.IR groff_mdoc (@MAN7EXT@).
.
It can be specified on the command line as
.B \-mdoc
or
.BR \-m\~mdoc .
.
.
.TP
.I andoc
is a wrapper that automatically recognizes whether a document uses
.I man
or
.I mdoc
format and branches to the corresponding macro package.
.
It can be specified on the command line as
.B \%\-mandoc
or
.BR \-m\~\%mandoc .
.
.
.TP
.I e
is the BSD general-purpose
document formatter;
see
.IR groff_me (@MAN7EXT@).
.
It can be specified on the command line as
.B \-me
or
.BR \-m\~me .
.
.
.TP
.I m
is the second-generation AT&T general-purpose
document formatter;
see
.IR groff_mm (@MAN7EXT@).
.
It can be specified on the command line as
.B \-mm
or
.BR \-m\~mm .
.
.
.TP
.I om
(invariably called \[lq]mom\[rq])
is a modern package written by Peter Schaffter specifically for
.I groff.
.
Consult the
.UR https://\:www\:.schaffter\:.ca/\:mom/
mom home page
.UE
for extensive documentation.
.
She\[em]for
.I mom
takes the female pronoun\[em]can be specified on the command line as
.B \-mom
or
.BR \-m\~mom . \" along with -m om and -mmom...
.
.
.TP
.I s
is the original AT&T general-purpose
.I ms
document formatter; see
.BR groff_ms (@MAN7EXT@).
.
It can be specified on the command line as
.B \-ms
or
.BR \-m\~ms .
.
.
.TP
.I www
is a supplemental package providing
HTML-like macros for inclusion in arbitrary
.I groff
documents;
see
.IR groff_www (@MAN7EXT@).
.
.P
Details on the naming of macro files and their placement can be found
in
.IR groff_tmac (@MAN5EXT@);
this page also documents some other,
minor auxiliary macro packages not mentioned here.
.
.
.\" ====================================================================
.SS "Programming language"
.\" ====================================================================
.
General concepts common to all
.I roff
programming languages are described in
.BR roff (@MAN7EXT@).
.
.
.P
The
.I groff
extensions to the classical
.I troff
language are documented in
.BR \%groff_diff (@MAN7EXT@).
.
.
.P
An overview of language features,
including all supported escapes and requests,
can be found in
.BR groff (@MAN7EXT@).
.
.
.\" ====================================================================
.SS Formatters
.\" ====================================================================
.
The central
.I roff
formatter within the
.I groff
system is
.IR \%@g@troff (@MAN1EXT@).
.
It provides the features of both the classical
.I troff
and
.IR nroff ,
as well as the
.I groff
extensions.
.
The command-line option
.B \-C
switches
.I \%@g@troff
into
.I "compatibility mode"
which tries to emulate classical
.I roff
as much as possible.
.
.
.P
There is a shell script
.IR \%@g@nroff (@MAN1EXT@)
that emulates the behavior of classical
.BR nroff .
.
It tries to automatically select the proper output encoding,
according to the current locale.
.
.
.P
The formatter program generates a device-independent,
but not device-agnostic,
intermediate output format,
documented in
.IR groff_out (@MAN5EXT@).
.
.
.\" ====================================================================
.SS Devices
.\" ====================================================================
.
In
.IR roff ,
the output targets are called
.IR devices .
A device can be a piece of hardware, e.g., a printer, or a software
file format.
.
A device is specified by the option
.BR \-T .
.
The
.I groff
devices are as follows.
.
.TP
.B ascii
Text output using the
.BR ascii (7)
character set.
.
.TP
.B cp1047
Text output using the EBCDIC code page IBM cp1047 (e.g., OS/390 Unix).
.
.TP
.B dvi
TeX DVI format.
.
.TP
.B html
HTML output.
.
.TP
.B latin1
Text output using the ISO \%Latin-1 (ISO \%8859-1) character set; see
.BR \%iso_8859_1 (7).
.
.TP
.B lbp
Output for Canon CAPSL printers (\%LBP-4 and \%LBP-8 series laser
printers).
.
.TP
.B lj4
HP LaserJet4-compatible (or other PCL5-compatible) printers.
.
.TP
.B ps
PostScript output; suitable for printers and previewers like
.BR gv (1).
.
.TP
.B pdf
PDF files; suitable for viewing with tools such as
.BR evince (1)
and
.BR okular (1).
.
.TP
.B utf8
Text output using the Unicode (ISO 10646) character set with \%UTF-8
encoding; see
.BR unicode (7).
.
.TP
.B xhtml
XHTML output.
.
.TP
.B X75
75dpi X Window System output suitable for the previewers
.BR \%xditview (1x)
and
.BR \%gxditview (@MAN1EXT@).
.
A variant for a 12\|pt document base font is
.BR \%X75-12 .
.
.TP
.B X100
100dpi X Window System output suitable for the previewers
.BR \%xditview (1x)
and
.BR \%gxditview (@MAN1EXT@).
.
A variant for a 12\|pt document base font is
.BR \%X100-12 .
.
.
.P
The postprocessor to be used for a device is specified by the
.B postpro
command in the device description file; see
.BR \%groff_font (@MAN5EXT@).
.
This can be overridden with the
.B \-X
option.
.
.P
The default device is
.BR @DEVICE@ .
.
.
.\" ====================================================================
.SS Postprocessors
.\" ====================================================================
.
.I groff
provides 3\~hardware postprocessors:
.
.TP
.BR \%grolbp (@MAN1EXT@)
for some Canon printers,
.
.TP
.BR \%grolj4 (@MAN1EXT@)
for printers compatible to the HP LaserJet\~4 and PCL5,
.
.TP
.BR \%grotty (@MAN1EXT@)
for text output using various encodings, e.g., on text-oriented
terminals or line printers.
.
.
.P
Today, most printing or drawing hardware is handled by the operating
system, by device drivers, or by software interfaces, usually
accepting PostScript.
.
Consequently, there isn't an urgent need for more hardware device
postprocessors.
.
.
.P
The
.I groff
software devices for conversion into other document file formats are
.
.TP
.BR \%grodvi (@MAN1EXT@)
for the DVI format,
.
.TP
.BR \%grohtml (@MAN1EXT@)
for HTML and XHTML formats,
.
.TP
.BR grops (@MAN1EXT@)
for PostScript.
.
.TP
.BR gropdf (@MAN1EXT@)
for PDF.
.
.
.P
Combined with the many existing free conversion tools this should
be sufficient to convert a
.I troff
document into virtually any existing data format.
.
.
.\" ====================================================================
.SS Utilities
.\" ====================================================================
.
The following utility programs around
.I groff
are available.
.
.TP
.BR \%addftinfo (@MAN1EXT@)
Add information to
.I troff
font description files for use with
.IR groff .
.
.TP
.BR \%afmtodit (@MAN1EXT@)
Create font description files for PostScript device.
.
.TP
.BR \%eqn2graph (@MAN1EXT@)
Convert an
.B eqn
image into a cropped image.
.
.TP
.BR \%gdiffmk (@MAN1EXT@)
Mark differences between
.IR groff ,
.IR nroff ,
or
.I troff
files.
.
.TP
.BR \%grap2graph (@MAN1EXT@)
Convert a
.B grap
diagram into a cropped bitmap image.
.
.TP
.BR \%gxditview (@MAN1EXT@)
The
.I groff
X viewer, the \f[CR]GNU\f[] version of
.BR xditview .
.
.TP
.BR \%hpftodit (@MAN1EXT@)
Create font description files for lj4 device.
.
.TP
.BR \%@g@indxbib (@MAN1EXT@)
Make inverted index for bibliographic databases.
.
.TP
.BR lkbib (@MAN1EXT@)
Search bibliographic databases.
.
.TP
.BR \%@g@lookbib (@MAN1EXT@)
Interactively search bibliographic databases.
.
.TP
.BR \%pdfroff (@MAN1EXT@)
Create PDF documents using
.BR groff .
.
.TP
.BR \%pfbtops (@MAN1EXT@)
Translate a PostScript font in \&.pfb format to \f[CR]ASCII\f[].
.
.TP
.BR \%pic2graph (@MAN1EXT@)
Convert a
.B pic
diagram into a cropped image.
.
.TP
.BR \%tfmtodit (@MAN1EXT@)
Create font description files for TeX DVI device.
.
.TP
.BR \%xditview (1x)
.I roff
viewer historically distributed with the X Window System.
.\" Nowadays (2017) it's its own module as X.Org does not do monolithic
.\" releases anymore (since 2012).  Development on "app/xditview" is
.\" close to moribund, though.
.
.TP
.BR \%xtotroff (@MAN1EXT@)
Convert X font metrics into \f[CR]GNU\f[]
.I troff
font metrics.
.
.
.\" ====================================================================
.SH Environment
.\" ====================================================================
.
Normally, the path separator in the following environment variables is
the colon; this may vary depending on the operating system.
.
For example, DOS and Windows use a semicolon instead.
.
.
.TP
.I GROFF_BIN_PATH
This search path, followed by
.IR PATH ,
is used for commands that are executed by
.BR groff .
.
If it is not set then the directory where the
.I groff
binaries were installed is prepended to
.IR PATH .
.
.
.TP
.I GROFF_COMMAND_PREFIX
When there is a need to run different
.I roff
implementations at the same time
.I groff
provides the facility to prepend a prefix to most of its programs that
could provoke name clashings at run time (default is to have none).
.
Historically, this prefix was the character
.BR g ,
but it can be anything.
.
For example,
.B gtroff
stood for
.IR groff 's
.BR troff ,
.B gtbl
for the
.I groff
version of
.BR tbl .
.
By setting
.I \%GROFF_COMMAND_PREFIX
to different values, the different
.I roff
installations can be addressed.
.
More exactly, if it is set to prefix
.I xxx
then
.B groff
as a wrapper program internally calls
.IB xxx troff
instead of
.BR troff .
.
This also applies to the preprocessors
.BR eqn ,
.BR grn ,
.BR pic ,
.BR \%refer ,
.BR tbl ,
.BR \%soelim ,
and to the utilities
.B \%@g@indxbib
and
.BR \%@g@lookbib .
.
This feature does not apply to any programs different from the ones
above (most notably
.B groff
itself) since they are unique to the
.I groff
package.
.
.
.TP
.I GROFF_ENCODING
The value of this environment value is passed to the
.B preconv
preprocessor to select the encoding of input files.
.
Setting this option implies
.BR groff 's
command-line option
.B \-k
(this is,
.B groff
actually always calls
.BR preconv ).
.
If set without a value,
.B groff
calls
.B preconv
without arguments.
.
An explicit
.B \-K
command-line option overrides the value of
.IR \%GROFF_ENCODING .
.
See
.BR preconv (@MAN1EXT@)
for details.
.
.
.TP
.I GROFF_FONT_PATH
A list of directories in which to search for the
.IR dev name
directory in addition to the default ones.
.
See
.IR \%@g@troff (@MAN1EXT@)
and
.BR \%groff_font (@MAN5EXT@)
for more details.
.
.
.TP
.I GROFF_TMAC_PATH
A list of directories in which to search for macro files in addition
to the default directories.
.
See
.IR \%@g@troff (@MAN1EXT@)
and
.BR \%groff_tmac (@MAN5EXT@)
for more details.
.
.
.TP
.I GROFF_TMPDIR
The directory in which temporary files are created.
.
If this is not set but the environment variable
.I \%TMPDIR
instead, temporary files are created in the directory
.IR \%TMPDIR .
.
On MS-DOS and Windows platforms, the environment variables
.I TMP
and
.I TEMP
(in that order) are searched also, after
.I \%GROFF_TMPDIR
and
.IR \%TMPDIR .
.
Otherwise, temporary files are created in
.IR /tmp .
.
The
.BR \%@g@refer (@MAN1EXT@),
.BR \%grohtml (@MAN1EXT@),
and
.BR grops (@MAN1EXT@)
commands use temporary files.
.
.
.TP
.I GROFF_TYPESETTER
Preset the default device.
.
If this is not set the
.B @DEVICE@
device is used as default.
.
This device name is overwritten by the option
.BR \-T .
.
.
.\" ====================================================================
.SH Examples
.\" ====================================================================
.
The following example illustrates the power of the
.I groff
program as a wrapper around
.IR \%@g@troff .
.
.
.P
To process a
.I roff
input file using the preprocessors
.I tbl \" AT&T
and
.I pic \" AT&T
and the
.I me
macro package in the way to which AT&T
.I troff
users were accustomed,
one would type
(or script)
a pipeline.
.
.IP
.EX
pic foo.me | tbl | troff \-me \-Tutf8 | grotty
.EE
.
.
.P
Using
.IR groff ,
this pipe can be shortened to the equivalent command
.
.IP
.EX
groff \-p \-t \-me \-T utf8 foo.me
.EE
.
.
.P
An even easier way to do this is to use
.IR grog (@MAN1EXT@)
to guess the preprocessor and macro options and execute the result by
using the command substitution feature of the shell.
.
.IP
.EX
$(grog \-Tutf8 foo.me)
.EE
.
.
.\" ====================================================================
.SH Notes
.\" ====================================================================
.
.P
When paging output for the
\[lq]ascii\[rq],
\[lq]cp1047\[rq],
\[lq]latin1\[rq],
and
\[lq]utf8\[rq]
devices,
programs like
.IR more (1)
and
.IR less (1)
may require command-line options to correctly handle some output
sequences;
see
.IR \%grotty (@MAN1EXT@).
.
.
.\" ====================================================================
.SH Bugs
.\" ====================================================================
.
On \f[CR]EBCDIC\f[] hosts (e.g., \f[CR]OS/390 Unix\f[]), output
devices
.B ascii
and
.B latin1
aren't available.
.
Similarly, output for \f[CR]EBCDIC\f[] code page
.B cp1047
is not available on \f[CR]ASCII\f[] based operating systems.
.
.
.\" ====================================================================
.SH "Installation Directories"
.\" ====================================================================
.
.I groff
installs files in varying locations depending on its compile-time
configuration.
.
On this installation, the following locations are used.
.
.
.TP
.I @APPRESDIR@
Application defaults directory for
.IR gxditview (@MAN1EXT@).
.
.
.TP
.I @BINDIR@
Directory containing
.IR groff 's
executable commands.
.
.
.TP
.I @COMMON_WORDS_FILE@
List of common words for
.IR indxbib (@MAN1EXT@).
.
.
.TP
.I @DATASUBDIR@
Directory for data files.
.
.
.TP
.I @DEFAULT_INDEX@
Default index for
.IR lkbib (@MAN1EXT@)
and
.IR refer (@MAN1EXT@).
.
.
.TP
.I @DOCDIR@
Documentation directory.
.
.
.TP
.I @EXAMPLEDIR@
Example directory.
.
.
.TP
.I @FONTDIR@
Font directory.
.
.
.TP
.I @HTMLDOCDIR@
HTML documentation directory.
.
.
.TP
.I @LEGACYFONTDIR@
Legacy font directory.
.
.
.TP
.I @LOCALFONTDIR@
Local font directory.
.
.
.TP
.I @LOCALMACRODIR@
Local macro package
.RI ( tmac
file) directory.
.
.
.TP
.I @MACRODIR@
Macro package
.RI ( tmac
file) directory.
.
.
.TP
.I @OLDFONTDIR@
Font directory for compatibility with old versions of
.IR groff ;
see
.IR grops (@MAN1EXT@).
.
.
.TP
.I @PDFDOCDIR@
PDF documentation directory.
.
.
.TP
.I @SYSTEMMACRODIR@
System macro package
.RI ( tmac
file) directory.
.
.
.\" ====================================================================
.SS "groff macro directory"
.\" ====================================================================
.
This contains all information related to macro packages.
.
Note that more than a single directory is searched for those files
as documented in
.BR \%groff_tmac (@MAN5EXT@).
.
For the
.I groff
installation corresponding to this document, it is located at
.IR @MACRODIR@ .
.
The following files contained in the
.I groff macro directory
have a special meaning:
.
.
.TP
.I troffrc
Initialization file for
.IR troff .
.
This is interpreted by
.I \%@g@troff
before reading the macro sets and any input.
.
.
.TP
.I troffrc\-end
Final startup file for
.IR troff .
.
It is parsed after all macro sets have been read.
.
.
.TP
.RI name .tmac
.TQ
.IR tmac. name
Macro file for macro package
.IR name .
.
.
.\" ====================================================================
.SS "groff font directory"
.\" ====================================================================
.
This contains all information related to output devices.
.
Note that more than a single directory is searched for those files; see
.IR \%@g@troff (@MAN1EXT@).
.
For the
.I groff
installation corresponding to this document, it is located at
.IR @FONTDIR@ .
.
The following files contained in the
.I "groff font directory"
have a special meaning:
.
.
.TP
.IR dev name /DESC
Device description file for device
.IR name ,
see
.BR \%groff_font (@MAN5EXT@).
.
.
.TP
.IR dev name / F
Font file for font
.I F
of device
.IR name .
.
.
.\" ====================================================================
.SH Availability
.\" ====================================================================
.
Information on how to get
.I groff
and related information is available at the
.UR http://\:www\:.gnu\:.org/\:software/\:groff
groff page of the GNU website
.UE .
.
.
.P
Three
.I groff
mailing lists are available:
.
.
.IP
.MT bug\-groff@\:gnu\:.org
bug tracker activity (read-only)
.ME ;
.
.
.IP
.MT groff@\:gnu\:.org
general discussion
.ME ;
and
.
.
.IP
.MT groff\-commit@\:gnu\:.org
commit activity (read-only)
.ME ,
which reports changes to
.IR groff 's
source code repository by its developers.
.
.
.P
Details on repository access and much more can be found in the file
.I README
at the top directory of the
.I groff
source package.
.
.
.P
A free implementation of the
.B grap
preprocessor, written by
.MT faber@\:lunabase\:.org
Ted Faber
.ME ,
can be found at the
.UR http://\:www\:.lunabase\:.org/\:\|\[ti]faber/\:Vault/\:software/\
\:grap/
grap website
.UE .
.
This is the only
.I grap
supported by
.IR groff .
.
.
.\" ====================================================================
.SH Authors
.\" ====================================================================
.
.I groff
was written by
.MT jjc@\:jclark\:.com
James Clark
.ME .
.
This document was rewritten,
enhanced,
and put under the GNU FDL license in
2002 by
.MT groff\-bernd.warken\-72@\:web\:.de
Bernd Warken
.ME .
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
.IR "Groff: The GNU Implementation of troff" ,
by Trent A.\& Fisher and Werner Lemberg,
is the primary
.I groff
manual.
.
You can browse it interactively with \[lq]info groff\[rq].
.
.
.\" groff ships 61 man pages generated from 60 source files.  The
.\" numbered comments refer to their sorting order in the source tree,
.\" so that it is easier to tell that we've enumerated all of them.
.TP
Introduction, history, and further reading:
.IR roff (@MAN7EXT@), \" #23
.IR ditroff (@MAN7EXT@) \" #16
.
.
.TP
.RI "Viewer for\~" groff "\~(and AT&T device-independent)\~" troff \
\~documents:
.IR gxditview (@MAN1EXT@) \" #33
.
.
.TP
Preprocessors:
.IR \%@g@chem (@MAN1EXT@), \" #1
.IR \%@g@eqn (@MAN1EXT@), \" #34
.IR \%@g@neqn (@MAN1EXT@), \" #35
.IR \%glilypond (@MAN1EXT@), \" #4
.IR \%@g@grn (@MAN1EXT@), \" #36
.IR \%preconv (@MAN1EXT@), \" #38
.IR gperl (@MAN1EXT@), \" #5
.IR \%@g@pic (@MAN1EXT@), \" #37
.IR gpinyin (@MAN1EXT@), \" #6
.IR \%@g@refer (@MAN1EXT@), \" #39
.IR \%@g@soelim (@MAN1EXT@), \" #40
.IR \%@g@tbl (@MAN1EXT@) \" #41
.
.
.TP
Macro packages and macro-specific utilities:
.IR \%groff_hdtbl (@MAN7EXT@), \" #9
.IR \%groff_man (@MAN7EXT@), \" #55a
.IR \%groff_man_style (@MAN7EXT@), \" #55b
.IR \%groff_mdoc (@MAN7EXT@), \" #56
.IR \%groff_me (@MAN7EXT@), \" #57
.IR \%groff_mm (@MAN7EXT@), \" # 10
.IR \%groff_mmse (@MAN7EXT@), \" # 11
.IR \%mmroff (@MAN1EXT@) \" #12
.IR \%groff_mom (@MAN7EXT@), \" #13
.IR \%pdfmom (@MAN1EXT@), \" #30
.IR \%groff_ms (@MAN7EXT@), \" #58
.IR \%groff_www (@MAN7EXT@), \" #59
.IR \%groff_trace (@MAN7EXT@) \" #60
.
.
.TP
Bibliographic and index tools:
.IR \%@g@indxbib (@MAN1EXT@), \" #49
.IR \%lkbib (@MAN1EXT@), \" #50
.IR \%@g@lookbib (@MAN1EXT@) \" #51
.
.
.TP
Language, conventions, and GNU extensions:
.IR groff (@MAN7EXT@), \" #17
.IR groff_char (@MAN7EXT@), \" #18
.IR groff_diff (@MAN7EXT@), \" #19
.IR \%groff_filenames (@MAN5EXT@), \" #8
.IR groff_font (@MAN5EXT@), \" #20
.IR groff_tmac (@MAN5EXT@) \" #22
.
.
.TP
Intermediate output language:
.IR groff_out (@MAN5EXT@) \" #21
.
.
.TP
Formatter program:
.IR \%@g@troff (@MAN1EXT@) \" #45
.
.
.TP
Formatter wrappers:
.\".IR groff (@MAN1EXT@), \" 42 -- this page
.IR \%@g@nroff (@MAN1EXT@), \" #44
.IR \%pdfroff (@MAN1EXT@) \" #14
.
.
.TP
Postprocessors for output devices:
.IR \%grodvi (@MAN1EXT@), \" #24
.IR \%grohtml (@MAN1EXT@), \" #25
.IR grolbp (@MAN1EXT@), \" #26
.IR grolj4 (@MAN1EXT@), \" #27
.IR lj4_font (@MAN5EXT@), \" #28
.IR gropdf (@MAN1EXT@), \" #29
.IR grops (@MAN1EXT@), \" #31
.IR \%grotty (@MAN1EXT@) \" #32
.
.
.TP
Font support utilities:
.IR \%addftinfo (@MAN1EXT@), \" #46
.IR \%afmtodit (@MAN1EXT@), \" #47
.IR \%hpftodit (@MAN1EXT@), \" #48
.IR \%pfbtops (@MAN1EXT@), \" #52
.IR \%tfmtodit (@MAN1EXT@), \" #53
.IR xtotroff (@MAN1EXT@) \" #54
.
.
.TP
Graphics conversion utilities:
.IR eqn2graph (@MAN1EXT@), \" #2
.IR grap2graph (@MAN1EXT@), \" #7
.IR pic2graph (@MAN1EXT@) \" #15
.
.
.TP
Difference-marking utility:
.IR \%gdiffmk (@MAN1EXT@) \" #3
.
.
.TP
\[lq]groff guess\[rq] utility:
.IR grog (@MAN1EXT@) \" #43
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_groff_1_man_C]
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
