'\" t
.TH @g@tbl @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
@g@tbl \- format tables in groff documents
.
.
.\" Bernd Warken <groff-bernd.warken-72@web.de> added simple examples.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 1989-2020 Free Software Foundation, Inc.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_tbl_1_man_C \n[.cp]
.cp 0
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY @g@tbl
.OP \-C
.RI [ file
\&.\|.\|.\&]
.YS
.
.
.SY @g@tbl
.B \-\-help
.YS
.
.
.SY @g@tbl
.B \-v
.
.SY @g@tbl
.B \-\-version
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
This manual page describes the GNU version of
.BR tbl ,
which is part of the groff document formatting system.
.
.B tbl
compiles descriptions of tables embedded within
.B troff
input files into commands that are understood by
.BR troff .
.
Normally, it should be invoked using the
.B \-t
option of
.B groff.
.
It is highly compatible with Unix
.BR tbl .
.
The output generated by GNU
.B tbl
cannot be processed with Unix
.BR troff ;
it must be processed with GNU
.BR troff .
.
If no files are given on the command line or a filename of
.B \-
is given, the standard input is read.
.
.
.\" ====================================================================
.SS Overview
.\" ====================================================================
.
.B tbl
expects to find table descriptions wrapped in the
.B .TS
(table start) and
.B .TE
(table end) macros.
.
Within each such table sections, another table can be defined by
using the request
.B .T&
before the final command
.BR .TE .
.
Each table definition has the following structure:
.
.TP
.I Global options
This is optional.
.
This table part can use several of these options distributed in 1 or
more lines.
.
The
.I global option part
must always be finished by a
.B "semi-colon ;" .
.
.TP
.I Table format specification
.
This part must be given, it is not optional.
.
It determines the number of columns (cells) of the table.
.
Moreover each cell is classified by being central, left adjusted, or
numerical, etc.
.
This specification can have several lines, but must be finished by a
.B dot .
at the end of the last line.
.
After each cell definition,
column specifiers can be appended,
but that's optional.
.
.
.P
Cells are separated by a tab character by default.
.
That can be changed by the
.I global option
.BI tab( c )\c
,
where
.I c
is an arbitrary character.
.
.
.\" ====================================================================
.SS "Global options"
.\" ====================================================================
.
The line immediately following the
.B .TS
macro may contain any of the following global options (ignoring the
case of characters \[en] Unix tbl only accepts options with all
characters lowercase or all characters uppercase), separated by
spaces, tabs, or commas:
.
.TP
.B allbox
Enclose each item of the table in a box.
.
.TP
.B box
Enclose the table in a box.
.
.TP
.B center
Center the table
(default is left-justified).
.
The alternative keyword name
.B centre
is also recognized
(this is a GNU
.I tbl \" exception
extension).
.
.TP
.BI decimalpoint( c )
Set the character to be recognized as the decimal point in numeric
columns
(GNU
.I tbl \" exception
only).
.
.TP
.BI delim( xy )
Use
.I x
.RI and\~ y
as start and end delimiters for
.IR \%@g@eqn (@MAN1EXT@).
.
.TP
.B doublebox
Enclose the table in a double box.
.
.TP
.B doubleframe
Same as
.B doublebox
(GNU
.I tbl \" exception
only).
.
.TP
.B expand
Make the table as wide as the current line length (providing a column
separation factor).
.
Ignored if one or more \[oq]x\[cq] column specifiers are used (see
below).
.
.IP
In case the sum of the column widths is larger than the current line
length,
the column separation factor is set to zero;
such tables extend into the right margin,
and there is no column separation at all.
.
.TP
.B frame
Same as
.B box
(GNU
.I tbl \" exception
only).
.
.TP
.BI linesize( n )
Set lines or rules
(e.g.,
from
.BR box )
in
.IR n -point
type.
.
.TP
.B nokeep
Don't use diversions to prevent page breaks
(GNU
.I tbl
only).
.
Normally
.I \%@g@tbl
attempts to prevent undesirable breaks in boxed tables by using
diversions.
.
This can sometimes interact badly with macro packages' own use of
diversions\[em]when footnotes, for example, are used.
.
.TP
.B nospaces
Ignore leading and trailing spaces in data items
(GNU
.I tbl \" exception
only).
.
.TP
.B nowarn
Turn off warnings related to tables exceeding the current line width
(GNU
.I tbl \" exception
only).
.
.TP
.BI tab( x )
Use the character
.I x
instead of a tab to separate items in a line of input data.
.
.
.LP
The global options must end with a semicolon.
.
There might be whitespace between an option and its argument in
parentheses.
.
.
.\" ====================================================================
.SS "Table format specification"
.\" ====================================================================
.
After global options come lines describing the format of each line of
the table.
.
Each such format line describes one line of the table itself, except
that the last format line (which you must end with a period) describes
all remaining lines of the table.
.
A single-key character describes each column of each line of the table.
Key characters can be separated by spaces or tabs.
.
You may run format specifications for multiple lines together on the
same line by separating them with commas.
.
.
.LP
You may follow each key character with specifiers that determine the
font and point size of the corresponding item, that determine column
width, inter-column spacing, etc.
.
.
.LP
The longest format line defines the number of columns in the table;
missing format descriptors at the end of format lines are assumed to
.RB be\~ L .
.
Extra columns in the data (which have no corresponding format entry)
are ignored.
.
.
.LP
The available key characters are:
.
.TP
.BR a , A
Center longest line in this column and then left-justifies all other
lines in this column with respect to that centered line.
.
The idea is to use such alphabetic sub-columns (hence the name of the
key character) in combination
.RB with\~ L ;
they are called sub-columns because
.BR A \~items
are indented by\~1n relative to
.BR L \~entries.
.
Example:
.RS
.IP
.EX
\&.TS
\&tab(;);
\&ln,an.
\&item one;1
\&sub-item two;2
\&sub-item three;3
\&.T&
\&ln,an.
\&item eleven;11
\&sub-item twenty-two;22
\&sub-item thirty-three;33
\&.TE
.EE
.RE
.
.IP
Result:
.
.RS
.IP
.TS
tab(;);
ln,an.
item one;1
sub-item two;2
sub-item three;3
.T&
ln,an.
item eleven;11
sub-item twenty-two;22
sub-item thirty-three;33
.TE
.RE
.
.TP
.BR c , C
Center item within the column.
.
.TP
.BR l , L
Left-justify item within the column.
.
.TP
.BR n , N
Numerically justify item in the column;
that is,
align columns of numbers vertically at the units place.
.
If there are one or more dots adjacent to a digit,
use the rightmost one for vertical alignment.
.
If there is no dot, use the rightmost digit for vertical alignment;
otherwise, center the item within the column.
.
Alignment can be forced to a certain position using \[oq]\[rs]&\[cq];
if there are one or more instances of this special (non-printing)
character present within the data,
use the leftmost one for alignment.
.
Example:
.RS
.IP
.EX
\&.TS
\&n.
\&1
\&1.5
\&1.5.3
\&abcde
\&a\[rs]&bcde
\&.TE
.EE
.RE
.
.IP
Result:
.
.RS
.IP
.TS
n.
1
1.5
1.5.3
abcde
a\&bcde
.TE
.RE
.
.IP
If numerical entries are combined with
.B L
or
.BR R \~entries\[em]this
this can happen if the table format is changed with
.BR .T& \[em]center
the widest
.I number
(of the data entered under the
.BR N \~specifier
regime)
relative to the widest
.B L
or
.BR R \~entry,
preserving the alignment of all numerical entries.
.
Contrary to
.BR A \~type
entries,
there is no extra indentation.
.
.IP
Using equations
(to be processed with
.IR \%@g@eqn )
within columns which use the
.BR N \~specifier
is problematic in most cases due to
.IR \%@g@tbl 's
algorithm for finding the vertical alignment,
as described above.
.
Using the global
.B delim
option,
however,
it is possible to make
.I \%@g@tbl
ignore the data within
.I eqn
delimiters for that purpose.
.
.
.TP
.BR r , R
Right-justify item within the column.
.
.TP
.BR s , S
Span previous item on the left into this column.
.
Not allowed for the first column.
.
.TP
.B ^
Span down entry from previous row in this column.
.
Not allowed for the first row.
.
.TP
.BR _ , -
Replace this entry with a horizontal line.
.
Note that \[oq]_\[cq] and \[oq]-\[cq] can be used for table fields only,
not for column separator lines.
.
.TP
.B =
.
Replace this entry with a double horizontal line.
.
Note that \[oq]=\[cq] can be used for table fields only,
not for column separator lines.
.
.TP
.B |
The corresponding column becomes a vertical rule (if two of these are
adjacent, a double vertical rule).
.
.
.LP
A vertical bar to the left of the first key letter or to the right of
the last one produces a line at the edge of the table.
.
.
.LP
To change the data format within a table, use the
.B .T&
command (at the start of a line).
.
It is followed by format and data lines (but no global options)
similar to the
.B .TS
request.
.
.
.\" ====================================================================
.SS "Column specifiers"
.\" ====================================================================
.
Here are the specifiers that can appear in suffixes to column key
letters (in any order):
.
.TP
.BR b , B
Short form of
.RB \[lq] fB \[rq]
(make affected entries bold).
.
.TP
.BR d , D
Start an item that vertically spans rows,
using the
.RB \[lq] \[ha] \[rq]
column specifier or
.RB \[lq] \[rs]\[ha] \[rq]
data item,
at the bottom of its range rather than vertically centering it
(GNU
.I tbl \" exception
only).
.
Example:
.RS
.IP
.EX
\&.TS
\&tab(;) allbox;
\&l l
\&l ld
\&r ^
\&l rd.
\&0000;foobar
\&T{
\&1111
\&.br
\&2222
\&T};foo
\&r;
\&T{
\&3333
\&.br
\&4444
\&T};bar
\&\[rs]^;\[rs]^
\&.TE
.EE
.RE
.
.IP
Result:
.
.RS
.IP
.TS
tab(;) allbox;
l l
l ld
r ^
l rd.
0000;foobar
T{
1111
.br
2222
T};foo
r;
T{
3333
.br
4444
T};bar
\^;\^
.TE
.RE
.
.TP
.BR e , E
Make equally-spaced columns.
.
All columns marked with this specifier get the same width;
this happens after the affected column widths have been computed
(this means that the largest-width value controls).
.
.TP
.BR f , F
Either of these specifiers may be followed by a font name
(either one or two characters long),
font number
(a single digit),
or long name in parentheses
(this last form is a GNU
.I tbl \" exception
extension).
.
A one-letter font name must be separated by one or more blanks from
whatever follows.
.
.TP
.BR i , I
Short form of
.RB \[lq] fI \[rq]
(make affected entries italic).
.
.TP
.BR m , M
Call named macro before outputting table cell text
(GNU
.I tbl \" exception
only).
.
Either of these specifiers may be followed by a macro name
(either one or two characters long),
or long name in parentheses.
.
A one-letter macro name must be separated by one or more blanks from
whatever follows.
.
The macro which name can be specified here must be defined before
creating the table.
.
As implemented currently,
this macro is only called if block input is used,
that is,
text between
.RB \[lq] T{ \[rq]
and
.RB \[lq] T} \[rq].
.
The macro should contain only simple
.I roff
requests to change the text block formatting,
like text adjustment,
hyphenation,
size,
or font.
.
The macro is called
.I after
other cell modifications like
.RB \[lq] b \[rq],
.RB \[lq] f \[rq],
or
.RB \[lq] v \[rq]
are output.
.
Thus the macro can overwrite other modification specifiers.
.
.TP
.BR p , P
Followed by a number,
this does a point size change for the affected fields.
.
If signed,
the current point size is incremented or decremented
(using a signed multi-digit number is a GNU
.I tbl \" exception
extension).
.
A point size specifier followed by a column separation number must be
separated by one or more blanks.
.
.TP
.BR t , T
Start an item vertically spanning rows at the top of its range rather
than vertically centering it.
.
.TP
.BR u , U
Move the corresponding column up one half-line.
.
.TP
.BR v , V
Followed by a number, this indicates the vertical line spacing to be
used in a multi-line table entry.
.
If signed, the current vertical line spacing is incremented or
decremented (using a signed number instead of a signed digit is a GNU
tbl extension).
.
A vertical line spacing specifier followed by a column separation
number must be separated by one or more blanks.
.
No effect if the corresponding table entry isn't a text block.
.
.TP
.BR w , W
Minimum column width value.
Must be followed either by a
.IR \%@g@troff (@MAN1EXT@)
width expression in parentheses or a unitless integer.
.
If no unit is given, en units are used.
.
Also used as the default line length for included text blocks.
.
If used multiple times to specify the width for a particular column,
the last entry takes effect.
.
.TP
.BR x , X
An expanded column.
.
After computing all column widths without an
.BR x \~specifier,
use the remaining line width for this column.
.
If there is more than one expanded column, distribute the remaining
horizontal space evenly among the affected columns (this is a GNU
extension).
.
This feature has the same effect as specifying a minimum column width.
.
.TP
.BR z , Z
Ignore the corresponding column for width-calculation purposes, this
is, don't use the fields but only the specifiers of this column to
compute its width.
.
.
.LP
A number suffix on a key character is interpreted as a column
separation in en units (multiplied in proportion if the
.B expand
option is on \[en] in case of overfull tables this might be zero).
.
Default separation is 3n.
.
.
.LP
The column
.RB specifier\~ x
is mutually exclusive with
.B e
.RB and\~ w
(but
.B e
is not mutually exclusive
.RB with\~ w );
if specified multiple times for a particular column,
the last entry takes effect:
.BR x \~unsets
both
.B e
.RB and\~ w ,
while either
.B e
or
.B w
.RB overrides\~ x .
.
.
.\" ====================================================================
.SS "Table data"
.\" ====================================================================
.
The format lines are followed by lines containing the actual data for
the table,
followed finally by
.BR .TE .
.
Within such data lines, items are normally separated by tab characters
(or the character specified with the
.B tab
option).
.
Long input lines can be broken across multiple lines if the last
character on the line is \[oq]\[rs]\[cq] (which vanishes after
concatenation).
.
.
.LP
Note that
.I \%@g@tbl
computes the column widths line by line, applying \[rs]w on each entry
which isn't a text block.
.
As a consequence, constructions like
.IP
.EX
\&.TS
\&c,l.
\&\[rs]s[20]MM
\&MMMM
\&.TE
.EE
.
.LP
fail; you must either say
.IP
.EX
\&.TS
\&cp20,lp20.
\&MM
\&MMMM
\&.TE
.EE
.
.LP
or
.
.IP
.EX
\&.TS
\&c,l.
\&\[rs]s[20]MM
\&\[rs]s[20]MMMM
\&.TE
.EE
.
.
.LP
A dot starting a line, followed by anything but a digit is handled as
a troff command, passed through without changes.
.
The table position is unchanged in this case.
.
.
.LP
If a data line consists of only \[oq]_\[cq] or \[oq]=\[cq], a single
or double line, respectively, is drawn across the table at that point;
if a single item in a data line consists of only \[oq]_\[cq] or
\[oq]=\[cq], then that item is replaced by a single or double line,
joining its neighbors.
.
If a data item consists only of \[oq]\[rs]_\[cq] or \[oq]\[rs]=\[cq],
a single or double line, respectively, is drawn across the field at
that point which does not join its neighbors.
.
.
.LP
A data item consisting only of \[oq]\[rs]Rx\[cq] (\[oq]x\[cq] any
character) is replaced by repetitions of character \[oq]x\[cq] as wide
as the column (not joining its neighbors).
.
.
.LP
A data item consisting only of \[oq]\[rs]^\[cq] indicates that the
field immediately above spans downward over this row.
.
.
.\" ====================================================================
.SS "Text blocks"
.\" ====================================================================
.
A text block can be used to enter data as a single entry which would
be too long as a simple string between tabs.
.
It is started with \[oq]T{\[cq] and closed with \[oq]T}\[cq].
.
The former must end a line, and the latter must start a line, probably
followed by other data columns (separated with tabs or the character
given with the
.B tab
global option).
.
.
.LP
By default, the text block is formatted with the settings which were
active before entering the table, possibly overridden by the
.BR m ,
.BR v ,
and
.B w
tbl specifiers.
.
.
.LP
If either \[oq]w\[cq] or \[oq]x\[cq] specifiers are not given for
.I all
columns of a text block span, the default length of the text block (to
be more precise, the line length used to process the text block
diversion) is computed as L\[tmu]C/(N+1), where \[oq]L\[cq] is the
current line length, \[oq]C\[cq] the number of columns spanned by the
text block, and \[oq]N\[cq] the total number of columns in the table.
.
Note, however, that the actual diversion width as returned in register
.B \[rs]n[dl]
is used eventually as the text block width.
.
If necessary, you can also control the text block width with a direct
insertion of a
.B .ll
request right after \[oq]T{\[cq].
.
.
.\" ====================================================================
.SS Miscellaneous
.\" ====================================================================
.
The number register
.B \[rs]n[TW]
holds the table width; it can't be used within the table itself
but is defined right before calling
.B .TE
so that this macro can make use of it.
.
.
.LP
.B tbl
also defines a macro
.B .T#
which produces the bottom and side lines of a boxed table.
.
While
.B tbl
does call this macro itself at the end of the table,
it can be used by macro packages to create boxes for multi-page tables
by calling it within the page footer.
.
An example of this is shown by the
.B \-ms
macros which provide this functionality if a table starts with
.B .TS\ H
instead of the standard call to the
.B .TS
macro.
.
.
.\" ====================================================================
.SS "Interaction with \%@g@eqn"
.\" ====================================================================
.
.IR \%@g@tbl (@MAN1EXT@)
should always be called before
.IR \%@g@eqn (@MAN1EXT@)
.RI ( groff (@MAN1EXT@)
automatically takes care of the correct order of preprocessors).
.
.
.\" ====================================================================
.SS "GNU tbl enhancements"
.\" ====================================================================
.
There is no limit on the number of columns in a table,
nor any limit on the number of text blocks.
.
All the lines of a table are considered in deciding column widths,
not just the first 200.
.
Table continuation
.RB ( .T& )
lines are not restricted to the first 200 lines.
.
.
.LP
Numeric and alphabetic items may appear in the same column.
.
.
.LP
Numeric and alphabetic items may span horizontally.
.
.
.LP
.I \%@g@tbl
uses register,
string,
macro and diversion names beginning with the
.RB digit\~ 3 .
.
When using
.I \%@g@tbl
you should avoid using any names beginning with
.RB a\~ 3 .
.
.
.\" ====================================================================
.SS "GNU tbl within macros"
.\" ====================================================================
.
Since
.I \%@g@tbl
defines its own macros (right before each table) it is necessary to use
an \[oq]end-of-macro\[cq] macro.
.
Additionally, the escape character has to be switched off.
.
Here's an example.
.
.
.IP
.EX
\&.eo
\&.de ATABLE ..
\&.TS
\&allbox tab(;);
\&cl.
\&\[rs]$1;\[rs]$2
\&.TE
\&...
\&.ec
\&.ATABLE A table
\&.ATABLE Another table
\&.ATABLE And \[dq]another one\[dq]
.EE
.
.
.LP
Note, however, that not all features of
.I \%@g@tbl
can be wrapped into a macro because
.I \%@g@tbl
sees the input earlier than
.IR \%@g@troff .
.
For example,
number formatting with vertically aligned decimal points fails if those
numbers are passed on as macro parameters because decimal point
alignment is handled by
.I \%@g@tbl
itself:
it only sees
.BR \[rs]$1 ,
.BR \[rs]$2 ,
etc.,
and therefore can't recognize the decimal point.
.
.
.\" ====================================================================
.SH Options
.\" ====================================================================
.
.B \-\-help
displays a usage message,
while
.B \-v
and
.B \-\-version
show version information;
all exit afterward.
.
.
.TP
.B \-C
Enable compatibility mode to
recognize
.B .TS
and
.B .TE
even when followed by a character other than space or newline.
.
Leader characters (\[rs]a) are handled as interpreted.
.
.
.\" ====================================================================
.SH Bugs
.\" ====================================================================
.
You should use
.BR .TS\ H / .TH
in conjunction with a supporting macro package for
.I all
multi-page boxed tables.
.
If there is no header that you wish to appear at the top of each page
of the table, place the
.B .TH
line immediately after the format section.
.
Do not enclose a multi-page table within keep/release macros,
or divert it in any other way.
.
.
.LP
A text block within a table must be able to fit on one page.
.
.
.LP
The
.B bp
request cannot be used to force a page-break in a multi-page table.
.
Instead, define
.B BP
as follows
.
.IP
.EX
\&.de BP
\&.\&  ie \[aq]\[rs]\[rs]n(.z\[aq]\[aq] \&.bp \[rs]\[rs]$1
\&.\&  el \[rs]!.BP \[rs]\[rs]$1
\&..
.EE
.
.
.LP
and use
.B BP
instead of
.BR bp .
.
.
.LP
Using \[rs]a directly in a table to get leaders does not work (except in
compatibility mode).
.
This is correct behavior: \[rs]a is an
.B uninterpreted
leader.
.
To get leaders use a real leader, either by using a control A or like
this:
.
.IP
.EX
\&.ds a \[rs]a
\&.TS
\&tab(;);
\&lw(1i) l.
\&A\[rs]*a;B
\&.TE
.EE
.
.
.LP
A leading and/or trailing \[oq]|\[cq] in a format line, such as
.
.IP
.EX
|l r|.
.EE
.
.
.LP
gives output which has a 1n\~space between the resulting
bordering vertical rule and the content of the adjacent column,
as in
.
.IP
.EX
\&.TS
\&tab(#);
\&|l r|.
\&left column#right column
\&.TE
.EE
.
.
.LP
If it is desired to have zero space (so that the rule touches
the content), this can be achieved by introducing extra \[lq]dummy\[rq]
columns, with no content and zero separation, before and/or after,
as in
.
.IP
.EX
\&.TS
\&tab(#);
\&r0|l r0|l.
\&#left column#right column#
\&.TE
.EE
.
.
.LP
The resulting \[lq]dummy\[rq] columns are invisible and have zero width;
note that such columns usually don't work with terminal devices.
.
.
.\" ====================================================================
.SH "Simple Examples"
.\" ====================================================================
.
A simple table definition follows.
.RS
.EX
\&.TS
c c c .
This	is	centered
Well,	this	also
\&.TE
.EE
.RE
.
.
By using
.B c c
.BR c ,
each cell in the whole table will be centered.
.
The separating character is here the default
.IR tab .
.
.
.P
The result is
.RS
.TS
c c c .
This	is	centered
Well,	this	also
.TE
.RE
.
.
.P
This definition is identical to
.RS
.EX
\&.TS
tab(@);
ccc.
This@is@centered
Well,@this@also
\&.TE
.EE
.RE
.
Here, the separating tab character is changed to the letter
.BR @ .
.
.
.P
Moreover a title can be added and the centering directions can be
changed to many other formats:
.RS
.EX
\&.TS
tab(@);
c s s
l c n .
Title
left@centers@123
another@number@75
\&.TE
.EE
.RE
.
The result is
.RS
.TS
tab(@);
c s s
l c n .
Title
left@centers@123
another@number@75
.TE
.RE
.
Here
.B l
means
.IR left\-justified ,
and
.B n
means
.IR numerical ,
which is here
.IR right\-justified .
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
\[lq]Tbl\[em]A Program to Format Tables\[rq];
Computing Science Technical Report #49;
M.\& E.\& Lesk;
AT&T Bell Laboratories;
1979.
.
.
.LP
.IR groff (@MAN1EXT@),
.IR \%@g@troff (@MAN1EXT@)
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_tbl_1_man_C]
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
