.TH grodvi @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
grodvi \- groff output driver for TeX DVI format
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 1989-2020 Free Software Foundation, Inc.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_grodvi_1_man_C \n[.cp]
.cp 0
.
.
.ie t .ds tx T\h'-.1667m'\v'.224m'E\v'-.224m'\h'-.125m'X
.el .ds tx TeX
.
.\" This macro definition is poor style from a portability standpoint,
.\" but it's a good test and demonstration of the standard font
.\" repertoire for the devices where it has any effect at all, and so
.\" should be retained.
.de FT
.  if '\\*(.T'dvi' .ft \\$1
..
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY grodvi
.OP \-dl
.OP \-F dir
.OP \-p papersize
.OP \-w n
.RI [ file
\&.\|.\|.\&]
.YS
.
.
.SY grodvi
.B \-\-help
.YS
.
.
.SY grodvi
.B \-v
.
.SY grodvi
.B \-\-version
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
.I grodvi
is a driver for
.I groff
that produces \*[tx] DVI format.
.
Normally it should be run via
.RB \[lq] "groff \-Tdvi" \[rq].
.
This will run
.RB \[lq] "\%@g@troff \-Tdvi" \[rq],
read the macros in
.IR \%@MACRODIR@/\:dvi\:.tmac ,
and pipe the output to
.IR grodvi .
.
.
.LP
The DVI file generated by
.I grodvi
can be printed by any correctly-written DVI driver.
.
.I troff \" generic
drawing primitives are implemented using
.I tpic
version\~2 specials.
.
If the driver does not support these,
the
.B \[rs]D
commands will not produce any output.
.
.
.LP
There is an additional drawing command available:
.
.
.TP
.BI \[rs]D\[aq]R\~ "dh dv" \[aq]
Draw a rule
(solid black rectangle),
with one corner at the current position,
and the diagonally opposite corner at the current position
.RI +( dh , dv ).
.
Afterwards the current position will be at the opposite corner.
.
This produces a rule in the DVI file and so can be printed even with a
driver that does not support the
.I tpic
specials unlike the other
.B \[rs]D
commands.
.
.
.LP
The
.I groff
command
.BI \[rs]X\[aq] anything \[aq]
is translated into the same command in the DVI file as would be
produced by
.BI \%\[rs]special{ anything }
in \*[tx];
.I anything
may not contain a newline.
.
.
.LP
For inclusion of EPS image files,
.B \-Tdvi
loads
.I pspic.tmac
automatically,
providing the
.B .PSPIC
macro.
.
See
.IR groff_tmac (@MAN5EXT@)
for a detailed description.
.
.
.LP
Font files for
.I grodvi
can be created from TFM
(\*[tx] font metrics)
files using
.IR tfmtodit (@MAN1EXT@).
.
The font description file should contain the following
additional commands:
.
.
.TP
.BI internalname\~ name
The name of the TFM file
(without the
.I .tfm
extension) is
.IR name .
.
.
.TP
.BI checksum\~ n
The checksum in the TFM file is
.IR n .
.
.
.TP
.BI designsize\~ n
The designsize in the TFM file is
.IR n .
.
.
.LP
These are automatically generated by
.I tfmtodit.
.
.
.LP
The default color for
.B \[rs]m
and
.B \[rs]M
is black.
.
Currently,
the drawing color for
.B \[rs]D
commands is always black,
and fill color values are translated to gray.
.
.
.LP
In
.IR groff ,
as in AT&T
.IR troff , \" AT&T
the
.B \[rs]N
escape sequence can be used to access characters by their position
in the corresponding TFM file;
all characters in the TFM file can be accessed this way.
.
.
.LP
By design,
the DVI format doesn't care about physical dimensions of the output
medium.
.
Instead,
.I grodvi
emits the equivalent to \*[tx]'s
.BI \%\[rs]special{\:\%papersize= width , length }
on the first page;
.I dvips
(and possibly other DVI drivers)
then sets the page size accordingly.
.
If either the page width or length is not positive,
no
.B papersize
special is output.
.
.
.\" ====================================================================
.SH Options
.\" ====================================================================
.
.B \-\-help
displays a usage message,
while
.B \-v
and
.B \-\-version
show version information;
all exit afterward.
.
.
.TP
.B \-d
Do not use
.I tpic
specials to implement drawing commands.
.
Horizontal and vertical lines will be implemented by rules.
.
Other drawing commands will be ignored.
.
.
.TP
.BI \-F dir
Prepend directory
.RI dir /dev name
to the search path for font and device description files;
.I name
is the name of the device,
usually
.BR dvi .
.
.
.TP
.B \-l
Specify landscape orientation.
.
.
.TP
.BI \-p papersize
Specify paper dimensions.
.
This overrides the
.BR papersize ,
.BR paperlength ,
and
.B paperwidth
commands in the
.I DESC
file;
it accepts the same arguments as the
.B papersize
command
(see
.IR groff_font (@MAN5EXT@)
for details).
.
.
.TP
.BI \-w n
Set the default line thickness to
.I n
thousandths of an em.
.
If this option isn't specified,
the line thickness defaults to 0.04\~em.
.
.
.\" ====================================================================
.SH Usage
.\" ====================================================================
.
There are styles called
.BR R ,
.BR I ,
.BR B ,
and
.B BI
mounted at font positions 1 to\~4.
.
The fonts are grouped into families
.B T
and
.B H
having members in each of these styles:
.
.
.RS
.TP
.B TR
.FT TR
CM Roman (cmr10)
.FT
.
.TQ
.B TI
.FT TI
CM Text Italic (cmti10)
.FT
.
.TQ
.B TB
.FT TB
CM Bold Extended Roman (cmbx10)
.FT
.
.TQ
.B TBI
.FT TBI
CM Bold Extended Text Italic (cmbxti10)
.FT
.
.TQ
.B HR
.FT HR
CM Sans Serif (cmss10)
.FT
.
.TQ
.B HI
.FT HI
CM Slanted Sans Serif (cmssi10)
.FT
.
.TQ
.B HB
.FT HB
CM Sans Serif Bold Extended (cmssbx10)
.FT
.
.TQ
.B HBI
.FT HBI
CM Slanted Sans Serif Bold Extended (cmssbxo10)
.FT
.RE
.
.
.LP
There are also the following fonts which are not members of a family:
.
.
.RS
.TP
.B CW
.FT CW
CM Typewriter Text (cmtt10)
.FT
.
.TQ
.B CWI
.FT CWI
CM Italic Typewriter Text (cmitt10)
.FT
.RE
.
.
.LP
Special fonts are
.B MI
(cmmi10),
.B S
(cmsy10),
.B EX
(cmex10),
.B SC
(cmtex10,
only for
.BR CW ),
and,
perhaps surprisingly,
.BR TR ,
.BR TI ,
and
.BR CW ,
due to the different font encodings of text fonts.
.
For italic fonts,
.B CWI
is used instead of
.BR CW .
.
.
.LP
Finally,
the symbol fonts of the American Mathematical Society are available as
special fonts
.B SA
(msam10) and
.B SB
(msbm10).
.
These two fonts are not mounted by default.
.
.
.LP
Using the option
.B \-mec
(which loads the file
.IR ec.tmac )
provides the EC and TC fonts.
.
The design of the EC family is very similar to that of the CM fonts;
additionally,
they give a much better coverage of
.I groff
symbols.
.
.I ec.tmac
must be called before any language-specific files;
it doesn't take care of
.B .hcode
values.
.
.
.\" ====================================================================
.SH Environment
.\" ====================================================================
.
.TP
.I GROFF_FONT_PATH
A list of directories in which to search for the
.IR dev name
directory in addition to the default ones.
.
See
.IR \%@g@troff (@MAN1EXT@)
and
.IR \%groff_font (@MAN5EXT@)
for more details.
.
.
.\" ====================================================================
.SH Files
.\" ====================================================================
.
.TP
.I \%@FONTDIR@/\:\%devdvi/\:DESC
Device description file.
.
.
.TP
.IR \%@FONTDIR@/\:\%devdvi/ F
Font description file for font
.IR F .
.
.
.TP
.I \%@MACRODIR@/\:dvi\:.tmac
Macros for use with
.IR grodvi .
.
.
.TP
.I \%@MACRODIR@/\:ec\:.tmac
Macros to switch to EC fonts.
.
.
.\" ====================================================================
.SH Bugs
.\" ====================================================================
.
DVI files produced by
.I grodvi
use a different resolution
(57816 units per inch)
from those produced by \*[tx].
.
Incorrectly written drivers which assume the resolution used by \*[tx],
rather than using the resolution specified in the DVI file will not
work with
.IR grodvi .
.
.
.LP
When using the
.B \-d
option with boxed tables,
vertical and horizontal lines can sometimes protrude by one pixel.
.
This is a consequence of the way \*[tx] requires that the heights
and widths of rules be rounded.
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
.IR \%tfmtodit (@MAN1EXT@),
.IR groff (@MAN1EXT@),
.IR \%@g@troff (@MAN1EXT@),
.IR groff_out (@MAN5EXT@),
.IR groff_font (@MAN5EXT@),
.IR groff_char (@MAN7EXT@),
.IR groff_tmac (@MAN5EXT@)
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_grodvi_1_man_C]
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
