'\" t
.TH roff @MAN7EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
roff \- concepts and history of roff typesetting
.
.
.\" TODO: Synchronize this material with introductory section(s) of our
.\" Texinfo manual, and then keep it that way.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 2000-2020 Free Software Foundation, Inc.
.\"
.\" This file is part of groff, the GNU roff type-setting system.
.\"
.\" Permission is granted to copy, distribute and/or modify this
.\" document under the terms of the GNU Free Documentation License,
.\" Version 1.3 or any later version published by the Free Software
.\" Foundation; with no Invariant Sections, with no Front-Cover Texts,
.\" and with no Back-Cover Texts.
.\"
.\" A copy of the Free Documentation License is included as a file
.\" called FDL in the main directory of the groff source package.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_roff_7_man_C \n[.cp]
.cp 0
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
The term
.I roff
describes a family of document formatting systems known by names like
.IR troff ,
.IR nroff ,
.IR ditroff ,
and
.IR groff .
.
A
.I roff
system consists of an extensible text formatting language and a set of
programs for printing and converting to other text formats.
.
Unix-like operating systems often distribute a
.I roff
system as a core package.
.
.
.P
The most common
.I roff
system today is GNU
.IR roff ,
.IR groff (@MAN1EXT@).
.
.I groff
retains the input conventions and functionality of its ancestors,
with many extensions.
.
The ancestry of
.I roff
is described in section \[lq]History\[rq] below.
.
In this document,
the term
.I roff
generally refers to this class of programs,
with the exception of a
.IR roff (1)
command provided in early Unix systems.
.
In spite of its age,
.I roff
remains in wide use today;
for example,
the manual pages on Unix systems
(\[lq]man\~pages\[rq]),
books about software and programming,
and technical memoranda are written in
.IR roff .
.
.
.P
This document describes the history of the development of the \[lq]roff
system\[rq],
typographical concepts that form the common background of all
.I roff
implementations,
details on the
.I roff
pipeline
which is usually hidden behind front-ends like
.IR groff (@MAN1EXT@),
a general overview of the formatting language,
some tips for editing
.I roff
files,
and many suggestions for further reading.
.
.
.\" ====================================================================
.SH History
.\" ====================================================================
.
Computer-driven document formatting dates back to the 1960s.
.
The
.I roff
system itself is intimately connected with the Unix operating system,
but its roots go back to the earlier operating systems CTSS and Multics.
.
.
.\" ====================================================================
.SS "The predecessor RUNOFF"
.\" ====================================================================
.
.IR roff 's
ancestor
.I RUNOFF
was written in the MAD language by Jerry Saltzer
to prepare his Ph.D.\& thesis using the Compatible Time Sharing System
(CTSS),
a project of the Massachusetts Institute of Technology (MIT).
.
The program is generally referred to in full capitals,
both to distinguish it from its many descendants,
and because bits were expensive in those days;
five- and six-bit character encodings were still in widespread usage,
and mixed-case alphabetics seen as a luxury.
.
.I RUNOFF
introduced a syntax of inlining formatting directives amid document
text,
by beginning a line with a period
(an unlikely occurrence in human-readable material)
followed by a \[lq]control word\[rq].
.
Control words with obvious meaning like \[lq].line length
.IR n \[rq]
were supported as well as an abbreviation system;
the latter came to overwhelm the former in popular usage and later
derivatives of the program.
.
A sample of control words from a
.UR http://\:web\:.mit\:.edu/\:Saltzer/\:www/\:publications/\:ctss/\:AH\
\:.9\:.01\:.html
.I RUNOFF
manual of December 1966
.UE
was documented as follows with only a slight update to parameter syntax.
.
They will be familiar to
.I roff
veterans.
.
.
.P
.ne 10 \" why is tbl ****ing with me?
.TS
center;
r l
rB l.
Abbreviation	Control word
\&.ad	.adjust
\&.bp	.begin page
\&.br	.break
\&.ce	.center
\&.in	.indent \f[I]n\f[]
\&.ll	.line length \f[I]n\f[]
\&.nf	.nofill
\&.pl	.paper length \f[I]n\f[]
\&.sp	.space [\f[I]n\f[]]
.TE
.
.
.P
In 1965,
MIT's Project MAC teamed with Bell Telephone Laboratories and General
Electric (GE) to inaugurate the
.UR http://\:www\:.multicians\:.org
Multics
.UE
project.
.
After a few years,
Bell Labs discontinued its participation in Multics,
famously prompting the development of Unix.
.
Meanwhile,
Saltzer's
.I RUNOFF
proved influential,
seeing many ports and derivations elsewhere.
.
.
.P
In 1969,
Doug McIlroy wrote one such reimplementation of
.I RUNOFF
in the BCPL language for a GE 645 running GECOS at the Bell Labs
location in Murray Hill,
New Jersey.
.
In its manual,
the control commands were termed \[lq]requests\[rq],
their two-letter names were canonical,
and the control character was configurable with a
.B .cc
request.
.
Other familiar requests emerged at this time;
no-adjust
.RB ( .na ),
need
.RB ( .ne ),
page offset
.RB ( .po ),
tab configuration
.RB ( .ta ,
though it worked differently),
temporary indent
.RB ( .ti ),
character translation
.RB ( .tr ),
and automatic underlining
.RB ( .ul ;
on
.I RUNOFF
you had to backspace and underscore in the input yourself).
.B .fi
to turn on fill mode got the name it retains to this day.
.
.\" GBR can't find a source for this claim (of Bernd's).
.\"Multics
.\".I runoff
.\"added features such as the ability to do two-pass formatting;
.\"it became the main system for Multics documentation and text
.\"processing.
.
.
.\" ====================================================================
.SS "Unix and roff"
.\" ====================================================================
.
By 1971,
McIlroy's
.I runoff
had been rewritten in DEC PDP-11 assembly language
by Dennis Ritchie
for the fledgling Unix operating system
and seen its name shortened to
.I roff
(perhaps under the influence of Ken Thompson),
but had added support for automatic hyphenation with
.B .hc
and
.B .hy
requests;
a generalization of line spacing control with the
.B .ls
request;
and what later
.IR roff s
would call diversions,
with \[lq]footnote\[rq] requests.
.
This
.I roff
indirectly funded operating systems research at Murray Hill,
for it was used to prepare patent applications for AT&T to the U.S.\&
government.
.
This arrangement enabled the group to acquire the aforementioned PDP-11;
.I roff
promptly proved equal to the task of typesetting the first edition of
the manual for what would later become known as \[lq]v1 Unix\[rq],
dated November 1971.
.
.
.P
Output from all of the foregoing programs was limited to line printers
and paper terminals such the IBM 2471
(based on the Selectric line of typewriters)
and the Teletype Corporation Model 37.
.
Proportionally-spaced type was unknown.
.
.
.\" ====================================================================
.SS "New roff and Typesetter roff"
.\" ====================================================================
.
The first years of Unix were spent in rapid evolution.
.
The practicalities of preparing standardized documents like patent
applications
(and Unix manual pages),
combined with McIlroy's enthusiasm for macro languages,
perhaps created an irresistible pressure to make
.I roff
extensible.
.
Joe Ossanna's
.IR nroff ,
literally a \[lq]new roff\[rq],
was the outlet for this pressure.
.
By the time of Version 3 Unix
(February 1973)\[em]and still in PDP-11 assembly language\[em]it sported
a swath of features now considered essential to
.I roff
systems;
.
definition of macros
.RB ( .de ),
diversion of text thence
.RB ( .di ),
and removal thereof
.RB ( .rm );
.
trap planting
.RB ( .wh ;
\[lq]when\[rq])
and relocation
.RB ( .ch ;
\[lq]change\[rq]);
.
conditional processing
.RB ( .if );
.
and environments
.RB ( .ev ).
.
Incremental improvements included
.
assignment of the next page number
.RB ( .pn );
.
no-space mode
.RB ( .ns )
and restoration of vertical spacing
.RB ( .rs );
.
the saving
.RB ( .sv )
and output
.RB ( .os )
of vertical space;
.
specification of replacement characters for tabs
.RB ( .tc )
and leaders
.RB ( .lc );
.
configuration of the no-break control character
.RB ( .c2 );
.
shorthand to disable automatic hyphenation
.RB ( .nh );
.
a condensation of what were formerly six different requests for
configuration of page \[lq]titles\[rq]
(headers and footers)
into one
.RB ( .tl )
with a length controlled separately from the line length
.RB ( .lt );
.
automatic line numbering
.RB ( .nm );
.
interactive input
.RB ( .rd ),
which necessitated buffer-flushing
.RB ( .fl ),
and was made convenient with early program cessation
.RB ( .ex );
.
source file inclusion in its modern form
.RB ( .so ;
though
.I RUNOFF
had an \[lq].append\[rq] control for a similar purpose)
and early advance to the next file argument
.RB ( .nx );
.
ignorable content
.RB ( .ig );
.
and programmable abort
.RB ( .ab ).
.
.
.P
Third Edition Unix also brought the
.IR pipe (2)
system call,
the explosive growth of a componentized system based around it,
and a \[lq]filter model\[rq] that remains perceptible today.
.
Around this time, \" judging by "CSTR #17"
Michael Lesk developed the
.I tbl \" AT&T
preprocessor for formatting tables.
.
Equally importantly,
the Bell Labs site in Murray Hill acquired a Graphic Systems C/A/T
phototypesetter,
and with it came the necessity of expanding the capabilities of a
.I roff
system to cope with proportionally-spaced type,
multiple point sizes and font styles.
.
Ossanna wrote a parallel implementation of
.I nroff
for the C/A/T,
dubbing it
.I troff
(for \[lq]typesetter roff\[rq]).
.
Unfortunately,
surviving documentation does not illustrate what requests were
implemented at this time for C/A/T support;
the
.IR troff (1) \" AT&T
man pages in Fourth Edition Unix
(November 1973)\[em]and
even Sixth (1975)\[em]do not feature a request list,
unlike
.IR nroff (1). \" AT&T
.
Apart from typesetter-driven features,
Version 4 Unix
.IR roff s
added string definitions
.RB ( .ds );
made the escape character configurable
.RB ( .ec );
and enabled the user to write diagnostics to the standard error stream
.RB ( .tm ).
.
Around 1974,
empowered with multiple type sizes,
italics,
and a symbol font specially commissioned by Bell Labs from
Graphic Systems,
Brian Kernighan and Lorinda Cherry implemented
.I eqn \" AT&T
for typesetting mathematics.
.
.
In the same year,
for Fifth Edition Unix,
Ossanna combined and reimplemented the two
.IR roff s
in C,
using preprocessor conditions of that language to generate both from a
single source tree.
.
.
.P
The syntax of the input language to the
.I nroff
and
.I troff
programs was documented in the \[lq]Troff User's Manual\[rq],
first published in 1976,
with further revisions as late as 1992 by Kernighan.
.
(The original version was entitled
\[lq]Nroff/Troff User's Manual\[rq],
which may partially explain why
.I roff
practitioners have tended to refer to it by its AT&T document
identifier,
\[lq]CSTR #54\[rq].)
.
Its final revision serves as the
.I de facto
specification of AT&T
.IR troff , \" AT&T
and all subsequent implementors of
.I roff
systems have done so in its shadow.
.
.
.P
A small and simple set of
.I roff
macros was first used for the manual pages of Version 4 Unix and
persisted for two further releases,
but the first macro package to be formally installed and described was
.I ms
by Lesk in Version 6.
.
He also wrote a manual,
\[lq]Typing Documents on the Unix System\[rq],
describing
.I ms
and basic
.IR nroff / troff
usage,
updating it as the package accrued features.
.
.
.P
For Version 7 Unix
(January 1979),
McIlroy designed,
implemented,
and documented the
.I man
macro package,
introducing most of the macros described in
.IR groff_man (7)
today,
and edited volume 1 of the Version 7 manual using it.
.
Documents composed using
.I ms
featured in volume 2,
edited by Kernighan.
.
.
.P
Ossanna had passed away unexpectedly in 1977,
and after the release of Version 7,
with the C/A/T typesetter becoming supplanted by alternative devices,
Kernighan undertook a revision and rewrite of
.I troff
to generalize its design.
.
To implement this revised architecture,
he developed the font and device description file formats and the
device-independent output format that remain in use today.
.
He described these novelties in the article \[lq]A
Typesetter-independent TROFF\[rq],
last revised in 1982,
and like the
.I troff
manual itself,
it is widely known by a shorthand,
\[lq]CSTR #97\[rq].
.
.
.P
Kernighan's innovations prepared
.I troff
well for the introduction of the Adobe PostScript language in 1982 and a
vibrant market in laser printers with built-in interpreters for it.
.
An output driver for PostScript,
.IR dpost ,
was swiftly developed.
.
However,
due to AT&T software licensing practices,
Ossanna's
.IR troff ,
with its tight coupling to the capabilities of the C/A/T,
remained in parallel distribution with device-independent
.I troff
throughout the 1980s,
leading some developers to contrive translators for C/A/T-formatted
documents to other devices.
.
An example was
.I vtroff
for Versatec and Benson-Varian plotters.
.
Today,
however,
all actively maintained
.IR troff s
follow Kernighan's device-independent design.
.
.
.\" ====================================================================
.SS "groff\[em]a free roff from GNU"
.\" ====================================================================
.
The most important free
.I roff
project historically has been
.IR groff ,
the GNU implementation of
.IR troff ,
developed from scratch by James Clark starting in 1989 and distributed
under
.UR http://\:www\:.gnu\:.org/\:copyleft
copyleft
.UE
licenses,
ensuring to all the availability of source code and the freedom to
modify and redistribute it,
properties unprecedented in
.I roff
systems to that point.
.
.I groff
rapidly attracted contributors,
and has served as a complete replacement for almost all applications of
AT&T
.I troff
(exceptions include
.IR mv ,
a macro package for preparation of viewgraphs and slides,
and the
.I ideal
preprocessor for producing diagrams from a constraint-based language).
.
Beyond that,
it has added numerous features;
see
.IR groff_diff (@MAN7EXT@).
.
Since its inception and for at least the following three decades,
it has been used by practically all GNU/Linux and BSD operating systems.
.
.
.P
.I groff
continues to be developed,
is available for almost all operating systems in common use
(along with several obscure ones),
and it is free.
.
These factors make
.I groff
the
.I de facto
.I roff
standard today.
.
.
.\" XXX GBR leaves off here.
.\" ====================================================================
.SS "Free Heirloom roff"
.\" ====================================================================
.
An alternative is
.UR https://\:github.com/\:n\-t\-roff/\:heirloom\-doctools
.I Gunnar Ritter's Heirloom roff project
.UE
project, started in 2005, which provides enhanced versions of the
various roff tools found in the OpenSolaris and Plan\~9 operating
systems, now available under free licenses.
.
You can get this package with the shell command:
.RS
.EX
\[Do] git clone https://github.com/n\-t\-roff/heirloom\-doctools
.EE
.RE
.
.
.P
Moreover, one finds there the
.UR https://\:github.com/\:n\-t\-roff/\:DWB3.3
.I Original Documenter's Workbench Release 3.3
.UE .
.
.
.\" ====================================================================
.SH "Using roff"
.\" ====================================================================
.
Many people use
.I roff
frequently without knowing it.
.
When you read a system manual page
(man page),
it is often a
.I roff
working in the background to render it.
.
But using a
.I roff
explicitly isn't difficult.
.
.
.P
Some
.I roff
implementations provide wrapper programs that make it easy to use the
.I roff
system from the shell's command line.
.
These can be specific to a macro package,
like
.IR mmroff (@MAN1EXT@),
or more general.
.
.IR groff (@MAN1EXT@)
provides command-line options sparing the user from constructing the
long,
order-dependent pipelines familiar to AT&T
.I troff
users.
.
Further,
a heuristic program,
.IR grog (@MAN1EXT@),
is available to infer from a document's contents which
.I groff
arguments should be used to process it.
.
.
.\" ====================================================================
.SS "The roff pipeline"
.\" ====================================================================
.
Each
.I roff
system consists of preprocessors,
one or more
.I roff
formatter programs,
and a set of output drivers
(or \[lq]device postprocessors\[rq]).
.
This arrangement is designed to take advantage of a landmark Unix
innovation in inter-process communication:
the pipe.
.
That is,
a series of programs termed a \[lq]pipeline\[rq] is called together
.\" in an indeterminate order :P
where the output of each program in the sequence is taken as the input
for the next program,
without (necessarily) passing through temporary files on a disk.
.
(On non-Unix systems,
pipelines may have to be simulated.)
.
.
.RS
.PP
.EX
.RI $\~ preproc1 \~\c
.BI <\~ input-file \~|\~ preproc2 \~|\~\c
.RB .\|.\|.\&\~ "| troff\~"\c
.BI [ option\~\c
.RB "\~.\|.\|.\&]\~" \[rs]
.BI "    |\~" output-driver \" 4 leading spaces
.EE
.RE
.
.
.P
One all preprocessors have run,
they deliver a pure
.I roff
document to the formatter,
which in turn generates intermediate output that is fed into an output
driver for viewing,
printing,
or further processing.
.
.
.P
All of these parts use programming languages of their own;
each language is totally unrelated to the other parts.
.
Moreover,
.I roff
macro packages that are tailored for special purposes can be included.
.
.
.P
Most
.I roff
input files use the macros of a document formatting package,
intermixed with instructions for one or more preprocessors,
seasoned with escape sequences and requests directly from the
.I roff
language.
.
Some documents are simpler still,
since their formatting packages discourage direct use of
.I roff
requests;
man pages are a prominent example.
.
The full power of the
.I roff
formatting language is seldom needed by users;
only programmers of macro packages need a substantial command of it.
.
.
.
.\" ====================================================================
.SS Preprocessors
.\" ====================================================================
.
A
.I roff
preprocessor is any program that generates output that syntactically
obeys the rules of the
.I roff
formatting language.
.
Each preprocessor defines a language of its own that is translated
into
.I roff
code when run through the preprocessor program.
.
Parts written in these languages may be included within a
.I roff
document; they are identified by special
.I roff
requests or macros.
.
Each document that is enhanced by preprocessor code must be run
through all corresponding preprocessors before it is fed into the
actual
.I roff
formatter program, for the formatter just ignores all alien code.
.
The preprocessor programs extract and transform only the document
parts that are determined for them.
.
.
.P
There are a lot of free and commercial
.I roff
preprocessors.
.
Some of them aren't available on each system, but there is a small
set of preprocessors that are considered as an integral part of each
.I roff
system.
.
The classical preprocessors are
.
.RS
.TS
tab (@);
lb l.
tbl@for tables.
eqn@for mathematical formulae.
pic@for drawing diagrams.
refer@for bibliographic references.
soelim@for including macro files from standard locations.
chem@for drawing chemical formul\[ae].
.TE
.RE
.
.
.P
Other known preprocessors that are not available on all systems
include
.
.RS
.TS
tab (@);
lb l.
grap@for constructing graphical elements.
grn@for including \fBgremlin\fR(1) pictures.
.TE
.RE
.
.
.\" ====================================================================
.SS "Formatter programs"
.\" ====================================================================
.
In the context of
.I roff
systems,
the formatter is the program that parses documents written in the
.I roff
language.
.
It generates intermediate output,
which is intended to be fed into an output driver
(also known as a device postprocessor),
the identity of which must be known prior to processing.
.
The documents must already have been run through all necessary
preprocessors to render correctly.
.
.
.P
The output produced by a
.I roff
formatter is represented in another language,
termed the \[lq]intermediate output format\[rq].
.
As noted in section \[lq]History\[rq] above,
this language was first specified in CSTR\~#97;
GNU extensions to it are documented in
.IR groff_out (@MAN5EXT@).
.
Intermediate output is in specialized in its parameters,
but not its syntax,
for the output driver used;
the format is
.RI device- independent ,
but not
.RI device- agnostic .
.
.
.P
The formatter is the heart of the
.I roff
system.
.
AT&T
had two formatters:
.I nroff
for terminals,
and
.I troff
for typesetters.
.
.
.P
Often,
the name
.I troff
is used as a general term to refer to both formatters.
.
When speaking that generally,
.I groff
documentation prefers the term
.RI \[lq] roff \[rq].
.
.
.\" ====================================================================
.SS "Devices and output drivers"
.\" ====================================================================
.
To a
.I roff
system,
a
.I device
is a hardware interface like a printer,
a text or graphical terminal,
or a standardized file format that unrelated software can interpret.
.
.
.P
A
.I roff
output driver is a program that parses the device-independent
intermediate output format of
.I troff
and produces instructions specific to the device or file format it
supports.
.
.
.P
The names of the devices and their driver programs are not standardized.
.
Technologies change;
the devices used for document preparation have greatly changed since
CSTR\~#54 was first written in the 1970s.
.
Such hardware is no longer used in production environments,
and device capabilities
(including resolution,
color drawing,
and font repertoire)
have tended to increase.
.
The PostScript output driver
.IR dpost (1)
from an AT&T
.I troff
of 1980s vintage had a resolution of 720 units per inch,
whereas
.IR groff 's
.IR grops (@MAN1EXT@)
uses 72 000.
.
.
.\".P
.\"Today the operating systems provide device drivers for most
.\"printer-like hardware, so it isn't necessary to write a special
.\"hardware postprocessor for each printer.
.\" XXX?  No they don't.  Instead printers interpret PS or PDF directly.
.\" With a TCP/IP protocol stack and an HTTP server to accept POSTed
.\" documents for printing.
.
.
.\" ====================================================================
.SH "roff programming"
.\" ====================================================================
.
Documents using
.I roff
are normal text files interleaved with
.I roff
formatting elements.
.
.I roff
languages are powerful enough to support arbitrary computation and
supply facilities that encourage their extension.
.
The primary such facility is macro definition;
with this feature,
macro packages have been developed that are tailored for particular
applications.
.
.
.\" ====================================================================
.SS "Macro packages"
.\" ====================================================================
.
Macro packages can have a much smaller vocabulary than
.I roff
itself;
this trait combined with their domain-specific nature can make them easy
to acquire and master.
.
The macro definitions of a package are typically kept in a file called
.IB name .tmac
(historically,
.BI tmac. name\/\c\" Italic correction comes before \c !
).
.
All tmac files are stored in one or more directories at standardized
positions.
.
Details on the naming of macro packages and their placement is found
in
.IR groff_tmac (@MAN5EXT@).
.
.
.P
A macro package anticipated for use in a document can be delcared to
the formatter by the command-line option
.BR \-m ;
see
.IR \%@g@troff (@MAN1EXT@).
.
It can alternatively be specified within a document using the file
inclusion requests of the
.I roff
language; see
.IR groff (@MAN7EXT@).
.
.
.P
Well-known macro packages include
.I man
for traditional man pages and
.I mdoc
for BSD-style manual pages.
.
Macro packages for typesetting books,
articles,
and letters include
.I ms
(from \[lq]manuscript macros\[rq]),
.I me
(named by a system administrator from the first name of its creator,
Eric Allman),
.I mm
(from \[lq]memorandum macros\[rq]),
and
.IR mom ,
a punningly-named package exercising many
.I groff
extensions.
.
.
.\" ====================================================================
.SS "The roff formatting language"
.\" ====================================================================
.
The canonical reference for the AT&T
.I troff
language is Ossanna's \[lq]Troff User's Manual\[rq],
CSTR\~#54,
in its 1992 revision by Kernighan.
.
.I roff
languages provide requests,
escape sequences,
macro definition facilities,
string variables,
registers for storage of numbers or dimensions,
and control of execution flow.
.
The theoretically-minded will observe that a
.I roff
is not a mere markup language,
but Turing-complete,
and would be even stripped of its macro-definition facility.
.
It has storage
(registers);
it can perform tests
(as in onditional expressions like
.RB \[lq] "(\[rs]n[i] >= 1)" \[rq]);
and it can jump or branch using the
.B .if
request.
.
.
.P
.I Requests
and
.I escape sequences
are instructions,
predefined parts of the language,
that perform formatting operations or otherwise change the state of the
parser.
.
The user can define their own request-like elements by composing
together text,
requests,
and escape sequences
.IR "ad libitum" .
.
.
A document writer will not
(usually)
note any difference in usage for requests or macros;
both are written on a line on their own starting with a dot.
.
However,
there is a distinction;
requests take either a fixed number of arguments
(sometimes zero),
silently ignoring any excess,
or consume the rest of the input line,
whereas macros can take a variable number of arguments.
.
Since arguments are separated by spaces,
macros require a means of embedding a space in an argument;
in other words,
of quoting it.
.
This then demands a mechanism of embedding the quoting character itself,
in case
.I it
is needed literally in a macro argument.
.
AT&T
.I troff
had complex rules involving the placement and repetition of the double
quote to achieve both aims.
.
.I groff
cuts this knot by supporting a special character escape sequence for the
double quote,
.RB \[lq] \[rs][dq] \[rq] ,
which never performs quoting in the typesetting language,
but is simply a glyph,
.RB \[oq] \[dq] \[cq].
.
.
.P
.I Escape sequences
start with a backslash,
.RB \[lq] \[rs] \[rq].
.
They can appear almost anywhere,
even in the midst of text on a line,
and implement various features,
including the insertion of special characters with
.RB \[lq] \[rs]( \[rq]
or
.RB \[lq] \[rs][] \[rq],
break suppression at input line endings with
.RB \[lq] \[rs]c \[rq],
font changes with
.RB \[lq] \[rs]f \[rq],
point size changes with
.RB \[lq] \[rs]s \[rq],
in-line comments with
.RB \[lq] \[rs]\[dq] \[rq],
and many others.
.
.
.P
.I Strings
are variables that can store a string.
.
A string is stored by the
.B .ds
request.
.
The stored string can be retrieved later by the
.B \[rs]*
escape sequence.
.
.
.P
.I Registers
store numbers and sizes.
.
A register can be set with the request
.B .nr
and its value can be retrieved by the escape sequence
.BR "\[rs]n" .
.
.
.\" ====================================================================
.SH "File name extensions"
.\" ====================================================================
.
Manual pages (man pages) take the section number as a file name
extension, e.g., the filename for this document is
.IR roff.7 ,
i.e., it is kept in section\~7
of the man pages.
.
.
.P
The classical macro packages take the package name as an extension,
e.g.,
.IB file. me
for a document using the
.I me
macro package,
.IB file. mm
for
.IR mm ,
.IB file. ms
for
.IR ms ,
.IB file. pic
for
.I pic
files,
etc.
.
.
.P
But there is no general naming scheme for
.I roff
documents, though
.IB file. tr
for
.I troff file
is seen now and then.
.
Maybe there should be a standardization for the filename extensions of
.I roff
files.
.
.
.P
File name extensions can be very handy in conjunction with the
.BR less (1)
pager.
.
It provides the possibility to feed all input into a command-line pipe
that is specified in the shell environment variable
.BR LESSOPEN .
.
This process is not well documented, so here an example:
.
.RS
.P
.EX
LESSOPEN=\[aq]|lesspipe %s\[aq]
.EE
.RE
.
.
.P
where
.B lesspipe
is either a system supplied command or a shell script of your own.
.
.
.P
More details for
.I file name extensions
can be found at
.BR groff_filenames (@MAN5EXT@).
.
.
.\" ====================================================================
.SH "Editing roff"
.\" ====================================================================
.
All
.I roff
formatters provide automated line breaks and horizontal and vertical
spacing.
.
In order to not disturb this, the following tips can be helpful.
.
.IP \(bu
Never include empty or blank lines in a
.I roff
document.
.
Instead, use the empty request (a line consisting of a dot only) or a
line comment
.B .\[rs]"\""
if a structuring element is needed.
.
.IP \(bu
Never start a line with whitespace because this can lead to unexpected
behavior.
.
Indented paragraphs can be constructed in a controlled way by
.I roff
requests.
.
.IP \(bu
Start each sentence on a line of its own, for the spacing after a dot
is handled differently depending on whether it terminates an
abbreviation or a sentence.
.
To distinguish both cases, do a line break after each sentence.
.
.IP \(bu
To additionally use the auto-fill mode in Emacs, it is best to insert
an empty
.I roff
request (a line consisting of a dot only) after each sentence.
.
.
.P
The following example shows judicious line breaking in a
.I roff
input file.
.
.RS
.P
.EX
.\" Keep the text width to 65 columns or fewer in this example so that
.\" it doesn't overrun the right margin when set in Courier (-Tps,
.\" -Tpdf).
This is an example of a
\&.I roff
document that you can type into your text editor.
\&.
.
This is the next sentence in the same paragraph.
\&.
.
This is a longer sentence stretching over several input lines;
abbreviations like cf.\& are easily identified because the dot is
not followed by a line break.
\&.
.
In the output, this sentence continues the same paragraph.
.EE
.RE
.
.
.\" ====================================================================
.SS "Editing with Emacs"
.\" ====================================================================
.
Official GNU doctrine holds that the best program for editing a
.I roff
document is Emacs; see
.IR emacs (1).
.
It provides an
.I nroff
major mode that is suitable for all kinds of
.I roff
dialects.
.
This mode can be activated by the following methods.
.
.
.P
When editing a file within Emacs the mode can be changed by typing
.RI \[oq] "M-x nroff\-mode" \[cq],
where
.B M-x
means to hold down the
.B Meta
key (or
.BR Alt )
and press the
.BR x\~ key
at the same time.
.
.
.P
But it is also possible to have the mode automatically selected when
the file is loaded into the editor.
.
.IP \(bu
The most general method is to include the following 3 comment lines at
the end of the file.
.
.RS
.IP
.EX
\&.\[rs]" Local Variables:
\&.\[rs]" mode: nroff
\&.\[rs]" End:
.EE
.RE
.
.IP \(bu
There is a set of file name extensions, e.g., the man pages that
trigger the automatic activation of the
.I nroff
mode.
.
.IP \(bu
Theoretically, it is possible to write the sequence
.
.RS
.IP
.EX
\&.\[rs]" \%\-*\-\ nroff\ \-*\-\""
.EE
.RE
.
.IP
as the first line of a file to have it started in
.I nroff
mode when loaded.
.
Unfortunately, some applications such as the
.B man
program are confused by this; so this is deprecated.
.
.
.\" ====================================================================
.SS "Editing with Vim"
.\" ====================================================================
.
.\" TODO: elvis, vile.  Nvi does not support highlighting at all, and
.\" gedit does but has no rules for roff yet.  Other editors TBD.
Besides Emacs, some other editors provide
.I nroff
style files too, e.g.,
.BR vim (1),
an extension of the
.BR vi (1)
program.
.
Vim's highlighting can be made to recognize
.I roff
files by setting the
.I filetype
option in a Vim
.IR modeline .
.
For this feature to work, your copy of
.B vim
must be built with support for, and configured to enable, several
features; consult the editor's online help topics
\[lq]auto\-setting\[rq], \[lq]filetype\[rq], and \[lq]syntax\[rq].
.
Then put the following at the end of your
.I roff
files,
after any Emacs configuration:
.\" ...because Emacs pattern-matches against 3000 bytes from the end of
.\" the buffer [or until hitting a 0x0C (FF, form-feed control)] for
.\" "Local Variables:", but Vim only checks as many lines as its
.\" 'modelines' variable tells it to.  A common default is "5", but
.\" Emacs settings can be longer than that.
.
.P
.
.RS
.IP
.EX
\&.\[rs]" vim: set filetype=groff:
.EE
.RE
.
.
.P
Replace \[lq]groff\[rq] in the above with \[lq]nroff\[rq] if you want
highlighing that does
.I not
recognize the GNU extensions to
.IR roff ,
such as request,
register,
and string names longer than two characters.
.
.
.\" ====================================================================
.SH Authors
.\" ====================================================================
.
This document was written by
.MT groff\-bernd\:.warken\-72@\:web\:.de
Bernd Warken
.ME ,
with the section \[lq]History\[rq] revised by
.MT g.branden.robinson@gmail.com
G.\& Branden Robinson
.ME .
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
There is a lot of documentation about
.IR roff .
.
The original papers describing AT&T
.I troff
are still available,
and all aspects of
.I groff
are documented in great detail.
.
.
.\" ====================================================================
.SS "Internet sites"
.\" ====================================================================
.
.P
.UR https://github.com/larrykollar/Unix-Text-Processing
.I Unix Text Processing
.UE ,
by Dale Dougherty and Tim O'Reilly,
1987,
Hayden Books.
.
This well-regarded text from 1987 brings the reader from a state of no
knowledge of Unix or text editing
(if necessary)
to sophisticated computer-aided typesetting.
.
It has been placed under a free software license by its authors and
updated by a team of
.I groff
contributors and enthusiasts.
.
.
.P
.UR http://\:manpages\:.bsd\:.lv/\:history\:.html
\[lq]History of Unix Manpages\[rq]
.UE ,
an online article maintained by the mdocml project,
provides an overview of
.I roff
development from Salzer's
.I RUNOFF
to 2008,
with links to original documentation and recollections of the authors
and their contemporaries.
.
.
.P
.UR http://\:www\:.troff\:.org/
troff.org
.UE ,
Ralph Corderoy's
.I troff
site,
provides an overview and pointers to much historical
.I roff
information.
.
.
.P
.UR http://\:www\:.multicians\:.org/
Multicians
.UE ,
a site by Multics enthusiasts,
contains a lot of information on the MIT projects CTSS and Multics,
including
.IR RUNOFF ;
it is especially useful for its glossary and the many links to
historical documents.
.
.
.P
.UR http://\:www\:.tuhs\:.org/\:Archive/
The Unix Archive
.UE ,
curated by the Unix Heritage Society,
provides the source code and some binaries of historical Unices
(including the source code of some versions of
.I troff
and its documentation)
contributed by their copyright holders.
.
.
.P
.UR http://\:web\:.mit\:.edu/\:Saltzer/\:www/\:publications/\
\:pubs\:.html
Jerry Saltzer's home page
.UE
stores some documents using the original
.I RUNOFF
formatting language.
.
.
.P
.UR http://\:www\:.gnu\:.org/\:software/\:groff
.I groff
.UE ,
GNU
.IR roff 's
web site ,
provides convenient access to
.IR groff 's
source code repository,
bug tracker,
and mailing lists
(including archives and the subscription interface).
.
.
.\" ====================================================================
.SS "Historical roff documentation"
.\" ====================================================================
.
Many AT&T
.I troff
documents are available online,
and can be found at Ralph Corderoy's site
(see above)
or via Internet search.
.
.
.P
Of foremost significance are two mentioned in section \[lq]History\[rq]
above,
describing the language and its device-independent implementation,
respectively.
.
.
.P
\[lq]Troff User's Manual\[rq];
Computing Science Technical Report #54;
Joseph F.\& Ossanna;
AT&T Bell Laboratories;
1976.
.
Revised by Brian Kernighan, November 1992.
.
.
.P
\[lq]A Typesetter-independent TROFF\[rq];
Computing Science Technical Report #54;
Brian W.\& Kernighan;
AT&T Bell Laboratories;
1981.
.
Revised March 1982.
.
.
.P
You can obtain many relevant Bell Labs papers in PDF from
.UR https://github.com/bwarken/roff_classical.git
Bernd Warken's
\[lq]roff classical\[rq]
GitHub repository
.UE .
.
.
.\" ====================================================================
.SS "Manual pages"
.\" ====================================================================
.
As a system of multiple components,
a
.I roff
system potentially has many man pages,
each describing an aspect of it.
.
Unfortunately,
there is no general naming scheme for the documentation among the
different
.I roff
implementations.
.
.
.P
For GNU
.IR roff ,
the
.IR groff (@MAN1EXT@)
man page offers a survey of all the documentation distributed with the
system.
.
.
.P
With other
.IR roff s,
you are on your own,
but
.IR troff (1) \" foreign troff
might be a good starting point.
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_roff_7_man_C]
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
