'\" e
.TH groff_diff @MAN7EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
groff_diff \- differences between GNU roff and AT&T troff
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 1989-2018, 2020 Free Software Foundation, Inc.
.\"
.\" This file is part of groff, the GNU roff type-setting system.
.\"
.\" Permission is granted to copy, distribute and/or modify this
.\" document under the terms of the GNU Free Documentation License,
.\" Version 1.3 or any later version published by the Free Software
.\" Foundation; with no Invariant Sections, with no Front-Cover Texts,
.\" and with no Back-Cover Texts.
.\"
.\" A copy of the Free Documentation License is included as a file
.\" called FDL in the main directory of the groff source package.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_groff_diff_7_man_C \n[.cp]
.cp 0
.
.
.\" ====================================================================
.\" Local definitions
.\" ====================================================================
.
.\" define a string tx for the TeX logo
.ie t .ds tx T\h'-.1667m'\v'.224m'E\v'-.224m'\h'-.125m'X
.el   .ds tx TeX
.
.
.\" from old groff_out.man
.ie \n(.g \
.  ds ic \/
.el \
.  ds ic \^
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
The GNU
.I roff
text processing system,
.IR groff ,
is largely compatible with
.RI AT&T\~ troff ,
the typesetting system originating in Unix systems of the 1970s.
.
At the same time,
.I groff
removes many arbitrary limitations and adds features,
both to the language and to the intermediate,
device-independent output format.
.
Differences arising from
.IR groff 's
implementation of
.RI AT&T\~ troff
features are also noted.
.
.
.\" ====================================================================
.SH Language
.\" ====================================================================
.
.I groff
features identifiers of arbitrary length,
supports non-integral point sizes,
adds new escapes and requests,
provides new conditional tests,
recognizes additional scale indicators and numerical operators,
and extends the function of some escapes and requests already present in
.RI AT&T\~ troff .
.
.
.\" ====================================================================
.SS "Long names"
.\" ====================================================================
.
.I groff
introduces many new requests;
with three exceptions,\" .cp, .do, .rj
they all have names longer than two characters.
.
The names of number registers,
fonts,
strings/\:macros/\:diversions,
environments,
special characters (glyphs),
and colors can be of any length.
.
More generally,
anywhere
.RI AT&T\~ troff
supports an escape form that uses an opening parenthesis \[lq](\[rq]
to introduce a two-character argument,
.I groff
supports a square-bracketed form \[lq][]\[rq] where the argument
within can be of arbitrary length.
.
.
.\" ====================================================================
.SS "Fractional point sizes and new scale indicators"
.\" ====================================================================
.
A
.I scaled point
is equal to
.RI 1/ sizescale
points,
where
.I sizescale
is a parameter specified in the device description file,
.IR DESC ,
and defaults to\~1.
.
A new scale
.RB indicator\~\[lq] z \[rq]
has the effect of multiplying by
.IR sizescale .
.
Requests and escapes in
.I groff
interpret arguments that represent a point size as being in units of
scaled points;
that is,
they evaluate such arguments using an implied default scale indicator
.RB of\~\[lq] z \[rq].
.
Arguments treated in this way comprise those to the escapes
.B \eH
and
.BR \es ,
to the request
.BR .ps ,
the third argument to the
.B .cs
request,
and the second and fourth arguments to the
.B .tkf
request.
.
.
.P
For example,
if
.I sizescale
is\~1000,
then a scaled point is one one-thousandth of a point.
.
The request
.RB \[lq] ".ps 10.25" \[rq]
is synonymous with
.RB \[lq] ".ps 10.25z" \[rq]
and sets the point size to 10250\~scaled points,
or 10.25\~points.
.
.
.P
Consequently,
in
.IR groff ,
the number register
.B \[rs]n[.s]
can contain a non-integral point size.
.
The new number register
.B \[rs]n[.ps]
returns the point size in scaled points.
.
.
.P
It makes no sense to use the
.RB \[lq] z \[rq]\~scale
indicator in a numeric expression whose default scale indicator is
neither
.RB \[lq] u \[rq]
.RB nor\~\[lq] z \[rq],
so
.I groff
disallows this.
.
Similarly,
it is nonsensical to use a scaling indicator other
.RB than\~\[lq] z \[rq]
.RB or\~\[lq] u \[rq]
in a numeric expression whose default scale indicator
.RB is\~\[lq] z \[rq],
so
.I groff
disallows this as well.
.
.
.P
Another new scale indicator,
.RB \[lq] s \[rq],
multiplies by the number of basic units in a scaled point.
.
For instance,
.RB \[lq] \[rs]n[.ps]s \[rq]
is equal to
.RB \[lq] 1m \[rq]
by definition.
.
Do not confuse the
.RB \[lq] s \[rq]
and
.RB \[lq] z \[rq]
scale indicators.
.
.
.P
A further two new measurement units available in
.I groff
are
.RB \[lq] M \[rq],
which indicates hundredths of an em,
and
.RB \[lq] f \[rq],
which is defined as 65536 basic units.
.
The latter provides convenient fractions for color definitions with the
.B .defcolor
request.
.
For example, 0.5f equals 32768u.
.
.
.\" ====================================================================
.SS "Numeric expressions"
.\" ====================================================================
.
Spaces are permitted in a numeric expression within parentheses.
.
Three new operators are available as well.
.
.
.TP
.IB e1 >? e2
Compute the maximum of
.I e1
and
.IR e2 .
.
.
.TP
.IB e1 <? e2
Compute the minimum of
.I e1
and
.IR e2 .
.
.
.TP
.BI ( c ; e )
Evaluate
.I e
using
.I c
as the default scaling indicator.
.
If
.I c
is missing,
ignore scaling indicators in the evaluation
.RI of\~ e .
.
.
.\" ====================================================================
.SS Conditions
.\" ====================================================================
.
More conditions can be tested with the
.B .if
and
.B .ie
requests,
as well as the new
.B .while
request.
.
.
.TP
.BI c\~ g
True if a glyph
.I g
is available,
where
.I g
is a Unicode basic Latin character;
a
.I groff
special character
.BI \[rs]( xx
or
.BI \[rs][ xxx\c
.BR ] ;
.BI \[rs]N\[aq] xxx\c
.BR \[aq] ;
or has been defined by the
.B .char
request.
.
.
.TP
.BI d\~ name
True if there is a string,
macro,
diversion,
or request called
.IR name .
.
.
.TP
.BI F\~ font
True if a font called
.I font
exists.
.
.I font
is handled as if it
were opened with the
.B .ft
request
(that is,
font translation and
styles are applied),
without actually mounting it.
.
This test doesn't load the complete font,
but only its header,
to verify its validity.
.
.
.TP
.BI m\~ color
True if there is a color called
.IR color .
.
.
.TP
.BI r\~ reg
True if there is a number register called
.IR reg .
.
.
.TP
.BI S\~ style
True if a style called
.I style
has been registered.
.
Font translation is applied.
.
.
.TP
.B v
Always false.
.
This condition is for compatibility with certain other
.I troff
implementations only.
.
(This refers to
.IR vtroff ,
a translator that would convert the C/A/T output from early-vintage
.RI AT&T\~ troff
to a form suitable for Versatec and Benson-Varian plotters.)

.
.
.\" ====================================================================
.SS "Escape sequences"
.\" ====================================================================
.
.I groff
introduces several new escape sequences
and extends the syntax of a few
.RI AT&T\~ troff
escapes
(namely,
.BR \[rs]D ,
.BR \[rs]f ,
.BR \[rs]k ,
.BR \[rs]n ,
.BR \[rs]$ ,
and
.BR \[rs]* ).
.
In the following list,
escapes are collated alphabetically at first,
and then by symbol roughly in Unicode code point order.
.\" Exceptions are made to group closely-related escapes in an order
.\" more agreeable to the development of a topic.
.
.
.TP
.BI \[rs]A\[aq] anything \[aq]
This expands to
.B 1
or\~\c
.BR 0 ,
depending on whether
.I anything
is or is not acceptable as the name of a string, macro, diversion,
number register, environment, font, or color.
.
It returns\~\c
.B 0
if
.I anything
is empty.
.
This is useful if you want to look up user input in some sort of
associative table.
.
.TP
.BI \[rs]B\[aq] anything \[aq]
This expands to
.B 1
or\~\c
.BR 0 ,
depending on whether
.I anything
is or is not a valid numeric expression.
.
It returns\~\c
.B 0
if
.I anything
is empty.
.
.TP
.BR \[rs]D\[aq] .\|.\|. \[aq]
All drawing commands supported by the
.RI AT&T\~ troff
device-independent
intermediate output format are accepted.
.
See subsection \[lq]Drawing Commands\[rq] below
for GNU extensions.
.
.TP
.B \[rs]E
This is equivalent to an escape character, but it is not interpreted in
copy mode.
.
Strings to start and end superscripting could be defined as follows.
.
.RS
.IP
.EX
\&.ds { \[rs]v\[aq]\-.3m\[aq]\[rs]s\[aq]\[rs]En[.s]*6u/10u\[aq]
\&.ds } \[rs]s0\[rs]v\[aq].3m\[aq]
.EE
.RE
.
.IP
The use of
.B \[rs]E
ensures that these definitions work even if
.B \[rs]*{
gets interpreted in copy mode (for example, by being used in a macro
argument).
.
.TP
.BI \[rs]f[ xxx ]
Set font
.IR xxx .
.
Additionally,
.B \[rs]f[]
is a new syntax form equal to
.BR \[rs]fP ,
i.e., to return to the previous font.
.
.TP
.BI \[rs]F f
.TQ
.BI \[rs]F( fm
.TQ
.BI \[rs]F[ fam ]
Change font family.
.
This is the same as the
.B .fam
request.
.
.B \[rs]F[]
switches back to the previous font family (note that
.B \[rs]FP
won't work; it selects font family \[oq]P\[cq] instead).
.
.TP
.BI \[rs]k( rg
.TQ
.BI \[rs]k[ reg ]
Mark horizontal position in register with two-character
.RI name\~ rg
or arbitrarily long
.RI name\~ reg .
.
.TP
.BI \[rs]m x
.TQ
.BI \[rs]m( xx
.TQ
.BI \[rs]m[ xxx ]
Set drawing color.
.B \[rs]m[]
switches back to the previous color.
.
.TP
.BI \[rs]M x
.TQ
.BI \[rs]M( xx
.TQ
.BI \[rs]M[ xxx ]
Set background color for filled objects drawn with the
.BR \[rs]D\[aq] .\|.\|.\& \[aq]
commands.
.B \[rs]M[]
switches back to the previous color.
.
.TP
.BI \[rs]n[ xxx ]
Interpolate number register
.IR xxx .
.
.TP
.BI \[rs]O n
.TQ
.BI \[rs]O[ n ]
Suppress troff output.
.
The escapes
.BR \[rs]O2 ,
.BR \[rs]O3 ,
.BR \[rs]O4 ,
and
.B \[rs]O5
are intended for internal use by
.BR \%grohtml .
.
.RS
.TP
.B \[rs]O0
Disable glyphs from being emitted to the device driver,
provided that the escape occurs at the outer level
(see
.B \[rs]O3
and
.BR \[rs]O4 ).
.
.TP
.B \[rs]O1
Enable output of glyphs, provided that the escape occurs at the outer
level.
.IP
.B \[rs]O0
and
.B \[rs]O1
also reset the registers
.BR \[rs]n[opminx] ,
.BR \[rs]n[opminy] ,
.BR \[rs]n[opmaxx] ,
and
.B \[rs]n[opmaxy]
to\~\-1.
.
These four registers mark the top left and bottom right hand corners
of a box which encompasses all written glyphs.
.
.TP
.B \[rs]O2
Provided that the escape occurs at the outer level, enable output of
glyphs and also write out to stderr the page number and four registers
encompassing the glyphs previously written since the last call to
.BR \[rs]O .
.
.TP
.B \[rs]O3
Begin a nesting level.
.
At start-up,
.B troff
is at outer level.
.
This is really an internal mechanism for
.B \%grohtml
while producing images.
.
They are generated by running the troff source through
.B troff
to the PostScript device and
.B ghostscript
to produce images in PNG format.
.
The
.B \[rs]O3
escape starts a new page if the device is not html (to reduce the
possibility of images crossing a page boundary).
.
.TP
.B \[rs]O4
End a nesting level.
.
.TP
.BI \[rs]O5[ Pfilename ]
This escape is
.B \%grohtml
specific.
.
Provided that this escape occurs at the outer nesting level, write
.I filename
to stderr.
.
The position of the image,
.IR P ,
must be specified and must be one of
.BR l ,
.BR r ,
.BR c ,
or
.B i
(left, right, centered, inline).
.
.I filename
is associated with the production of the next inline image.
.RE
.
.TP
.BI \[rs]R\[aq] name\~\[+-]n \[aq]
This has the same effect as
.
.RS
.IP
.BI .nr\~ name\~\[+-]n
.RE
.
.TP
.BI \[rs]s[ \[+-]n ]
.TQ
.BI \[rs]s \[+-] [ n ]
.TQ
.BI \[rs]s\[aq] \[+-]n \[aq]
.TQ
.BI \[rs]s \[+-] \[aq] n \[aq]
Set the point size to
.I n
scaled points;
.I n
is a numeric expression with a default scale indicator of\~\c
.BR z .
.
.TP
.BI \[rs]V x
.TQ
.BI \[rs]V( xx
.TQ
.BI \[rs]V[ xxx ]
Interpolate the contents of the environment variable
.IR xxx ,
as returned by
.BR getenv (3).
.B \[rs]V
is interpreted in copy mode.
.
.TP
.BI \[rs]Y x
.TQ
.BI \[rs]Y( xx
.TQ
.BI \[rs]Y[ xxx ]
This is approximately equivalent to
.BI \[rs]X\[aq]\[rs]*[ xxx ]\[aq]\f[R].
However the contents of the string or macro
.I xxx
are not interpreted; also it is permitted for
.I xxx
to have been defined as a macro and thus contain newlines (it is not
permitted for the argument to
.B \[rs]X
to contain newlines).
.
The inclusion of newlines requires an extension to the
.RI AT&T\~ troff
output format,
and confuses drivers that do not know about this extension.
.
.TP
.BI \[rs]Z\[aq] anything \[aq]
Print anything and then restore the horizontal and vertical position;
.I anything
may not contain tabs or leaders.
.
.TP
.B \[rs]#
Everything up to and including the next newline is ignored.
.
This is interpreted in copy mode.
.
It is like
.B \[rs]"
except that
.B \[rs]"
does not ignore the terminating newline.
.
.\" Keep \$0 before \$( in spite of collation.
.TP
.B \[rs]$0
The name by which the current macro was invoked.
.
The
.B als
request can make a macro have more than one name.
.
.TP
.BI \[rs]$( nn
.TQ
.BI \[rs]$[ nnn ]
In a macro or string, this gives the
.IR nn -th
or
.IR nnn -th
argument.
.
Macros and strings can have an unlimited number of arguments.
.
.TP
.B \[rs]$*
In a macro or string, the concatenation of all the arguments separated
by spaces.
.
.TP
.B \[rs]$@
In a macro or string, the concatenation of all the arguments with each
surrounded by double quotes, and separated by spaces.
.
.TP
.B \[rs]$^
In a macro, the representation of all parameters as if they were an
argument to the
.B ds
request.
.
.TP
.B \[rs])
Like
.B \[rs]&
except that it behaves like a character declared with the
.B .cflags
request to be transparent for the purposes of end-of-sentence
recognition.
.
.TP
.BI \[rs]*[ "xxx arg1 arg2\~"\c
\&.\|.\|.]
Interpolate string
.IR xxx ,
taking
.IR arg1 ,
.IR arg2 ,
\&.\|.\|.\&
as arguments.
.
.\" Keep \/ before \, in spite of collation.
.TP
.B \[rs]/
This increases the width of the preceding glyph so that the
spacing between that glyph and the following glyph is
correct if the following glyph is a roman glyph.
.
.if t \{\
.  nop For example, if an italic\~f is immediately followed by a roman
.  nop right parenthesis, then in many fonts the top right portion of
.  nop the\~f overlaps the top left of the right parenthesis
.  nop producing \f[I]f\f[R]), which is ugly.
.  nop Inserting
.  B \[rs]/
.  nop produces
.  ie \n(.g \f[I]f\/\f[R])
.  el       \f[I]f\|\f[R])
.  nop and avoids this problem.
.\}
It is a good idea to use this escape sequence whenever an italic
glyph is immediately followed by a roman glyph without any
intervening space.
.
.TP
.B \[rs],
This modifies the spacing of the following glyph so that the
spacing between that glyph and the preceding glyph is
correct if the preceding glyph is a roman glyph.
.
.if t \{\
.  nop For example, inserting
.  B \[rs],
.  nop between the parenthesis and the\~f changes
.  nop \f[R](\f[I]f\f[R] to
.  ie \n(.g \f[R](\,\f[I]f\f[R].
.  el       \f[R](\^\f[I]f\f[R].
.\}
It is a good idea to use this escape sequence whenever a roman
glyph is immediately followed by an italic glyph without any
intervening space.
.
.TP
.B \[rs]:
Insert a non-printing break point.
.
That is,
the word can break there,
but the soft hyphen glyph is not written to the output if it does
(in contrast to
.RB \[lq] \[rs]% \[rq]).
.
Note that breaks are word boundaries,
so if a break is inserted,
the remainder of the (input) word is subject to hyphenation as normal.
.
.
.IP
You can use
.B \[rs]:
and
.B \[rs]%
in combination to control breaking of a filename or URL.
.
.
.RS
.RS
.IP
.EX
\&.\|.\|.\& check \e%/var/log/\e:\e%httpd/\e:\e%access_log .\|.\|.
.EE
.RE
.RE
.
.
.TP
.BI \[rs]? anything \[rs]?
When used in a diversion, this transparently embeds
.I anything
in the diversion.
.I anything
is read in copy mode.
.
When the diversion is reread,
.I anything
is interpreted.
.I anything
may not contain newlines; use
.B \[rs]!\&
if you want to embed newlines in a diversion.
.
The escape sequence
.B \[rs]?\&
is also recognized in copy mode and turned into a single internal
code; it is this code that terminates
.IR anything .
Thus
.
.RS
.IP
.EX
.ne 14v+\n(.Vu
\&.nr x 1
\&.nf
\&.di d
\&\[rs]?\[rs]\[rs]?\[rs]\[rs]\[rs]\[rs]?\[rs]\[rs]\[rs]\[rs]\[rs]\[rs]\
\[rs]\c
\&\[rs]nx\[rs]\[rs]\[rs]\[rs]?\[rs]\[rs]?\[rs]?
\&.di
\&.nr x 2
\&.di e
\&.d
\&.di
\&.nr x 3
\&.di f
\&.e
\&.di
\&.nr x 4
\&.f
.EE
.RE
.
.IP
prints\~\c
.BR 4 .
.
.TP
.BI \[rs][ xxx ]
Print the special character (glyph) called
.IR xxx .
.
.TP
.BI \[rs][ "comp1 comp2\~"\c
\&.\|.\|.]
Print composite glyph consisting of multiple components.
.
Example: \[oq]\[rs][A\~ho]\[cq] is capital letter A with ogonek which
finally maps to glyph name \[oq]u0041_0328\[cq].
.
See
.IR "Groff: The GNU Implementation of troff" ,
the
.I groff
Texinfo manual,
for details of how a glyph name for a composite glyph is constructed,
and
.BR groff_char (@MAN7EXT@)
for a list of glyph name components used in composite glyph names.
.
.TP
.B \[rs]\[ti]
This produces an unbreakable space that stretches like a normal
inter-word space when a line is adjusted.
.
.
.\" ====================================================================
.SS "New requests"
.\" ====================================================================
.
.TP
.BI .aln\~ "new old"
Create an alias
.I new
for an existing number register named
.IR old ,
causing the names to refer to the same stored object.
.
If
.I old
is undefined,
a warning of type
.RB \[lq] reg \[rq]
is generated and the request is ignored.
.
To remove a number register alias,
call
.B .rr
on its name.
.
A number register's contents do not become inaccessible until it has no
more names.
.
.
.TP
.BI .als\~ "new old"
Create an alias
.I new
for the existing request,
string,
macro,
or diversion named
.IR old ,
causing the names to refer to the same stored object.
.
If
.I old
is undefined,
a warning of type
.RB \[lq] mac \[rq]
is generated and the request is ignored.
.
The
.BR .am ,
.BR .as ,
.BR .da ,
.BR .de ,
.BR .di ,
and
.B .ds
requests
(together with their variants)
only create a new object if the name of the macro,
diversion,
or string is currently undefined
or if it is defined as a request;
normally,
they modify the value of an existing object.
.
To remove an alias,
simply call
.B .rm
on its name.
.
The object itself is not destroyed until it has no more names.
.
.
.TP
.BI .am1\~ xx\~yy
Similar to
.BR .am ,
but compatibility mode is switched off during execution.
.
To be more precise,
a \[lq]compatibility save\[rq] token is inserted at the beginning,
and a \[lq]compatibility restore\[rq] token at the end.
.
As a consequence,
the requests
.BR .am ,
.BR .am1 ,
.BR .de ,
and
.B .de1
can be intermixed freely since the compatibility save/\:restore tokens
only affect the macro parts defined by
.B .am1
and
.BR .ds1 .
.
.
.TP
.BI .ami\~ xx\~yy
Append to macro indirectly.
.
See the
.B dei
request below for more information.
.
.TP
.BI .ami1\~ xx\~yy
Same as the
.B ami
request but compatibility mode is switched off during execution.
.
.
.TP
.BI .as1\~ "name string"
Similar to
.BR .as ,
but compatibility mode is switched off when the appended portion of the
string is later interpolated.
.
To be more precise,
a \[lq]compatibility save\[rq] token is inserted at the beginning of the
appended string
.IR string ,
and a \[lq]compatibility restore\[rq] token at the end.
.
As a consequence,
the requests
.BR .as ,
.BR .as1 ,
.BR .ds ,
and
.B .ds1
can be intermixed freely since the compatibility save/\:restore tokens
only affect the (sub)strings defined by
.B .as1
and
.BR .ds1 .
.
.
.TP
.BI .asciify\~ div
.I Unformat
the diversion
.I div
in a way such that Unicode basic Latin (ASCI) characters,
characters translated with the
.B .trin
request,
space characters,
and some escape sequences,
that were formatted and diverted into
.I div
are treated like ordinary input characters when
.I div
is reread.
.
Doing so can be useful in conjunction with the
.B .writem
request.
.
.B .asciify
can be also used for gross hacks;
for example,
the following sets
.RB register\~ n
to\~1.
.
.
.RS
.IP
.EX
.ne 8v+\n(.Vu
\&.tr @.
\&.di x
\&@nr n 1
\&.br
\&.di
\&.tr @@
\&.asciify x
\&.x
.EE
.RE
.
.
.IP
.B .asciify
cannot return all items in a diversion back to their source equivalent;
nodes such as those produced by
.BR \[rs]N[ .\|.\|.\& ]
will remain nodes,
so the result cannot be guaranteed to be a pure string.
.
.
.IP
Glyph information
(font,
point size,
etc.)
is not preserved;
use
.B .unformat
instead to achieve that.
.
.
.TP
.B .backtrace
Write a backtrace of the input stack to the standard error stream.
.
Also see the
.B \-b
option of
.IR groff (@MAN1EXT@).
.
.
.TP
.BR .blm\~ [\c
.IR macro ]
Set a blank line trap.
.
If a blank line macro is thus defined,
.I groff
executes
.I macro
when a blank line is encountered in the input file,
instead of the usual behavior.
.
If no argument is supplied,
the default blank line behavior is (re-)asserted.
.
.
.TP
.BI .box\~ xx
.TQ
.BI .boxa\~ xx
These requests are similar to the
.B di
and
.B da
requests with the exception that a partially filled line does not
become part of the diversion (i.e., the diversion always starts with a
new line) but is restored after ending the diversion, discarding the
partially filled line which possibly comes from the diversion.
.
.TP
.B .break
Break out of a while loop.
.
See also the
.B while
and
.B continue
requests.
.
Be sure not to confuse this with the
.B br
request.
.
.TP
.B .brp
This is the same as
.BR \[rs]p .
.
.TP
.BI .cflags\~ "n c1 c2\~"\c
\&.\|.\|.
Assign properties encoded by the number
.I n
to characters
.IR c1 ,
.IR c2 ,
and so on.
.
.IP
Input characters,
including special characters introduced by an escape,
have certain properties associated with them.
.
(Note that output glyphs don't have such properties.
.
In
.IR groff ,
a glyph is a numbered box with a given height above and depth below the
baseline,
and a width\[em]nothing more.)
.
These properties can be modified with this request.
.
The first argument is the sum of the desired flags and the remaining
arguments are the characters to be assigned those properties.
.
Spaces between the
.I cn
arguments are optional.
.
Any argument
.I cn
can be a character class defined with the
.B .class
request rather than an individual character.
.
.IP
The non-negative integer
.I n
is the sum of any of the following.
.
Some combinations are nonsensical,
such as
.RB \[lq] 33 \[rq]
(1 + 32).
.
.RS
.IP 1
Recognize the character as ending a sentence if followed by a newline
or two spaces.
.
Initially,
characters
.RB \[lq] .?! \[rq]
have this property.
.
.IP 2
Enable breaks before the character.
.
A line is not broken at a character with this property unless the
characters on each side both have non-zero hyphenation codes.
.
This exception can be overridden by adding 64.
.
Initially,
no characters have this property.
.
.IP 4
Enable breaks after the character.
.
A line is not broken at a character with this property unless the
characters on each side both have non-zero hyphenation codes.
.
This exception can be overridden by adding 64.
.
Initially,
characters
.RB \[lq] \-\[rs][hy]\[rs][em] \[rq]
have this property.
.
.IP 8
Mark the glyph associated with this character as overlapping other
instances of itself horizontally.
.
Initially,
characters
.RB \[lq] \[rs][ul]\[rs][rn]\[rs][ru]\[rs][radicalex]\[rs][sqrtex] \[rq]
have this property.
.
.IP 16
Mark the glyph associated with this character as overlapping other
instances of itself vertically.
.
Initially,
the character
.RB \[lq] \[rs][br] \[rq]
has this property.
.
.IP 32
Mark the character as transparent for the purpose of end-of-sentence
recognition.
.
In other words,
an end-of-sentence character followed by any number of characters with
this property is treated as the end of a sentence if followed by a
newline or two spaces.
.
This is the same as having a zero space factor in \*[tx].
.
Initially,
characters
.\" The following is ordered with the apostrophe and (single) closing
.\" quote on the ends so they are more easily visually distinguished
.\" from the double quotation marks in roman.
.RB \[lq] \[aq]")]*\[rs][dg]\[rs][dd]\[rs][rq]\[rs][cq] \[rq]
have this property.
.
.IP 64
Ignore hyphenation codes of the surrounding characters.
.
Use this value in combination with values 2 and\~4.
.
Initially,
no characters have this property.
.
.IP
For example,
if you need an automatic break point after
the en-dash in numerical ranges like \[lq]3000\[en]5000\[rq],
insert
.RS
.RS
.EX
\&.cflags 68 \[rs][en]
.EE
.RE
into your document.
.
Note,
however,
that this can lead to bad layout if done without thinking;
in most situations,
a better solution than
changing the
.B .cflags
value is inserting
.RB \[lq] \[rs]: \[rq]
right after the hyphen at the places that really need a break point.
.RE
.
.PP
The remaining values were implemented for East Asian language support;
those who use alphabetic scripts exclusively can disregard them.
.
.IP 128
Prohibit a break before the character,
but allow a break after the character.
.
This works only in combination with values 256 and 512 and has no effect
otherwise.
.
Initially,
no characters have this property.
.
.IP 256
Prohibit a break after the character,
but allow a break before the character.
.
This works only in combination with values 128 and 512 and has no effect
otherwise.
.
Initially,
no characters have this property.
.
.IP 512
Allow a break before or after the character.
.
This works only in combination with values 128 and 256 and has no effect
otherwise.
.
Initially,
no characters have this property.
.RE
.
.IP
In contrast to values 2 and\~4,
the values 128,
256,
and 512 work
pairwise.
.
If,
for example,
the left character has value 512,
and the right character 128,
no break will be automatically inserted between them.
.
If we use value\~6 instead for the left character,
a break after the character can't be suppressed since the neighboring
character on the right doesn't get examined.
.
.
.TP
.BI .char\~ "g string"
Define a new character or
.RI glyph\~ g
to be
.IR string ,
which can be empty.
.
More precisely,
.B .char
defines a
.I groff
object
(or redefines an existing one)
that is accessed with the
.RI name\~ g
on input,
and produces
.I string
on output.
.
Every time
.RI glyph\~ g
needs to be printed,
.I string
is processed in a temporary environment and the result is wrapped up
into a single object.
.
Compatibility mode is turned off and the escape character is
set
.RB to\~ \[rs]
while
.I string
is processed.
.
Any emboldening,
constant spacing,
or track kerning is applied to this object rather than to individual
glyphs in
.IR string .
.
.
.IP
An object defined by this request can be used just like a normal glyph
provided by the output device.
.
In particular,
other characters can be translated to it with the
.B .tr
request;
it can be made the leader glyph with the
.B .lc
request;
repeated patterns can be drawn with it using the
.B \[rs]l
and
.B \[rs]L
escape sequences;
and words
.RI containing\~ g
can be hyphenated correctly,
if the
.B .hcode
request is used to give the object a hyphenation code.
.
.
.IP
There is a special anti-recursion feature:
use of the object within its own definition is handled like a normal
character
(one not defined with
.BR .char ).
.
.
.IP
The
.B .tr
and
.B .trin
requests take precedence if
.B .char
accesses the same symbol.
.
.
.IP
A glyph definition can be removed with the
.B .rchar
request.
.
.
.TP
.BI .chop\~ object
Remove the last character from the macro,
string,
or diversion
named
.IR object .
.
This is useful for removing the newline from the end of a diversion that
is to be interpolated as a string.
.
This request can be used repeatedly on the same
.IR object ;
see section \[lq]Gtroff Internals\[rq] in
.IR "Groff: The GNU Implementation of troff" ,
the
.I groff
Texinfo manual,
for details on nodes inserted additionally by
.IR groff .
.
.
.TP
.BI .class\~ "name c1 c2\~"\c
\&.\|.\|.
Define a character class
(or simply \[lq]class\[rq])
.I name
comprising the characters or range expressions
.IR c1 ,
.IR c2 ,
and so on.
.
.IP
A class thus defined can then be referred to in lieu of listing all the
characters within it.
.
Currently,
only the
.B .cflags
request can handle references to character classes.
.
.IP
In the request's simplest form,
each
.I cn
is a character
(or special character).
.
.RS
.RS
.EX
\&.class [quotes] \[aq] \[rs][aq] \[rs][dq] \[rs][oq] \[rs][cq] \
\[rs][lq] \[rs][rq]
.EE
.RE
.RE
.
.IP
Since class and glyph names share the same name space,
it is recommended to start and end the class name with
.RB \[lq] [ \[rq]
and
.RB \[lq] ] \[rq],
respectively,
to avoid collisions with existing character names defined by
.I groff
or the user
(with
.B .char
and related requests).
.
This practice applies the presence of
.RB \[lq] ] \[rq]
in the class name to prevent the usage of the special character escape
form
.RB \[lq] \[rs][ .\|.\|. ] \[rq],
thus you must use the
.B \[rs]C
escape to access a class with such a name.
.
.
.IP
You can also use a character range expression consisting of a start
character followed by
.RB \[lq] \- \[rq]
and then an end character.
.
Internally,
.I groff
converts these two character names to Unicode code points
(according to the
.I groff
glyph list [GGL]),
which determine the start and end values of the range.
.
If that fails,
the class definition is skipped.
.
Furthermore,
classes can be nested.
.
.RS
.RS
.EX
\&.class [prepunct] , : ; > }
\&.class [prepunctx] \[rs]C\[aq][prepunct]\[aq] \
\[rs][u2013]\-\[rs][u2016]
.EE
.RE
The class
.RB \[lq] [prepunctx] \[rq]
thus contains the contents of the class
.RB \[lq] [prepunct] \[rq]
and characters in the range U+2013\[en]U+2016.
.RE
.
.
.IP
If you want to include
.RB \[lq] \- \[rq]
in a class,
it must be the first character value in the argument list,
otherwise it gets misinterpreted as part of the range syntax.
.
.
.IP
Note that it is not possible to use class names as end points of range
definitions.
.
.
.IP
A typical use of the
.B .class
request is to control line-breaking and hyphenation rules as defined by
the
.B .cflags
request.
.
For example,
to inhibit line breaks before the characters belonging to the
.RB \[lq] [prepunctx] \[rq]
class defined in the previous example,
you can write the following.
.
.RS
.RS
.EX
\&.cflags 2 \[rs]C\[aq][prepunctx]\[aq]
.EE
.RE
.RE
.
.
.TP
.BI .close\~ stream
Close the stream named
.IR stream ;
.I stream
will no longer be an acceptable argument to the
.B write
request.
.
See the
.B open
request.
.
.TP
.BI .composite\~ glyph1\~glyph2
Map glyph name
.I glyph1
to glyph name
.I glyph2
if it is used in
.BR \[rs][ .\|.\|.\& ]
with more than one component.
.
.TP
.B .continue
Finish the current iteration of a while loop.
.
See also the
.B while
and
.B break
requests.
.
.TP
.BI .color\~ n
If
.I n
is non-zero or missing, enable colors (this is the default), otherwise
disable them.
.
.TP
.BI .cp\~ n
If
.I n
is non-zero or missing, enable compatibility mode, otherwise disable
it.
.
In compatibility mode, long names are not recognized, and the
incompatibilities caused by long names do not arise.
.
.TP
.BI .defcolor\~ xxx\~scheme\~color_components
Define color
.IR xxx .
.I scheme
can be one of the following values:
.B rgb
(three components),
.B cmy
(three components),
.B cmyk
(four components), and
.B gray
or
.B grey
(one component).
.
Color components can be given either as a hexadecimal string or as
positive decimal integers in the range 0\[en]65535.
.
A hexadecimal string contains all color components concatenated; it
must start with either
.B #
or
.BR ## .
The former specifies hex values in the range 0\[en]255 (which are
internally multiplied by\~257), the latter in the range 0\[en]65535.
.
Examples: #FFC0CB (pink), ##ffff0000ffff (magenta).
.
A new scaling indicator\~\c
.B f
has been introduced which multiplies its value by\~65536; this makes
it convenient to specify color components as fractions in the range 0
to\~1.
.
Example:
.
.RS
.IP
.EX
\&.defcolor darkgreen rgb 0.1f 0.5f 0.2f
.EE
.RE
.
.IP
Note that
.B f
is the default scaling indicator for the
.B defcolor
request, thus the above statement is equivalent to
.
.RS
.IP
.EX
\&.defcolor darkgreen rgb 0.1 0.5 0.2
.EE
.RE
.
.IP
The color named
.B default
(which is device-specific) can't be redefined.
.
It is possible that the default color for
.B \[rs]M
and
.B \[rs]m
is not the same.
.
.TP
.BI .de1\~ xx\~yy
Similar to
.BR .de ,
but compatibility mode is switched off during execution.
.
On entry, the current compatibility mode is saved and restored at exit.
.
.TP
.BI .dei\~ xx\~yy
Define macro indirectly.
.
The following example
.
.RS
.IP
.ne 2v+\n(.Vu
.EX
\&.ds xx aa
\&.ds yy bb
\&.dei xx yy
.EE
.RE
.
.IP
is equivalent to
.
.RS
.IP
.EX
\&.de aa bb
.EE
.RE
.
.TP
.BI .dei1\~ xx\~yy
Similar to the
.B dei
request but compatibility mode is switched off during execution.
.
.TP
.BI .device\~ anything
This is (almost) the same as the
.B \[rs]X
escape.
.I anything
is read in copy mode; a leading\~\c
.B \[dq]
is stripped.
.
.TP
.BI .devicem\~ xx
This is the same as the
.B \[rs]Y
escape (to embed the contents of a macro into the intermediate
output preceded with \[oq]x\~X\[cq]).
.
.TP
.BI .do\~ name\~\c
\&.\|.\|.
Interpret the string,
request,
diversion,
or macro
.I name
(along with any arguments)
with compatibility mode disabled.
.
Note that compatibility mode is restored
(if and only if it was active)
when the
.I expansion
of
.I name
is interpreted;
that is,
the restored compatibility state applies to the contents of the macro
(string, \&.\|.\|.\&)
.I name
as well as file or pipe data read if
.I name
is the
.BR .so ,
.BR .mso ,
or
.B .pso
request.
.
.IP
For example,
.RS
.RS \" one "extra" RS to get us inboard of this indented paragraph
.EX
\&.de mac1
FOO
\&..
\&.de1 mac2
groff
\&.mac1
\&..
\&.de mac3
compatibility
\&.mac1
\&..
\&.de ma
\[rs]\[rs]$1
\&..
\&.cp 1
\&.do mac1
\&.do mac2 \[rs]" mac2, defined with .de1, calls "mac1"
\&.do mac3 \[rs]" mac3 calls "ma" with argument "c1"
\&.do mac3 \[rs][ti] \[rs]" groff syntax accepted in .do arguments
.EE
.RE
results in
.RS
.EX
FOO groff FOO compatibility c1 \[ti]
.EE
.RE
as output.
.RE \" this "extra" RE avoids indentation of the remaining paragraphs
.
.TP
.BI .ds1\~ "name string"
Similar to
.BR .ds ,
but compatibility mode is switched off when the string is later
interpolated.
but compatibility mode is switched off during expansion.
.
To be more precise,
a \[lq]compatibility save\[rq] token is inserted at the beginning of the
string,
and a \[lq]compatibility restore\[rq] token at the end.
.
.
.TP
.B .ecs
Save current escape character.
.
.TP
.B .ecr
Restore escape character saved with
.BR ecs .
Without a previous call to
.BR ecs ,
.RB \[oq] \[rs] \[cq]
will be the new escape character.
.
.TP
.BI .evc\~ xx
Copy the contents of environment
.I xx
to the current environment.
.
No pushing or popping of environments is done.
.
.TP
.BI .fam\~ xx
Set the current font family to
.IR xx .
The current font family is part of the current environment.
If
.I xx
is missing, switch back to previous font family.
.
The value at start-up is \[oq]T\[cq].
.
See the description of the
.B sty
request for more information on font families.
.
.TP
.BI .fchar\~ c\~string
Define fallback character (or glyph)\~\c
.I c
to be
.IR string .
.
The syntax of this request is the same as the
.B char
request; the only difference is that a glyph defined with
.B char
hides the glyph with the same name in the current font, whereas a
glyph defined with
.B .fchar
is checked only if the particular glyph isn't found in the current
font.
.
This test happens before checking special fonts.
.
.TP
.BI .fcolor\~ c
Set the fill color to\~\c
.IR c .
If
.I c
is missing,
switch to the previous fill color.
.
.TP
.BI .fschar\~ f\~c\~string
Define fallback character (or glyph)\~\c
.I c
for font\~\c
.I f
to be
.IR string .
.
The syntax of this request is the same as the
.B char
request (with an additional argument to specify the font); a glyph
defined with
.B fschar
is searched after the list of fonts declared with the
.B fspecial
request but before the list of fonts declared with
.BR .special .
.
.TP
.BI .fspecial\~ "f s1 s2\~"\c
\&.\|.\|.
When the current font is\~\c
.IR f ,
fonts
.IR s1 ,
.IR s2 ,
\&.\|.\|.\&
are special,
that is,
they are searched for glyphs not in the current font.
.
Any fonts specified in the
.B .special
request are searched after fonts specified in the
.B .fspecial
request.
.
Without argument,
reset the list of global special fonts to be empty.
.
.TP
.BI .ftr\~ f\~g
Translate font\~\c
.I f
to\~\c
.IR g .
Whenever a font named\~\c
.I f
is referred to in an
.B \[rs]f
escape sequence, in the
.B F
and
.B S
conditional operators, or in the
.BR ft ,
.BR ul ,
.BR bd ,
.BR cs ,
.BR tkf ,
.BR special ,
.BR fspecial ,
.BR fp ,
or
.B sty
requests, font\~\c
.I g
is used.
If
.I g
is missing, or equal to\~\c
.I f
then font\~\c
.I f
is not translated.
.
.TP
.BI .fzoom\~ f\~zoom
Set zoom factor
.I zoom
for font\~\c
.IR f .
.I zoom
must a non-negative integer multiple of 1/1000th.
If it is missing or is equal to zero, it means the same as 1000, namely
no magnification.
.IR f \~\c
must be a real font name, not a style.
.
.TP
.BI .gcolor\~ c
Set the glyph color to\~\c
.IR c .
If
.I c
is missing,
switch to the previous glyph color.
.
.
.TP
.BI .hcode\~ "c1 code1\~"\c
.RI [ "c2 code2" "] .\|.\|."
Set the hyphenation code of character
.I c1
to
.IR code1 ,
that of
.I c2
to
.IR code2 ,
and so on.
.
A hyphenation code must be a single input character
(not a special character)
other than a digit or a space.
.
The request is ignored if it has no parameters.
.
.
.IP
For hyphenation to work,
hyphenation codes must be set up.
.
At start-up,
.I groff
assigns hyphenation codes to the letters \[lq]a\[en]z\[rq]
(mapped to themselves)
and to the letters \[lq]A\[en]Z\[rq]
(mapped to \[lq]a\[en]z\[rq])
and zero to all other characters.
.
Normally,
hyphenation patterns contain only lowercase letters which should be
applied regardless of case.
.
In other words,
they assume that the words \[lq]FOO\[rq] and \[lq]Foo\[rq] should be
hyphenated exactly as \[lq]foo\[rq] is.
.
The
.B .hcode
request extends this principle to letters outside the Unicode basic
Latin alphabet;
without it,
words containing such letters won't be hyphenated properly even if the
corresponding hyphenation patterns contain them.
.
For example,
the following
.B .hcode
requests are necessary to assign hyphenation codes to the letters
\[lq]\[:A]\[:a]\[:O]\[:o]\[:U]\[:u]\[ss]\[rq]
(needed for German):
.
.
.RS
.IP
.EX
\&.hcode \[:a] \[:a]  \[:A] \[:a]
\&.hcode \[:o] \[:o]  \[:O] \[:o]
\&.hcode \[:u] \[:u]  \[:U] \[:u]
\&.hcode \[ss] \[ss]
.EE
.RE
.
.
.IP
Without those assignments,
.I groff
treats German words like \[lq]Kinderg\[:a]rten\[rq]
(the plural form of \[lq]kindergarten\[rq])
as two substrings \[lq]kinderg\[rq] and \[lq]rten\[rq]) because the
hyphenation code of the umlaut\~a is zero by default.
.
There is a German hyphenation pattern that covers \[lq]kinder\[rq],
so
.I groff
finds the hyphenation \[lq]kin-der\[rq].
.
The other two hyphenation points
(\[lq]kin-der-gär-ten\[rq])
are missed.
.
.
.TP
.BI .hla\~ lang
Set the hyphenation language to
.IR lang .
.
Hyphenation exceptions specified with the
.B .hw
request and hyphenation patterns and exceptions specified with the
.B .hpf
and
.B .hpfa
requests are associated with the hyphenation language.
.
The
.B .hla
request is usually invoked by the
.I troffrc
or
.I troffrc\-end
files;
.I troffrc
sets the default language to \[lq]us\[rq]
(U.S. English).
.
.
.IP
The hyphenation language is associated with the current environment.
.
.
.TP
.BR .hlm\~ [\c
.IR n ]
Set the maximum number of consecutive hyphenated lines
.RI to\~ n .
.
If
.I n
is negative,
there is no maximum.
.
If omitted,
.I n
is\~\-1.
.
This value is associated with the current environment.
.
Only lines output from an environment count towards the maximum
associated with that environment.
.
Hyphens resulting from
.B \[rs]%
are counted; explicit hyphens are not.
.
.
.TP
.BI .hpf\~ pattern-file
Read hyphenation patterns from
.IR pattern-file .
.
This file is sought in the same way that macro files are with the
.B .mso
request or the
.BI \-m name
command-line option to
.IR groff (@MAN1EXT@).
.
.
.IP
The
.I pattern-file
should have the same format as (simple) \*[tx] pattern files.
.
More specifically,
the following scanning rules are implemented.
.
.
.RS
.IP \[bu]
A percent sign starts a comment
(up to the end of the line)
even if preceded by a backslash.
.
.
.IP \[bu]
\[lq]Digraphs\[rq] like
.B \[rs]$
are not supported.
.
.
.IP \[bu]
.RB \[lq] \[ha]\[ha]\c
.IR xx \[rq]
(where each
.I x
is 0\[en]9 or a\[en]f) and
.BI \[ha]\[ha] c
.RI (character\~ c
in the code point range 0\[en]127 decimal)
are recognized;
other uses
.RB of\~ \[ha]
cause an error.
.
.
.IP \[bu]
No macro expansion is performed.
.
.
.IP \[bu]
.B hpf
checks for the expression
.BR \[rs]patterns{ .\|.\|. }
(possibly with whitespace before or after the braces).
.
Everything between the braces is taken as hyphenation patterns.
.
Consequently,
.RB \[lq] { \[rq]
and
.RB \[lq] } \[rq]
are not allowed in patterns.
.
.
.IP \[bu]
Similarly,
.BR \[rs]hyphenation{ .\|.\|. }
gives a list of hyphenation exceptions.
.
.
.IP \[bu]
.B \[rs]endinput
is recognized also.
.
.
.IP \[bu]
For backwards compatibility,
if
.B \[rs]patterns
is missing,
the whole file is treated as a list of hyphenation patterns
(except that the
.RB \[lq] % \[rq]
character is recognized as the start of a comment).
.RE
.
.
.IP
Use the
.B .hpfcode
request
(see below)
to map the encoding used in hyphenation pattern files to
.IR groff 's
input encoding.
.
.
.IP
The set of hyphenation patterns is associated with the hyphenation
language set by the
.B .hla
request.
.
The
.B .hpf
request is usually invoked by the
.I troffrc
or
.I troffrc\-end
file;
by default,
.I troffrc
loads hyphenation patterns and exceptions for U.S. English from the
files
.I hyphen.us
and
.IR hyphenex.us ,
respectively.
.
.
.IP
A second call to
.B .hpf
(for the same language)
replaces the old patterns with the new ones.
.
.
.IP
Invoking
.B .hpf
causes an error if there is no hyphenation language.
.
.
.IP
If no
.B .hpf
request is specified
(either in the document,
in a
.I troffrc
or
.I troffrc\-end
file,
or in a macro package),
.I groff
won't automatically hyphenate at all.
.
.
.TP
.BI .hpfa\~ pattern-file
As
.BR .hpf ,
except that the hyphenation patterns and exceptions from
.I pattern-file
are appended to the patterns already applied to the hyphenation language
of the environment.
.
.
.TP
.BI .hpfcode\~ "a b"\c
.RI \~[ "c d" "] .\|.\|."
Define mapping values for character codes in pattern files;
after reading a pattern file with the
.B .hpf
or
.B .hpfa
request,
convert all characters with character
.RI code\~ a
in the recently read patterns to character
.RI code\~ b ,
.RI code\~ c
.RI to\~ d ,
and so on,
before replacing or appending to the active list of patterns.
.
Each argument must be an integer in the range 0 to\~255.
.
Character codes that would otherwise be invalid in
.I groff
can be used.
.
By default,
every code maps to itself except those for letters \[lq]A\[rq] to
\[lq]Z\[rq],
which map to those for \[lq]a\[rq] to \[lq]z\[rq].
.
.
.TP
.BR .hym\~ [\c
.IR length ]
Set the (right) hyphenation margin
.RI to\~ length .
.
If the adjustment mode is not
.RB \[lq] b \[rq]
or
.RB \[lq] n \[rq],
the line is not hyphenated if it is shorter than
.IR length .
.
Without an argument,
the default hyphenation margin is reset to its default value,
0.
.
The default scaling indicator
.RB is\~\[lq] m \[rq].
.
The hyphenation margin is associated with the current environment.
.
.
.IP
A negative argument resets the hyphenation margin to zero,
emitting a warning of type \[lq]range\[rq].
.
.
.TP
.BR .hys\~ [\c
.IR hyphenation-space ]
Suppress hyphenation of the line in adjustment modes
.RB \[lq] b \[rq]
or
.RB \[lq] n \[rq],
if it can be justified by adding no more than
.I hyphenation-space
extra space to each inter-word space.
.
Without an argument,
the hyphenation space adjustment threshold is set to its default value,
0.
.
The default scaling indicator
.RB is\~\[lq] m \[rq].
.
The hyphenation space adjustment threshold is associated with the
current environment.
.
.
.IP
A negative argument resets the hyphenation space adjustment threshold to
zero, emitting a warning of type \[lq]range\[rq].
.
.
.TP
.BI .itc\~ n\~macro
Variant of
.B .it
for which a line interrupted with
.B \[rs]c
is not counted as an input line.
.
.TP
.BI .kern\~ n
If
.I n
is non-zero or missing, enable pairwise kerning, otherwise disable it.
.
.TP
.BI .length\~ "reg anything"
Compute the number of characters in
.I anything
and return the count in the number register
.IR reg .
.
If
.I reg
doesn't exist,
it is created.
.
.I anything
is read in copy mode.
.
.RS
.IP
.EX
.B .ds xxx abcd\eh\[aq]3i\[aq]efgh
.B .length yyy \e*[xxx]
.B \en[yyy]
14
.EE
.RE
.
.
.TP
.BI .linetabs\~ n
If
.I n
is non-zero or missing, enable line-tabs mode, otherwise disable it
(which is the default).
.
In line-tabs mode, tab distances are computed relative to the
(current) output line.
.
Otherwise they are taken relative to the input line.
.
For example, the following
.
.RS
.IP
.ne 6v+\n(.Vu
.EX
\&.ds x a\[rs]t\[rs]c
\&.ds y b\[rs]t\[rs]c
\&.ds z c
\&.ta 1i 3i
\&\[rs]*x
\&\[rs]*y
\&\[rs]*z
.EE
.RE
.
.IP
yields
.
.RS
.IP
.EX
a         b         c
.EE
.RE
.
.IP
In line-tabs mode, the same code gives
.
.RS
.IP
.EX
a         b                   c
.EE
.RE
.
.IP
Line-tabs mode is associated with the current environment; the
read-only number register
.B \[rs]n[.linetabs]
is set to\~1 if in line-tabs mode, and 0 otherwise.
.
.TP
.BI .lsm\~ xx
Set the leading spaces macro to
.IR xx .
If there are leading spaces in an input line, it is invoked instead of
the usual troff behaviour; the leading spaces are removed.
Registers
.B \[rs]n[lsn]
and
.B \[rs]n[lss]
hold the number of removed leading spaces and the corresponding
horizontal space, respectively.
.
.TP
.BI .mso\~ file
The same as the
.B so
request except that
.I file
is searched for in the same directories as macro files for the
.B \-m
command-line option.
.
If the file name to be included has the form
.IB name .tmac
and it isn't found,
.B .mso
tries to include
.BI tmac. name
instead and vice versa.
.
A warning of type
.B file
is generated if
.I file
can't be loaded, and the request is ignored.
.
.TP
.BI .nop \~anything
Execute
.IR anything .
This is similar to \[oq].if\~1\[cq].
.
.TP
.B .nroff
Make the
.B n
built-in condition true and the
.B t
built-in condition false.
.
This can be reversed using the
.B troff
request.
.
.TP
.BI .open\~ stream\~filename
Open
.I filename
for writing and associate the stream named
.I stream
with it.
.
See also the
.B close
and
.B write
requests.
.
.TP
.BI .opena\~ stream\~filename
Like
.BR open ,
but if
.I filename
exists, append to it instead of truncating it.
.
.TP
.BI .output\~ string
Emit
.I string
directly to the intermediate output (subject to copy-mode
interpretation);
this is similar to
.B \[rs]!\&
used at the top level.
.
An initial double quote in
.I string
is stripped off to allow initial blanks.
.
.TP
.B .pev
Print the current environment and each defined environment state on
stderr.
.
.TP
.B .pnr
Print the names and contents of all currently defined number registers
on stderr.
.
.TP
.BI .psbb \~filename
Get the bounding box of a PostScript image
.IR filename .
.
This file must conform to Adobe's Document Structuring
Conventions; the command looks for a
.B \%%%BoundingBox
comment to extract the bounding box values.
.
After a successful call, the coordinates (in PostScript units) of the
lower left and upper right corner can be found in the registers
.BR \[rs]n[llx] ,
.BR \[rs]n[lly] ,
.BR \[rs]n[urx] ,
and
.BR \[rs]n[ury] ,
respectively.
.
If some error has occurred, the four registers are set to zero.
.
.TP
.BI .pso \~command
This behaves like the
.B so
request except that input comes from the standard output of
.IR command .
.
.TP
.B .ptr
Print the names and positions of all traps (not including input line
traps and diversion traps) on stderr.
.
Empty slots in the page trap list are printed as well, because they
can affect the priority of subsequently planted traps.
.
.TP
.BI .pvs \~\[+-]n
Set the post-vertical line space to\~\c
.IR n ;
default scale indicator is\~\c
.BR p .
.
This value is added to each line after it has been output.
.
With no argument, the post-vertical line space is set to its previous
value.
.
.IP
The total vertical line spacing consists of four components:
.B .vs
and
.B \[rs]x
with a negative value which are applied before the line is output, and
.B .pvs
and
.B \[rs]x
with a positive value which are applied after the line is output.
.
.TP
.BI .rchar\~ "c1 c2\~"\c
\&.\|.\|.
Remove the definitions of glyphs
.IR c1 ,
.IR c2 ,
and so on.
.
This undoes the effect of a
.B .char
request.
.
.TP
.B .return
Within a macro, return immediately.
.
If called with an argument, return twice, namely from the current macro
and from the macro one level higher.
.
No effect otherwise.
.
.TP
.BI .rfschar\~ "f c1 c2\~"\c
\&.\|.\|.
Remove the font-specific definitions of glyphs
.IR c1 ,
.IR c2 ,
\&.\|.\|.\& for
.RI font\~ f .
.
Whitespace is optional between
.IR cn \~arguments.
.
See
.BR .fschar .
.
.
.TP
.B .rj
.TQ
.BI .rj \~n
Right justify the next
.IR n \~\c
input lines.
.
Without an argument right justify the next input line.
.
The number of lines to be right justified is available in the
.B \[rs]n[.rj]
register.
.
This implicitly does
.BR .ce\~0 .
The
.B ce
request implicitly does
.BR .rj\~0 .
.
.TP
.BI .rnn \~xx\~yy
Rename number register
.I xx
to
.IR yy .
.
.TP
.BI .schar\~ c\~string
Define global fallback character (or glyph)\~\c
.I c
to be
.IR string .
.
The syntax of this request is the same as the
.B char
request; a glyph defined with
.B schar
is searched after the list of fonts declared with the
.B special
request but before the mounted special fonts.
.
.TP
.BI .shc\~ glyph
Set the soft hyphen character
.RI to\~ glyph .
.
If
.I glyph
is omitted,
the soft hyphen character is set to the default,
.BR \[rs][hy] .
.
The soft hyphen character is the glyph that is inserted when a word is
automatically hyphenated at a line break.
.
If the soft hyphen character does not exist in the font of the character
immediately preceding a potential break point,
then the line is not broken at that point.
.
Neither definitions
(specified with the
.B .char
request)
nor translations
(specified with the
.B .tr
request)
are considered when determining the soft hyphen character.
.
.
.TP
.BI .shift\~ n
In a macro, shift the arguments by
.I n
positions: argument\~\c
.I i
becomes argument
.IR i \|\-\| n ;
arguments 1 to\~\c
.I n
are no longer available.
.
If
.I n
is missing, arguments are shifted by\~1.
.
Shifting by negative amounts is currently undefined.
.
.TP
.BI .sizes\~ "s1 s2\~"\c
.RI .\|.\|.\~ sn\~\c
.RB [ 0 ]
This request is similar to the
.B sizes
command of a
.I DESC
file.
.
It sets the available font sizes for the current font to
.IR s1 ,
.IR s2 ,
\&.\|.\|.\&
.I sn
scaled points.
.
The list of sizes can be terminated by an
.RB optional\~\[lq] 0 \[rq].
.
Each
.I si
can also be a range of sizes
.IR m \(en n .
.
Contrary to the font file command, the list can't extend over more
than a single line.
.
.TP
.BI .special\~ "s1 s2\~"\c
\&.\|.\|.
Fonts
.IR s1 ,
.IR s2 ,
\&.\|.\|.\&
are special and are searched for glyphs not in the current font.
.
Without arguments, reset the list of special fonts to be empty.
.
.TP
.B .spreadwarn\c
.RI " [" limit ]
Emit a
.B break
warning if the additional space inserted for each space between words in
an output line adjusted to both margins with
.RB \[lq] .ad\~b \[rq]
is larger than or equal to
.IR limit .
.
A negative value is treated as zero;
an absent argument toggles the warning on and off without changing
.IR limit .
.
The default scaling indicator is
.BR m .
.
At startup,
.B .spreadwarn
is inactive and
.I limit
is 3\~m.
.
.IP
For example,
.IP
.RS
.RS
.EX
\&.spreadwarn 0.2m
.EE
.RE
.RE
.IP
causes a warning if
.B break
warnings are not suppressed and
.
.I \%@g@troff
must add 0.2\~m or more for each interword space in a line.
.
See
.IR \%@g@troff (@MAN1EXT@)
for warning types and control.
.
.TP
.BI .stringdown \~str
.TQ
.BI .stringup \~str
Alter the string named
.I str
by replacing each of its bytes with its
lowercase
.RB ( down )
or uppercase
.RB ( up )
version
(if one exists).
.
.I groff
special characters
(see
.IR groff_char (@MAN7EXT@))
can be used and the output will usually transform in the expected way
due to the regular naming convention of the special character escapes.
.
.IP
.RS
.RS
.EX
\&.ds resume R\e[\[aq]e]sum\e[\[aq]e]\e"
\e*[resume] \e# R\['e]sum\['e]
\&.stringdown resume
\e*[resume] \e# r\['e]sum\['e]
\&.stringup resume
\e*[resume] \e# R\['E]SUM\['E]
.EE
.RE
.RE
.
.TP
.BI .sty\~ n\~f
Associate style\~\c
.I f
with font position\~\c
.IR n .
A font position can be associated either with a font or with a style.
.
The current font is the index of a font position and so is also either
a font or a style.
.
When it is a style, the font that is actually used is the font the
name of which is the concatenation of the name of the current family
and the name of the current style.
.
For example, if the current font is\~1 and font position\~1 is
associated with style\~\c
.B R
and the current font family is\~\c
.BR T ,
then font
.B TR
is used.
.
If the current font is not a style, then the current family is ignored.
.
When the requests
.BR cs ,
.BR bd ,
.BR tkf ,
.BR uf ,
or
.B fspecial
are applied to a style, then they are applied instead to the
member of the current family corresponding to that style.
.
The default family can be set with the
.B \-f
command-line option.
.
The
.B styles
command in the
DESC
file controls which font positions (if any) are initially associated
with styles rather than fonts.
.
.TP
.BI .substring\~ "str start\~"\c
.RI [ end ]
Replace the string named
.I str
with its substring bounded by the indices
.I start
and
.IR end ,
inclusive.
.
The first character in the string has index\~0.
.
If
.I end
is omitted,
it is implicitly set to the largest valid value
(the string length minus one).
.
Negative indices count backwards from the end of the string:
the last character has index\~\-1,
the character before the last has index\~\-2,
and so on.
.
.RS
.IP
.EX
.B .ds xxx abcdefgh
.B .substring xxx 1 \-4
.B \e*[xxx]
bcde
.B .substring xxx 2
.B \e*[xxx]
de
.EE
.RE
.
.TP
.BI .tkf\~ f\~s1\~n1\~s2\~n2
Enable track kerning for font\~\c
.IR f .
When the current font is\~\c
.I f
the width of every glyph is increased by an amount between
.I n1
and
.IR n2 ;
when the current point size is less than or equal to
.I s1
the width is increased by
.IR n1 ;
when it is greater than or equal to
.I s2
the width is increased by
.IR n2 ;
when the point size is greater than or equal to
.I s1
and less than or equal to
.I s2
the increase in width is a linear function of the point size.
.
.TP
.BI .tm1\~ string
Similar to the
.B tm
request,
.I string
is read in copy mode and written on the standard error, but an initial
double quote in
.I string
is stripped off to allow initial blanks.
.
.TP
.BI .tmc\~ string
Similar to
.B tm1
but without writing a final newline.
.
.TP
.BI .trf\~ filename
Transparently output the contents of file
.IR filename .
Each line is output as if preceded by
.BR \[rs]! ;
however, the lines are not subject to copy-mode interpretation.
.
If the file does not end with a newline, then a newline is added.
.
For example, you can define a macro\~\c
.I x
containing the contents of file\~\c
.IR f ,
using
.
.RS
.IP
.ne 2v+\n(.Vu
.EX
\&.di x
\&.trf f
\&.di
.EE
.RE
.
.IP
Unlike with the
.B cf
request, the file cannot contain characters, such as NUL,
that are not valid troff input characters.
.
.TP
.BI .trin\~ abcd
This is the same as the
.B tr
request except that the
.B asciify
request uses the character code (if any) before the character
translation.
.
Example:
.
.RS
.IP
.EX
\&.trin ax
\&.di xxx
\&a
\&.br
\&.di
\&.xxx
\&.trin aa
\&.asciify xxx
\&.xxx
.EE
.RE
.
.IP
The result is
.BR x\~a .
.
Using
.BR tr ,
the result would be
.BR x\~x .
.
.TP
.BI .trnt\~ abcd
This is the same as the
.B tr
request except that the translations do not apply to text that is
transparently throughput into a diversion with
.BR \[rs]! .
For example,
.
.RS
.IP
.EX
\&.tr ab
\&.di x
\&\[rs]!.tm a
\&.di
\&.x
.EE
.RE
.
.IP
prints\~\c
.BR b ;
if
.B trnt
is used instead of
.B tr
it prints\~\c
.BR a .
.
.TP
.B .troff
Make the
.B n
built-in condition false, and the
.B t
built-in condition true.
.
This undoes the effect of the
.B nroff
request.
.
.
.TP
.BI .unformat\~ div
\[lq]Unformat\[rq]
the diversion
.IR div .
.
In contrast to the
.B .asciify
request,
which tries to convert formatted elements of the diversion back to input
tokens as much as possible,
.B .unformat
handles only tabs and spaces between words,
the latter usually arising from spaces or newlines in the input.
.
Tabs are treated as input tokens,
and spaces become are stretchable again.
.
Note that the vertical size of lines is not preserved.
.
The vertical sizes of lines are not preserved,
but glyph information
(font, font size, space width, etc.\&)
is retained.
.
.B .unformat
can be useful in conjunction with the
.B .box
and
.B .boxa
requests.
.
.
.TP
.BI .vpt\~ n
Enable vertical position traps if
.I n
is non-zero, disable them otherwise.
.
Vertical position traps are traps set by the
.B wh
or
.B dt
requests.
.
Traps set by the
.B it
request are not vertical position traps.
.
The parameter that controls whether vertical position traps are
enabled is global.
.
Initially,
vertical position traps are enabled.
.
.TP
.BI .warn\~ n
Control warnings.
.IR n \~\c
is the sum of the numbers associated with each warning that is to be
enabled; all other warnings are disabled.
.
The number associated with each warning is listed in
.IR \%@g@troff (@MAN1EXT@).
.
For example,
.B .warn 0
disables all warnings, and
.B .warn 1
disables all warnings except that about missing glyphs.
.
If
.I n
is not given, all warnings are enabled.
.
.TP
.BI .warnscale\~ si
Set the scaling indicator used in warnings to
.IR si .
.
Valid values for
.I si
are
.BR u ,
.BR i ,
.BR c ,
.BR p ,
and\~\c
.BR P .
.
At startup, it is set to\~\c
.BR i .
.
.TP
.BI .while \~c\~anything
While condition\~\c
.I c
is true, accept
.I anything
as input;
.IR c \~\c
can be any condition acceptable to an
.B if
request;
.I anything
can comprise multiple lines if the first line starts with
.B \[rs]{
and the last line ends with
.BR \[rs]} .
See also the
.B break
and
.B continue
requests.
.
.TP
.BI .write\~ stream\~anything
Write
.I anything
to the stream named
.IR stream .
.I stream
must previously have been the subject of an
.B open
request.
.I anything
is read in copy mode;
a leading\~\c
.B \[dq]
is stripped.
.
.TP
.BI .writec\~ stream\~anything
Similar to
.B write
but without writing a final newline.
.
.TP
.BI .writem\~ stream\~xx
Write the contents of the macro or string
.I xx
to the stream named
.IR stream .
.I stream
must previously have been the subject of an
.B open
request.
.I xx
is read in copy mode.
.
.
.\" ====================================================================
.SS "Extended requests"
.\" ====================================================================
.
.TP
.BI .cf\~ filename
When used in a diversion, this embeds in the diversion an object
which, when reread, will cause the contents of
.I filename
to be transparently copied through to the output.
.
In
.RI AT&T\~ troff,
the contents of
.I filename
are immediately copied through to the output regardless of whether there
is a current diversion;
this behavior is so anomalous that it must be considered a bug.
.
.
.TP
.BI .de\~ "xx yy"
.TQ
.BI .am\~ "xx yy"
.TQ
.BI .ds\~ "xx yy"
.TQ
.BI .as\~ "xx yy"
In compatibility mode,
these requests behave similarly to
.BR .de1 ,
.BR .am1 ,
.BR .ds1 ,
and
.BR .as1 ,
respectively:
a \[lq]compatibility save\[rq] token is inserted at the beginning,
and a \[lq]compatibility restore\[rq] token at the end,
with compatibility mode switched on during execution.
.
.
.TP
.BI .ev\~ xx
If
.I xx
is not a number, this switches to a named environment called
.IR xx .
The environment should be popped with a matching
.B ev
request without any arguments, just as for numbered environments.
.
There is no limit on the number of named environments; they are
created the first time that they are referenced.
.
.
.TP
.BI .hy\~ n
New values 16 and\~32 are available;
the former enables hyphenation before the last character in a word,
and the latter enables hyphenation after the first character in a word.
.
.
.TP
.BI .ss\~ "word-space-size sentence-space-size"
A second argument to the
.B .ss
request determines the additional inter-sentence spacing used in fill
mode.
.
If omitted,
this value is the same as the minimal inter-word spacing
(the first argument).
.
Both are in units of twelfths of the space-width parameter of the
current font
(see
.IR groff_font (@MAN5EXT@))
and default to \~12.
.
Unlike
.RI AT&T\~ troff ,
.I groff
does not ignore the
.B .ss
request if the output is a terminal device;
instead,
the values of minimal inter-word and additional inter-sentence spacing
are rounded down to the nearest multiple of\~12.
.
.IP
Additional inter-sentence spacing is used only in fill mode,
and only if the output line is not full when the end of a sentence
occurs in the input.
.
If a sentence ends at the end of an input line,
then both an inter-word space and an inter-sentence space are added to
the output;
if two spaces follow the end of a sentence in the middle of an input
line,
then the second space becomes an inter-sentence space in the output.
.
Additional inter-sentence space is not adjusted,
but the inter-word space that always precedes it may be.
.
.IP
If a second argument is never given to the
.B .ss
request,
.I groff
separates sentences as
.RI AT&T\~ troff
does.
.
In
.IR groff ,
as in
.RI AT&T\~ troff ,
you should always follow a sentence with either a newline or two spaces.
.
.IP
A related application of the
.B .ss
request is to insert discardable horizontal space;
i.e.,
space that is discarded at a line break.
For example,
some footnote styles collect the notes into a single paragraph with
large spaces between each.
.
.RS
.RS \" Extra indent to get us inboard of the indented paragraph.
.EX
\&.ie n .ll 50n
\&.el   .ll 2.75i
\&.ss 12 48
1. J. Fict. Ch. Soc. 6 (2020), 3\[rs][en]14.
2. Better known for other work.
.EE
.RE
.RE
.
.IP
The result has obvious inter-sentence spacing.
.RS
.RS \" Extra indent to get us inboard of the indented paragraph.
.\" This is an output example, so use a real en-dash.
.EX
1. J. Fict. Ch. Soc. 6 (2020), 3\[en]14.     2. Better
known for other work.
.EE
.RE
.RE
.
.TP
.BR .ta\~ [[\c
.IR "n1 n2\~" .\|.\|.\~ nn \~]\c
.B T\c
.IR "r1 r2\~" .\|.\|.\~ rn ]
Set tabs at positions
.IR n1 ,
.IR n2 ,
\&.\|.\|.\|,
.I nn
and then set tabs at
.IR nn \|+\| r1 ,
.IR nn \|+\| r2 ,
\&.\|.\|.\|,
.IR nn \|+\| rn
and then at
.IR nn \|+\| rn \|+\| r1 ,
.IR nn \|+\| rn \|+\| r2 ,
\&.\|.\|.\|,
.IR nn \|+\| rn \|+\| rn ,
and so on.
For example,
.
.RS
.IP
.EX
\&.ta T .5i
.EE
.
.P
sets tabs every half an inch.
.RE
.
.
.\" ====================================================================
.SS "New number registers"
.\" ====================================================================
.
The following read-only registers are available:
.
.TP
.B \[rs]n[.br]
Within a macro call, it is set to\~1 if the macro is called with the
\[oq]normal\[cq] control character (\[oq].\[cq] by default), and set
to\~0 otherwise.
.
This allows the reliable modification of requests.
.
.RS
.IP
.ne 6v+\n(.Vu
.EX
\&.als bp*orig bp
\&.de bp
\&.tm before bp
\&.ie \[rs]\[rs]n[.br] .bp*orig
\&.el \[aq]bp*orig
\&.tm after bp
\&..
.EE
.RE
.
.IP
Using this register outside of a macro makes no sense (it always returns
zero in such cases).
.
.TP
.B \[rs]n[.C]
1\~if compatibility mode is in effect, 0\~otherwise.
.
.TP
.B \[rs]n[.cdp]
The depth of the last glyph added to the current environment.
.
It is positive if the glyph extends below the baseline.
.
.TP
.B \[rs]n[.ce]
The number of lines remaining to be centered, as set by the
.B ce
request.
.
.TP
.B \[rs]n[.cht]
The height of the last glyph added to the current environment.
.
It is positive if the glyph extends above the baseline.
.
.TP
.B \[rs]n[.color]
1\~if colors are enabled, 0\~otherwise.
.
.TP
.B \[rs]n[.cp]
Within a
.B .do
request,
holds the saved value of compatibility mode
(see
.B \[rs]n[.C]
above).
.
.TP
.B \[rs]n[.csk]
The skew of the last glyph added to the current environment.
.
The
.I skew
of a glyph is how far to the right of the center of a glyph
the center of an accent over that glyph should be placed.
.
.TP
.B \[rs]n[.ev]
The name or number of the current environment.
.
This is a string-valued register.
.
.TP
.B \[rs]n[.fam]
The current font family.
.
This is a string-valued register.
.
.TP
.B \[rs]n[.fn]
The current (internal) real font name.
.
This is a string-valued register.
.
If the current font is a style, the value of
.B \[rs]n[.fn]
is the proper concatenation of family and style name.
.
.TP
.B \[rs]n[.fp]
The number of the next free font position.
.
.TP
.B \[rs]n[.g]
Always\~1.
.
Macros should use this to determine whether they are running under GNU
troff.
.
.TP
.B \[rs]n[.height]
The current height of the font as set with
.BR \[rs]H .
.
.
.TP
.B \[rs]n[.hla]
The hyphenation language in the current environment.
.
.
.TP
.B \[rs]n[.hlc]
The count of immediately preceding consecutive hyphenated lines in the
current environment.
.
.
.TP
.B \[rs]n[.hlm]
The maximum number of consecutive hyphenated lines allowed in the
current environment.
.
.
.TP
.B \[rs]n[.hy]
The hyphenation mode in the current environment.
.
.
.TP
.B \[rs]n[.hym]
The hyphenation margin in the current environment.
.
.
.TP
.B \[rs]n[.hys]
The hyphenation space adjustment threshold in the current environment.
.
.
.TP
.B \[rs]n[.in]
The indentation that applies to the current output line.
.
.TP
.B \[rs]n[.int]
Set to a positive value if last output line is interrupted (i.e., if
it contains
.BR \[rs]c ).
.
.TP
.B \[rs]n[.kern]
1\~if pairwise kerning is enabled, 0\~otherwise.
.
.TP
.B \[rs]n[.lg]
The current ligature mode (as set by the
.B lg
request).
.
.TP
.B \[rs]n[.linetabs]
The current line-tabs mode (as set by the
.B linetabs
request).
.
.TP
.B \[rs]n[.ll]
The line length that applies to the current output line.
.
.TP
.B \[rs]n[.lt]
The title length as set by the
.B lt
request.
.
.TP
.B \[rs]n[.m]
The name of the current drawing color.
.
This is a string-valued register.
.
.TP
.B \[rs]n[.M]
The name of the current background color.
.
This is a string-valued register.
.
.TP
.B \[rs]n[.ne]
The amount of space that was needed in the last
.B ne
request that caused a trap to be sprung.
.
Useful in conjunction with the
.B \[rs]n[.trunc]
register.
.
.TP
.B \[rs]n[.ns]
1\~if no-space mode is active, 0\~otherwise.
.
.TP
.B \[rs]n[.O]
The current output level as set with
.BR \[rs]O .
.
.TP
.B \[rs]n[.P]
1\~if the current page is in the output list set with
.BR \-o .
.
.TP
.B \[rs]n[.pe]
1\~during a page ejection caused by the
.B bp
request, 0\~otherwise.
.
.TP
.B \[rs]n[.pn]
The number of the next page, either the value set by a
.B pn
request, or the number of the current page plus\~1.
.
.TP
.B \[rs]n[.ps]
The current point size in scaled points.
.
.TP
.B \[rs]n[.psr]
The last-requested point size in scaled points.
.
.TP
.B \[rs]n[.pvs]
The current post-vertical line space as set with the
.B pvs
request.
.
.TP
.B \[rs]n[.rj]
The number of lines to be right-justified as set by the
.B rj
request.
.
.TP
.B \[rs]n[.slant]
The slant of the current font as set with
.BR \[rs]S .
.
.TP
.B \[rs]n[.sr]
The last requested point size in points as a decimal fraction.
.
This is a string-valued register.
.
.TP
.B \[rs]n[.ss]
.TQ
.B \[rs]n[.sss]
The values of minimal inter-word spacing and additional inter-sentence
spacing,
respectively,
in twelfths of the space width of the current font.
.
Set by the
.B .ss
request.
.
.TP
.B \[rs]n[.sty]
The current font style.
.
This is a string-valued register.
.
.TP
.B \[rs]n[.tabs]
A string representation of the current tab settings suitable for use
as an argument to the
.B ta
request.
.
.TP
.B \[rs]n[.trunc]
The amount of vertical space truncated by the most recently sprung
vertical position trap, or, if the trap was sprung by an
.B ne
request, minus the amount of vertical motion produced by the
.B ne
request.
.
In other words, at the point a trap is sprung, it represents the
difference of what the vertical position would have been but for the
trap, and what the vertical position actually is.
.
Useful in conjunction with the
.B \[rs]n[.ne]
register.
.
.TP
.B \[rs]n[.U]
Set to\~1 if in safer mode and to\~0 if in unsafe mode (as given with
the
.B \-U
command-line option).
.
.TP
.B \[rs]n[.vpt]
1\~if vertical position traps are enabled, 0\~otherwise.
.
.TP
.B \[rs]n[.warn]
The sum of the numbers associated with each of the currently enabled
warnings.
.
The number associated with each warning is listed in
.IR \%@g@troff (@MAN1EXT@).
.
.TP
.B \[rs]n[.x]
The major version number.
.
For example, if the version number is 1.03, then
.B \[rs]n[.x]
contains\~1.
.
.TP
.B \[rs]n[.y]
The minor version number.
.
For example, if the version number is 1.03, then
.B \[rs]n[.y]
contains\~03.
.
.TP
.B \[rs]n[.Y]
The revision number of groff.
.
.TP
.B \[rs]n[.zoom]
The zoom value of the current font, in multiples of 1/1000th.
Zero if no magnification.
.
.TP
.B \[rs]n[llx]
.TQ
.B \[rs]n[lly]
.TQ
.B \[rs]n[urx]
.TQ
.B \[rs]n[ury]
These four read/\:write registers are set by the
.B psbb
request and contain the bounding box values (in PostScript units) of a
given PostScript image.
.
.P
The following read/\:write registers are set by the
.B \[rs]w
escape sequence:
.
.TP
.B \[rs]n[rst]
.TQ
.B \[rs]n[rsb]
Like the
.B st
and
.B sb
registers, but take account of the heights and depths of glyphs.
.
.TP
.B \[rs]n[ssc]
The amount of horizontal space (possibly negative) that should be
added to the last glyph before a subscript.
.
.TP
.B \[rs]n[skw]
How far to right of the center of the last glyph in the
.B \[rs]w
argument, the center of an accent from a roman font should be placed
over that glyph.
.
.P
Other available read/write number registers are:
.
.TP
.B \[rs]n[c.]
The current input line number.
.B \[rs]n[.c]
is a read-only alias to this register.
.
.TP
.B \[rs]n[hours]
The number of hours past midnight.
.
Initialized at start-up.
.
.TP
.B \[rs]n[hp]
The current horizontal position at input line.
.
.TP
.B \[rs]n[lsn]
.TQ
.B \[rs]n[lss]
If there are leading spaces in an input line, these registers
hold the number of leading spaces and the corresponding horizontal
space,
respectively.
.
.TP
.B \[rs]n[minutes]
The number of minutes after the hour.
.
Initialized at start-up.
.
.TP
.B \[rs]n[seconds]
The number of seconds after the minute.
.
Initialized at start-up.
.
.TP
.B \[rs]n[systat]
The return value of the system() function executed by the last
.B sy
request.
.
.TP
.B \[rs]n[slimit]
If greater than\~0, the maximum number of objects on the input stack.
.
If less than or equal to\~0, there is no limit on the number of
objects on the input stack.
.
With no limit, recursion can continue until virtual memory is
exhausted.
.
.TP
.B \[rs]n[year]
The current year.
.
Note that the traditional
.I troff \" AT&T
number register
.B \[rs]n[yr]
is the current year minus 1900.
.
.
.\" ====================================================================
.SS Miscellaneous
.\" ====================================================================
.
.I \%@g@troff
predefines a string,
.BR \[rs]*[.T] ;
it contains the argument given to the
.B \-T
command-line option,
namely the current output device
(for example,
.B pdf
or
.BR utf8 ).
.
This is not the same as the (read-only) register
.BR \[rs]n[.T] ,
which is defined to be\~1 if
.I \%@g@troff
is called with the
.B \-T
command-line option,
and zero otherwise.
.
This behavior differs from AT&T
.IR troff . \" AT&T
.
.
.P
Fonts not listed in the
.I DESC
file are automatically mounted on the next available font position
when they are referenced.
.
If a font is to be mounted explicitly with the
.B .fp
request on an unused font position,
it should be mounted on the first unused font position,
which can be found in the
.B \[rs]n[.fp]
register;
although
.I \%@g@troff
does not enforce that strictly.
.
Rather,
it does not allow a font to be mounted at a position whose number is
much greater than that of any currently used position.
.
.
.P
Interpolating a string does not hide existing macro arguments.
.
Thus,
in a macro,
a more efficient way of doing
.
.IP
.BI . xx\~ \[rs]\[rs]$@
.
.
.P
is
.
.IP
.BI \[rs]\[rs]*[ xx ]\[rs]\[rs]
.
.
.P
If the font description file contains pairwise kerning information,
glyphs from that font are kerned.
.
Kerning between two glyphs can be inhibited by placing a non-printing
input break
.B \[rs]&
between them.
.
.
.P
In a string comparison in a condition,
characters that appear at different input levels from the first
delimiter character are not recognized as the second or third
delimiters.
.
This also applies to the
.B .tl
request.
.
In a
.B \[rs]w
escape sequence,
a character that appears at a different input level from the starting
delimiter character is not recognized as the closing delimiter
character.
.
The same is true for
.BR \[rs]A ,
.BR \[rs]b ,
.BR \[rs]B ,
.BR \[rs]C ,
.BR \[rs]l ,
.BR \[rs]L ,
.BR \[rs]o ,
.BR \[rs]X ,
and
.BR \[rs]Z .
.
When decoding a macro or string argument that is delimited by double
quotes,
a character that appears at a different input level from the starting
delimiter character is not recognized as the closing delimiter
character.
.
The implementation of
.B \[rs]$@
ensures that the double quotes surrounding an argument appear at the
same input level,
which is differs from the input level of the argument itself.
.
In a long escape name
.B ]
is not recognized as a closing delimiter except when it occurs at
the same input level as the
.RB opening\~ [ .
.
In compatibility mode,
no attention is paid to the input level.
.
.
.P
In
.IR groff ,
the
.B .tr
request can map characters onto
.BR \[rs]\[ti] .
.
.
.P
The space width emitted by the
.B \[rs]|
and
.B \[rs]^
escape sequences can be controlled on a per-font basis.
.
If there is a glyph named
.B \[rs]|
or
.BR \[rs]\[ha] ,
respectively
(note the leading backslash),
defined in the current font file,
use this glyph's width instead of the default value.
.
.
.P
In
.IR groff ,
tabs and spaces are allowed between the first and second dots
(or between the dot and the name of the ending macro)
that end a macro definition.
.
Example:
.
.IP
.ne 5v+\n(.Vu
.EX
\&.if t \[rs]{\[rs]
\&.  de bar
\&.    nop Hello, I'm \[aq]bar\[aq].
\&.  .
\&.\[rs]}
.EE
.
.
.\" ====================================================================
.SH "Intermediate Output Format"
.\" ====================================================================
.
The output format of
.I groff
is modeled after that used by AT&T
.I troff \" AT&T
once it adopted a device-independent approach in the early 1980s.
.
Only the differences are documented here.
.
.
.\" ====================================================================
.SS Units
.\" ====================================================================
.
The argument to the
.BR s \~command
is in scaled points
(in units of
.RI points/ n ,
where
.I n
is the argument to the
.B sizescale
command in the
.I DESC
file).
.
The argument to the
.B x Height
command is also in scaled points.
.
.
.\" ====================================================================
.SS "Text commands"
.\" ====================================================================
.
.TP
.BI N n
Print glyph with index\~\c
.I n
(a non-negative integer)
of the current font.
.
.P
If the
.B tcommand
line is present in the
.I DESC
file,
GNU
.I troff \" GNU
uses the following two commands.
.
.TP
.BI t xxx
.I xxx
is any sequence of characters terminated by a space or a newline
(to be more precise,
it is a sequence of glyphs which are accessed with the corresponding
characters);
the first character should be printed at the current position,
the current horizontal position should be increased by the width of the
first character,
and so on for each character.
.
The width of the glyph is that given in the font file,
appropriately scaled for the current point size,
and rounded so that it is a multiple of the horizontal resolution.
.
Special characters cannot be printed using this command.
.
.TP
.BI u n\~xxx
This is same as the
.BR t \~command
except that after printing each character, the current
horizontal position is increased by the sum of the width of that
character
.RI and\~ n .
.
.P
Note that single characters can have the eighth bit set, as can the
names of fonts and special characters.
.
.P
The names of glyphs and fonts can be of arbitrary length; drivers
should not assume that they are only two characters long.
.
.P
When a glyph is to be printed, that glyph is always
in the current font.
.
Unlike device-independent troff, it is not necessary for drivers to
search special fonts to find a glyph.
.
.P
For color support, some new commands have been added:
.
.TP
\f[B]mc \f[I]cyan magenta yellow\f[R]
.TQ
\f[B]md\f[R]
.TQ
\f[B]mg \f[I]gray\f[R]
.TQ
\f[B]mk \f[I]cyan magenta yellow black\f[R]
.TQ
\f[B]mr \f[I]red green blue\f[R]
Set the color components of the current drawing color, using various
color schemes.
.
.B md
resets the drawing color to the default value.
.
The arguments are integers in the range 0 to 65536.
.
.P
The
.BR x \~\c
device control command has been extended.
.
.TP
\f[B]x u \f[I]n\f[R]
If
.I n
is\~1, start underlining of spaces.
.
If
.I n
is\~0, stop underlining of spaces.
.
This is needed for the
.B cu
request in nroff mode and is ignored otherwise.
.
.
.\" ====================================================================
.SS "Drawing commands"
.\" ====================================================================
.
The
.B D
drawing command has been extended.
.
These extensions are not used by GNU pic if the
.B \-n
option is given.
.
.TP
\f[B]Df \f[I]n\/\f[R]\*[ic]\[rs]n
Set the shade of gray to be used for filling solid objects to
.IR n ;
.I n
must be an integer between 0 and 1000, where 0 corresponds solid white
and 1000 to solid black, and values in between correspond to
intermediate shades of gray.
.
This applies only to solid circles, solid ellipses and solid
polygons.
.
By default, a level of 1000 is used.
.
Whatever color a solid object has, it should completely obscure
everything beneath it.
.
A value greater than 1000 or less than\~0 can also be used: this means
fill with the shade of gray that is currently being used for lines and
text.
.
Normally this is black, but some drivers may provide a way of
changing this.
.
.IP
The corresponding
.BR \[rs]D\[aq]f .\|.\|.\& \[aq]
command shouldn't be used since its argument is always rounded to an
integer multiple of the horizontal resolution which can lead to
surprising results.
.
.TP
\f[B]DC \f[I]\/d\f[R]\*[ic]\[rs]n
Draw a solid circle with a diameter of
.I d
with the leftmost point at the current position.
.
.TP
\f[B]DE \f[I]dx dy\/\f[R]\*[ic]\[rs]n
Draw a solid ellipse with a horizontal diameter of
.I dx
and a vertical diameter of
.I dy
with the leftmost point at the current position.
.
.EQ
delim $$
.EN
.TP
\f[B]Dp\f[R] $dx sub 1$ $dy sub 1$ $dx sub 2$ $dy sub 2$ $...$ \c
$dx sub n$ $dy sub n$\[rs]n
Draw a polygon with, for $i = 1 ,..., n+1$, the
.IR i -th
vertex at the current position
.
$+ sum from j=1 to i-1 ( dx sub j , dy sub j )$.
.
At the moment, GNU pic only uses this command to generate triangles
and rectangles.
.
.TP
\f[B]DP\f[R] $dx sub 1$ $dy sub 1$ $dx sub 2$ $dy sub 2$ $...$ \c
$dx sub n$ $dy sub n$\[rs]n
.
Like
.B Dp
but draw a solid rather than outlined polygon.
.
.TP
\f[B]Dt \f[I]n\/\f[R]\*[ic]\[rs]n
Set the current line thickness to
.IR n \~\c
machine units.
.
Traditionally,
.RI AT&T\~ troff
drivers use a line thickness proportional to the current point size;
drivers should continue to do this if no
.B Dt
command has been given, or if a
.B Dt
command has been given with a negative value of\~\c
.IR n .
A zero value of\~\c
.I n
selects the smallest available line thickness.
.
.P
A difficulty arises in how the current position should be changed after
the execution of these commands.
.
This is not of great importance since the code generated by GNU pic
does not depend on this.
.
Given a drawing command of the form
.IP
\f[B]\[rs]D\[aq]\f[I]c\f[R] $x sub 1$ $y sub 1$ $x sub 2$ $y sub 2$ \c
$...$ $x sub n$ $y sub n$\f[B]\[aq]\f[R]
.
.P
where
.I c
is not one of
.BR c ,
.BR e ,
.BR l ,
.BR a ,
or\~\c
.BR \[ti] ,
.RI AT&T\~ troff
treats each of the $x sub i$ as a horizontal quantity,
and each of the $y sub i$ as a vertical quantity and assumes that
the width of the drawn object is $sum from i=1 to n x sub i$,
and that the height is $sum from i=1 to n y sub i$.
.
(The assumption about the height can be seen by examining the
.B st
and
.B sb
registers after using such a
.BR D \~\c
command in a
.B \[rs]w
escape sequence).
.
This rule also holds for all the original drawing commands with the
exception of
.BR De .
For the sake of compatibility GNU troff also follows this rule, even
though it produces an ugly result in the case of the
.B Dt
and
.BR Df ,
and, to a lesser extent,
.B DE
commands.
.
Thus after executing a
.BR D \~\c
command of the form
.IP
\f[B]D\f[I]c\f[R] $x sub 1$ $y sub 1$ $x sub 2$ $y sub 2$ $...$ \c
$x sub n$ $y sub n$\[rs]n
.
.P
the current position should be increased by
.
$( sum from i=1 to n x sub i , sum from i=1 to n y sub i )$.
.EQ
delim off
.EN
.
.P
Another set of extensions is
.
.TP
\f[B]DFc \f[I]cyan magenta yellow\f[R]\*[ic]\[rs]n
.TQ
\f[B]DFd\f[R]\*[ic]\[rs]n
.TQ
\f[B]DFg \f[I]gray\/\f[R]\*[ic]\[rs]n
.TQ
\f[B]DFk \f[I]cyan magenta yellow black\f[R]\*[ic]\[rs]n
.TQ
\f[B]DFr \f[I]red green blue\f[R]\*[ic]\[rs]n
Set the color components of the filling color similar to the
.BR m \~\c
commands above.
.
.P
The current position isn't changed by those colour commands
(contrary to
.BR Df ).
.
.
.\" ====================================================================
.SS "Device control commands"
.\" ====================================================================
.
There is a continuation convention which permits the argument to the
.B x X
command to contain newlines: when outputting the argument to the
.B x X
command, GNU troff follows each newline in the argument with a
.B +
character (as usual, it terminates the entire argument with a
newline); thus if the line after the line containing the
.B x X
command starts with
.BR + ,
then the newline ending the line containing the
.B x X
command should be treated as part of the argument to the
.B x X
command, the
.B +
should be ignored, and the part of the line following the
.B +
should be treated like the part of the line following the
.B x X
command.
.
.P
The first three output commands are guaranteed to be:
.IP
.BI x\~T\~ device
.br
.BI x\~res\~ n\~h\~v
.br
.B x init
.
.
.\" ====================================================================
.SH "Implementation Differences"
.\" ====================================================================
.
.I groff
has a number of features that cause incompatibilities with documents
written using old versions of
.IR roff .
.
Some GNU extensions to
.I roff
have become supported by other implementations.
.
.
.P
.I groff
does not always hyphenate words as
.RI AT&T\~ troff
does.
.
The AT&T implementation uses a set of hard-coded rules specific to U.S.
English,
while
.I groff
uses language-specific hyphenation pattern files derived from \*[tx].
.
Furthermore,
in old versions of
.I troff
there was a limited amount of space to store hyphenation exceptions
(arguments to the
.B .hw
request);
.I groff
has no such restriction.
.
.
.P
Long names may be
.IR groff 's
most obvious innovation.
.
.RI AT&T\~ troff
interprets
.RB \[lq] .dsabcd \[rq]
as defining a string
.RB \[lq] ab \[rq]
with contents
.RB \[lq] cd \[rq].
.
Normally,
.I groff
interprets this as a call of a macro named
.RB \[lq] dsabcd \[rq].
.
.RI AT&T\~ troff
also interprets
.B \[rs]*[
and
.B \[rs]n[
as a reference to a string or number register,
respectively,
called
.RB \[lq] [ \[rq].
.
In
.IR groff ,
however,
the
.RB \[lq] [ \[rq]
is normally interpreted as delimiting a long name.
.
In compatibility mode,
.I groff
interprets names in the traditional way,
which means that they are limited to one or two characters.
.
See the
.B \-C
option in
.IR groff (@MAN1EXT@)
and,
above,
the
.B .C
and
.B .cp
registers,
and
.B .cp
and
.B .do
requests,
for more on compatibility mode.
.
.
.P
The register
.B \[rs]n[.cp]
is specialized and may require a statement of rationale.
.
When writing macro packages or documents that use
.I groff
features and which may be mixed with other packages or documents that do
not\[em]common scenarios include serial processing of man pages or use
of the
.B .so
or
.B .mso
requests\[em]you may desire correct operation regardless of
compatibility mode in the surrounding context.
.
It may occur to you to save the existing value of
.B \[rs]n(.C
into a register,
say,
.BR _C ,
at the beginning of your file,
turn compatibility mode off with
.RB \[lq] .cp\~0 \[rq],
then restore it from that register at the end with
.RB \[lq] .cp\~\[rs]n(_C \[rq].
.
At the same time,
a modular design of a document or macro package may lead you to multiple
layers of inclusion.
.
You cannot use the same register name everywhere or you risk
\[lq]clobbering\[rq] the value from a preceding or enclosing context.
.
The two-character register name space of
.RI AT&T\~ troff
is confining and mnemonically challenging;
you may wish to use
.IR groff 's
more capacious name space.
.
However,
attempting
.RB \[lq] ".nr _my_saved_C \[rs]n(.C" \[rq]
will not work in compatibility mode;
the register name is too long.
.
\[lq]This is exactly what
.B .do
is for,\[rq] you think,
.RB \[lq] ".do nr _my_saved_C \[rs]n(.C" \[rq].
.
The foregoing will always save zero to your register,
because
.B .do
turns compatibility mode
.I off
while it interprets its argument list.
.
What you need is:
.RS
.EX
\&.do nr _my_saved_C \[rs]n[.cp]
\&.cp 0
.EE
.RE
at the beginning of your file,
followed by
.RS
.EX
\&.cp _my_saved_C
.EE
.RE
at the end.
.
As in the C language,
we all have to share one big name space,
so choose a register name that is unlikely to collide with other uses.
.
.P
Normally,
.I groff
preserves the input level in delimited arguments,
but not in compatibility mode.
.
For example,
on terminal devices,
.RS
.EX
\&.ds xx \[aq]
\&\[rs]w\[aq]abc\[rs]*(xxdef\[aq]
.EE
.RE
produces \[lq]168\[rq] ordinarily,
but \[lq]72def\[aq]\[rq] in compatibility mode.
.
.
.P
Furthermore,
the escapes
.BR \[rs]f ,
.BR \[rs]H ,
.BR \[rs]m ,
.BR \[rs]M ,
.BR \[rs]R ,
.BR \[rs]s ,
and
.B \[rs]S
are transparent for recognizing the beginning of a line only in
compatibility mode.
.
For example,
this code produces bold output in both cases,
but the text differs,
.RS
.EX
\&.de xx \[aq]
Hello!
\&..
\&\[rs]fB.xx\[rs]fP
.EE
.RE
producing \[lq].xx\[rq] in normal mode and \[lq]Hello!\[rq] in
compatibility mode.
.
.
.P
.I groff
does not allow the use of the escape sequences
.BR \[rs]| ,
.BR \[rs]\[ha] ,
.BR \[rs]& ,
.BR \[rs]{ ,
.BR \[rs]} ,
.RB \[lq] \[rs]\~ \[rq] ,
.BR \[rs]\[aq] ,
.BR \[rs]\[ga] ,
.BR \[rs]\- ,
.BR \[rs]_ ,
.BR \[rs]! ,
.BR \[rs]% ,
.BR \[rs]c ,
in names of strings,
macros,
diversions,
number registers,
fonts, or environments;
.RI AT&T\~ troff
does.
.
The
.B \[rs]A
escape sequence
(see subsection \[lq]Escape sequences\[rq] above)
may be helpful in avoiding use of these escape sequences in names.
.
.
.P
Normally,
the syntax form
.BI \[rs]s n
accepts only a single character
(a digit)
for
.IR n ,
consistently with other forms that originated in
.RI AT&T\~ troff ,
like
.BR \[rs]* ,
.BR \[rs]$ ,
.BR \[rs]f ,
.BR \[rs]g ,
.BR \[rs]k ,
.BR \[rs]n ,
and
.BR \[rs]z .
.
In compatibility mode only,
a
.RI non-zero\~ n
must be in the range 4\[en]39.
.
Legacy documents relying upon this quirk of parsing should be migrated
to another
.B \[rs]s
form.
.
[Background:
The Graphic Systems C/A/T phototypesetter
(the original device target for
.RI AT&T\~ troff )
supported only a few discrete point sizes in the range 6\[en]36,
so Ossanna contrived a special case in the parser to do what the user
must have meant.
.
Kernighan warned of this in the 1992 revision of CSTR\~#54 (\[sc]2.3),
and more recently,
McIlroy referred to it as a \[lq]living fossil\[rq].]
.
.
.P
Fractional point sizes cause one noteworthy incompatibility.
.
In
.RI AT&T\~ troff
the
.B .ps
request ignores scale indicators and thus
.RB \[lq] .ps\~10u \[rq]
sets the point size to 10\~points,
whereas in
.I groff
it sets the point size to 10\~scaled points.
.
See subsection \[lq]Fractional point sizes and new scale indicators\[rq]
above.
.
.
.P
In
.RI AT&T\~ troff
the
.B .pm
request reports
macro,
string,
and
diversion
sizes in units of 128-byte blocks,
and an argument reduces the report to a sum of the above in the same
units.
.
.I groff
ignores any arguments and reports the sizes in bytes.
.
.
.P
In
.IR groff ,
there is a fundamental difference between unformatted input
characters, and formatted output characters (glyphs).
.
Everything that affects how a glyph is output is stored with the glyph;
once a glyph has been constructed,
it is unaffected by any subsequent requests that are executed,
including the
.BR .bd ,
.BR .cs ,
.BR .tkf ,
.BR .tr ,
or
.B .fp
requests.
.
Normally,
glyphs are constructed from input characters immediately before the
glyph is added to the current output line.
.
Macros,
diversions,
and strings are all,
in fact,
the same type of object;
they contain lists of input characters and glyphs in any combination.
.
Special characters can be both: before being added to the output,
they act as input entities;
afterwards,
they denote glyphs.
.
A glyph does not behave like an input character for the purposes of
macro processing;
it does not inherit any of the special properties that the input
character from which it was constructed might have had.
.
Consider the following example.
.
.RS
.EX
\&.di x
\[rs]\[rs]\[rs]\[rs]
\&.br
\&.di
\&.x
.EE
.RE
.
It prints
.RB \[lq] \[rs]\[rs] \[rq]
in
.IR groff ;
each pair of input backslashes is turned into one output backslash and
the resulting output backslashes are not interpreted as escape
characters when they are reread.
.
.RI AT&T\~ troff
would interpret them as escape characters when they were reread and
would end up printing one
.RB \[lq] \[rs] \[rq].
.
.
.P
One correct way to obtain a printable backslash in most documents is to
use the
.B \[rs]e
escape sequence;
this always prints a single instance of the current escape character,
regardless of whether or not it is used in a diversion;
it also works in both
.I groff
and
.RI AT&T\~ troff .
.
(Naturally,
if you've changed the escape character,
you need to prefix the
.RB \[lq] e \[rq]
with whatever it is\[em]and you'll likely get something other than a
backslash in the output.)
.
.
.P
The other correct way,
appropriate in contexts independent of the backslash's common use as a
.I roff
escape character\[em]perhaps in discussion of character sets or other
programming languages\[em]is the character escape
.B \[rs](rs
or
.BR \[rs][rs] ,
for \[lq]reverse solidus\[rq],
from its name in the ECMA-6 (ISO/IEC\~646) standard.
.
[This character escape is not portable to
.RI AT&T\~ troff ,
but is to its lineal descendant,
Heirloom Doctools
.IR troff ,
as of its 060716 release (July 2006).]
.
.
.P
To store an escape sequence in a diversion that is interpreted when the
diversion is reread,
either use the traditional
.B \[rs]!\&
transparent output facility,
or,
if this is unsuitable,
the new
.B \[rs]?\&
escape sequence.
.
See subsection \[lq]Escape sequences\[rq] above and sections
\[lq]Diversions\[rq] and \[lq]Gtroff Internals\[rq] in
.IR "Groff: The GNU Implementation of troff" ,
the
.I groff
Texinfo manual.
.
.
.\" ====================================================================
.SS "Intermediate output format"
.\" ====================================================================
.
Its extensions notwithstanding,
the
.I groff
intermediate output format has some incompatibilities
with that of
.RI AT&T\~ troff ,
but full compatibility is sought;
problem reports and patches are welcome.
.
The following incompatibilities are known.
.
.
.IP \[bu]
The positioning after drawing polygons conflicts with the
.RI AT&T\~ troff
practice.
.
.
.IP \[bu]
The intermediate output cannot be rescaled to other devices as
.RI AT&T\~ troff 's
could.
.
.
.\" ====================================================================
.SH Authors
.\" ====================================================================
.
This document was written by James Clark and modified by Werner Lemberg
and Bernd Warken.
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
.IR "Groff: The GNU Implementation of troff" ,
by Trent A.\& Fisher and Werner Lemberg,
is the primary
.I groff
manual.
.
You can browse it interactively with \[lq]info groff\[rq].
.
.
.PP
\[lq]Troff User's Manual\[rq]
by Joseph F.\& Ossanna,
1976
(revised by Brian W.\& Kernighan,
1992),
AT&T Bell Laboratories Computing Science Techical Report No.\& 54,
widely called simply \[lq]CSTR\~#54\[rq],
documents the language,
device and font description file formats,
and device-independent output format
referred to collectively in
.I groff
documentation as
.RI \[lq]AT&T\~ troff \[rq].
.
.
.PP
\[lq]A Typesetter-independent TROFF\[rq]
by Brian W.\& Kernighan,
1982,
AT&T Bell Laboratories Computing Science Techical Report No.\& 97,
provides additional insights into the
device and font description file formats
and device-independent output format.
.
.
.PP
.IR groff (@MAN1EXT@),
.IR groff (@MAN7EXT@),
.IR roff (@MAN7EXT@)
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_groff_diff_7_man_C]
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
