
/*
   based on testprint.c from gnome-print 0.25
   
    Copyright 2000, 2002  Li-Cheng (Andy) Tai
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
 
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
 
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "print.h"
#include <gnome.h>
#include <gtk/gtk.h>

#include <libgnomeprint/gnome-print.h>
#include <libgnomeprint/gnome-print-master.h>
#include <libgnomeprint/gnome-font.h>
#include <libgnomeprintui/gnome-print-dialog.h>
#include <libgnomeprintui/gnome-print-master-preview.h>

static int image_buf_print(image_buf *ibuf, GnomePrintContext *pc, double page_width, double page_height)
{
    
    image_buf_pixmap_to_rgbbuf(ibuf, 0); /* get the latest version of the image in memory */
    gnome_print_beginpage(pc, ibuf->name);

	gnome_print_gsave (pc);
    gnome_print_translate(pc, 0, page_height - image_buf_height(ibuf) );/* give a hard coded margin of 10 points on thw top and left */
    gnome_print_scale(pc, image_buf_width(ibuf), image_buf_height(ibuf));
    gnome_print_rgbaimage (pc, image_buf_rgbbuf(ibuf), image_buf_width(ibuf), image_buf_height(ibuf), image_buf_rowstride(ibuf));
	gnome_print_grestore(pc);
    
    gnome_print_showpage (pc);

    return 1;
}


int do_print_preview(image_buf *ibuf)
{
   
    GnomePrintConfig *cfg;
    GnomePrintContext *ctx;
    GnomePrintMaster *master;
    gint response;
    gdouble page_width, page_height;
    cfg = gnome_print_config_default ();
    master = gnome_print_master_new_from_config (cfg);
    {
        gdouble width, height;
        gnome_print_master_get_page_size_from_config (cfg, &page_width, &page_height);
        ctx = gnome_print_master_get_context (master);
        /* Do page rendering, using width and height retrieved */
        image_buf_print(ibuf, ctx, page_width, page_height);
        g_object_unref (G_OBJECT (ctx));
        gnome_print_master_close (master);
        {
            GtkWidget *p;
            p = gnome_print_master_preview_new (master, ibuf->name);
            gtk_widget_show (p);
            /* Connect signals etc. and run gtk_main () */
        }
        g_object_unref (G_OBJECT (master));



    }
}

int do_print(image_buf *ibuf)
{
    GtkWidget *dlg;
    static GnomePrintConfig *cfg = 0;
    GnomePrintContext *ctx;
    GnomePrintMaster *master;
    gint response;
    gdouble page_width, page_height;
    char tmp[2000];
    sprintf(tmp, "Print: %s", ibuf->name);
    
    if (!cfg)
        cfg = gnome_print_config_default ();
    master = gnome_print_master_new_from_config (cfg);
    dlg = gnome_print_dialog_new_from_master (master, tmp, 0); /* libgnomeprintui method */
    response = gtk_dialog_run (GTK_DIALOG(dlg));
    if ((response == GNOME_PRINT_DIALOG_RESPONSE_PRINT) || (response == GNOME_PRINT_DIALOG_RESPONSE_PREVIEW))
    {
      
        gnome_print_master_get_page_size_from_config (cfg, &page_width, &page_height);
        ctx = gnome_print_master_get_context (master);
        /* Do page rendering, using width and height retrieved */
        image_buf_print(ibuf, ctx, page_width, page_height);
        gnome_print_master_close (master);
        if (response == GNOME_PRINT_DIALOG_RESPONSE_PREVIEW)
        {
            GtkWidget *p;
            p = gnome_print_master_preview_new (master, ibuf->name);
            gtk_widget_show (p);
            /* Connect signals etc. and run gtk_main () */
        }
        else
        {
            gnome_print_master_print (master);
        }


    }
  
    g_object_unref (G_OBJECT (ctx));
    g_object_unref (G_OBJECT (master));
    gtk_widget_destroy(dlg);
           
}
