
/*
    Copyright 2000  Li-Cheng (Andy) Tai

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "fileio.h"
#include <stdlib.h>
#include <string.h>

#include <gdk-pixbuf/gdk-pixbuf.h>
#include "image_buf.h"

int image_buf_save(image_buf *ibuf, const char *name)
{
   int i;
   GdkImlibImage *tmp = 0;
   g_assert(ibuf);
   image_buf_pixmap_to_rgbbuf(ibuf, 0);
   tmp = gdk_imlib_create_image_from_data(image_buf_rgbbuf(ibuf), 0, image_buf_width(ibuf), image_buf_height(ibuf));
   i = gdk_imlib_save_image(tmp, name, 0);
   gdk_imlib_kill_image(tmp);
   return i;
}
   
   
int image_buf_load(image_buf *ibuf, const char *name)
{
   
   GdkPixbuf *tmp = 0;
   g_assert(ibuf);
   
   tmp = gdk_pixbuf_new_from_file(name);
   if (tmp)
   {
      image_buf_resize(ibuf, gdk_pixbuf_get_width(tmp), gdk_pixbuf_get_height(tmp));
      gdk_pixbuf_copy_area(tmp, 0, 0, image_buf_width(ibuf), image_buf_height(ibuf), ibuf->rgbbuf, 0, 0); 
      set_image_buf_name(ibuf, (name));
      gdk_pixbuf_unref(tmp);
      image_buf_rgbbuf_to_pixmap(ibuf, 0);
      return 1; 
   }
   else 
      return 0;
   
}
