/*
 *  GNU Kart
 *
 *  Copyright (C) 2010 Eric P. Hutchins
 *
 *  GNU Kart is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *  
 *  GNU Kart is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Kart.  If not, see <http://www.gnu.org/licenses/>.
 **/

#include "kart.h"

Kart *
kart_new (double size, double x, double y, double z, double r, double g, double b, double direction, Model *model)
{
  Kart *kart;
  kart = (Kart *)malloc (sizeof (Kart));
  if (kart == NULL)
    printf ("Error allocating player\n");
  kart->size = size;
  kart->x = x;
  kart->y = y;
  kart->z = z;
  kart->r = r;
  kart->g = g;
  kart->b = b;
  kart->speed = 0;
  kart->turning = 0;
  kart->forward = 0;
  kart->direction = direction;
  kart->model = model;
  kart->current_edges = NULL;
  kart->n_current_edges = 0;
  return kart;
}

void
kart_draw (Kart *kart)
{
  model_draw (kart->model, kart->x, kart->y + 0.5, kart->z,
              kart->direction, kart->r, kart->g, kart->b);
}

void
kart_destroy (Kart *kart)
{
  free (kart);
}

