/* A Bison parser, made by GNU Bison 3.0.4.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.0.4"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* Copy the first part of user declarations.  */
#line 27 "parser.y" /* yacc.c:339  */

#include "config.h"

#include <stdlib.h>
#include <string.h>

#define	COB_IN_PARSER	1
#include "cobc.h"
#include "tree.h"

#ifndef	_STDLIB_H
#define	_STDLIB_H 1
#endif

#define YYSTYPE			cb_tree
#define yyerror(x)		cb_error ("%s", x)

#define emit_statement(x) \
do { \
  if (!skip_statements) { \
	CB_ADD_TO_CHAIN (x, current_program->exec_list); \
  } \
}  ONCE_COB

#define push_expr(type, node) \
  current_expr = cb_build_list (cb_int (type), node, current_expr)

/* Statement terminator definitions */
#define TERM_NONE		0
#define TERM_ACCEPT		1U
#define TERM_ADD		2U
#define TERM_CALL		3U
#define TERM_COMPUTE		4U
#define TERM_DELETE		5U
#define TERM_DISPLAY		6U
#define TERM_DIVIDE		7U
#define TERM_EVALUATE		8U
#define TERM_IF			9U
#define TERM_MULTIPLY		10U
#define TERM_PERFORM		11U
#define TERM_READ		12U
#define TERM_RECEIVE		13U
#define TERM_RETURN		14U
#define TERM_REWRITE		15U
#define TERM_SEARCH		16U
#define TERM_START		17U
#define TERM_STRING		18U
#define TERM_SUBTRACT		19U
#define TERM_UNSTRING		20U
#define TERM_WRITE		21U
#define TERM_MAX		22U	/* Always last entry, used for array size */

#define	TERMINATOR_WARNING(x,z)	terminator_warning (x, TERM_##z, #z)
#define	TERMINATOR_ERROR(x,z)	terminator_error (x, TERM_##z, #z)
#define	TERMINATOR_CLEAR(x,z)	terminator_clear (x, TERM_##z)

/* Defines for duplicate checks */
/* Note - We use <= 16 for common item definitons and */
/* > 16 for non-common item definitions e.g. REPORT and SCREEN */
#define	SYN_CLAUSE_1		(1U << 0)
#define	SYN_CLAUSE_2		(1U << 1)
#define	SYN_CLAUSE_3		(1U << 2)
#define	SYN_CLAUSE_4		(1U << 3)
#define	SYN_CLAUSE_5		(1U << 4)
#define	SYN_CLAUSE_6		(1U << 5)
#define	SYN_CLAUSE_7		(1U << 6)
#define	SYN_CLAUSE_8		(1U << 7)
#define	SYN_CLAUSE_9		(1U << 8)
#define	SYN_CLAUSE_10		(1U << 9)
#define	SYN_CLAUSE_11		(1U << 10)
#define	SYN_CLAUSE_12		(1U << 11)
#define	SYN_CLAUSE_13		(1U << 12)
#define	SYN_CLAUSE_14		(1U << 13)
#define	SYN_CLAUSE_15		(1U << 14)
#define	SYN_CLAUSE_16		(1U << 15)
#define	SYN_CLAUSE_17		(1U << 16)
#define	SYN_CLAUSE_18		(1U << 17)
#define	SYN_CLAUSE_19		(1U << 18)
#define	SYN_CLAUSE_20		(1U << 19)
#define	SYN_CLAUSE_21		(1U << 20)
#define	SYN_CLAUSE_22		(1U << 21)
#define	SYN_CLAUSE_23		(1U << 22)
#define	SYN_CLAUSE_24		(1U << 23)
#define	SYN_CLAUSE_25		(1U << 24)
#define	SYN_CLAUSE_26		(1U << 25)
#define	SYN_CLAUSE_27		(1U << 26)
#define	SYN_CLAUSE_28		(1U << 27)
#define	SYN_CLAUSE_29		(1U << 28)
#define	SYN_CLAUSE_30		(1U << 29)
#define	SYN_CLAUSE_31		(1U << 30)
#define	SYN_CLAUSE_32		(1U << 31)

#define	EVAL_DEPTH		32
#define	PROG_DEPTH		16

/* Global variables */

struct cb_program		*current_program = NULL;
struct cb_statement		*current_statement = NULL;
struct cb_label			*current_section = NULL;
struct cb_label			*current_paragraph = NULL;
cb_tree				defined_prog_list = NULL;
int				cb_exp_line = 0;

cb_tree				cobc_printer_node = NULL;
int				functions_are_all = 0;
int				non_const_word = 0;
int				suppress_data_exceptions = 0;
int				call_line_number;
unsigned int			cobc_repeat_last_token = 0;
unsigned int			cobc_in_id = 0;
unsigned int			cobc_in_procedure = 0;
unsigned int			cobc_in_repository = 0;
unsigned int			cobc_force_literal = 0;
unsigned int			cobc_cs_check = 0;
unsigned int			cobc_allow_program_name = 0;

/* Local variables */

enum tallying_phrase {
	NO_PHRASE,
	FOR_PHRASE,
	CHARACTERS_PHRASE,
	ALL_LEADING_TRAILING_PHRASES,
	VALUE_REGION_PHRASE
};

static struct cb_statement	*main_statement;

static cb_tree			current_expr;
static struct cb_field		*current_field;
static struct cb_field		*description_field;
static struct cb_file		*current_file;
static struct cb_cd		*current_cd;
static struct cb_report		*current_report;
static struct cb_report		*report_instance;

static struct cb_file		*linage_file;
static cb_tree			next_label_list;

static char			*stack_progid[PROG_DEPTH];

static enum cb_storage		current_storage;

static cb_tree			perform_stack;
static cb_tree			qualifier;
static cb_tree			keys_list;

static cb_tree			save_tree;
static cb_tree			start_tree;

static unsigned int		check_unreached;
static unsigned int		in_declaratives;
static unsigned int		in_debugging;
static unsigned int		current_linage;
static unsigned int		report_count;
static unsigned int		first_prog;
static unsigned int		setup_from_identification;
static unsigned int		use_global_ind;
static unsigned int		same_area;
static unsigned int		inspect_keyword;
static unsigned int		main_flag_set;
static int			next_label_id;
static int			eval_level;
static int			eval_inc;
static int			eval_inc2;
static int			depth;
static int			first_nested_program;
static int			call_mode;
static int			size_mode;
static cob_flags_t		set_attr_val_on;
static cob_flags_t		set_attr_val_off;
static cob_flags_t		check_duplicate;
static cob_flags_t		check_on_off_duplicate;
static cob_flags_t		check_pic_duplicate;
static cob_flags_t		check_line_col_duplicate;
static unsigned int		skip_statements;
static unsigned int		start_debug;
static unsigned int		save_debug;
static unsigned int		needs_field_debug;
static unsigned int		needs_debug_item;
static unsigned int		env_div_seen;
static cob_flags_t		header_check;
static unsigned int		call_nothing;
static enum tallying_phrase	previous_tallying_phrase;
static cb_tree			default_rounded_mode;

static enum cb_display_type	display_type;
static int			is_first_display_item;
static cb_tree			advancing_value;
static cb_tree			upon_value;
static cb_tree			line_column;

static int			term_array[TERM_MAX];
static cb_tree			eval_check[EVAL_DEPTH][EVAL_DEPTH];

/* Defines for header presence */

#define	COBC_HD_ENVIRONMENT_DIVISION	(1U << 0)
#define	COBC_HD_CONFIGURATION_SECTION	(1U << 1)
#define	COBC_HD_SPECIAL_NAMES		(1U << 2)
#define	COBC_HD_INPUT_OUTPUT_SECTION	(1U << 3)
#define	COBC_HD_FILE_CONTROL		(1U << 4)
#define	COBC_HD_I_O_CONTROL		(1U << 5)
#define	COBC_HD_DATA_DIVISION		(1U << 6)
#define	COBC_HD_FILE_SECTION		(1U << 7)
#define	COBC_HD_WORKING_STORAGE_SECTION	(1U << 8)
#define	COBC_HD_LOCAL_STORAGE_SECTION	(1U << 9)
#define	COBC_HD_LINKAGE_SECTION		(1U << 10)
#define	COBC_HD_COMMUNICATION_SECTION	(1U << 11)
#define	COBC_HD_REPORT_SECTION		(1U << 12)
#define	COBC_HD_SCREEN_SECTION		(1U << 13)
#define	COBC_HD_PROCEDURE_DIVISION	(1U << 14)
#define	COBC_HD_PROGRAM_ID		(1U << 15)

/* Static functions */

static void
begin_statement (const char *name, const unsigned int term)
{
	if (check_unreached) {
		cb_warning (cb_warn_unreachable, _("unreachable statement '%s'"), name);
	}
	current_paragraph->flag_statement = 1;
	current_statement = cb_build_statement (name);
	CB_TREE (current_statement)->source_file = cb_source_file;
	CB_TREE (current_statement)->source_line = cb_source_line;
	current_statement->flag_in_debug = in_debugging;
	emit_statement (CB_TREE (current_statement));
	if (term) {
		term_array[term]++;
	}
	main_statement = current_statement;
}

/* create a new statement with base attributes of current_statement
   and set this as new current_statement */
static void
begin_implicit_statement (void)
{
	struct cb_statement	*new_statement;
	new_statement = cb_build_statement (NULL);
	new_statement->common = current_statement->common;
	new_statement->name = current_statement->name;
	new_statement->flag_in_debug = !!in_debugging;
	current_statement = new_statement;
	main_statement->body = cb_list_add (main_statement->body,
					    CB_TREE (current_statement));
}

# if 0 /* activate only for debugging purposes for attribs */
static
void print_bits (cob_flags_t num)
{
	unsigned int 	size = sizeof (cob_flags_t);
	unsigned int	max_pow = 1 << (size * 8 - 1);
	int 		i = 0;

	for(; i < size * 8; ++i){
		/* Print last bit and shift left. */
		fprintf (stderr, "%u ", num & max_pow ? 1 : 0);
		num = num << 1;
	}
	fprintf (stderr, "\n");
}
#endif

static void
emit_entry (const char *name, const int encode, cb_tree using_list, cb_tree convention)
{
	cb_tree		l;
	cb_tree		label;
	cb_tree		x;
	cb_tree		entry_conv;
	struct cb_field	*f, *ret_f;
	int			param_num;
	char		buff[COB_MINI_BUFF];

	snprintf (buff, (size_t)COB_MINI_MAX, "E$%s", name);
	label = cb_build_label (cb_build_reference (buff), NULL);
	if (encode) {
		CB_LABEL (label)->name = cb_encode_program_id (name);
		CB_LABEL (label)->orig_name = name;
	} else {
		CB_LABEL (label)->name = name;
		CB_LABEL (label)->orig_name = current_program->orig_program_id;
	}
	CB_LABEL (label)->flag_begin = 1;
	CB_LABEL (label)->flag_entry = 1;
	label->source_file = cb_source_file;
	label->source_line = cb_source_line;
	emit_statement (label);

	if (current_program->flag_debugging) {
		emit_statement (cb_build_debug (cb_debug_contents,
						"START PROGRAM", NULL));
	}

	param_num = 1;
	for (l = using_list; l; l = CB_CHAIN (l)) {
		x = CB_VALUE (l);
		if (CB_VALID_TREE (x) && cb_ref (x) != cb_error_node) {
			f = CB_FIELD (cb_ref (x));
			if (!current_program->flag_chained) {
				if (f->storage != CB_STORAGE_LINKAGE) {
					cb_error_x (x, _("'%s' is not in LINKAGE SECTION"), f->name);
				}
				if (f->flag_item_based || f->flag_external) {
					cb_error_x (x, _("'%s' cannot be BASED/EXTERNAL"), f->name);
				}
				f->flag_is_pdiv_parm = 1;
			} else {
				if (f->storage != CB_STORAGE_WORKING) {
					cb_error_x (x, _("'%s' is not in WORKING-STORAGE SECTION"), f->name);
				}
				f->flag_chained = 1;
				f->param_num = param_num;
				param_num++;
			}
			if (f->level != 01 && f->level != 77) {
				cb_error_x (x, _("'%s' not level 01 or 77"), f->name);
			}
			if (f->redefines) {
				cb_error_x (x, _ ("'%s' REDEFINES field not allowed here"), f->name);
			}
			/* add a "receiving" entry for the USING parameter */
			if (cb_listing_xref) {
				cobc_xref_link (&f->xref, CB_REFERENCE (x)->common.source_line, 1);
			}
		}
	}


	if (current_program->returning &&
		cb_ref (current_program->returning) != cb_error_node) {
		ret_f = CB_FIELD (cb_ref (current_program->returning));
		if (ret_f->redefines) {
			cb_error_x (current_program->returning, _("'%s' REDEFINES field not allowed here"), ret_f->name);
		}
	} else {
		ret_f = NULL;
	}

	/* Check dangling LINKAGE items */
	if (cb_warn_linkage) {
		for (f = current_program->linkage_storage; f; f = f->sister) {
			if (f == ret_f) {
				continue;
			}
			for (l = using_list; l; l = CB_CHAIN (l)) {
				x = CB_VALUE (l);
				if (CB_VALID_TREE (x) && cb_ref (x) != cb_error_node) {
					if (f == CB_FIELD (cb_ref (x))) {
						break;
					}
				}
			}
			if (!l && !f->redefines) {
				cb_warning (cb_warn_linkage, _("LINKAGE item '%s' is not a PROCEDURE USING parameter"), f->name);
			}
		}
	}

	/* Check returning item against using items when FUNCTION */
	if (current_program->prog_type == CB_FUNCTION_TYPE && current_program->returning) {
		for (l = using_list; l; l = CB_CHAIN (l)) {
			x = CB_VALUE (l);
			if (CB_VALID_TREE (x) && cb_ref (x) != cb_error_node) {
				f = CB_FIELD (cb_ref (x));
				if (ret_f == f) {
					cb_error_x (x, _("'%s' USING item duplicates RETURNING item"), f->name);
				}
			}
		}
	}

	for (l = current_program->entry_list; l; l = CB_CHAIN (l)) {
		if (strcmp ((const char *)name,
			    (const char *)(CB_LABEL(CB_PURPOSE(l))->name)) == 0) {
			cb_error_x (CB_TREE (current_statement),
				    _("ENTRY '%s' duplicated"), name);
		}
	}

	if (convention) {
		entry_conv = convention;
	} else {
		entry_conv = current_program->entry_convention;
	}

	current_program->entry_list =
		cb_list_append (current_program->entry_list,
				CB_BUILD_PAIR (label, CB_BUILD_PAIR(entry_conv, using_list)));
}

static size_t
increment_depth (void)
{
	if (++depth >= PROG_DEPTH) {
		cb_error (_("maximum nested program depth exceeded (%d)"),
			  PROG_DEPTH);
		return 1;
	}
	return 0;
}

static void
terminator_warning (cb_tree stmt, const unsigned int termid,
		    const char *name)
{
	char		terminator[32];

	check_unreached = 0;
	if (term_array[termid]) {
		term_array[termid]--;
	/* LCOV_EXCL_START */
	} else {
		cobc_err_msg ("call to '%s' without any open term for %s",
			"terminator_warning", name);
		COBC_ABORT ();
	}
	/* LCOV_EXCL_END */
	snprintf (terminator, 32, "END-%s", name);
	if (is_reserved_word (terminator)) {
		cb_warning_x (cb_warn_terminator, CB_TREE (current_statement),
			_("%s statement not terminated by %s"), name, terminator);
	}

	/* Free tree associated with terminator */
	if (stmt) {
		cobc_parse_free (stmt);
	}
}

static void
terminator_error (cb_tree stmt, const unsigned int termid, const char *name)
{
	char		terminator[32];

	check_unreached = 0;
	if (term_array[termid]) {
		term_array[termid]--;
	/* LCOV_EXCL_START */
	} else {
		cobc_err_msg ("call to '%s' without any open term for %s",
			"terminator_error", name);
		COBC_ABORT ();
	}
	/* LCOV_EXCL_END */
	snprintf (terminator, 32, "END-%s", name);
	if (is_reserved_word (terminator)) {
		cb_error_x (CB_TREE (current_statement),
			_("%s statement not terminated by %s"), name, terminator);
	} else {
		cb_error_x (CB_TREE (current_statement),
			_("%s statement not terminated"), name);
	}

	/* Free tree associated with terminator */
	if (stmt) {
		cobc_parse_free (stmt);
	}
}

static void
terminator_clear (cb_tree stmt, const unsigned int termid)
{
	struct cb_perform	*p;
	check_unreached = 0;
	if (term_array[termid]) {
		term_array[termid]--;
	/* LCOV_EXCL_START */
	} else {
		cobc_err_msg ("call to '%s' without any open term for %s",
			"terminator_warning", current_statement->name);
		COBC_ABORT ();
	}
	/* LCOV_EXCL_END */
	if (termid == TERM_PERFORM
	 && perform_stack) {
		p = CB_PERFORM (CB_VALUE (perform_stack));
		if (p->perform_type == CB_PERFORM_UNTIL) {
			cb_terminate_cond ();
		}
	}
	/* Free tree associated with terminator */
	if (stmt) {
		cobc_parse_free (stmt);
	}
}

static int
literal_value (cb_tree x)
{
	if (x == cb_space) {
		return ' ';
	} else if (x == cb_zero) {
		return '0';
	} else if (x == cb_quote) {
		return cb_flag_apostrophe ? '\'' : '"';
	} else if (x == cb_null) {
		return 0;
	} else if (x == cb_low) {
		return 0;
	} else if (x == cb_high) {
		return 255;
	} else if (CB_TREE_CLASS (x) == CB_CLASS_NUMERIC) {
		return cb_get_int (x);
	} else {
		return CB_LITERAL (x)->data[0];
	}
}

static void
setup_use_file (struct cb_file *fileptr)
{
	struct cb_file	*newptr;

	if (fileptr->organization == COB_ORG_SORT) {
		cb_error (_("USE statement invalid for SORT file"));
	}
	if (fileptr->flag_global) {
		newptr = cobc_parse_malloc (sizeof(struct cb_file));
		*newptr = *fileptr;
		newptr->handler = current_section;
		newptr->handler_prog = current_program;
		if (!use_global_ind) {
			current_program->local_file_list =
				cb_list_add (current_program->local_file_list,
					     CB_TREE (newptr));
		} else {
			current_program->global_file_list =
				cb_list_add (current_program->global_file_list,
					     CB_TREE (newptr));
		}
	} else {
		fileptr->handler = current_section;
	}
}

static void
emit_duplicate_clause_message (const char *clause)
{
	/* FIXME: replace by a new warning level that is set
	   to warn/error depending on cb_relaxed_syntax_checks */
	if (cb_relaxed_syntax_checks) {
		cb_warning (COBC_WARN_FILLER, _("duplicate %s clause"), clause);
	} else {
		cb_error (_("duplicate %s clause"), clause);
	}
}

static void
check_repeated (const char *clause, const cob_flags_t bitval, cob_flags_t *already_seen)
{
	if (*already_seen & bitval) {
		emit_duplicate_clause_message (clause);
	} else {
		*already_seen |= bitval;
	}
}

static void
setup_occurs (void)
{
	check_repeated ("OCCURS", SYN_CLAUSE_7, &check_pic_duplicate);
	if (current_field->indexes == COB_MAX_SUBSCRIPTS) {
		cb_error (_ ("maximum OCCURS depth exceeded (%d)"),
			COB_MAX_SUBSCRIPTS);
	} else {
		current_field->indexes++;
	}

	if (current_field->flag_unbounded) {
		if (current_field->storage != CB_STORAGE_LINKAGE) {
			cb_error_x (CB_TREE(current_field), _("'%s' is not in LINKAGE SECTION"),
				cb_name (CB_TREE(current_field)));
		}
	}

	if (current_field->flag_item_based) {
		cb_error (_ ("%s and %s are mutually exclusive"), "BASED", "OCCURS");
	} else if (current_field->flag_external) {
		cb_error (_ ("%s and %s are mutually exclusive"), "EXTERNAL", "OCCURS");
	}
	current_field->flag_occurs = 1;
}

static void
setup_occurs_min_max (cb_tree occurs_min, cb_tree occurs_max)
{
	if (occurs_max) {
		current_field->occurs_min = cb_get_int (occurs_min);
		if (occurs_max != cb_int0) {
			current_field->occurs_max = cb_get_int (occurs_max);
			if (!current_field->depending) {
				if (cb_relaxed_syntax_checks) {
					cb_warning (COBC_WARN_FILLER, _ ("TO phrase without DEPENDING phrase"));
					cb_warning (COBC_WARN_FILLER, _ ("maximum number of occurences assumed to be exact number"));
					current_field->occurs_min = 1; /* CHECKME: why using 1 ? */
				} else {
					cb_error (_ ("TO phrase without DEPENDING phrase"));
				}
			}
			if (current_field->occurs_max <= current_field->occurs_min) {
				cb_error (_ ("OCCURS TO must be greater than OCCURS FROM"));
			}
		} else {
			current_field->occurs_max = 0;
		}
	} else {
		current_field->occurs_min = 1; /* CHECKME: why using 1 ? */
		current_field->occurs_max = cb_get_int (occurs_min);
		if (current_field->depending) {
			cb_verify (cb_odo_without_to, _ ("ODO without TO phrase"));
		}
	}
}

static void
check_relaxed_syntax (const cob_flags_t lev)
{
	const char	*s;

	switch (lev) {
	case COBC_HD_ENVIRONMENT_DIVISION:
		s = "ENVIRONMENT DIVISION";
		break;
	case COBC_HD_CONFIGURATION_SECTION:
		s = "CONFIGURATION SECTION";
		break;
	case COBC_HD_SPECIAL_NAMES:
		s = "SPECIAL-NAMES";
		break;
	case COBC_HD_INPUT_OUTPUT_SECTION:
		s = "INPUT-OUTPUT SECTION";
		break;
	case COBC_HD_FILE_CONTROL:
		s = "FILE-CONTROL";
		break;
	case COBC_HD_I_O_CONTROL:
		s = "I-O-CONTROL";
		break;
	case COBC_HD_DATA_DIVISION:
		s = "DATA DIVISION";
		break;
	case COBC_HD_FILE_SECTION:
		s = "FILE SECTION";
		break;
	case COBC_HD_WORKING_STORAGE_SECTION:
		s = "WORKING-STORAGE SECTION";
		break;
	case COBC_HD_LOCAL_STORAGE_SECTION:
		s = "LOCAL-STORAGE SECTION";
		break;
	case COBC_HD_LINKAGE_SECTION:
		s = "LINKAGE SECTION";
		break;
	case COBC_HD_COMMUNICATION_SECTION:
		s = "COMMUNICATION SECTION";
		break;
	case COBC_HD_REPORT_SECTION:
		s = "REPORT SECTION";
		break;
	case COBC_HD_SCREEN_SECTION:
		s = "SCREEN SECTION";
		break;
	case COBC_HD_PROCEDURE_DIVISION:
		s = "PROCEDURE DIVISION";
		break;
	case COBC_HD_PROGRAM_ID:
		s = "PROGRAM-ID";
		break;
	default:
		s = "Unknown";
		break;
	}
	if (cb_relaxed_syntax_checks) {
		cb_warning (COBC_WARN_FILLER, _("%s header missing - assumed"), s);
	} else {
		cb_error (_("%s header missing"), s);
	}
}

/* check if headers are present - return 0 if fine, 1 if missing
   Lev1 must always be present and is checked
   Lev2/3/4, if non-zero (forced) may be present
*/
static int
check_headers_present (const cob_flags_t lev1, const cob_flags_t lev2,
		       const cob_flags_t lev3, const cob_flags_t lev4)
{
	int ret = 0;
	if (!(header_check & lev1)) {
		header_check |= lev1;
		check_relaxed_syntax (lev1);
		ret = 1;
	}
	if (lev2) {
		if (!(header_check & lev2)) {
			header_check |= lev2;
			check_relaxed_syntax (lev2);
			ret = 1;
		}
	}
	if (lev3) {
		if (!(header_check & lev3)) {
			header_check |= lev3;
			check_relaxed_syntax (lev3);
			ret = 1;
		}
	}
	if (lev4) {
		if (!(header_check & lev4)) {
			header_check |= lev4;
			check_relaxed_syntax (lev4);
			ret = 1;
		}
	}
	return ret;
}

static void
build_nested_special (const int ndepth)
{
	cb_tree		x;
	cb_tree		y;

	if (!ndepth) {
		return;
	}

	/* Inherit special name mnemonics from parent */
	for (x = current_program->mnemonic_spec_list; x; x = CB_CHAIN (x)) {
		y = cb_build_reference (cb_name(CB_PURPOSE(x)));
		if (CB_SYSTEM_NAME_P (CB_VALUE(x))) {
			cb_define (y, CB_VALUE(x));
		} else {
			cb_build_constant (y, CB_VALUE(x));
		}
	}
}

static void
clear_initial_values (void)
{
	perform_stack = NULL;
	current_statement = NULL;
	main_statement = NULL;
	qualifier = NULL;
	in_declaratives = 0;
	in_debugging = 0;
	use_global_ind = 0;
	check_duplicate = 0;
	check_pic_duplicate = 0;
	skip_statements = 0;
	start_debug = 0;
	save_debug = 0;
	needs_field_debug = 0;
	needs_debug_item = 0;
	env_div_seen = 0;
	header_check = 0;
	next_label_id = 0;
	current_linage = 0;
	set_attr_val_on = 0;
	set_attr_val_off = 0;
	report_count = 0;
	current_storage = CB_STORAGE_WORKING;
	eval_level = 0;
	eval_inc = 0;
	eval_inc2 = 0;
	inspect_keyword = 0;
	check_unreached = 0;
	cobc_in_id = 0;
	cobc_in_procedure = 0;
	cobc_in_repository = 0;
	cobc_force_literal = 0;
	non_const_word = 0;
	suppress_data_exceptions = 0;
	same_area = 1;
	memset ((void *)eval_check, 0, sizeof(eval_check));
	memset ((void *)term_array, 0, sizeof(term_array));
	linage_file = NULL;
	current_file = NULL;
	current_cd = NULL;
	current_report = NULL;
	report_instance = NULL;
	next_label_list = NULL;
	default_rounded_mode = cb_int (COB_STORE_ROUND);
}

/*
  We must check for redefinitions of program-names and external program names
  outside of the usual reference/word_list methods as it may have to be done in
  a case-sensitive way.
*/
static void
begin_scope_of_program_name (struct cb_program *program)
{
	const char	*prog_name = program->program_name;
	const char	*prog_id = program->orig_program_id;
	const char	*elt_name;
	const char	*elt_id;
	cb_tree		l;

	/* Error if a program with the same name has been defined. */
	for (l = defined_prog_list; l; l = CB_CHAIN (l)) {
		elt_name = ((struct cb_program *) CB_VALUE (l))->program_name;
		elt_id = ((struct cb_program *) CB_VALUE (l))->orig_program_id;
		if (cb_fold_call && strcasecmp (prog_name, elt_name) == 0) {
			cb_error_x ((cb_tree) program,
				    _("redefinition of program name '%s'"),
				    elt_name);
		} else if (strcmp (prog_id, elt_id) == 0) {
		        cb_error_x ((cb_tree) program,
				    _("redefinition of program ID '%s'"),
				    elt_id);
			return;
		}
	}

	/* Otherwise, add the program to the list. */
	defined_prog_list = cb_list_add (defined_prog_list,
					 (cb_tree) program);
}

static void
remove_program_name (struct cb_list *l, struct cb_list *prev)
{
	if (prev == NULL) {
		defined_prog_list = l->chain;
	} else {
		prev->chain = l->chain;
	}
	cobc_parse_free (l);
}

/* Remove the program from defined_prog_list, if necessary. */
static void
end_scope_of_program_name (struct cb_program *program, const unsigned char type)
{
	struct	cb_list	*prev = NULL;
	struct	cb_list *l = (struct cb_list *) defined_prog_list;

	/* create empty entry if the program has no PROCEDURE DIVISION, error for UDF */
	if (!program->entry_list) {
		if (type == CB_FUNCTION_TYPE) {
			cb_error (_("FUNCTION '%s' has no PROCEDURE DIVISION"), program->program_name);
		} else {
			emit_entry (program->program_id, 0, NULL, NULL);
		}
	}

	if (program->nested_level == 0) {
		return;
	}

	/* Remove any subprograms */
	l = CB_LIST (defined_prog_list);
	while (l) {
		if (CB_PROGRAM (l->value)->nested_level > program->nested_level) {
			remove_program_name (l, prev);
		} else {
			prev = l;
		}
		if (prev && prev->chain != NULL) {
			l = CB_LIST (prev->chain);
		} else {
			l = NULL;
		}
	}

	/* Remove the specified program, if it is not COMMON */
	if (!program->flag_common) {
		l = (struct cb_list *) defined_prog_list;
		while (l) {
			if (strcmp (program->orig_program_id,
				    CB_PROGRAM (l->value)->orig_program_id)
			    == 0) {
				remove_program_name (l, prev);
				if (prev && prev->chain != NULL) {
					l = CB_LIST (prev->chain);
				} else {
					l = NULL;
				}
				break;
			} else {
				prev = l;
				if (l->chain != NULL) {
					l = CB_LIST (l->chain);
				} else {
					l = NULL;
				}
			}
		}
	}
}

static void
setup_program_start (void)
{
	if (setup_from_identification) {
		setup_from_identification = 0;
		return;
	}
	current_section = NULL;
	current_paragraph = NULL;

	if (depth != 0 && first_nested_program) {
		check_headers_present (COBC_HD_PROCEDURE_DIVISION, 0, 0, 0);
	}
	first_nested_program = 1;
}

static int
setup_program (cb_tree id, cb_tree as_literal, const unsigned char type)
{
	setup_program_start ();

	if (first_prog) {
		first_prog = 0;
	} else {
		if (!current_program->flag_validated) {
			current_program->flag_validated = 1;
			cb_validate_program_body (current_program);
		}

		clear_initial_values ();
		current_program = cb_build_program (current_program, depth);
		build_nested_special (depth);
		cb_set_intr_when_compiled ();
		cb_build_registers ();
	}

	if (CB_LITERAL_P (id)) {
		stack_progid[depth] = (char *)(CB_LITERAL (id)->data);
	} else {
		stack_progid[depth] = (char *)(CB_NAME (id));
	}

	if (depth != 0 && type == CB_FUNCTION_TYPE) {
		cb_error (_("functions may not be defined within a program/function"));
	}

	if (increment_depth ()) {
		return 1;
	}

	current_program->program_id = cb_build_program_id (id, as_literal, type == CB_FUNCTION_TYPE);
	current_program->prog_type = type;

	if (type == CB_PROGRAM_TYPE) {
		if (!main_flag_set) {
			main_flag_set = 1;
			current_program->flag_main = !!cobc_flag_main;
		}
	} else { /* CB_FUNCTION_TYPE */
		current_program->flag_recursive = 1;
	}

	if (CB_REFERENCE_P (id)) {
	        cb_define (id, CB_TREE (current_program));
	}

	begin_scope_of_program_name (current_program);

	return 0;
}

static void
decrement_depth (const char *name, const unsigned char type)
{
	int	d;

	if (depth) {
		depth--;
	}

	if (!strcmp (stack_progid[depth], name)) {
		return;
	}

	if (type == CB_FUNCTION_TYPE) {
		cb_error (_("END FUNCTION '%s' is different from FUNCTION-ID '%s'"),
			  name, stack_progid[depth]);
		return;
	}

	/* Set depth to that of whatever program we just ended, if it exists. */
	for (d = depth; d >= 0; --d) {
		if (!strcmp (stack_progid[d], name)) {
			depth = d;
			return;
		}
	}

	if (depth != d) {
		cb_error (_("END PROGRAM '%s' is different from PROGRAM-ID '%s'"),
			  name, stack_progid[depth]);
	}
}

static void
clean_up_program (cb_tree name, const unsigned char type)
{
	char		*s;

	end_scope_of_program_name (current_program, type);

	if (name) {
		if (CB_LITERAL_P (name)) {
			s = (char *)(CB_LITERAL (name)->data);
		} else {
			s = (char *)(CB_NAME (name));
		}

		decrement_depth (s, type);
	}

	current_section = NULL;
	current_paragraph = NULL;
	if (!current_program->flag_validated) {
		current_program->flag_validated = 1;
		cb_validate_program_body (current_program);
	}
}

static const char *
get_literal_or_word_name (const cb_tree x)
{
	if (CB_LITERAL_P (x)) {
		return (const char *) CB_LITERAL (x)->data;
	} else { /* CB_REFERENCE_P (x) */
		return (const char *) CB_NAME (x);
	}
}

/* verify and set picture sign for currency */
static void
set_currency_picture_symbol (const cb_tree x)
{
	unsigned char	*s		= CB_LITERAL (x)->data;

	if (CB_LITERAL (x)->size != 1) {
		cb_error_x (x, _("PICTURE SYMBOL for CURRENCY must be one character long"));
		return;
	}
	switch (*s) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'N':
	case 'P':
	case 'R':
	case 'S':
	case 'V':
	case 'X':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'n':
	case 'p':
	case 'r':
	case 's':
	case 'v':
	case 'x':
	case 'z':
	case '+':
	case '-':
	case ',':
	case '.':
	case '*':
	case '/':
	case ';':
	case '(':
	case ')':
	case '=':
	case '\'':
	case '"':
	case ' ':
		cb_error_x (x, _("invalid character '%c' in PICTURE SYMBOL for CURRENCY"), s[0]);
		return;
	default:
		break;
	}
	current_program->currency_symbol = s[0];
}

/* Return 1 if the prototype name is the same as the current function's. */
static int
check_prototype_redefines_current_element (const cb_tree prototype_name)
{
	const char	*name = get_literal_or_word_name (prototype_name);

	if (strcasecmp (name, current_program->program_name) == 0) {
		cb_warning_x (COBC_WARN_FILLER, prototype_name,
			_("prototype has same name as current function and will be ignored"));
		return 1;
	}

	return 0;
}

/* Returns 1 if the prototype has been duplicated. */
static int
check_for_duplicate_prototype (const cb_tree prototype_name,
			       const cb_tree prototype)
{
	cb_tree	dup;

	if (CB_WORD_COUNT (prototype_name) > 0) {
		/* Make sure the duplicate is a prototype */
		dup = cb_ref (prototype_name);
		if (!CB_PROTOTYPE_P (dup)) {
			redefinition_error (prototype_name);
			return 1;
		}

		/* Check the duplicate prototypes match */
		if (strcmp (CB_PROTOTYPE (prototype)->ext_name,
			    CB_PROTOTYPE (dup)->ext_name)
		    || CB_PROTOTYPE (prototype)->type != CB_PROTOTYPE (dup)->type) {
			cb_error_x (prototype_name,
				    _("duplicate REPOSITORY entries for '%s' do not match"),
				    get_literal_or_word_name (prototype_name));
		} else {
			cb_warning_x (COBC_WARN_FILLER, prototype_name,
				      _("duplicate REPOSITORY entry for '%s'"),
				      get_literal_or_word_name (prototype_name));
		}
		return 1;
	}

	return 0;
}

static void
setup_prototype (cb_tree prototype_name, cb_tree ext_name,
		  const int type, const int is_current_element)
{
	cb_tree	prototype;
	int	name_redefinition_allowed;

	if (!is_current_element
	    && check_prototype_redefines_current_element (prototype_name)) {
		return;
	}

	prototype = cb_build_prototype (prototype_name, ext_name, type);

	if (!is_current_element
	    && check_for_duplicate_prototype (prototype_name, prototype)) {
		return;
	}

	name_redefinition_allowed = type == CB_PROGRAM_TYPE
		&& is_current_element && cb_program_name_redefinition;
	if (!name_redefinition_allowed) {
		if (CB_LITERAL_P (prototype_name)) {
			cb_define (cb_build_reference ((const char *)CB_LITERAL (prototype_name)->data), prototype);
		} else {
			cb_define (prototype_name, prototype);
		}

		if (type == CB_PROGRAM_TYPE) {
			current_program->program_spec_list =
				cb_list_add (current_program->program_spec_list, prototype);
		} else { /* CB_FUNCTION_TYPE */
			current_program->user_spec_list =
				cb_list_add (current_program->user_spec_list, prototype);
		}
	}
}

static void
error_if_invalid_level_for_renames (cb_tree item)
{
	int	level = CB_FIELD (cb_ref (item))->level;

	if (level == 1 || level == 66 || level == 77) {
	        cb_verify (cb_renames_uncommon_levels,
			   _("RENAMES of 01-, 66- and 77-level items"));
	} else if (level == 88) {
		cb_error (_("RENAMES may not reference a level 88"));
	}
}

static int
set_current_field (cb_tree level, cb_tree name)
{
	cb_tree	x  = cb_build_field_tree (level, name, current_field,
					  current_storage, current_file, 0);
	cobc_parse_free (level);

	if (CB_INVALID_TREE (x)) {
	        return 1;
	} else {
		current_field = CB_FIELD (x);
		check_pic_duplicate = 0;
	}

	return 0;
}

static void
check_not_both (const cob_flags_t flag1, const cob_flags_t flag2,
		const char *flag1_name, const char *flag2_name,
		const cob_flags_t flags, const cob_flags_t flag_to_set)
{
	if (flag_to_set == flag1 && (flags & flag2)) {
		cb_error (_("cannot specify both %s and %s"),
			  flag1_name, flag2_name);
	} else if (flag_to_set == flag2 && (flags & flag1)) {
		cb_error (_("cannot specify both %s and %s"),
			  flag1_name, flag2_name);

	}
}

static COB_INLINE COB_A_INLINE void
check_not_highlight_and_lowlight (const cob_flags_t flags,
				  const cob_flags_t flag_to_set)
{
	check_not_both (COB_SCREEN_HIGHLIGHT, COB_SCREEN_LOWLIGHT,
			"HIGHLIGHT", "LOWLIGHT", flags, flag_to_set);
}

static void
set_screen_attr (const char *clause, const cob_flags_t bitval)
{
	if (current_field->screen_flag & bitval) {
		emit_duplicate_clause_message (clause);
	} else {
		current_field->screen_flag |= bitval;
	}
}

static void
emit_conflicting_clause_message (const char *clause, const char *conflicting)
{
	if (cb_relaxed_syntax_checks) {
		cb_warning (COBC_WARN_FILLER, _("cannot specify both %s and %s; %s is ignored"),
			clause, conflicting, clause);
	} else {
		cb_error (_("cannot specify both %s and %s"),
			clause, conflicting);
	}

}

static void
set_attr_with_conflict (const char *clause, const cob_flags_t bitval,
			const char *confl_clause, const cob_flags_t confl_bit,
			const int local_check_duplicate, cob_flags_t *flags)
{
	if (local_check_duplicate && (*flags & bitval)) {
		emit_duplicate_clause_message (clause);
	} else if (*flags & confl_bit) {
		emit_conflicting_clause_message (clause, confl_clause);
	} else {
	*flags |= bitval;
	}
}

static COB_INLINE COB_A_INLINE void
set_screen_attr_with_conflict (const char *clause, const cob_flags_t bitval,
			       const char *confl_clause,
			       const cob_flags_t confl_bit)
{
	set_attr_with_conflict (clause, bitval, confl_clause, confl_bit, 1,
				&current_field->screen_flag);
}

static COB_INLINE COB_A_INLINE int
has_dispattr (const cob_flags_t attrib)
{
	return current_statement->attr_ptr
		&& current_statement->attr_ptr->dispattrs & attrib;
}

static void
attach_attrib_to_cur_stmt (void)
{
	if (!current_statement->attr_ptr) {
		current_statement->attr_ptr =
			cobc_parse_malloc (sizeof(struct cb_attr_struct));
	}
}

static COB_INLINE COB_A_INLINE void
set_dispattr (const cob_flags_t attrib)
{
	attach_attrib_to_cur_stmt ();
	current_statement->attr_ptr->dispattrs |= attrib;
}

static COB_INLINE COB_A_INLINE void
set_dispattr_with_conflict (const char *attrib_name, const cob_flags_t attrib,
			    const char *confl_name,
			    const cob_flags_t confl_attrib)
{
	attach_attrib_to_cur_stmt ();
	set_attr_with_conflict (attrib_name, attrib, confl_name, confl_attrib, 0,
				&current_statement->attr_ptr->dispattrs);
}

static void
bit_set_attr (const cb_tree on_off, const cob_flags_t attr_val)
{
	if (on_off == cb_int1) {
		set_attr_val_on |= attr_val;
	} else {
		set_attr_val_off |= attr_val;
	}
}

static void
set_field_attribs (cb_tree fgc, cb_tree bgc, cb_tree scroll,
		   cb_tree timeout, cb_tree prompt, cb_tree size_is)
{
	/* [WITH] FOREGROUND-COLOR [IS] */
	if (fgc) {
		current_statement->attr_ptr->fgc = fgc;
	}
	/* [WITH] BACKGROUND-COLOR [IS] */
	if (bgc) {
		current_statement->attr_ptr->bgc = bgc;
	}
	/* [WITH] SCROLL UP | DOWN */
	if (scroll) {
		current_statement->attr_ptr->scroll = scroll;
	}
	/* [WITH] TIME-OUT [AFTER] */
	if (timeout) {
		current_statement->attr_ptr->timeout = timeout;
	}
	/* [WITH] PROMPT CHARACTER [IS] */
	if (prompt) {
		current_statement->attr_ptr->prompt = prompt;
	}
	/* [WITH] SIZE [IS] */
	if (size_is) {
		current_statement->attr_ptr->size_is = size_is;
	}
}

static void
set_attribs (cb_tree fgc, cb_tree bgc, cb_tree scroll,
	     cb_tree timeout, cb_tree prompt, cb_tree size_is,
	     const cob_flags_t attrib)
{
	attach_attrib_to_cur_stmt ();
	set_field_attribs (fgc, bgc, scroll, timeout, prompt, size_is);

	current_statement->attr_ptr->dispattrs |= attrib;
}

static void
set_attribs_with_conflict  (cb_tree fgc, cb_tree bgc, cb_tree scroll,
			    cb_tree timeout, cb_tree prompt, cb_tree size_is,
			    const char *clause_name, const cob_flags_t attrib,
			    const char *confl_name, const cob_flags_t confl_attrib)
{
	attach_attrib_to_cur_stmt ();
	set_field_attribs (fgc, bgc, scroll, timeout, prompt, size_is);

	set_dispattr_with_conflict (clause_name, attrib, confl_name,
				    confl_attrib);
}

static cob_flags_t
zero_conflicting_flag (const cob_flags_t screen_flag, cob_flags_t parent_flag,
				const cob_flags_t flag1, const cob_flags_t flag2)
{
	if (screen_flag & flag1) {
		parent_flag &= ~flag2;
	} else if (screen_flag & flag2) {
		parent_flag &= ~flag1;
	}

	return parent_flag;
}

static cob_flags_t
zero_conflicting_flags (const cob_flags_t screen_flag, cob_flags_t parent_flag)
{
	parent_flag = zero_conflicting_flag (screen_flag, parent_flag,
					     COB_SCREEN_BLANK_LINE,
					     COB_SCREEN_BLANK_SCREEN);
	parent_flag = zero_conflicting_flag (screen_flag, parent_flag,
					     COB_SCREEN_ERASE_EOL,
					     COB_SCREEN_ERASE_EOS);
	parent_flag = zero_conflicting_flag (screen_flag, parent_flag,
					     COB_SCREEN_HIGHLIGHT,
					     COB_SCREEN_LOWLIGHT);

	return parent_flag;
}

static void
check_and_set_usage (const enum cb_usage usage)
{
	check_repeated ("USAGE", SYN_CLAUSE_5, &check_pic_duplicate);
	current_field->usage = usage;
}

static void
check_preceding_tallying_phrases (const enum tallying_phrase phrase)
{
	switch (phrase) {
	case FOR_PHRASE:
		if (previous_tallying_phrase == ALL_LEADING_TRAILING_PHRASES) {
			cb_error (_("FOR phrase cannot immediately follow ALL/LEADING/TRAILING"));
		} else if (previous_tallying_phrase == FOR_PHRASE) {
			cb_error (_("missing CHARACTERS/ALL/LEADING/TRAILING phrase after FOR phrase"));
		}
		break;

	case CHARACTERS_PHRASE:
	case ALL_LEADING_TRAILING_PHRASES:
		if (previous_tallying_phrase == NO_PHRASE) {
			cb_error (_("missing FOR phrase before CHARACTERS/ALL/LEADING/TRAILING phrase"));
		} else if (previous_tallying_phrase == CHARACTERS_PHRASE
			   || previous_tallying_phrase == ALL_LEADING_TRAILING_PHRASES) {
			cb_error (_("missing value between CHARACTERS/ALL/LEADING/TRAILING words"));
		}
		break;

	case VALUE_REGION_PHRASE:
		if (!(previous_tallying_phrase == ALL_LEADING_TRAILING_PHRASES
		      || previous_tallying_phrase == VALUE_REGION_PHRASE)) {
			cb_error (_("missing ALL/LEADING/TRAILING before value"));
		}
		break;

		/* LCOV_EXCL_START */
	default:
		/* This should never happen (and therefore doesn't get a translation) */
		cb_error ("unexpected tallying phrase");
		COBC_ABORT();
		/* LCOV_EXCL_END */
	}

	previous_tallying_phrase = phrase;
}

static int
has_relative_pos (struct cb_field const *field)
{
	return !!(field->screen_flag
		  & (COB_SCREEN_LINE_PLUS | COB_SCREEN_LINE_MINUS
		     | COB_SCREEN_COLUMN_PLUS | COB_SCREEN_COLUMN_MINUS));
}

static int
is_recursive_call (cb_tree target)
{
	const char *target_name = "";

	if (CB_LITERAL_P (target)) {
		target_name = (const char *)(CB_LITERAL(target)->data);
	} else if (CB_REFERENCE_P (target)
		   && CB_PROTOTYPE_P (cb_ref (target))) {
		target_name = CB_PROTOTYPE (cb_ref (target))->ext_name;
	}

	return !strcmp (target_name, current_program->orig_program_id);
}

static void
check_not_88_level (cb_tree x)
{
	struct cb_field	*f;

	if (x == cb_error_node || x->tag != CB_TAG_REFERENCE) {
		return;
	}

	f = CB_FIELD (cb_ref (x));

	if (f != (struct cb_field *) cb_error_node && f->level == 88) {
		cb_error (_("88-level cannot be used here"));
	}
}

static int
is_screen_field (cb_tree x)
{
	if (CB_FIELD_P (x)) {
		return (CB_FIELD (x))->storage == CB_STORAGE_SCREEN;
	} else if (CB_REFERENCE_P (x)) {
		return is_screen_field (cb_ref (x));
	} else {
		return 0;
	}
}

static void
error_if_no_advancing_in_screen_display (cb_tree advancing)
{
	if (advancing != cb_int1) {
		cb_error (_("cannot specify NO ADVANCING in screen DISPLAY"));
	}
}

static cb_tree
get_default_display_device (void)
{
	if (current_program->flag_console_is_crt
	    || cb_console_is_crt) {
		return cb_null;
	} else {
		return cb_int0;
	}
}

static COB_INLINE COB_A_INLINE int
contains_one_screen_field (struct cb_list *x_list)
{
	return (cb_tree) x_list != cb_null
		&& cb_list_length ((cb_tree) x_list) == 1
		&& is_screen_field (x_list->value);
}

static int
contains_only_screen_fields (struct cb_list *x_list)
{
	if ((cb_tree) x_list == cb_null) {
		return 0;
	}

	for (; x_list; x_list = (struct cb_list *) x_list->chain) {
		if (!is_screen_field (x_list->value)) {
			return 0;
		}
	}

	return 1;
}

static int
contains_fields_and_screens (struct cb_list *x_list)
{
	int	field_seen = 0;
	int	screen_seen = 0;

	if ((cb_tree) x_list == cb_null) {
		return 0;
	}

	for (; x_list; x_list = (struct cb_list *) x_list->chain) {
		if (is_screen_field (x_list->value)) {
			screen_seen = 1;
		} else {
			field_seen = 1;
		}
	}

	return screen_seen && field_seen;
}

static enum cb_display_type
deduce_display_type (cb_tree x_list, cb_tree local_upon_value, cb_tree local_line_column,
		     struct cb_attr_struct * const attr_ptr)
{
	int	using_default_device_which_is_crt =
		local_upon_value == NULL && get_default_display_device () == cb_null;

	if (contains_only_screen_fields ((struct cb_list *) x_list)) {
		if (!contains_one_screen_field ((struct cb_list *) x_list)
		    || attr_ptr) {
			cb_verify_x (x_list, cb_accept_display_extensions,
				     _("non-standard DISPLAY"));
		}

		if (local_upon_value != NULL && local_upon_value != cb_null) {
			cb_error_x (x_list, _("screens may only be displayed on CRT"));
		}

		return SCREEN_DISPLAY;
	} else if (contains_fields_and_screens ((struct cb_list *) x_list)) {
		cb_error_x (x_list, _("cannot mix screens and fields in the same DISPLAY statement"));
		return MIXED_DISPLAY;
	} else if (local_line_column || attr_ptr) {
		if (local_upon_value != NULL && local_upon_value != cb_null) {
			cb_error_x (x_list, _("screen clauses may only be used for DISPLAY on CRT"));
		}

		cb_verify_x (x_list, cb_accept_display_extensions,
			     _("non-standard DISPLAY"));

		return FIELD_ON_SCREEN_DISPLAY;
	} else if (local_upon_value == cb_null || using_default_device_which_is_crt) {
		/* This is the only format permitted by the standard */
		return FIELD_ON_SCREEN_DISPLAY;
	} else if (display_type == FIELD_ON_SCREEN_DISPLAY && local_upon_value == NULL) {
		/* This is for when fields without clauses follow fields with screen clauses */
		return FIELD_ON_SCREEN_DISPLAY;
	} else {
		return DEVICE_DISPLAY;
	}
}

static void
set_display_type (cb_tree x_list, cb_tree local_upon_value,
		  cb_tree local_line_column, struct cb_attr_struct * const attr_ptr)
{
	display_type = deduce_display_type (x_list, local_upon_value, local_line_column, attr_ptr);
}

static void
error_if_different_display_type (cb_tree x_list, cb_tree local_upon_value,
				 cb_tree local_line_column, struct cb_attr_struct * const attr_ptr)
{
        const enum cb_display_type	type =
		deduce_display_type (x_list, local_upon_value, local_line_column, attr_ptr);

	/* Avoid re-displaying the same error for mixed DISPLAYs */
	if (type == display_type || display_type == MIXED_DISPLAY) {
		return;
	}

	if (type != MIXED_DISPLAY) {
		if (type == SCREEN_DISPLAY || display_type == SCREEN_DISPLAY) {
			cb_error_x (x_list, _("cannot mix screens and fields in the same DISPLAY statement"));
		} else {
			/*
			  The only other option is that there is a mix of
			  FIELD_ON_SCREEN_DISPLAY and DEVICE_DISPLAY.
			*/
			cb_error_x (x_list, _("ambiguous DISPLAY; put items to display on device in separate DISPLAY"));
		}
	}

	display_type = MIXED_DISPLAY;
}

static void
error_if_not_usage_display_or_nonnumeric_lit (cb_tree x)
{
	const int	is_numeric_literal = CB_NUMERIC_LITERAL_P (x);
	const int	is_field_with_usage_not_display =
		CB_REFERENCE_P (x) && CB_FIELD (cb_ref (x))
		&& CB_FIELD (cb_ref (x))->usage != CB_USAGE_DISPLAY;

	if (is_numeric_literal) {
		cb_error_x (x, _("%s is not an alphanumeric literal"), CB_LITERAL (x)->data);
	} else if (is_field_with_usage_not_display) {
		cb_error_x (x, _("'%s' is not USAGE DISPLAY"), cb_name (x));
	}
}


#line 1735 "parser.c" /* yacc.c:339  */

# ifndef YY_NULLPTR
#  if defined __cplusplus && 201103L <= __cplusplus
#   define YY_NULLPTR nullptr
#  else
#   define YY_NULLPTR 0
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 1
#endif

/* In a future release of Bison, this section will be replaced
   by #include "y.tab.h".  */
#ifndef YY_YY_PARSER_H_INCLUDED
# define YY_YY_PARSER_H_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token type.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    TOKEN_EOF = 0,
    ACCEPT = 258,
    ACCESS = 259,
    ADD = 260,
    ADDRESS = 261,
    ADVANCING = 262,
    AFTER = 263,
    ALL = 264,
    ALLOCATE = 265,
    ALPHABET = 266,
    ALPHABETIC = 267,
    ALPHABETIC_LOWER = 268,
    ALPHABETIC_UPPER = 269,
    ALPHANUMERIC = 270,
    ALPHANUMERIC_EDITED = 271,
    ALSO = 272,
    ALTER = 273,
    ALTERNATE = 274,
    AND = 275,
    ANY = 276,
    ARE = 277,
    AREA = 278,
    AREAS = 279,
    ARGUMENT_NUMBER = 280,
    ARGUMENT_VALUE = 281,
    AS = 282,
    ASCENDING = 283,
    ASCII = 284,
    ASSIGN = 285,
    AT = 286,
    ATTRIBUTE = 287,
    AUTO = 288,
    AUTOMATIC = 289,
    AWAY_FROM_ZERO = 290,
    BACKGROUND_COLOR = 291,
    BASED = 292,
    BEFORE = 293,
    BELL = 294,
    BINARY = 295,
    BINARY_C_LONG = 296,
    BINARY_CHAR = 297,
    BINARY_DOUBLE = 298,
    BINARY_LONG = 299,
    BINARY_SHORT = 300,
    BLANK = 301,
    BLINK = 302,
    BLOCK = 303,
    BOTTOM = 304,
    BY = 305,
    BYTE_LENGTH = 306,
    CALL = 307,
    CANCEL = 308,
    CAPACITY = 309,
    CARD_PUNCH = 310,
    CARD_READER = 311,
    CASSETTE = 312,
    CD = 313,
    CF = 314,
    CH = 315,
    CHAINING = 316,
    CHARACTER = 317,
    CHARACTERS = 318,
    CLASS = 319,
    CLASSIFICATION = 320,
    CLASS_NAME = 321,
    CLOSE = 322,
    COBOL = 323,
    CODE = 324,
    CODE_SET = 325,
    COLLATING = 326,
    COL = 327,
    COLS = 328,
    COLUMN = 329,
    COLUMNS = 330,
    COMMA = 331,
    COMMAND_LINE = 332,
    COMMA_DELIM = 333,
    COMMIT = 334,
    COMMON = 335,
    COMMUNICATION = 336,
    COMP = 337,
    COMPUTE = 338,
    COMP_1 = 339,
    COMP_2 = 340,
    COMP_3 = 341,
    COMP_4 = 342,
    COMP_5 = 343,
    COMP_6 = 344,
    COMP_X = 345,
    CONCATENATE_FUNC = 346,
    CONDITION = 347,
    CONFIGURATION = 348,
    CONSTANT = 349,
    CONTAINS = 350,
    CONTENT = 351,
    CONTINUE = 352,
    CONTROL = 353,
    CONTROLS = 354,
    CONVERSION = 355,
    CONVERTING = 356,
    COPY = 357,
    CORRESPONDING = 358,
    COUNT = 359,
    CRT = 360,
    CRT_UNDER = 361,
    CURRENCY = 362,
    CURRENT_DATE_FUNC = 363,
    CURSOR = 364,
    CYCLE = 365,
    DATA = 366,
    DATE = 367,
    DAY = 368,
    DAY_OF_WEEK = 369,
    DE = 370,
    DEBUGGING = 371,
    DECIMAL_POINT = 372,
    DECLARATIVES = 373,
    DEFAULT = 374,
    DEFAULT_FONT = 375,
    DELETE = 376,
    DELIMITED = 377,
    DELIMITER = 378,
    DEPENDING = 379,
    DESCENDING = 380,
    DESTINATION = 381,
    DESTROY = 382,
    DETAIL = 383,
    DISABLE = 384,
    DISC = 385,
    DISK = 386,
    DISPLAY = 387,
    DISPLAY_OF_FUNC = 388,
    DIVIDE = 389,
    DIVISION = 390,
    DOWN = 391,
    DUPLICATES = 392,
    DYNAMIC = 393,
    EBCDIC = 394,
    EC = 395,
    ECHO = 396,
    EGI = 397,
    EIGHTY_EIGHT = 398,
    ENABLE = 399,
    ELSE = 400,
    EMI = 401,
    END = 402,
    END_ACCEPT = 403,
    END_ADD = 404,
    END_CALL = 405,
    END_COMPUTE = 406,
    END_DELETE = 407,
    END_DISPLAY = 408,
    END_DIVIDE = 409,
    END_EVALUATE = 410,
    END_FUNCTION = 411,
    END_IF = 412,
    END_MULTIPLY = 413,
    END_PERFORM = 414,
    END_PROGRAM = 415,
    END_READ = 416,
    END_RECEIVE = 417,
    END_RETURN = 418,
    END_REWRITE = 419,
    END_SEARCH = 420,
    END_START = 421,
    END_STRING = 422,
    END_SUBTRACT = 423,
    END_UNSTRING = 424,
    END_WRITE = 425,
    ENTRY = 426,
    ENTRY_CONVENTION = 427,
    ENVIRONMENT = 428,
    ENVIRONMENT_NAME = 429,
    ENVIRONMENT_VALUE = 430,
    EOL = 431,
    EOP = 432,
    EOS = 433,
    EQUAL = 434,
    ERASE = 435,
    ERROR = 436,
    ESCAPE = 437,
    ESI = 438,
    EVALUATE = 439,
    EVENT_STATUS = 440,
    EXCEPTION = 441,
    EXCEPTION_CONDITION = 442,
    EXCLUSIVE = 443,
    EXIT = 444,
    EXPONENTIATION = 445,
    EXTEND = 446,
    EXTERNAL = 447,
    F = 448,
    FD = 449,
    FILE_CONTROL = 450,
    FILE_ID = 451,
    FILLER = 452,
    FINAL = 453,
    FIRST = 454,
    FIXED = 455,
    FIXED_FONT = 456,
    FLOAT_BINARY_128 = 457,
    FLOAT_BINARY_32 = 458,
    FLOAT_BINARY_64 = 459,
    FLOAT_DECIMAL_16 = 460,
    FLOAT_DECIMAL_34 = 461,
    FLOAT_DECIMAL_7 = 462,
    FLOAT_EXTENDED = 463,
    FLOAT_LONG = 464,
    FLOAT_SHORT = 465,
    FLOATING = 466,
    FONT = 467,
    FOOTING = 468,
    FOR = 469,
    FOREGROUND_COLOR = 470,
    FOREVER = 471,
    FORMATTED_DATE_FUNC = 472,
    FORMATTED_DATETIME_FUNC = 473,
    FORMATTED_TIME_FUNC = 474,
    FREE = 475,
    FROM = 476,
    FROM_CRT = 477,
    FULL = 478,
    FUNCTION = 479,
    FUNCTION_ID = 480,
    FUNCTION_NAME = 481,
    GENERATE = 482,
    GIVING = 483,
    GLOBAL = 484,
    GO = 485,
    GOBACK = 486,
    GRAPHICAL = 487,
    GREATER = 488,
    GREATER_OR_EQUAL = 489,
    GRID = 490,
    GROUP = 491,
    HANDLE = 492,
    HEADING = 493,
    HIGHLIGHT = 494,
    HIGH_VALUE = 495,
    ID = 496,
    IDENTIFICATION = 497,
    IF = 498,
    IGNORE = 499,
    IGNORING = 500,
    IN = 501,
    INDEPENDENT = 502,
    INDEX = 503,
    INDEXED = 504,
    INDICATE = 505,
    INITIALIZE = 506,
    INITIALIZED = 507,
    INITIATE = 508,
    INPUT = 509,
    INPUT_OUTPUT = 510,
    INSPECT = 511,
    INTERMEDIATE = 512,
    INTO = 513,
    INTRINSIC = 514,
    INVALID = 515,
    INVALID_KEY = 516,
    IS = 517,
    I_O = 518,
    I_O_CONTROL = 519,
    JUSTIFIED = 520,
    KEPT = 521,
    KEY = 522,
    KEYBOARD = 523,
    LABEL = 524,
    LARGE_FONT = 525,
    LAST = 526,
    LAYOUT_MANAGER = 527,
    LEADING = 528,
    LEFT = 529,
    LEFTLINE = 530,
    LENGTH = 531,
    LENGTH_FUNC = 532,
    LENGTH_OF = 533,
    LESS = 534,
    LESS_OR_EQUAL = 535,
    LIMIT = 536,
    LIMITS = 537,
    LINAGE = 538,
    LINAGE_COUNTER = 539,
    LINE = 540,
    LINE_COUNTER = 541,
    LINES = 542,
    LINKAGE = 543,
    LITERAL = 544,
    LM_RESIZE = 545,
    LOCALE = 546,
    LOCALE_DATE_FUNC = 547,
    LOCALE_TIME_FUNC = 548,
    LOCALE_TIME_FROM_FUNC = 549,
    LOCAL_STORAGE = 550,
    LOCK = 551,
    LOWER = 552,
    LOWER_CASE_FUNC = 553,
    LOWLIGHT = 554,
    LOW_VALUE = 555,
    MANUAL = 556,
    MAGNETIC_TAPE = 557,
    MEMORY = 558,
    MEDIUM_FONT = 559,
    MENU = 560,
    MERGE = 561,
    MESSAGE = 562,
    MINUS = 563,
    MNEMONIC_NAME = 564,
    MODE = 565,
    MODULES = 566,
    MOVE = 567,
    MULTIPLE = 568,
    MULTIPLY = 569,
    NAME = 570,
    NATIONAL = 571,
    NATIONAL_EDITED = 572,
    NATIONAL_OF_FUNC = 573,
    NATIVE = 574,
    NEAREST_AWAY_FROM_ZERO = 575,
    NEAREST_EVEN = 576,
    NEAREST_TOWARD_ZERO = 577,
    NEGATIVE = 578,
    NESTED = 579,
    NEXT = 580,
    NEXT_PAGE = 581,
    NO = 582,
    NO_DATA = 583,
    NO_ECHO = 584,
    NORMAL = 585,
    NOT = 586,
    NOTHING = 587,
    NOT_END = 588,
    NOT_EOP = 589,
    NOT_ESCAPE = 590,
    NOT_EQUAL = 591,
    NOT_EXCEPTION = 592,
    NOT_INVALID_KEY = 593,
    NOT_OVERFLOW = 594,
    NOT_SIZE_ERROR = 595,
    NO_ADVANCING = 596,
    NUMBER = 597,
    NUMBERS = 598,
    NUMERIC = 599,
    NUMERIC_EDITED = 600,
    NUMVALC_FUNC = 601,
    OBJECT_COMPUTER = 602,
    OCCURS = 603,
    OF = 604,
    OFF = 605,
    OMITTED = 606,
    ON = 607,
    ONLY = 608,
    OPEN = 609,
    OPTIONAL = 610,
    OPTIONS = 611,
    OR = 612,
    ORDER = 613,
    ORGANIZATION = 614,
    OTHER = 615,
    OUTPUT = 616,
    OVERLINE = 617,
    PACKED_DECIMAL = 618,
    PADDING = 619,
    PAGE = 620,
    PAGE_COUNTER = 621,
    PARAGRAPH = 622,
    PERFORM = 623,
    PH = 624,
    PF = 625,
    PICTURE = 626,
    PICTURE_SYMBOL = 627,
    PLUS = 628,
    POINTER = 629,
    POP_UP = 630,
    POSITION = 631,
    POSITIVE = 632,
    PRESENT = 633,
    PREVIOUS = 634,
    PRINT = 635,
    PRINTER = 636,
    PRINTER_1 = 637,
    PRINTING = 638,
    PRIORITY = 639,
    PROCEDURE = 640,
    PROCEDURES = 641,
    PROCEED = 642,
    PROGRAM = 643,
    PROGRAM_ID = 644,
    PROGRAM_NAME = 645,
    PROGRAM_POINTER = 646,
    PROHIBITED = 647,
    PROMPT = 648,
    PROTECTED = 649,
    PURGE = 650,
    QUEUE = 651,
    QUOTE = 652,
    RANDOM = 653,
    RD = 654,
    READ = 655,
    READY_TRACE = 656,
    RECEIVE = 657,
    RECORD = 658,
    RECORDING = 659,
    RECORDS = 660,
    RECURSIVE = 661,
    REDEFINES = 662,
    REEL = 663,
    REFERENCE = 664,
    REFERENCES = 665,
    RELATIVE = 666,
    RELEASE = 667,
    REMAINDER = 668,
    REMOVAL = 669,
    RENAMES = 670,
    REPLACE = 671,
    REPLACING = 672,
    REPORT = 673,
    REPORTING = 674,
    REPORTS = 675,
    REPOSITORY = 676,
    REQUIRED = 677,
    RESERVE = 678,
    RESET = 679,
    RESET_TRACE = 680,
    RETRY = 681,
    RETURN = 682,
    RETURNING = 683,
    REVERSE = 684,
    REVERSE_FUNC = 685,
    REVERSE_VIDEO = 686,
    REVERSED = 687,
    REWIND = 688,
    REWRITE = 689,
    RF = 690,
    RH = 691,
    RIGHT = 692,
    ROLLBACK = 693,
    ROUNDED = 694,
    ROUNDING = 695,
    RUN = 696,
    S = 697,
    SAME = 698,
    SCREEN = 699,
    SCREEN_CONTROL = 700,
    SCROLL = 701,
    SD = 702,
    SEARCH = 703,
    SECONDS = 704,
    SECTION = 705,
    SECURE = 706,
    SEGMENT = 707,
    SEGMENT_LIMIT = 708,
    SELECT = 709,
    SEMI_COLON = 710,
    SEND = 711,
    SENTENCE = 712,
    SEPARATE = 713,
    SEQUENCE = 714,
    SEQUENTIAL = 715,
    SET = 716,
    SEVENTY_EIGHT = 717,
    SHARING = 718,
    SIGN = 719,
    SIGNED = 720,
    SIGNED_INT = 721,
    SIGNED_LONG = 722,
    SIGNED_SHORT = 723,
    SIXTY_SIX = 724,
    SIZE = 725,
    SIZE_ERROR = 726,
    SMALL_FONT = 727,
    SORT = 728,
    SORT_MERGE = 729,
    SOURCE = 730,
    SOURCE_COMPUTER = 731,
    SPACE = 732,
    SPECIAL_NAMES = 733,
    STANDARD = 734,
    STANDARD_1 = 735,
    STANDARD_2 = 736,
    START = 737,
    STATIC = 738,
    STATUS = 739,
    STDCALL = 740,
    STEP = 741,
    STOP = 742,
    STRING = 743,
    SUB_QUEUE_1 = 744,
    SUB_QUEUE_2 = 745,
    SUB_QUEUE_3 = 746,
    SUBSTITUTE_FUNC = 747,
    SUBSTITUTE_CASE_FUNC = 748,
    SUBTRACT = 749,
    SUBWINDOW = 750,
    SUM = 751,
    SUPPRESS = 752,
    SYMBOLIC = 753,
    SYNCHRONIZED = 754,
    SYSTEM_DEFAULT = 755,
    SYSTEM_OFFSET = 756,
    TAB = 757,
    TABLE = 758,
    TALLYING = 759,
    TAPE = 760,
    TERMINAL = 761,
    TERMINATE = 762,
    TEXT = 763,
    TEST = 764,
    THAN = 765,
    THEN = 766,
    THREAD = 767,
    THREADS = 768,
    THRU = 769,
    TIME = 770,
    TIME_OUT = 771,
    TIMES = 772,
    TO = 773,
    TOK_AMPER = 774,
    TOK_CLOSE_PAREN = 775,
    TOK_COLON = 776,
    TOK_DIV = 777,
    TOK_DOT = 778,
    TOK_EQUAL = 779,
    TOK_EXTERN = 780,
    TOK_FALSE = 781,
    TOK_FILE = 782,
    TOK_GREATER = 783,
    TOK_INITIAL = 784,
    TOK_LESS = 785,
    TOK_MINUS = 786,
    TOK_MUL = 787,
    TOK_NULL = 788,
    TOK_OVERFLOW = 789,
    TOK_OPEN_PAREN = 790,
    TOK_PLUS = 791,
    TOK_TRUE = 792,
    TOP = 793,
    TOWARD_GREATER = 794,
    TOWARD_LESSER = 795,
    TRADITIONAL_FONT = 796,
    TRAILING = 797,
    TRANSFORM = 798,
    TRIM_FUNC = 799,
    TRUNCATION = 800,
    TYPE = 801,
    U = 802,
    UNBOUNDED = 803,
    UNDERLINE = 804,
    UNIT = 805,
    UNLOCK = 806,
    UNSIGNED = 807,
    UNSIGNED_INT = 808,
    UNSIGNED_LONG = 809,
    UNSIGNED_SHORT = 810,
    UNSTRING = 811,
    UNTIL = 812,
    UP = 813,
    UPDATE = 814,
    UPON = 815,
    UPON_ARGUMENT_NUMBER = 816,
    UPON_COMMAND_LINE = 817,
    UPON_ENVIRONMENT_NAME = 818,
    UPON_ENVIRONMENT_VALUE = 819,
    UPPER = 820,
    UPPER_CASE_FUNC = 821,
    USAGE = 822,
    USE = 823,
    USER = 824,
    USER_DEFAULT = 825,
    USER_FUNCTION_NAME = 826,
    USING = 827,
    V = 828,
    VALUE = 829,
    VARIABLE = 830,
    VARIANT = 831,
    VARYING = 832,
    WAIT = 833,
    WHEN = 834,
    WHEN_COMPILED_FUNC = 835,
    WINDOW = 836,
    WITH = 837,
    WORD = 838,
    WORDS = 839,
    WORKING_STORAGE = 840,
    WRITE = 841,
    YYYYDDD = 842,
    YYYYMMDD = 843,
    ZERO = 844,
    SHIFT_PREFER = 845
  };
#endif
/* Tokens.  */
#define TOKEN_EOF 0
#define ACCEPT 258
#define ACCESS 259
#define ADD 260
#define ADDRESS 261
#define ADVANCING 262
#define AFTER 263
#define ALL 264
#define ALLOCATE 265
#define ALPHABET 266
#define ALPHABETIC 267
#define ALPHABETIC_LOWER 268
#define ALPHABETIC_UPPER 269
#define ALPHANUMERIC 270
#define ALPHANUMERIC_EDITED 271
#define ALSO 272
#define ALTER 273
#define ALTERNATE 274
#define AND 275
#define ANY 276
#define ARE 277
#define AREA 278
#define AREAS 279
#define ARGUMENT_NUMBER 280
#define ARGUMENT_VALUE 281
#define AS 282
#define ASCENDING 283
#define ASCII 284
#define ASSIGN 285
#define AT 286
#define ATTRIBUTE 287
#define AUTO 288
#define AUTOMATIC 289
#define AWAY_FROM_ZERO 290
#define BACKGROUND_COLOR 291
#define BASED 292
#define BEFORE 293
#define BELL 294
#define BINARY 295
#define BINARY_C_LONG 296
#define BINARY_CHAR 297
#define BINARY_DOUBLE 298
#define BINARY_LONG 299
#define BINARY_SHORT 300
#define BLANK 301
#define BLINK 302
#define BLOCK 303
#define BOTTOM 304
#define BY 305
#define BYTE_LENGTH 306
#define CALL 307
#define CANCEL 308
#define CAPACITY 309
#define CARD_PUNCH 310
#define CARD_READER 311
#define CASSETTE 312
#define CD 313
#define CF 314
#define CH 315
#define CHAINING 316
#define CHARACTER 317
#define CHARACTERS 318
#define CLASS 319
#define CLASSIFICATION 320
#define CLASS_NAME 321
#define CLOSE 322
#define COBOL 323
#define CODE 324
#define CODE_SET 325
#define COLLATING 326
#define COL 327
#define COLS 328
#define COLUMN 329
#define COLUMNS 330
#define COMMA 331
#define COMMAND_LINE 332
#define COMMA_DELIM 333
#define COMMIT 334
#define COMMON 335
#define COMMUNICATION 336
#define COMP 337
#define COMPUTE 338
#define COMP_1 339
#define COMP_2 340
#define COMP_3 341
#define COMP_4 342
#define COMP_5 343
#define COMP_6 344
#define COMP_X 345
#define CONCATENATE_FUNC 346
#define CONDITION 347
#define CONFIGURATION 348
#define CONSTANT 349
#define CONTAINS 350
#define CONTENT 351
#define CONTINUE 352
#define CONTROL 353
#define CONTROLS 354
#define CONVERSION 355
#define CONVERTING 356
#define COPY 357
#define CORRESPONDING 358
#define COUNT 359
#define CRT 360
#define CRT_UNDER 361
#define CURRENCY 362
#define CURRENT_DATE_FUNC 363
#define CURSOR 364
#define CYCLE 365
#define DATA 366
#define DATE 367
#define DAY 368
#define DAY_OF_WEEK 369
#define DE 370
#define DEBUGGING 371
#define DECIMAL_POINT 372
#define DECLARATIVES 373
#define DEFAULT 374
#define DEFAULT_FONT 375
#define DELETE 376
#define DELIMITED 377
#define DELIMITER 378
#define DEPENDING 379
#define DESCENDING 380
#define DESTINATION 381
#define DESTROY 382
#define DETAIL 383
#define DISABLE 384
#define DISC 385
#define DISK 386
#define DISPLAY 387
#define DISPLAY_OF_FUNC 388
#define DIVIDE 389
#define DIVISION 390
#define DOWN 391
#define DUPLICATES 392
#define DYNAMIC 393
#define EBCDIC 394
#define EC 395
#define ECHO 396
#define EGI 397
#define EIGHTY_EIGHT 398
#define ENABLE 399
#define ELSE 400
#define EMI 401
#define END 402
#define END_ACCEPT 403
#define END_ADD 404
#define END_CALL 405
#define END_COMPUTE 406
#define END_DELETE 407
#define END_DISPLAY 408
#define END_DIVIDE 409
#define END_EVALUATE 410
#define END_FUNCTION 411
#define END_IF 412
#define END_MULTIPLY 413
#define END_PERFORM 414
#define END_PROGRAM 415
#define END_READ 416
#define END_RECEIVE 417
#define END_RETURN 418
#define END_REWRITE 419
#define END_SEARCH 420
#define END_START 421
#define END_STRING 422
#define END_SUBTRACT 423
#define END_UNSTRING 424
#define END_WRITE 425
#define ENTRY 426
#define ENTRY_CONVENTION 427
#define ENVIRONMENT 428
#define ENVIRONMENT_NAME 429
#define ENVIRONMENT_VALUE 430
#define EOL 431
#define EOP 432
#define EOS 433
#define EQUAL 434
#define ERASE 435
#define ERROR 436
#define ESCAPE 437
#define ESI 438
#define EVALUATE 439
#define EVENT_STATUS 440
#define EXCEPTION 441
#define EXCEPTION_CONDITION 442
#define EXCLUSIVE 443
#define EXIT 444
#define EXPONENTIATION 445
#define EXTEND 446
#define EXTERNAL 447
#define F 448
#define FD 449
#define FILE_CONTROL 450
#define FILE_ID 451
#define FILLER 452
#define FINAL 453
#define FIRST 454
#define FIXED 455
#define FIXED_FONT 456
#define FLOAT_BINARY_128 457
#define FLOAT_BINARY_32 458
#define FLOAT_BINARY_64 459
#define FLOAT_DECIMAL_16 460
#define FLOAT_DECIMAL_34 461
#define FLOAT_DECIMAL_7 462
#define FLOAT_EXTENDED 463
#define FLOAT_LONG 464
#define FLOAT_SHORT 465
#define FLOATING 466
#define FONT 467
#define FOOTING 468
#define FOR 469
#define FOREGROUND_COLOR 470
#define FOREVER 471
#define FORMATTED_DATE_FUNC 472
#define FORMATTED_DATETIME_FUNC 473
#define FORMATTED_TIME_FUNC 474
#define FREE 475
#define FROM 476
#define FROM_CRT 477
#define FULL 478
#define FUNCTION 479
#define FUNCTION_ID 480
#define FUNCTION_NAME 481
#define GENERATE 482
#define GIVING 483
#define GLOBAL 484
#define GO 485
#define GOBACK 486
#define GRAPHICAL 487
#define GREATER 488
#define GREATER_OR_EQUAL 489
#define GRID 490
#define GROUP 491
#define HANDLE 492
#define HEADING 493
#define HIGHLIGHT 494
#define HIGH_VALUE 495
#define ID 496
#define IDENTIFICATION 497
#define IF 498
#define IGNORE 499
#define IGNORING 500
#define IN 501
#define INDEPENDENT 502
#define INDEX 503
#define INDEXED 504
#define INDICATE 505
#define INITIALIZE 506
#define INITIALIZED 507
#define INITIATE 508
#define INPUT 509
#define INPUT_OUTPUT 510
#define INSPECT 511
#define INTERMEDIATE 512
#define INTO 513
#define INTRINSIC 514
#define INVALID 515
#define INVALID_KEY 516
#define IS 517
#define I_O 518
#define I_O_CONTROL 519
#define JUSTIFIED 520
#define KEPT 521
#define KEY 522
#define KEYBOARD 523
#define LABEL 524
#define LARGE_FONT 525
#define LAST 526
#define LAYOUT_MANAGER 527
#define LEADING 528
#define LEFT 529
#define LEFTLINE 530
#define LENGTH 531
#define LENGTH_FUNC 532
#define LENGTH_OF 533
#define LESS 534
#define LESS_OR_EQUAL 535
#define LIMIT 536
#define LIMITS 537
#define LINAGE 538
#define LINAGE_COUNTER 539
#define LINE 540
#define LINE_COUNTER 541
#define LINES 542
#define LINKAGE 543
#define LITERAL 544
#define LM_RESIZE 545
#define LOCALE 546
#define LOCALE_DATE_FUNC 547
#define LOCALE_TIME_FUNC 548
#define LOCALE_TIME_FROM_FUNC 549
#define LOCAL_STORAGE 550
#define LOCK 551
#define LOWER 552
#define LOWER_CASE_FUNC 553
#define LOWLIGHT 554
#define LOW_VALUE 555
#define MANUAL 556
#define MAGNETIC_TAPE 557
#define MEMORY 558
#define MEDIUM_FONT 559
#define MENU 560
#define MERGE 561
#define MESSAGE 562
#define MINUS 563
#define MNEMONIC_NAME 564
#define MODE 565
#define MODULES 566
#define MOVE 567
#define MULTIPLE 568
#define MULTIPLY 569
#define NAME 570
#define NATIONAL 571
#define NATIONAL_EDITED 572
#define NATIONAL_OF_FUNC 573
#define NATIVE 574
#define NEAREST_AWAY_FROM_ZERO 575
#define NEAREST_EVEN 576
#define NEAREST_TOWARD_ZERO 577
#define NEGATIVE 578
#define NESTED 579
#define NEXT 580
#define NEXT_PAGE 581
#define NO 582
#define NO_DATA 583
#define NO_ECHO 584
#define NORMAL 585
#define NOT 586
#define NOTHING 587
#define NOT_END 588
#define NOT_EOP 589
#define NOT_ESCAPE 590
#define NOT_EQUAL 591
#define NOT_EXCEPTION 592
#define NOT_INVALID_KEY 593
#define NOT_OVERFLOW 594
#define NOT_SIZE_ERROR 595
#define NO_ADVANCING 596
#define NUMBER 597
#define NUMBERS 598
#define NUMERIC 599
#define NUMERIC_EDITED 600
#define NUMVALC_FUNC 601
#define OBJECT_COMPUTER 602
#define OCCURS 603
#define OF 604
#define OFF 605
#define OMITTED 606
#define ON 607
#define ONLY 608
#define OPEN 609
#define OPTIONAL 610
#define OPTIONS 611
#define OR 612
#define ORDER 613
#define ORGANIZATION 614
#define OTHER 615
#define OUTPUT 616
#define OVERLINE 617
#define PACKED_DECIMAL 618
#define PADDING 619
#define PAGE 620
#define PAGE_COUNTER 621
#define PARAGRAPH 622
#define PERFORM 623
#define PH 624
#define PF 625
#define PICTURE 626
#define PICTURE_SYMBOL 627
#define PLUS 628
#define POINTER 629
#define POP_UP 630
#define POSITION 631
#define POSITIVE 632
#define PRESENT 633
#define PREVIOUS 634
#define PRINT 635
#define PRINTER 636
#define PRINTER_1 637
#define PRINTING 638
#define PRIORITY 639
#define PROCEDURE 640
#define PROCEDURES 641
#define PROCEED 642
#define PROGRAM 643
#define PROGRAM_ID 644
#define PROGRAM_NAME 645
#define PROGRAM_POINTER 646
#define PROHIBITED 647
#define PROMPT 648
#define PROTECTED 649
#define PURGE 650
#define QUEUE 651
#define QUOTE 652
#define RANDOM 653
#define RD 654
#define READ 655
#define READY_TRACE 656
#define RECEIVE 657
#define RECORD 658
#define RECORDING 659
#define RECORDS 660
#define RECURSIVE 661
#define REDEFINES 662
#define REEL 663
#define REFERENCE 664
#define REFERENCES 665
#define RELATIVE 666
#define RELEASE 667
#define REMAINDER 668
#define REMOVAL 669
#define RENAMES 670
#define REPLACE 671
#define REPLACING 672
#define REPORT 673
#define REPORTING 674
#define REPORTS 675
#define REPOSITORY 676
#define REQUIRED 677
#define RESERVE 678
#define RESET 679
#define RESET_TRACE 680
#define RETRY 681
#define RETURN 682
#define RETURNING 683
#define REVERSE 684
#define REVERSE_FUNC 685
#define REVERSE_VIDEO 686
#define REVERSED 687
#define REWIND 688
#define REWRITE 689
#define RF 690
#define RH 691
#define RIGHT 692
#define ROLLBACK 693
#define ROUNDED 694
#define ROUNDING 695
#define RUN 696
#define S 697
#define SAME 698
#define SCREEN 699
#define SCREEN_CONTROL 700
#define SCROLL 701
#define SD 702
#define SEARCH 703
#define SECONDS 704
#define SECTION 705
#define SECURE 706
#define SEGMENT 707
#define SEGMENT_LIMIT 708
#define SELECT 709
#define SEMI_COLON 710
#define SEND 711
#define SENTENCE 712
#define SEPARATE 713
#define SEQUENCE 714
#define SEQUENTIAL 715
#define SET 716
#define SEVENTY_EIGHT 717
#define SHARING 718
#define SIGN 719
#define SIGNED 720
#define SIGNED_INT 721
#define SIGNED_LONG 722
#define SIGNED_SHORT 723
#define SIXTY_SIX 724
#define SIZE 725
#define SIZE_ERROR 726
#define SMALL_FONT 727
#define SORT 728
#define SORT_MERGE 729
#define SOURCE 730
#define SOURCE_COMPUTER 731
#define SPACE 732
#define SPECIAL_NAMES 733
#define STANDARD 734
#define STANDARD_1 735
#define STANDARD_2 736
#define START 737
#define STATIC 738
#define STATUS 739
#define STDCALL 740
#define STEP 741
#define STOP 742
#define STRING 743
#define SUB_QUEUE_1 744
#define SUB_QUEUE_2 745
#define SUB_QUEUE_3 746
#define SUBSTITUTE_FUNC 747
#define SUBSTITUTE_CASE_FUNC 748
#define SUBTRACT 749
#define SUBWINDOW 750
#define SUM 751
#define SUPPRESS 752
#define SYMBOLIC 753
#define SYNCHRONIZED 754
#define SYSTEM_DEFAULT 755
#define SYSTEM_OFFSET 756
#define TAB 757
#define TABLE 758
#define TALLYING 759
#define TAPE 760
#define TERMINAL 761
#define TERMINATE 762
#define TEXT 763
#define TEST 764
#define THAN 765
#define THEN 766
#define THREAD 767
#define THREADS 768
#define THRU 769
#define TIME 770
#define TIME_OUT 771
#define TIMES 772
#define TO 773
#define TOK_AMPER 774
#define TOK_CLOSE_PAREN 775
#define TOK_COLON 776
#define TOK_DIV 777
#define TOK_DOT 778
#define TOK_EQUAL 779
#define TOK_EXTERN 780
#define TOK_FALSE 781
#define TOK_FILE 782
#define TOK_GREATER 783
#define TOK_INITIAL 784
#define TOK_LESS 785
#define TOK_MINUS 786
#define TOK_MUL 787
#define TOK_NULL 788
#define TOK_OVERFLOW 789
#define TOK_OPEN_PAREN 790
#define TOK_PLUS 791
#define TOK_TRUE 792
#define TOP 793
#define TOWARD_GREATER 794
#define TOWARD_LESSER 795
#define TRADITIONAL_FONT 796
#define TRAILING 797
#define TRANSFORM 798
#define TRIM_FUNC 799
#define TRUNCATION 800
#define TYPE 801
#define U 802
#define UNBOUNDED 803
#define UNDERLINE 804
#define UNIT 805
#define UNLOCK 806
#define UNSIGNED 807
#define UNSIGNED_INT 808
#define UNSIGNED_LONG 809
#define UNSIGNED_SHORT 810
#define UNSTRING 811
#define UNTIL 812
#define UP 813
#define UPDATE 814
#define UPON 815
#define UPON_ARGUMENT_NUMBER 816
#define UPON_COMMAND_LINE 817
#define UPON_ENVIRONMENT_NAME 818
#define UPON_ENVIRONMENT_VALUE 819
#define UPPER 820
#define UPPER_CASE_FUNC 821
#define USAGE 822
#define USE 823
#define USER 824
#define USER_DEFAULT 825
#define USER_FUNCTION_NAME 826
#define USING 827
#define V 828
#define VALUE 829
#define VARIABLE 830
#define VARIANT 831
#define VARYING 832
#define WAIT 833
#define WHEN 834
#define WHEN_COMPILED_FUNC 835
#define WINDOW 836
#define WITH 837
#define WORD 838
#define WORDS 839
#define WORKING_STORAGE 840
#define WRITE 841
#define YYYYDDD 842
#define YYYYMMDD 843
#define ZERO 844
#define SHIFT_PREFER 845

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef int YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif


extern YYSTYPE yylval;

int yyparse (void);

#endif /* !YY_YY_PARSER_H_INCLUDED  */

/* Copy the second part of user declarations.  */

#line 2968 "parser.c" /* yacc.c:358  */

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef YY_ATTRIBUTE
# if (defined __GNUC__                                               \
      && (2 < __GNUC__ || (__GNUC__ == 2 && 96 <= __GNUC_MINOR__)))  \
     || defined __SUNPRO_C && 0x5110 <= __SUNPRO_C
#  define YY_ATTRIBUTE(Spec) __attribute__(Spec)
# else
#  define YY_ATTRIBUTE(Spec) /* empty */
# endif
#endif

#ifndef YY_ATTRIBUTE_PURE
# define YY_ATTRIBUTE_PURE   YY_ATTRIBUTE ((__pure__))
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# define YY_ATTRIBUTE_UNUSED YY_ATTRIBUTE ((__unused__))
#endif

#if !defined _Noreturn \
     && (!defined __STDC_VERSION__ || __STDC_VERSION__ < 201112)
# if defined _MSC_VER && 1200 <= _MSC_VER
#  define _Noreturn __declspec (noreturn)
# else
#  define _Noreturn YY_ATTRIBUTE ((__noreturn__))
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN \
    _Pragma ("GCC diagnostic push") \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")\
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif


#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYSIZE_T yynewbytes;                                            \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / sizeof (*yyptr);                          \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, (Count) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYSIZE_T yyi;                         \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   10676

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  591
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  1014
/* YYNRULES -- Number of rules.  */
#define YYNRULES  2333
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  3370

/* YYTRANSLATE[YYX] -- Symbol number corresponding to YYX as returned
   by yylex, with out-of-bounds checking.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   845

#define YYTRANSLATE(YYX)                                                \
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, without out-of-bounds checking.  */
static const yytype_uint16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  2400,  2400,  2400,  2432,  2433,  2437,  2437,  2446,  2447,
    2451,  2452,  2456,  2456,  2479,  2491,  2500,  2503,  2507,  2508,
    2512,  2520,  2529,  2537,  2538,  2547,  2547,  2552,  2556,  2551,
    2572,  2571,  2587,  2598,  2605,  2606,  2613,  2614,  2617,  2618,
    2622,  2631,  2640,  2641,  2648,  2649,  2653,  2657,  2663,  2665,
    2673,  2681,  2684,  2694,  2696,  2705,  2709,  2713,  2719,  2721,
    2728,  2732,  2736,  2740,  2749,  2754,  2755,  2764,  2768,  2769,
    2770,  2783,  2784,  2785,  2786,  2787,  2791,  2792,  2793,  2794,
    2795,  2798,  2799,  2809,  2810,  2814,  2815,  2816,  2817,  2829,
    2828,  2837,  2838,  2841,  2842,  2855,  2854,  2866,  2867,  2868,
    2869,  2873,  2874,  2878,  2879,  2880,  2881,  2885,  2893,  2900,
    2916,  2927,  2931,  2935,  2939,  2946,  2947,  2952,  2953,  2958,
    2957,  2968,  2969,  2970,  2977,  2978,  2982,  2986,  2992,  2993,
    3000,  3007,  3012,  3022,  3023,  3027,  3028,  3032,  3044,  3046,
    3050,  3051,  3055,  3056,  3060,  3061,  3062,  3063,  3064,  3065,
    3066,  3067,  3068,  3069,  3070,  3071,  3079,  3078,  3107,  3118,
    3137,  3145,  3148,  3149,  3153,  3160,  3175,  3196,  3195,  3219,
    3225,  3231,  3237,  3243,  3249,  3259,  3263,  3270,  3274,  3279,
    3278,  3289,  3293,  3300,  3301,  3302,  3303,  3304,  3305,  3309,
    3310,  3317,  3332,  3335,  3342,  3350,  3354,  3365,  3385,  3393,
    3404,  3405,  3411,  3432,  3433,  3437,  3441,  3462,  3485,  3560,
    3563,  3572,  3591,  3607,  3625,  3643,  3660,  3677,  3687,  3688,
    3695,  3696,  3704,  3705,  3715,  3716,  3721,  3720,  3748,  3749,
    3755,  3756,  3760,  3761,  3762,  3763,  3764,  3765,  3766,  3767,
    3768,  3769,  3770,  3771,  3772,  3779,  3785,  3795,  3806,  3819,
    3832,  3865,  3866,  3867,  3872,  3873,  3874,  3875,  3879,  3880,
    3881,  3882,  3883,  3884,  3885,  3888,  3889,  3895,  3896,  3900,
    3904,  3905,  3910,  3913,  3914,  3921,  3929,  3930,  3931,  3938,
    3960,  3962,  3967,  3977,  3985,  4000,  4007,  4009,  4010,  4016,
    4016,  4023,  4028,  4033,  4040,  4041,  4042,  4046,  4057,  4058,
    4062,  4067,  4072,  4077,  4088,  4099,  4109,  4117,  4118,  4119,
    4125,  4136,  4143,  4144,  4150,  4158,  4159,  4160,  4166,  4167,
    4168,  4175,  4176,  4180,  4181,  4187,  4215,  4216,  4217,  4218,
    4225,  4224,  4240,  4241,  4245,  4248,  4249,  4259,  4256,  4273,
    4274,  4282,  4283,  4291,  4292,  4296,  4317,  4316,  4333,  4340,
    4344,  4350,  4351,  4355,  4365,  4380,  4381,  4382,  4383,  4384,
    4385,  4386,  4387,  4388,  4395,  4402,  4402,  4402,  4408,  4432,
    4471,  4511,  4512,  4519,  4520,  4524,  4525,  4532,  4543,  4548,
    4559,  4560,  4564,  4565,  4571,  4582,  4600,  4601,  4605,  4606,
    4607,  4611,  4618,  4625,  4634,  4643,  4644,  4645,  4646,  4647,
    4656,  4657,  4663,  4700,  4701,  4714,  4729,  4730,  4734,  4744,
    4757,  4759,  4758,  4773,  4774,  4778,  4795,  4794,  4815,  4816,
    4820,  4821,  4822,  4825,  4827,  4828,  4832,  4833,  4837,  4838,
    4839,  4840,  4841,  4842,  4843,  4844,  4845,  4846,  4847,  4851,
    4855,  4857,  4861,  4862,  4866,  4867,  4868,  4869,  4870,  4871,
    4872,  4875,  4877,  4878,  4882,  4883,  4887,  4888,  4889,  4890,
    4891,  4892,  4896,  4901,  4903,  4902,  4918,  4922,  4922,  4939,
    4940,  4944,  4945,  4946,  4948,  4947,  4962,  4975,  4981,  4983,
    4987,  4994,  4998,  5009,  5012,  5024,  5025,  5026,  5028,  5032,
    5036,  5040,  5044,  5048,  5052,  5056,  5060,  5064,  5068,  5072,
    5076,  5080,  5091,  5092,  5096,  5097,  5101,  5102,  5103,  5107,
    5108,  5112,  5137,  5140,  5148,  5147,  5160,  5188,  5187,  5202,
    5206,  5213,  5217,  5221,  5228,  5229,  5233,  5234,  5235,  5236,
    5237,  5238,  5239,  5240,  5241,  5242,  5247,  5251,  5260,  5261,
    5262,  5263,  5264,  5265,  5266,  5267,  5268,  5269,  5270,  5271,
    5272,  5279,  5303,  5331,  5334,  5342,  5343,  5347,  5372,  5383,
    5384,  5388,  5392,  5396,  5400,  5404,  5408,  5412,  5416,  5420,
    5424,  5428,  5432,  5436,  5441,  5446,  5450,  5454,  5458,  5463,
    5467,  5472,  5476,  5481,  5485,  5489,  5497,  5501,  5505,  5513,
    5517,  5521,  5525,  5529,  5533,  5537,  5541,  5545,  5553,  5561,
    5565,  5569,  5573,  5577,  5581,  5589,  5590,  5594,  5595,  5598,
    5600,  5601,  5602,  5603,  5604,  5605,  5608,  5610,  5616,  5623,
    5636,  5645,  5646,  5655,  5662,  5674,  5692,  5693,  5697,  5698,
    5702,  5703,  5706,  5707,  5712,  5713,  5720,  5721,  5727,  5729,
    5731,  5730,  5739,  5740,  5744,  5768,  5769,  5773,  5790,  5791,
    5794,  5796,  5799,  5806,  5807,  5812,  5823,  5834,  5845,  5856,
    5885,  5884,  5893,  5894,  5898,  5899,  5902,  5904,  5916,  5925,
    5939,  5941,  5940,  5960,  5962,  5961,  5977,  5979,  5978,  5987,
    5988,  5995,  5994,  6007,  6008,  6009,  6016,  6021,  6025,  6026,
    6032,  6039,  6045,  6082,  6086,  6091,  6097,  6098,  6103,  6104,
    6105,  6106,  6107,  6111,  6118,  6125,  6132,  6139,  6145,  6146,
    6151,  6150,  6157,  6158,  6162,  6163,  6164,  6165,  6166,  6167,
    6168,  6169,  6170,  6171,  6172,  6173,  6174,  6175,  6176,  6177,
    6181,  6188,  6189,  6190,  6191,  6192,  6193,  6194,  6197,  6198,
    6199,  6202,  6203,  6207,  6214,  6220,  6221,  6225,  6226,  6230,
    6237,  6241,  6248,  6249,  6253,  6260,  6261,  6265,  6266,  6270,
    6271,  6272,  6276,  6277,  6281,  6282,  6286,  6293,  6300,  6308,
    6310,  6309,  6330,  6331,  6335,  6336,  6340,  6342,  6341,  6401,
    6419,  6421,  6425,  6430,  6435,  6439,  6443,  6448,  6453,  6458,
    6463,  6467,  6471,  6476,  6481,  6486,  6491,  6496,  6501,  6510,
    6514,  6518,  6523,  6527,  6531,  6535,  6539,  6544,  6549,  6550,
    6551,  6552,  6553,  6554,  6555,  6556,  6557,  6566,  6571,  6582,
    6583,  6587,  6588,  6592,  6593,  6597,  6598,  6602,  6612,  6615,
    6619,  6626,  6636,  6639,  6643,  6650,  6661,  6671,  6681,  6699,
    6680,  6726,  6726,  6764,  6768,  6767,  6781,  6780,  6800,  6801,
    6806,  6828,  6830,  6834,  6845,  6847,  6855,  6863,  6871,  6877,
    6881,  6915,  6918,  6931,  6936,  6946,  6974,  6976,  6975,  7012,
    7013,  7017,  7018,  7019,  7037,  7038,  7050,  7049,  7097,  7098,
    7102,  7151,  7171,  7174,  7204,  7209,  7203,  7222,  7222,  7258,
    7265,  7266,  7267,  7268,  7269,  7270,  7271,  7272,  7273,  7274,
    7275,  7276,  7277,  7278,  7279,  7280,  7281,  7282,  7283,  7284,
    7285,  7286,  7287,  7288,  7289,  7290,  7291,  7292,  7293,  7294,
    7295,  7296,  7297,  7298,  7299,  7300,  7301,  7302,  7303,  7304,
    7305,  7306,  7307,  7308,  7309,  7310,  7311,  7312,  7313,  7314,
    7315,  7316,  7317,  7318,  7319,  7320,  7335,  7347,  7346,  7357,
    7356,  7390,  7394,  7398,  7403,  7408,  7413,  7418,  7422,  7426,
    7430,  7434,  7439,  7443,  7447,  7451,  7455,  7459,  7463,  7467,
    7474,  7475,  7481,  7483,  7487,  7488,  7492,  7493,  7497,  7501,
    7502,  7511,  7512,  7516,  7532,  7548,  7561,  7565,  7566,  7570,
    7577,  7583,  7589,  7594,  7599,  7604,  7609,  7615,  7620,  7626,
    7632,  7643,  7648,  7653,  7658,  7663,  7668,  7674,  7679,  7684,
    7689,  7695,  7701,  7707,  7712,  7717,  7724,  7731,  7740,  7741,
    7742,  7746,  7747,  7748,  7752,  7753,  7757,  7761,  7779,  7778,
    7787,  7791,  7795,  7799,  7806,  7807,  7814,  7818,  7829,  7828,
    7838,  7842,  7854,  7855,  7863,  7862,  7871,  7872,  7876,  7882,
    7882,  7889,  7888,  7902,  7901,  7942,  7946,  7955,  7960,  7965,
    7985,  7991,  8011,  8015,  8025,  8029,  8034,  8038,  8037,  8054,
    8055,  8060,  8068,  8092,  8094,  8098,  8107,  8120,  8123,  8127,
    8131,  8136,  8159,  8160,  8164,  8165,  8169,  8173,  8177,  8188,
    8192,  8199,  8203,  8211,  8215,  8222,  8229,  8233,  8244,  8243,
    8255,  8259,  8266,  8267,  8277,  8276,  8284,  8285,  8289,  8294,
    8302,  8303,  8304,  8305,  8306,  8311,  8310,  8326,  8327,  8335,
    8334,  8343,  8350,  8354,  8364,  8375,  8393,  8392,  8401,  8408,
    8419,  8418,  8427,  8431,  8435,  8440,  8448,  8452,  8463,  8462,
    8471,  8474,  8476,  8482,  8484,  8485,  8486,  8487,  8495,  8494,
    8506,  8510,  8514,  8518,  8522,  8523,  8524,  8525,  8529,  8537,
    8546,  8547,  8552,  8551,  8596,  8600,  8608,  8609,  8613,  8617,
    8622,  8626,  8627,  8631,  8635,  8639,  8643,  8650,  8651,  8656,
    8661,  8655,  8675,  8676,  8681,  8686,  8680,  8705,  8704,  8725,
    8726,  8727,  8731,  8732,  8737,  8740,  8747,  8748,  8754,  8755,
    8759,  8760,  8764,  8765,  8769,  8779,  8795,  8800,  8806,  8812,
    8817,  8822,  8828,  8834,  8840,  8846,  8851,  8856,  8861,  8866,
    8871,  8876,  8883,  8893,  8897,  8908,  8907,  8916,  8920,  8924,
    8928,  8932,  8939,  8943,  8954,  8953,  8965,  8964,  8973,  8992,
    8991,  9015,  9023,  9024,  9029,  9040,  9051,  9065,  9069,  9077,
    9078,  9083,  9092,  9101,  9106,  9115,  9116,  9121,  9187,  9188,
    9189,  9193,  9194,  9198,  9202,  9213,  9212,  9224,  9226,  9251,
    9265,  9287,  9309,  9329,  9352,  9353,  9361,  9360,  9369,  9380,
    9379,  9389,  9396,  9395,  9408,  9417,  9421,  9432,  9452,  9451,
    9460,  9464,  9468,  9475,  9478,  9485,  9491,  9497,  9502,  9514,
    9513,  9521,  9529,  9530,  9534,  9535,  9536,  9541,  9544,  9551,
    9555,  9563,  9570,  9571,  9572,  9573,  9574,  9575,  9576,  9588,
    9591,  9601,  9600,  9609,  9615,  9627,  9626,  9635,  9639,  9640,
    9641,  9645,  9646,  9647,  9648,  9655,  9654,  9675,  9685,  9694,
    9698,  9705,  9710,  9715,  9720,  9725,  9730,  9738,  9739,  9743,
    9748,  9754,  9756,  9757,  9758,  9759,  9763,  9791,  9794,  9798,
    9802,  9806,  9813,  9820,  9830,  9829,  9842,  9841,  9849,  9853,
    9864,  9863,  9872,  9876,  9883,  9887,  9898,  9897,  9905,  9906,
    9910,  9935,  9936,  9937,  9938,  9942,  9943,  9947,  9948,  9949,
    9950,  9962,  9961,  9973,  9985,  9982,  9996, 10008, 10016, 10023,
   10027, 10040, 10047, 10059, 10062, 10067, 10071, 10084, 10091, 10092,
   10096, 10097, 10100, 10101, 10106, 10116, 10115, 10128, 10127, 10137,
   10166, 10167, 10171, 10175, 10179, 10183, 10190, 10191, 10195, 10199,
   10202, 10204, 10208, 10217, 10218, 10219, 10222, 10224, 10228, 10232,
   10236, 10244, 10245, 10249, 10250, 10254, 10258, 10268, 10279, 10278,
   10287, 10292, 10293, 10297, 10298, 10299, 10303, 10304, 10308, 10312,
   10313, 10317, 10321, 10325, 10335, 10334, 10342, 10352, 10363, 10362,
   10371, 10378, 10382, 10393, 10392, 10404, 10413, 10416, 10420, 10424,
   10431, 10435, 10445, 10457, 10456, 10465, 10469, 10478, 10479, 10484,
   10487, 10495, 10499, 10506, 10514, 10518, 10529, 10528, 10536, 10539,
   10544, 10546, 10550, 10556, 10557, 10558, 10559, 10562, 10564, 10571,
   10570, 10584, 10585, 10586, 10587, 10588, 10589, 10590, 10591, 10595,
   10596, 10600, 10601, 10607, 10616, 10623, 10624, 10628, 10632, 10636,
   10642, 10648, 10652, 10656, 10660, 10669, 10673, 10677, 10686, 10695,
   10696, 10700, 10709, 10710, 10714, 10718, 10727, 10736, 10748, 10747,
   10756, 10755, 10787, 10790, 10810, 10811, 10814, 10815, 10823, 10824,
   10829, 10834, 10844, 10861, 10866, 10876, 10894, 10893, 10903, 10916,
   10919, 10927, 10930, 10935, 10940, 10948, 10949, 10950, 10951, 10952,
   10953, 10957, 10965, 10966, 10970, 10974, 10985, 10984, 10994, 11002,
   11013, 11020, 11024, 11028, 11036, 11048, 11051, 11058, 11062, 11069,
   11070, 11071, 11072, 11079, 11078, 11088, 11095, 11096, 11100, 11114,
   11115, 11120, 11121, 11125, 11126, 11130, 11134, 11145, 11144, 11153,
   11157, 11161, 11165, 11173, 11177, 11187, 11198, 11199, 11206, 11205,
   11214, 11220, 11232, 11231, 11239, 11253, 11252, 11260, 11277, 11276,
   11286, 11294, 11295, 11300, 11301, 11306, 11313, 11314, 11319, 11326,
   11327, 11331, 11332, 11336, 11337, 11341, 11345, 11356, 11355, 11364,
   11365, 11366, 11367, 11368, 11372, 11399, 11402, 11414, 11424, 11429,
   11434, 11439, 11447, 11487, 11488, 11492, 11535, 11545, 11568, 11569,
   11570, 11571, 11575, 11584, 11590, 11600, 11609, 11618, 11619, 11626,
   11625, 11637, 11647, 11648, 11653, 11656, 11660, 11664, 11671, 11672,
   11676, 11677, 11678, 11682, 11686, 11698, 11699, 11700, 11710, 11714,
   11721, 11729, 11730, 11734, 11735, 11739, 11747, 11748, 11753, 11754,
   11755, 11765, 11769, 11776, 11784, 11785, 11789, 11799, 11800, 11801,
   11811, 11815, 11822, 11830, 11831, 11835, 11845, 11846, 11847, 11857,
   11861, 11868, 11876, 11877, 11881, 11892, 11893, 11900, 11902, 11911,
   11915, 11922, 11930, 11931, 11935, 11945, 11946, 11956, 11960, 11967,
   11975, 11976, 11980, 11990, 11991, 11995, 11996, 12006, 12010, 12017,
   12025, 12026, 12030, 12041, 12044, 12053, 12056, 12064, 12068, 12077,
   12081, 12091, 12099, 12106, 12106, 12117, 12118, 12122, 12123, 12125,
   12127, 12129, 12130, 12132, 12133, 12134, 12135, 12136, 12138, 12139,
   12140, 12143, 12145, 12149, 12152, 12154, 12155, 12156, 12157, 12158,
   12159, 12161, 12162, 12163, 12164, 12165, 12168, 12169, 12173, 12174,
   12178, 12179, 12183, 12184, 12188, 12192, 12198, 12202, 12208, 12209,
   12210, 12214, 12215, 12216, 12220, 12221, 12222, 12226, 12230, 12234,
   12235, 12236, 12239, 12240, 12250, 12262, 12271, 12283, 12292, 12304,
   12319, 12320, 12325, 12334, 12340, 12350, 12364, 12386, 12390, 12411,
   12423, 12464, 12478, 12479, 12484, 12490, 12491, 12496, 12508, 12509,
   12510, 12517, 12528, 12529, 12533, 12541, 12549, 12553, 12560, 12569,
   12570, 12576, 12585, 12596, 12613, 12617, 12624, 12625, 12626, 12633,
   12634, 12638, 12642, 12649, 12650, 12654, 12655, 12659, 12660, 12661,
   12662, 12666, 12670, 12674, 12678, 12682, 12703, 12707, 12714, 12715,
   12716, 12720, 12721, 12722, 12723, 12724, 12728, 12732, 12739, 12740,
   12744, 12745, 12749, 12756, 12763, 12764, 12765, 12769, 12770, 12774,
   12778, 12782, 12786, 12787, 12791, 12795, 12796, 12800, 12804, 12805,
   12812, 12816, 12820, 12824, 12828, 12832, 12833, 12839, 12843, 12847,
   12848, 12852, 12859, 12869, 12888, 12906, 12913, 12920, 12927, 12937,
   12941, 12948, 12955, 12965, 12975, 12985, 12998, 13002, 13010, 13018,
   13022, 13032, 13046, 13069, 13091, 13107, 13108, 13109, 13110, 13111,
   13112, 13116, 13120, 13137, 13141, 13148, 13149, 13150, 13151, 13152,
   13153, 13154, 13160, 13164, 13168, 13172, 13176, 13180, 13184, 13188,
   13192, 13196, 13200, 13204, 13208, 13215, 13216, 13220, 13221, 13222,
   13226, 13227, 13228, 13229, 13233, 13237, 13241, 13248, 13252, 13256,
   13263, 13270, 13277, 13287, 13287, 13298, 13305, 13315, 13322, 13332,
   13336, 13349, 13353, 13368, 13376, 13377, 13381, 13382, 13386, 13387,
   13392, 13395, 13403, 13406, 13413, 13415, 13416, 13420, 13421, 13425,
   13426, 13427, 13432, 13435, 13448, 13452, 13460, 13464, 13468, 13472,
   13476, 13480, 13484, 13488, 13495, 13496, 13500, 13501, 13511, 13512,
   13521, 13525, 13529, 13536, 13537, 13538, 13539, 13540, 13541, 13542,
   13543, 13544, 13545, 13546, 13547, 13548, 13549, 13550, 13551, 13552,
   13553, 13554, 13555, 13556, 13557, 13558, 13559, 13560, 13561, 13562,
   13563, 13564, 13565, 13566, 13567, 13568, 13569, 13570, 13571, 13572,
   13573, 13574, 13575, 13576, 13577, 13578, 13579, 13580, 13581, 13582,
   13583, 13584, 13588, 13589, 13590, 13591, 13592, 13593, 13594, 13595,
   13596, 13597, 13598, 13599, 13600, 13601, 13602, 13603, 13604, 13605,
   13606, 13607, 13608, 13615, 13615, 13616, 13616, 13617, 13617, 13618,
   13618, 13619, 13619, 13619, 13620, 13620, 13621, 13621, 13622, 13622,
   13623, 13623, 13624, 13624, 13625, 13625, 13626, 13626, 13627, 13627,
   13628, 13628, 13629, 13629, 13630, 13630, 13631, 13631, 13632, 13632,
   13633, 13633, 13634, 13634, 13635, 13635, 13636, 13636, 13636, 13637,
   13637, 13638, 13638, 13639, 13639, 13640, 13640, 13641, 13641, 13642,
   13642, 13642, 13643, 13643, 13643, 13644, 13644, 13645, 13645, 13645,
   13646, 13646, 13647, 13647, 13647, 13648, 13648, 13648, 13649, 13649,
   13650, 13650, 13651, 13651, 13652, 13652, 13653, 13653, 13653, 13654,
   13654, 13655, 13655, 13656, 13656, 13656, 13656, 13657, 13657, 13658,
   13658, 13659, 13659, 13660, 13660, 13661, 13661, 13661, 13662, 13662,
   13663, 13663, 13664, 13664, 13665, 13665, 13665, 13666, 13666, 13667,
   13667, 13668, 13668, 13669, 13669, 13670, 13670, 13671, 13671, 13672,
   13672, 13673, 13673, 13674, 13674, 13675, 13675, 13675, 13676, 13676,
   13677, 13677, 13678, 13678, 13682, 13682, 13683, 13683, 13684, 13684,
   13685, 13685, 13686, 13686, 13687, 13687, 13688, 13688, 13689, 13689,
   13690, 13690, 13691, 13691, 13691, 13692, 13692, 13693, 13693, 13694,
   13694, 13695, 13695, 13696, 13696, 13699, 13700, 13701, 13705, 13705,
   13706, 13706, 13707, 13707, 13708, 13708, 13709, 13709, 13710, 13710,
   13711, 13711, 13712, 13712
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 1
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "$undefined", "ACCEPT", "ACCESS", "ADD",
  "ADDRESS", "ADVANCING", "AFTER", "ALL", "ALLOCATE", "ALPHABET",
  "ALPHABETIC", "\"ALPHABETIC-LOWER\"", "\"ALPHABETIC-UPPER\"",
  "ALPHANUMERIC", "\"ALPHANUMERIC-EDITED\"", "ALSO", "ALTER", "ALTERNATE",
  "AND", "ANY", "ARE", "AREA", "AREAS", "\"ARGUMENT-NUMBER\"",
  "\"ARGUMENT-VALUE\"", "AS", "ASCENDING", "ASCII", "ASSIGN", "AT",
  "ATTRIBUTE", "AUTO", "AUTOMATIC", "\"AWAY-FROM-ZERO\"",
  "\"BACKGROUND-COLOR\"", "BASED", "BEFORE", "BELL", "BINARY",
  "\"BINARY-C-LONG\"", "\"BINARY-CHAR\"", "\"BINARY-DOUBLE\"",
  "\"BINARY-LONG\"", "\"BINARY-SHORT\"", "BLANK", "BLINK", "BLOCK",
  "BOTTOM", "BY", "\"BYTE-LENGTH\"", "CALL", "CANCEL", "CAPACITY",
  "\"CARD-PUNCH\"", "\"CARD-READER\"", "CASSETTE", "CD", "CF", "CH",
  "CHAINING", "CHARACTER", "CHARACTERS", "CLASS", "CLASSIFICATION",
  "\"class-name\"", "CLOSE", "COBOL", "CODE", "\"CODE-SET\"", "COLLATING",
  "COL", "COLS", "COLUMN", "COLUMNS", "COMMA", "\"COMMAND-LINE\"",
  "\"comma delimiter\"", "COMMIT", "COMMON", "COMMUNICATION", "COMP",
  "COMPUTE", "\"COMP-1\"", "\"COMP-2\"", "\"COMP-3\"", "\"COMP-4\"",
  "\"COMP-5\"", "\"COMP-6\"", "\"COMP-X\"", "\"FUNCTION CONCATENATE\"",
  "CONDITION", "CONFIGURATION", "CONSTANT", "CONTAINS", "CONTENT",
  "CONTINUE", "CONTROL", "CONTROLS", "CONVERSION", "CONVERTING", "COPY",
  "CORRESPONDING", "COUNT", "CRT", "\"CRT-UNDER\"", "CURRENCY",
  "\"FUNCTION CURRENT-DATE\"", "CURSOR", "CYCLE", "DATA", "DATE", "DAY",
  "\"DAY-OF-WEEK\"", "DE", "DEBUGGING", "\"DECIMAL-POINT\"",
  "DECLARATIVES", "DEFAULT", "\"DEFAULT-FONT\"", "DELETE", "DELIMITED",
  "DELIMITER", "DEPENDING", "DESCENDING", "DESTINATION", "DESTROY",
  "DETAIL", "DISABLE", "DISC", "DISK", "DISPLAY",
  "\"FUNCTION DISPLAY-OF\"", "DIVIDE", "DIVISION", "DOWN", "DUPLICATES",
  "DYNAMIC", "EBCDIC", "EC", "ECHO", "EGI", "\"88\"", "ENABLE", "ELSE",
  "EMI", "END", "\"END-ACCEPT\"", "\"END-ADD\"", "\"END-CALL\"",
  "\"END-COMPUTE\"", "\"END-DELETE\"", "\"END-DISPLAY\"", "\"END-DIVIDE\"",
  "\"END-EVALUATE\"", "\"END FUNCTION\"", "\"END-IF\"", "\"END-MULTIPLY\"",
  "\"END-PERFORM\"", "\"END PROGRAM\"", "\"END-READ\"", "\"END-RECEIVE\"",
  "\"END-RETURN\"", "\"END-REWRITE\"", "\"END-SEARCH\"", "\"END-START\"",
  "\"END-STRING\"", "\"END-SUBTRACT\"", "\"END-UNSTRING\"",
  "\"END-WRITE\"", "ENTRY", "\"ENTRY-CONVENTION\"", "ENVIRONMENT",
  "\"ENVIRONMENT-NAME\"", "\"ENVIRONMENT-VALUE\"", "EOL", "EOP", "EOS",
  "EQUAL", "ERASE", "ERROR", "ESCAPE", "ESI", "EVALUATE",
  "\"EVENT STATUS\"", "EXCEPTION", "\"EXCEPTION CONDITION\"", "EXCLUSIVE",
  "EXIT", "\"exponentiation operator\"", "EXTEND", "EXTERNAL", "F", "FD",
  "\"FILE-CONTROL\"", "\"FILE-ID\"", "FILLER", "FINAL", "FIRST", "FIXED",
  "\"FIXED-FONT\"", "\"FLOAT-BINARY-128\"", "\"FLOAT-BINARY-32\"",
  "\"FLOAT-BINARY-64\"", "\"FLOAT-DECIMAL-16\"", "\"FLOAT-DECIMAL-34\"",
  "\"FLOAT-DECIMAL-7\"", "\"FLOAT-EXTENDED\"", "\"FLOAT-LONG\"",
  "\"FLOAT-SHORT\"", "FLOATING", "FONT", "FOOTING", "FOR",
  "\"FOREGROUND-COLOR\"", "FOREVER", "\"FUNCTION FORMATTED-DATE\"",
  "\"FUNCTION FORMATTED-DATETIME\"", "\"FUNCTION FORMATTED-TIME\"", "FREE",
  "FROM", "\"FROM CRT\"", "FULL", "FUNCTION", "\"FUNCTION-ID\"",
  "\"intrinsic function name\"", "GENERATE", "GIVING", "GLOBAL", "GO",
  "GOBACK", "GRAPHICAL", "GREATER", "\"GREATER OR EQUAL\"", "GRID",
  "GROUP", "HANDLE", "HEADING", "HIGHLIGHT", "\"HIGH-VALUE\"", "ID",
  "IDENTIFICATION", "IF", "IGNORE", "IGNORING", "IN", "INDEPENDENT",
  "INDEX", "INDEXED", "INDICATE", "INITIALIZE", "INITIALIZED", "INITIATE",
  "INPUT", "\"INPUT-OUTPUT\"", "INSPECT", "INTERMEDIATE", "INTO",
  "INTRINSIC", "INVALID", "\"INVALID KEY\"", "IS", "\"I-O\"",
  "\"I-O-CONTROL\"", "JUSTIFIED", "KEPT", "KEY", "KEYBOARD", "LABEL",
  "\"LARGE-FONT\"", "LAST", "\"LAYOUT-MANAGER\"", "LEADING", "LEFT",
  "LEFTLINE", "LENGTH", "\"FUNCTION LENGTH/BYTE-LENGTH\"", "\"LENGTH OF\"",
  "LESS", "\"LESS OR EQUAL\"", "LIMIT", "LIMITS", "LINAGE",
  "\"LINAGE-COUNTER\"", "LINE", "\"LINE-COUNTER\"", "LINES", "LINKAGE",
  "\"Literal\"", "\"LM-RESIZE\"", "LOCALE", "\"FUNCTION LOCALE-DATE\"",
  "\"FUNCTION LOCALE-TIME\"", "\"FUNCTION LOCALE-TIME-FROM-SECONDS\"",
  "\"LOCAL-STORAGE\"", "LOCK", "LOWER", "\"FUNCTION LOWER-CASE\"",
  "LOWLIGHT", "\"LOW-VALUE\"", "MANUAL", "\"MAGNETIC-TAPE\"", "MEMORY",
  "\"MEDIUM-FONT\"", "MENU", "MERGE", "MESSAGE", "MINUS",
  "\"Mnemonic name\"", "MODE", "MODULES", "MOVE", "MULTIPLE", "MULTIPLY",
  "NAME", "NATIONAL", "\"NATIONAL-EDITED\"", "\"FUNCTION NATIONAL-OF\"",
  "NATIVE", "\"NEAREST-AWAY-FROM-ZERO\"", "\"NEAREST-EVEN\"",
  "\"NEAREST-TOWARD-ZERO\"", "NEGATIVE", "NESTED", "NEXT", "\"NEXT PAGE\"",
  "NO", "\"NO DATA\"", "\"NO-ECHO\"", "NORMAL", "NOT", "NOTHING",
  "\"NOT END\"", "\"NOT EOP\"", "\"NOT ESCAPE\"", "\"NOT EQUAL\"",
  "\"NOT EXCEPTION\"", "\"NOT INVALID KEY\"", "\"NOT OVERFLOW\"",
  "\"NOT SIZE ERROR\"", "\"NO ADVANCING\"", "NUMBER", "NUMBERS", "NUMERIC",
  "\"NUMERIC-EDITED\"", "\"FUNCTION NUMVAL-C\"", "\"OBJECT-COMPUTER\"",
  "OCCURS", "OF", "OFF", "OMITTED", "ON", "ONLY", "OPEN", "OPTIONAL",
  "OPTIONS", "OR", "ORDER", "ORGANIZATION", "OTHER", "OUTPUT", "OVERLINE",
  "\"PACKED-DECIMAL\"", "PADDING", "PAGE", "\"PAGE-COUNTER\"", "PARAGRAPH",
  "PERFORM", "PH", "PF", "PICTURE", "\"PICTURE SYMBOL\"", "PLUS",
  "POINTER", "\"POP-UP\"", "POSITION", "POSITIVE", "PRESENT", "PREVIOUS",
  "PRINT", "PRINTER", "PRINTER_1", "PRINTING", "PRIORITY", "PROCEDURE",
  "PROCEDURES", "PROCEED", "PROGRAM", "\"PROGRAM-ID\"", "\"program name\"",
  "\"PROGRAM-POINTER\"", "PROHIBITED", "PROMPT", "\"PROTECTED\"", "PURGE",
  "QUEUE", "QUOTE", "RANDOM", "RD", "READ", "\"READY TRACE\"", "RECEIVE",
  "RECORD", "RECORDING", "RECORDS", "RECURSIVE", "REDEFINES", "REEL",
  "REFERENCE", "REFERENCES", "RELATIVE", "RELEASE", "REMAINDER", "REMOVAL",
  "RENAMES", "REPLACE", "REPLACING", "REPORT", "REPORTING", "REPORTS",
  "REPOSITORY", "REQUIRED", "RESERVE", "RESET", "\"RESET TRACE\"", "RETRY",
  "RETURN", "RETURNING", "REVERSE", "\"FUNCTION REVERSE\"",
  "\"REVERSE-VIDEO\"", "REVERSED", "REWIND", "REWRITE", "RF", "RH",
  "RIGHT", "ROLLBACK", "ROUNDED", "ROUNDING", "RUN", "S", "SAME", "SCREEN",
  "\"SCREEN CONTROL\"", "SCROLL", "SD", "SEARCH", "SECONDS", "SECTION",
  "SECURE", "SEGMENT", "\"SEGMENT-LIMIT\"", "SELECT", "\"semi-colon\"",
  "SEND", "SENTENCE", "SEPARATE", "SEQUENCE", "SEQUENTIAL", "SET",
  "\"78\"", "SHARING", "SIGN", "SIGNED", "\"SIGNED-INT\"",
  "\"SIGNED-LONG\"", "\"SIGNED-SHORT\"", "\"66\"", "SIZE",
  "\"SIZE ERROR\"", "\"SMALL-FONT\"", "SORT", "\"SORT-MERGE\"", "SOURCE",
  "\"SOURCE-COMPUTER\"", "SPACE", "\"SPECIAL-NAMES\"", "STANDARD",
  "\"STANDARD-1\"", "\"STANDARD-2\"", "START", "STATIC", "STATUS",
  "STDCALL", "STEP", "STOP", "STRING", "SUB_QUEUE_1", "SUB_QUEUE_2",
  "SUB_QUEUE_3", "\"FUNCTION SUBSTITUTE\"", "\"FUNCTION SUBSTITUTE-CASE\"",
  "SUBTRACT", "SUBWINDOW", "SUM", "SUPPRESS", "SYMBOLIC", "SYNCHRONIZED",
  "\"SYSTEM-DEFAULT\"", "\"SYSTEM-OFFSET\"", "TAB", "TABLE", "TALLYING",
  "TAPE", "TERMINAL", "TERMINATE", "TEXT", "TEST", "THAN", "THEN",
  "THREAD", "THREADS", "THRU", "TIME", "\"TIME-OUT\"", "TIMES", "TO",
  "\"&\"", "\")\"", "\":\"", "\"/\"", "\".\"", "\"=\"", "\"EXTERN\"",
  "\"FALSE\"", "\"FILE\"", "\">\"", "\"INITIAL\"", "\"<\"", "\"-\"",
  "\"*\"", "\"NULL\"", "\"OVERFLOW\"", "\"(\"", "\"+\"", "\"TRUE\"", "TOP",
  "\"TOWARD-GREATER\"", "\"TOWARD-LESSER\"", "\"TRADITIONAL-FONT\"",
  "TRAILING", "TRANSFORM", "\"FUNCTION TRIM\"", "TRUNCATION", "TYPE", "U",
  "UNBOUNDED", "UNDERLINE", "UNIT", "UNLOCK", "UNSIGNED",
  "\"UNSIGNED-INT\"", "\"UNSIGNED-LONG\"", "\"UNSIGNED-SHORT\"",
  "UNSTRING", "UNTIL", "UP", "UPDATE", "UPON", "\"UPON ARGUMENT-NUMBER\"",
  "\"UPON COMMAND-LINE\"", "\"UPON ENVIRONMENT-NAME\"",
  "\"UPON ENVIRONMENT-VALUE\"", "UPPER", "\"FUNCTION UPPER-CASE\"",
  "USAGE", "USE", "USER", "\"USER-DEFAULT\"", "\"user function name\"",
  "USING", "V", "VALUE", "VARIABLE", "VARIANT", "VARYING", "WAIT", "WHEN",
  "\"FUNCTION WHEN-COMPILED\"", "WINDOW", "WITH", "\"Identifier\"",
  "WORDS", "\"WORKING-STORAGE\"", "WRITE", "YYYYDDD", "YYYYMMDD", "ZERO",
  "SHIFT_PREFER", "$accept", "start", "$@1", "compilation_group",
  "nested_list", "$@2", "source_element_list", "source_element",
  "simple_prog", "$@3", "program_definition", "function_definition",
  "_end_program_list", "end_program_list", "end_program", "end_function",
  "_program_body", "_identification_header", "identification_or_id",
  "program_id_paragraph", "$@4", "$@5", "function_id_paragraph", "$@6",
  "program_id_name", "end_program_name", "_as_literal", "_program_type",
  "program_type_clause", "init_or_recurse_and_common", "init_or_recurse",
  "_options_paragraph", "_options_clauses", "_default_rounded_clause",
  "_entry_convention_clause", "convention_type",
  "_intermediate_rounding_clause", "intermediate_rounding_choice",
  "_environment_division", "_environment_header", "_configuration_section",
  "_configuration_paragraphs", "standard_order_conf_section",
  "nonstandard_order_conf_section", "_configuration_header",
  "_source_object_computer_paragraphs",
  "source_object_computer_paragraphs", "source_computer_paragraph", "$@7",
  "_source_computer_entry", "_with_debugging_mode",
  "object_computer_paragraph", "$@8", "_object_computer_entry",
  "object_clauses_list", "object_clauses", "object_computer_memory",
  "object_computer_sequence", "object_computer_segment",
  "object_computer_class", "locale_class", "computer_words",
  "_repository_paragraph", "repository_paragraph", "$@9",
  "_repository_entry", "repository_list", "repository_name",
  "repository_name_list", "_special_names_paragraph",
  "special_names_paragraph", "special_names_header",
  "_special_names_sentence_list", "special_names_sentence_list",
  "special_name_list", "special_name", "mnemonic_name_clause", "$@10",
  "mnemonic_choices", "_special_name_mnemonic_on_off", "on_off_clauses",
  "on_off_clauses_1", "alphabet_name_clause", "@11", "alphabet_definition",
  "alphabet_literal_list", "alphabet_literal", "@12",
  "alphabet_also_sequence", "alphabet_lits", "space_or_zero",
  "symbolic_characters_clause", "_sym_in_word", "symbolic_collection",
  "symbolic_chars_list", "symbolic_chars_phrase", "char_list",
  "integer_list", "class_name_clause", "class_item_list", "class_item",
  "locale_clause", "currency_sign_clause", "_with_pic_symbol",
  "decimal_point_clause", "numeric_sign_clause", "cursor_clause",
  "crt_status_clause", "screen_control", "event_status",
  "_input_output_section", "_input_output_header", "_file_control_header",
  "_i_o_control_header", "_file_control_sequence", "file_control_entry",
  "$@13", "_select_clauses_or_error", "_select_clause_sequence",
  "select_clause", "assign_clause", "printer_name", "general_device_name",
  "line_seq_device_name", "_line_adv_file", "_ext_clause",
  "assignment_name", "_assignment_name", "access_mode_clause",
  "access_mode", "alternative_record_key_clause", "_suppress_clause",
  "collating_sequence_clause", "alphabet_name", "file_status_clause",
  "_file_or_sort", "lock_mode_clause", "$@14", "lock_mode", "_lock_with",
  "organization_clause", "organization", "padding_character_clause",
  "record_delimiter_clause", "record_key_clause", "key_or_split_keys",
  "relative_key_clause", "reserve_clause", "no_or_integer",
  "sharing_clause", "sharing_option", "_i_o_control", "i_o_control_list",
  "i_o_control_clause", "same_clause", "_same_option",
  "multiple_file_tape_clause", "$@15", "multiple_file_list",
  "multiple_file", "_multiple_file_position", "_data_division", "$@16",
  "_data_division_header", "_file_section_header",
  "_file_description_sequence", "file_description",
  "file_description_entry", "$@17", "file_type",
  "_file_description_clause_sequence", "file_description_clause",
  "block_contains_clause", "_records_or_characters", "record_clause",
  "_record_depending", "_from_integer", "_to_integer",
  "label_records_clause", "value_of_clause", "file_id", "valueof_name",
  "data_records_clause", "linage_clause", "_linage_sequence",
  "linage_lines", "linage_footing", "linage_top", "linage_bottom",
  "recording_mode_clause", "recording_mode", "u_or_s", "code_set_clause",
  "_for_sub_records_clause", "report_clause", "report_keyword",
  "rep_name_list", "_communication_section", "$@18",
  "_communication_description_sequence", "communication_description",
  "communication_description_entry", "$@19",
  "_communication_description_clause_sequence",
  "communication_description_clause", "_input_cd_clauses",
  "named_input_cd_clauses", "named_input_cd_clause",
  "unnamed_input_cd_clauses", "_output_cd_clauses", "output_cd_clauses",
  "output_cd_clause", "_i_o_cd_clauses", "named_i_o_cd_clauses",
  "named_i_o_cd_clause", "unnamed_i_o_cd_clauses",
  "_working_storage_section", "$@20", "_record_description_list", "$@21",
  "record_description_list", "data_description", "$@22", "level_number",
  "_filler", "_entry_name", "user_entry_name", "const_global",
  "lit_or_length", "con_identifier", "fp32_usage", "fp64_usage",
  "fp128_usage", "pointer_len", "renames_entry", "_renames_thru",
  "condition_name_entry", "$@23", "constant_entry", "$@24",
  "constant_source", "constant_78_source", "constant_expression_list",
  "constant_expression", "_data_description_clause_sequence",
  "data_description_clause", "redefines_clause", "external_clause",
  "_as_extname", "_global_clause", "global_clause", "picture_clause",
  "usage_clause", "usage", "float_usage", "double_usage", "_font_name",
  "_layout_name", "sign_clause", "report_occurs_clause", "_occurs_step",
  "occurs_clause", "_occurs_to_integer", "_occurs_from_integer",
  "_occurs_integer_to", "_occurs_depending", "_capacity_in",
  "_occurs_initialized", "_occurs_keys_and_indexed", "$@25", "occurs_keys",
  "occurs_key_list", "occurs_key_field", "ascending_or_descending",
  "_occurs_indexed", "occurs_indexed", "occurs_index_list", "occurs_index",
  "justified_clause", "synchronized_clause", "blank_clause",
  "based_clause", "value_clause", "$@26", "value_item_list", "value_item",
  "_false_is", "any_length_clause", "_local_storage_section", "$@27",
  "_linkage_section", "$@28", "_report_section", "$@29",
  "_report_description_sequence", "report_description", "$@30",
  "_report_description_options", "report_description_option",
  "control_clause", "control_field_list", "page_limit_clause",
  "page_line_column", "_page_heading_list", "page_detail",
  "heading_clause", "first_detail", "last_heading", "last_detail",
  "footing_clause", "_report_group_description_list",
  "report_group_description_entry", "$@31", "_report_group_options",
  "report_group_option", "type_clause", "type_option", "_control_final",
  "_or_page", "next_group_clause", "sum_clause_list", "_reset_clause",
  "data_or_final", "present_when_condition", "varying_clause",
  "line_clause", "line_keyword_clause", "column_clause",
  "col_keyword_clause", "report_line_integer_list", "line_or_plus",
  "report_col_integer_list", "col_or_plus", "source_clause",
  "group_indicate_clause", "report_usage_clause", "_screen_section",
  "$@32", "_screen_description_list", "screen_description_list",
  "screen_description", "$@33", "_screen_options", "screen_option", "eol",
  "eos", "plus_plus", "minus_minus", "screen_line_number",
  "_screen_line_plus_minus", "screen_col_number", "_screen_col_plus_minus",
  "screen_occurs_clause", "screen_global_clause", "_procedure_division",
  "$@34", "$@35", "$@36", "_procedure_using_chaining", "$@37", "$@38",
  "procedure_param_list", "procedure_param", "_procedure_type",
  "_size_optional", "size_is_integer", "_procedure_optional",
  "_procedure_returning", "_procedure_declaratives", "$@39",
  "_procedure_list", "procedure", "section_header", "$@40",
  "_use_statement", "paragraph_header", "invalid_statement", "_segment",
  "statement_list", "@41", "@42", "statements", "$@43", "statement",
  "accept_statement", "$@44", "accept_body", "$@45", "accp_identifier",
  "_accept_clauses", "accept_clauses", "accept_clause", "lines_or_number",
  "at_line_column", "line_number", "column_number", "mode_is_block",
  "accp_attr", "no_echo", "reverse_video", "update_default", "end_accept",
  "add_statement", "$@46", "add_body", "_add_to", "end_add",
  "allocate_statement", "$@47", "allocate_body", "allocate_returning",
  "alter_statement", "$@48", "alter_body", "alter_entry", "_proceed_to",
  "call_statement", "$@49", "call_body", "$@50", "_mnemonic_conv",
  "program_or_prototype", "_id_or_lit_or_func_as", "nested_or_prototype",
  "call_using", "$@51", "call_param_list", "call_param", "call_type",
  "call_returning", "return_give", "null_or_omitted",
  "call_exception_phrases", "_call_on_exception", "call_on_exception",
  "_call_not_on_exception", "call_not_on_exception", "end_call",
  "cancel_statement", "$@52", "cancel_body", "id_or_lit_or_program_name",
  "close_statement", "$@53", "close_body", "close_files", "_close_option",
  "close_window", "@54", "_close_display_option", "compute_statement",
  "$@55", "compute_body", "end_compute", "commit_statement",
  "continue_statement", "destroy_statement", "$@56", "destroy_body",
  "delete_statement", "$@57", "delete_body", "delete_file_list",
  "end_delete", "disable_statement", "$@58", "enable_disable_handling",
  "_enable_disable_key", "communication_mode", "display_statement", "$@59",
  "display_body", "screen_or_device_display", "display_list",
  "display_atom", "$@60", "disp_list", "display_clauses", "display_clause",
  "display_upon", "crt_under", "display_window", "@61", "$@62",
  "sub_or_window", "display_floating_window", "@63", "$@64",
  "display_initial_window", "$@65", "intial_type", "_graphical",
  "_upon_window_handle", "display_window_clauses", "display_window_clause",
  "pop_up_or_handle", "pop_up_area", "handle_is_in", "disp_attr",
  "end_display", "divide_statement", "$@66", "divide_body", "end_divide",
  "enable_statement", "$@67", "entry_statement", "$@68", "entry_body",
  "evaluate_statement", "$@69", "evaluate_body", "evaluate_subject_list",
  "evaluate_subject", "evaluate_condition_list", "evaluate_case_list",
  "evaluate_case", "evaluate_other", "evaluate_when_list",
  "evaluate_object_list", "evaluate_object", "_evaluate_thru_expr",
  "end_evaluate", "exit_statement", "$@70", "exit_body",
  "exit_program_returning", "free_statement", "$@71", "free_body",
  "generate_statement", "$@72", "generate_body", "goto_statement", "$@73",
  "go_body", "goto_depending", "goback_statement", "if_statement", "$@74",
  "if_else_statements", "if_then", "if_true", "if_false", "end_if",
  "initialize_statement", "$@75", "initialize_body", "_initialize_filler",
  "_initialize_value", "_initialize_replacing",
  "initialize_replacing_list", "initialize_replacing_item",
  "initialize_category", "_initialize_default", "initiate_statement",
  "$@76", "initiate_body", "inspect_statement", "$@77", "inspect_body",
  "send_identifier", "inspect_list", "inspect_tallying", "$@78",
  "inspect_replacing", "inspect_converting", "tallying_list",
  "tallying_item", "replacing_list", "replacing_item", "rep_keyword",
  "replacing_region", "inspect_region", "inspect_before", "inspect_after",
  "merge_statement", "$@79", "move_statement", "$@80", "move_body",
  "multiply_statement", "$@81", "multiply_body", "end_multiply",
  "open_statement", "$@82", "open_body", "open_file_entry", "open_mode",
  "open_sharing", "open_option", "perform_statement", "$@83",
  "perform_body", "$@84", "end_perform", "term_or_dot",
  "perform_procedure", "perform_option", "perform_test", "cond_or_exit",
  "perform_varying_list", "perform_varying", "purge_statement", "$@85",
  "read_statement", "$@86", "read_body", "_read_into", "_lock_phrases",
  "ignoring_lock", "advancing_lock_or_retry", "_retry_phrase",
  "retry_phrase", "retry_options", "_extended_with_lock",
  "extended_with_lock", "_read_key", "read_handler", "end_read",
  "ready_statement", "receive_statement", "$@87", "receive_body",
  "message_or_segment", "_data_sentence_phrases", "_no_data_sentence",
  "no_data_sentence", "_with_data_sentence", "with_data_sentence",
  "end_receive", "release_statement", "$@88", "release_body",
  "reset_statement", "return_statement", "$@89", "return_body",
  "end_return", "rewrite_statement", "$@90", "rewrite_body", "_with_lock",
  "with_lock", "end_rewrite", "rollback_statement", "search_statement",
  "$@91", "search_body", "search_varying", "search_at_end", "search_whens",
  "search_when", "end_search", "send_statement", "$@92", "send_body",
  "_from_identifier", "from_identifier", "with_indicator",
  "_replacing_line", "set_statement", "$@93", "set_body", "on_or_off",
  "up_or_down", "set_environment", "set_attr", "set_attr_clause",
  "set_attr_one", "set_to", "set_up_down", "set_to_on_off_sequence",
  "set_to_on_off", "set_to_true_false_sequence", "set_to_true_false",
  "set_last_exception_to_off", "set_thread_priority", "sort_statement",
  "$@94", "sort_body", "@95", "sort_key_list", "_key_list",
  "_sort_duplicates", "sort_collating", "sort_input", "sort_output",
  "start_statement", "$@96", "start_body", "sizelen_clause", "start_key",
  "start_op", "disallowed_op", "not_equal_op", "end_start",
  "stop_statement", "$@97", "stop_returning", "_status_x", "stop_argument",
  "stop_literal", "string_statement", "$@98", "string_body",
  "string_item_list", "string_item", "_string_delimited",
  "string_delimiter", "_with_pointer", "end_string", "subtract_statement",
  "$@99", "subtract_body", "end_subtract", "suppress_statement",
  "_printing", "terminate_statement", "$@100", "terminate_body",
  "transform_statement", "$@101", "transform_body", "unlock_statement",
  "$@102", "unlock_body", "unstring_statement", "$@103", "unstring_body",
  "_unstring_delimited", "unstring_delimited_list",
  "unstring_delimited_item", "unstring_into", "unstring_into_item",
  "_unstring_into_delimiter", "_unstring_into_count", "_unstring_tallying",
  "end_unstring", "use_statement", "$@104", "use_phrase",
  "use_file_exception", "use_global", "use_file_exception_target",
  "use_debugging", "debugging_list", "debugging_target", "_all_refs",
  "use_start_end", "program_start_end", "use_reporting", "use_exception",
  "use_ex_keyw", "write_statement", "$@105", "write_body", "from_option",
  "write_option", "before_or_after", "write_handler", "end_write",
  "_accept_exception_phrases", "_accp_on_exception", "accp_on_exception",
  "escape_or_exception", "_accp_not_on_exception", "accp_not_on_exception",
  "not_escape_or_not_exception", "_display_exception_phrases",
  "_disp_on_exception", "disp_on_exception", "_disp_not_on_exception",
  "disp_not_on_exception", "on_size_error_phrases", "_on_size_error",
  "on_size_error", "_not_on_size_error", "not_on_size_error",
  "_on_overflow_phrases", "_on_overflow", "on_overflow",
  "_not_on_overflow", "not_on_overflow", "return_at_end", "at_end",
  "_at_end_clause", "at_end_clause", "_not_at_end_clause",
  "not_at_end_clause", "at_eop_clauses", "_at_eop_clause", "at_eop_clause",
  "_not_at_eop_clause", "not_at_eop_clause", "_invalid_key_phrases",
  "invalid_key_phrases", "_invalid_key_sentence", "invalid_key_sentence",
  "_not_invalid_key_sentence", "not_invalid_key_sentence", "_thread_start",
  "_thread_handle", "thread_reference_optional", "_scroll_lines",
  "condition", "expr", "partial_expr", "$@106", "expr_tokens",
  "expr_token", "_not", "not", "condition_or_class", "eq", "gt", "lt",
  "ge", "le", "exp_list", "_e_sep", "exp", "exp_term", "exp_factor",
  "exp_unary", "exp_atom", "line_linage_page_counter", "arithmetic_x_list",
  "arithmetic_x", "record_name", "file_or_record_name", "table_name",
  "file_name_list", "file_name", "cd_name", "report_name",
  "mnemonic_name_list", "mnemonic_name", "procedure_name_list",
  "procedure_name", "label", "integer_label", "reference_list",
  "reference", "single_reference", "optional_reference_list",
  "optional_reference", "reference_or_literal", "undefined_word",
  "unique_word", "target_x_list", "target_x", "_x_list", "x_list", "x",
  "call_x", "x_common", "report_x_list", "expr_x", "arith_x",
  "prog_or_entry", "alnum_or_id", "simple_display_value",
  "simple_display_all_value", "simple_value", "simple_all_value",
  "id_or_lit", "id_or_lit_or_func", "id_or_lit_or_length_or_func",
  "num_id_or_lit", "positive_id_or_lit", "pos_num_id_or_lit",
  "from_parameter", "sub_identifier", "table_identifier",
  "sub_identifier_1", "display_identifier", "numeric_identifier",
  "identifier_or_file_name", "identifier", "identifier_1",
  "identifier_list", "target_identifier", "target_identifier_1",
  "qualified_word", "subref", "refmod", "integer", "symbolic_integer",
  "report_integer", "class_value", "literal", "basic_literal",
  "basic_value", "function", "func_no_parm", "func_one_parm",
  "func_multi_parm", "func_refmod", "func_args", "trim_args", "length_arg",
  "$@107", "numvalc_args", "locale_dt_args", "formatted_datetime_args",
  "formatted_time_args", "not_const_word", "flag_all", "flag_duplicates",
  "flag_initialized", "flag_initialized_to", "to_init_val", "_flag_next",
  "_flag_not", "flag_optional", "flag_rounded", "round_mode",
  "round_choice", "flag_separate", "_from_idx_to_idx", "_dest_index",
  "error_stmt_recover", "verb", "scope_terminator", "_advancing", "_after",
  "_are", "_area", "_areas", "_as", "_at", "_before", "_binary", "_by",
  "_character", "_characters", "_contains", "_controls", "_data",
  "_end_of", "_file", "_final", "_for", "_from", "_in", "_in_order",
  "_index", "_indicate", "_initial", "_into", "_is", "_is_are", "_is_in",
  "_key", "_left_or_right", "_line", "_line_or_lines", "_limits", "_lines",
  "_message", "_mode", "_number", "_numbers", "_of", "_on",
  "_onoff_status", "_other", "_procedure", "_program", "_record",
  "_records", "_right", "_sign", "_signed", "_sign_is", "_size",
  "_standard", "_status", "_symbolic", "_tape", "_terminal", "_then",
  "_times", "_to", "_to_using", "_when", "_when_set_to", "_with",
  "coll_sequence", "column_or_col", "columns_or_cols", "comp_equal",
  "exception_or_error", "in_of", "label_option", "line_or_lines",
  "lock_records", "object_char_or_word_or_modules", "records",
  "reel_or_unit", "scroll_line_or_lines", "size_or_length", "with_dups",
  "prog_coll_sequence", "detail_keyword", "ch_keyword", "cf_keyword",
  "ph_keyword", "pf_keyword", "rh_keyword", "rf_keyword",
  "control_keyword", YY_NULLPTR
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   818,   819,   820,   821,   822,   823,   824,
     825,   826,   827,   828,   829,   830,   831,   832,   833,   834,
     835,   836,   837,   838,   839,   840,   841,   842,   843,   844,
     845
};
# endif

#define YYPACT_NINF -2942

#define yypact_value_is_default(Yystate) \
  (!!((Yystate) == (-2942)))

#define YYTABLE_NINF -2283

#define yytable_value_is_error(Yytable_value) \
  0

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const yytype_int16 yypact[] =
{
   -2942,   308,  1109, -2942, -2942, -2942,  1376, -2942,   158, -2942,
   -2942,   842, -2942, -2942, -2942,   764,   976,  1054, -2942,  1205,
    1238, -2942, -2942, -2942,   652,   652,   817,   902,  1316,  1080,
    1022,  1116,  1320,  1297,  1142,  1182,  1191,   158,   158, -2942,
   -2942,  1243,  1504, -2942, -2942,  1308, -2942,  1254,  1342, -2942,
    1605,    88,    88,  1328,  1355,  1564,  1564,  1564,    88,  1366,
    1324,  1349,  1564,  1360,  1373,  1768, -2942, -2942, -2942, -2942,
    2073,  1517,  1423,  2031,   -99,  1574,  1574,  2119, -2942, -2942,
   -2942, -2942,  1658, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942,   -24,   -24,  1788,  1748,  1766, -2942,   883,  4084,
    4944,  1406,   647, -2942,  1411,  1421, -2942, -2942, -2942, -2942,
    1564,  1564, -2942,  1564, -2942,  1374,  1871,  1374,  1564,  1564,
   -2942, -2942,  1374, -2942, -2942, -2942,  1375,  1181,  2161,  1548,
   -2942, -2942,  2161,   908,  1548, -2942,   908, -2942,  1574,  2201,
   -2942, -2942,  1396, -2942, -2942, -2942,  1965,  1965,  1554, -2942,
    1822,   -19, -2942,  1748, -2942,   -19, -2942, -2942, -2942, -2942,
   -2942,    41,  5312, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942,    13, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942,  1552, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
    1367, -2942, -2942,  1614, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
    1420, -2942,   311,   100, -2942, -2942,   592,  1564,   730,  1374,
    1721,     9, -2942, -2942, -2942, -2942,  1722,  1470,   874,    27,
   -2942,  1433, -2942,  1375, -2942,    81, -2942, -2942, -2942, -2942,
   -2942, -2942,  1434,   -27,  1564,    82, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942,  1728,  1495, -2942,
    1711,  1564,  1767, -2942, -2942,  1500, -2942,  1502, -2942, -2942,
    1598, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942,  -154,  6264,  9826,   476,   883,
    -111,  1226,   117,  -244,    86,  1011,  5847,  7107,  1011,   883,
    1047,  1147,   117,  1374,  1512, -2942, -2942,  7107, -2942, -2942,
     117,  1453,  2580,  1374,  6562,  7107, -2942,  1196,   -66,  1455,
    1456,  1455,  1374,  1456,   734,    95,  1455,   215,  1374,  1456,
   -2942, -2942, -2942, -2942,  1374, -2942, -2942, -2942, -2942, -2942,
   -2942,  1505,  7107,  6292, -2942, -2942,  1453,   138,  1374,  1456,
    4560,   734,  1593,  1960, -2942,   293,  1523, -2942, -2942,  1525,
     -30,   -38, -2942,   482, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942,   730, -2942,  1535, -2942,  -140, -2942, -2942,  1374, -2942,
    1592, -2942,  1594,  1581,  1983,  1564, -2942, -2942, -2942,  1123,
   -2942, -2942, -2942, -2942, -2942,   632,  1990,  1564,    83,  1473,
   -2942,   105, -2942, -2942,   142, -2942, -2942, -2942, -2942,  1769,
     -27, -2942,  1795,    88,    88, -2942,  1434, -2942, -2942,   470,
   -2942,  1564,   238,  1620,  1538, -2942, -2942,    60,    60,  -144,
    1539, -2942,  1135,  1915, -2942,  1757,  1844,  1717,   897, -2942,
    1374, -2942, -2942,  1542,  1543,  1544, -2942,  1550,  3900,     9,
       9, -2942,  1551,  1555,  1556, -2942, -2942, -2942,  1557,     9,
   -2942, -2942, -2942, -2942, -2942,  1374, -2942,  1559, -2942,  1544,
   -2942, -2942,  1920, -2942,  6605, -2942, -2942, -2942, -2942,  1568,
   -2942, -2942,  1565,  1566,  1567,  3900,  9839,  9826,  9839, -2942,
      70,  -211, -2942,  1880, -2942, -2942, -2942,   355,  1568, -2942,
   -2942,   476, -2942,  1571, -2942,     9, -2942,  1924,   -66, -2942,
   -2942,  -111, -2942, -2942, -2942, -2942, -2942,  1456, -2942,   918,
    1717,  1931,    84, -2942,  1644, -2942, -2942,  1505,  1568,  1456,
    1941,  1695,  2000, -2942, -2942,  1374,  1599,  1601, -2942, -2942,
   -2942,  1455,  1877, -2942,  1292, -2942, -2942, -2942, -2942, -2942,
    1955,    67,  6660, -2942, -2942, -2942, -2942, -2942, -2942,  1877,
    5625,  1391,  1403,  1956,   876, -2942,  1824, -2942, -2942, -2942,
    1961,    76, -2942, -2942, -2942,  4070, -2942, -2942,  2001,    13,
   -2942, -2942, -2942,   117, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942,  1606, -2942, -2942,    92, -2942,  1453, -2942, -2942,    39,
   -2942, -2942, -2942, -2942, -2942, -2942,  1584,  7107, -2942,  1602,
    1963,  2074, -2942, -2942, -2942, -2942,  1196, -2942,  1660, -2942,
   -2942,  7989,  1613, -2942, -2942,  1966,   -41,  1964,   -43, -2942,
    1907, -2942,  1968,  1695,  1561,  1971, -2942,  1907,  1374,  1977,
    1569, -2942, -2942,  1908,  3900,  1959, -2942, -2942, -2942, -2942,
   -2942, -2942,  1838, -2942,   117, -2942, -2942, -2942,  1765,   -84,
   -2942,   236,  2118, -2942,   121, -2942,  1985,  1384,  6110, -2942,
    9826,  1617, -2942,  1986,  6886, -2942,  2032,  1374,  1374,  1987,
    6941,  1453, -2942, -2942,  -174, -2942, -2942, -2942, -2942,  4662,
   -2942,  1935, -2942, -2942,  1466, -2942,  1992,  2037, -2942, -2942,
    1993,  1907,  1642,  1718,  1872,  1596,  1596,  1596,   349,  1653,
    7974, -2942, -2942, -2942,  1609, -2942, -2942, -2942,  1829, -2942,
      88, -2942,   959, -2942,   253, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
     621, -2942,   102, -2942,   730, -2942, -2942,  1805, -2942, -2942,
   -2942, -2942,  1564,  1726,  1897, -2942, -2942, -2942, -2942,  1134,
    1564,  1611,  1928, -2942,  1965,  1028,  1965,  1665, -2942, -2942,
    1666,  2075, -2942,  1769, -2942,    88, -2942, -2942, -2942, -2942,
   -2942,  1672,    90,   466, -2942, -2942, -2942, -2942,  1564, -2942,
   -2942,   119, -2942,  -201,   519,   218, -2942, -2942, -2942, -2942,
   -2942,  8559, -2942,  2092,  1200, -2942,   -35, -2942,  1679,  9826,
    9826,  9275, -2942, -2942, -2942,  1568, -2942,  1619,  1623,  9826,
    9826,  9826,  3900,  1624,  1685,  3900, -2942, -2942, -2942,  7205,
    1976, -2942,   897,  9826, -2942,  3900,  9826, -2942,  1568, -2942,
   -2942, -2942,  -224, -2942,  1958,  9826,  9826,  9826,  9826,  9826,
   -2942,  1780, -2942,  1827,  1926, -2942, -2942,  4560, -2942,  1374,
     918, -2942, -2942, -2942,  1183,     0,  1374, -2942, -2942, -2942,
   -2942, -2942,  9826,  1911, -2942,  1617, -2942,  1456, -2942, -2942,
   -2942, -2942,  1791, -2942, -2942, -2942, -2942, -2942, -2942,   184,
   -2942,  1637, -2942, -2942, -2942, -2942, -2942,  1886,  2045, -2942,
   -2942,  5625,   127,  1673,  1651,    67,    67,    67,    67, -2942,
   -2942,  7107,  7205,  1662, -2942, -2942,  1047,   192, -2942,  1661,
   -2942,  1669, -2942, -2942,   472, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942,  5503, -2942, -2942, -2942,  2892, -2942, -2942,
   -2942,     6, -2942,  2099,  1412,  2040, -2942,  3900,   103, -2942,
   -2942,  1832, -2942, -2942,   106,  9826, -2942,  1732,   117, -2942,
   -2942,  7205, -2942,  1670,  1791,  1717, -2942,  1025,  1025,  1365,
   -2942,  2018,  2018,  -247,  1743,  1746, -2942,   480, -2942, -2942,
    1751, -2942, -2942, -2942, -2942, -2942,  1695, -2942, -2942, -2942,
   -2942,  2009,  2580, -2942, -2942, -2942,  2011, -2942, -2942, -2942,
    1791,  2124, -2942, -2942,  1374,  2124,  1374,  1670,   195,  1754,
   -2942, -2942,  1568, -2942,  1758, -2942, -2942,   322,  1759,  1434,
   -2942, -2942,  4740, -2942,  2225,   907,   145, -2942, -2942, -2942,
    1564, -2942,   561,  7107, -2942, -2942,   707,    43,  1240,  9826,
   -2942, -2942, -2942,  1374, -2942,  2230, -2942,  2060,  2061, -2942,
   -2942,  7205, -2942, -2942, -2942, -2942,  3900, -2942, -2942, -2942,
   -2942, -2942,  2230,  2025, -2942, -2942,   983, -2942,  1761,  1835,
    1998, -2942, -2942, -2942,  1875,  1764, -2942,  1770, -2942, -2942,
   -2942,  2197, -2942,  1087, -2942, -2942,  1773, -2942, -2942, -2942,
    2269,  1772, -2942, -2942, -2942, -2942,   621, -2942,  2007,  1897,
   -2942, -2942, -2942,   477, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942,  1991, -2942, -2942, -2942,   912, -2942,
   -2942, -2942,  1909, -2942,  2222, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942,  1044, -2942,  1564,  1833,  1952, -2942,
   -2942, -2942,  2191,   421, -2942, -2942,  1564,  1317,  8559, -2942,
   -2942, -2942,   895,  1798,  8931, -2942, -2942,  1317, -2942, -2942,
   -2942,  1727,  1729, -2942,  3900,  1317,  2047,  1837,  1975, -2942,
   -2942,  2008, -2942, -2942, -2942, -2942, -2942, -2942,   550, -2942,
    1374,   312,  1170,  1806,   352,  1807, -2942,   362,  1808,  3900,
   -2942, -2942,   345,  1810,  1811,  1812,   392, -2942,  1568, -2942,
    1813, -2942,  1374,   393,  1814,  1717,   260, -2942,   327,   -53,
     117, -2942,  1312,  1816,   397, -2942,  1819,  1780,  -211,  -211,
   -2942, -2942, -2942,   117, -2942,  1820,   476, -2942, -2942,   594,
    2298,  -137, -2942, -2942,  1906, -2942,  1927, -2942,  1007,  1564,
   -2942, -2942, -2942,  1677,  1124, -2942, -2942, -2942,  2076, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942,   151, -2942, -2942,
    3501, -2942, -2942,  2968,  1374, -2942, -2942, -2942, -2942, -2942,
   -2942,  2112,   260,  2114, -2942, -2942, -2942, -2942, -2942, -2942,
    2327, -2942,  1831,   284, -2942, -2942,   192, -2942,  1760,  2892,
   -2942, -2942, -2942, -2942, -2942,  1512, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942,  1995, -2942, -2942, -2942,  2196, -2942,
    1512, -2942, -2942, -2942, -2942, -2942, -2942, -2942,  1937,  1512,
   -2942,  1839, -2942,  2305, -2942, -2942, -2942,  4276, -2942,  3900,
    8207, -2942, -2942, -2942,  2219,    64,   231,     3,   117,   117,
     260,  2130,   175,  1456,  1025,  1836, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942,  2120,  8090,    -4,  2171,  1374,   476, -2942,
     983,  2011,  1374, -2942, -2942, -2942, -2942,  1374,   948,   606,
   -2942,  1786, -2942,  1792, -2942,   983,    21,  3900,  2017,  1098,
     564, -2942,   550,  2023, -2942, -2942, -2942,  7107,  1434,  1434,
    1434,  1434,  1434,  1434,  1434,  1434,   907, -2942,   671,  1124,
     711, -2942,  1890,  1890, -2942, -2942, -2942,  9826,  9300,  1240,
     642,  6984,  1374,  1374,   260,  2149,  1897,  1861,  2374,  1374,
     450, -2942, -2942,  1791,  2382,   311, -2942,  1867,  1942,  1973,
    1821,  1235,  1374, -2942, -2942, -2942,  1235,  2299,  1564,  1516,
    1516,  1564,    10,  1711,  1564,  2371, -2942,  2048, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,    88,   107,
    2234, -2942,  1891, -2942,  2186, -2942,   621, -2942, -2942,    48,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942,   856,  1564, -2942, -2942,  1818,
    1883, -2942, -2942, -2942, -2942, -2942,  2355, -2942, -2942, -2942,
   -2942, -2942,  1591, -2942,  1608, -2942, -2942, -2942, -2942,  2065,
    2065, -2942, -2942,  2065,   589, -2942,  1564, -2942, -2942, -2942,
   -2942,  1564, -2942, -2942, -2942, -2942, -2942,   199, -2942, -2942,
   -2942,  2346,  1939, -2942, -2942, -2942, -2942,    47, -2942,  1564,
   -2942,  2404, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942,  1317, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942,  1644,  9417,  1565,  9443,  1565, -2942, -2942, -2942,  1374,
    1565,  1565,  1565,  3900, -2942,  1644,   -75,  1565,   -35, -2942,
   -2942, -2942,  2078,  1943,   451,  2185,   260,  9741,  1565,  1565,
     630, -2942, -2942, -2942, -2942, -2942,  2018, -2942, -2942, -2942,
   -2942, -2942,  2088, -2942, -2942, -2942,   466, -2942,  9826, -2942,
   -2942, -2942, -2942,  2082,  2155,   591,  1673, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942,  1564, -2942,   599, -2942, -2942,
    1506,  1564, -2942, -2942, -2942, -2942,   150,  1564, -2942, -2942,
   -2942, -2942,   272,   272,   117, -2942,   117,    78,   192, -2942,
   -2942, -2942,  2327, -2942, -2942, -2942,  1374, -2942, -2942, -2942,
    2276,  1848,  1380,    26,  1849,   630,  3900, -2942, -2942,  2376,
   -2942,  1498, -2942, -2942,  8207, -2942,  1498,  2210,  2213, -2942,
    1969, -2942, -2942,  1564, -2942, -2942,  2162,  2072, -2942, -2942,
     117, -2942,   117,  2071,  2071,  2079, -2942,  1049, -2942, -2942,
   -2942,  1374, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
    2425, -2942,  2214, -2942, -2942,   120,    94, -2942, -2942, -2942,
   -2942,  2103,  2290,  1124, -2942,  1278, -2942, -2942, -2942, -2942,
    1792,  2024, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942,  7107, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942,   135, -2942,  1374, -2942, -2942, -2942,   681,
   -2942, -2942, -2942,  9826, -2942,  7107,  7107,  1170, -2942,   927,
    -109,  2066, -2942, -2942, -2942,  1644,  1644, -2942,   117,  1923,
   -2942,   630, -2942,  2086, -2942,  3900, -2942,  2322,  1946, -2942,
     606, -2942,   687, -2942, -2942, -2942,  1933,  1997,  2015,   838,
   -2942,  1887, -2942,  2231,  1948,  8645,   200,  2235, -2942,  1897,
    1868,  1564,  2371,  1882,   915,   608,  1897,  1889,  1564, -2942,
   -2942, -2942,   -49,  1558, -2942, -2942, -2942,  1944, -2942,  2331,
   -2942,  2299,  1456,  2451, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942,   783, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942,   421,   421,   421, -2942, -2942, -2942,
   -2942,   421,   421, -2942, -2942,  1564,  1564,   564,   564,   421,
   -2942,   589, -2942,  -104, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942,  2248, -2942, -2942, -2942,  2242, -2942, -2942,
   -2942, -2942, -2942, -2942,  2243, -2942, -2942,  1268, -2942, -2942,
   -2942, -2942, -2942,  1662,  2340, -2942,  1199, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942,  3541,   421, -2942, -2942,  1717,
   -2942, -2942, -2942, -2942,   700,   421,   564,   564,   421,  1090,
    1897,  2269, -2942,  2906, -2942, -2942, -2942, -2942,  2794,  2906,
     260,  2064,   260,  2067,  5954, -2942,  -125,    17, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942,  1380, -2942,  2362, -2942, -2942,
    1512, -2942,  1498, -2942,  1498,   630,  1945,  1945, -2942,  2473,
    2444, -2942, -2942, -2942, -2942,   -60,  1374, -2942, -2942, -2942,
     260, -2942, -2942, -2942, -2942, -2942, -2942, -2942,  1341, -2942,
    2325,  1374,  7107,  1995,  2189,  2220, -2942,   626, -2942, -2942,
   -2942,   539, -2942, -2942, -2942,  2378,  2165, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942,  2194, -2942, -2942, -2942,  2212, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942,  1170, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942,  2156,  1970,  1564,  -104,  2248,
     260,  1934, -2942,  2374, -2942,  2120,  2399,  2120,  -109,  1106,
   -2942, -2942,  1645,  2450,   311, -2942,  1989,  2063, -2942,  1638,
    1564, -2942,  1374, -2942,  1129, -2942, -2942,  -204,   473,   547,
     787,   964,  1936, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942,  1039, -2942,  2077, -2942,    96,
   -2942, -2942, -2942, -2942,  1374,  2254, -2942, -2942, -2942,   845,
   -2942, -2942, -2942,  1564, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942,  1329,   -57, -2942,  1938, -2942,  1638, -2942,  1999, -2942,
    2296, -2942, -2942, -2942,  1882, -2942, -2942, -2942, -2942, -2942,
   -2942,  2233,    53,  2120,   674,  1564, -2942, -2942,  1564, -2942,
   -2942,  1711,  1695,   720, -2942,  2062,  1564,  2461,   819,   181,
       8,  1670, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942,  2049, -2942,  2236, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942,  2491,  1564,  1456,  1456,   621, -2942, -2942,   237,
   -2942, -2942, -2942, -2942, -2942,   591,   421, -2942,  1652, -2942,
   -2942, -2942, -2942,  2286,  2409, -2942,    13, -2942, -2942, -2942,
     272, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942,  1374, -2942,  1564, -2942, -2942, -2942,   117, -2942,   117,
   -2942, -2942,  7107, -2942, -2942, -2942, -2942, -2942, -2942,  2486,
    2418, -2942, -2942,  1498, -2942,  7107,  7107, -2942, -2942,  2153,
    1456,   754, -2942,  1374, -2942, -2942,  2108, -2942, -2942, -2942,
    2493,  2250, -2942,  1564,  1232, -2942, -2942,   682,  2251,  2252,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,  1374, -2942,
    2409, -2942, -2942, -2942,  2021, -2942,  1374,  2120, -2942,  1374,
   -2942, -2942, -2942, -2942, -2942,  2215,  2373, -2942, -2942, -2942,
   -2942,    88, -2942,   311, -2942,   311, -2942,  2029, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942,  2039, -2942,  1638,
   -2942,  1922, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942,  1974,  1118, -2942,
   -2942,  2504,  2012,  2041, -2942, -2942, -2942, -2942, -2942,  9225,
    2535,  2109,  2109, -2942,  1638,  1897,   337,  1374, -2942, -2942,
   -2942, -2942,  1897, -2942,  1581, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942,   619,   619,  1564,  2162, -2942, -2942,  1104,
   -2942,  1160,  1564,  1564,  1564,  1564, -2942,   977, -2942,   175,
    1564,  1711, -2942,  2106,  1868,  1456, -2942,  2192, -2942,    15,
   -2942, -2942, -2942, -2942, -2942, -2942,   564,  2286,  -104,   -14,
     162,  2906, -2942,  1374,  -104,  -104, -2942, -2942, -2942, -2942,
   -2942,  7107, -2942, -2942, -2942, -2942,  1564,  1456,  1456,  2187,
   -2942, -2942, -2942,  7107, -2942,  1374, -2942, -2942,  2103,  2290,
   -2942, -2942, -2942, -2942,  -104,  1446, -2942, -2942,  1374, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942,   631,   929, -2942, -2942,  1717, -2942, -2942,  1638, -2942,
   -2942,   625,  2280, -2942, -2942, -2942, -2942, -2942,  2120,  2354,
    2059,  1897,  2059, -2942,  2288, -2942,  2461, -2942, -2942, -2942,
   -2942, -2942, -2942,  1374, -2942,    80,  1768,  1275, -2942, -2942,
   -2942, -2942,   758,  1564, -2942, -2942,  2714, -2942, -2942,   608,
    2098,  1374,  1374, -2942, -2942, -2942, -2942,  1374,  1564, -2942,
   -2942, -2942,  1897, -2942,  2463,  2068,   564, -2942, -2942, -2942,
   -2942, -2942,  2246,    20,  1717, -2942, -2942, -2942, -2942, -2942,
    1374, -2942, -2942, -2942, -2942,   476,  1456,  1564,  2027, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
    1621, -2942, -2942, -2942, -2942, -2942,  2199,  2469, -2942, -2942,
    2193,   827, -2942,  2127, -2942,  2069,  1374, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942,  2013,  1897,  2081,
   -2942,  2466, -2942,  2467, -2942, -2942, -2942,   608,   608, -2942,
   -2942, -2942, -2942,  2381, -2942, -2942,  1999,  1897, -2942, -2942,
   -2942, -2942,  1374, -2942, -2942, -2942, -2942, -2942,   661, -2942,
   -2942,   661,  2590, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
     661,   661,   661,   676, -2942, -2942, -2942,  -190, -2942, -2942,
     829, -2942,  2080,   564, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942,  1374, -2942, -2942,   476, -2942,  2181,  2122,   277,
    1995,   197,  1453, -2942,  7619, -2942, -2942,   827,  2087,  2084,
    1564, -2942, -2942, -2942,  1897,  2352,  1995,  1995,   967, -2942,
   -2942,  2574,  1768, -2942,   -17, -2942, -2942, -2942, -2942,  1773,
   -2942, -2942, -2942, -2942, -2942, -2942,  1564,  1374,  2030, -2942,
    2030, -2942, -2942, -2942, -2942, -2942, -2942,  1374, -2942,  1563,
   -2942, -2942, -2942,    85, -2942, -2942,  -133, -2942,  2090, -2942,
    2095, -2942, -2942,   631, -2942,   967,  1374,  1374,  2230, -2942,
    2360, -2942,   231,  2162,   873,   608,  2487,  2123, -2942, -2942,
    1374,  1374,   604, -2942, -2942, -2942, -2942, -2942,  2237,  1368,
      85, -2942, -2942,   759,   740,   140, -2942, -2942, -2942, -2942,
   -2942,   967, -2942,  2042, -2942, -2942,  1564,   231, -2942,  1995,
   -2942,  2036, -2942,  1374,  2271, -2942, -2942,  1995, -2942, -2942,
    2275,  1374, -2942,   246,  2359,  2361,  2510,  2364, -2942,   759,
   -2942,  1327,   780,  2107,   221,  8956, -2942, -2942,  2042, -2942,
    1374, -2942,  1374,   108,  1099,   760, -2942, -2942,  1564,  2293,
    1374,  1564,  1564,  1564,  1564, -2942,  2380,    59,  2384, -2942,
    2372, -2942,  1307, -2942, -2942,  1374,  2534,  1064,  2385,    77,
    2386,  2379, -2942,   634, -2942, -2942,  1374,  2143, -2942,  1564,
    1564,  2371,  1344, -2942, -2942, -2942, -2942,  2431,  2464, -2942,
    1564, -2942,   511, -2942,  1506,  1564,  2580, -2942, -2942, -2942,
   -2942,  2065, -2942,  2520,  1897, -2942,  2602, -2942, -2942, -2942,
    1374, -2942, -2942,  1374, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942,  2436,  2065, -2942,  1374, -2942,
     897, -2942, -2942, -2942,  1540, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942,  1456,  1374,  1897, -2942,  1374,  1374,  1374,
    1374,  1564,  1564,  1564,  1564,  1564, -2942,  1374,  1564,  1564,
    1564,  1564,  1564,  1564,  1564,  1564,  1564,  1564,  1564, -2942,
    1374,  1564,   591, -2942, -2942,  1564,  2371,  2377,  2085, -2942,
   -2942, -2942,  1374,   421, -2942, -2942, -2942, -2942,   421, -2942,
   -2942,  1564,  2059,  1564, -2942, -2942, -2942, -2942,  1564, -2942,
   -2942, -2942,  2059, -2942, -2942, -2942, -2942,  1374,  1374,  1374,
    1374,  1374,  1374,  1374,  1374,  1374,  1374,  1374,  1374,  1374,
    1374,  1374,  1374,  1374,  1374,  1374, -2942, -2942, -2942, -2942,
    1683,   -73, -2942,  1374, -2942, -2942,   595, -2942,   591,   595,
    2360, -2942, -2942, -2942, -2942, -2942,  1374, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,  1374, -2942,
    1281, -2942, -2942,  2377, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942,   421, -2942, -2942, -2942,   421, -2942, -2942,  1374,
    1374,   189,  1564,  1564,  1604, -2942, -2942, -2942, -2942, -2942,
   -2942,  1902, -2942, -2942, -2942,  1374, -2942, -2942, -2942,  1564,
    2377,  2377, -2942,  2429,  1564,  1564, -2942,  3285,  1374,  2377,
   -2942, -2942, -2942,  2377,  2377,  2419,  1350,  2371,  2434,  1897,
    2093,  1564,  1717, -2942,  1564,  1564,  1374, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
    1187, -2942,   690, -2942, -2942, -2942,  1350,  2371,  1374, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942,   838, -2942,  1564,  2081,
   -2942, 10087, 10087,  1876,  2541,  2454, -2942,  1897,  1187, -2942,
   -2942,  1897,   690, -2942, -2942,   838, -2942,  1374, -2942,  1187,
    2059, -2942,  1644,  9858, -2942, -2942,  1450,  1534, -2942, -2942,
    1547, -2942, -2942, -2942, -2942,   -50,   -50, -2942, -2942, -2942,
   -2942, -2942, 10087, -2942, -2942, -2942, -2942, -2942,  1374, -2942,
    2467, -2942,  1995, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
    2319, -2942,  2319, -2942,  2627, -2942,  2198,    89,  2313, -2942,
   -2942, 10087,  1897, -2942, -2942, -2942, -2942, -2942, -2942, -2942
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       2,     0,    12,     1,     3,     5,    23,     4,    65,    26,
      25,    23,     8,    10,    11,     0,     0,     0,    13,   339,
      81,     9,    30,    27,    48,    48,     0,     0,     0,   841,
     341,     0,   218,    68,     0,     0,     0,    65,    65,    24,
      66,     0,     0,    22,   887,     0,   343,     0,     0,    64,
     220,     0,     0,     0,  2250,  2197,  2197,  2197,     0,     0,
       0,     0,  2197,     0,     0,  2166,   156,    67,    69,    70,
      73,    85,    86,    75,   117,   138,   136,     0,   142,   144,
     145,   146,   192,   148,   147,   149,   150,   151,   152,   153,
     154,   155,     0,     0,    51,    16,     0,   340,  1055,     0,
       0,     0,   337,    82,     0,     0,   224,  1882,  1881,   167,
    2197,  2197,  2251,  2197,  2198,     0,     0,     0,  2197,  2197,
      95,   119,     0,    89,   137,  2167,     0,  2197,    72,   117,
      87,    88,   133,    83,   117,    74,   118,   135,   139,     0,
     140,   143,     0,   191,    33,    32,    36,    36,     0,    49,
      53,     0,    14,    17,    18,     0,    15,  1059,  1056,  1057,
    1058,   843,     0,   947,  1028,  1038,  1044,  1051,  1098,  1104,
    1124,  1119,  1125,  1130,  1126,  1138,  1148,  1225,  1234,  1236,
    1239,  1265,  1276,  1279,  1282,  1274,  1288,  1299,  1321,  1325,
    1364,  1366,  1370,     0,  1376,  1391,  1415,  1417,  1447,  1448,
    1464,  1467,  1468,  1473,  1482,  1483,  1496,  1509,  1548,  1566,
       0,  1603,  1617,  1626,  1628,   869,  1632,  1635,  1638,  1689,
     889,   890,   891,   892,   893,   894,   895,   896,   898,   897,
     899,   901,   900,   902,   903,   904,   905,   906,   907,   908,
     909,   910,   911,   912,   913,   914,   915,   916,   917,   918,
     919,   920,   921,   922,   923,   924,   925,   926,   927,   928,
     929,   930,   931,   932,   933,   934,   935,   936,   937,   938,
     939,   940,   941,   942,   943,   944,   888,   342,   349,   350,
     463,   344,   466,     0,   219,   221,   222,  2197,     0,     0,
       0,  1966,   213,  1874,   211,   216,     0,     0,    97,   121,
     215,    91,  1883,   194,   195,  2199,   198,  1971,  1520,  1519,
     157,   161,   164,  2233,  2197,     0,    76,    71,   118,    77,
     134,    78,    84,    79,    80,   141,   193,     0,     0,    28,
    2222,  2197,    58,    35,    34,     0,    19,     0,   846,   844,
     863,  2073,  2074,  2075,  2076,  2077,  2078,  2079,  2080,  2081,
    2082,  2083,  2084,  2085,  2086,  2122,  2123,  2124,  2125,  2126,
    2127,  2128,  2129,  2130,  2131,  2132,  2133,  2134,  2135,  2136,
    2137,  2138,  2139,  2140,  2141,  2142,  2087,  2088,  2089,  2090,
    2091,  2092,  2093,  2094,  2095,  2096,  2097,  2098,  2099,  2100,
    2101,  2102,  2103,  2104,  2105,  2106,  2107,  2108,  2109,  2110,
    2111,  2112,  2113,  2114,  2115,  2116,  2117,  2070,  2118,  2119,
    2120,  2121,   946,  2071,  2072,     0,     0,     0,     0,  1055,
       0,     0,     0,     0,     0,  1143,     0,     0,  1143,  1055,
    1783,  1267,     0,     0,  2273,  1083,  1082,     0,  1287,  1783,
       0,     0,     0,     0,     0,     0,   945,     0,  1773,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1599,  1602,  1586,  1600,  1778,  1601,  1588,  1597,  1589,  1598,
    1954,  1958,     0,     0,  1627,  1625,     0,   887,     0,     0,
       0,     0,     0,   410,   345,  2033,     0,  1859,   346,     0,
    2049,   318,   225,     0,  1978,  1974,  1979,  1977,  1975,  1980,
    1976,   202,   203,   205,   214,   209,  2294,  2295,     0,   207,
       0,  2165,     0,  2257,     0,  2197,  2317,   115,    96,  2164,
     101,   103,   104,   105,   106,  2164,     0,  2197,     0,     0,
     120,     0,   124,    90,    93,   196,  2201,  2200,   199,     0,
    2233,  2236,  2235,     0,     0,   158,   162,    37,    31,  2197,
    2223,  2197,     0,     0,     0,    20,    21,   851,   851,     0,
       0,   971,  1966,  1026,   949,  2220,   970,  2229,     0,  2010,
       0,  2005,  2011,     0,     0,  2017,  1989,     0,     0,  1844,
    1846,  1985,     0,     0,     0,  2008,  1990,  1905,     0,  1848,
    1988,  2009,  1986,  2012,  2013,     0,  1991,     0,  2007,  2017,
    2006,  1987,  1036,  1899,  1034,  1891,  1894,  1893,  1897,  1981,
    1983,  1898,  2014,     0,     0,     0,     0,     0,     0,  1039,
       0,  1833,  1836,  1838,  1841,  1914,  1843,  2038,  1912,  1913,
    1871,  1045,  1046,     0,  1867,  1869,  1868,  1096,  1773,  1930,
    1103,  1099,  1100,  1102,  1929,  1115,  1105,  1106,  1107,  1110,
    2229,  1122,     0,  1850,  2052,  1886,  1961,  1965,  1887,     0,
    1136,  2243,  2170,  1127,  1959,  1129,  2267,     0,  1145,  1147,
    1139,     0,  1192,  1191,  1985,  1165,  1190,  1183,  1189,  1182,
    1223,  1718,  1889,  1160,  1162,  1155,  1179,  1156,  1157,  1192,
    1159,     0,  1893,  1232,     0,  1235,     0,  1237,  1246,  1245,
    1263,     0,  1242,  1244,  1782,  2197,  1269,  1273,  1271,  1274,
    1272,  1266,  1277,  1278,  1884,  1280,  1281,  2274,  1283,  1865,
    1275,  1293,  1781,  1300,  1302,  1861,  1322,  1323,  1326,     0,
    1328,  1329,  1330,  1365,  1552,  1948,  1949,     0,  1367,     0,
    1374,     0,  1384,  1381,  1383,  1382,  1377,  1378,  1385,  2185,
    1392,  1403,     0,  1860,  1416,  1445,  2044,  1462,     0,  1465,
    1692,  1853,  1471,  2243,     0,  1480,  1854,  1692,     0,  1494,
    1487,  1856,  1497,  1500,     0,     0,  1864,  1510,  1511,  1512,
    1513,  1514,  1515,  1539,  1516,  1542,  1517,  1518,     0,     0,
    1862,     0,     0,  1947,  1965,  1549,  1584,  1571,  1590,  1777,
       0,  1956,  1957,  1615,     0,  1606,  1609,     0,     0,  1623,
       0,  1629,  1630,   875,   881,   870,   871,   872,   874,     0,
    1633,     0,  1951,  1636,  2245,  1932,  1655,  1641,  1931,  1933,
    1703,  1692,     0,     0,   670,     0,     0,     0,   468,     0,
       0,   472,   473,   471,     0,   348,   351,   223,     0,  2050,
       0,   330,   326,   217,     0,   321,   323,   324,   173,   172,
     187,   183,   188,   169,   186,   184,   170,   171,   185,   168,
     174,   175,   177,   204,     0,  2283,   208,     0,  1967,   212,
    2316,  2258,  2197,     0,     0,   100,   102,    98,   116,  2164,
    2197,     0,     0,   131,    36,     0,    36,     0,   122,   125,
       0,     0,  1972,   197,   200,     0,  2234,   165,   159,   160,
     163,     0,     0,     0,    55,    57,    56,    54,  2197,    50,
    2163,   851,   848,   854,     0,   851,   864,   865,   838,  1027,
     948,   972,  2221,     0,     0,  2230,     0,  1982,     0,     0,
       0,     0,  2003,  2023,  1900,  1901,  1902,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2004,  1037,  1029,     0,
       0,  1892,     0,     0,  1992,     0,     0,  1915,  1916,  1917,
    1840,  1911,     0,  1839,  2040,     0,     0,     0,     0,     0,
    2039,  1042,  1047,  1049,     0,  1097,  1052,  1062,  1101,     0,
    1110,  2307,  2308,  1108,     0,  1111,     0,  1123,  1120,  2291,
    2290,  1851,     0,  2054,  1852,  1963,  1964,  1133,  1134,  1137,
    1131,  2244,  1430,  2171,  1128,  1960,  2268,  1144,  1146,  1141,
    1193,     0,  1224,  1149,   884,   884,  1154,  1724,  1721,  1161,
    1158,  1890,  2282,  1194,     0,  1718,  1718,  1718,  1718,  1233,
    1226,     0,     0,  1066,  1264,  1240,  1783,  1783,  1241,  1248,
    1249,   884,  1799,  1797,  2198,  1803,  1800,  1792,  1796,  1794,
    1795,  1791,  1793,  1784,  1785,  1798,  1787,     0,  1270,  1268,
    1885,  1285,  1294,  1295,  1304,     0,  1324,     0,  1351,  1335,
    1327,  1332,  1333,  1334,  1556,     0,  1950,     0,     0,  1375,
    1371,     0,  1379,  2282,  1430,  2229,  1405,     0,     0,  1871,
    1935,  1775,  1775,     0,  1401,     0,  1934,  1868,   485,  1936,
       0,  1774,  1446,  1418,  2045,  2046,  2243,  1463,  1449,  1451,
    1452,     0,     0,  1466,  1472,  1469,  1420,  1855,  1481,  1474,
    1430,  1489,  1495,  1484,     0,  1489,     0,  2282,  1498,     0,
    1922,  1924,  1925,  1926,     0,  1540,  1543,     0,     0,     0,
    1863,  1522,     0,  1521,     0,     0,  1963,  1585,  1567,  1573,
    2197,  1574,  1569,     0,  1587,  1592,     0,  1828,  1826,     0,
    1955,  1616,  1604,     0,  1607,  2162,  1608,     0,     0,  1624,
    1618,     0,  1631,   876,   880,   873,     0,  2246,  2247,  1637,
    1656,  1639,  2162,     0,  1704,  1690,  1694,   464,     0,     0,
     673,   482,   514,   517,     0,     0,   469,     0,   479,   480,
     474,   481,   477,  2197,  2051,   226,  2176,   327,   328,   329,
    2149,     0,   319,   322,   176,   179,     0,   206,     0,     0,
    2315,   109,    99,     0,  1875,   108,   126,   127,   130,   132,
     128,   129,   123,    92,     0,   201,   166,    29,    40,    43,
      47,    46,  2241,    41,    42,  2056,  2057,  2058,  2059,  2060,
    2061,  2062,  2063,    52,     0,   849,  2197,     0,   861,   859,
     852,   853,   866,  2157,  2159,   977,  2197,  1705,   973,   974,
     976,   978,     0,     0,     0,   969,   965,  1705,  2289,  2288,
     962,   954,   956,   957,     0,  1705,     0,     0,     0,   981,
     960,     0,   968,   951,   967,   952,  1919,  1918,     0,  1904,
       0,  1828,  1826,     0,  1828,     0,  2019,  1828,     0,     0,
    1845,  1847,  1828,     0,     0,     0,  1828,  1908,  1909,  1910,
       0,  1849,     0,  1828,     0,  2229,  1727,  1035,  1965,  1887,
       0,  1984,     0,     0,  1828,  1842,  2042,  1042,  1832,  1831,
    1835,  1834,  1837,     0,  1040,     0,     0,  1870,  1053,     0,
    1060,  1117,  1109,  1114,     0,  2181,     0,  1888,  1727,  2197,
    2053,  1962,  1135,  2180,  1763,  1431,  1432,  1140,     0,  1184,
    1723,   885,  1726,  1719,  1725,  1720,  1722,     0,  1171,  1170,
    1163,  1166,  1168,     0,     0,  1180,  1187,  1152,  1153,  1150,
    1151,     0,  1727,     0,  1067,  1238,  1243,  1258,  1260,  1259,
    1253,  1255,  1261,  1783,  1250,  1247,  1783,  1251,     0,  1802,
    1786,  1813,  1814,  1815,  1804,  2273,  1821,  1824,  1823,  1825,
    1817,  1810,  1812,  1811,  1816,  1818,  1820,  1822,  1788,  1805,
    1806,  1807,  1808,  1809,  2231,  1284,  1866,  1296,  1297,   884,
    2273,  1312,  1313,  1315,  1317,  1318,  1314,  1316,  1307,  2273,
    1303,     0,  1352,     0,  1354,  1353,  1355,  1337,  1347,     0,
       0,  1331,  2314,  2232,     0,  1558,     0,  2186,     0,  1368,
    1727,     0,     0,     0,     0,     0,   494,   490,   493,   492,
     491,   605,   607,   506,   502,   504,   505,   507,   503,   508,
     608,   606,   509,   510,   487,   498,   499,   500,   495,   496,
     497,   489,   486,  2184,  1403,  1394,  1783,     0,     0,  1404,
       0,  1420,     0,  1693,  1944,  1945,  1946,     0,     0,  1476,
     884,     0,  1488,     0,  1502,  1694,     0,     0,     0,     0,
       0,  1541,     0,     0,  1545,  1544,  1536,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1524,  1525,  2047,  1763,
       0,  1591,  2261,  2261,  1829,  1830,  1968,     0,     0,     0,
    1613,     0,     0,     0,  1727,     0,   882,     0,  2034,     0,
    1613,  1699,  1698,  1430,  2143,   466,   411,     0,     0,   676,
       0,   555,     0,   470,   476,   536,   483,  2168,  2197,     0,
       0,  2197,  2168,  2222,  2197,  2147,   347,     0,   352,   355,
     356,   357,   358,   359,   360,   361,   362,   363,     0,     0,
       0,  2177,  2265,  2150,  2180,   320,     0,   178,   210,     0,
     112,   114,   113,   110,   111,    94,    45,  2242,    39,    44,
      60,    61,    62,    63,    59,     0,  2197,   858,   862,     0,
       0,   839,  1939,   985,  1937,  1938,     0,  1711,  1712,  1716,
    1717,   950,  1713,   884,  1708,   884,   975,  2287,  2286,  2224,
    2224,   983,   984,  2224,     0,   990,  2197,   992,   993,   994,
    1025,  2197,   995,   996,   997,   998,   999,     0,  1019,  1020,
    1001,  1003,     0,  1004,  1023,  1021,  1022,     0,  1006,  2197,
     991,  2145,  1009,  1024,  1012,   979,  1000,  1005,  1011,   966,
     953,   955,  1705,   963,   958,   959,   982,   961,  1921,  1903,
    1920,  2052,     0,  2014,     0,  2014,  2018,  1996,  2024,     0,
    2014,  2014,  2014,     0,  1997,  2052,     0,  2014,     0,   884,
     884,  1030,  1733,  1730,  1963,  1964,  1727,     0,  2014,  2014,
       0,  2041,  1041,  1043,  1050,  1048,  1775,  1064,  1065,  1061,
    1063,  1116,     0,  1113,  1112,  1121,     0,  1435,     0,   884,
     884,  1132,  1764,  1770,  1767,     0,  1194,   887,  1177,  1178,
    1175,  1174,  1176,  1173,  1167,  2197,  1206,     0,  1209,  1210,
    2174,  2197,  1213,  1214,  1169,  1215,     0,  2197,  1218,  1216,
    1172,  1195,  2282,  2282,     0,  1227,     0,  1073,  1783,  1783,
    1257,   884,  1254,  1790,  1789,  1819,     0,   884,  1298,  1289,
    1292,     0,     0,  1319,     0,     0,     0,  1348,  1350,     0,
    1343,  1357,  1344,  1345,  1336,  1339,  1357,     0,  1924,  2313,
       0,  2285,  1550,  2197,   648,   649,  2205,     0,  2187,  1557,
    1369,  1372,     0,  2237,  2237,     0,  1386,  1387,  1857,   488,
     501,     0,  1393,  1399,  1400,   884,  1396,  1410,  1406,  1411,
    1407,  1412,     0,  1402,  1409,  1422,  1453,  1421,   884,   884,
    1470,  1752,     0,  1763,  1477,     0,  1490,  1783,  1783,  1485,
    1491,  1507,  1506,  1505,  1504,  1503,  1523,  1546,  1547,  1942,
    1943,  1535,     0,  1538,  1527,  1528,  1529,  1533,  1530,  1534,
    1531,  1532,  1526,  2048,  1583,     0,  1580,  1581,  1575,     0,
    1568,  2312,  2311,     0,  2262,  1595,  1595,  1827,  1969,     0,
    1736,     0,  1611,  1610,  1612,  2052,  2052,  1619,     0,     0,
     883,     0,  2035,  1642,  1643,     0,  1646,  1649,  1653,  1647,
    1476,  2144,     0,   465,   413,   671,     0,     0,   769,  2199,
     515,     0,   556,     0,   512,  2197,  2154,     0,  2169,     0,
       0,  2197,  2147,     0,     0,     0,     0,     0,  2197,   406,
    2148,   407,     0,     0,   408,   353,   354,     0,   227,  2243,
    2266,  2168,     0,   180,   181,  2302,  2304,  2303,   107,   855,
     856,   860,     0,   850,   867,   869,   989,  1706,  1714,  1710,
    1707,  1709,  1715,  2225,     0,     0,     0,  1973,   980,  1940,
    1941,     0,     0,  1018,  1010,  2197,  2197,  1779,  1779,     0,
    2146,     0,   964,  1727,  2030,  2001,  2032,  2002,  2028,  1998,
    1999,  2000,  2026,  2066,  2021,  2022,  1995,  1888,  1735,  1732,
    1728,  1734,  1729,  1731,  1962,  1031,  2015,     0,  1993,  1994,
    2043,  1927,  1928,  1066,     0,  2055,     0,  1769,  1772,  1765,
    1771,  1766,  1768,  1142,  1185,     0,     0,  1207,  1208,  2229,
     819,   821,  1211,  1212,     0,     0,  1779,  1779,     0,  2202,
       0,  2149,  1200,  1181,  1196,  1198,  1202,  1203,     0,  1188,
    1727,  1850,  1727,  1850,  1068,  1069,   854,     0,  1256,  1262,
    1252,  1286,  1291,  1296,  1305,  1308,  1309,  2172,  2270,  1301,
    2273,  1306,  1357,  1923,  1357,     0,  2193,  2193,  1342,  1358,
    1359,  1340,  1346,  1341,  2284,  1560,     0,  2206,  1554,  2188,
    1727,  2238,   315,   316,   317,  1390,  1380,  1858,     0,  1776,
    1397,     0,     0,  2231,     0,  1441,  1423,  1436,  1429,  1425,
    1438,     0,   884,   884,  1450,  1459,  1456,  1751,  1754,  1745,
    1753,  1746,  1475,  1478,     0,   884,   884,  1492,  2210,  1499,
    1537,  1582,  1572,  1576,  1577,  1578,  1579,  1570,  1593,  1596,
    1594,  1970,   884,   884,  1605,  1742,  1739,  2197,  1727,  2066,
    1727,   878,  1634,  2034,  1645,  2184,  1651,  2184,  1736,  1700,
    1697,  1696,  2212,   412,   466,   674,     0,     0,   338,     0,
    2197,   557,     0,   511,     0,   659,   561,  2252,  2252,  2252,
    2252,  2252,  2278,   562,   565,   566,   567,   568,   569,   570,
     601,   599,   600,   602,   603,   575,   571,  2248,   604,   630,
     572,   558,   573,   574,     0,  2255,   584,   585,   583,  2207,
     587,   588,   586,  2197,   537,   538,   539,   540,   541,   542,
     559,   563,   564,   543,   544,   545,   546,   547,   548,   549,
     550,     0,     0,  2155,     0,   516,     0,   484,   375,   284,
     403,  2305,  2306,  1878,   384,  1876,  2297,  2296,   377,  1880,
    1879,  2218,  2166,  2184,     0,  2197,   381,   380,  2197,   409,
     229,  2222,  2243,  2275,   300,     0,  2197,  2164,  2205,   302,
       0,  2282,   288,   228,   287,   231,   232,   233,   234,   235,
     236,     0,   237,     0,   238,   299,   239,   240,   241,   242,
     243,   244,  2160,  2197,     0,   325,     0,   857,   869,   887,
     986,   988,   987,  1014,  1013,     0,     0,  1016,     0,  1015,
    1008,  1017,  1032,  2189,  2068,  2016,  1077,  1118,  1434,  1433,
    2282,  1220,  2175,   820,   822,  1219,  1222,  1221,  1217,  2204,
    2203,     0,  1199,  2197,  1197,  1201,  1229,     0,  1228,     0,
    1070,  1071,     0,  1075,  1074,  1076,   884,  1310,  2173,     0,
       0,  1338,  1349,  1357,  2194,     0,     0,  1360,  1361,     0,
       0,  1563,  1559,  1553,  1373,  1389,     0,  1398,  1395,  1413,
       0,     0,  1426,  2197,  1763,  1424,  1437,     0,     0,     0,
    1440,  1461,  1458,  1454,  1460,  1455,  1457,  1479,  1486,  1493,
    2211,  1508,  1744,  1741,  1737,  1743,  1738,  1740,     0,  1621,
    2068,  1620,  1657,   877,     0,  1644,     0,  2184,  1648,     0,
    1640,   884,   884,  1691,  1702,  1760,  1757,  1701,  2213,  2214,
    1695,     0,   414,   466,   672,   466,   677,     0,   533,   535,
     534,   528,   532,   530,   531,   527,   529,   526,   665,   660,
     662,     0,   513,   668,   669,  2253,   598,   597,   590,   589,
     596,   595,   594,   593,   592,   591,  2279,     0,     0,  2249,
     656,   634,     0,   626,   551,  2256,  2208,  2209,   657,     0,
     553,  2064,  2064,   520,   519,     0,   365,     0,   402,  1877,
    2219,   386,     0,   368,  2257,   395,   397,   401,   400,   396,
     398,   394,   399,     0,     0,  2197,  2205,  2276,  2277,   267,
     303,  2243,  2197,  2197,  2197,  2197,   312,  2151,   313,     0,
    2197,  2222,  2161,     0,     0,   331,   332,   335,   182,   887,
    1002,  1007,  2309,  2310,  1780,  2190,     0,  2189,  1727,  1086,
    2195,  1186,  1205,     0,  1727,  1727,  1072,  1896,  1895,  1953,
    1290,     0,  1320,  1356,  1363,  1362,  2197,  1561,     0,     0,
    1551,  1555,  1388,     0,  1428,     0,  1419,  1444,  1752,  1749,
    1443,  1427,  1439,  1614,  1727,  1665,   879,  1650,     0,  1654,
    1759,  1762,  1755,  1761,  1756,  1758,   416,   415,   675,   679,
     770,     0,   666,   663,   523,  2229,   526,   518,   521,   524,
     658,   609,   616,   580,   577,   579,   581,   576,  2184,   628,
    2271,   631,  2271,   560,     0,   552,  2164,   618,   619,   376,
     367,   366,   364,   404,  1872,   385,  2166,   373,   382,   379,
     383,   378,     0,  2197,   269,   268,   265,   302,   298,     0,
       0,     0,     0,  2152,  2153,   311,   314,     0,  2197,   301,
     283,   333,     0,   334,     0,     0,     0,  1033,   884,   884,
     884,  1054,  1093,  1089,  2229,  2196,  1080,  1085,  1084,  1079,
       0,  1204,  1231,  1230,  1311,     0,  1564,  2197,     0,  1442,
    1747,  1748,  1750,  1622,  2157,  1688,  1687,  1666,  1658,  1659,
    2145,  1660,  1661,  1662,  1663,  1686,     0,     0,  1652,   418,
     678,   772,   664,     0,   661,     0,     0,   525,   610,   611,
     615,   614,   613,   612,   578,   617,   582,     0,     0,   626,
    2272,     0,   627,   632,   554,  2065,  1873,     0,     0,   387,
     388,   389,   390,     0,   369,  2183,   375,     0,   277,   278,
     276,   275,     0,   258,   259,   260,   254,   255,   272,   261,
     262,   272,     0,   263,   264,   253,   251,   252,   257,   256,
     272,   272,   272,     0,   304,   305,   306,   307,   310,   285,
       0,   336,     0,     0,  2069,  1091,  1095,  1092,  1087,  1094,
    1088,  1090,     0,  1078,  1562,     0,  1783,     0,  2259,     0,
    2231,  2180,     0,   680,     0,   776,   771,   773,     0,     0,
    2197,   522,   635,   629,     0,   636,  2231,  2231,   638,   393,
     392,  2156,  2166,   374,  2036,   273,   248,   274,   249,  2176,
     250,   246,   247,   270,   245,   271,  2197,     0,   294,   293,
     294,   290,   868,  2067,  1081,  1565,  1414,     0,  2260,     0,
    1684,  1683,  1682,     0,   417,   419,  2193,   681,     0,   777,
       0,   774,  2281,     0,   637,   638,     0,     0,  2162,   623,
     643,   644,   645,  2205,   642,     0,   371,   280,  2037,   266,
       0,   308,     0,   292,   291,  1685,  2293,  2292,  2239,  1678,
    1672,  1673,  1675,   440,     0,     0,   779,   780,   775,   667,
     625,   638,   633,     0,   639,   646,  2197,     0,   391,  2231,
     370,     0,   279,   309,     0,   297,  2240,  2231,  1681,  1676,
    1679,     0,  1674,  2197,     0,     0,     0,     0,   421,   441,
     442,   423,   451,     0,  2197,  2254,   624,   655,   652,   653,
       0,   641,     0,     0,     0,     0,  1680,  1677,  2197,     0,
       0,  2197,  2197,  2197,  2197,   443,     0,  2221,     0,  2264,
       0,   420,   424,   426,   425,     0,     0,     0,     0,     0,
       0,     0,   422,   452,   454,   453,     0,     0,   685,  2197,
    2197,  2147,  2215,   708,   684,   688,   689,     0,  2178,   795,
    2197,   784,  2278,   785,  2174,  2197,     0,   800,   793,   788,
     794,  2224,   789,     0,     0,   792,   802,   799,   797,   796,
       0,   803,   791,     0,   814,   808,   812,   811,   809,   813,
     781,   815,   810,   798,   790,     0,  2224,   654,   647,   372,
       0,   189,   190,   282,     0,  2300,  2301,   295,  1671,  1668,
    1670,  1669,  1664,  1667,     0,     0,   449,     0,     0,     0,
       0,  2197,  2197,  2197,  2197,  2197,   427,     0,  2197,  2197,
    2197,  2197,  2197,  2197,  2197,  2197,  2197,  2197,  2197,   455,
       0,  2197,     0,  2332,  2333,  2197,  2147,     0,   682,   686,
    2179,   690,     0,     0,   782,   783,   786,   787,     0,   817,
     804,  2197,  2271,  2197,   818,   816,   836,   805,  2197,   281,
     296,   444,  2271,   448,   446,   450,   445,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   687,  2216,  2217,   696,
     693,   478,   709,   691,   807,   806,   828,   835,     0,   832,
     650,   436,   432,   433,   437,   435,     0,   438,   428,   434,
     429,   430,   431,   460,   456,   457,   461,   459,     0,   458,
     692,  2298,  2299,   695,   710,   481,   825,   823,   826,   824,
     829,   830,     0,   801,   833,   834,     0,   447,   651,     0,
       0,     0,  2197,  2197,     0,   697,   698,   699,   700,   701,
     702,     0,   712,   827,   831,     0,   462,  2319,  2318,  2197,
       0,     0,  2321,     0,  2197,  2197,   694,  2254,     0,     0,
     707,   703,  2320,     0,     0,  2191,  2226,  2147,     0,     0,
       0,  2197,  2229,   711,  2197,  2197,     0,   717,   719,   728,
     720,   722,   725,   713,   714,   715,   724,   726,   729,   716,
       0,   721,     0,   723,   727,   718,  2226,  2147,     0,   704,
     706,   705,  2192,   767,  2227,  2228,  2199,   753,  2197,   626,
    1783,     0,     0,     0,     0,     0,   761,     0,   751,   757,
     760,     0,   754,   762,   765,  2199,   756,     0,   752,     0,
    2271,   749,  2052,   745,  1906,  2323,     0,     0,  2325,  2327,
       0,  2331,  2329,   730,   734,   738,   738,   732,   736,   731,
     737,   768,     0,   759,   758,   764,   763,   755,     0,   743,
     632,   766,  2231,   744,  1907,  2322,  2326,  2324,  2330,  2328,
     741,   733,   741,   735,     0,   439,   621,     0,     0,   740,
     739,     0,     0,   620,   748,   746,   747,   742,   750,   622
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -2942, -2942, -2942, -2942, -2942, -2942, -2942,  2669, -2942, -2942,
   -2942, -2942, -2942, -2942,  2529, -2942,  1634, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942,  2592,  2528,   -67, -2942, -2942, -2942,
    1441,  2666, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942,  1603,  2620, -2942, -2942,
   -2942,  2625, -2942, -2942,  2175,  -354, -2942, -2942, -2942, -2942,
   -2942,  2400,  1636,  1693, -2942, -2942, -2942,  2172, -2942, -2942,
    1546, -2942, -2942,  2629,   216,  1463, -2942, -2942, -2942, -2942,
    2159, -2942, -2942, -2942, -2942, -2942,  1840, -2942, -2942, -1173,
   -2942, -2942, -2942, -2942, -2942,  2403, -2942, -2942, -2942, -2942,
    2207, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942,  -962, -2942, -2942,
   -2942, -2942, -2942,   147, -2942, -2942, -2942, -2942, -2942,  -161,
   -2942,   161, -2942, -2942, -2942,   -69, -2942, -2942, -2942, -2942,
     156, -2942, -2942,  1862, -2942, -2942, -2942, -2942, -2942,   154,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942,   -56, -2942, -2942,
   -2942,   178, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942,  -269, -2942, -2942,
   -2942,  -234, -2942, -2942,  -276, -2942, -2942, -2942, -1509, -2942,
   -2942,  1888, -2942, -2264, -2942, -2643,  -810, -2942,  -729,  -853,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -1792, -2942,
   -2942, -2942, -2942, -1616, -2942, -2942, -2942, -2942, -2942, -2942,
     763, -2772,  -236,   211, -1924, -1910, -2942, -2942, -2193, -2942,
   -2942, -2942, -2659, -2942, -2942,  -609, -2942, -2942, -1896, -2942,
    -205,  -169, -2942,  1259, -2942, -2721, -2942,  -232, -2181, -2942,
   -2108, -2942, -1931, -2942,   453, -2198, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942,  -585,  -612, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -1571, -2942,  -559, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
     -91, -2942, -2942, -2942,  -275,  -274,  -422,  -421, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942,  2200,   889, -2942,   645,  1485, -2942, -2942, -2942, -2942,
   -1866, -2942, -2942, -2942, -2942, -2942, -2942, -2942,   364, -2942,
   -2942,   -31, -2942,  2655, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942,  1484, -2942,  -788, -2942, -2942,  -873, -2942,  -202, -1261,
    1077, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
    1418, -2942, -2942, -2942,  2135, -2942, -2942, -2942, -2942, -2942,
    1279, -2942, -2942, -2942,   704, -2942, -2942,   664, -2942, -2942,
    -765, -2942, -2942, -2942,    69, -2942,    71, -2942, -2942, -2942,
   -2942,  2133, -2942, -2942, -2942, -2942,  1785, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942,  2348, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942,  2097, -2942, -2942, -2942,  1387, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942,  2091,  1005, -1712, -1967, -2942, -2942, -2942,   684, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942,  1737, -2942, -2942,  1736, -2942, -2942,  1371,
     984, -2942, -2942, -2942, -2942, -2942,  2096, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942,   680, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942,   685,  1733, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942,  1714, -2942, -2942,   974, -2942,
    1334, -2942, -2942, -1714,   679,   688, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,  2070, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2463,  1296,
   -2942, -2942, -2942,   660, -2942, -2942, -2942, -2942, -2942,  1293,
   -2942, -2942, -2942,  -942,   938, -2942, -2942,   662, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,   655, -2942,
     653, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942,   872, -1078, -2942, -2942, -2942, -2942, -2942,
   -2942,  1688,   934, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942,  -251, -2942, -2942, -2942, -2942,
    1271, -2942, -2942, -2942,  2046, -2942,  2052, -2942, -2942, -2942,
   -2942,  2389, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942,   903, -2942, -2942, -2942, -2942, -2942, -2942,  2028, -2942,
   -2942,  1251, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942,   635, -2942,  1257, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,   -81, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -2942,   694,  1313,
    1322, -2942, -2942, -1092, -2942,  1179, -2942, -2942,  1188, -2942,
     949, -2942,  1823, -2942,  1825, -1294, -2942,  1110, -2942,  1107,
     651, -2942,   659, -2942,   665, -2942, -2942, -2942, -1800,   255,
   -1466, -2942, -2942,   395, -2942,   400, -1480,   657, -2942,  1093,
   -2942,  1095,  2232, -1021,  2414,  -483, -1497,  -392,  -978, -2942,
   -2942,  1828, -2942,  1830,  1457, -1270,   956,   958,   960,   962,
     840,   559,  -367,   745,   880, -2942,  1364,  -399,  -881,  -406,
    2433,  2405,  2128, -1922,  -277,  -227,  -464, -2942,  -749, -2942,
    -364, -1627,  1903, -1532,  -108,  1655, -2942,   596, -1296,   -37,
    2593,  -389,  -397, -2942,   517,  -330, -2942,   503, -2942,  -888,
   -1558, -2942,  1358,  -722,  -958, -2942,  1151,  -415,  1910, -2942,
   -1865,   871, -1503,  -123,  -437,  -537,  -395, -2942, -2942, -2942,
     173,  -568,  -203, -2942, -2942,  1930,  -582,  -586,  -127,  2005,
   -1632,  2038,  -418,    99,  -564,   911, -2942, -2942, -2942,   283,
    2314, -2942, -2942, -2942, -2942,   886, -2942, -2942, -2942, -2942,
   -2942, -2942, -2942, -2942, -2942, -2942, -2942, -1689, -2942,  1149,
     394,   718,   468, -2942, -2942, -2942, -2942,   190, -1923,   830,
   -2942, -2942, -2419, -2942, -2942, -1147, -2157, -2203, -1465, -2942,
   -2942, -2942,    63, -2942, -1343, -2942, -1469, -2942,   346, -2942,
   -2055, -2942,   -54, -1928, -2942, -2233, -2942, -2942, -2942, -2942,
   -2942,  2366, -1537, -1634,  -351,  -645, -1427,  2392,  1081, -2942,
   -2942,  -632, -2942, -2942, -2942,  -228, -2942,   402, -2942,  1377,
   -1990, -2942, -2942, -2942, -2564, -1341, -2942, -2942, -2942,  -409,
     945, -2072, -1691, -2942, -2942,  1133, -2942, -2942,  -126, -2942,
    1339, -2942, -2942, -2942,    87, -2942, -2941,  -350, -2942, -2942,
   -2942, -2942, -2942, -2942
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,     1,     2,     4,     5,     6,    11,    12,     7,     8,
      13,    14,   152,   153,   154,   156,    18,    15,    16,    24,
      35,   549,    25,    34,   146,   335,   328,   911,  1252,  1253,
    1254,    37,   149,   150,   332,   917,   554,  1644,    19,    20,
      32,    67,    68,    69,    33,   321,    70,    71,   301,   533,
     900,    72,   298,   518,   519,   520,   521,   522,   523,   524,
    1633,   525,   135,   318,   299,   530,   531,   532,   895,   319,
      74,    75,   137,    76,    77,    78,    79,   127,   310,   909,
     311,   312,    80,   287,   869,   870,   871,  1626,  1993,   872,
    3063,    81,   143,    82,   303,   304,   305,   903,    83,   501,
     502,    84,    85,   876,    86,    87,    88,    89,    90,    91,
      49,    50,   106,   491,   286,   492,  1620,  1988,  1989,  2325,
    2326,  2800,  2801,  2802,  2803,  2676,  2864,  2856,  2327,  2781,
    2328,  2942,  2329,  2290,  2330,  2331,  2332,  2333,  2871,  2913,
    2334,  2335,  2336,  2337,  2338,  2806,  2339,  2340,  2557,  2341,
    1856,   853,   854,   855,   856,  1220,   857,  1216,  2565,  2566,
    2693,    29,   280,    30,    46,   102,   281,   282,   846,   283,
    1213,  1608,  1609,  2662,  1610,  2940,  2776,  2526,  1611,  1612,
    2308,  2669,  1613,  1614,  2665,  2769,  2770,  2771,  2772,  1615,
    2541,  2542,  1616,  2528,  1617,  1618,  1983,   834,  1954,  2213,
    2472,  2473,  2739,  2831,  2885,  2991,  2992,  2993,  2994,  2958,
    2959,  2960,  3002,  3003,  3004,  3005,   483,  1585,   484,   485,
     838,   839,  1595,   840,  1209,  1210,  1211,  1966,  2487,  1504,
    1505,  1506,  1507,  1508,   841,  2223,   842,  1590,   843,  1591,
    2285,  2637,  2638,  2488,  1965,  2264,  2265,  2266,  2655,  1961,
    1962,  2268,  2269,  2270,  1509,  1510,  2754,  2756,  2273,  3259,
    3363,  2274,  2652,  2759,  2512,  2848,  2649,  2895,  2899,  2937,
    2900,  2901,  2902,  2903,  3207,  2904,  2968,  2969,  2275,  2276,
    2277,  2278,  1960,  2632,  2489,  2490,  2744,  2280,  1200,  2214,
    1589,  2475,  1958,  2629,  2740,  2833,  2925,  2964,  3014,  3015,
    3111,  3016,  3159,  3190,  3215,  3216,  3217,  3218,  3219,  3220,
    3108,  3162,  3222,  3237,  3263,  3264,  3323,  3351,  3359,  3265,
    3266,  3343,  3365,  3267,  3268,  3269,  3270,  3271,  3272,  3298,
    3299,  3302,  3303,  3273,  3274,  3275,  2218,  2741,  2836,  2837,
    2838,  2927,  2965,  3050,  2082,  2083,  3200,  3201,  3120,  3202,
    3127,  3206,  3051,  3052,    43,  1272,  2005,    44,   340,   558,
     557,   921,   922,   923,  1268,  1269,  1649,   560,  1651,  2348,
     477,   815,   816,  1576,  2453,   817,   818,  1939,  1380,  1381,
    1777,   819,   100,   220,   221,   415,   563,   931,   564,  1277,
    1278,  1279,  1303,  2092,  1671,  1672,  1281,  1705,  1706,  1799,
    1708,   930,   222,   416,   602,   960,   958,   223,   417,   619,
    1354,   224,   418,   631,   632,  1356,   225,   419,   637,  1756,
     161,  1358,  1359,  1759,  1405,  1807,  2104,  2105,  2106,  2579,
     437,  2709,  2701,  2820,  2702,  2818,  2703,   986,   226,   420,
     641,   642,   227,   421,   646,   647,   993,   648,   989,  1761,
     228,   422,   651,   998,   229,   230,   231,   424,   663,   232,
     423,   660,  1007,  1010,   233,   425,   670,  1377,   671,   234,
     426,   680,   681,   682,   683,  1032,   684,  1390,  1391,  1392,
    1782,   685,  1033,  1802,   686,   687,  1776,  2370,   688,  1803,
     689,  1021,  1395,  2093,  2094,  2095,  2096,  2097,  1800,  1023,
     235,   427,   693,  1040,   236,   428,   237,   429,   697,   238,
     430,   700,   701,   702,  1048,  1049,  1050,  1415,  1051,  1410,
    1411,  1810,  1045,   239,   431,   711,   438,   240,   432,   712,
     241,   433,   715,   242,   434,   718,  1445,   243,   244,   439,
    1448,  1073,  1449,  1817,  1819,   245,   440,   723,  1074,  1458,
    1823,  2115,  2116,  2117,  2119,   246,   441,   726,   247,   442,
     728,   729,  1080,  1081,  1470,  1082,  1083,  1834,  1835,  1467,
    1468,  1469,  1828,  2128,  2129,  2130,   248,   443,   249,   444,
     738,   250,   445,   740,  1090,   251,   447,   746,   747,   748,
    1094,  2146,   252,   448,   750,  1865,  2418,  1866,  1101,  1102,
    1103,  1868,  1870,  1871,   253,   449,   254,   450,   755,  1528,
    2155,  2156,  2157,  1374,  1375,  1376,  2425,  2159,  2424,  2606,
    1113,   255,   256,   451,   757,  1121,  2164,  2435,  2165,  2433,
    2166,  1118,   257,   452,   759,   258,   259,   453,   762,  1125,
     260,   454,   765,  1883,  1884,  1129,   261,   262,   455,   769,
    1135,  1531,  1889,  1890,  1133,   263,   456,   772,  1137,  1138,
    1535,  2179,   264,   457,   777,   313,  1154,   778,   779,  1556,
    1557,   780,   781,   782,   783,   784,   785,   786,   787,   265,
     458,   733,  2135,  1084,  2413,  1475,  1842,  2411,  2600,   266,
     459,   796,  1559,  1162,  1915,  1916,  1917,  1158,   267,   798,
    1164,  2188,   466,   467,   268,   472,   803,   804,   805,  1176,
    1933,  1930,  1172,   269,   473,   809,  1180,   270,   475,   271,
     476,   811,   272,   478,   820,   273,   479,   823,   274,   480,
     826,  1193,  1943,  1944,  1580,  1946,  2206,  2458,  2208,  1191,
    2454,  2615,  2728,  2729,  2730,  3072,  2731,  2920,  2921,  2951,
    2732,  2882,  2733,  2734,  2735,   275,   481,   830,  1123,  1583,
    1584,  2463,  1195,  1661,  2010,  1662,  1663,  2007,  1664,  1665,
    1026,  1385,  1027,  1383,  1028,  1741,  2052,  1742,  2050,  1743,
    2194,  2446,  2195,  2444,  2196,  1880,  2607,  2721,  1881,  2169,
    2170,  2464,  2624,  2465,  2622,  2466,  1771,  1772,  2071,  1773,
    2069,  1774,   751,  1514,   468,  2357,   721,   722,   704,   705,
    1063,  1064,  1418,  1065,  1438,  1439,  1440,  1441,  1442,  1443,
    1167,  1567,  1312,   621,   622,   623,   624,   603,   652,  1001,
     766,   767,   770,  1857,  1858,   565,   727,   789,   790,  1071,
    1104,   634,   635,  2663,  2300,  1235,  2294,  2295,  2301,   109,
     306,   713,   654,  1030,   604,   605,  2586,   606,  3313,  1326,
     626,  1308,  1719,  1836,  2122,  1140,  2123,   643,   827,  1105,
    1653,  2018,  2358,  1523,  1654,   734,   793,   821,  1837,  2588,
     607,   470,   665,   655,   656,   471,   801,   802,  1655,   904,
    3300,   503,   608,   609,   610,   611,   612,   613,   614,   964,
     942,  1334,  1318,  1319,  1330,  1323,  1313,  1315,   844,  1945,
    2907,   981,  1347,  1751,  1116,  1919,   850,  1004,  1370,  1263,
    2657,  2364,  2578,   412,   413,   414,  1952,  2031,  1981,  1624,
    2685,  2286,  1282,  1283,  2563,   924,   526,   126,  1969,  1014,
    2399,  2084,  1622,  3112,  1366,  2777,   752,  1849,  2576,  3283,
    2405,  2710,  1067,   539,  2381,  2138,  2518,  2441,  2470,  3107,
    2531,  2996,   551,  2014,  3286,   936,  1476,   543,  2142,  2947,
    1638,  2342,  1189,  2510,   113,  2497,  2282,   882,  2879,  1925,
    2997,  1991,  1017,  2120,  2761,   719,  2549,  2507,  2745,  2098,
    1843,  1673,  1305,  1002,  2918,   508,  2298,  3193,  3067,  1998,
    1973,   995,  2574,  1923,  1477,   527,  3229,  3235,  3326,  3327,
    3328,  3329,  3330,  3018
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     314,   115,   116,   117,   937,   996,   488,   292,   122,   295,
     944,   691,   812,    99,   300,   110,   653,  1816,   625,  1869,
     792,   118,  1100,  1707,   731,  1202,  1203,  1204,  1571,  1012,
    1768,  2219,  2033,  1163,  2279,   714,  2015,  1898,   703,  2016,
    1150,  2271,  2020,   714,  1861,  1578,  2043,   967,   735,  2292,
     620,   724,  1139,  1627,   633,  2272,   288,   289,   954,   290,
     714,   540,  1882,   735,   296,   297,  1978,  1333,   791,  1412,
    2345,  1006,  2406,   315,  1765,  1005,  1953,  1343,  1336,  1920,
     329,  1515,  2171,   107,  1815,  2554,  2555,  2212,  2763,   107,
     650,  2099,   892,  1046,  2919,   662,   877,   694,   650,  2533,
    2845,   486,   338,   536,   768,  1968,   897,   720,  1805,  1821,
     920,  1995,  1462,  2393,   739,   741,   125,  3060,  1824,  1225,
    1472,  1564,  2132,   650,  1208,   901,  2384,  2153,   920,  2767,
    1444,  1126,  2384,   974, -2231,  1840,  1306,  1976,  -842,  2349,
    1077,  2963,   806,  1280,   649, -2269,   661,  2305,  3350,  2350,
    2351,  2352,  1483, -1949,  1086,  1863,  2353,  2354,  1273,  1389,
    2552,  1402,  2694,  1892,  2360,   886,  1463,  1893,  2704,   920,
    1248,  3082,  2698,   756, -2162, -1981,   763, -1950,   639,  2934,
     749,   504,   797,  2027,  1853,  1304,  1851,   545,  1529,  3095,
   -2282,  2889,  2306,  3044,  2409,  1709,  2736,   561,  2044, -2156,
     735, -2156,   824,  1713,  1894,  2162,  2698,   926,  1006,  -683,
    1480,  2371,  1156,  1407,  1365,  1170,  2521,   625,   625,   625,
    2375,   650,   754,  2378,   758,   776,  2391,  2283,  2923,   773,
    2192, -2231, -2282,   493,  2511,   541,  1739,  -840,  -683,  -683,
     994,   435,   650,  1472,  1388,  1512,  2198,  2199,    60,  1847,
     972,   528,  2824,  1024,  1221,   506,  1778,  1779, -2282,  1844,
     544,  2495,  1076,   999,  1119,   144,   650,   633,   920,  1266,
     333,  1178,   114,  3234,   961,   851,  1183,   552,   546,   640,
    1937,  1992,  1249,   659,  1114,  2866,  2086,  3364,  1918, -2282,
    3009,  2633,   139, -2282,  -842,   630,  1345,   307,  -842,  1985,
    1574,   848,  1464,  1273,  3227,  1407,   914,   975,     3,   893,
    1516,   977,   976,  2673,  1425,  1075,  1070,  3228,  1680,  3010,
    3011,   978,    61,  2699,   576,   849,  2633,  1070,   650,   528,
    1517,    17,   576,  1108,  2867,  2556,  1986, -1501,  1115,   487,
    2023, -1501,  1110,   537, -2156,  1266, -2156,  1182,  2496,  1184,
    2978,  1267,  3324,  1307,   139,  1461,  1845,   576,   507,  1996,
     961,  1848,  2875,  -842, -2282,  2154,   145,  1740,  1309,  -683,
     990,   334,  1151,   581,   630,  1066,  1465,    63, -1501,  -842,
    -842,   581,  1008,   469,   586,   307, -2282,   714,   774,  1166,
    1564,  2176,   586,  -840,  1070,  1147,  2404,  -840,  1341,  2020,
    2660,   625,  -683,  2172,  1025,   852,   581,  1087,  2401,  1120,
    2402,  1365, -2156,   735, -2180,   529, -2282,   586, -1911,  1371,
    2705,  2284,  2163,  1564,  2880,  2193,  2394,  1267,  1367,   562,
    1564,  1728,  2905,  1168,  1149,  1412,   835,  1276,  1412,   927,
    1564,   436,   875, -2205,  1019,   875, -2184, -2282,  2137,  3208,
    1484, -2282,  2055,  1994,  -467,   576,  1078,   542,  1473,  1746,
     776,   884,  -840,  2774,  1577,  3257,   962,  2045,  1165, -2162,
    1564,  1564,   291,   891,   806,  1564,   576,  2834,  -840,  -840,
     961,   590,  2569,   114,  1521,  2522,   775, -2162,  2597,   590,
    1280,  2571,   835,   529,  2706,   912,  1250,   913,  1565,  2765,
     576,  1255,  1854, -2156,   581,  -683,   907,   908,   114,  2089,
    1201,   858,  2410,  2707,   590,   586,   628,  1389,  3194,  1864,
    2700,   658,  1284,  1841,   776,   581,  2344,  -842, -2162,  1511,
    1511,   658,  1780,   291,  2307,   886,   586,  2118,   813,   658,
     625,   625,   625,  1079, -2269, -1911,  1373,  -847,   291,   581,
     625,   625,   625,   653,  2700, -1958,   658, -2156,  3167,  2090,
     586,   592,   576,  1566,   625,  1474,   851,   625,  3170,   592,
    1371,  2532,  1712,  2834,  3083,  1855,   625,   625,   625,   625,
     625,   994,  1322,  1322,  1322,  3061,  3012, -2197,   566,   291,
     627,  2395,  3096,   644,   592,  2271,  1342,   664,   814,   692,
    1739,   975,  1388,   625,   291,  2028,   976,   980,  1000,  2272,
    1378,   581,   590,   339,  2384,   730,  1226,   596,  2768,  1251,
    2032,   859,   586,  1393,  2608,   596,  -840, -2162,   898,  1337,
    3310,  1859,  1997,   590, -2162,  1368,   653,   799,  1783,   568,
     568,  1950,  -847,  2181,  1811,  1466,  -845,  2091, -2156,  2906,
     596,   822, -2162,   828,   703,  1047,   800,   590,  2581,  1435,
    2107,   813,   875,  -683,   302,   108,   894,   291,   291,   291,
    2936,   108,   291,   601,   875,   291,  2716,   945,   291, -1956,
    1169,   601,  1095,   487,  1482,   653,   625,  1387,  1474,  2593,
    1738,   714,   592, -2162,   511,  2708,   852,  3062, -2282,  1479,
     291,   961,   875,   512,  1525,  2474,   601,  1446,  2087,   875,
     307,  1401,  1403,   592,   968,   628,   628,   628,  1408,   590,
    2884,   814,   860,   915,   875,   888,  2421,   464,  1536,  1409,
    1372,  1740,   114,  1066,  1781,  2063,  2456,   592,  2459,  2362,
    1720,  -845,  2661,   938,  3013,  2748,  3340,  1829,   596,  2979,
    1070,   658,  1745,  1560,  1152,   836,  1744,  1231,  1703,  2881,
     813,  1481,   837,   916, -2205,   630,   875,  1565,  1630,   596,
     625,   861,  3046,  -467,  2545,   653,  1222, -1501, -1501,  2400,
    -467,  2998,   862,  2428,  3047,  1100,  1256,  1257,  1258,   971,
     971,   971, -2162,   596,  1153,  1735,  3114,  2160,   291,   592,
    1565,   863,  1569,  1055,   601,  2429,  2386,  1565,  2388,  2722,
    1408,   836,   658,  1215,   644,  1896,  2347,  1565,   837,   291,
     814,  1409,  1546,   658, -2282,   601,  2749,  1237,  1229,  1241,
    1412,  2924, -2029,  1561,  2534,  2173,  1233, -2282,  1015,  1718,
    1539,   278,    -7,   291,  3161,  2042,  2414,  1565,  1565,   601,
    1425,  1575,  1565,   307,   875,   596,   489,  3048,  1259, -2244,
     536,   860,   800,  2868,  1264, -2027,  2174,  2535,  1246,  1284,
     576,   576, -2031,  1142,  2536,  2639,   975, -1911,  2017,   864,
     639,   976,  1726,   658,  2077,  2953, -1911, -1911,  1562,  1999,
     658, -1911, -2282,  3056,  -467,  2750,  2778,  2299,  1541,   628,
    2944,  -640, -2282,  3196,  2449,   291,  2451,  1097,  2668,  1098,
     861,   601, -2025, -2020,  1426,  1427,  1511,  1749,  1757,   581,
     581,   862, -2282,  2100,  1106,  2102,  1041,  2998,  1270,  2751,
     586,   586, -2033, -2282,   653,   513,   511,   735,  2495, -2164,
    2954,  2999,  2553,   690,  2610,   512,  1548,  1141,  2429,  2835,
    2855,  3068,  1762, -2282,  1549,  3115,  1753,  2107,  2609,   865,
    1428,  1429,   866,   867,  2627,  2863,  2628,  1667,  3197,  1668,
     494,  2140,  3007,   971,  1720,  2000,   307,  1631,  2173,  2017,
    1177,  1393,  2598,  2202,  1758,  2373,  1169,  1921,  2618,    22,
     810,  1581,  1755,   -38,  2961,  1844,   776, -1958,  -640,  2930,
    2683,  2684,  1913,  2962,   291,  1260,  1261,  1914,    36,  2174,
    1652,  1262,  2495,  3007,  3069,   800, -2282,  2869,   864,   495,
     514,  1582,  2747,  3070,  2688,  2498,  1485,   590,   590,  1238,
     496, -2282,   875,   291,  3049,  2966,  1936,  1563,   628,   628,
     628,  2271,  2945,  2078,  3258,  2835,   490,  1632,   628,   628,
     628,  1328,  2210,  3073,  1328,  2272,  3260,  2200,  1339,   291,
    1234, -1801,   628,  3301,  1328,   628,  1486,  1487,  1488,  1489,
    1490,   868,   307,  2695,   628,   628,   628,   628,   628,  2160,
    -837,   714,  1070,     9,    10,   515,  2137,  2999,  3104,  1850,
    2506,   516,  1845,  1271,   279,  1878,  1108,  2752,   865,  2500,
     537,   628,  1629,  1899,  2124,  1110,  1558,   592,   592,  1491,
    1492,    26,   971,   971,   971,  2599,  2537,  2430,  3000,  2516,
    1885,  3071,   971,   971,   971,  1327,  3198,   497,  1327,  3261,
    2870,  3199,  2989,   291,  1042,  1597,   971,   576,  1327,   971,
   -2263,  1339,  3001,   875,  2374,   307,  1550,   291,   971,   971,
     971,   971,   971,    23,  1873,   887,  2779,  1598,  2054,  1619,
     828,  1931,  1361,   596,   596,  3276,  2753,  2403,   625,   625,
    2047,  1931,   291,  2568,   291,   971,  1142,   513,   735,  2757,
    1669,  1922,  1551,  3158,   628,   511,   581,   658,   875,    27,
    1339,   291,   157,  2814,   512,  1435,   511,   586,  1599,  1031,
    1927,  1929,   291,  2211, -2282,   512,  1552,   498,   875,  1436,
     868,  1437,  1645,   291, -2282,   888,  2898,  1903,  2780,   601,
     601,  2538,  1656,  2204,   875,  1286,  1287,  1493,  1494,  1495,
    1496,  1497,  1498,  1499,  1500,  1501,  -837,  2019,  2547, -1860,
    -837,  1934,  2674,  2955,   291, -2282,   658,  2539,  3164,  2540,
    1141, -2229,  2495,  3165,  1239,    60,  2922,  2956,   971,   291,
    2430,   764,   514,   499,  3000,   666,  2296,  2957,   628,  1553,
     291,  1670,  2737,  1288,   667,  1289,  1652,  1290,  2989, -2244,
    1339,  1879,  2517,  2461,  2697,  1142, -2263,  1240,  3001,   836,
    2712,  2713,  2548,  2922,   590,  1524,  2675,  1904,  1905,  1906,
    1907,  1908,  1909,  1910,  1911,  -837,  3262,  1532,    51,  1534,
    2873, -2229,  1291,  1292,  1293,  1766,    28,   291,  1250,   500,
    2723,  -837,  -837,   625,  3287,   625,   991,   515,   629,  2876,
    2641,    31,  2062,   516,    -6,  2911,  2379,  3223,  1554,  2502,
      39,  3224,   971,   487, -2229, -2282,  1570,  1739,   625,   114,
      -6,    -6,  2380,   732,  3306,  1927,  1600,  1927,  3308,  1141,
    2073,    52,  1217,   291,  1640,  1641,   158,  1769,   159,   625,
    1601,   706,   668,  1294,   592,  1295, -2282,  3337,  2943,  1878,
    2057,   506,  1296,  2804,    63,  1769,  1297,   742,   935,  1382,
    2642,   829,  1451,  1142,  2297,  1452,  1453,  3121,  2101,  1502,
    2103,  2066,    53,  2883,    54,  2493,    55,  2062,   160,  2314,
   -2033, -2220,  3064,  1900,    56,  1417,  1503,  2109,  1328,  2896,
    2897,  1450,  3128,  2643,  1451,    40,   513,  1452,  1453,  2495,
     596, -2220,  1218,  1219,  2372,   658,  1642,   513,  3058,   658,
    2462,  1251, -1860,   114,  1770,  2315,   653,  2191,  2148,  1940,
     743,    41,   658,  1070,  2986, -2280,  1555,   517,   975,   744,
    3089,  1130,  1770,   976, -2197,    42,  2161,  1141,   992,  -837,
     307,  2849,  2850,  2494,  2986,  3160,  2017,  2724,  1740,  1363,
    3211,  2145,    57,  1721,   507,  1298,   601,  1299,  2886,   946,
    1602,  1603,  1327,  1769,  3212,  2175,  2775,   114,    -6,  1657,
     875,   658,  3065,  1658,  3066,  1604,  2126,  1605,  2743,   776,
    1364,   514,  2972,  3296,   707,   708,  2504,   669,  2001,  3213,
    2975,  2520,   514,  2062,   625,  1196,   969,   629,   629,   629,
    3236,   308,   653,   309, -2229,   709,  2127,  1963,   975,  3090,
     141,  1885,  1967,   976,  1970,  2359,  3277,  1975,  1977,    45,
    1979, -2229,  3214,  3091,  3092,  3093,  2187,   745,  2221,   107,
    3297,  3221, -2180,  1011, -2182,  1879,    47,  1801,  1142,  1142,
    1770,  2677,  2180,   698,  2173,    48,   515,   658,   658,   658,
    2147,  1984,   516,  1159,   699,    51,  2725,   515,    58,  1643,
    1899,  1899,  2002,   516,  2019,  2189,  2189,   710,  3240,  3241,
    2508,  2580,   141,  2376,  2377,  2174,  -405,  3279,   291,  2938,
    1606,  3280,  3281,  2644,  2987, -2229,   129,     9,    10,   133,
   -2229,  2038,  2021,  3341,  1544,  3105,  3106,  2022,  -405,  2030,
    2645,   875,   487,  2726,  2987,  1545,  1142,  2415,    52,    98,
    3304,    59,  1141,  1838,    60,  2029,   885,   568,  2368,  1899,
    1899,  1160,  1659,  2079,  1660,  1161,   460,  1232,  2478,  2827,
    1365,  1607,  1109,  3345,  3232,    92,   628,   628,  2416,  -405,
    3304,    95,    96,   658,   316,  2727,   132,   134,   320,    53,
    2546,    54,  2080,    55,  2081,  1143,  2514,  1106,  3242,  1095,
    1872,    56,  3284,  3285,  2646,  1876,  1454,  1455,   638,  2647,
    1877,   975,  3233, -2263,  3054,    93,   976,  2062,   696,  1895,
    1141,   629,   947,   948,    94,  1300,  2369,  2948,    61,  3227,
    1348,  1349,   953, -2263,  1456,  1457,    73,  3334,  1454,  1455,
     975,  2076,  3228,  3312,  3314,   976,   322,  2085,  3339,   324,
     971,   971,    62,  2088,  2916,  1935,  2075,  3346,  2427,  2917,
    -405,  2933,  1947,  1947,  2949,  3344,  1456,  1457,   101,    57,
    3348,  1568,  2636,   128,   461,   317,    97,   136,   984,  1301,
     323,   975,  3347,    63,  3354,    64,   976,   103,  2950,  1311,
    1314,  1317, -2263,  1302,   308,  3349,   309,  -405,  2365,  2136,
    1657,  2988,   104,  3311,  1658,    65, -2263, -2263, -2263,   975,
     105,  1108, -2263,  3368,   976,  2989,  1344,   645,   462,   487,
    1265,  2988,   111,  1820,  1265,  2990, -2263, -2263, -2263,   112,
    -405,   628,  2420,   628,  2589,  2989,   114,  -405,  2479,  2858,
     119,   125,  1328,  1747, -2156,  2990,  1324,  1325,  2860,  2861,
    2862,  -405,  2288,   975,   463,   658,   628,   120,   976,  2302,
     629,   629,   629, -1930, -1930, -1930, -1930,  1350,  1351,  1352,
     629,   629,   629,  1329,    60,    58,  1329,   628,  1108,  1187,
    1722,  1188,   121,  1724,   629,  2001,  1329,   629,   576,   464,
      66,  1729, -1985,   123, -1985,  1733,   629,   629,   629,   629,
     629,  1365,  1736,  1767,  1886,   971,   124,   971,   829,    63,
    1900,  1900,  2742,   658,   142,   658,  1327,   148,   151,  2636,
     291,  2281,  2559,   629,  1097,  3357,  1098,  2291,    59,  1971,
     971,  1972,   155,  2061,  2304,  1142,  1659,   581,  1660,   277,
    2468,   568,  2469,  1142,   284,  3315,  3232,  2572,   586,  2573,
    2570,   971,  2478,  3065,   285,  3066,  2309,   294,   644,   658,
     291,   658,  1035,  1036,  1037,  1038,   465,   291,   302,  1900,
    1900,  -405,  -405,  2382, -1929, -1929, -1929, -1929,  3191,    61,
    3192,  2355,  2356,  1095,  3316,  1288,  -405,  1289,  -405,   326,
     970,  2584,   973,  2585,  1397,  1398,  1399,  1400,  1143,  2111,
    2746,  3227,   327,   330,   331,  2480,   629,   474,  2061,  1141,
    2499,  2501,  2503,  2505,  3228,   482,  2035,  1838,  2037,   446,
     505,   509,   510,  2039,  2040,  2041,   517,   547,   548,    62,
    2046,   550,   628,   555,   553,   556,   559,  2009,  2412,  2012,
     717,  2058,  2059,  1526,  2149,   590,   725,   658,   753,   487,
     800,   833,    51,   832,  1142,   293,   845,   293,   847,   874,
     879,   881,   293,   880,   883,   890,   896,   906,   902,  2822,
     918,   919,   928,   929,   932,   934,   935,  2567,  2147,   957,
     979,  1108,    65,  1108,   985,  2594,  2595,   939,   940,   941,
     629,  -405,   997,  1003,    51,   943,   949,   962,  2182,   983,
     950,   951,   952,  1009,   955,    52,   971,  1143,  1011,  1013,
     963,   965,   966,  2048,  2049,  1016,  1108,  1018,  1022,  1020,
    1039,  1068,  2479,  1043,  2061,   592,  1044,  1072,  1141,  1085,
    1088,  1089,  2513,  1093,  1091,  1111,  1117,  1112,  1122,  1136,
      51,  1124,  -405,  2067,  2068,  1128,    53,    52,    54,  1899,
      55,   108,  1132,  2448,  1127,  1144,  1134,   776,    56,  1148,
    1155,  1157,  1169,  1171,  1175,  1179,  1186,    66,  2481,  1192,
    2482,  1190,   576,  1194,  2929,  1197,  2491,  1199,  1198,  2483,
    2484,   596,    51,  2485,  2486,  2110,  1206,  1228,    53,  1201,
      54,  2112,    55,    52,  1214,  1230,   307,  1236,  1242,  1243,
      56,  1244,  1212,  2558,  1234,  1247,  1285,  1310,  1097,   658,
    1098,   658,  1320,  1332,  1340,  1143,  1321,  1331,  1353,  2519,
    1346,   581,    51,  1108,  1355,   630,    57,  1373,  1379,   293,
    1108,  1369,   586,  1025,    53,    52,    54,   601,    55,  2150,
    1329,  1024,  1396,  1394,  1404,  1987,    56,  1460,  -230,   658,
    1413,  3317,  2167,  2168,  1447,  3318,  3319,  2634,  1416,  1078,
    1478,  2543,   875,  -230,  2544,  1513,  2773,  1518,    57,  1899,
    1520,  2714,  2551,  1519,  -230,    52,    53,  1522,    54,  1527,
      55,  1530,  1537,  2718,  -230,  1547,  1538,  1540,    56,  2480,
     920,  1572,  1573,  1579,  1586,  1587,  1588,  1593,  2567,  2564,
    1592,  1596,  1623,  1594,  3320,  1625,  1628,  1637,  2061,   658,
    1621,  1635,  1639,  1646,    57,  -230,    53,  1648,    54,  1650,
      55,  3321,  3322,  1674,  1714,  1710,  1711,  1716,    56,   590,
    2147,  1715,    58,  1717,  1872,  1760,  1723,  1725,  1727,  2583,
    1730,  1731,  1732,  1734,  1737,  2311,  1748,  1750,  1754,  1763,
    1804,  1764,  1806,  1775,  1808,  1809,    57,  1473,   636,  1813,
    2312,  3195,   657,  1818,  1822,  1826,  1839,  1825,  1852,  1860,
    1867,  2313,   657,   716,    58,  1887,   749,  1897,  2887,  2605,
     657,  1888,  1902,   736,  1924,    59,  1899,  1938,    60,  1941,
    1143,  1143,   761,  1942,   761,   771,    57,   794,   736,  1951,
    1955,  1957,  1956,  1980,  1968,  1959,  1990,  1982,  2659,   592,
    1365,  2003,  1840,  2006,  2635,  2666,  2004,  2013,  2025,  2026,
      58,   761,  2030, -1957,  1740,  2064,  1769,    59,  1739,  2664,
    1770,  2113,  2114,  2121,  2133,  1109,  2125, -1952,  2134,  2137,
    2139,  2141,  2144,  2151,  2626,  2152,  1879,  1878,   878,  2147,
    2197,  2178,  2481,  2203,  2482,  2205,  2201,  2216,  1143,  1900,
    2207,  2289,    58,  2483,  2484,   596,  2215,  2485,  2486,  2217,
    2221,  2220,  2222,    59,  2287,  2293,  2303,  2310,  2346,  2363,
   -1904, -1955,  2367,  2398,  2404,  1108,    62,  2387,   629,   629,
    2389,  2126,  2127,  -230,  2417,  2422,   658,  2423,   658,  2162,
    2437,  2672,    58,  2163,    61,  2192,  3129,  2440,  2679,  2680,
    2681,  2682,  2452,  2457,  2193,    59,  2687,    63,  2471,    64,
    2527,   601,  2476,  2477,  2509,  2506,  2515,  2525,    62,  -230,
    2530,  2523,  2550,   511,  2762,   736,  2431,  2432,   644,    65,
    -230,  2562,  2561,  2560,  2575,  2577,  2591,  2592,  2596,  2438,
    2439,  2602,  2715,  2603,  2616,    59,  2604,  2611,  2612,  2462,
    2461,    64,  2630,  2631,  2582,  2766,  2442,  2443,  2648,  2651,
    2650,   636,  2654,  2640,    62,  2811,  2689,  2656,  2692,  1900,
    2755,    65,  2717,  2807,  2808,  2758,  2760,  2764,  2805,  2809,
    2314,  2812,   657,  2699,  2826,  2830,  2813,  2829,  2839,   568,
    2846,  2847,  2832,  -230,  2851,  2840,  2842,  2859,  -230,  2844,
    2877,  2878,  2892,  2872,  2894,  2724,    62,  3292,  1525,  2898,
    2891,  2939,  2912,  2926,    66,  2973,  2315,    65,  2928,  2782,
    2941,  2613,  2946,  2974,  2976,  2967,  2981,  -289,  2982,  2617,
    3008,  2843,  2619,   629,  2810,   629,  2983,  -230,  3088,    64,
    2984,  3075,   140,   657,  1329,  -230,    62,  3081,  3085,  3101,
    2853,  3084,  3094,  3097,   657,  3098,    66,  -230,   629,    65,
    3109,  2023,  3110,  2825,  3123,  3126,  2017,  3242, -2033,  3282,
    3288,   569,  3290,  3331,  2807,  3332,  3358,  3361,  3367,   629,
      21,  1107,   336,   337,  3362,   147,  1900,  3156,   571,  1636,
    2316,    38,   131,  -230,  -230,  2317,   130,  -230,   771,    65,
     889,   534,    66,   899,   138,   910,   535,  -230,   873,  2914,
    1224,  2690,  2678,  2854,   657,  2686,  1223,  2762,  -230,  2691,
    2852,   657,  2671,  3086,   325,  2985,  1205,  3099,  2267,  3045,
    2653,  3356,  2971,  2935,  2318,  1846,  3057,  1143,   736,  2524,
    3360,  3353,  2319,  3336,    66,  1143,  2890,  3204,  3205,  3116,
    3117,  2392,  1647,  3203,  2320,   276,  2711,  -230,   925,  2664,
    2590,  -230,  1666,  3053,  2024,  1752,   982,  2366,  2390,  2783,
    2784,  2785,  2821,  2819,   988,  1362,   695,  1784,  2719,  1029,
    1034,  2074,  2385,  1406,    66,  1414,  2893,  1812,  2931,  2932,
    1841,  2738,  2108,  2396,  2321,  1471,  2147,   572,   573,   574,
    2397,  1827,  2664,  2766,  2322,  1069,   575,  1459,  2131,  2408,
    1862,  2419,  2910,  2158,  1875,  -286,  1092,  2407,  2434,  2426,
     576,  2436,  2209,  1533,  2177,  2620,  2621,  1912,  1145,  2190,
    1785,  1948,  1174,  1786,   629,  2766,  1146,  1949,  2455,  2952,
    1787,  1788,  1874,  2011,  2786,  2787,  2788,   795,  1891,  2051,
    2008,  1386,  1384,  2053,  2323,  2447,  1143,   577,  2324,  2460,
    2445,  2625,  2664,  2720,  3059,  2623,  2467,  2072,  2070,   581,
     987,   788,   582,   583,   584,  2183,  1814,  2184,   585,  2185,
     586,  2186,  2970,  2823,  1419,   760,   831,  1357,  1634,  1338,
    2529,  1420,   625,   625,  1789,  2587,  1131,  1360,   538,  2980,
    1901,  2060,  2361,  3119,  1421,  1422,  1423,  3122,  1245,  3163,
    3017,  3055,  1227,   956,   625,  2065,  2658,  2450,  2614,  2841,
    2828,  2383,  2909,  2696,  3074,  3305,   588,  3077,  3078,  3079,
    3080,   933,   905,   625,  2343,  2143,  2667,  1273,  3130,  1974,
    1926,  2908, -2282,  3325,     0, -2282,     0,     0,  3132,     0,
    2766,     0, -2282, -2282,     0,  3102,  3103,     0,  1424,     0,
       0,     0,   625,     0,     0,     0,  3113,     0,  2789,  2790,
       0,  3118,  1338,     0,  1790,     0,     0,   590, -2156,     0,
   -2156,     0,  2791,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2874,     0,     0,     0,  2792,
       0,   636,     0,     0,  1785,     0, -2282,  1786,     0,  1791,
     591,     0,     0,     0,  1787,  1788,  2793,     0,   657,     0,
       0,  1338,     0,     0,     0,     0,     0,  3137,  3138,  3139,
    3140,  3141,     0,  1792,  3143,  3144,  3145,  3146,  3147,  3148,
    3149,  3150,  3151,  3152,  3153,     0,     0,  3155,     0,     0,
    2915,  3157,     0,     0,     0,     0,     0,   592,     0,     0,
       0,     0,  2815,  2816,  2817,     0,     0,  3166,  1789,  3168,
       0,  1425,   593,   594,  3169,  2794,     0,   657,     0,     0,
       0,     0,     0,     0,     0,     0, -2282,     0,     0,     0,
       0,     0,     0,  1793,  2795,  2796,  2797,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1338,  2798,   596,     0,     0,     0,     0,     0,     0,
       0, -2282,  3289,     0,   597,  1426,  1427,     0,     0,     0,
       0,     0,     0,     0,  2995,  3006,     0,     0,     0,     0,
       0,     0,     0,  2089,     0, -2282,   598,     0,  1790,     0,
       0,   599,     0,  3076,     0,     0,  1795,     0,  3230,  3231,
     600,     0,     0,   291,     0,     0,     0,     0,  3087,   601,
    3333,  1428,  1429,     0,  3335,  3239,     0,     0,     0,  3100,
    3243,  3244,     0,  1791,     0,     0,     0,     0,     0,     0,
       0, -2156,     0,  2090,     0,     0,     0,  3291,     0,  1524,
    3293,  3294,     0,   736,     0, -2282,     0,  1792,     0,     0,
       0,     0,     0,  3124,     0,  1430,  3125,     0,     0,  2799,
       0,     0,     0,  1694,     0,  1695,  1696,     0,  1431,     0,
       0,     0,     0,     0,  3309,  3369,  1432,     0,     0,     0,
    1796,     0,     0,  1433,     0,     0,     0,  3131,     0,     0,
    3133,  3134,  3135,  3136,     0,     0,     0,     0,     0,     0,
    3142,     0,   736,     0,  1797,     0,   657,  1793, -2282,  1434,
     657,     0,     0,  3154,     0,   644,     0,     0,     0,     0,
       0,  2091, -2156,   657,     0,   664,   636,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1794,
    3171,  3172,  3173,  3174,  3175,  3176,  3177,  3178,  3179,  3180,
    3181,  3182,  3183,  3184,  3185,  3186,  3187,  3188,  3189,     0,
    1795,  2232,   657,     0,     0, -2282,  1015, -2282, -2282,     0,
       0,   644,     0,  1798,     0,     0,     0,     0,     0,  3209,
       0,     0, -2282,     0,     0,     0,     0,  1667,  1288,  1668,
    1289,  3210,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -2282,     0,     0,     0,
       0,     0,  3225,  3226,     0,     0,     0,     0,     0,     0,
     628,   628,     0,     0,     0,     0,     0,  1694,  3238,  1695,
    1696,     0,     0,     0,     0,     0,     0,     0,   657,   657,
     657,  3278,   628,     0,  1796,     0,  1435,     0,     0,     0,
    1436,     0,  1437,     0,     0,     0,     0,     0,     0,  3295,
       0,   628,     0,     0,     0,     0,     0,     0,  1797,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   636,     0,
       0,  3307,     0,     0,     0, -2282,     0,     0,     0,     0,
     628,     0,     0,     0,   971,   971,     0,     0,     0,     0,
     736,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3338,     0,     0,     0,     0,     0,   971,     0,   875,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3352,  3352,
       0,     0,     0,   736,   657,   971,     0,     0,     0,     0,
       0,  3355,     0,     0,     0,     0,     0,  1798,     0,     0,
       0,  3245,  1964,     0,     0,     0,     0,     0,     0,     0,
    3366,     0,  1273,     0,   971,     0,     0, -2282,     0,     0,
   -2282,     0,   162,     0,   163,     0,   164, -2282, -2282,     0,
    2247,   165,     0,     0,     0,     0,     0,     0,     0,   166,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3246,     0,  3247, -2156,     0, -2156,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   167,   168,     0,     0,     0,     0,     0,
       0, -2282,     0,     0,   736,     0,     0,     0,   169,     0,
    3248,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     170,     0,     0,     0,   171,     0,     0,     0,     0,     0,
       0,     0,     0,  3249,     0,     0,     0,     0,   172,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -886,     0,     0,     0,  2251,     0,     0,   293,
       0,     0,   173,  3250,     0,     0,     0,     0,   174,     0,
     175,     0,     0,   176,     0,   177,   657,     0,     0,     0,
       0, -2282,     0,     0,     0,   178,  -886,     0,  -886,  -886,
    -886,  -886,  -886,  -886,  -886,  -886,  -886,     0,  -886,  -886,
    -886,     0,  -886,  -886,  -886,  -886,  -886,  -886,  -886,  -886,
    -886,  -886,   179,     0,     0,     0, -2282,     0,  -886,     0,
       0,     0,     0,  -886,     0,   180,     0,  -886,     0,     0,
     181,     0,     0,     0,   657,     0,   657,     0,     0,     0,
   -2282,     0,     0,     0,     0,     0,     0,     0,     0,  2255,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3251,   182,     0,     0,     0,     0,     0,     0,   183,     0,
       0,   184,   185,     0,     0,     0,     0,     0,     0,     0,
     657,  3252,   657,     0,   186,     0, -2156,     0,     0,     0,
       0,     0,   187,     0,   188,     0,     0,   189,     0,     0,
   -2282,     0,  -886,     0,     0,     0,     0,     0,  3253,     0,
       0,  1276,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3254,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -2282,     0,     0,     0,     0,   190,     0,     0,
       0,     0,  3255,   191,     0,   192,     0,     0,     0,  1959,
       0,     0,  3256, -2282,     0,     0,   193,     0,   657,  -886,
       0,     0,     0,     0,  -886,  -886,  -886, -2156,  -886,  -886,
    -886,  -886,   736,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   194,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   293,     0,     0,     0,   195,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -2282,     0, -2282, -2282,     0,     0,   196,  1526,     0,     0,
       0,   197,   198,   199,   736,   736,   736, -2282,     0,     0,
       0,   736,   736,   200,     0,     0,     0,   736,   736,   736,
       0,   736,     0,     0,     0,     0,   201,     0,   202,     0,
       0, -2282,     0,     0,     0,   203,     0,     0,     0,   204,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   205,
       0,   569,     0,     0,     0,     0,     0,   206,     0,     0,
       0,     0,   207,     0,     0,     0,   736,     0,   571,     0,
       0,     0,  -886,     0,   208,   736,   736,   736,   736,     0,
       0,     0,     0,   209,     0,     0,     0,     0,   210,   211,
     657,     0,   657,     0,     0,   212,     0,     0,   213,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   214,     0,
   -2282,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1387,     0,     0,  -886,     0,   293,     0,     0,     0,
     657,     0,     0,     0,     0,  -886,   567,     0,     0,   568,
       0,     0,     0,   875,   216,   162,     0,   163,     0,   164,
    1052,     0,   217,     0,   165,     0,     0,   218,     0,     0,
       0,     0,   166,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   572,   573,   574,
    -886,     0,     0,     0,     0,     0,   575,   219,     0,     0,
     657,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     576,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   169,  2492,     0,     0,     0,     0,     0,     0,     0,
       0,   569,     0,   170,     0,     0,     0,   171,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   577,   571,     0,
       0,   172,     0,     0,     0,     0,     0,     0,     0,   581,
       0,     0,   582,   583,   584,     0,     0,     0,   585,     0,
     586,     0,   629,   629,     0,   173,     0,     0,     0,     0,
       0,   174,     0,   175,     0,     0,   176,     0,   177,     0,
       0,     0,     0,     0,   629,     0,     0,     0,   178,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   629,     0,     0,   588,     0,     0,     0,
       0,     0,     0,     0,     0,   179,     0,     0,     0,     0,
    1053,     0,     0,     0,     0,     0,     0,     0,   180,     0,
       0,     0,   629,   181,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1462,   736,   572,   573,   574,
       0,     0,     0,     0,     0,     0,   575,   590,     0,     0,
       0,     0,     0,     0,   182,     0,     0,     0,     0,     0,
     576,   183,     0,     0,   184,   185,     0,   657,     0,   657,
       0,     0,     0,     0,     0,     0,     0,   186,     0,     0,
     591,     0,  1054,     0,     0,   187,     0,   188,     0,  1463,
     189,     0,     0,  2601,     0,     0,     0,   577,   578,     0,
       0,     0,     0,     0,   579,     0,   580,     0,     0,   581,
       0,     0,   582,   583,   584,     0,     0, -1351,   585,     0,
     586,     0,     0,     0,     0,     0,     0,   592,     0,   587,
       0,     0,     0,     0, -1351,     0,     0,     0,     0,     0,
     190,     0,   593,   594,     0,     0,   191,     0,   192,     0,
       0,  1055,     0,     0,     0,     0,     0,     0,     0,   193,
       0,     0,     0,     0,     0,     0,   588,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1056,     0,     0,
       0,     0,     0,   596,     0,     0,   589,     0,   194,     0,
       0,     0,     0,     0,   597,     0,     0,     0,     0,     0,
       0,     0,   195,     0,     0,     0,     0,   293,     0,     0,
       0,     0,     0,     0,     0,     0,   598,   590,     0,     0,
       0,   599,     0,  2670,  2670,  1464,     0,     0,     0,   196,
     600,     0,     0,   291,   197,   198,   199,     0,     0,   601,
       0,     0,     0, -1351, -1351, -1351,   200,     0,     0,     0,
     591,     0, -1351,     0,     0,     0,   736,     0,     0,   201,
       0,   202,     0,     0,     0,     0, -1351,     0,   203,     0,
       0,     0,   204,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   205,     0,     0,     0,     0,     0,     0,     0,
     206,     0,     0,     0,     0,   207,     0,   592,     0,  1465,
       0,     0,     0, -1351,     0,     0,     0,   208,     0,     0,
       0,     0,   593,   594,     0, -1351,   209,     0, -1351, -1351,
   -1351,   210,   211,     0, -1351,     0, -1351,     0,   212,     0,
       0,   213,     0,     0,     0,     0,     0,     0,     0,     0,
    1057,   214,  1058,   293,     0,     0,     0,     0,     0,     0,
       0,  1059,  1060,   596,     0,  1061,  1062,   215,     0,   293,
       0,   293,   293,     0,   597,     0,     0,   293,     0,     0,
       0,     0, -1351,     0,     0,     0,   736,   216,     0,     0,
       0,     0,     0,     0,     0,   217,   598,     0,     0,     0,
     218,   599,     0,     0,     0,   636,     0,     0,     0,     0,
     600,   569,     0,   291,     0,     0,     0,     0,     0,   601,
       0,     0,     0,   162,     0,   163,     0,   164,   571,     0,
     219,     0,   165, -1351,     0,     0,     0,     0,     0,     0,
     166,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   293,   293,     0,
       0,     0,     0,     0,     0,     0, -1351,     0,     0,     0,
       0,     0,   293,     0,   167,   168,     0,     0,  2857,     0,
       0,  2857,     0,     0,     0,     0,     0,     0,     0,   169,
    2857,  2857,  2857,  2865,     0,     0,     0,     0,     0,     0,
       0,   170,     0,   736,     0,   171,   567,     0,     0,   568,
       0,     0,     0, -1351,     0,   636,     0,     0,     0,   172,
       0,     0,     0,     0,     0,     0,     0,     0, -1351, -1351,
       0,     0,     0,     0,     0,     0,     0,   572,   573,   574,
       0,     0,     0,   173,     0,     0,   575,     0,     0,   174,
       0,   175,     0,     0,   176,     0,   177,   293,     0,     0,
       0,     0,     0,     0,     0,     0,   178,     0,     0, -1351,
       0,     0,     0,   636,     0,     0,     0,     0,  1466,     0,
   -1351,     0,     0,     0,     0,     0,   293,   293,     0,     0,
       0,   569,     0,   179,     0,   293,     0,   577,     0,     0,
     293,   293, -1351,     0,     0,     0,   180, -1351,   571,   825,
     636,   181,   582,   583,   584,     0, -1351,     0,   585, -1351,
       0,     0,     0,     0,     0, -1351,     0,     0,     0,     0,
       0,     0,     0,   293,     0,     0,     0,     0,     0,     0,
       0,  2977,   182,     0,     0,     0,     0,     0,     0,   183,
       0,     0,   184,   185,     0,     0,     0,     0,     0,     0,
     293,     0,   293,     0,     0,   186,   588,     0,     0,     0,
       0,  1542,     0,   187,     0,   188,     0,     0,   189,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   162,     0,   163,     0,   164,
       0,     0,     0,     0,   165,     0,     0,   572,   573,   574,
       0,     0,   166,     0,     0,     0,   575,     0,   190,     0,
       0,     0,     0,     0,   191,     0,   192,     0,     0,     0,
     576,     0,     0,     0,     0,     0,     0,   193,   293,     0,
     591,     0,     0,     0,     0,     0,   167,   168,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   169,     0,     0,     0,     0,   194,   577,   578,     0,
       0,     0,     0,   170,   579,     0,   580,   171,     0,   581,
     195,     0,   582,   583,   584,     0,     0,     0,   585,     0,
     586,   172,     0,   736,     0,     0,     0,     0,   736,   587,
       0,     0,   593,   594,     0,     0,     0,   196,     0,     0,
       0,     0,   197,   198,   199,   173,     0,     0,     0,     0,
       0,   174,     0,   175,   200,     0,   176,     0,   177,     0,
       0,     0,     0,     0,     0,     0,   588,   201,   178,   202,
       0,     0,     0,     0,     0,     0,   203,     0,     0,     0,
     204,     0,     0,     0,   597,     0,   589,     0,     0,     0,
     205,     0,     0,     0,     0,   179,     0,     0,   206,     0,
       0,     0,     0,   207,     0,     0,   598,     0,   180,     0,
       0,   599,   736,   181,     0,   208,   736,   590,     0,     0,
     600,     0,     0,   291,   209,     0,     0,     0,     0,   210,
     211,     0,     0,     0,     0,     0,   212,     0,     0,   213,
       0,     0,     0,     0,   182,     0,     0,     0,     0,   214,
     591,   183,     0,     0,   184,   185,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1185,     0,   186,     0,     0,
       0,     0,     0,     0,     0,   187,     0,   188,     0,     0,
     189,     0,     0,     0,     0,   216,     0,     0,     0,     0,
    1543,     0,     0,   217,     0,     0,     0,   592,   218,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   593,   594,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   219,     0,
     190,     0,     0,     0,     0,     0,   191,     0,   192,     0,
       0,     0,     0,     0,     0,     0,  1544,     0,     0,   193,
       0,     0,     0,   596,     0,     0,     0,  1545,     0,     0,
       0,     0,     0,     0,   597,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   194,     0,
       0,     0,     0,     0,     0,     0,   598,     0,     0,     0,
       0,   599,   195,     0,     0,   341,     0,   342,     0,     0,
     600,     0,   343,   291,     0,     0,     0,     0,     0,   601,
     344,     0,     0,     0,     0,     0,     0,     0,     0,   196,
       0,     0,     0,     0,   197,   198,   199,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   200,     0,     0,     0,
       0,     0,     0,     0,   345,   346,     0,     0,     0,   201,
       0,   202,     0,     0,     0,     0,     0,     0,   203,   347,
       0,     0,   204,     0,     0,     0,     0,     0,     0,     0,
       0,   348,   205,     0,     0,   349,     0,     0,     0,     0,
     206,     0,     0,     0,     0,   207,     0,     0,     0,   350,
       0,     0,     0,     0,     0,     0,     0,   208,     0,     0,
       0,     0,     0,     0,     0,     0,   209,     0,     0,     0,
       0,   210,   211,   351,     0,     0,     0,     0,   212,     0,
       0,   213,     0,     0,   352,     0,   353,     0,     0,     0,
       0,   214,     0,     0,     0,     0,     0,   354,     0,     0,
     355,   356,   357,   358,   359,   360,   361,   362,     0,   363,
     364,   365,     0,   366,   367,   368,   369,   370,   371,   372,
     373,   374,   375,   376,     0,     0,     0,   216,     0,     0,
       0,     0,     0,     0,     0,   217,   377,     0,     0,     0,
     218,   378,     0,     0,     0,     0,     0,     0,     0,   567,
       0,     0,   568,     0,     0, -2197, -2197, -2197,     0,     0,
       0,     0,     0,  1052,     0,     0,     0,     0,     0,     0,
     219,     0,   379,     0,     0,     0,     0,     0,     0,   380,
       0,     0,   381,   382,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   383,     0,     0,     0,     0,
       0,     0,     0,   384,     0,   385,     0,     0,   386, -2197,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   569,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   571,     0,     0,     0,     0,     0,     0,   387,     0,
       0,     0,     0,     0,   388,     0,   389,     0,     0,     0,
       0,   567,     0,     0,   568,     0,     0,   390,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -1164,     0,     0,     0,
       0, -1164,     0,     0, -1164,     0,   391,     0,     0,     0,
       0, -1164, -1164,     0,     0,     0,     0,     0,     0,     0,
     392,     0, -2197,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1053,     0,     0,     0, -1164,     0, -1164,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   393,     0,     0,     0,   569,     0,     0,     0,
     572,   573,   574,     0,   394, -1164,     0,     0,     0,   575,
       0,     0,     0,   571,     0,     0, -2197, -2197,     0,   395,
       0,     0,     0,   576,     0,     0,   396,     0,     0,     0,
     397,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     398,     0,     0,     0,     0,  1054,     0,     0,     0,     0,
       0,     0,     0,   399,     0,     0,     0,     0,     0,     0,
     577,   578, -2197, -2197,     0,   400,     0,   579,     0,   580,
       0,     0,   581,     0,   401,   582,   583,   584,     0,   402,
     403,   585,     0,   586,     0, -1164,   404,     0,     0,   405,
       0,     0,   587,     0,     0,     0,     0,     0,     0,   406,
       0,     0,     0,     0,     0,     0, -2197,     0,     0,     0,
       0,     0,     0,     0,  1055,   407,     0,     0,     0, -2197,
   -1164,     0,   572,   573,   574,     0,     0, -2197,     0,   588,
       0,   575,     0,   567, -2197,   408,   568,     0,     0,     0,
    1056,     0,     0,   409, -1164,   576,     0,     0,   410,   589,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -2197,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   411,     0,
     590,     0,   577,   578,     0,     0,     0,     0,     0,   579,
   -1164,   580,     0,     0,   581,     0,     0,   582,   583,   584,
       0,     0,     0,   585, -1164,   586,     0,     0,     0,     0,
       0,     0,     0,   591,   587, -1164,     0,     0,   569,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   571,     0,     0,     0,     0,
   -1073,     0,     0, -1073,     0,     0, -1164,     0,     0,     0,
       0,   588,     0,     0,     0,     0,     0,     0,     0,     0,
     592,     0,     0,     0,     0,     0,     0, -1164,     0,     0,
       0,   589,     0,     0,     0,   593,   594,     0,     0,     0,
       0, -1164,     0,     0,   920,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   590,  1057,     0,  1058,     0, -2197,     0,     0,
       0, -2197,     0, -2197,  1059,  1060,   596,     0,  1061,  1062,
       0,     0,     0,     0,     0, -1073,     0,   597,     0,     0,
   -2162,     0,     0,     0, -1164,   591, -1164, -1164,   672,     0,
       0,     0, -1073,     0,   572,   573,   574,     0,     0,   598,
       0, -1164,     0,   575,   599,     0,     0,     0,     0,     0,
       0,     0,     0,   600,     0,     0,   291,   576,     0,     0,
       0,     0,   601,     0,   673, -1164,     0,     0,     0,     0,
       0,     0,   592,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   567,   593,   594,   568,
       0,     0,     0,     0,   577,   578,     0,     0,     0,     0,
       0,   579,     0,   580,     0,     0,   674,     0,     0,   582,
     583,   584,     0,     0,     0,   585,     0,   586,     0,     0,
       0,     0,     0,     0,     0,     0,   587,     0,   596,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   597,
       0, -1073, -1073, -1073, -1164,     0,     0,     0,     0,     0,
   -1073,     0,     0,     0,     0, -1164,     0,     0,     0,     0,
       0,   598,     0,   588, -1073,     0,   599,     0,   675,     0,
       0,   569,     0,     0,     0,   600,     0, -1164,   291,     0,
       0,     0,     0,   589,   601,     0,     0,     0,   571,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -1073, -1073,     0,     0,     0,     0,     0, -1073,     0,
   -1073,     0,     0, -1073,   590,     0, -1073, -1073, -1073,     0,
       0,     0, -1073,     0, -1073,     0,     0,     0,     0,     0,
       0,     0,     0, -1073,     0,     0,     0,     0,     0,     0,
     567,     0,     0,   568,     0,     0,     0,   591,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -2282,     0,     0,     0,     0,     0,     0,   567,     0,
   -1073,   568,     0,     0,     0, -1073,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -1073,     0,     0,     0,   592,     0,   676,   572,   573,   574,
       0,     0,     0,     0,     0,     0,   575,     0,   435,   593,
     594,     0,   677,     0,     0,     0,     0,     0,     0,     0,
     576, -1073,     0,     0,     0,   569,     0,     0,     0,     0,
       0,     0,     0, -2162,     0,     0,     0,   570,     0,     0,
       0,     0,   571,     0,     0,     0,   678,     0,     0,     0,
     596,     0,     0,   569, -1073,     0,     0,   577,   578,     0,
       0,   597,     0,     0,   579,   807,   580,     0,     0,   581,
     571,     0,   582,   583,   584,     0,     0,     0,   585,     0,
     586,     0,     0,   598,     0,     0,     0,     0,   599,   587,
       0,     0,     0,     0, -1073,     0,     0,   600,   679,     0,
     291, -1073,     0,     0,     0,     0,   601,     0,     0,     0,
   -2282,     0,     0,     0,     0,     0, -1073, -1073,     0,     0,
       0,     0,     0,     0,     0,     0,   588,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   589,     0,     0,     0,
       0,   572,   573,   574,     0,     0,     0, -1073,     0,     0,
     575,     0,     0,     0,     0,     0,     0,     0, -1073,     0,
       0,     0,     0,     0,   576,     0, -1073,   590,     0,   572,
     573,   574,     0,     0,     0,     0,     0,     0,   575,     0,
   -1073,     0,     0,     0,     0, -1073,     0,     0, -2162,     0,
       0,     0,   576,     0, -1073,     0,     0, -1073,   436,     0,
     591,   577,   578, -1073,     0,     0,     0,     0,   579,     0,
     580,     0,     0,   581,     0,     0,   582,   583,   584,     0,
       0,     0,   585,     0,   586,     0,     0,     0,   567,   577,
     578,   568,     0,   587,     0,     0,   579,     0,   580,     0,
       0,   581,     0,     0,   582,   583,   584,   592,     0,     0,
     585,     0,   586,     0,     0,     0,     0,     0,     0,     0,
       0,   587,   593,   594,     0,     0,     0,     0,     0,     0,
     588,   567,     0,     0,   568,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     589,     0,     0,     0,     0,     0,     0,     0,   588,     0,
       0,     0,     0,   596,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   569,   597,     0,     0,     0,   589,     0,
       0,   590,     0,     0,     0,   737,   567,     0,     0,   568,
     571,     0,     0,     0,     0,     0,   598,     0,     0,     0,
       0,   599,     0,     0,     0,     0,     0,     0,     0,   590,
     600,     0,   875,   291,   591,     0,   569,     0,     0,   601,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   571,     0,     0,     0,     0,     0,     0,
       0,     0,   591,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   592,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   569,     0,     0,     0,     0,   593,   594,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   595,   571,   592,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   572,
     573,   574,     0,     0,   593,   594,     0,     0,   575,     0,
       0,     0,     0,     0,     0,   808,     0,   596,     0,     0,
       0,     0,   576,     0,     0,     0,     0,     0,   597,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   572,   573,   574,   596,     0,     0,     0,     0,
     598,   575,     0,     0,     0,   599,   597,     0,     0,   577,
     578,     0,     0,     0,   600,   576,   579,   291,   580,     0,
       0,   581,     0,   601,   582,   583,   584,     0,   598,     0,
     585,     0,   586,   599,     0,     0,     0,     0,     0,     0,
       0,   587,   600,     0,     0,   291,     0,   572,   573,   574,
       0,   601,   577,   578,     0,     0,   575,     0,     0,   579,
       0,   580,   567,     0,   581,   568,     0,   582,   583,   584,
     576,     0,     0,   585,     0,   586,     0,     0,   588,     0,
       0,     0,     0,     0,   587,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   589,     0,
       0,     0,     0,     0,     0,     0,     0,   577,   578,     0,
       0,     0,     0,     0,   579,     0,   580,   567,     0,   581,
     568,   588,   582,   583,   584,     0,     0,     0,   585,   590,
     586,     0,     0,     0,     0,     0,     0,     0,     0,   587,
       0,   589,     0,     0,     0,     0,     0,   569,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     567,     0,   591,   568,   571,     0,     0,     0,     0,     0,
       0,     0,   590,     0,     0,     0,   588,     0,     0,     0,
       0,   675,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   589,     0,     0,     0,
       0,     0,   569,     0,     0,   591,     0,     0,     0,   592,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   571,
       0,     0,     0,     0,   593,   594,     0,   590,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   569,     0,     0,     0,     0,
       0,     0,   592,     0,     0,     0,     0,     0,     0,     0,
     591,     0,   571,     0,     0,   596,     0,   593,   594,     0,
       0,     0,     0,   572,   573,   574,   597,     0,     0,     0,
       0,     0,   575,   567,     0,     0,   568,     0,     0,     0,
       0,     0,     0,   959,     0,     0,   576,     0,   598,     0,
       0,     0,     0,   599,     0,     0,     0,   592,   596,     0,
       0,     0,   600,     0,  1173,   291,     0,     0,     0,   597,
       0,   601,   593,   594,     0,     0,     0,     0,   572,   573,
     574,     0,  1181,   577,   578,     0,     0,   575,     0,     0,
     579,   598,   580,     0,     0,   581,   599,     0,   582,   583,
     584,   576,     0,     0,   585,   600,   586,     0,   291,     0,
       0,     0,     0,   596,   601,   587,     0,     0,   569,     0,
       0,   572,   573,   574,   597,     0,     0,     0,     0,     0,
     575,  1335,     0,     0,   568,   571,     0,     0,   577,   578,
       0,     0,     0,     0,   576,   579,   598,   580,     0,     0,
     581,   599,   588,   582,   583,   584,     0,     0,     0,   585,
     600,   586,     0,   291,     0,     0,     0,     0,     0,   601,
     587,     0,   589,     0,     0,     0,     0,     0,     0,     0,
       0,   577,   578,     0,     0,     0,     0,     0,   579,     0,
     580,     0,     0,   581,     0,     0,   582,   583,   584,     0,
       0,     0,   585,   590,   586,     0,     0,   588,     0,     0,
       0,     0,     0,   587,     0,     0,   569,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   589,     0,     0,
       0,     0,     0,   571,     0,     0,   591,     0,     0,     0,
       0,     0,     0,     0,   572,   573,   574,     0,     0,     0,
     588,     0,     0,   575,     0,     0,     0,     0,   590,     0,
       0,     0,     0,     0,     0,     0,     0,   576,     0,     0,
     589,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   592,     0,     0,     0,     0,     0,     0,
       0,   591,     0,     0,     0,     0,     0,     0,   593,   594,
       0,   590,     0,     0,   577,   578,     0,     0,     0,     0,
       0,   579,     0,   580,     0,     0,   581,     0,     0,   582,
     583,   584,     0,     0,     0,   585,     0,   586,     0,     0,
       0,     0,     0,     0,   591,     0,   587,     0,   592,   596,
       0,     0,   572,   573,   574,     0,     0,     0,     0,     0,
     597,   575,     0,   593,   594,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   576,     0,     0,     0,     0,
       0,     0,   598,   588,  1932,     0,     0,   599,     0,     0,
       0,   592,     0,     0,     0,     0,   600,     0,     0,   291,
       0,     0,     0,   589,   596,   601,   593,   594,     0,     0,
       0,     0,   577,   578,     0,   597,     0,     0,     0,   579,
       0,   580,     0,     0,   581,     0,     0,   582,   583,   584,
       0,     0,     0,   585,   590,   586,     0,   598,     0,     0,
       0,     0,   599,     0,   587,     0,     0,   596,     0,     0,
       0,   600,     0,     0,   291,     0,     0,     0,   597,     0,
     601,     0,     0,     0,     0,     0,     0,   591,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     598,   588,     0,     0,     0,   599,     0,     0,     0,     0,
       0,     0,     0,     0,   600,     0,     0,   291,     0,     0,
       0,   589,     0,   601,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   592,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   593,
     594,     0,   590,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2888,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   591,     0,     0,     0,     0,
     596,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   597,  -478,     0,     0,  -478,     0,     0,  -478,  -478,
    -478,  -478,  -478,  -478,  -478,  -478,  -478,     0,     0,     0,
       0,     0,     0,   598,     0,     0,     0,     0,   599,     0,
       0,     0,   592,     0,     0,     0,     0,   600,     0,     0,
     291,  -478,     0,  -478,     0,     0,   601,   593,   594,     0,
       0,  -478,     0,  -478,  -478,  -478,  -478,  -478,  -478,  -478,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   596,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   597,
       0,  -478,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   598,     0,     0,     0,     0,   599,     0,     0,     0,
       0,     0,     0,     0,     0,   600,     0,     0,   291,     0,
       0,     0,     0,     0,   601,     0,     0,     0,     0,  -478,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1208,     0,     0,     0,
       0,  -478,  -478,  -478,  -478,  -478,     0,     0,  -478,  -478,
       0,     0,     0,     0,  -478,     0,     0,     0,     0,     0,
    -478,     0,  -478,     0,     0,     0,     0,     0,  -478,     0,
       0,     0,     0,     0,  -478,     0,  -478,     0,  -478,     0,
       0,     0,     0,     0,     0,     0,     0,  -478,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -478,     0,     0,  -478,     0,     0,     0,     0,     0,
       0,     0,  -478,     0,  -478,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  -478,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -478,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -478,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -478,     0,  -478,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -478,     0,  -478,
       0,     0,     0,     0,     0,  1207,     0,     0,     0,     0,
       0,  -478,  -478,     0,     0,     0,     0,     0,     0,     0,
    -478,     0,     0,  -478,     0,  -478,     0,     0,   568,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -478,  -478,  -478,     0,  -478,  -478,  -478,  -478,  -478,  -478,
    -478,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1095,  -478,     0,     0,     0,     0,     0,     0,  -478,     0,
    -478,  -478,     0,     0,     0,     0,  -478,     0,  -478,  -478,
    -478,  -478,  -478,  -478,  -478,     0,     0,     0,     0,     0,
    -478,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     569,     0,     0,  -478,     0,  -478,  -478,  -478,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   571,     0,   568,
       0,     0,     0,     0,     0,     0,  -478,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -478,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -478,     0,     0,
       0,  1095,  -478,     0,     0,     0,     0,     0,  -478,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -478,     0,     0,     0,     0,  -478,     0,  -478,     0,
       0,  1208,  -478,  -478,  -478,     0,  -478,  -478,  -478,  -478,
    -478,   569,     0,  -478,  -478,     0,  -478,     0,     0,     0,
       0,  -478,     0,  -478,     0,     0,     0,     0,   571,     0,
       0,     0,  1201,  -478,     0,  1096,   572,   573,   574,     0,
       0,  -478,     0,     0,     0,   575,  1830,     0,     0,     0,
       0,     0,  -478,     0,     0,     0,     0,     0,     0,   576,
       0,     0,     0,     0,     0,     0,  -478,     0,     0,  -478,
       0,     0,     0,     0,     0,     0,     0,  -478,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1097,   577,  1098,     0,     0,
    1831,     0,     0,     0,     0,     0,     0,     0,  1099,     0,
       0,   582,   583,   584,     0,     0,     0,   585,     0,   586,
    -478,     0,     0,     0,     0,     0,     0,     0,   569,     0,
       0,     0,     0,     0,     0,     0,  1096,   572,   573,   574,
       0,     0,     0,     0,     0,   571,   575,     0,     0,     0,
       0,     0,  -478,     0,     0,     0,     0,     0,     0,     0,
     576,     0,     0,     0,     0,   588,     0,  -478,     0,     0,
       0,     0,     0,     0,     0,  -478,     0,     0,  -478,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -478,  1097,   577,  1098,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   581,
       0,  -478,   582,   583,   584,     0,   590,     0,   585,     0,
     586,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   591,
       0,     0,     0,     0,   572,   573,   574,     0,     0,     0,
       0,     0,     0,   575,     0,     0,   588,     0,  -478,     0,
    -478,  -478,  -478,     0,     0,     0,     0,   576,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   592,     0,     0,     0,
       0,     0,     0,  -478,     0,     0,     0,     0,     0,     0,
    1832,   593,   594,     0,   577,     0,     0,   590,     0,     0,
       0,     0,     0,     0,     0,     0,   581,  -478, -2282,   582,
     583,   584,     0,     0,     0,   585,     0,   586,     0,     0,
       0,     0,     0,     0,     0,     0,  -478,     0,     0,     0,
     591,     0,   596,     0,     0,     0,     0,  -478,  -478,  -478,
       0,     0,     0,   597,     0,     0,     0,     0,     0,     0,
       0,  -478,     0,     0,     0,     0, -1408,     0,  -478,     0,
       0,     0,     0,   588,     0,   598,     0,  1201,     0,     0,
     599,     0,     0,     0,     0,     0, -1408,   592,     0,   600,
       0,   875,   291,     0,     0,     0,     0,     0,   601,     0,
       0,     0,   593,   594,     0,     0,     0,     0,     0,     0,
    1273,     0, -2282,     0,     0, -2282,     0,  1274, -2282, -2282,
       0,     0,     0,     0,   590,     0, -2282,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   596,     0,     0,     0,     0,     0,     0,
       0, -2156,     0, -2156,   597,     0,     0,   591,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -1408,     0,     0,
       0,     0,     0,     0,     0,     0,   598,     0,     0, -2282,
       0,   599,     0,     0,     0,     0,  2224, -1408,     0,     0,
     600,     0,   875,   291,     0,     0,     0,     0, -2282,   601,
       0,     0,  2225,     0,   592,  2226,  2227,  2228,  2229,  2230,
    2231,  2232,     0,     0,     0,     0,     0,     0,     0,   593,
     594,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2233,     0,  1491,
    1492,  2234,  2235,  2236,  2237,  2238,     0,     0,     0,     0,
     596,     0,     0,     0,     0,     0,     0,     0,     0,  1833,
       0,   597,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   598, -2282,     0,     0,  2239,   599,     0,
       0,  1275, -2282,     0,     0,     0,     0,   600,     0,     0,
     291,     0,     0,     0,     0,     0,   601,     0, -2282,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -2282,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -2156,     0,     0,  2240,  2241,  2242,
    2243,  2244,     0,     0,  1500,  1501, -2282,     0, -2282,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1276,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2245,     0,     0,     0, -2282,     0, -2282,     0,
       0,     0,     0,  2246,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   114,     0, -2282,
    2247,     0,     0,     0,     0,     0,     0,     0, -2254,     0,
       0, -2282,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -2156,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -2282, -2282,     0,     0,     0,     0,     0,     0,
       0,  2248,     0,     0,  1675,     0,     0,  1676,     0,     0,
    1677,     0,     0,     0,     0,     0,     0,     0,  1678,     0,
       0, -2282,     0,     0,     0,     0,     0,     0, -2282,  3019,
   -2282, -2282,  3020,  2249,     0,  3021,  2226,  2227,  2228,  2229,
    2230,  2231,  3022,  3023,     0, -2282,     0,     0,  2250,     0,
   -2282,     0,     0,     0,     0,     0,  2251,     0,     0,  2252,
       0,     0,     0,     0,     0,     0,     0,     0,  1667, -2282,
    1668,  1679,     0,     0,     0,     0,  2253,     0,  2233,     0,
    1491,  1492,  2234,  2235,  2236,  2237,  2238,     0,     0,     0,
    1680,     0,  2254,     0,     0,     0,     0,     0,     0,     0,
       0, -2282,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -2158, -2282,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2239,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -2282,  2255,
       0,  2256,  2257,  2258,     0,     0,     0,     0, -2282,     0,
       0,     0,     0,     0, -2282,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3024,     0,     0,     0,
       0,   875,     0,     0,  2259,     0,  1681,     0,     0,     0,
       0,     0,     0,     0,  1682,     0,     0,     0,  2240,  2241,
    2242,  2243,  2244,     0,     0,  1500,  1501,     0,  -475,     0,
    1683,  3025,     0,     0,     0,     0,     0,  3026,     0,  3027,
       0,     0,     0,     0,     0, -2197,     0, -2254,     0,     0,
       0,  3028,     0,  2245,     0,  3029,     0,     0,  2260,  2261,
    2262,     0,     0,     0,  2246,     0,  1684,     0,     0,     0,
       0,     0,  2263,     0,     0,     0,     0,     0,   114,  1959,
       0,  2247,     0,     0,     0,     0,     0,     0,  1685,     0,
    1686,  3030,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3031,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3032,     0,     0,  1687,     0,
    1688,     0,     0,     0,     0,  2226,  2227,  2228,  2229,  2230,
    2231,     0,  2248,     0,     0,     0,     0,     0,     0,     0,
       0,  1689,     0,  3033,     0,  1688,     0,     0,     0,     0,
       0,     0,     0,  1690,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3034,     0,  1689,  2233,     0,  1491,
    1492,  2234,  2235,  2236,  2237,  2238,     0,     0,  3035,  2250,
       0,     0,     0,     0,  1691,  1692,     0,  2251,     0,     0,
    2252,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2253,     0,  3036,
       0,     0,     0,  1693,     0,     0,     0,  2239,     0,     0,
    1694,     0,  1695,  1696,     0,     0,   569,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1697,  3037,     0,
       0,     0,  1698,   571,     0,  1694,     0,  1695,  1696,     0,
       0,   569,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1699,     0,     0,     0,     0,     0,  3038,   571,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2255,     0,  2256,  2257,  2258,     0,     0,  2240,  2241,  2242,
    2243,  2244,     0,  1700,  1500,  1501,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1701,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3039,     0,
       0,     0,  2245,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2246,  3040,     0,     0,     0,     0,  -778,
    1702,     0,     0,     0,     0,  3041,     0,     0,     0,     0,
    1703,     0,   572,   573,   574,     0,  1704,     0,     0,     0,
       0,   575,     0,     0,     0,  3042,     0,     0,   569,  2260,
    2261,  2262,     0,     0,     0,   576,     0,   572,   573,   574,
       0,     0,     0,  2263,     0,   571,   575,     0,  3043,     0,
    1959,     0,     0,     0,   569,     0,     0,     0,     0,     0,
     576,  2248,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   571,   577,   615,     0,     0,     0,     0,     0,   579,
       0,   580,     0,     0,   581,     0,     0,   582,   583,   584,
       0,     0,     0,   585,     0,   586,     0,   577,   615,     0,
       0,     0,     0,     0,   579,     0,   580,     0,  2250,   581,
       0,     0,   582,   583,   584,     0,     0,     0,   585,  2252,
     586,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2253,     0,     0,     0,
       0,   588,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   572,   573,   574,     0,     0,     0,
       0,   589,     0,   575,     0,     0,   588,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   576,     0,     0,
     572,   573,   574,     0,     0,     0,   589,     0,     0,   575,
       0,     0,   590,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   576,     0,     0,     0,     0,     0,     0,
       0,  2256,  2257,  2258,   577,   615,     0,   590,     0,     0,
       0,   579,     0,   580,     0,   591,   581,     0,     0,   582,
     583,   584,     0,     0,     0,   585,     0,   586,     0,     0,
     577,   615,     0,     0,     0,     0,     0,   579,     0,   580,
     591,     0,   581,     0,     0,   582,   583,   584,     0,     0,
       0,   585,     0,   586,     0,     0,     0,     0,     0,     0,
       0,     0,   592,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   588,     0,     0,     0,   593,   594,     0,
       0,     0,     0,     0,     0,     0,     0,   592,  2260,  2261,
    2262,     0,     0,   589,     0,     0,     0,     0,     0,   588,
       0,     0,   593,   594,     0,  1316,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   616,     0,   596,   589,
     617,   618,     0,     0,   590,     0,     0,     0,     0,   597,
    1928,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   616,   569,   596,     0,   617,   618,     0,     0,     0,
     590,   598,     0,     0,   597,     0,   599,   591,     0,   571,
       0,     0,     0,     0,     0,   600,     0,     0,   291,     0,
       0,     0,     0,     0,   601,     0,   598,     0,     0,     0,
       0,   599,     0,   591,     0,     0,     0,     0,     0,     0,
     600,     0,     0,   291,     0,     0,     0,     0,     0,   601,
       0,     0,     0,     0,   592,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   593,
     594,     0,     0,     0,     0,     0,     0,   569,  2034,     0,
     592,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     569,     0,     0,     0,   571,   593,   594,     0,     0,     0,
       0,     0,     0,     0,  2036,     0,     0,   571,   616,   569,
     596,     0,   617,   618,     0,     0,     0,     0,   572,   573,
     574,   597,     0,     0,     0,     0,   571,   575,     0,     0,
       0,     0,     0,     0,   616,     0,   596,     0,   617,   618,
       0,   576,     0,   598,     0,     0,     0,   597,   599,     0,
       0,     0,     0,     0,     0,     0,     0,   600,     0,     0,
     291,     0,     0,     0,     0,     0,   601,     0,     0,   598,
       0,     0,     0,     0,   599,     0,     0,     0,   577,   615,
       0,     0,     0,   600,     0,   579,   291,   580,     0,     0,
     581,     0,   601,   582,   583,   584,     0,     0,     0,   585,
       0,   586,     0,   572,   573,   574,     0,     0,     0,     0,
       0,     0,   575,     0,     0,     0,   572,   573,   574,     0,
       0,     0,     0,     0,     0,   575,   576,     0,     0,     0,
       0,     0,     0,     0,     0,   572,   573,   574,     0,   576,
       0,     0,     0,     0,   575,     0,     0,   588,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   576,     0,
       0,     0,     0,   577,   615,     0,     0,   589,     0,     0,
     579,     0,   580,     0,     0,   581,   577,   615,   582,   583,
     584,     0,     0,   579,   585,   580,   586,     0,   581,     0,
       0,   582,   583,   584,     0,   577,   615,   585,   590,   586,
       0,     0,   579,     0,   580,     0,     0,   581,     0,     0,
     582,   583,   584,     0,     0,     0,   585,     0,   586,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   591,   588,     0,     0,     0,     0,     0,   569,     0,
       0,     0,     0,     0,     0,   588,     0,     0,     0,     0,
       0,     0,   589,     0,     0,   571,     0,     0,     0,     0,
       0,     0,     0,     0,   588,   589,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   592,     0,
       0,     0,     0,   590,   589,     0,     0,     0,     0,     0,
       0,     0,     0,   593,   594,     0,   590,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   590,   591,     0,     0,     0,
       0,  2056,     0,     0,     0,     0,     0,     0,     0,   591,
       0,     0,   616,     0,   596,     0,   617,   618,     0,     0,
       0,     0,  3342,     0,     0,   597,     0,     0,   591,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   592,   572,   573,   574,   598,     0,     0,
       0,     0,   599,   575,     0,     0,   592,     0,   593,   594,
       0,   600,     0,     0,   291,     0,     0,   576,     0,     0,
     601,   593,   594,     0,     0,   592,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     593,   594,     0,     0,     0,     0,     0,   616,     0,   596,
       0,   617,   618,     0,   577,   615,     0,     0,     0,     0,
     597,   579,   596,   580,   617,     0,   581,     0,     0,   582,
     583,   584,     0,   597,     0,   585,     0,   586,     0,     0,
       0,   596,   598,     0,     0,     0,     0,   599,     0,     0,
       0,     0,   597,     0,     0,   598,   600,     0,     0,   291,
     599,     0,     0,     0,     0,   601,     0,     0,     0,   600,
       0,     0,   291,     0,   598,     0,     0,     0,   601,   599,
       0,     0,     0,   588,     0,     0,     0,     0,   600,     0,
       0,   291,     0,     0,     0,     0,     0,   601,     0,     0,
       0,     0,     0,   589,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   590,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   591,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   592,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   593,
     594,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     596,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   597,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   598,     0,     0,     0,     0,   599,     0,
       0,     0,     0,     0,     0,     0,     0,   600,     0,     0,
     291,     0,     0,     0,     0,     0,   601
};

static const yytype_int16 yycheck[] =
{
     127,    55,    56,    57,   568,   650,   283,   115,    62,   117,
     578,   426,   476,    44,   122,    52,   422,  1444,   417,  1516,
     457,    58,   751,  1284,   442,   835,   836,   837,  1175,   661,
    1373,  1959,  1721,   798,  1965,   432,  1670,  1540,   430,  1673,
     789,  1965,  1674,   440,  1513,  1192,  1735,   615,   443,  1972,
     417,   440,   774,  1226,   418,  1965,   110,   111,   595,   113,
     457,   312,  1528,   458,   118,   119,  1603,   955,   457,  1047,
    1992,   657,  2127,   127,  1368,   657,  1585,   965,   959,  1559,
     147,  1102,  1882,     1,  1425,  2318,  2319,  1952,  2652,     1,
       6,  1803,     9,    17,     9,     9,   505,   427,     6,  2302,
    2759,     1,    61,    22,     9,    95,     1,   437,  1402,  1450,
      50,    63,     9,    96,   444,   445,    63,     9,  1459,    17,
     137,    78,  1836,     6,   197,   534,  2093,     7,    50,    49,
     124,   763,  2099,    63,    28,    71,   171,  1602,     0,  2005,
     101,     1,   472,   931,   421,   119,   423,   196,   198,  2014,
    2015,  2016,  1094,    32,   736,   159,  2021,  2022,    31,  1032,
    2317,  1042,   147,   142,  2029,   519,    63,   146,     6,    50,
      80,   112,   186,   450,    96,   228,   453,    32,   289,  2900,
     246,   289,   459,   136,     9,   934,  1480,   105,  1130,   112,
     327,  2834,   241,  2965,   254,  1287,  2615,   351,   273,    72,
     595,    74,   479,  1295,   183,   111,   186,   351,   794,    69,
    1091,  2076,   794,    21,   214,   801,   273,   616,   617,   618,
    2085,     6,   449,  2088,   451,   309,   351,    27,   361,   456,
     339,   125,   372,   287,   138,   262,   340,     0,    98,    99,
     649,   228,     6,   137,  1032,  1098,  1935,  1936,   347,   246,
     617,   224,  2715,   186,     1,   246,   105,   106,   116,    28,
     314,   465,   726,   179,   307,   289,     6,   631,    50,   470,
     289,   808,   262,  3214,   604,   313,   450,   331,   315,   390,
    1574,  1624,   192,   527,   325,   475,   136,   198,  1558,   197,
      69,  2489,    76,   213,   156,   289,   520,   289,   160,   192,
    1181,   331,   199,    31,   115,    21,    68,   531,     0,   226,
     557,   522,   536,  2546,   179,   724,   713,   128,   119,    98,
      99,   532,   421,   337,   240,   355,  2524,   724,     6,   224,
     577,   173,   240,   751,   524,   327,   229,   142,   379,   583,
     141,   146,   751,   262,    72,   470,    74,   811,   552,   523,
     104,   552,  3293,   388,   138,  1077,   125,   240,   349,   311,
     690,   358,  2825,   225,   244,   245,   390,   471,   936,   229,
     647,   390,   136,   289,   289,   705,   273,   476,   183,   241,
     242,   289,   659,   210,   300,   289,   266,   784,   173,   798,
      78,  1888,   300,   156,   791,   784,   529,   160,   962,  2031,
      63,   800,   262,  1883,   337,   443,   289,   737,  2122,   452,
    2124,   214,   285,   808,   414,   388,   296,   300,    63,  1005,
     258,   221,   328,    78,   147,   534,   409,   552,   996,   583,
      78,  1319,  2851,   800,   518,  1413,   143,   310,  1416,   583,
      78,   428,   582,   262,   671,   582,   512,   327,   267,  3170,
    1095,   267,  1746,  1626,   143,   240,   417,   484,   352,  1340,
     309,   515,   225,  2666,  1186,  3237,   519,   542,   798,   409,
      78,    78,   583,   527,   804,    78,   240,  2741,   241,   242,
     810,   397,  2348,   262,  1116,   542,   271,   409,  2410,   397,
    1278,  2356,   143,   388,   332,   549,   406,   551,   455,  2656,
     240,    35,   327,   376,   289,   365,   543,   544,   262,   237,
     583,    29,   572,   351,   397,   300,   417,  1390,  3161,   523,
     534,   422,   931,   459,   309,   289,  1991,   389,   409,  1097,
    1098,   432,   381,   583,   583,   889,   300,   511,   523,   440,
     939,   940,   941,   504,   518,   190,   426,   428,   583,   289,
     949,   950,   951,   959,   534,   228,   457,   285,  3122,   287,
     300,   477,   240,   520,   963,   582,   313,   966,  3132,   477,
    1156,   518,  1294,  2837,   515,   400,   975,   976,   977,   978,
     979,   990,   949,   950,   951,   477,   365,   577,   415,   583,
     417,   574,   515,   420,   477,  2519,   963,   424,   583,   426,
     340,   531,  1390,  1002,   583,   558,   536,   252,   524,  2519,
    1019,   289,   397,   572,  2581,   442,   514,   533,   538,   529,
    1712,   139,   300,  1032,  2424,   533,   389,   409,   523,   959,
    3289,  1484,   584,   397,   574,  1002,  1042,   464,  1387,     9,
       9,  1583,   523,  1913,   360,   542,   428,   375,   376,  2852,
     533,   478,   574,   480,  1046,   579,   535,   397,  2370,   524,
    1807,   523,   582,   523,   583,   583,   583,   583,   583,   583,
    2903,   583,   583,   589,   582,   583,  2598,   578,   583,   228,
     535,   589,    51,   583,  1093,  1091,  1085,   560,   582,  2403,
    1335,  1088,   477,   574,    62,   533,   443,   589,   578,  1088,
     583,  1031,   582,    71,  1122,  2214,   589,  1071,   558,   582,
     289,  1041,  1042,   477,   615,   616,   617,   618,   526,   397,
     523,   583,   240,   485,   582,   583,  2153,   512,  1137,   537,
    1007,   471,   262,  1063,   583,  1756,  2205,   477,  2207,  2033,
    1308,   523,   405,   570,   523,   120,  3310,  1469,   533,   503,
    1147,   652,  1338,  1162,   518,   462,  1338,   884,   559,   482,
     523,  1091,   469,   525,   583,   289,   582,   455,   291,   533,
    1169,   289,  2965,   462,  2311,  1181,   523,   582,   583,  2120,
     469,   147,   300,   244,  2965,  1514,   320,   321,   322,   616,
     617,   618,   574,   533,   558,  1332,   285,  1875,   583,   477,
     455,   319,  1169,   331,   589,   266,  2100,   455,  2102,  2609,
     526,   462,   713,   850,   641,  1537,    33,   455,   469,   583,
     583,   537,  1152,   724,   374,   589,   201,   894,   882,   896,
    1808,  2886,   520,  1163,  2303,   296,   890,   276,   665,   289,
     518,   194,     0,   583,  3108,  1733,  2140,   455,   455,   589,
     179,  1181,   455,   289,   582,   533,   264,  2965,   392,    40,
      22,   240,   535,    34,   918,   520,   327,   193,   905,  1278,
     240,   240,   520,   774,   200,  2491,   531,   522,   289,   397,
     289,   536,   520,   784,   285,   126,   531,   532,   181,    33,
     791,   536,   266,  2965,   583,   270,   138,   289,  1149,   800,
     296,    28,   296,   308,  2198,   583,  2200,   276,   289,   278,
     289,   589,   520,   520,   233,   234,  1484,   520,   324,   289,
     289,   300,   296,  1804,   751,  1806,    50,   147,   409,   304,
     300,   300,   583,   327,  1340,   303,    62,  1332,   465,    65,
     181,   307,   123,   426,  2424,    71,    39,   774,   266,  2741,
     289,   191,  1361,   327,    47,   444,  1353,  2104,  2424,   477,
     279,   280,   480,   481,  2473,   289,  2475,    72,   373,    74,
     240,  1852,  2962,   800,  1542,   119,   289,   500,   296,   289,
     807,  1390,   228,  1941,   390,   285,   535,   276,  2457,   225,
     473,     8,  1356,   523,   254,    28,   309,   517,   125,  2895,
      23,    24,   331,   263,   583,   539,   540,   336,   356,   327,
     589,   545,   465,  3003,   254,   535,   374,   188,   397,   289,
     388,    38,  2638,   263,  2561,   552,     1,   397,   397,     1,
     300,   470,   582,   583,  2965,  2931,  1573,   330,   939,   940,
     941,  2965,   438,   444,  3237,  2837,   454,   570,   949,   950,
     951,   952,   365,  2975,   955,  2965,  3237,  1938,   959,   583,
     583,   589,   963,   373,   965,   966,    41,    42,    43,    44,
      45,   589,   289,  2576,   975,   976,   977,   978,   979,  2157,
       0,  1478,  1479,   241,   242,   453,   267,   307,  3011,  1478,
     579,   459,   125,   574,   447,   147,  1514,   472,   477,   552,
     262,  1002,  1229,  1540,  1826,  1514,  1160,   477,   477,    84,
      85,   135,   939,   940,   941,   361,   442,   578,   484,   274,
    1529,   361,   949,   950,   951,   952,   531,   397,   955,  3237,
     301,   536,   498,   583,   258,    48,   963,   240,   965,   966,
     506,  1042,   508,   582,   444,   289,   239,   583,   975,   976,
     977,   978,   979,   389,  1518,   523,   398,    70,  1744,  1213,
     987,  1570,   989,   533,   533,  3237,   541,  2125,  1567,  1568,
    1738,  1580,   583,  2346,   583,  1002,  1077,   303,  1573,  2648,
     285,   470,   275,  3106,  1085,    62,   289,  1088,   582,   135,
    1091,   583,   309,  2696,    71,   524,    62,   300,   111,   682,
    1567,  1568,   583,  1952,   578,    71,   299,   477,   582,   528,
     589,   530,  1266,   583,   296,   583,   249,  1547,   460,   589,
     589,   547,  1276,  1945,   582,    25,    26,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   156,  1674,   518,   104,
     160,  1571,   138,   484,   583,   327,  1147,   573,  3113,   575,
    1077,   212,   465,  3118,   226,   347,  2883,   498,  1085,   583,
     578,   527,   388,   533,   484,   254,   351,   508,  1169,   362,
     583,   376,  2615,    73,   263,    75,   589,    77,   498,   460,
    1181,   333,   437,   177,  2578,  1186,   506,   259,   508,   462,
    2584,  2585,   572,  2920,   397,  1122,   192,  1548,  1549,  1550,
    1551,  1552,  1553,  1554,  1555,   225,  3237,  1134,    11,  1136,
    2813,   272,   112,   113,   114,  1369,   111,   583,   406,   589,
    2614,   241,   242,  1722,  3247,  1724,   408,   453,   417,  2826,
     212,    93,  1750,   459,   225,  2867,   246,  3202,   431,   552,
     523,  3206,  1169,   583,   305,   296,  1173,   340,  1747,   262,
     241,   242,   262,   442,  3277,  1722,   269,  1724,  3286,  1186,
    1775,    64,   403,   583,   320,   321,   483,   261,   485,  1768,
     283,   224,   361,   173,   477,   175,   327,  3305,  2910,   147,
    1747,   246,   182,  2679,   476,   261,   186,   191,   349,  1025,
     272,   480,    12,  1294,   479,    15,    16,  3031,  1804,   374,
    1806,  1768,   105,  2830,   107,   276,   109,  1825,   525,   249,
     583,   104,   313,  1540,   117,  1051,   391,  1809,  1319,  2846,
    2847,     9,  3056,   305,    12,   523,   303,    15,    16,   465,
     533,   104,   473,   474,  2079,  1336,   392,   303,  2970,  1340,
     334,   529,   307,   262,   338,   285,  1852,   520,  1857,  1576,
     254,   135,  1353,  1850,   147,   526,   549,   583,   531,   263,
     396,   767,   338,   536,   229,   385,  1875,  1294,   550,   389,
     289,  2767,  2768,   344,   147,  3107,   289,    31,   471,   296,
     199,   432,   185,  1310,   349,   285,   589,   287,  2831,   578,
     403,   404,  1319,   261,   213,  1887,   221,   262,   389,   182,
     582,  1402,   403,   186,   405,   418,     8,   420,   579,   309,
     327,   388,  2939,   326,   367,   368,   552,   506,  1645,   238,
    2947,   192,   388,  1941,  1923,   831,   615,   616,   617,   618,
    3221,   350,  1938,   352,   495,   388,    38,  1591,   531,   475,
      77,  1950,  1596,   536,  1598,  2028,  3237,  1601,  1602,   527,
    1604,   512,   271,   489,   490,   491,  1923,   361,   229,     1,
     373,  3193,   116,   403,   289,   333,   450,  1394,  1469,  1470,
     338,   411,  1902,   526,   296,   255,   453,  1478,  1479,  1480,
    1857,  1618,   459,   199,   537,    11,   140,   453,   291,   545,
    2027,  2028,  1646,   459,  2031,  1925,  1926,   450,  3230,  3231,
    2245,  2366,   139,  2086,  2087,   327,    48,  3239,   583,  2905,
     523,  3243,  3244,   495,   307,   576,    70,   241,   242,    73,
     581,  1729,  1676,  3312,   526,   281,   282,  1681,    70,     8,
     512,   582,   583,   187,   307,   537,  1537,   296,    64,   135,
    3272,   344,  1469,  1470,   347,  1699,   523,     9,   449,  2086,
    2087,   267,   335,   147,   337,   271,   289,   523,    20,    38,
     214,   574,   751,   213,    60,   523,  1567,  1568,   327,   111,
    3302,    37,    38,  1574,   128,   229,    73,    74,   132,   105,
    2312,   107,   176,   109,   178,   774,  2254,  1514,   238,    51,
    1517,   117,   342,   343,   576,  1522,   316,   317,   419,   581,
    1527,   531,    98,   396,  2965,   523,   536,  2125,   429,  1536,
    1537,   800,   579,   580,   523,   515,   517,   349,   421,   115,
     975,   976,   589,   396,   344,   345,    33,  3298,   316,   317,
     531,  1785,   128,  3291,  3292,   536,   133,  1791,  3309,   136,
    1567,  1568,   445,  1797,   181,  1572,  1777,   213,  2157,   186,
     192,  2898,  1579,  1580,   386,  3313,   344,   345,   450,   185,
     213,   521,  2491,    70,   397,   129,   523,    74,   635,   569,
     134,   531,   238,   476,  3332,   478,   536,   523,   410,   939,
     940,   941,   475,   583,   350,   238,   352,   229,   520,  1843,
     182,   484,   450,  3290,   186,   498,   489,   490,   491,   531,
     195,  2219,   475,  3361,   536,   498,   966,   581,   441,   583,
     921,   484,   484,  1449,   925,   508,   489,   490,   491,   464,
     262,  1722,  2152,  1724,  2392,   498,   262,   269,   190,  2791,
     464,    63,  1733,   521,   388,   508,   950,   951,  2800,  2801,
    2802,   283,  1969,   531,   477,  1746,  1747,   523,   536,  1976,
     939,   940,   941,   561,   562,   563,   564,   977,   978,   979,
     949,   950,   951,   952,   347,   291,   955,  1768,  2286,   403,
    1311,   405,   523,  1314,   963,  2002,   965,   966,   240,   512,
     583,  1322,   517,   523,   519,  1326,   975,   976,   977,   978,
     979,   214,  1333,   216,  1530,  1722,   523,  1724,   987,   476,
    2027,  2028,  2631,  1804,   246,  1806,  1733,   119,   160,  2638,
     583,  1965,  2321,  1002,   276,  3342,   278,  1971,   344,   403,
    1747,   405,   156,  1750,  1978,  1826,   335,   289,   337,   523,
     285,     9,   287,  1834,   523,    59,    60,   285,   300,   287,
    2355,  1768,    20,   403,   523,   405,  1983,    76,  1775,  1850,
     583,  1852,   561,   562,   563,   564,   589,   583,   583,  2086,
    2087,   403,   404,  2090,   561,   562,   563,   564,   285,   421,
     287,  2025,  2026,    51,    98,    73,   418,    75,   420,   583,
     616,  2387,   618,  2389,  1035,  1036,  1037,  1038,  1077,  1816,
    2635,   115,    27,   439,   172,   357,  1085,   383,  1825,  1826,
    2228,  2229,  2230,  2231,   128,   585,  1723,  1834,  1725,   457,
     289,   289,   542,  1730,  1731,  1732,   583,   289,   523,   445,
    1737,   310,  1923,   523,   257,   523,   428,  1663,  2136,  1665,
     518,  1748,  1749,  1122,  1861,   397,   583,  1938,   583,   583,
     535,    81,    11,   450,  1945,   115,   523,   117,   523,   514,
     458,   470,   122,   459,    71,    65,   583,   262,   289,  2704,
     440,   523,   523,   148,   307,   221,   349,  2344,  2345,   149,
     190,  2489,   498,  2491,   150,  2405,  2406,   535,   535,   535,
    1169,   523,   151,   439,    11,   535,   535,   519,  1915,   518,
     535,   535,   535,   152,   535,    64,  1923,  1186,   403,    99,
     535,   535,   535,  1739,  1740,   506,  2524,   506,   153,   232,
     154,   110,   190,   289,  1941,   477,   155,   511,  1945,   535,
     518,   158,  2249,   463,    50,   512,   162,   161,   221,   221,
      11,   163,   574,  1769,  1770,   164,   105,    64,   107,  2576,
     109,   583,   165,  2197,   583,   186,   577,   309,   117,   384,
      32,   166,   535,   167,   122,   168,   221,   583,   520,   122,
     522,   169,   240,   170,  2893,   523,  2220,   295,   450,   531,
     532,   533,    11,   535,   536,  1811,   523,   372,   105,   583,
     107,  1817,   109,    64,   355,   459,   289,   259,   523,   523,
     117,   116,   583,  2320,   583,   523,   104,   518,   276,  2100,
     278,  2102,   583,   518,   228,  1294,   583,   583,   428,  2263,
     252,   289,    11,  2631,   387,   289,   185,   426,   581,   289,
    2638,   310,   300,   337,   105,    64,   107,   589,   109,  1865,
    1319,   186,   581,   560,   572,     1,   117,   197,     4,  2140,
     579,   365,  1878,  1879,   145,   369,   370,   325,   579,   417,
     518,  2305,   582,    19,  2308,   237,  2665,   514,   185,  2696,
     509,  2591,  2316,   517,    30,    64,   105,   258,   107,   258,
     109,   147,   518,  2603,    40,    50,   518,   518,   117,   357,
      50,   221,   221,   258,   523,   450,   288,   523,  2565,  2343,
     415,    94,    23,   523,   418,   523,   289,   388,  2125,  2200,
     527,   310,    80,   470,   185,    71,   105,   355,   107,   118,
     109,   435,   436,   515,   267,   588,   587,   342,   117,   397,
    2597,   484,   291,   315,  2151,    27,   520,   520,   520,  2383,
     520,   520,   520,   520,   520,     4,   520,   518,   518,   433,
     228,   414,   228,   267,    17,   514,   185,   352,   418,   589,
      19,  3161,   422,   157,   417,    50,   137,   518,   228,   523,
     189,    30,   432,   433,   291,   579,   246,   350,  2832,  2423,
     440,   579,   349,   443,   484,   344,  2813,   228,   347,   518,
    1469,  1470,   452,     9,   454,   455,   185,   457,   458,     7,
     523,   418,   450,    22,    95,   574,   505,   349,  2525,   477,
     214,   583,    71,    48,   482,  2532,   523,   342,    62,   470,
     291,   481,     8,   228,   471,   327,   261,   344,   340,  2527,
     338,   145,   574,   574,   214,  1514,    50,   214,   459,   267,
     358,   360,   353,     8,  2471,   221,   333,   147,   508,  2716,
     374,   417,   520,   357,   522,   123,   523,   450,  1537,  2576,
     504,   583,   291,   531,   532,   533,   523,   535,   536,   444,
     229,   574,   514,   344,   229,   583,   577,   523,    17,   221,
     228,   228,   132,   111,   529,  2893,   445,   413,  1567,  1568,
     413,     8,    38,   249,   159,   296,  2387,   267,  2389,   111,
     296,  2545,   291,   328,   421,   339,  3060,   285,  2552,  2553,
    2554,  2555,   568,   104,   534,   344,  2560,   476,    58,   478,
     214,   589,   523,   450,   437,   579,   262,   518,   445,   285,
     287,   583,   460,    62,  2651,   595,  2162,  2163,  2355,   498,
     296,    40,   296,   484,   248,   126,    50,   119,   385,  2175,
    2176,   433,  2596,    50,   523,   344,   296,   296,   296,   334,
     177,   478,   523,   514,  2381,  2663,  2192,  2193,    54,   518,
     548,   631,    27,   589,   445,  2692,   460,   458,   376,  2696,
     290,   498,   385,  2681,  2682,   221,   517,   289,   480,  2687,
     249,   118,   652,   337,   557,   116,   518,   388,   461,     9,
     124,   124,   399,   359,   213,   526,   583,     7,   364,   518,
     419,   479,   518,   523,   252,    31,   445,  3252,  3026,   249,
     523,   124,   582,   523,   583,   579,   285,   498,   523,  2673,
     497,  2448,   385,   352,   349,   583,   267,   296,   267,  2456,
     523,  2758,  2459,  1722,  2688,  1724,   126,   403,   104,   478,
     276,   348,   523,   713,  1733,   411,   445,   267,   276,   506,
    2777,   267,   267,   267,   724,   276,   583,   423,  1747,   498,
     229,   141,   198,  2717,    62,   229,   289,   238,   583,   250,
     236,    91,   579,   132,  2782,   221,   357,    50,   365,  1768,
      11,   751,   153,   155,   486,    93,  2813,  3102,   108,  1248,
     359,    25,    72,   459,   460,   364,    71,   463,   768,   498,
     525,   301,   583,   531,    75,   546,   303,   473,   501,  2870,
     870,  2564,  2551,  2782,   784,  2559,   854,  2844,   484,  2565,
    2776,   791,  2544,  2992,   523,  2959,   838,  3003,  1965,  2965,
    2519,  3340,  2937,  2902,   403,  1476,  2968,  1826,   808,  2286,
    3352,  3326,   411,  3302,   583,  1834,  2837,  3169,  3169,  3024,
    3024,  2106,  1267,  3168,   423,   100,  2583,   523,   558,  2867,
    2396,   527,  1278,  2965,  1687,  1347,   631,  2063,  2104,    55,
      56,    57,  2703,  2702,   641,   990,   428,  1390,  2605,   682,
     689,  1776,  2098,  1046,   583,  1049,  2840,  1416,  2896,  2897,
     459,  2618,  1808,  2113,   463,  1081,  3073,   217,   218,   219,
    2115,  1467,  2910,  2911,   473,   709,   226,  1074,  1834,  2130,
    1514,  2151,  2866,  1875,  1521,   484,   746,  2129,  2165,  2157,
     240,  2166,  1950,  1135,  1890,  2461,  2462,  1556,   782,  1926,
      36,  1580,   804,    39,  1923,  2943,   784,  1580,  2203,  2920,
      46,    47,  1520,  1664,   130,   131,   132,   458,  1535,  1742,
    1662,  1028,  1027,  1743,   523,  2196,  1945,   277,   527,  2208,
    2195,  2466,  2970,  2608,  2972,  2465,  2209,  1774,  1773,   289,
     638,   457,   292,   293,   294,  1919,  1419,  1919,   298,  1919,
     300,  1919,  2936,  2710,  1054,   452,   481,   984,  1233,   959,
    2294,  1063,  3291,  3292,   100,  2392,   768,   987,   305,  2953,
    1542,  1750,  2031,  3026,    12,    13,    14,  3034,   903,  3112,
    2964,  2965,   874,   599,  3313,  1766,  2522,  2199,  2450,  2746,
    2730,  2091,  2859,  2577,  2978,  3276,   346,  2981,  2982,  2983,
    2984,   565,   540,  3332,  1989,  1854,  2534,    31,  3064,  1600,
    1563,  2854,    36,  3293,    -1,    39,    -1,    -1,  3075,    -1,
    3058,    -1,    46,    47,    -1,  3009,  3010,    -1,    66,    -1,
      -1,    -1,  3361,    -1,    -1,    -1,  3020,    -1,   254,   255,
      -1,  3025,  1042,    -1,   180,    -1,    -1,   397,    72,    -1,
      74,    -1,   268,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2822,    -1,    -1,    -1,   285,
      -1,  1071,    -1,    -1,    36,    -1,   100,    39,    -1,   215,
     430,    -1,    -1,    -1,    46,    47,   302,    -1,  1088,    -1,
      -1,  1091,    -1,    -1,    -1,    -1,    -1,  3081,  3082,  3083,
    3084,  3085,    -1,   239,  3088,  3089,  3090,  3091,  3092,  3093,
    3094,  3095,  3096,  3097,  3098,    -1,    -1,  3101,    -1,    -1,
    2877,  3105,    -1,    -1,    -1,    -1,    -1,   477,    -1,    -1,
      -1,    -1,  2698,  2699,  2700,    -1,    -1,  3121,   100,  3123,
      -1,   179,   492,   493,  3128,   361,    -1,  1147,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   180,    -1,    -1,    -1,
      -1,    -1,    -1,   299,   380,   381,   382,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1181,   398,   533,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   215,  3249,    -1,   544,   233,   234,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2961,  2962,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   237,    -1,   239,   566,    -1,   180,    -1,
      -1,   571,    -1,  2980,    -1,    -1,   362,    -1,  3212,  3213,
     580,    -1,    -1,   583,    -1,    -1,    -1,    -1,  2995,   589,
    3297,   279,   280,    -1,  3301,  3229,    -1,    -1,    -1,  3006,
    3234,  3235,    -1,   215,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   285,    -1,   287,    -1,    -1,    -1,  3251,    -1,  3026,
    3254,  3255,    -1,  1273,    -1,   299,    -1,   239,    -1,    -1,
      -1,    -1,    -1,  3040,    -1,   323,  3043,    -1,    -1,   505,
      -1,    -1,    -1,   429,    -1,   431,   432,    -1,   336,    -1,
      -1,    -1,    -1,    -1,  3288,  3362,   344,    -1,    -1,    -1,
     446,    -1,    -1,   351,    -1,    -1,    -1,  3074,    -1,    -1,
    3077,  3078,  3079,  3080,    -1,    -1,    -1,    -1,    -1,    -1,
    3087,    -1,  1332,    -1,   470,    -1,  1336,   299,   362,   377,
    1340,    -1,    -1,  3100,    -1,  3102,    -1,    -1,    -1,    -1,
      -1,   375,   376,  1353,    -1,  3112,  1356,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   341,
    3137,  3138,  3139,  3140,  3141,  3142,  3143,  3144,  3145,  3146,
    3147,  3148,  3149,  3150,  3151,  3152,  3153,  3154,  3155,    -1,
     362,    46,  1402,    -1,    -1,   429,  3163,   431,   432,    -1,
      -1,  3168,    -1,   549,    -1,    -1,    -1,    -1,    -1,  3176,
      -1,    -1,   446,    -1,    -1,    -1,    -1,    72,    73,    74,
      75,  3188,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   470,    -1,    -1,    -1,
      -1,    -1,  3209,  3210,    -1,    -1,    -1,    -1,    -1,    -1,
    3291,  3292,    -1,    -1,    -1,    -1,    -1,   429,  3225,   431,
     432,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1478,  1479,
    1480,  3238,  3313,    -1,   446,    -1,   524,    -1,    -1,    -1,
     528,    -1,   530,    -1,    -1,    -1,    -1,    -1,    -1,  3256,
      -1,  3332,    -1,    -1,    -1,    -1,    -1,    -1,   470,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1518,    -1,
      -1,  3278,    -1,    -1,    -1,   549,    -1,    -1,    -1,    -1,
    3361,    -1,    -1,    -1,  3291,  3292,    -1,    -1,    -1,    -1,
    1540,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3307,    -1,    -1,    -1,    -1,    -1,  3313,    -1,   582,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3325,  3326,
      -1,    -1,    -1,  1573,  1574,  3332,    -1,    -1,    -1,    -1,
      -1,  3338,    -1,    -1,    -1,    -1,    -1,   549,    -1,    -1,
      -1,   236,  1592,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3357,    -1,    31,    -1,  3361,    -1,    -1,    36,    -1,    -1,
      39,    -1,     1,    -1,     3,    -1,     5,    46,    47,    -1,
     265,    10,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    18,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     285,    -1,   287,    72,    -1,    74,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    -1,    -1,
      -1,   100,    -1,    -1,  1674,    -1,    -1,    -1,    67,    -1,
     325,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      79,    -1,    -1,    -1,    83,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   348,    -1,    -1,    -1,    -1,    97,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   111,    -1,    -1,    -1,   371,    -1,    -1,  1729,
      -1,    -1,   121,   378,    -1,    -1,    -1,    -1,   127,    -1,
     129,    -1,    -1,   132,    -1,   134,  1746,    -1,    -1,    -1,
      -1,   180,    -1,    -1,    -1,   144,   145,    -1,   147,   148,
     149,   150,   151,   152,   153,   154,   155,    -1,   157,   158,
     159,    -1,   161,   162,   163,   164,   165,   166,   167,   168,
     169,   170,   171,    -1,    -1,    -1,   215,    -1,   177,    -1,
      -1,    -1,    -1,   182,    -1,   184,    -1,   186,    -1,    -1,
     189,    -1,    -1,    -1,  1804,    -1,  1806,    -1,    -1,    -1,
     239,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   464,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     475,   220,    -1,    -1,    -1,    -1,    -1,    -1,   227,    -1,
      -1,   230,   231,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1850,   496,  1852,    -1,   243,    -1,   285,    -1,    -1,    -1,
      -1,    -1,   251,    -1,   253,    -1,    -1,   256,    -1,    -1,
     299,    -1,   261,    -1,    -1,    -1,    -1,    -1,   523,    -1,
      -1,   310,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   546,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   341,    -1,    -1,    -1,    -1,   306,    -1,    -1,
      -1,    -1,   567,   312,    -1,   314,    -1,    -1,    -1,   574,
      -1,    -1,   577,   362,    -1,    -1,   325,    -1,  1938,   328,
      -1,    -1,    -1,    -1,   333,   334,   335,   376,   337,   338,
     339,   340,  1952,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   354,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1975,    -1,    -1,    -1,   368,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     429,    -1,   431,   432,    -1,    -1,   395,  3026,    -1,    -1,
      -1,   400,   401,   402,  2014,  2015,  2016,   446,    -1,    -1,
      -1,  2021,  2022,   412,    -1,    -1,    -1,  2027,  2028,  2029,
      -1,  2031,    -1,    -1,    -1,    -1,   425,    -1,   427,    -1,
      -1,   470,    -1,    -1,    -1,   434,    -1,    -1,    -1,   438,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   448,
      -1,    91,    -1,    -1,    -1,    -1,    -1,   456,    -1,    -1,
      -1,    -1,   461,    -1,    -1,    -1,  2076,    -1,   108,    -1,
      -1,    -1,   471,    -1,   473,  2085,  2086,  2087,  2088,    -1,
      -1,    -1,    -1,   482,    -1,    -1,    -1,    -1,   487,   488,
    2100,    -1,  2102,    -1,    -1,   494,    -1,    -1,   497,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   507,    -1,
     549,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   560,    -1,    -1,   523,    -1,  2136,    -1,    -1,    -1,
    2140,    -1,    -1,    -1,    -1,   534,     6,    -1,    -1,     9,
      -1,    -1,    -1,   582,   543,     1,    -1,     3,    -1,     5,
      20,    -1,   551,    -1,    10,    -1,    -1,   556,    -1,    -1,
      -1,    -1,    18,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   217,   218,   219,
     579,    -1,    -1,    -1,    -1,    -1,   226,   586,    -1,    -1,
    2200,    -1,    -1,    -1,    -1,    -1,    52,    53,    -1,    -1,
     240,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    67,  2222,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    91,    -1,    79,    -1,    -1,    -1,    83,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   277,   108,    -1,
      -1,    97,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   289,
      -1,    -1,   292,   293,   294,    -1,    -1,    -1,   298,    -1,
     300,    -1,  3291,  3292,    -1,   121,    -1,    -1,    -1,    -1,
      -1,   127,    -1,   129,    -1,    -1,   132,    -1,   134,    -1,
      -1,    -1,    -1,    -1,  3313,    -1,    -1,    -1,   144,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3332,    -1,    -1,   346,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   171,    -1,    -1,    -1,    -1,
     190,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   184,    -1,
      -1,    -1,  3361,   189,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     9,  2356,   217,   218,   219,
      -1,    -1,    -1,    -1,    -1,    -1,   226,   397,    -1,    -1,
      -1,    -1,    -1,    -1,   220,    -1,    -1,    -1,    -1,    -1,
     240,   227,    -1,    -1,   230,   231,    -1,  2387,    -1,  2389,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,    -1,
     430,    -1,   262,    -1,    -1,   251,    -1,   253,    -1,    63,
     256,    -1,    -1,  2413,    -1,    -1,    -1,   277,   278,    -1,
      -1,    -1,    -1,    -1,   284,    -1,   286,    -1,    -1,   289,
      -1,    -1,   292,   293,   294,    -1,    -1,    91,   298,    -1,
     300,    -1,    -1,    -1,    -1,    -1,    -1,   477,    -1,   309,
      -1,    -1,    -1,    -1,   108,    -1,    -1,    -1,    -1,    -1,
     306,    -1,   492,   493,    -1,    -1,   312,    -1,   314,    -1,
      -1,   331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   325,
      -1,    -1,    -1,    -1,    -1,    -1,   346,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   357,    -1,    -1,
      -1,    -1,    -1,   533,    -1,    -1,   366,    -1,   354,    -1,
      -1,    -1,    -1,    -1,   544,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   368,    -1,    -1,    -1,    -1,  2527,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   566,   397,    -1,    -1,
      -1,   571,    -1,  2543,  2544,   199,    -1,    -1,    -1,   395,
     580,    -1,    -1,   583,   400,   401,   402,    -1,    -1,   589,
      -1,    -1,    -1,   217,   218,   219,   412,    -1,    -1,    -1,
     430,    -1,   226,    -1,    -1,    -1,  2576,    -1,    -1,   425,
      -1,   427,    -1,    -1,    -1,    -1,   240,    -1,   434,    -1,
      -1,    -1,   438,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   448,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     456,    -1,    -1,    -1,    -1,   461,    -1,   477,    -1,   273,
      -1,    -1,    -1,   277,    -1,    -1,    -1,   473,    -1,    -1,
      -1,    -1,   492,   493,    -1,   289,   482,    -1,   292,   293,
     294,   487,   488,    -1,   298,    -1,   300,    -1,   494,    -1,
      -1,   497,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     520,   507,   522,  2663,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   531,   532,   533,    -1,   535,   536,   523,    -1,  2679,
      -1,  2681,  2682,    -1,   544,    -1,    -1,  2687,    -1,    -1,
      -1,    -1,   346,    -1,    -1,    -1,  2696,   543,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   551,   566,    -1,    -1,    -1,
     556,   571,    -1,    -1,    -1,  2715,    -1,    -1,    -1,    -1,
     580,    91,    -1,   583,    -1,    -1,    -1,    -1,    -1,   589,
      -1,    -1,    -1,     1,    -1,     3,    -1,     5,   108,    -1,
     586,    -1,    10,   397,    -1,    -1,    -1,    -1,    -1,    -1,
      18,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2767,  2768,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   430,    -1,    -1,    -1,
      -1,    -1,  2782,    -1,    52,    53,    -1,    -1,  2788,    -1,
      -1,  2791,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    67,
    2800,  2801,  2802,  2803,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    79,    -1,  2813,    -1,    83,     6,    -1,    -1,     9,
      -1,    -1,    -1,   477,    -1,  2825,    -1,    -1,    -1,    97,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   492,   493,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   217,   218,   219,
      -1,    -1,    -1,   121,    -1,    -1,   226,    -1,    -1,   127,
      -1,   129,    -1,    -1,   132,    -1,   134,  2867,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   144,    -1,    -1,   533,
      -1,    -1,    -1,  2883,    -1,    -1,    -1,    -1,   542,    -1,
     544,    -1,    -1,    -1,    -1,    -1,  2896,  2897,    -1,    -1,
      -1,    91,    -1,   171,    -1,  2905,    -1,   277,    -1,    -1,
    2910,  2911,   566,    -1,    -1,    -1,   184,   571,   108,   289,
    2920,   189,   292,   293,   294,    -1,   580,    -1,   298,   583,
      -1,    -1,    -1,    -1,    -1,   589,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2943,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2951,   220,    -1,    -1,    -1,    -1,    -1,    -1,   227,
      -1,    -1,   230,   231,    -1,    -1,    -1,    -1,    -1,    -1,
    2970,    -1,  2972,    -1,    -1,   243,   346,    -1,    -1,    -1,
      -1,   171,    -1,   251,    -1,   253,    -1,    -1,   256,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     1,    -1,     3,    -1,     5,
      -1,    -1,    -1,    -1,    10,    -1,    -1,   217,   218,   219,
      -1,    -1,    18,    -1,    -1,    -1,   226,    -1,   306,    -1,
      -1,    -1,    -1,    -1,   312,    -1,   314,    -1,    -1,    -1,
     240,    -1,    -1,    -1,    -1,    -1,    -1,   325,  3058,    -1,
     430,    -1,    -1,    -1,    -1,    -1,    52,    53,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    67,    -1,    -1,    -1,    -1,   354,   277,   278,    -1,
      -1,    -1,    -1,    79,   284,    -1,   286,    83,    -1,   289,
     368,    -1,   292,   293,   294,    -1,    -1,    -1,   298,    -1,
     300,    97,    -1,  3113,    -1,    -1,    -1,    -1,  3118,   309,
      -1,    -1,   492,   493,    -1,    -1,    -1,   395,    -1,    -1,
      -1,    -1,   400,   401,   402,   121,    -1,    -1,    -1,    -1,
      -1,   127,    -1,   129,   412,    -1,   132,    -1,   134,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   346,   425,   144,   427,
      -1,    -1,    -1,    -1,    -1,    -1,   434,    -1,    -1,    -1,
     438,    -1,    -1,    -1,   544,    -1,   366,    -1,    -1,    -1,
     448,    -1,    -1,    -1,    -1,   171,    -1,    -1,   456,    -1,
      -1,    -1,    -1,   461,    -1,    -1,   566,    -1,   184,    -1,
      -1,   571,  3202,   189,    -1,   473,  3206,   397,    -1,    -1,
     580,    -1,    -1,   583,   482,    -1,    -1,    -1,    -1,   487,
     488,    -1,    -1,    -1,    -1,    -1,   494,    -1,    -1,   497,
      -1,    -1,    -1,    -1,   220,    -1,    -1,    -1,    -1,   507,
     430,   227,    -1,    -1,   230,   231,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   523,    -1,   243,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   251,    -1,   253,    -1,    -1,
     256,    -1,    -1,    -1,    -1,   543,    -1,    -1,    -1,    -1,
     470,    -1,    -1,   551,    -1,    -1,    -1,   477,   556,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   492,   493,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   586,    -1,
     306,    -1,    -1,    -1,    -1,    -1,   312,    -1,   314,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   526,    -1,    -1,   325,
      -1,    -1,    -1,   533,    -1,    -1,    -1,   537,    -1,    -1,
      -1,    -1,    -1,    -1,   544,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   354,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,    -1,
      -1,   571,   368,    -1,    -1,     3,    -1,     5,    -1,    -1,
     580,    -1,    10,   583,    -1,    -1,    -1,    -1,    -1,   589,
      18,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   395,
      -1,    -1,    -1,    -1,   400,   401,   402,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   412,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,   425,
      -1,   427,    -1,    -1,    -1,    -1,    -1,    -1,   434,    67,
      -1,    -1,   438,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    79,   448,    -1,    -1,    83,    -1,    -1,    -1,    -1,
     456,    -1,    -1,    -1,    -1,   461,    -1,    -1,    -1,    97,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   473,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   482,    -1,    -1,    -1,
      -1,   487,   488,   121,    -1,    -1,    -1,    -1,   494,    -1,
      -1,   497,    -1,    -1,   132,    -1,   134,    -1,    -1,    -1,
      -1,   507,    -1,    -1,    -1,    -1,    -1,   145,    -1,    -1,
     148,   149,   150,   151,   152,   153,   154,   155,    -1,   157,
     158,   159,    -1,   161,   162,   163,   164,   165,   166,   167,
     168,   169,   170,   171,    -1,    -1,    -1,   543,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   551,   184,    -1,    -1,    -1,
     556,   189,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     6,
      -1,    -1,     9,    -1,    -1,    12,    13,    14,    -1,    -1,
      -1,    -1,    -1,    20,    -1,    -1,    -1,    -1,    -1,    -1,
     586,    -1,   220,    -1,    -1,    -1,    -1,    -1,    -1,   227,
      -1,    -1,   230,   231,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   243,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   251,    -1,   253,    -1,    -1,   256,    66,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    91,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   108,    -1,    -1,    -1,    -1,    -1,    -1,   306,    -1,
      -1,    -1,    -1,    -1,   312,    -1,   314,    -1,    -1,    -1,
      -1,     6,    -1,    -1,     9,    -1,    -1,   325,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    31,    -1,    -1,    -1,
      -1,    36,    -1,    -1,    39,    -1,   354,    -1,    -1,    -1,
      -1,    46,    47,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     368,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   190,    -1,    -1,    -1,    72,    -1,    74,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   400,    -1,    -1,    -1,    91,    -1,    -1,    -1,
     217,   218,   219,    -1,   412,   100,    -1,    -1,    -1,   226,
      -1,    -1,    -1,   108,    -1,    -1,   233,   234,    -1,   427,
      -1,    -1,    -1,   240,    -1,    -1,   434,    -1,    -1,    -1,
     438,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     448,    -1,    -1,    -1,    -1,   262,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   461,    -1,    -1,    -1,    -1,    -1,    -1,
     277,   278,   279,   280,    -1,   473,    -1,   284,    -1,   286,
      -1,    -1,   289,    -1,   482,   292,   293,   294,    -1,   487,
     488,   298,    -1,   300,    -1,   180,   494,    -1,    -1,   497,
      -1,    -1,   309,    -1,    -1,    -1,    -1,    -1,    -1,   507,
      -1,    -1,    -1,    -1,    -1,    -1,   323,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   331,   523,    -1,    -1,    -1,   336,
     215,    -1,   217,   218,   219,    -1,    -1,   344,    -1,   346,
      -1,   226,    -1,     6,   351,   543,     9,    -1,    -1,    -1,
     357,    -1,    -1,   551,   239,   240,    -1,    -1,   556,   366,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     377,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   586,    -1,
     397,    -1,   277,   278,    -1,    -1,    -1,    -1,    -1,   284,
     285,   286,    -1,    -1,   289,    -1,    -1,   292,   293,   294,
      -1,    -1,    -1,   298,   299,   300,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   430,   309,   310,    -1,    -1,    91,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   108,    -1,    -1,    -1,    -1,
       6,    -1,    -1,     9,    -1,    -1,   341,    -1,    -1,    -1,
      -1,   346,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     477,    -1,    -1,    -1,    -1,    -1,    -1,   362,    -1,    -1,
      -1,   366,    -1,    -1,    -1,   492,   493,    -1,    -1,    -1,
      -1,   376,    -1,    -1,    50,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   397,   520,    -1,   522,    -1,   524,    -1,    -1,
      -1,   528,    -1,   530,   531,   532,   533,    -1,   535,   536,
      -1,    -1,    -1,    -1,    -1,    91,    -1,   544,    -1,    -1,
      96,    -1,    -1,    -1,   429,   430,   431,   432,   211,    -1,
      -1,    -1,   108,    -1,   217,   218,   219,    -1,    -1,   566,
      -1,   446,    -1,   226,   571,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   580,    -1,    -1,   583,   240,    -1,    -1,
      -1,    -1,   589,    -1,   247,   470,    -1,    -1,    -1,    -1,
      -1,    -1,   477,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,     6,   492,   493,     9,
      -1,    -1,    -1,    -1,   277,   278,    -1,    -1,    -1,    -1,
      -1,   284,    -1,   286,    -1,    -1,   289,    -1,    -1,   292,
     293,   294,    -1,    -1,    -1,   298,    -1,   300,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   309,    -1,   533,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   544,
      -1,   217,   218,   219,   549,    -1,    -1,    -1,    -1,    -1,
     226,    -1,    -1,    -1,    -1,   560,    -1,    -1,    -1,    -1,
      -1,   566,    -1,   346,   240,    -1,   571,    -1,   351,    -1,
      -1,    91,    -1,    -1,    -1,   580,    -1,   582,   583,    -1,
      -1,    -1,    -1,   366,   589,    -1,    -1,    -1,   108,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   277,   278,    -1,    -1,    -1,    -1,    -1,   284,    -1,
     286,    -1,    -1,   289,   397,    -1,   292,   293,   294,    -1,
      -1,    -1,   298,    -1,   300,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   309,    -1,    -1,    -1,    -1,    -1,    -1,
       6,    -1,    -1,     9,    -1,    -1,    -1,   430,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   181,    -1,    -1,    -1,    -1,    -1,    -1,     6,    -1,
     346,     9,    -1,    -1,    -1,   351,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     366,    -1,    -1,    -1,   477,    -1,   479,   217,   218,   219,
      -1,    -1,    -1,    -1,    -1,    -1,   226,    -1,   228,   492,
     493,    -1,   495,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     240,   397,    -1,    -1,    -1,    91,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   409,    -1,    -1,    -1,   103,    -1,    -1,
      -1,    -1,   108,    -1,    -1,    -1,   529,    -1,    -1,    -1,
     533,    -1,    -1,    91,   430,    -1,    -1,   277,   278,    -1,
      -1,   544,    -1,    -1,   284,   103,   286,    -1,    -1,   289,
     108,    -1,   292,   293,   294,    -1,    -1,    -1,   298,    -1,
     300,    -1,    -1,   566,    -1,    -1,    -1,    -1,   571,   309,
      -1,    -1,    -1,    -1,   470,    -1,    -1,   580,   581,    -1,
     583,   477,    -1,    -1,    -1,    -1,   589,    -1,    -1,    -1,
     330,    -1,    -1,    -1,    -1,    -1,   492,   493,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   346,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   366,    -1,    -1,    -1,
      -1,   217,   218,   219,    -1,    -1,    -1,   533,    -1,    -1,
     226,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   544,    -1,
      -1,    -1,    -1,    -1,   240,    -1,   552,   397,    -1,   217,
     218,   219,    -1,    -1,    -1,    -1,    -1,    -1,   226,    -1,
     566,    -1,    -1,    -1,    -1,   571,    -1,    -1,   574,    -1,
      -1,    -1,   240,    -1,   580,    -1,    -1,   583,   428,    -1,
     430,   277,   278,   589,    -1,    -1,    -1,    -1,   284,    -1,
     286,    -1,    -1,   289,    -1,    -1,   292,   293,   294,    -1,
      -1,    -1,   298,    -1,   300,    -1,    -1,    -1,     6,   277,
     278,     9,    -1,   309,    -1,    -1,   284,    -1,   286,    -1,
      -1,   289,    -1,    -1,   292,   293,   294,   477,    -1,    -1,
     298,    -1,   300,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   309,   492,   493,    -1,    -1,    -1,    -1,    -1,    -1,
     346,     6,    -1,    -1,     9,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     366,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   346,    -1,
      -1,    -1,    -1,   533,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    91,   544,    -1,    -1,    -1,   366,    -1,
      -1,   397,    -1,    -1,    -1,   103,     6,    -1,    -1,     9,
     108,    -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,    -1,
      -1,   571,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   397,
     580,    -1,   582,   583,   430,    -1,    91,    -1,    -1,   589,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   108,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   430,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   477,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    91,    -1,    -1,    -1,    -1,   492,   493,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   503,   108,   477,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   217,
     218,   219,    -1,    -1,   492,   493,    -1,    -1,   226,    -1,
      -1,    -1,    -1,    -1,    -1,   503,    -1,   533,    -1,    -1,
      -1,    -1,   240,    -1,    -1,    -1,    -1,    -1,   544,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   217,   218,   219,   533,    -1,    -1,    -1,    -1,
     566,   226,    -1,    -1,    -1,   571,   544,    -1,    -1,   277,
     278,    -1,    -1,    -1,   580,   240,   284,   583,   286,    -1,
      -1,   289,    -1,   589,   292,   293,   294,    -1,   566,    -1,
     298,    -1,   300,   571,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   309,   580,    -1,    -1,   583,    -1,   217,   218,   219,
      -1,   589,   277,   278,    -1,    -1,   226,    -1,    -1,   284,
      -1,   286,     6,    -1,   289,     9,    -1,   292,   293,   294,
     240,    -1,    -1,   298,    -1,   300,    -1,    -1,   346,    -1,
      -1,    -1,    -1,    -1,   309,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   366,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   277,   278,    -1,
      -1,    -1,    -1,    -1,   284,    -1,   286,     6,    -1,   289,
       9,   346,   292,   293,   294,    -1,    -1,    -1,   298,   397,
     300,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   309,
      -1,   366,    -1,    -1,    -1,    -1,    -1,    91,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       6,    -1,   430,     9,   108,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   397,    -1,    -1,    -1,   346,    -1,    -1,    -1,
      -1,   351,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   366,    -1,    -1,    -1,
      -1,    -1,    91,    -1,    -1,   430,    -1,    -1,    -1,   477,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   108,
      -1,    -1,    -1,    -1,   492,   493,    -1,   397,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    91,    -1,    -1,    -1,    -1,
      -1,    -1,   477,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     430,    -1,   108,    -1,    -1,   533,    -1,   492,   493,    -1,
      -1,    -1,    -1,   217,   218,   219,   544,    -1,    -1,    -1,
      -1,    -1,   226,     6,    -1,    -1,     9,    -1,    -1,    -1,
      -1,    -1,    -1,   518,    -1,    -1,   240,    -1,   566,    -1,
      -1,    -1,    -1,   571,    -1,    -1,    -1,   477,   533,    -1,
      -1,    -1,   580,    -1,   258,   583,    -1,    -1,    -1,   544,
      -1,   589,   492,   493,    -1,    -1,    -1,    -1,   217,   218,
     219,    -1,   221,   277,   278,    -1,    -1,   226,    -1,    -1,
     284,   566,   286,    -1,    -1,   289,   571,    -1,   292,   293,
     294,   240,    -1,    -1,   298,   580,   300,    -1,   583,    -1,
      -1,    -1,    -1,   533,   589,   309,    -1,    -1,    91,    -1,
      -1,   217,   218,   219,   544,    -1,    -1,    -1,    -1,    -1,
     226,     6,    -1,    -1,     9,   108,    -1,    -1,   277,   278,
      -1,    -1,    -1,    -1,   240,   284,   566,   286,    -1,    -1,
     289,   571,   346,   292,   293,   294,    -1,    -1,    -1,   298,
     580,   300,    -1,   583,    -1,    -1,    -1,    -1,    -1,   589,
     309,    -1,   366,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   277,   278,    -1,    -1,    -1,    -1,    -1,   284,    -1,
     286,    -1,    -1,   289,    -1,    -1,   292,   293,   294,    -1,
      -1,    -1,   298,   397,   300,    -1,    -1,   346,    -1,    -1,
      -1,    -1,    -1,   309,    -1,    -1,    91,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   366,    -1,    -1,
      -1,    -1,    -1,   108,    -1,    -1,   430,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   217,   218,   219,    -1,    -1,    -1,
     346,    -1,    -1,   226,    -1,    -1,    -1,    -1,   397,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   240,    -1,    -1,
     366,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   477,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   430,    -1,    -1,    -1,    -1,    -1,    -1,   492,   493,
      -1,   397,    -1,    -1,   277,   278,    -1,    -1,    -1,    -1,
      -1,   284,    -1,   286,    -1,    -1,   289,    -1,    -1,   292,
     293,   294,    -1,    -1,    -1,   298,    -1,   300,    -1,    -1,
      -1,    -1,    -1,    -1,   430,    -1,   309,    -1,   477,   533,
      -1,    -1,   217,   218,   219,    -1,    -1,    -1,    -1,    -1,
     544,   226,    -1,   492,   493,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   240,    -1,    -1,    -1,    -1,
      -1,    -1,   566,   346,   470,    -1,    -1,   571,    -1,    -1,
      -1,   477,    -1,    -1,    -1,    -1,   580,    -1,    -1,   583,
      -1,    -1,    -1,   366,   533,   589,   492,   493,    -1,    -1,
      -1,    -1,   277,   278,    -1,   544,    -1,    -1,    -1,   284,
      -1,   286,    -1,    -1,   289,    -1,    -1,   292,   293,   294,
      -1,    -1,    -1,   298,   397,   300,    -1,   566,    -1,    -1,
      -1,    -1,   571,    -1,   309,    -1,    -1,   533,    -1,    -1,
      -1,   580,    -1,    -1,   583,    -1,    -1,    -1,   544,    -1,
     589,    -1,    -1,    -1,    -1,    -1,    -1,   430,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     566,   346,    -1,    -1,    -1,   571,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   580,    -1,    -1,   583,    -1,    -1,
      -1,   366,    -1,   589,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   477,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   492,
     493,    -1,   397,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   430,    -1,    -1,    -1,    -1,
     533,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   544,    33,    -1,    -1,    36,    -1,    -1,    39,    40,
      41,    42,    43,    44,    45,    46,    47,    -1,    -1,    -1,
      -1,    -1,    -1,   566,    -1,    -1,    -1,    -1,   571,    -1,
      -1,    -1,   477,    -1,    -1,    -1,    -1,   580,    -1,    -1,
     583,    72,    -1,    74,    -1,    -1,   589,   492,   493,    -1,
      -1,    82,    -1,    84,    85,    86,    87,    88,    89,    90,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   533,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   544,
      -1,   132,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   566,    -1,    -1,    -1,    -1,   571,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   580,    -1,    -1,   583,    -1,
      -1,    -1,    -1,    -1,   589,    -1,    -1,    -1,    -1,   180,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   197,    -1,    -1,    -1,
      -1,   202,   203,   204,   205,   206,    -1,    -1,   209,   210,
      -1,    -1,    -1,    -1,   215,    -1,    -1,    -1,    -1,    -1,
     221,    -1,   223,    -1,    -1,    -1,    -1,    -1,   229,    -1,
      -1,    -1,    -1,    -1,   235,    -1,   237,    -1,   239,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   248,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   262,    -1,    -1,   265,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,    -1,   275,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   285,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   299,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   316,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   327,    -1,   329,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   348,    -1,   350,
      -1,    -1,    -1,    -1,    -1,     1,    -1,    -1,    -1,    -1,
      -1,   362,   363,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     371,    -1,    -1,   374,    -1,    21,    -1,    -1,     9,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     391,    37,   393,    -1,    40,    41,    42,    43,    44,    45,
      46,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      51,   422,    -1,    -1,    -1,    -1,    -1,    -1,   429,    -1,
     431,   432,    -1,    -1,    -1,    -1,    82,    -1,    84,    85,
      86,    87,    88,    89,    90,    -1,    -1,    -1,    -1,    -1,
     451,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      91,    -1,    -1,   464,    -1,   466,   467,   468,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   108,    -1,     9,
      -1,    -1,    -1,    -1,    -1,    -1,   132,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   502,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   518,    -1,    -1,
      -1,    51,   523,    -1,    -1,    -1,    -1,    -1,   529,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   542,    -1,    -1,    -1,    -1,   192,    -1,   549,    -1,
      -1,   197,   553,   554,   555,    -1,   202,   203,   204,   205,
     206,    91,    -1,   209,   210,    -1,   567,    -1,    -1,    -1,
      -1,   572,    -1,   574,    -1,    -1,    -1,    -1,   108,    -1,
      -1,    -1,   583,   229,    -1,   216,   217,   218,   219,    -1,
      -1,   237,    -1,    -1,    -1,   226,     9,    -1,    -1,    -1,
      -1,    -1,   248,    -1,    -1,    -1,    -1,    -1,    -1,   240,
      -1,    -1,    -1,    -1,    -1,    -1,   262,    -1,    -1,   265,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   276,   277,   278,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   289,    -1,
      -1,   292,   293,   294,    -1,    -1,    -1,   298,    -1,   300,
     316,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    91,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   216,   217,   218,   219,
      -1,    -1,    -1,    -1,    -1,   108,   226,    -1,    -1,    -1,
      -1,    -1,   348,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     240,    -1,    -1,    -1,    -1,   346,    -1,   363,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   371,    -1,    -1,   374,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   391,   276,   277,   278,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   289,
      -1,   407,   292,   293,   294,    -1,   397,    -1,   298,    -1,
     300,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   430,
      -1,    -1,    -1,    -1,   217,   218,   219,    -1,    -1,    -1,
      -1,    -1,    -1,   226,    -1,    -1,   346,    -1,   464,    -1,
     466,   467,   468,    -1,    -1,    -1,    -1,   240,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   477,    -1,    -1,    -1,
      -1,    -1,    -1,   499,    -1,    -1,    -1,    -1,    -1,    -1,
     273,   492,   493,    -1,   277,    -1,    -1,   397,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   289,   523,   509,   292,
     293,   294,    -1,    -1,    -1,   298,    -1,   300,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   542,    -1,    -1,    -1,
     430,    -1,   533,    -1,    -1,    -1,    -1,   553,   554,   555,
      -1,    -1,    -1,   544,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   567,    -1,    -1,    -1,    -1,   557,    -1,   574,    -1,
      -1,    -1,    -1,   346,    -1,   566,    -1,   583,    -1,    -1,
     571,    -1,    -1,    -1,    -1,    -1,   577,   477,    -1,   580,
      -1,   582,   583,    -1,    -1,    -1,    -1,    -1,   589,    -1,
      -1,    -1,   492,   493,    -1,    -1,    -1,    -1,    -1,    -1,
      31,    -1,    33,    -1,    -1,    36,    -1,    38,    39,   509,
      -1,    -1,    -1,    -1,   397,    -1,    47,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   533,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    -1,    74,   544,    -1,    -1,   430,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   557,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,   100,
      -1,   571,    -1,    -1,    -1,    -1,    21,   577,    -1,    -1,
     580,    -1,   582,   583,    -1,    -1,    -1,    -1,   119,   589,
      -1,    -1,    37,    -1,   477,    40,    41,    42,    43,    44,
      45,    46,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   492,
     493,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    82,    -1,    84,
      85,    86,    87,    88,    89,    90,    -1,    -1,    -1,    -1,
     533,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   542,
      -1,   544,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   566,   215,    -1,    -1,   132,   571,    -1,
      -1,   222,   223,    -1,    -1,    -1,    -1,   580,    -1,    -1,
     583,    -1,    -1,    -1,    -1,    -1,   589,    -1,   239,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   275,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   285,    -1,    -1,   202,   203,   204,
     205,   206,    -1,    -1,   209,   210,   297,    -1,   299,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   310,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   237,    -1,    -1,    -1,   327,    -1,   329,    -1,
      -1,    -1,    -1,   248,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   262,    -1,   350,
     265,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,    -1,
      -1,   362,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   376,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   393,   394,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   316,    -1,    -1,    33,    -1,    -1,    36,    -1,    -1,
      39,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    47,    -1,
      -1,   422,    -1,    -1,    -1,    -1,    -1,    -1,   429,    33,
     431,   432,    36,   348,    -1,    39,    40,    41,    42,    43,
      44,    45,    46,    47,    -1,   446,    -1,    -1,   363,    -1,
     451,    -1,    -1,    -1,    -1,    -1,   371,    -1,    -1,   374,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,   470,
      74,   100,    -1,    -1,    -1,    -1,   391,    -1,    82,    -1,
      84,    85,    86,    87,    88,    89,    90,    -1,    -1,    -1,
     119,    -1,   407,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   502,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   515,   516,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   549,   464,
      -1,   466,   467,   468,    -1,    -1,    -1,    -1,   559,    -1,
      -1,    -1,    -1,    -1,   565,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   180,    -1,    -1,    -1,
      -1,   582,    -1,    -1,   499,    -1,   215,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   223,    -1,    -1,    -1,   202,   203,
     204,   205,   206,    -1,    -1,   209,   210,    -1,   523,    -1,
     239,   215,    -1,    -1,    -1,    -1,    -1,   221,    -1,   223,
      -1,    -1,    -1,    -1,    -1,   229,    -1,   542,    -1,    -1,
      -1,   235,    -1,   237,    -1,   239,    -1,    -1,   553,   554,
     555,    -1,    -1,    -1,   248,    -1,   275,    -1,    -1,    -1,
      -1,    -1,   567,    -1,    -1,    -1,    -1,    -1,   262,   574,
      -1,   265,    -1,    -1,    -1,    -1,    -1,    -1,   297,    -1,
     299,   275,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   285,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   299,    -1,    -1,   327,    -1,
     329,    -1,    -1,    -1,    -1,    40,    41,    42,    43,    44,
      45,    -1,   316,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   350,    -1,   327,    -1,   329,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   362,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   348,    -1,   350,    82,    -1,    84,
      85,    86,    87,    88,    89,    90,    -1,    -1,   362,   363,
      -1,    -1,    -1,    -1,   393,   394,    -1,   371,    -1,    -1,
     374,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   391,    -1,   393,
      -1,    -1,    -1,   422,    -1,    -1,    -1,   132,    -1,    -1,
     429,    -1,   431,   432,    -1,    -1,    91,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   446,   422,    -1,
      -1,    -1,   451,   108,    -1,   429,    -1,   431,   432,    -1,
      -1,    91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   470,    -1,    -1,    -1,    -1,    -1,   451,   108,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     464,    -1,   466,   467,   468,    -1,    -1,   202,   203,   204,
     205,   206,    -1,   502,   209,   210,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   516,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   502,    -1,
      -1,    -1,   237,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   248,   518,    -1,    -1,    -1,    -1,   523,
     549,    -1,    -1,    -1,    -1,   529,    -1,    -1,    -1,    -1,
     559,    -1,   217,   218,   219,    -1,   565,    -1,    -1,    -1,
      -1,   226,    -1,    -1,    -1,   549,    -1,    -1,    91,   553,
     554,   555,    -1,    -1,    -1,   240,    -1,   217,   218,   219,
      -1,    -1,    -1,   567,    -1,   108,   226,    -1,   572,    -1,
     574,    -1,    -1,    -1,    91,    -1,    -1,    -1,    -1,    -1,
     240,   316,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   108,   277,   278,    -1,    -1,    -1,    -1,    -1,   284,
      -1,   286,    -1,    -1,   289,    -1,    -1,   292,   293,   294,
      -1,    -1,    -1,   298,    -1,   300,    -1,   277,   278,    -1,
      -1,    -1,    -1,    -1,   284,    -1,   286,    -1,   363,   289,
      -1,    -1,   292,   293,   294,    -1,    -1,    -1,   298,   374,
     300,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   391,    -1,    -1,    -1,
      -1,   346,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   217,   218,   219,    -1,    -1,    -1,
      -1,   366,    -1,   226,    -1,    -1,   346,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   240,    -1,    -1,
     217,   218,   219,    -1,    -1,    -1,   366,    -1,    -1,   226,
      -1,    -1,   397,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   240,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   466,   467,   468,   277,   278,    -1,   397,    -1,    -1,
      -1,   284,    -1,   286,    -1,   430,   289,    -1,    -1,   292,
     293,   294,    -1,    -1,    -1,   298,    -1,   300,    -1,    -1,
     277,   278,    -1,    -1,    -1,    -1,    -1,   284,    -1,   286,
     430,    -1,   289,    -1,    -1,   292,   293,   294,    -1,    -1,
      -1,   298,    -1,   300,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   477,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   346,    -1,    -1,    -1,   492,   493,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   477,   553,   554,
     555,    -1,    -1,   366,    -1,    -1,    -1,    -1,    -1,   346,
      -1,    -1,   492,   493,    -1,   520,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   531,    -1,   533,   366,
     535,   536,    -1,    -1,   397,    -1,    -1,    -1,    -1,   544,
     520,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   531,    91,   533,    -1,   535,   536,    -1,    -1,    -1,
     397,   566,    -1,    -1,   544,    -1,   571,   430,    -1,   108,
      -1,    -1,    -1,    -1,    -1,   580,    -1,    -1,   583,    -1,
      -1,    -1,    -1,    -1,   589,    -1,   566,    -1,    -1,    -1,
      -1,   571,    -1,   430,    -1,    -1,    -1,    -1,    -1,    -1,
     580,    -1,    -1,   583,    -1,    -1,    -1,    -1,    -1,   589,
      -1,    -1,    -1,    -1,   477,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   492,
     493,    -1,    -1,    -1,    -1,    -1,    -1,    91,   501,    -1,
     477,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      91,    -1,    -1,    -1,   108,   492,   493,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   501,    -1,    -1,   108,   531,    91,
     533,    -1,   535,   536,    -1,    -1,    -1,    -1,   217,   218,
     219,   544,    -1,    -1,    -1,    -1,   108,   226,    -1,    -1,
      -1,    -1,    -1,    -1,   531,    -1,   533,    -1,   535,   536,
      -1,   240,    -1,   566,    -1,    -1,    -1,   544,   571,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   580,    -1,    -1,
     583,    -1,    -1,    -1,    -1,    -1,   589,    -1,    -1,   566,
      -1,    -1,    -1,    -1,   571,    -1,    -1,    -1,   277,   278,
      -1,    -1,    -1,   580,    -1,   284,   583,   286,    -1,    -1,
     289,    -1,   589,   292,   293,   294,    -1,    -1,    -1,   298,
      -1,   300,    -1,   217,   218,   219,    -1,    -1,    -1,    -1,
      -1,    -1,   226,    -1,    -1,    -1,   217,   218,   219,    -1,
      -1,    -1,    -1,    -1,    -1,   226,   240,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   217,   218,   219,    -1,   240,
      -1,    -1,    -1,    -1,   226,    -1,    -1,   346,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   240,    -1,
      -1,    -1,    -1,   277,   278,    -1,    -1,   366,    -1,    -1,
     284,    -1,   286,    -1,    -1,   289,   277,   278,   292,   293,
     294,    -1,    -1,   284,   298,   286,   300,    -1,   289,    -1,
      -1,   292,   293,   294,    -1,   277,   278,   298,   397,   300,
      -1,    -1,   284,    -1,   286,    -1,    -1,   289,    -1,    -1,
     292,   293,   294,    -1,    -1,    -1,   298,    -1,   300,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   430,   346,    -1,    -1,    -1,    -1,    -1,    91,    -1,
      -1,    -1,    -1,    -1,    -1,   346,    -1,    -1,    -1,    -1,
      -1,    -1,   366,    -1,    -1,   108,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   346,   366,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   477,    -1,
      -1,    -1,    -1,   397,   366,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   492,   493,    -1,   397,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   397,   430,    -1,    -1,    -1,
      -1,   520,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   430,
      -1,    -1,   531,    -1,   533,    -1,   535,   536,    -1,    -1,
      -1,    -1,   424,    -1,    -1,   544,    -1,    -1,   430,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   477,   217,   218,   219,   566,    -1,    -1,
      -1,    -1,   571,   226,    -1,    -1,   477,    -1,   492,   493,
      -1,   580,    -1,    -1,   583,    -1,    -1,   240,    -1,    -1,
     589,   492,   493,    -1,    -1,   477,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     492,   493,    -1,    -1,    -1,    -1,    -1,   531,    -1,   533,
      -1,   535,   536,    -1,   277,   278,    -1,    -1,    -1,    -1,
     544,   284,   533,   286,   535,    -1,   289,    -1,    -1,   292,
     293,   294,    -1,   544,    -1,   298,    -1,   300,    -1,    -1,
      -1,   533,   566,    -1,    -1,    -1,    -1,   571,    -1,    -1,
      -1,    -1,   544,    -1,    -1,   566,   580,    -1,    -1,   583,
     571,    -1,    -1,    -1,    -1,   589,    -1,    -1,    -1,   580,
      -1,    -1,   583,    -1,   566,    -1,    -1,    -1,   589,   571,
      -1,    -1,    -1,   346,    -1,    -1,    -1,    -1,   580,    -1,
      -1,   583,    -1,    -1,    -1,    -1,    -1,   589,    -1,    -1,
      -1,    -1,    -1,   366,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   397,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   430,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   477,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   492,
     493,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     533,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   544,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   566,    -1,    -1,    -1,    -1,   571,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   580,    -1,    -1,
     583,    -1,    -1,    -1,    -1,    -1,   589
};

  /* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
static const yytype_uint16 yystos[] =
{
       0,   592,   593,     0,   594,   595,   596,   599,   600,   241,
     242,   597,   598,   601,   602,   608,   609,   173,   607,   629,
     630,   598,   225,   389,   610,   613,   135,   135,   111,   752,
     754,    93,   631,   635,   614,   611,   356,   622,   622,   523,
     523,   135,   385,   945,   948,   527,   755,   450,   255,   701,
     702,    11,    64,   105,   107,   109,   117,   185,   291,   344,
     347,   421,   445,   476,   478,   498,   583,   632,   633,   634,
     637,   638,   642,   654,   661,   662,   664,   665,   666,   667,
     673,   682,   684,   689,   692,   693,   695,   696,   697,   698,
     699,   700,   523,   523,   523,   607,   607,   523,   135,   972,
     973,   450,   756,   523,   450,   195,   703,     1,   583,  1440,
    1440,   484,   464,  1565,   262,  1543,  1543,  1543,  1440,   464,
     523,   523,  1543,   523,   523,    63,  1528,   668,   654,   661,
     642,   638,   637,   661,   637,   653,   654,   663,   664,   665,
     523,   666,   246,   683,   289,   390,   615,   615,   119,   623,
     624,   160,   603,   604,   605,   156,   606,   309,   483,   485,
     525,  1011,     1,     3,     5,    10,    18,    52,    53,    67,
      79,    83,    97,   121,   127,   129,   132,   134,   144,   171,
     184,   189,   220,   227,   230,   231,   243,   251,   253,   256,
     306,   312,   314,   325,   354,   368,   395,   400,   401,   402,
     412,   425,   427,   434,   438,   448,   456,   461,   473,   482,
     487,   488,   494,   497,   507,   523,   543,   551,   556,   586,
     974,   975,   993,   998,  1002,  1007,  1029,  1033,  1041,  1045,
    1046,  1047,  1050,  1055,  1060,  1091,  1095,  1097,  1100,  1114,
    1118,  1121,  1124,  1128,  1129,  1136,  1146,  1149,  1167,  1169,
    1172,  1176,  1183,  1195,  1197,  1212,  1213,  1223,  1226,  1227,
    1231,  1237,  1238,  1246,  1253,  1270,  1280,  1289,  1295,  1304,
    1308,  1310,  1313,  1316,  1319,  1346,   974,   523,   194,   447,
     753,   757,   758,   760,   523,   523,   705,   674,  1543,  1543,
    1543,   583,  1435,  1476,    76,  1435,  1543,  1543,   643,   655,
    1435,   639,   583,   685,   686,   687,  1441,   289,   350,   352,
     669,   671,   672,  1256,  1479,  1543,   661,   653,   654,   660,
     661,   636,   637,   653,   637,   523,   583,    27,   617,   617,
     439,   172,   625,   289,   390,   616,   605,   616,    61,   572,
     949,     3,     5,    10,    18,    52,    53,    67,    79,    83,
      97,   121,   132,   134,   145,   148,   149,   150,   151,   152,
     153,   154,   155,   157,   158,   159,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   184,   189,   220,
     227,   230,   231,   243,   251,   253,   256,   306,   312,   314,
     325,   354,   368,   400,   412,   427,   434,   438,   448,   461,
     473,   482,   487,   488,   494,   497,   507,   523,   543,   551,
     556,   586,  1514,  1515,  1516,   976,   994,   999,  1003,  1008,
    1030,  1034,  1042,  1051,  1048,  1056,  1061,  1092,  1096,  1098,
    1101,  1115,  1119,  1122,  1125,   228,   428,  1021,  1117,  1130,
    1137,  1147,  1150,  1168,  1170,  1173,   457,  1177,  1184,  1196,
    1198,  1214,  1224,  1228,  1232,  1239,  1247,  1254,  1271,  1281,
     289,   397,   441,   477,   512,   589,  1293,  1294,  1395,  1471,
    1472,  1476,  1296,  1305,   383,  1309,  1311,   961,  1314,  1317,
    1320,  1347,   585,   807,   809,   810,     1,   583,  1425,   264,
     454,   704,   706,  1543,   240,   289,   300,   397,   477,   533,
     589,   690,   691,  1482,  1435,   289,   246,   349,  1586,   289,
     542,    62,    71,   303,   388,   453,   459,   583,   644,   645,
     646,   647,   648,   649,   650,   652,  1527,  1596,   224,   388,
     656,   657,   658,   640,   652,   686,    22,   262,  1441,  1544,
    1256,   262,   484,  1558,  1543,   105,  1440,   289,   523,   612,
     310,  1553,  1543,   257,   627,   523,   523,   951,   950,   428,
     958,   351,   583,   977,   979,  1426,  1471,     6,     9,    91,
     103,   108,   217,   218,   219,   226,   240,   277,   278,   284,
     286,   289,   292,   293,   294,   298,   300,   309,   346,   366,
     397,   430,   477,   492,   493,   503,   533,   544,   566,   571,
     580,   589,   995,  1418,  1445,  1446,  1448,  1471,  1483,  1484,
    1485,  1486,  1487,  1488,  1489,   278,   531,   535,   536,  1000,
    1413,  1414,  1415,  1416,  1417,  1418,  1451,  1471,  1484,  1486,
     289,  1004,  1005,  1431,  1432,  1433,  1476,  1009,  1011,   289,
     390,  1031,  1032,  1458,  1471,   581,  1035,  1036,  1038,  1425,
       6,  1043,  1419,  1420,  1443,  1474,  1475,  1476,  1484,   527,
    1052,  1425,     9,  1049,  1471,  1473,   254,   263,   361,   506,
    1057,  1059,   211,   247,   289,   351,   479,   495,   529,   581,
    1062,  1063,  1064,  1065,  1067,  1072,  1075,  1076,  1079,  1081,
    1445,  1458,  1471,  1093,  1446,  1057,  1011,  1099,   526,   537,
    1102,  1103,  1104,  1398,  1399,  1400,   224,   367,   368,   388,
     450,  1116,  1120,  1442,  1443,  1123,  1476,   518,  1126,  1576,
    1446,  1397,  1398,  1138,  1442,   583,  1148,  1427,  1151,  1152,
    1471,  1483,  1486,  1272,  1466,  1467,  1476,   103,  1171,  1446,
    1174,  1446,   191,   254,   263,   361,  1178,  1179,  1180,   246,
    1185,  1393,  1537,   583,  1426,  1199,  1425,  1215,  1426,  1225,
    1421,  1476,  1229,  1425,   527,  1233,  1421,  1422,     9,  1240,
    1423,  1476,  1248,  1426,   173,   271,   309,  1255,  1258,  1259,
    1262,  1263,  1264,  1265,  1266,  1267,  1268,  1269,  1395,  1428,
    1429,  1442,  1465,  1467,  1476,  1272,  1282,  1425,  1290,  1471,
     535,  1477,  1478,  1297,  1298,  1299,  1446,   103,   503,  1306,
    1445,  1312,  1427,   523,   583,   962,   963,   966,   967,   972,
    1315,  1468,  1471,  1318,  1425,   289,  1321,  1459,  1471,  1486,
    1348,  1422,   450,    81,   788,   143,   462,   469,   811,   812,
     814,   825,   827,   829,  1499,   523,   759,   523,   331,   355,
    1507,   313,   443,   742,   743,   744,   745,   747,    29,   139,
     240,   289,   300,   319,   397,   477,   480,   481,   589,   675,
     676,   677,   680,   691,   514,   582,   694,  1580,  1476,   458,
     459,   470,  1568,    71,  1543,   523,   646,   523,   583,   645,
      65,  1543,     9,   226,   583,   659,   583,     1,   523,   658,
     641,  1580,   289,   688,  1480,  1558,   262,  1440,  1440,   670,
     671,   618,  1543,  1543,    68,   485,   525,   626,   440,   523,
      50,   952,   953,   954,  1526,   952,   351,   583,   523,   148,
     992,   978,   307,  1552,   221,   349,  1556,  1485,  1471,   535,
     535,   535,  1491,   535,  1472,  1484,  1486,  1586,  1586,   535,
     535,   535,   535,  1586,  1466,   535,  1491,   149,   997,   518,
     996,  1446,   519,   535,  1490,   535,   535,  1472,  1484,  1486,
    1417,  1471,  1413,  1417,    63,   531,   536,   522,   532,   190,
     252,  1502,  1005,   518,  1586,   150,  1028,  1393,  1032,  1039,
    1425,   408,   550,  1037,  1580,  1592,  1556,   151,  1044,   179,
     524,  1420,  1584,   439,  1508,  1477,  1478,  1053,  1425,   152,
    1054,   403,  1562,    99,  1530,  1471,   506,  1573,   506,  1426,
     232,  1082,   153,  1090,   186,   337,  1361,  1363,  1365,  1065,
    1444,  1445,  1066,  1073,  1082,   561,   562,   563,   564,   154,
    1094,    50,   258,   289,   155,  1113,    17,   579,  1105,  1106,
    1107,  1109,    20,   190,   262,   331,   357,   520,   522,   531,
     532,   535,   536,  1401,  1402,  1404,  1446,  1543,   110,  1117,
    1443,  1430,   511,  1132,  1139,  1580,  1427,   101,   417,   504,
    1153,  1154,  1156,  1157,  1274,   535,  1477,  1446,   518,   158,
    1175,    50,  1179,   463,  1181,    51,   216,   276,   278,   289,
     819,  1189,  1190,  1191,  1431,  1460,  1471,  1476,  1483,  1486,
    1580,   512,   161,  1211,   325,   379,  1505,   162,  1222,   307,
     452,  1216,   221,  1349,   163,  1230,  1562,   583,   164,  1236,
    1349,  1423,   165,  1245,   577,  1241,   221,  1249,  1250,  1454,
    1456,  1471,  1484,  1486,   186,  1265,  1267,  1442,   384,   518,
    1429,   136,   518,   558,  1257,    32,  1477,   166,  1288,   199,
     267,   271,  1284,  1021,  1291,  1446,  1580,  1411,  1413,   535,
    1478,   167,  1303,   258,  1299,   122,  1300,  1471,  1466,   168,
    1307,   221,  1427,   450,   523,   523,   221,   403,   405,  1563,
     169,  1330,   122,  1322,   170,  1353,  1349,   523,   450,   295,
     879,   583,   817,   817,   817,   812,   523,     1,   197,   815,
     816,   817,   583,   761,   355,  1440,   748,   403,   473,   474,
     746,     1,   523,   744,   677,    17,   514,  1482,   372,  1543,
     459,  1479,   523,  1543,   583,  1436,   259,   617,     1,   226,
     259,   617,   523,   523,   116,  1480,  1440,   523,    80,   192,
     406,   529,   619,   620,   621,    35,   320,   321,   322,   392,
     539,   540,   545,  1510,  1543,   953,   470,   552,   955,   956,
     409,   574,   946,    31,    38,   222,   310,   980,   981,   982,
     984,   987,  1523,  1524,  1580,   104,    25,    26,    73,    75,
      77,   112,   113,   114,   173,   175,   182,   186,   285,   287,
     515,   569,   583,   983,  1429,  1583,   171,   388,  1452,  1472,
     518,  1411,  1413,  1497,  1411,  1498,   520,  1411,  1493,  1494,
     583,   583,  1413,  1496,  1496,  1496,  1450,  1471,  1484,  1486,
    1495,   583,   518,  1450,  1492,     6,  1419,  1446,  1476,  1484,
     228,  1485,  1413,  1450,  1411,   520,   252,  1503,  1414,  1414,
    1415,  1415,  1415,   428,  1001,   387,  1006,  1433,  1012,  1013,
    1459,  1471,  1037,   296,   327,   214,  1535,  1472,  1413,   310,
    1509,  1478,  1425,   426,  1204,  1205,  1206,  1058,  1580,   581,
     969,   970,   969,  1364,  1365,  1362,  1363,   560,   984,   987,
    1068,  1069,  1070,  1580,   560,  1083,   581,  1361,  1361,  1361,
    1361,  1446,  1419,  1446,   572,  1015,  1104,    21,   526,   537,
    1110,  1111,  1399,   579,  1107,  1108,   579,   969,  1403,  1404,
    1402,    12,    13,    14,    66,   179,   233,   234,   279,   280,
     323,   336,   344,   351,   377,   524,   528,   530,  1405,  1406,
    1407,  1408,  1409,  1410,   124,  1127,  1431,   145,  1131,  1133,
       9,    12,    15,    16,   316,   317,   344,   345,  1140,  1144,
     197,  1454,     9,    63,   199,   273,   542,  1160,  1161,  1162,
    1155,  1156,   137,   352,   582,  1276,  1557,  1595,   518,  1442,
    1419,  1446,  1580,  1204,  1556,     1,    41,    42,    43,    44,
      45,    84,    85,   202,   203,   204,   205,   206,   207,   208,
     209,   210,   374,   391,   820,   821,   822,   823,   824,   845,
     846,  1472,   820,   237,  1394,  1394,   557,   577,   514,   517,
     509,  1562,   258,  1464,  1471,  1483,  1486,   258,  1200,  1204,
     147,  1242,  1471,  1242,  1471,  1251,  1580,   518,   518,   518,
     518,  1256,   171,   470,   526,   537,  1446,    50,    39,    47,
     239,   275,   299,   362,   431,   549,  1260,  1261,  1543,  1283,
    1580,  1446,   181,   330,    78,   455,   520,  1412,   521,  1413,
    1471,  1526,   221,   221,  1419,  1446,   964,  1454,  1526,   258,
    1325,     8,    38,  1350,  1351,   808,   523,   450,   288,   881,
     828,   830,   415,   523,   523,   813,    94,    48,    70,   111,
     269,   283,   403,   404,   418,   420,   523,   574,   762,   763,
     765,   769,   770,   773,   774,   780,   783,   785,   786,  1543,
     707,   527,  1533,    23,  1520,   523,   678,   680,   289,  1479,
     291,   500,   570,   651,  1436,   310,   621,   388,  1561,    80,
     320,   321,   392,   545,   628,  1543,   470,   956,   355,   957,
     118,   959,   589,  1461,  1465,  1479,  1543,   182,   186,   335,
     337,  1354,  1356,  1357,  1359,  1360,   982,    72,    74,   285,
     376,   985,   986,  1582,   515,    33,    36,    39,    47,   100,
     119,   215,   223,   239,   275,   297,   299,   327,   329,   350,
     362,   393,   394,   422,   429,   431,   432,   446,   451,   470,
     502,   516,   549,   559,   565,   988,   989,   990,   991,  1354,
     588,   587,  1454,  1354,   267,   484,   342,   315,   289,  1453,
    1472,  1471,  1412,   520,  1412,   520,   520,   520,  1450,  1412,
     520,   520,   520,  1412,   520,  1466,  1412,   520,  1556,   340,
     471,  1366,  1368,  1370,  1477,  1478,  1419,   521,   520,   520,
     518,  1504,  1001,  1443,   518,  1431,  1010,   324,   390,  1014,
      27,  1040,  1580,   433,   414,  1366,  1543,   216,  1535,   261,
     338,  1387,  1388,  1390,  1392,   267,  1077,   971,   105,   106,
     381,   583,  1071,  1429,  1069,    36,    39,    46,    47,   100,
     180,   215,   239,   299,   341,   362,   446,   470,   549,   990,
    1089,  1471,  1074,  1080,   228,  1366,   228,  1016,    17,   514,
    1112,   360,  1110,   589,  1405,  1576,  1557,  1134,   157,  1135,
     969,  1576,   417,  1141,  1576,   518,    50,  1161,  1163,  1454,
       9,    63,   273,   542,  1158,  1159,  1454,  1469,  1471,   137,
      71,   459,  1277,  1581,    28,   125,   864,   246,   358,  1538,
    1442,  1366,   228,     9,   327,   400,   741,  1424,  1425,   820,
     523,  1537,  1190,   159,   523,  1186,  1188,   189,  1192,  1397,
    1193,  1194,  1471,  1431,  1351,  1200,  1471,  1471,   147,   333,
    1376,  1379,  1381,  1234,  1235,  1580,   969,   579,   579,  1243,
    1244,  1350,   142,   146,   183,  1471,  1454,   350,  1463,  1465,
    1479,  1453,   349,  1446,  1256,  1256,  1256,  1256,  1256,  1256,
    1256,  1256,  1261,   331,   336,  1285,  1286,  1287,  1406,  1506,
    1387,   276,   470,  1594,   484,  1570,  1570,  1413,   520,  1413,
    1302,  1580,   470,  1301,  1446,  1471,  1466,  1366,   228,   968,
    1479,   518,     9,  1323,  1324,  1500,  1326,  1471,  1302,  1326,
    1204,     7,  1517,   809,   789,   523,   450,   418,   883,   574,
     873,   840,   841,  1543,  1476,   835,   818,  1543,    95,  1529,
    1543,   403,   405,  1591,  1591,  1543,  1529,  1543,  1553,  1543,
      22,  1519,   349,   787,  1440,   192,   229,     1,   708,   709,
     505,  1572,  1535,   679,   680,    63,   311,   584,  1590,    33,
     119,  1479,  1543,   583,   523,   947,    48,  1358,  1359,   969,
    1355,  1356,   969,   342,  1554,  1554,  1554,   289,  1462,  1465,
    1481,  1543,  1543,   141,   991,    62,   470,   136,   558,  1543,
       8,  1518,  1354,  1508,   501,  1490,   501,  1490,  1435,  1490,
    1490,  1490,  1450,  1508,   273,   542,  1490,  1472,   969,   969,
    1369,  1370,  1367,  1368,  1478,  1366,   520,  1413,  1490,  1490,
    1457,  1471,  1483,  1394,   327,  1510,  1413,   969,   969,  1391,
    1392,  1389,  1390,  1458,  1083,   972,  1543,   285,   444,   147,
     176,   178,   935,   936,  1532,  1543,   136,   558,  1543,   237,
     287,   375,   984,  1084,  1085,  1086,  1087,  1088,  1580,  1084,
    1419,  1420,  1419,  1420,  1017,  1018,  1019,  1526,  1111,  1398,
     969,  1471,   969,   145,   574,  1142,  1143,  1144,   511,  1145,
    1574,   574,  1455,  1457,  1454,    50,     8,    38,  1164,  1165,
    1166,  1159,  1164,   214,   459,  1273,  1543,   267,  1546,   358,
    1419,   360,  1559,  1559,   353,   432,  1182,  1425,  1580,  1471,
     969,     8,   221,     7,   245,  1201,  1202,  1203,  1205,  1208,
    1235,  1580,   111,   328,  1217,  1219,  1221,   969,   969,  1380,
    1381,  1379,  1387,   296,   327,  1398,  1397,  1243,   417,  1252,
    1446,  1406,  1471,  1407,  1408,  1409,  1410,  1413,  1292,  1446,
    1292,   520,   339,   534,  1371,  1373,  1375,   374,  1508,  1508,
    1419,   523,  1455,   357,  1454,   123,  1327,   504,  1329,  1234,
     365,  1429,  1461,   790,   880,   523,   450,   444,   927,  1544,
     574,   229,   514,   826,    21,    37,    40,    41,    42,    43,
      44,    45,    46,    82,    86,    87,    88,    89,    90,   132,
     202,   203,   204,   205,   206,   237,   248,   265,   316,   348,
     363,   371,   374,   391,   407,   464,   466,   467,   468,   499,
     553,   554,   555,   567,   836,   837,   838,   841,   842,   843,
     844,   845,   846,   849,   852,   869,   870,   871,   872,   873,
     878,  1543,  1567,    27,   221,   831,  1522,   229,  1479,   583,
     724,  1543,  1519,   583,  1437,  1438,   351,   479,  1587,   289,
    1435,  1439,  1479,   577,  1543,   196,   241,   583,   771,  1440,
     523,     4,    19,    30,   249,   285,   359,   364,   403,   411,
     423,   463,   473,   523,   527,   710,   711,   719,   721,   723,
     725,   726,   727,   728,   731,   732,   733,   734,   735,   737,
     738,   740,  1562,  1581,  1529,  1424,    17,    33,   960,   961,
    1461,  1461,  1461,  1461,  1461,  1543,  1543,  1396,  1463,  1396,
    1461,  1462,  1366,   221,  1512,   520,  1015,   132,   449,   517,
    1078,  1461,  1556,   285,   444,  1461,  1396,  1396,  1461,   246,
     262,  1545,  1479,  1520,  1085,  1089,  1366,   413,  1366,   413,
    1018,   351,   955,    96,   409,   574,  1134,  1143,   111,  1531,
    1576,  1164,  1164,  1455,   529,  1541,  1541,  1166,  1165,   254,
     572,  1278,  1435,  1275,  1366,   296,   327,   159,  1187,  1194,
    1446,  1557,   296,   267,  1209,  1207,  1208,  1580,   244,   266,
     578,   969,   969,  1220,  1221,  1218,  1219,   296,   969,   969,
     285,  1548,   969,   969,  1374,  1375,  1372,  1373,  1543,  1366,
    1512,  1366,   568,   965,  1331,  1324,  1537,   104,  1328,  1537,
    1371,   177,   334,  1352,  1382,  1384,  1386,  1388,   285,   287,
    1549,    58,   791,   792,   809,   882,   523,   450,    20,   190,
     357,   520,   522,   531,   532,   535,   536,   819,   834,   875,
     876,  1543,  1476,   276,   344,   465,   552,  1566,   552,  1566,
     552,  1566,   552,  1566,   552,  1566,   579,  1578,  1556,   437,
    1564,   138,   855,  1479,  1472,   262,   274,   437,  1547,  1543,
     192,   273,   542,   583,   875,   518,   768,   214,   784,  1438,
     287,  1551,   518,  1528,  1537,   193,   200,   442,   547,   573,
     575,   781,   782,  1543,  1543,  1553,  1562,   518,   572,  1577,
     460,  1543,  1527,   123,  1546,  1546,   327,   739,  1479,  1580,
     484,   296,    40,  1525,  1543,   749,   750,  1425,   680,   961,
    1458,  1461,   285,   287,  1593,   248,  1539,   126,  1513,  1020,
    1021,  1084,  1471,  1543,  1420,  1420,  1447,  1448,  1470,  1472,
     969,    50,   119,  1164,  1446,  1446,   385,  1424,   228,   361,
    1279,  1476,   433,    50,   296,  1543,  1210,  1377,  1379,  1381,
    1387,   296,   296,  1471,  1513,  1332,   523,  1471,  1537,  1471,
     969,   969,  1385,  1386,  1383,  1384,  1440,   809,   809,   884,
     523,   514,   874,   876,   325,   482,   819,   832,   833,   834,
     589,   212,   272,   305,   495,   512,   576,   581,    54,   857,
     548,   518,   853,   844,    27,   839,   458,  1511,  1511,  1479,
      63,   405,   764,  1434,  1435,   775,  1479,  1568,   289,   772,
    1476,   772,  1543,  1546,   138,   192,   716,   411,   732,  1543,
    1543,  1543,  1543,    23,    24,  1521,   741,  1543,  1553,   460,
     724,   750,   376,   751,   147,  1463,  1539,  1366,   186,   337,
     534,  1023,  1025,  1027,     6,   258,   332,   351,   533,  1022,
    1542,  1471,  1366,  1366,  1446,  1543,  1424,   385,  1446,  1471,
    1380,  1378,  1379,  1366,    31,   140,   187,   229,  1333,  1334,
    1335,  1337,  1341,  1343,  1344,  1345,  1523,  1535,  1471,   793,
     885,   928,   819,   579,   877,  1579,  1556,   834,   120,   201,
     270,   304,   472,   541,   847,   290,   848,  1537,   221,   854,
     517,  1575,  1479,  1575,   289,  1527,  1435,    49,   538,   776,
     777,   778,   779,  1580,  1528,   221,   767,  1536,   138,   398,
     460,   720,  1543,    55,    56,    57,   130,   131,   132,   254,
     255,   268,   285,   302,   361,   380,   381,   382,   398,   505,
     712,   713,   714,   715,  1439,   480,   736,  1435,  1435,  1435,
    1543,  1479,   118,   518,  1463,   969,   969,   969,  1026,  1027,
    1024,  1025,  1556,  1471,  1189,  1543,   557,    38,  1518,   388,
     116,   794,   399,   886,   814,   829,   929,   930,   931,   461,
     526,  1471,   583,  1479,   518,   853,   124,   124,   856,  1439,
    1439,   213,   768,  1479,   736,   289,   718,  1476,   718,     7,
     718,   718,   718,   289,   717,  1476,   475,   524,    34,   188,
     301,   729,   523,  1463,  1471,  1189,  1397,   419,   479,  1569,
     147,   482,  1342,  1557,   523,   795,  1535,  1427,     1,   816,
     931,   523,   518,  1543,   252,   858,  1557,  1557,   249,   859,
     861,   862,   863,   864,   866,  1523,  1528,  1501,  1595,  1533,
    1543,  1434,   582,   730,   730,  1471,   181,   186,  1585,     9,
    1338,  1339,  1432,   361,  1541,   887,   523,   932,   523,   819,
     859,  1435,  1435,  1526,   866,   862,  1546,   860,  1439,   124,
     766,   497,   722,  1434,   296,   438,   385,  1560,   349,   386,
     410,  1340,  1339,   126,   181,   484,   498,   508,   800,   801,
     802,   254,   263,     1,   888,   933,   859,   583,   867,   868,
    1543,   861,  1557,   579,   352,  1557,   349,  1476,   104,   503,
    1543,   267,   267,   126,   276,   802,   147,   307,   484,   498,
     508,   796,   797,   798,   799,  1471,  1552,  1571,   147,   307,
     484,   508,   803,   804,   805,   806,  1471,  1571,   523,    69,
      98,    99,   365,   523,   889,   890,   892,  1543,  1604,    33,
      36,    39,    46,    47,   180,   215,   221,   223,   235,   239,
     275,   285,   299,   327,   348,   362,   393,   422,   451,   502,
     518,   529,   549,   572,   842,   843,   849,   869,   871,   873,
     934,   943,   944,   989,   990,  1543,  1582,   868,  1434,  1435,
       9,   477,   589,   681,   313,   403,   405,  1589,   191,   254,
     263,   361,  1336,  1424,  1543,   348,  1471,  1543,  1543,  1543,
    1543,   267,   112,   515,   267,   276,   798,  1471,   104,   396,
     475,   489,   490,   491,   267,   112,   515,   267,   276,   805,
    1471,   506,  1543,  1543,  1519,   281,   282,  1550,   901,   229,
     198,   891,  1534,  1543,   285,   444,   935,   936,  1543,  1464,
     939,  1554,  1479,    62,  1471,  1471,   229,   941,  1554,  1485,
    1589,  1471,  1479,  1471,  1471,  1471,  1471,  1543,  1543,  1543,
    1543,  1543,  1471,  1543,  1543,  1543,  1543,  1543,  1543,  1543,
    1543,  1543,  1543,  1543,  1471,  1543,  1458,  1543,  1519,   893,
    1481,   814,   902,  1473,  1461,  1461,  1543,  1575,  1543,  1543,
    1575,  1471,  1471,  1471,  1471,  1471,  1471,  1471,  1471,  1471,
    1471,  1471,  1471,  1471,  1471,  1471,  1471,  1471,  1471,  1471,
     894,   285,   287,  1588,   816,   817,   308,   373,   531,   536,
     937,   938,   940,  1458,   937,   938,   942,   865,   866,  1471,
    1471,   199,   213,   238,   271,   895,   896,   897,   898,   899,
     900,  1481,   903,  1461,  1461,  1471,  1471,   115,   128,  1597,
    1543,  1543,    60,    98,  1597,  1598,  1583,   904,  1471,  1543,
    1481,  1481,   238,  1543,  1543,   236,   285,   287,   325,   348,
     378,   475,   496,   523,   546,   567,   577,   842,   849,   850,
     869,   871,   873,   905,   906,   910,   911,   914,   915,   916,
     917,   918,   919,   924,   925,   926,  1582,  1583,  1471,  1481,
    1481,  1481,   250,  1540,   342,   343,  1555,  1519,   236,  1479,
     579,  1543,  1556,  1543,  1543,  1471,   326,   373,   920,   921,
    1481,   373,   922,   923,  1481,  1555,  1519,  1471,  1544,  1543,
     853,  1397,  1451,  1449,  1451,    59,    98,   365,   369,   370,
     418,   435,   436,   907,  1597,  1598,  1599,  1600,  1601,  1602,
    1603,   132,   221,  1479,   921,  1479,   923,  1544,  1471,   921,
    1575,  1508,   424,   912,  1451,   213,   213,   238,   213,   238,
     198,   908,  1471,   908,  1451,  1471,   856,  1557,   357,   909,
     909,    50,   486,   851,   198,   913,  1471,   365,  1451,  1479
};

  /* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint16 yyr1[] =
{
       0,   591,   593,   592,   594,   594,   596,   595,   597,   597,
     598,   598,   600,   599,   601,   602,   603,   603,   604,   604,
     605,   606,   607,   608,   608,   609,   609,   611,   612,   610,
     614,   613,   615,   615,   616,   616,   617,   617,   618,   618,
     619,   619,   619,   619,   620,   620,   621,   621,   622,   622,
     623,   624,   624,   625,   625,   626,   626,   626,   627,   627,
     628,   628,   628,   628,   629,   630,   630,   631,   632,   632,
     632,   633,   633,   633,   633,   633,   634,   634,   634,   634,
     634,   635,   635,   636,   636,   637,   637,   637,   637,   639,
     638,   640,   640,   641,   641,   643,   642,   644,   644,   644,
     644,   645,   645,   646,   646,   646,   646,   647,   648,   649,
     650,   651,   651,   651,   651,   652,   652,   653,   653,   655,
     654,   656,   656,   656,   657,   657,   658,   658,   658,   658,
     658,   659,   659,   660,   660,   661,   661,   662,   663,   663,
     664,   664,   665,   665,   666,   666,   666,   666,   666,   666,
     666,   666,   666,   666,   666,   666,   668,   667,   669,   669,
     669,   669,   670,   670,   671,   672,   672,   674,   673,   675,
     675,   675,   675,   675,   675,   676,   676,   677,   677,   678,
     677,   679,   679,   680,   680,   680,   680,   680,   680,   681,
     681,   682,   683,   683,   684,   685,   685,   686,   687,   687,
     688,   688,   689,   690,   690,   691,   691,   692,   693,   694,
     694,   695,   696,   697,   698,   699,   700,   701,   702,   702,
     703,   703,   704,   704,   705,   705,   707,   706,   708,   708,
     709,   709,   710,   710,   710,   710,   710,   710,   710,   710,
     710,   710,   710,   710,   710,   711,   711,   711,   711,   711,
     711,   712,   712,   712,   713,   713,   713,   713,   714,   714,
     714,   714,   714,   714,   714,   715,   715,   716,   716,   716,
     717,   717,   718,   718,   718,   719,   720,   720,   720,   721,
     722,   722,   722,   723,   724,   725,   726,   726,   726,   728,
     727,   729,   729,   729,   730,   730,   730,   730,   731,   731,
     732,   732,   732,   732,   733,   734,   735,   736,   736,   736,
     737,   738,   739,   739,   740,   741,   741,   741,   742,   742,
     742,   743,   743,   744,   744,   745,   746,   746,   746,   746,
     748,   747,   749,   749,   750,   751,   751,   753,   752,   754,
     754,   755,   755,   756,   756,   757,   759,   758,   758,   760,
     760,   761,   761,   762,   762,   762,   762,   762,   762,   762,
     762,   762,   762,   762,   763,   764,   764,   764,   765,   765,
     765,   766,   766,   767,   767,   768,   768,   769,   770,   770,
     771,   771,   772,   772,   773,   774,   775,   775,   776,   776,
     776,   777,   778,   779,   780,   781,   781,   781,   781,   781,
     782,   782,   783,   784,   784,   785,   786,   786,   787,   787,
     788,   789,   788,   790,   790,   791,   793,   792,   794,   794,
     795,   795,   795,   796,   796,   796,   797,   797,   798,   798,
     798,   798,   798,   798,   798,   798,   798,   798,   798,   799,
     800,   800,   801,   801,   802,   802,   802,   802,   802,   802,
     802,   803,   803,   803,   804,   804,   805,   805,   805,   805,
     805,   805,   806,   807,   808,   807,   809,   810,   809,   811,
     811,   812,   812,   812,   813,   812,   812,   814,   815,   815,
     816,   816,   817,   818,   818,   819,   819,   819,   819,   820,
     820,   820,   820,   820,   820,   820,   820,   820,   820,   820,
     820,   820,   821,   821,   822,   822,   823,   823,   823,   824,
     824,   825,   826,   826,   828,   827,   829,   830,   829,   831,
     831,   832,   832,   832,   833,   833,   834,   834,   834,   834,
     834,   834,   834,   834,   834,   834,   835,   835,   836,   836,
     836,   836,   836,   836,   836,   836,   836,   836,   836,   836,
     836,   837,   838,   839,   839,   840,   840,   841,   842,   843,
     843,   844,   844,   844,   844,   844,   844,   844,   844,   844,
     844,   844,   844,   844,   844,   844,   844,   844,   844,   844,
     844,   844,   844,   844,   844,   844,   844,   844,   844,   844,
     844,   844,   844,   844,   844,   844,   844,   844,   844,   844,
     844,   844,   844,   844,   844,   845,   845,   846,   846,   847,
     847,   847,   847,   847,   847,   847,   848,   848,   849,   849,
     850,   851,   851,   852,   852,   852,   853,   853,   854,   854,
     855,   855,   856,   856,   857,   857,   858,   858,   859,   859,
     860,   859,   859,   859,   861,   862,   862,   863,   864,   864,
     865,   865,   866,   867,   867,   868,   869,   870,   871,   872,
     874,   873,   875,   875,   876,   876,   877,   877,   878,   878,
     879,   880,   879,   881,   882,   881,   883,   884,   883,   885,
     885,   887,   886,   888,   888,   888,   889,   889,   889,   889,
     890,   891,   892,   893,   893,   893,   894,   894,   895,   895,
     895,   895,   895,   896,   897,   898,   899,   900,   901,   901,
     903,   902,   904,   904,   905,   905,   905,   905,   905,   905,
     905,   905,   905,   905,   905,   905,   905,   905,   905,   905,
     906,   907,   907,   907,   907,   907,   907,   907,   908,   908,
     908,   909,   909,   910,   911,   912,   912,   913,   913,   914,
     915,   916,   917,   917,   918,   919,   919,   920,   920,   921,
     921,   921,   922,   922,   923,   923,   924,   925,   926,   927,
     928,   927,   929,   929,   930,   930,   931,   932,   931,   931,
     933,   933,   934,   934,   934,   934,   934,   934,   934,   934,
     934,   934,   934,   934,   934,   934,   934,   934,   934,   934,
     934,   934,   934,   934,   934,   934,   934,   934,   934,   934,
     934,   934,   934,   934,   934,   934,   934,   934,   934,   935,
     935,   936,   936,   937,   937,   938,   938,   939,   940,   940,
     940,   941,   942,   942,   942,   943,   944,   945,   946,   947,
     945,   948,   945,   949,   950,   949,   951,   949,   952,   952,
     953,   954,   954,   954,   955,   955,   955,   955,   955,   955,
     956,   957,   957,   958,   958,   958,   959,   960,   959,   961,
     961,   962,   962,   962,   962,   962,   964,   963,   965,   965,
     966,   967,   968,   968,   970,   971,   969,   973,   972,   972,
     974,   974,   974,   974,   974,   974,   974,   974,   974,   974,
     974,   974,   974,   974,   974,   974,   974,   974,   974,   974,
     974,   974,   974,   974,   974,   974,   974,   974,   974,   974,
     974,   974,   974,   974,   974,   974,   974,   974,   974,   974,
     974,   974,   974,   974,   974,   974,   974,   974,   974,   974,
     974,   974,   974,   974,   974,   974,   974,   976,   975,   978,
     977,   977,   977,   977,   977,   977,   977,   977,   977,   977,
     977,   977,   977,   977,   977,   977,   977,   977,   977,   977,
     979,   979,   980,   980,   981,   981,   982,   982,   982,   982,
     982,   983,   983,   984,   984,   984,   985,   986,   986,   987,
     988,   988,   988,   988,   988,   988,   988,   988,   988,   988,
     988,   988,   988,   988,   988,   988,   988,   988,   988,   988,
     988,   988,   988,   988,   988,   988,   988,   988,   989,   989,
     989,   990,   990,   990,   991,   991,   992,   992,   994,   993,
     995,   995,   995,   995,   996,   996,   997,   997,   999,   998,
    1000,  1000,  1001,  1001,  1003,  1002,  1004,  1004,  1005,  1006,
    1006,  1008,  1007,  1010,  1009,  1011,  1011,  1011,  1011,  1011,
    1012,  1012,  1013,  1013,  1014,  1014,  1015,  1016,  1015,  1017,
    1017,  1018,  1018,  1019,  1019,  1019,  1019,  1020,  1020,  1020,
    1020,  1020,  1021,  1021,  1022,  1022,  1023,  1023,  1023,  1024,
    1024,  1025,  1025,  1026,  1026,  1027,  1028,  1028,  1030,  1029,
    1031,  1031,  1032,  1032,  1034,  1033,  1035,  1035,  1036,  1036,
    1037,  1037,  1037,  1037,  1037,  1039,  1038,  1040,  1040,  1042,
    1041,  1043,  1044,  1044,  1045,  1046,  1048,  1047,  1049,  1049,
    1051,  1050,  1052,  1052,  1053,  1053,  1054,  1054,  1056,  1055,
    1057,  1058,  1058,  1059,  1059,  1059,  1059,  1059,  1061,  1060,
    1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1063,  1063,
    1064,  1064,  1066,  1065,  1067,  1067,  1068,  1068,  1069,  1069,
    1069,  1069,  1069,  1070,  1070,  1070,  1070,  1071,  1071,  1073,
    1074,  1072,  1075,  1075,  1077,  1078,  1076,  1080,  1079,  1081,
    1081,  1081,  1082,  1082,  1083,  1083,  1084,  1084,  1085,  1085,
    1085,  1085,  1086,  1086,  1087,  1088,  1089,  1089,  1089,  1089,
    1089,  1089,  1089,  1089,  1089,  1089,  1089,  1089,  1089,  1089,
    1089,  1089,  1089,  1090,  1090,  1092,  1091,  1093,  1093,  1093,
    1093,  1093,  1094,  1094,  1096,  1095,  1098,  1097,  1099,  1101,
    1100,  1102,  1103,  1103,  1104,  1104,  1104,  1105,  1105,  1106,
    1106,  1107,  1108,  1109,  1109,  1110,  1110,  1111,  1111,  1111,
    1111,  1112,  1112,  1113,  1113,  1115,  1114,  1116,  1116,  1116,
    1116,  1116,  1116,  1116,  1117,  1117,  1119,  1118,  1120,  1122,
    1121,  1123,  1125,  1124,  1126,  1127,  1127,  1128,  1130,  1129,
    1131,  1131,  1131,  1132,  1132,  1133,  1134,  1135,  1135,  1137,
    1136,  1138,  1139,  1139,  1140,  1140,  1140,  1141,  1141,  1142,
    1142,  1143,  1144,  1144,  1144,  1144,  1144,  1144,  1144,  1145,
    1145,  1147,  1146,  1148,  1148,  1150,  1149,  1151,  1152,  1152,
    1152,  1153,  1153,  1153,  1153,  1155,  1154,  1156,  1157,  1158,
    1158,  1159,  1159,  1159,  1159,  1159,  1159,  1160,  1160,  1161,
    1161,  1162,  1162,  1162,  1162,  1162,  1163,  1164,  1164,  1164,
    1164,  1164,  1165,  1166,  1168,  1167,  1170,  1169,  1171,  1171,
    1173,  1172,  1174,  1174,  1175,  1175,  1177,  1176,  1178,  1178,
    1179,  1180,  1180,  1180,  1180,  1181,  1181,  1182,  1182,  1182,
    1182,  1184,  1183,  1185,  1186,  1185,  1185,  1187,  1187,  1188,
    1188,  1189,  1189,  1190,  1190,  1190,  1190,  1190,  1191,  1191,
    1192,  1192,  1193,  1193,  1194,  1196,  1195,  1198,  1197,  1199,
    1200,  1200,  1201,  1201,  1201,  1201,  1202,  1202,  1203,  1203,
    1204,  1204,  1205,  1206,  1206,  1206,  1207,  1207,  1208,  1208,
    1208,  1209,  1209,  1210,  1210,  1211,  1211,  1212,  1214,  1213,
    1215,  1216,  1216,  1217,  1217,  1217,  1218,  1218,  1219,  1220,
    1220,  1221,  1222,  1222,  1224,  1223,  1225,  1226,  1228,  1227,
    1229,  1230,  1230,  1232,  1231,  1233,  1234,  1234,  1235,  1235,
    1236,  1236,  1237,  1239,  1238,  1240,  1240,  1241,  1241,  1242,
    1242,  1243,  1243,  1244,  1245,  1245,  1247,  1246,  1248,  1248,
    1249,  1249,  1250,  1251,  1251,  1251,  1251,  1252,  1252,  1254,
    1253,  1255,  1255,  1255,  1255,  1255,  1255,  1255,  1255,  1256,
    1256,  1257,  1257,  1258,  1259,  1260,  1260,  1261,  1261,  1261,
    1261,  1261,  1261,  1261,  1261,  1262,  1262,  1262,  1263,  1264,
    1264,  1265,  1266,  1266,  1267,  1267,  1268,  1269,  1271,  1270,
    1273,  1272,  1274,  1274,  1275,  1275,  1276,  1276,  1277,  1277,
    1278,  1278,  1278,  1279,  1279,  1279,  1281,  1280,  1282,  1283,
    1283,  1284,  1284,  1284,  1284,  1285,  1285,  1285,  1285,  1285,
    1285,  1286,  1287,  1287,  1288,  1288,  1290,  1289,  1289,  1289,
    1291,  1291,  1291,  1291,  1291,  1292,  1292,  1293,  1293,  1294,
    1294,  1294,  1294,  1296,  1295,  1297,  1298,  1298,  1299,  1300,
    1300,  1301,  1301,  1302,  1302,  1303,  1303,  1305,  1304,  1306,
    1306,  1306,  1306,  1307,  1307,  1308,  1309,  1309,  1311,  1310,
    1312,  1312,  1314,  1313,  1315,  1317,  1316,  1318,  1320,  1319,
    1321,  1322,  1322,  1323,  1323,  1324,  1325,  1325,  1326,  1327,
    1327,  1328,  1328,  1329,  1329,  1330,  1330,  1332,  1331,  1333,
    1333,  1333,  1333,  1333,  1334,  1335,  1335,  1336,  1336,  1336,
    1336,  1336,  1337,  1338,  1338,  1339,  1339,  1339,  1340,  1340,
    1340,  1340,  1341,  1342,  1342,  1343,  1344,  1345,  1345,  1347,
    1346,  1348,  1349,  1349,  1350,  1350,  1350,  1350,  1351,  1351,
    1352,  1352,  1352,  1353,  1353,  1354,  1354,  1354,  1355,  1355,
    1356,  1357,  1357,  1358,  1358,  1359,  1360,  1360,  1361,  1361,
    1361,  1362,  1362,  1363,  1364,  1364,  1365,  1366,  1366,  1366,
    1367,  1367,  1368,  1369,  1369,  1370,  1371,  1371,  1371,  1372,
    1372,  1373,  1374,  1374,  1375,  1376,  1376,  1377,  1377,  1378,
    1378,  1379,  1380,  1380,  1381,  1382,  1382,  1383,  1383,  1384,
    1385,  1385,  1386,  1387,  1387,  1388,  1388,  1389,  1389,  1390,
    1391,  1391,  1392,  1393,  1393,  1394,  1394,  1395,  1395,  1396,
    1396,  1397,  1398,  1400,  1399,  1401,  1401,  1402,  1402,  1402,
    1402,  1402,  1402,  1402,  1402,  1402,  1402,  1402,  1402,  1402,
    1402,  1403,  1403,  1404,  1405,  1405,  1405,  1405,  1405,  1405,
    1405,  1405,  1405,  1405,  1405,  1405,  1405,  1405,  1406,  1406,
    1407,  1407,  1408,  1408,  1409,  1410,  1411,  1411,  1412,  1412,
    1412,  1413,  1413,  1413,  1414,  1414,  1414,  1415,  1415,  1416,
    1416,  1416,  1417,  1417,  1418,  1418,  1418,  1418,  1418,  1418,
    1419,  1419,  1420,  1421,  1422,  1422,  1423,  1424,  1424,  1425,
    1426,  1427,  1428,  1428,  1429,  1430,  1430,  1431,  1432,  1432,
    1432,  1433,  1434,  1434,  1435,  1436,  1437,  1437,  1438,  1439,
    1439,  1440,  1440,  1441,  1442,  1442,  1443,  1443,  1443,  1444,
    1444,  1445,  1445,  1446,  1446,  1447,  1447,  1448,  1448,  1448,
    1448,  1448,  1448,  1448,  1448,  1448,  1449,  1449,  1450,  1450,
    1450,  1451,  1451,  1451,  1451,  1451,  1451,  1451,  1452,  1452,
    1453,  1453,  1454,  1455,  1456,  1456,  1456,  1457,  1457,  1458,
    1458,  1459,  1459,  1459,  1460,  1460,  1460,  1461,  1461,  1461,
    1462,  1462,  1463,  1463,  1464,  1464,  1464,  1465,  1466,  1467,
    1467,  1468,  1469,  1470,  1471,  1472,  1472,  1472,  1472,  1473,
    1473,  1474,  1475,  1475,  1475,  1475,  1476,  1476,  1477,  1478,
    1478,  1479,  1480,  1481,  1482,  1482,  1482,  1482,  1482,  1482,
    1482,  1483,  1483,  1484,  1484,  1485,  1485,  1485,  1485,  1485,
    1485,  1485,  1486,  1486,  1486,  1486,  1486,  1486,  1486,  1486,
    1486,  1486,  1486,  1486,  1486,  1487,  1487,  1488,  1488,  1488,
    1489,  1489,  1489,  1489,  1490,  1490,  1490,  1491,  1491,  1491,
    1492,  1492,  1492,  1494,  1493,  1495,  1495,  1496,  1496,  1497,
    1497,  1498,  1498,  1499,  1500,  1500,  1501,  1501,  1502,  1502,
    1503,  1503,  1504,  1504,  1505,  1505,  1505,  1506,  1506,  1507,
    1507,  1507,  1508,  1508,  1509,  1509,  1510,  1510,  1510,  1510,
    1510,  1510,  1510,  1510,  1511,  1511,  1512,  1512,  1513,  1513,
    1514,  1514,  1514,  1515,  1515,  1515,  1515,  1515,  1515,  1515,
    1515,  1515,  1515,  1515,  1515,  1515,  1515,  1515,  1515,  1515,
    1515,  1515,  1515,  1515,  1515,  1515,  1515,  1515,  1515,  1515,
    1515,  1515,  1515,  1515,  1515,  1515,  1515,  1515,  1515,  1515,
    1515,  1515,  1515,  1515,  1515,  1515,  1515,  1515,  1515,  1515,
    1515,  1515,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,
    1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,  1516,
    1516,  1516,  1516,  1517,  1517,  1518,  1518,  1519,  1519,  1520,
    1520,  1521,  1521,  1521,  1522,  1522,  1523,  1523,  1524,  1524,
    1525,  1525,  1526,  1526,  1527,  1527,  1528,  1528,  1529,  1529,
    1530,  1530,  1531,  1531,  1532,  1532,  1533,  1533,  1534,  1534,
    1535,  1535,  1536,  1536,  1537,  1537,  1538,  1538,  1538,  1539,
    1539,  1540,  1540,  1541,  1541,  1542,  1542,  1543,  1543,  1544,
    1544,  1544,  1545,  1545,  1545,  1546,  1546,  1547,  1547,  1547,
    1548,  1548,  1549,  1549,  1549,  1550,  1550,  1550,  1551,  1551,
    1552,  1552,  1553,  1553,  1554,  1554,  1555,  1555,  1555,  1556,
    1556,  1557,  1557,  1558,  1558,  1558,  1558,  1559,  1559,  1560,
    1560,  1561,  1561,  1562,  1562,  1563,  1563,  1563,  1564,  1564,
    1565,  1565,  1566,  1566,  1567,  1567,  1567,  1568,  1568,  1569,
    1569,  1570,  1570,  1571,  1571,  1572,  1572,  1573,  1573,  1574,
    1574,  1575,  1575,  1576,  1576,  1577,  1577,  1577,  1578,  1578,
    1579,  1579,  1580,  1580,  1581,  1581,  1582,  1582,  1583,  1583,
    1584,  1584,  1585,  1585,  1586,  1586,  1587,  1587,  1588,  1588,
    1589,  1589,  1590,  1590,  1590,  1591,  1591,  1592,  1592,  1593,
    1593,  1594,  1594,  1595,  1595,  1596,  1596,  1596,  1597,  1597,
    1598,  1598,  1599,  1599,  1600,  1600,  1601,  1601,  1602,  1602,
    1603,  1603,  1604,  1604
};

  /* YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     0,     2,     1,     1,     0,     2,     1,     2,
       1,     1,     0,     2,     5,     5,     0,     1,     1,     2,
       3,     3,     3,     0,     3,     1,     1,     0,     0,     8,
       0,     6,     1,     1,     1,     1,     0,     2,     0,     3,
       1,     1,     1,     1,     2,     2,     1,     1,     0,     3,
       4,     0,     5,     0,     3,     1,     1,     1,     0,     4,
       1,     1,     1,     1,     3,     0,     3,     2,     0,     1,
       1,     3,     2,     1,     2,     1,     3,     3,     3,     3,
       3,     0,     3,     0,     1,     1,     1,     2,     2,     0,
       4,     0,     3,     0,     3,     0,     4,     0,     2,     3,
       2,     1,     2,     1,     1,     1,     1,     5,     3,     3,
       4,     1,     1,     1,     1,     1,     2,     0,     1,     0,
       4,     0,     2,     3,     1,     2,     3,     3,     3,     3,
       3,     1,     2,     0,     1,     2,     1,     2,     0,     1,
       2,     3,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     3,     2,     3,
       3,     1,     0,     1,     1,     3,     4,     0,     5,     1,
       1,     1,     1,     1,     1,     1,     2,     1,     3,     0,
       4,     1,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     0,     2,     3,     1,     2,     3,     1,     2,
       1,     2,     4,     1,     2,     1,     3,     4,     5,     0,
       3,     3,     5,     3,     4,     3,     3,     5,     0,     3,
       0,     2,     0,     2,     0,     2,     0,     5,     2,     2,
       0,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     5,     5,     5,     5,     5,
       5,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     3,     0,     1,     1,
       1,     1,     0,     1,     1,     4,     1,     1,     1,     7,
       0,     4,     3,     3,     1,     4,     0,     1,     1,     0,
       5,     2,     2,     1,     0,     4,     5,     2,     3,     1,
       1,     3,     1,     2,     4,     4,     4,     1,     3,     4,
       4,     3,     1,     1,     3,     2,     2,     2,     0,     2,
       3,     1,     2,     1,     1,     5,     0,     1,     1,     1,
       0,     6,     1,     2,     2,     0,     2,     0,    10,     0,
       3,     0,     3,     0,     2,     2,     0,     5,     3,     1,
       1,     0,     2,     2,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     5,     0,     1,     1,     4,     6,
       9,     0,     3,     0,     2,     0,     2,     3,     5,     5,
       1,     1,     1,     1,     3,     5,     0,     2,     1,     1,
       1,     4,     2,     2,     4,     1,     1,     1,     1,     1,
       1,     1,     4,     0,     2,     2,     2,     2,     1,     2,
       0,     0,     5,     0,     2,     2,     0,     5,     0,     2,
       4,     3,     4,     0,     1,     1,     1,     2,     4,     4,
       4,     4,     4,     4,     4,     4,     4,     4,     4,    11,
       0,     1,     1,     2,     4,     4,     4,     6,     4,     3,
       4,     0,     1,     1,     1,     2,     4,     4,     4,     4,
       4,     4,     6,     0,     0,     5,     0,     0,     2,     2,
       3,     1,     1,     1,     0,     4,     3,     2,     0,     1,
       1,     1,     1,     0,     2,     1,     2,     2,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     5,     0,     2,     0,     4,     5,     0,     7,     2,
       2,     1,     3,     1,     1,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     3,     0,     2,     0,     1,     2,     1,     1,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     3,     3,     4,     3,
       3,     3,     4,     1,     1,     1,     1,     1,     1,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       1,     1,     1,     1,     1,     1,     0,     1,     3,     3,
       6,     0,     2,     6,     8,     7,     0,     2,     0,     2,
       0,     2,     0,     3,     0,     3,     0,     1,     0,     2,
       0,     3,     1,     1,     1,     1,     2,     4,     1,     1,
       0,     1,     3,     1,     2,     1,     2,     2,     3,     1,
       0,     5,     1,     2,     3,     1,     0,     4,     2,     2,
       0,     0,     5,     0,     0,     5,     0,     0,     5,     0,
       2,     0,     6,     0,     2,     2,     2,     3,     1,     1,
       2,     2,     4,     1,     4,     2,     0,     2,     1,     1,
       1,     1,     1,     3,     4,     4,     4,     3,     0,     2,
       0,     5,     0,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     1,     1,     2,     1,     2,     1,     1,     0,     2,
       2,     0,     2,     4,     4,     0,     3,     1,     1,     3,
       6,     2,     3,     2,     2,     3,     2,     1,     2,     2,
       1,     1,     1,     2,     2,     1,     4,     2,     3,     0,
       0,     5,     0,     1,     2,     3,     1,     0,     4,     3,
       0,     2,     2,     2,     1,     1,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     4,     1,     1,     2,     2,     3,     3,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     2,     2,     1,
       2,     1,     2,     1,     1,     1,     1,     4,     0,     1,
       1,     4,     0,     1,     1,     3,     2,     0,     0,     0,
      10,     0,     4,     0,     0,     3,     0,     3,     1,     2,
       4,     0,     2,     2,     0,     3,     3,     4,     2,     1,
       3,     0,     1,     0,     2,     2,     0,     0,     7,     0,
       2,     1,     1,     2,     1,     1,     0,     6,     0,     2,
       2,     1,     0,     1,     0,     0,     3,     0,     2,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     2,     0,     4,     0,
       4,     3,     3,     4,     3,     4,     3,     3,     4,     4,
       3,     4,     3,     4,     5,     3,     4,     3,     3,     3,
       1,     1,     0,     1,     1,     2,     1,     1,     1,     2,
       3,     1,     2,     2,     2,     2,     3,     3,     3,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     4,     1,     1,     1,     1,     4,     3,     1,
       2,     1,     1,     3,     3,     3,     3,     3,     2,     1,
       1,     1,     1,     1,     1,     1,     0,     1,     0,     4,
       4,     5,     6,     8,     0,     2,     0,     1,     0,     3,
       3,     4,     0,     2,     0,     3,     1,     2,     4,     0,
       2,     0,     4,     0,     8,     0,     1,     1,     1,     1,
       1,     2,     0,     2,     1,     1,     0,     0,     3,     1,
       2,     2,     3,     0,     2,     2,     2,     0,     3,     2,
       2,     4,     1,     1,     1,     1,     0,     2,     2,     0,
       1,     2,     2,     0,     1,     2,     0,     1,     0,     3,
       1,     2,     1,     1,     0,     3,     1,     1,     2,     3,
       0,     1,     3,     3,     2,     0,     4,     0,     3,     0,
       4,     4,     0,     1,     1,     1,     0,     3,     2,     1,
       0,     4,     4,     2,     1,     2,     0,     1,     0,     3,
       3,     0,     3,     0,     2,     1,     2,     1,     0,     4,
       3,     3,     3,     3,     2,     1,     1,     1,     2,     1,
       1,     2,     0,     3,     1,     1,     1,     2,     1,     2,
       1,     1,     2,     2,     2,     2,     2,     1,     1,     0,
       0,     5,     1,     1,     0,     0,     7,     0,     5,     1,
       1,     1,     0,     1,     0,     2,     1,     2,     1,     2,
       1,     2,     1,     1,     4,     3,     1,     2,     2,     1,
       1,     2,     2,     1,     1,     1,     1,     3,     1,     3,
       3,     3,     3,     0,     1,     0,     4,     4,     6,     6,
       8,     8,     0,     1,     0,     3,     0,     3,     3,     0,
       4,     2,     1,     3,     1,     1,     1,     2,     1,     1,
       2,     2,     3,     2,     3,     1,     3,     2,     1,     1,
       1,     0,     2,     0,     1,     0,     3,     0,     2,     1,
       2,     1,     1,     1,     0,     2,     0,     3,     1,     0,
       3,     1,     0,     3,     3,     0,     3,     2,     0,     6,
       5,     3,     2,     0,     1,     0,     0,     0,     1,     0,
       3,     5,     0,     2,     0,     3,     3,     0,     2,     1,
       2,     4,     1,     1,     1,     1,     1,     1,     1,     0,
       3,     0,     3,     1,     2,     0,     3,     2,     1,     1,
       1,     2,     1,     1,     1,     0,     3,     2,     5,     1,
       2,     2,     2,     1,     1,     1,     2,     1,     2,     4,
       2,     0,     1,     1,     1,     1,     4,     0,     1,     1,
       2,     2,     3,     3,     0,     3,     0,     3,     3,     4,
       0,     4,     4,     6,     0,     1,     0,     3,     1,     2,
       5,     1,     1,     1,     1,     0,     3,     0,     3,     2,
       1,     0,     3,     4,     0,     6,     4,     0,     1,     1,
       1,     1,     3,     0,     2,     1,     3,     3,     0,     3,
       1,     1,     1,     3,     7,     0,     3,     0,     4,     7,
       0,     2,     0,     1,     2,     1,     2,     3,     3,     1,
       0,     1,     1,     4,     4,     2,     0,     1,     1,     3,
       2,     0,     3,     1,     1,     0,     1,     1,     0,     4,
       5,     1,     1,     0,     2,     2,     0,     1,     2,     0,
       1,     2,     0,     1,     0,     3,     2,     1,     0,     4,
       4,     0,     1,     0,     4,     5,     0,     1,     2,     3,
       0,     1,     1,     0,     4,     4,     6,     0,     2,     0,
       2,     1,     2,     3,     0,     1,     0,     3,     2,     5,
       0,     1,     2,     2,     2,     2,     2,     0,     2,     0,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     4,     3,     1,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     4,     3,     5,     4,     1,
       2,     3,     1,     2,     3,     3,     4,     4,     0,     3,
       0,     7,     0,     5,     0,     2,     0,     2,     0,     3,
       0,     2,     4,     0,     2,     4,     0,     4,     4,     0,
       3,     0,     4,     1,     1,     1,     2,     2,     2,     2,
       1,     1,     2,     1,     0,     1,     0,     4,     2,     2,
       0,     2,     1,     4,     4,     0,     1,     1,     1,     1,
       1,     1,     1,     0,     4,     5,     1,     2,     2,     0,
       3,     1,     1,     0,     4,     0,     1,     0,     4,     4,
       6,     6,     8,     0,     1,     2,     0,     1,     0,     3,
       1,     2,     0,     3,     5,     0,     3,     2,     0,     4,
       6,     0,     3,     1,     3,     2,     2,     2,     3,     0,
       3,     0,     3,     0,     3,     0,     1,     0,     3,     1,
       1,     1,     1,     1,     7,     0,     1,     1,     1,     1,
       1,     1,     4,     1,     2,     1,     2,     3,     0,     1,
       2,     1,     3,     1,     1,     4,     1,     1,     1,     0,
       4,     6,     0,     2,     0,     4,     3,     3,     1,     1,
       0,     1,     1,     0,     1,     0,     2,     2,     0,     1,
       2,     1,     1,     0,     1,     2,     1,     1,     0,     2,
       2,     0,     1,     2,     0,     1,     2,     0,     2,     2,
       0,     1,     2,     0,     1,     2,     0,     2,     2,     0,
       1,     2,     0,     1,     2,     2,     2,     2,     2,     0,
       1,     2,     0,     1,     2,     2,     2,     0,     1,     2,
       0,     1,     2,     0,     1,     2,     2,     0,     1,     2,
       0,     1,     2,     0,     2,     0,     3,     2,     1,     0,
       2,     1,     1,     0,     2,     1,     2,     1,     2,     3,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       1,     1,     1,     1,     1,     1,     1,     3,     0,     1,
       1,     3,     3,     1,     3,     3,     1,     3,     1,     2,
       2,     1,     3,     1,     1,     3,     1,     3,     1,     3,
       1,     2,     2,     1,     1,     2,     1,     1,     2,     1,
       1,     1,     1,     2,     1,     0,     2,     1,     1,     1,
       3,     1,     1,     2,     1,     1,     1,     2,     1,     1,
       1,     1,     1,     1,     1,     2,     1,     1,     3,     0,
       1,     1,     2,     1,     1,     1,     1,     1,     1,     1,
       2,     2,     2,     4,     3,     1,     1,     2,     1,     1,
       1,     1,     1,     1,     1,     2,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     1,     1,     1,     1,     3,     2,     2,     1,     1,
       2,     1,     3,     2,     2,     1,     1,     3,     3,     4,
       5,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     1,     3,     1,     1,     1,     1,     1,
       1,     1,     2,     5,     5,     5,     4,     4,     5,     5,
       5,     5,     5,     2,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     4,     5,     0,     3,     2,
       1,     3,     3,     0,     2,     1,     3,     1,     3,     1,
       3,     1,     3,     0,     0,     1,     0,     1,     0,     1,
       0,     2,     0,     2,     0,     1,     1,     0,     1,     0,
       1,     2,     0,     2,     0,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     2,     0,     5,     0,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     1,     0,     1,     0,     1,     0,
       1,     0,     1,     1,     0,     1,     0,     1,     0,     1,
       0,     1,     0,     1,     0,     1,     0,     1,     0,     1,
       0,     1,     0,     1,     0,     2,     0,     1,     0,     1,
       0,     1,     0,     1,     0,     1,     0,     1,     2,     0,
       1,     0,     1,     0,     1,     0,     1,     0,     1,     0,
       1,     1,     0,     1,     1,     0,     1,     0,     1,     1,
       0,     1,     0,     1,     1,     0,     2,     2,     0,     1,
       0,     1,     0,     1,     0,     1,     0,     1,     1,     0,
       1,     0,     1,     0,     2,     1,     1,     0,     1,     0,
       1,     0,     1,     0,     1,     0,     1,     1,     0,     1,
       0,     1,     0,     1,     0,     1,     2,     0,     1,     0,
       1,     0,     1,     0,     1,     0,     1,     0,     1,     0,
       1,     0,     1,     0,     1,     0,     1,     1,     0,     1,
       0,     3,     0,     1,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     2,     1,     1,     1,
       1,     1,     1,     2,     1,     3,     2,     1,     1,     1,
       2,     1,     2,     1,     2,     1,     2,     1,     2,     1,
       2,     1,     2,     2
};


#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)
#define YYEMPTY         (-2)
#define YYEOF           0

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                  \
do                                                              \
  if (yychar == YYEMPTY)                                        \
    {                                                           \
      yychar = (Token);                                         \
      yylval = (Value);                                         \
      YYPOPSTACK (yylen);                                       \
      yystate = *yyssp;                                         \
      goto yybackup;                                            \
    }                                                           \
  else                                                          \
    {                                                           \
      yyerror (YY_("syntax error: cannot back up")); \
      YYERROR;                                                  \
    }                                                           \
while (0)

/* Error token number */
#define YYTERROR        1
#define YYERRCODE       256



/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)

/* This macro is provided for backward compatibility. */
#ifndef YY_LOCATION_PRINT
# define YY_LOCATION_PRINT(File, Loc) ((void) 0)
#endif


# define YY_SYMBOL_PRINT(Title, Type, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Type, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*----------------------------------------.
| Print this symbol's value on YYOUTPUT.  |
`----------------------------------------*/

static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
{
  FILE *yyo = yyoutput;
  YYUSE (yyo);
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
  YYUSE (yytype);
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyoutput, "%s %s (",
             yytype < YYNTOKENS ? "token" : "nterm", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yytype_int16 *yybottom, yytype_int16 *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yytype_int16 *yyssp, YYSTYPE *yyvsp, int yyrule)
{
  unsigned long int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       yystos[yyssp[yyi + 1 - yynrhs]],
                       &(yyvsp[(yyi + 1) - (yynrhs)])
                                              );
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
yystrlen (const char *yystr)
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            /* Fall through.  */
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return 1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return 2 if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYSIZE_T *yymsg_alloc, char **yymsg,
                yytype_int16 *yyssp, int yytoken)
{
  YYSIZE_T yysize0 = yytnamerr (YY_NULLPTR, yytname[yytoken]);
  YYSIZE_T yysize = yysize0;
  enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat. */
  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
  /* Number of reported tokens (one for the "unexpected", one per
     "expected"). */
  int yycount = 0;

  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yytoken != YYEMPTY)
    {
      int yyn = yypact[*yyssp];
      yyarg[yycount++] = yytname[yytoken];
      if (!yypact_value_is_default (yyn))
        {
          /* Start YYX at -YYN if negative to avoid negative indexes in
             YYCHECK.  In other words, skip the first -YYN actions for
             this state because they are default actions.  */
          int yyxbegin = yyn < 0 ? -yyn : 0;
          /* Stay within bounds of both yycheck and yytname.  */
          int yychecklim = YYLAST - yyn + 1;
          int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
          int yyx;

          for (yyx = yyxbegin; yyx < yyxend; ++yyx)
            if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR
                && !yytable_value_is_error (yytable[yyx + yyn]))
              {
                if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
                  {
                    yycount = 1;
                    yysize = yysize0;
                    break;
                  }
                yyarg[yycount++] = yytname[yyx];
                {
                  YYSIZE_T yysize1 = yysize + yytnamerr (YY_NULLPTR, yytname[yyx]);
                  if (! (yysize <= yysize1
                         && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
                    return 2;
                  yysize = yysize1;
                }
              }
        }
    }

  switch (yycount)
    {
# define YYCASE_(N, S)                      \
      case N:                               \
        yyformat = S;                       \
      break
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
# undef YYCASE_
    }

  {
    YYSIZE_T yysize1 = yysize + yystrlen (yyformat);
    if (! (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
      return 2;
    yysize = yysize1;
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return 1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yyarg[yyi++]);
          yyformat += 2;
        }
      else
        {
          yyp++;
          yyformat++;
        }
  }
  return 0;
}
#endif /* YYERROR_VERBOSE */

/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
{
  YYUSE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YYUSE (yytype);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}




/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;


/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    int yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       'yyss': related to states.
       'yyvs': related to semantic values.

       Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yytype_int16 yyssa[YYINITDEPTH];
    yytype_int16 *yyss;
    yytype_int16 *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    YYSIZE_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yyssp = yyss = yyssa;
  yyvsp = yyvs = yyvsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */
  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        YYSTYPE *yyvs1 = yyvs;
        yytype_int16 *yyss1 = yyss;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * sizeof (*yyssp),
                    &yyvs1, yysize * sizeof (*yyvsp),
                    &yystacksize);

        yyss = yyss1;
        yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yytype_int16 *yyss1 = yyss;
        union yyalloc *yyptr =
          (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
        if (! yyptr)
          goto yyexhaustedlab;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
                  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token.  */
  yychar = YYEMPTY;

  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 2400 "parser.y" /* yacc.c:1646  */
    {
	clear_initial_values ();
	current_program = NULL;
	defined_prog_list = NULL;
	cobc_cs_check = 0;
	main_flag_set = 0;
	current_program = cb_build_program (NULL, 0);
	cb_set_intr_when_compiled ();
	cb_build_registers ();
  }
#line 8594 "parser.c" /* yacc.c:1646  */
    break;

  case 3:
#line 2411 "parser.y" /* yacc.c:1646  */
    {
	if (!current_program->flag_validated) {
		current_program->flag_validated = 1;
		cb_validate_program_body (current_program);
	}
	if (depth > 1) {
		cb_error (_("multiple PROGRAM-ID's without matching END PROGRAM"));
	}
	if (cobc_flag_main && !main_flag_set) {
		cb_error (_("executable requested but no program found"));
	}
	if (errorcount > 0) {
		YYABORT;
	}
	if (!current_program->entry_list) {
		emit_entry (current_program->program_id, 0, NULL, NULL);
	}
  }
#line 8617 "parser.c" /* yacc.c:1646  */
    break;

  case 6:
#line 2437 "parser.y" /* yacc.c:1646  */
    {
	first_prog = 1;
	depth = 0;
	setup_from_identification = 0;
  }
#line 8627 "parser.c" /* yacc.c:1646  */
    break;

  case 12:
#line 2456 "parser.y" /* yacc.c:1646  */
    {
	cb_tree		l;

	current_section = NULL;
	current_paragraph = NULL;
	l = cb_build_alphanumeric_literal (demangle_name,
					   strlen (demangle_name));
	current_program->program_id = cb_build_program_id (l, NULL, 0);
	current_program->prog_type = CB_PROGRAM_TYPE;
	if (!main_flag_set) {
		main_flag_set = 1;
		current_program->flag_main = cobc_flag_main;
	}
	check_relaxed_syntax (COBC_HD_PROGRAM_ID);
  }
#line 8647 "parser.c" /* yacc.c:1646  */
    break;

  case 13:
#line 2473 "parser.y" /* yacc.c:1646  */
    {
	clean_up_program (NULL, CB_PROGRAM_TYPE);
  }
#line 8655 "parser.c" /* yacc.c:1646  */
    break;

  case 16:
#line 2500 "parser.y" /* yacc.c:1646  */
    {
	clean_up_program (NULL, CB_PROGRAM_TYPE);
  }
#line 8663 "parser.c" /* yacc.c:1646  */
    break;

  case 20:
#line 2513 "parser.y" /* yacc.c:1646  */
    {
	first_nested_program = 0;
	clean_up_program ((yyvsp[-1]), CB_PROGRAM_TYPE);
  }
#line 8672 "parser.c" /* yacc.c:1646  */
    break;

  case 21:
#line 2521 "parser.y" /* yacc.c:1646  */
    {
	clean_up_program ((yyvsp[-1]), CB_FUNCTION_TYPE);
  }
#line 8680 "parser.c" /* yacc.c:1646  */
    break;

  case 24:
#line 2539 "parser.y" /* yacc.c:1646  */
    {
	setup_program_start ();
	setup_from_identification = 1;
  }
#line 8689 "parser.c" /* yacc.c:1646  */
    break;

  case 27:
#line 2552 "parser.y" /* yacc.c:1646  */
    {
	cobc_in_id = 1;
  }
#line 8697 "parser.c" /* yacc.c:1646  */
    break;

  case 28:
#line 2556 "parser.y" /* yacc.c:1646  */
    {
	if (setup_program ((yyvsp[-1]), (yyvsp[0]), CB_PROGRAM_TYPE)) {
		YYABORT;
	}

	setup_prototype ((yyvsp[-1]), (yyvsp[0]), CB_PROGRAM_TYPE, 1);
  }
#line 8709 "parser.c" /* yacc.c:1646  */
    break;

  case 29:
#line 2564 "parser.y" /* yacc.c:1646  */
    {
	cobc_cs_check = 0;
	cobc_in_id = 0;
  }
#line 8718 "parser.c" /* yacc.c:1646  */
    break;

  case 30:
#line 2572 "parser.y" /* yacc.c:1646  */
    {
	cobc_in_id = 1;
  }
#line 8726 "parser.c" /* yacc.c:1646  */
    break;

  case 31:
#line 2576 "parser.y" /* yacc.c:1646  */
    {
	if (setup_program ((yyvsp[-2]), (yyvsp[-1]), CB_FUNCTION_TYPE)) {
		YYABORT;
	}
	setup_prototype ((yyvsp[-2]), (yyvsp[-1]), CB_FUNCTION_TYPE, 1);
	cobc_cs_check = 0;
	cobc_in_id = 0;
  }
#line 8739 "parser.c" /* yacc.c:1646  */
    break;

  case 32:
#line 2588 "parser.y" /* yacc.c:1646  */
    {
	if (CB_REFERENCE_P ((yyvsp[0])) && CB_WORD_COUNT ((yyvsp[0])) > 0) {
		redefinition_error ((yyvsp[0]));
	}
	/*
	  The program name is a key part of defining the current_program, so we
	  mustn't lose it (unlike in undefined_word).
	*/
	(yyval) = (yyvsp[0]);
  }
#line 8754 "parser.c" /* yacc.c:1646  */
    break;

  case 33:
#line 2599 "parser.y" /* yacc.c:1646  */
    {
	cb_trim_program_id ((yyvsp[0]));
  }
#line 8762 "parser.c" /* yacc.c:1646  */
    break;

  case 35:
#line 2607 "parser.y" /* yacc.c:1646  */
    {
	cb_trim_program_id ((yyvsp[0]));
  }
#line 8770 "parser.c" /* yacc.c:1646  */
    break;

  case 36:
#line 2613 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 8776 "parser.c" /* yacc.c:1646  */
    break;

  case 37:
#line 2614 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 8782 "parser.c" /* yacc.c:1646  */
    break;

  case 40:
#line 2623 "parser.y" /* yacc.c:1646  */
    {
	if (!current_program->nested_level) {
		cb_error (_("COMMON may only be used in a contained program"));
	} else {
		current_program->flag_common = 1;
		cb_add_common_prog (current_program);
	}
  }
#line 8795 "parser.c" /* yacc.c:1646  */
    break;

  case 41:
#line 2632 "parser.y" /* yacc.c:1646  */
    {
	if (!current_program->nested_level) {
		cb_error (_("COMMON may only be used in a contained program"));
	} else {
		current_program->flag_common = 1;
		cb_add_common_prog (current_program);
	}
  }
#line 8808 "parser.c" /* yacc.c:1646  */
    break;

  case 43:
#line 2642 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING (_("CALL prototypes"));
  }
#line 8816 "parser.c" /* yacc.c:1646  */
    break;

  case 46:
#line 2654 "parser.y" /* yacc.c:1646  */
    {
	current_program->flag_initial = 1;
  }
#line 8824 "parser.c" /* yacc.c:1646  */
    break;

  case 47:
#line 2658 "parser.y" /* yacc.c:1646  */
    {
	current_program->flag_recursive = 1;
  }
#line 8832 "parser.c" /* yacc.c:1646  */
    break;

  case 49:
#line 2667 "parser.y" /* yacc.c:1646  */
    {
	cobc_cs_check = 0;
  }
#line 8840 "parser.c" /* yacc.c:1646  */
    break;

  case 51:
#line 2681 "parser.y" /* yacc.c:1646  */
    {
	default_rounded_mode = cb_int (COB_STORE_ROUND);
  }
#line 8848 "parser.c" /* yacc.c:1646  */
    break;

  case 52:
#line 2685 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0])) {
		default_rounded_mode = (yyvsp[0]);
	} else {
		default_rounded_mode = cb_int (COB_STORE_ROUND);
	}
  }
#line 8860 "parser.c" /* yacc.c:1646  */
    break;

  case 54:
#line 2697 "parser.y" /* yacc.c:1646  */
    {
	current_program->entry_convention = (yyvsp[0]);
	current_program->entry_convention->source_file = cb_source_file;
	current_program->entry_convention->source_line = cb_source_line;
  }
#line 8870 "parser.c" /* yacc.c:1646  */
    break;

  case 55:
#line 2706 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int (CB_CONV_COBOL);
  }
#line 8878 "parser.c" /* yacc.c:1646  */
    break;

  case 56:
#line 2710 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int (0);
  }
#line 8886 "parser.c" /* yacc.c:1646  */
    break;

  case 57:
#line 2714 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int (CB_CONV_STDCALL);
  }
#line 8894 "parser.c" /* yacc.c:1646  */
    break;

  case 59:
#line 2722 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("INTERMEDIATE ROUNDING");
  }
#line 8902 "parser.c" /* yacc.c:1646  */
    break;

  case 60:
#line 2729 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int (COB_STORE_ROUND | COB_STORE_NEAR_AWAY_FROM_ZERO);
  }
#line 8910 "parser.c" /* yacc.c:1646  */
    break;

  case 61:
#line 2733 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int (COB_STORE_ROUND | COB_STORE_NEAR_EVEN);
  }
#line 8918 "parser.c" /* yacc.c:1646  */
    break;

  case 62:
#line 2737 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int (COB_STORE_ROUND | COB_STORE_PROHIBITED);
  }
#line 8926 "parser.c" /* yacc.c:1646  */
    break;

  case 63:
#line 2741 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int (COB_STORE_ROUND | COB_STORE_TRUNCATION);
  }
#line 8934 "parser.c" /* yacc.c:1646  */
    break;

  case 66:
#line 2756 "parser.y" /* yacc.c:1646  */
    {
	header_check |= COBC_HD_ENVIRONMENT_DIVISION;
  }
#line 8942 "parser.c" /* yacc.c:1646  */
    break;

  case 70:
#line 2771 "parser.y" /* yacc.c:1646  */
    {
	cb_verify (cb_incorrect_conf_sec_order,
		   _("incorrect order of CONFIGURATION SECTION paragraphs"));
  }
#line 8951 "parser.c" /* yacc.c:1646  */
    break;

  case 82:
#line 2800 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_CONFIGURATION_SECTION;
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "CONFIGURATION SECTION");
	}
  }
#line 8963 "parser.c" /* yacc.c:1646  */
    break;

  case 88:
#line 2818 "parser.y" /* yacc.c:1646  */
    {
	cb_verify (cb_incorrect_conf_sec_order,
		   _("incorrect order of SOURCE- and OBJECT-COMPUTER paragraphs"));
  }
#line 8972 "parser.c" /* yacc.c:1646  */
    break;

  case 89:
#line 2829 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION, 0, 0);
  }
#line 8981 "parser.c" /* yacc.c:1646  */
    break;

  case 94:
#line 2843 "parser.y" /* yacc.c:1646  */
    {
	current_program->flag_debugging = 1;
	needs_debug_item = 1;
	cobc_cs_check = 0;
	cb_build_debug_item ();
  }
#line 8992 "parser.c" /* yacc.c:1646  */
    break;

  case 95:
#line 2855 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION, 0, 0);
  }
#line 9001 "parser.c" /* yacc.c:1646  */
    break;

  case 96:
#line 2860 "parser.y" /* yacc.c:1646  */
    {
	cobc_cs_check = 0;
  }
#line 9009 "parser.c" /* yacc.c:1646  */
    break;

  case 107:
#line 2886 "parser.y" /* yacc.c:1646  */
    {
	cb_verify (cb_memory_size_clause, "MEMORY SIZE");
  }
#line 9017 "parser.c" /* yacc.c:1646  */
    break;

  case 108:
#line 2894 "parser.y" /* yacc.c:1646  */
    {
	current_program->collating_sequence = (yyvsp[0]);
  }
#line 9025 "parser.c" /* yacc.c:1646  */
    break;

  case 109:
#line 2901 "parser.y" /* yacc.c:1646  */
    {
	int segnum;
	
	if (cb_verify (cb_section_segments, "SEGMENT LIMIT")) {
		segnum = cb_get_int ((yyvsp[0]));
		if (segnum == 0 || segnum > 49) {
			cb_error (_("segment-number must be in range of values 1 to 49"));
			(yyval) = NULL;
		}
	}
	/* Ignore */
  }
#line 9042 "parser.c" /* yacc.c:1646  */
    break;

  case 110:
#line 2917 "parser.y" /* yacc.c:1646  */
    {
	if (current_program->classification) {
		cb_error (_("duplicate CLASSIFICATION clause"));
	} else {
		current_program->classification = (yyvsp[0]);
	}
  }
#line 9054 "parser.c" /* yacc.c:1646  */
    break;

  case 111:
#line 2928 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 9062 "parser.c" /* yacc.c:1646  */
    break;

  case 112:
#line 2932 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 9070 "parser.c" /* yacc.c:1646  */
    break;

  case 113:
#line 2936 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int1;
  }
#line 9078 "parser.c" /* yacc.c:1646  */
    break;

  case 114:
#line 2940 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int1;
  }
#line 9086 "parser.c" /* yacc.c:1646  */
    break;

  case 119:
#line 2958 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION, 0, 0);
  }
#line 9095 "parser.c" /* yacc.c:1646  */
    break;

  case 120:
#line 2963 "parser.y" /* yacc.c:1646  */
    {
	cobc_in_repository = 0;
  }
#line 9103 "parser.c" /* yacc.c:1646  */
    break;

  case 123:
#line 2971 "parser.y" /* yacc.c:1646  */
    {
	yyerrok;
  }
#line 9111 "parser.c" /* yacc.c:1646  */
    break;

  case 126:
#line 2983 "parser.y" /* yacc.c:1646  */
    {
	functions_are_all = 1;
  }
#line 9119 "parser.c" /* yacc.c:1646  */
    break;

  case 127:
#line 2987 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[-1]) != cb_error_node) {
		setup_prototype ((yyvsp[-1]), (yyvsp[0]), CB_FUNCTION_TYPE, 0);
	}
  }
#line 9129 "parser.c" /* yacc.c:1646  */
    break;

  case 129:
#line 2994 "parser.y" /* yacc.c:1646  */
    {
	  if ((yyvsp[-1]) != cb_error_node
	      && cb_verify (cb_program_prototypes, _("PROGRAM phrase"))) {
		setup_prototype ((yyvsp[-1]), (yyvsp[0]), CB_PROGRAM_TYPE, 0);
	}
  }
#line 9140 "parser.c" /* yacc.c:1646  */
    break;

  case 130:
#line 3001 "parser.y" /* yacc.c:1646  */
    {
	  yyerrok;
  }
#line 9148 "parser.c" /* yacc.c:1646  */
    break;

  case 131:
#line 3008 "parser.y" /* yacc.c:1646  */
    {
	current_program->function_spec_list =
		cb_list_add (current_program->function_spec_list, (yyvsp[0]));
  }
#line 9157 "parser.c" /* yacc.c:1646  */
    break;

  case 132:
#line 3013 "parser.y" /* yacc.c:1646  */
    {
	current_program->function_spec_list =
		cb_list_add (current_program->function_spec_list, (yyvsp[0]));
  }
#line 9166 "parser.c" /* yacc.c:1646  */
    break;

  case 137:
#line 3033 "parser.y" /* yacc.c:1646  */
    {
	check_duplicate = 0;
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION, 0, 0);
	header_check |= COBC_HD_SPECIAL_NAMES;
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	}
  }
#line 9180 "parser.c" /* yacc.c:1646  */
    break;

  case 156:
#line 3079 "parser.y" /* yacc.c:1646  */
    {
	char system_name[16];
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	check_duplicate = 0;
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
		save_tree = NULL;
	} else {
		/* get system name and revert word-combination of scanner.l,
		   if necessary (e.g. SWITCH A <--> SWITCH_A) */
		system_name[15] = 0;
		strncpy(system_name, CB_NAME ((yyvsp[0])), 15);
		if (system_name [6] == '_') {
			system_name [6] = ' ';
		}
		/* lookup system name */
		save_tree = get_system_name (system_name);
		if (!save_tree) {
			cb_error_x ((yyvsp[0]), _("invalid system-name '%s'"), system_name);
		}
	}
  }
#line 9209 "parser.c" /* yacc.c:1646  */
    break;

  case 158:
#line 3108 "parser.y" /* yacc.c:1646  */
    {
	if (save_tree) {
		if (CB_SYSTEM_NAME(save_tree)->token != CB_DEVICE_CONSOLE) {
			cb_error_x (save_tree, _("invalid %s clause"), "");
		} else {
			current_program->flag_console_is_crt = 1;
		}
	}
  }
#line 9223 "parser.c" /* yacc.c:1646  */
    break;

  case 159:
#line 3119 "parser.y" /* yacc.c:1646  */
    {
	if (save_tree) {
		if (CB_SYSTEM_NAME(save_tree)->token != CB_FEATURE_CONVENTION) {
			cb_error_x (save_tree, _("invalid %s clause"), "SPECIAL NAMES");
		} else if (CB_VALID_TREE ((yyvsp[0]))) {
			CB_SYSTEM_NAME(save_tree)->value = (yyvsp[-2]);
			cb_define ((yyvsp[0]), save_tree);
			CB_CHAIN_PAIR (current_program->mnemonic_spec_list,
					(yyvsp[0]), save_tree);
			/* remove non-standard context-sensitive words when identical to mnemonic */
			if (strcasecmp (CB_NAME((yyvsp[0])), "EXTERN") == 0 ||
			    strcasecmp (CB_NAME((yyvsp[0])), "STDCALL") == 0 ||
			    strcasecmp (CB_NAME((yyvsp[0])), "STATIC") == 0) {
				remove_context_sensitivity (CB_NAME((yyvsp[0])), CB_CS_CALL);
			}
		}
	}
  }
#line 9246 "parser.c" /* yacc.c:1646  */
    break;

  case 160:
#line 3138 "parser.y" /* yacc.c:1646  */
    {
	if (save_tree && CB_VALID_TREE ((yyvsp[-1]))) {
		cb_define ((yyvsp[-1]), save_tree);
		CB_CHAIN_PAIR (current_program->mnemonic_spec_list,
				(yyvsp[-1]), save_tree);
	}
  }
#line 9258 "parser.c" /* yacc.c:1646  */
    break;

  case 164:
#line 3154 "parser.y" /* yacc.c:1646  */
    {
	  check_on_off_duplicate = 0;
  }
#line 9266 "parser.c" /* yacc.c:1646  */
    break;

  case 165:
#line 3161 "parser.y" /* yacc.c:1646  */
    {
	cb_tree		x;

	/* cb_define_switch_name checks param validity */
	x = cb_define_switch_name ((yyvsp[0]), save_tree, (yyvsp[-2]) == cb_int1);
	if (x) {
		if ((yyvsp[-2]) == cb_int1) {
			check_repeated ("ON", SYN_CLAUSE_1, &check_on_off_duplicate);
		} else {
			check_repeated ("OFF", SYN_CLAUSE_2, &check_on_off_duplicate);
		}
		CB_CHAIN_PAIR (current_program->mnemonic_spec_list, (yyvsp[0]), x);
	}
  }
#line 9285 "parser.c" /* yacc.c:1646  */
    break;

  case 166:
#line 3176 "parser.y" /* yacc.c:1646  */
    {
	cb_tree		x;

	/* cb_define_switch_name checks param validity */
	x = cb_define_switch_name ((yyvsp[0]), save_tree, (yyvsp[-2]) == cb_int1);
	if (x) {
		if ((yyvsp[-2]) == cb_int1) {
			check_repeated ("ON", SYN_CLAUSE_1, &check_on_off_duplicate);
		} else {
			check_repeated ("OFF", SYN_CLAUSE_2, &check_on_off_duplicate);
		}
		CB_CHAIN_PAIR (current_program->mnemonic_spec_list, (yyvsp[0]), x);
	}
  }
#line 9304 "parser.c" /* yacc.c:1646  */
    break;

  case 167:
#line 3196 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
		(yyval) = NULL;
	} else {
		/* Returns null on error */
		(yyval) = cb_build_alphabet_name ((yyvsp[0]));
	}
  }
#line 9321 "parser.c" /* yacc.c:1646  */
    break;

  case 168:
#line 3209 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[-2])) {
		current_program->alphabet_name_list =
			cb_list_add (current_program->alphabet_name_list, (yyvsp[-2]));
	}
	cobc_cs_check = 0;
  }
#line 9333 "parser.c" /* yacc.c:1646  */
    break;

  case 169:
#line 3220 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[(-1) - (1)])) {
		CB_ALPHABET_NAME ((yyvsp[(-1) - (1)]))->alphabet_type = CB_ALPHABET_NATIVE;
	}
  }
#line 9343 "parser.c" /* yacc.c:1646  */
    break;

  case 170:
#line 3226 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[(-1) - (1)])) {
		CB_ALPHABET_NAME ((yyvsp[(-1) - (1)]))->alphabet_type = CB_ALPHABET_ASCII;
	}
  }
#line 9353 "parser.c" /* yacc.c:1646  */
    break;

  case 171:
#line 3232 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[(-1) - (1)])) {
		CB_ALPHABET_NAME ((yyvsp[(-1) - (1)]))->alphabet_type = CB_ALPHABET_ASCII;
	}
  }
#line 9363 "parser.c" /* yacc.c:1646  */
    break;

  case 172:
#line 3238 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[(-1) - (1)])) {
		CB_ALPHABET_NAME ((yyvsp[(-1) - (1)]))->alphabet_type = CB_ALPHABET_EBCDIC;
	}
  }
#line 9373 "parser.c" /* yacc.c:1646  */
    break;

  case 173:
#line 3244 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[(-1) - (1)])) {
		CB_ALPHABET_NAME ((yyvsp[(-1) - (1)]))->alphabet_type = CB_ALPHABET_ASCII;
	}
  }
#line 9383 "parser.c" /* yacc.c:1646  */
    break;

  case 174:
#line 3250 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[(-1) - (1)])) {
		CB_ALPHABET_NAME ((yyvsp[(-1) - (1)]))->alphabet_type = CB_ALPHABET_CUSTOM;
		CB_ALPHABET_NAME ((yyvsp[(-1) - (1)]))->custom_list = (yyvsp[0]);
	}
  }
#line 9394 "parser.c" /* yacc.c:1646  */
    break;

  case 175:
#line 3260 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_LIST_INIT ((yyvsp[0]));
  }
#line 9402 "parser.c" /* yacc.c:1646  */
    break;

  case 176:
#line 3264 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_list_add ((yyvsp[-1]), (yyvsp[0]));
  }
#line 9410 "parser.c" /* yacc.c:1646  */
    break;

  case 177:
#line 3271 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 9418 "parser.c" /* yacc.c:1646  */
    break;

  case 178:
#line 3275 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_BUILD_PAIR ((yyvsp[-2]), (yyvsp[0]));
  }
#line 9426 "parser.c" /* yacc.c:1646  */
    break;

  case 179:
#line 3279 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_LIST_INIT ((yyvsp[-1]));
  }
#line 9434 "parser.c" /* yacc.c:1646  */
    break;

  case 180:
#line 3283 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[-1]);
  }
#line 9442 "parser.c" /* yacc.c:1646  */
    break;

  case 181:
#line 3290 "parser.y" /* yacc.c:1646  */
    {
	cb_list_add ((yyvsp[-1]), (yyvsp[0]));
  }
#line 9450 "parser.c" /* yacc.c:1646  */
    break;

  case 182:
#line 3294 "parser.y" /* yacc.c:1646  */
    {
	cb_list_add ((yyvsp[-3]), (yyvsp[0]));
  }
#line 9458 "parser.c" /* yacc.c:1646  */
    break;

  case 183:
#line 3300 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 9464 "parser.c" /* yacc.c:1646  */
    break;

  case 184:
#line 3301 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_space; }
#line 9470 "parser.c" /* yacc.c:1646  */
    break;

  case 185:
#line 3302 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_zero; }
#line 9476 "parser.c" /* yacc.c:1646  */
    break;

  case 186:
#line 3303 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_quote; }
#line 9482 "parser.c" /* yacc.c:1646  */
    break;

  case 187:
#line 3304 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_norm_high; }
#line 9488 "parser.c" /* yacc.c:1646  */
    break;

  case 188:
#line 3305 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_norm_low; }
#line 9494 "parser.c" /* yacc.c:1646  */
    break;

  case 189:
#line 3309 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_space; }
#line 9500 "parser.c" /* yacc.c:1646  */
    break;

  case 190:
#line 3310 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_zero; }
#line 9506 "parser.c" /* yacc.c:1646  */
    break;

  case 191:
#line 3318 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else if ((yyvsp[-1])) {
		CB_CHAIN_PAIR (current_program->symbolic_char_list, (yyvsp[-1]), (yyvsp[0]));
	}
  }
#line 9521 "parser.c" /* yacc.c:1646  */
    break;

  case 192:
#line 3332 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 9529 "parser.c" /* yacc.c:1646  */
    break;

  case 193:
#line 3336 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 9537 "parser.c" /* yacc.c:1646  */
    break;

  case 194:
#line 3344 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 9545 "parser.c" /* yacc.c:1646  */
    break;

  case 195:
#line 3351 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 9553 "parser.c" /* yacc.c:1646  */
    break;

  case 196:
#line 3355 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0])) {
		(yyval) = cb_list_append ((yyvsp[-1]), (yyvsp[0]));
	} else {
		(yyval) = (yyvsp[-1]);
	}
  }
#line 9565 "parser.c" /* yacc.c:1646  */
    break;

  case 197:
#line 3366 "parser.y" /* yacc.c:1646  */
    {
	cb_tree		l1;
	cb_tree		l2;

	if (cb_list_length ((yyvsp[-2])) != cb_list_length ((yyvsp[0]))) {
		cb_error (_("invalid %s clause"), "SYMBOLIC");
		(yyval) = NULL;
	} else {
		l1 = (yyvsp[-2]);
		l2 = (yyvsp[0]);
		for (; l1; l1 = CB_CHAIN (l1), l2 = CB_CHAIN (l2)) {
			CB_PURPOSE (l1) = CB_VALUE (l2);
		}
		(yyval) = (yyvsp[-2]);
	}
  }
#line 9586 "parser.c" /* yacc.c:1646  */
    break;

  case 198:
#line 3386 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0]) == NULL) {
		(yyval) = NULL;
	} else {
		(yyval) = CB_LIST_INIT ((yyvsp[0]));
	}
  }
#line 9598 "parser.c" /* yacc.c:1646  */
    break;

  case 199:
#line 3394 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0]) == NULL) {
		(yyval) = (yyvsp[-1]);
	} else {
		(yyval) = cb_list_add ((yyvsp[-1]), (yyvsp[0]));
	}
  }
#line 9610 "parser.c" /* yacc.c:1646  */
    break;

  case 200:
#line 3404 "parser.y" /* yacc.c:1646  */
    { (yyval) = CB_LIST_INIT ((yyvsp[0])); }
#line 9616 "parser.c" /* yacc.c:1646  */
    break;

  case 201:
#line 3405 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_list_add ((yyvsp[-1]), (yyvsp[0])); }
#line 9622 "parser.c" /* yacc.c:1646  */
    break;

  case 202:
#line 3412 "parser.y" /* yacc.c:1646  */
    {
	cb_tree		x;

	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		/* Returns null on error */
		x = cb_build_class_name ((yyvsp[-2]), (yyvsp[0]));
		if (x) {
			current_program->class_name_list =
				cb_list_add (current_program->class_name_list, x);
		}
	}
  }
#line 9644 "parser.c" /* yacc.c:1646  */
    break;

  case 203:
#line 3432 "parser.y" /* yacc.c:1646  */
    { (yyval) = CB_LIST_INIT ((yyvsp[0])); }
#line 9650 "parser.c" /* yacc.c:1646  */
    break;

  case 204:
#line 3433 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_list_add ((yyvsp[-1]), (yyvsp[0])); }
#line 9656 "parser.c" /* yacc.c:1646  */
    break;

  case 205:
#line 3438 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 9664 "parser.c" /* yacc.c:1646  */
    break;

  case 206:
#line 3442 "parser.y" /* yacc.c:1646  */
    {
	if (CB_TREE_CLASS ((yyvsp[-2])) != CB_CLASS_NUMERIC &&
	    CB_LITERAL_P ((yyvsp[-2])) && CB_LITERAL ((yyvsp[-2]))->size != 1) {
		cb_error (_("CLASS literal with THRU must have size 1"));
	}
	if (CB_TREE_CLASS ((yyvsp[0])) != CB_CLASS_NUMERIC &&
	    CB_LITERAL_P ((yyvsp[0])) && CB_LITERAL ((yyvsp[0]))->size != 1) {
		cb_error (_("CLASS literal with THRU must have size 1"));
	}
	if (literal_value ((yyvsp[-2])) <= literal_value ((yyvsp[0]))) {
		(yyval) = CB_BUILD_PAIR ((yyvsp[-2]), (yyvsp[0]));
	} else {
		(yyval) = CB_BUILD_PAIR ((yyvsp[0]), (yyvsp[-2]));
	}
  }
#line 9684 "parser.c" /* yacc.c:1646  */
    break;

  case 207:
#line 3463 "parser.y" /* yacc.c:1646  */
    {
	cb_tree	l;

	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		/* Returns null on error */
		l = cb_build_locale_name ((yyvsp[-2]), (yyvsp[0]));
		if (l) {
			current_program->locale_list =
				cb_list_add (current_program->locale_list, l);
		}
	}
  }
#line 9706 "parser.c" /* yacc.c:1646  */
    break;

  case 208:
#line 3486 "parser.y" /* yacc.c:1646  */
    {
	unsigned char	*s = CB_LITERAL ((yyvsp[-1]))->data;
	unsigned int	error_ind = 0;
	unsigned int	char_seen = 0;

	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		check_repeated ("CURRENCY", SYN_CLAUSE_1, &check_duplicate);
		if (strcmp("$", (const char *)s) != 0) {
			if ((yyvsp[0]) && CB_LITERAL ((yyvsp[-1]))->size != 1) {
				CB_PENDING_X ((yyvsp[-1]), _("CURRENCY SIGN longer than one character"));
				error_ind = 1;
			}
			while (*s) {
				switch (*s) {
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
				case '+':
				case '-':
				case ',':
				case '.':
				case '*':
					error_ind = 2;
					break;
				case ' ':
					break;
				default:
					char_seen = 1;
					break;
				}
				s++;
			}
			if (!char_seen) {
				error_ind = 2;
			}
		} else {
			if (error_ind > 1) {;
				CB_PENDING_X ((yyvsp[-1]), _("CURRENCY SIGN other than '$'"));
			}
		}
		switch (error_ind) {
		case 0:
		case 1:
			/* FIXME: currency sign/symbol are currently mixed in cobc and libcob */
			/* current_program->currency_sign = CB_LITERAL ($4); */
			break;
		default:
			cb_error_x ((yyvsp[-1]), _("invalid CURRENCY SIGN '%s'"), (char*)CB_LITERAL ((yyvsp[-1]))->data);
			break;
		}
		if ((yyvsp[0])) {
			set_currency_picture_symbol ((yyvsp[0]));
		} else {
			set_currency_picture_symbol ((yyvsp[-1]));
		}
	}
  }
#line 9780 "parser.c" /* yacc.c:1646  */
    break;

  case 209:
#line 3560 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 9788 "parser.c" /* yacc.c:1646  */
    break;

  case 210:
#line 3564 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 9796 "parser.c" /* yacc.c:1646  */
    break;

  case 211:
#line 3573 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		check_repeated ("DECIMAL-POINT", SYN_CLAUSE_2, &check_duplicate);
		current_program->decimal_point = ',';
		current_program->numeric_separator = '.';
	}
  }
#line 9813 "parser.c" /* yacc.c:1646  */
    break;

  case 212:
#line 3592 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		current_program->flag_trailing_separate = 1;
	}
  }
#line 9828 "parser.c" /* yacc.c:1646  */
    break;

  case 213:
#line 3608 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		check_repeated ("CURSOR", SYN_CLAUSE_3, &check_duplicate);
		current_program->cursor_pos = (yyvsp[0]);
	}
  }
#line 9844 "parser.c" /* yacc.c:1646  */
    break;

  case 214:
#line 3626 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		check_repeated ("CRT STATUS", SYN_CLAUSE_4, &check_duplicate);
		current_program->crt_status = (yyvsp[0]);
	}
  }
#line 9860 "parser.c" /* yacc.c:1646  */
    break;

  case 215:
#line 3644 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		check_repeated ("SCREEN CONTROL", SYN_CLAUSE_5, &check_duplicate);
		CB_PENDING ("SCREEN CONTROL");
	}
  }
#line 9876 "parser.c" /* yacc.c:1646  */
    break;

  case 216:
#line 3661 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		check_repeated ("EVENT STATUS", SYN_CLAUSE_6, &check_duplicate);
		CB_PENDING ("EVENT STATUS");
	}
  }
#line 9892 "parser.c" /* yacc.c:1646  */
    break;

  case 217:
#line 3682 "parser.y" /* yacc.c:1646  */
    {
	cb_validate_program_environment (current_program);
  }
#line 9900 "parser.c" /* yacc.c:1646  */
    break;

  case 219:
#line 3689 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_INPUT_OUTPUT_SECTION;
  }
#line 9909 "parser.c" /* yacc.c:1646  */
    break;

  case 221:
#line 3697 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_INPUT_OUTPUT_SECTION, 0, 0);
	header_check |= COBC_HD_FILE_CONTROL;
  }
#line 9919 "parser.c" /* yacc.c:1646  */
    break;

  case 223:
#line 3706 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_INPUT_OUTPUT_SECTION, 0, 0);
	header_check |= COBC_HD_I_O_CONTROL;
  }
#line 9929 "parser.c" /* yacc.c:1646  */
    break;

  case 226:
#line 3721 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_INPUT_OUTPUT_SECTION,
			       COBC_HD_FILE_CONTROL, 0);
	check_duplicate = 0;
	if (CB_VALID_TREE ((yyvsp[0]))) {
		/* Build new file */
		current_file = build_file ((yyvsp[0]));
		current_file->optional = CB_INTEGER ((yyvsp[-1]))->val;

		/* Add file to current program list */
		CB_ADD_TO_CHAIN (CB_TREE (current_file),
				 current_program->file_list);
	} else if (current_program->file_list) {
		current_program->file_list
			= CB_CHAIN (current_program->file_list);
	}
  }
#line 9952 "parser.c" /* yacc.c:1646  */
    break;

  case 227:
#line 3740 "parser.y" /* yacc.c:1646  */
    {
	if (CB_VALID_TREE ((yyvsp[-2]))) {
		validate_file (current_file, (yyvsp[-2]));
	}
  }
#line 9962 "parser.c" /* yacc.c:1646  */
    break;

  case 229:
#line 3750 "parser.y" /* yacc.c:1646  */
    {
	yyerrok;
  }
#line 9970 "parser.c" /* yacc.c:1646  */
    break;

  case 245:
#line 3780 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("ASSIGN", SYN_CLAUSE_1, &check_duplicate);
	cobc_cs_check = 0;
	current_file->assign = cb_build_assignment_name (current_file, (yyvsp[0]));
  }
#line 9980 "parser.c" /* yacc.c:1646  */
    break;

  case 246:
#line 3786 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("ASSIGN", SYN_CLAUSE_1, &check_duplicate);
	cobc_cs_check = 0;
	if ((yyvsp[0])) {
		current_file->assign = cb_build_assignment_name (current_file, (yyvsp[0]));
	} else {
		current_file->flag_fileid = 1;
	}
  }
#line 9994 "parser.c" /* yacc.c:1646  */
    break;

  case 247:
#line 3796 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("ASSIGN", SYN_CLAUSE_1, &check_duplicate);
	cobc_cs_check = 0;
	current_file->organization = COB_ORG_LINE_SEQUENTIAL;
	if ((yyvsp[0])) {
		current_file->assign = cb_build_assignment_name (current_file, (yyvsp[0]));
	} else {
		current_file->flag_fileid = 1;
	}
  }
#line 10009 "parser.c" /* yacc.c:1646  */
    break;

  case 248:
#line 3807 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("ASSIGN", SYN_CLAUSE_1, &check_duplicate);
	cobc_cs_check = 0;
	if ((yyvsp[0])) {
		current_file->assign = cb_build_assignment_name (current_file, (yyvsp[0]));
	} else {
		current_file->flag_ext_assign = 0;
		current_file->assign =
			cb_build_alphanumeric_literal ("stdout", (size_t)6);
		current_file->special = COB_SELECT_STDOUT;
	}
  }
#line 10026 "parser.c" /* yacc.c:1646  */
    break;

  case 249:
#line 3820 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("ASSIGN", SYN_CLAUSE_1, &check_duplicate);
	cobc_cs_check = 0;
	if ((yyvsp[0])) {
		current_file->assign = cb_build_assignment_name (current_file, (yyvsp[0]));
	} else {
		current_file->flag_ext_assign = 0;
		current_file->assign =
			cb_build_alphanumeric_literal ("stdin", (size_t)5);
		current_file->special = COB_SELECT_STDIN;
	}
  }
#line 10043 "parser.c" /* yacc.c:1646  */
    break;

  case 250:
#line 3833 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("ASSIGN", SYN_CLAUSE_1, &check_duplicate);
	cobc_cs_check = 0;
	current_file->organization = COB_ORG_LINE_SEQUENTIAL;
	if ((yyvsp[0])) {
		current_file->assign = cb_build_assignment_name (current_file, (yyvsp[0]));
	} else {
		/* RM/COBOL always expects an assignment name here - we ignore this
		   for PRINTER + PRINTER-1 as ACUCOBOL allows this for using as alias */
		current_file->flag_ext_assign = 0;
		if ((yyvsp[-1]) == cb_int0) {
			current_file->assign =
				cb_build_alphanumeric_literal ("PRINTER", (size_t)7);
		} else if ((yyvsp[-1]) == cb_int1) {
			current_file->assign =
				cb_build_alphanumeric_literal ("PRINTER-1", (size_t)9);
		} else {
			current_file->assign =
				cb_build_alphanumeric_literal ("LPT1", (size_t)4);
		}

	}
  }
#line 10071 "parser.c" /* yacc.c:1646  */
    break;

  case 251:
#line 3865 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int0; }
#line 10077 "parser.c" /* yacc.c:1646  */
    break;

  case 252:
#line 3866 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int1; }
#line 10083 "parser.c" /* yacc.c:1646  */
    break;

  case 253:
#line 3867 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int4; }
#line 10089 "parser.c" /* yacc.c:1646  */
    break;

  case 266:
#line 3890 "parser.y" /* yacc.c:1646  */
    {
	current_file->flag_line_adv = 1;
  }
#line 10097 "parser.c" /* yacc.c:1646  */
    break;

  case 268:
#line 3897 "parser.y" /* yacc.c:1646  */
    {
	current_file->flag_ext_assign = 1;
  }
#line 10105 "parser.c" /* yacc.c:1646  */
    break;

  case 272:
#line 3910 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 10113 "parser.c" /* yacc.c:1646  */
    break;

  case 275:
#line 3922 "parser.y" /* yacc.c:1646  */
    {
	cobc_cs_check = 0;
	check_repeated ("ACCESS", SYN_CLAUSE_2, &check_duplicate);
  }
#line 10122 "parser.c" /* yacc.c:1646  */
    break;

  case 276:
#line 3929 "parser.y" /* yacc.c:1646  */
    { current_file->access_mode = COB_ACCESS_SEQUENTIAL; }
#line 10128 "parser.c" /* yacc.c:1646  */
    break;

  case 277:
#line 3930 "parser.y" /* yacc.c:1646  */
    { current_file->access_mode = COB_ACCESS_DYNAMIC; }
#line 10134 "parser.c" /* yacc.c:1646  */
    break;

  case 278:
#line 3931 "parser.y" /* yacc.c:1646  */
    { current_file->access_mode = COB_ACCESS_RANDOM; }
#line 10140 "parser.c" /* yacc.c:1646  */
    break;

  case 279:
#line 3939 "parser.y" /* yacc.c:1646  */
    {
	struct cb_alt_key *p;
	struct cb_alt_key *l;

	p = cobc_parse_malloc (sizeof (struct cb_alt_key));
	p->key = (yyvsp[-2]);
	p->duplicates = CB_INTEGER ((yyvsp[-1]))->val;
	p->next = NULL;

	/* Add to the end of list */
	if (current_file->alt_key_list == NULL) {
		current_file->alt_key_list = p;
	} else {
		l = current_file->alt_key_list;
		for (; l->next; l = l->next) { ; }
		l->next = p;
	}
  }
#line 10163 "parser.c" /* yacc.c:1646  */
    break;

  case 280:
#line 3960 "parser.y" /* yacc.c:1646  */
    { }
#line 10169 "parser.c" /* yacc.c:1646  */
    break;

  case 281:
#line 3963 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("SUPPRESS WHEN ALL");
  }
#line 10177 "parser.c" /* yacc.c:1646  */
    break;

  case 282:
#line 3968 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("SUPPRESS WHEN SPACE/ZERO");
  }
#line 10185 "parser.c" /* yacc.c:1646  */
    break;

  case 283:
#line 3978 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("COLLATING", SYN_CLAUSE_3, &check_duplicate);
	CB_PENDING ("COLLATING SEQUENCE");
  }
#line 10194 "parser.c" /* yacc.c:1646  */
    break;

  case 284:
#line 3986 "parser.y" /* yacc.c:1646  */
    {
	  if (CB_ALPHABET_NAME_P (cb_ref ((yyvsp[0])))) {
		  (yyval) = (yyvsp[0]);
	  } else {
		  cb_error_x ((yyvsp[0]), _("'%s' is not an alphabet-name"),
			      cb_name ((yyvsp[0])));
		  (yyval) = cb_error_node;
	  }
  }
#line 10208 "parser.c" /* yacc.c:1646  */
    break;

  case 285:
#line 4001 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("STATUS", SYN_CLAUSE_4, &check_duplicate);
	current_file->file_status = (yyvsp[0]);
  }
#line 10217 "parser.c" /* yacc.c:1646  */
    break;

  case 289:
#line 4016 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("LOCK", SYN_CLAUSE_5, &check_duplicate);
  }
#line 10225 "parser.c" /* yacc.c:1646  */
    break;

  case 291:
#line 4024 "parser.y" /* yacc.c:1646  */
    {
	current_file->lock_mode |= COB_LOCK_MANUAL;
	cobc_cs_check = 0;
  }
#line 10234 "parser.c" /* yacc.c:1646  */
    break;

  case 292:
#line 4029 "parser.y" /* yacc.c:1646  */
    {
	current_file->lock_mode |= COB_LOCK_AUTOMATIC;
	cobc_cs_check = 0;
  }
#line 10243 "parser.c" /* yacc.c:1646  */
    break;

  case 293:
#line 4034 "parser.y" /* yacc.c:1646  */
    {
	current_file->lock_mode |= COB_LOCK_EXCLUSIVE;
	cobc_cs_check = 0;
  }
#line 10252 "parser.c" /* yacc.c:1646  */
    break;

  case 296:
#line 4043 "parser.y" /* yacc.c:1646  */
    {
	current_file->lock_mode |= COB_LOCK_MULTIPLE;
  }
#line 10260 "parser.c" /* yacc.c:1646  */
    break;

  case 297:
#line 4047 "parser.y" /* yacc.c:1646  */
    {
	current_file->lock_mode |= COB_LOCK_MULTIPLE;
	CB_PENDING ("WITH ROLLBACK");
  }
#line 10269 "parser.c" /* yacc.c:1646  */
    break;

  case 300:
#line 4063 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("ORGANIZATION", SYN_CLAUSE_6, &check_duplicate);
	current_file->organization = COB_ORG_INDEXED;
  }
#line 10278 "parser.c" /* yacc.c:1646  */
    break;

  case 301:
#line 4068 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("ORGANIZATION", SYN_CLAUSE_6, &check_duplicate);
	current_file->organization = COB_ORG_SEQUENTIAL;
  }
#line 10287 "parser.c" /* yacc.c:1646  */
    break;

  case 302:
#line 4073 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("ORGANIZATION", SYN_CLAUSE_6, &check_duplicate);
	current_file->organization = COB_ORG_RELATIVE;
  }
#line 10296 "parser.c" /* yacc.c:1646  */
    break;

  case 303:
#line 4078 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("ORGANIZATION", SYN_CLAUSE_6, &check_duplicate);
	current_file->organization = COB_ORG_LINE_SEQUENTIAL;
  }
#line 10305 "parser.c" /* yacc.c:1646  */
    break;

  case 304:
#line 4089 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("PADDING", SYN_CLAUSE_7, &check_duplicate);
	cb_verify (cb_padding_character_clause, "PADDING CHARACTER");
  }
#line 10314 "parser.c" /* yacc.c:1646  */
    break;

  case 305:
#line 4100 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("RECORD DELIMITER", SYN_CLAUSE_8, &check_duplicate);
  }
#line 10322 "parser.c" /* yacc.c:1646  */
    break;

  case 306:
#line 4110 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("RECORD KEY", SYN_CLAUSE_9, &check_duplicate);
	current_file->key = (yyvsp[0]);
  }
#line 10331 "parser.c" /* yacc.c:1646  */
    break;

  case 307:
#line 4117 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 10337 "parser.c" /* yacc.c:1646  */
    break;

  case 308:
#line 4118 "parser.y" /* yacc.c:1646  */
    { CB_PENDING ("SPLIT KEYS"); }
#line 10343 "parser.c" /* yacc.c:1646  */
    break;

  case 309:
#line 4119 "parser.y" /* yacc.c:1646  */
    { CB_PENDING ("SPLIT KEYS"); }
#line 10349 "parser.c" /* yacc.c:1646  */
    break;

  case 310:
#line 4126 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("RELATIVE KEY", SYN_CLAUSE_10, &check_duplicate);
	current_file->key = (yyvsp[0]);
  }
#line 10358 "parser.c" /* yacc.c:1646  */
    break;

  case 311:
#line 4137 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("RESERVE", SYN_CLAUSE_11, &check_duplicate);
  }
#line 10366 "parser.c" /* yacc.c:1646  */
    break;

  case 314:
#line 4151 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("SHARING", SYN_CLAUSE_12, &check_duplicate);
	current_file->sharing = (yyvsp[0]);
  }
#line 10375 "parser.c" /* yacc.c:1646  */
    break;

  case 315:
#line 4158 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 10381 "parser.c" /* yacc.c:1646  */
    break;

  case 316:
#line 4159 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (COB_LOCK_OPEN_EXCLUSIVE); }
#line 10387 "parser.c" /* yacc.c:1646  */
    break;

  case 317:
#line 4160 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 10393 "parser.c" /* yacc.c:1646  */
    break;

  case 320:
#line 4169 "parser.y" /* yacc.c:1646  */
    {
	yyerrok;
  }
#line 10401 "parser.c" /* yacc.c:1646  */
    break;

  case 325:
#line 4188 "parser.y" /* yacc.c:1646  */
    {
	cb_tree l;

	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_I_O_CONTROL, 0);
	switch (CB_INTEGER ((yyvsp[-3]))->val) {
	case 0:
		/* SAME AREA */
		break;
	case 1:
		/* SAME RECORD */
		for (l = (yyvsp[0]); l; l = CB_CHAIN (l)) {
			if (CB_VALID_TREE (CB_VALUE (l))) {
				CB_FILE (cb_ref (CB_VALUE (l)))->same_clause = same_area;
			}
		}
		same_area++;
		break;
	case 2:
		/* SAME SORT-MERGE */
		break;
	}
  }
#line 10430 "parser.c" /* yacc.c:1646  */
    break;

  case 326:
#line 4215 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int0; }
#line 10436 "parser.c" /* yacc.c:1646  */
    break;

  case 327:
#line 4216 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int1; }
#line 10442 "parser.c" /* yacc.c:1646  */
    break;

  case 328:
#line 4217 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int2; }
#line 10448 "parser.c" /* yacc.c:1646  */
    break;

  case 329:
#line 4218 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int2; }
#line 10454 "parser.c" /* yacc.c:1646  */
    break;

  case 330:
#line 4225 "parser.y" /* yacc.c:1646  */
    {
	/* Fake for TAPE */
	cobc_cs_check = CB_CS_ASSIGN;
  }
#line 10463 "parser.c" /* yacc.c:1646  */
    break;

  case 331:
#line 4230 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_I_O_CONTROL, 0);
	cb_verify (cb_multiple_file_tape_clause, "MULTIPLE FILE TAPE");
	cobc_cs_check = 0;
  }
#line 10475 "parser.c" /* yacc.c:1646  */
    break;

  case 337:
#line 4259 "parser.y" /* yacc.c:1646  */
    {
	current_storage = CB_STORAGE_WORKING;
  }
#line 10483 "parser.c" /* yacc.c:1646  */
    break;

  case 338:
#line 4268 "parser.y" /* yacc.c:1646  */
    {
	cb_validate_program_data (current_program);
  }
#line 10491 "parser.c" /* yacc.c:1646  */
    break;

  case 340:
#line 4275 "parser.y" /* yacc.c:1646  */
    {
	header_check |= COBC_HD_DATA_DIVISION;
  }
#line 10499 "parser.c" /* yacc.c:1646  */
    break;

  case 342:
#line 4284 "parser.y" /* yacc.c:1646  */
    {
	current_storage = CB_STORAGE_FILE;
	check_headers_present (COBC_HD_DATA_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_FILE_SECTION;
  }
#line 10509 "parser.c" /* yacc.c:1646  */
    break;

  case 345:
#line 4298 "parser.y" /* yacc.c:1646  */
    {
	if (CB_VALID_TREE (current_file)) {
		if (CB_VALID_TREE ((yyvsp[0]))) {
			if (current_file->reports) {
				cb_error (_("RECORD description invalid with REPORT"));
			} else {
				finalize_file (current_file, CB_FIELD ((yyvsp[0])));
			}
		} else if (!current_file->reports) {
			cb_error (_("RECORD description missing or invalid"));
		}
	}
  }
#line 10527 "parser.c" /* yacc.c:1646  */
    break;

  case 346:
#line 4317 "parser.y" /* yacc.c:1646  */
    {
	current_storage = CB_STORAGE_FILE;
	check_headers_present (COBC_HD_DATA_DIVISION,
			       COBC_HD_FILE_SECTION, 0, 0);
	check_duplicate = 0;
	if (CB_INVALID_TREE ((yyvsp[0])) || cb_ref ((yyvsp[0])) == cb_error_node) {
		YYERROR;
	}
	current_file = CB_FILE (cb_ref ((yyvsp[0])));
	if (CB_VALID_TREE (current_file)) {
		if ((yyvsp[-1])) {
			current_file->organization = COB_ORG_SORT;
		}
	}
  }
#line 10547 "parser.c" /* yacc.c:1646  */
    break;

  case 348:
#line 4334 "parser.y" /* yacc.c:1646  */
    {
	yyerrok;
  }
#line 10555 "parser.c" /* yacc.c:1646  */
    break;

  case 349:
#line 4341 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 10563 "parser.c" /* yacc.c:1646  */
    break;

  case 350:
#line 4345 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int1;
  }
#line 10571 "parser.c" /* yacc.c:1646  */
    break;

  case 353:
#line 4356 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("EXTERNAL", SYN_CLAUSE_1, &check_duplicate);
#if	0	/* RXWRXW - Global/External */
	if (current_file->flag_global) {
		cb_error (_("file cannot have both EXTERNAL and GLOBAL clauses"));
	}
#endif
	current_file->flag_external = 1;
  }
#line 10585 "parser.c" /* yacc.c:1646  */
    break;

  case 354:
#line 4366 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("GLOBAL", SYN_CLAUSE_2, &check_duplicate);
#if	0	/* RXWRXW - Global/External */
	if (current_file->flag_external) {
		cb_error (_("file cannot have both EXTERNAL and GLOBAL clauses"));
	}
#endif
	if (current_program->prog_type == CB_FUNCTION_TYPE) {
		cb_error (_("%s is invalid in a user FUNCTION"), "GLOBAL");
	} else {
		current_file->flag_global = 1;
		current_program->flag_file_global = 1;
	}
  }
#line 10604 "parser.c" /* yacc.c:1646  */
    break;

  case 364:
#line 4396 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("BLOCK", SYN_CLAUSE_3, &check_duplicate);
	/* ignore */
  }
#line 10613 "parser.c" /* yacc.c:1646  */
    break;

  case 368:
#line 4409 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("RECORD", SYN_CLAUSE_4, &check_duplicate);
	if (current_file->organization == COB_ORG_LINE_SEQUENTIAL) {
		cb_warning (warningopt, _("RECORD clause ignored for LINE SEQUENTIAL"));
	} else {
		current_file->record_max = cb_get_int ((yyvsp[-1]));
		if (current_file->record_max < 1)  {
			current_file->record_max = 1;
			cb_error (_("RECORD clause invalid"));
		}
		if (current_file->organization == COB_ORG_INDEXED) {
			if (current_file->record_max > MAX_FD_RECORD_IDX)  {
				current_file->record_max = MAX_FD_RECORD_IDX;
				cb_error (_("RECORD size (IDX) exceeds maximum allowed (%d)"),
					  MAX_FD_RECORD_IDX);
			}
		} else if (current_file->record_max > MAX_FD_RECORD)  {
			current_file->record_max = MAX_FD_RECORD;
			cb_error (_("RECORD size exceeds maximum allowed (%d)"),
				  MAX_FD_RECORD);
		}
	}
  }
#line 10641 "parser.c" /* yacc.c:1646  */
    break;

  case 369:
#line 4433 "parser.y" /* yacc.c:1646  */
    {
	int	error_ind = 0;

	check_repeated ("RECORD", SYN_CLAUSE_4, &check_duplicate);
	if (current_file->organization == COB_ORG_LINE_SEQUENTIAL) {
		cb_warning (warningopt, _("RECORD clause ignored for LINE SEQUENTIAL"));
	} else {
		current_file->record_min = cb_get_int ((yyvsp[-3]));
		current_file->record_max = cb_get_int ((yyvsp[-1]));
		if (current_file->record_min < 0)  {
			current_file->record_min = 0;
			error_ind = 1;
		}
		if (current_file->record_max < 1)  {
			current_file->record_max = 1;
			error_ind = 1;
		}
		if (current_file->organization == COB_ORG_INDEXED) {
			if (current_file->record_max > MAX_FD_RECORD_IDX)  {
				current_file->record_max = MAX_FD_RECORD_IDX;
				cb_error (_("RECORD size (IDX) exceeds maximum allowed (%d)"),
					  MAX_FD_RECORD_IDX);
			error_ind = 1;
			}
		} else if (current_file->record_max > MAX_FD_RECORD)  {
			current_file->record_max = MAX_FD_RECORD;
			cb_error (_("RECORD size exceeds maximum allowed (%d)"),
				  MAX_FD_RECORD);
			error_ind = 1;
		}
		if (current_file->record_max <= current_file->record_min)  {
			error_ind = 1;
		}
		if (error_ind) {
			cb_error (_("RECORD clause invalid"));
		}
	}
  }
#line 10684 "parser.c" /* yacc.c:1646  */
    break;

  case 370:
#line 4473 "parser.y" /* yacc.c:1646  */
    {
	int	error_ind = 0;

	check_repeated ("RECORD", SYN_CLAUSE_4, &check_duplicate);
	current_file->record_min = (yyvsp[-3]) ? cb_get_int ((yyvsp[-3])) : 0;
	current_file->record_max = (yyvsp[-2]) ? cb_get_int ((yyvsp[-2])) : 0;
	if ((yyvsp[-3]) && current_file->record_min < 0)  {
		current_file->record_min = 0;
		error_ind = 1;
	}
	if ((yyvsp[-2]) && current_file->record_max < 1)  {
		current_file->record_max = 1;
		error_ind = 1;
	}
	if ((yyvsp[-2])) {
		if (current_file->organization == COB_ORG_INDEXED) {
			if (current_file->record_max > MAX_FD_RECORD_IDX)  {
				current_file->record_max = MAX_FD_RECORD_IDX;
				cb_error (_("RECORD size (IDX) exceeds maximum allowed (%d)"),
					  MAX_FD_RECORD_IDX);
				error_ind = 1;
			}
		} else if (current_file->record_max > MAX_FD_RECORD)  {
			current_file->record_max = MAX_FD_RECORD;
			cb_error (_("RECORD size exceeds maximum allowed (%d)"),
				  MAX_FD_RECORD);
			error_ind = 1;
		}
	}
	if (((yyvsp[-3]) || (yyvsp[-2])) && current_file->record_max <= current_file->record_min)  {
		error_ind = 1;
	}
	if (error_ind) {
		cb_error (_("RECORD clause invalid"));
	}
  }
#line 10725 "parser.c" /* yacc.c:1646  */
    break;

  case 372:
#line 4513 "parser.y" /* yacc.c:1646  */
    {
	current_file->record_depending = (yyvsp[0]);
  }
#line 10733 "parser.c" /* yacc.c:1646  */
    break;

  case 373:
#line 4519 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 10739 "parser.c" /* yacc.c:1646  */
    break;

  case 374:
#line 4520 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 10745 "parser.c" /* yacc.c:1646  */
    break;

  case 375:
#line 4524 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 10751 "parser.c" /* yacc.c:1646  */
    break;

  case 376:
#line 4525 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 10757 "parser.c" /* yacc.c:1646  */
    break;

  case 377:
#line 4533 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("LABEL", SYN_CLAUSE_5, &check_duplicate);
	cb_verify (cb_label_records_clause, "LABEL RECORDS");
  }
#line 10766 "parser.c" /* yacc.c:1646  */
    break;

  case 378:
#line 4544 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("VALUE OF", SYN_CLAUSE_6, &check_duplicate);
	cb_verify (cb_value_of_clause, "VALUE OF");
  }
#line 10775 "parser.c" /* yacc.c:1646  */
    break;

  case 379:
#line 4549 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("VALUE OF", SYN_CLAUSE_6, &check_duplicate);
	cb_verify (cb_value_of_clause, "VALUE OF");
	if (!current_file->assign) {
		current_file->assign = cb_build_assignment_name (current_file, (yyvsp[0]));
	}
  }
#line 10787 "parser.c" /* yacc.c:1646  */
    break;

  case 384:
#line 4572 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("DATA", SYN_CLAUSE_7, &check_duplicate);
	cb_verify (cb_data_records_clause, "DATA RECORDS");
  }
#line 10796 "parser.c" /* yacc.c:1646  */
    break;

  case 385:
#line 4584 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("LINAGE", SYN_CLAUSE_8, &check_duplicate);
	if (current_file->organization != COB_ORG_LINE_SEQUENTIAL &&
	    current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("LINAGE clause with wrong file type"));
	} else {
		current_file->linage = (yyvsp[-2]);
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
		if (current_linage == 0) {
			linage_file = current_file;
		}
		current_linage++;
	}
  }
#line 10815 "parser.c" /* yacc.c:1646  */
    break;

  case 391:
#line 4612 "parser.y" /* yacc.c:1646  */
    {
	current_file->latfoot = (yyvsp[0]);
  }
#line 10823 "parser.c" /* yacc.c:1646  */
    break;

  case 392:
#line 4619 "parser.y" /* yacc.c:1646  */
    {
	current_file->lattop = (yyvsp[0]);
  }
#line 10831 "parser.c" /* yacc.c:1646  */
    break;

  case 393:
#line 4626 "parser.y" /* yacc.c:1646  */
    {
	current_file->latbot = (yyvsp[0]);
  }
#line 10839 "parser.c" /* yacc.c:1646  */
    break;

  case 394:
#line 4635 "parser.y" /* yacc.c:1646  */
    {
	cobc_cs_check = 0;
	check_repeated ("RECORDING", SYN_CLAUSE_9, &check_duplicate);
	/* ignore */
  }
#line 10849 "parser.c" /* yacc.c:1646  */
    break;

  case 399:
#line 4648 "parser.y" /* yacc.c:1646  */
    {
	if (current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("RECORDING MODE U or S can only be used with RECORD SEQUENTIAL files"));
	}
  }
#line 10859 "parser.c" /* yacc.c:1646  */
    break;

  case 402:
#line 4664 "parser.y" /* yacc.c:1646  */
    {
	struct cb_alphabet_name	*al;

	check_repeated ("CODE SET", SYN_CLAUSE_10, &check_duplicate);

	if (CB_VALID_TREE ((yyvsp[-1]))) {
		al = CB_ALPHABET_NAME (cb_ref ((yyvsp[-1])));
		switch (al->alphabet_type) {
#ifdef	COB_EBCDIC_MACHINE
		case CB_ALPHABET_ASCII:
#else
		case CB_ALPHABET_EBCDIC:
#endif
		case CB_ALPHABET_CUSTOM:
			current_file->code_set = al;
			break;
		default:
			if (CB_VALID_TREE ((yyvsp[-1]))) {
				cb_warning_x (warningopt, (yyvsp[-1]), _("ignoring CODE-SET '%s'"),
						  cb_name ((yyvsp[-1])));
			}
			break;
		}
	}

	if (current_file->organization != COB_ORG_LINE_SEQUENTIAL &&
	    current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("CODE-SET clause invalid for file type"));
	}

	if (warningopt) {
		CB_PENDING ("CODE-SET");
	}
  }
#line 10898 "parser.c" /* yacc.c:1646  */
    break;

  case 404:
#line 4702 "parser.y" /* yacc.c:1646  */
    {
	  if (warningopt) {
		  CB_PENDING ("FOR sub-records");
	  }

	  current_file->code_set_items = CB_LIST ((yyvsp[0]));
  }
#line 10910 "parser.c" /* yacc.c:1646  */
    break;

  case 405:
#line 4715 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("REPORT", SYN_CLAUSE_11, &check_duplicate);
	CB_PENDING("REPORT WRITER");
	if (current_file->organization != COB_ORG_LINE_SEQUENTIAL &&
	    current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("REPORT clause with wrong file type"));
	} else {
		current_file->reports = (yyvsp[0]);
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
	}
  }
#line 10926 "parser.c" /* yacc.c:1646  */
    break;

  case 408:
#line 4735 "parser.y" /* yacc.c:1646  */
    {
	current_report = build_report ((yyvsp[0]));
	current_report->file = current_file;
	CB_ADD_TO_CHAIN (CB_TREE (current_report), current_program->report_list);
	if (report_count == 0) {
		report_instance = current_report;
	}
	report_count++;
  }
#line 10940 "parser.c" /* yacc.c:1646  */
    break;

  case 409:
#line 4745 "parser.y" /* yacc.c:1646  */
    {
	current_report = build_report ((yyvsp[0]));
	CB_ADD_TO_CHAIN (CB_TREE (current_report), current_program->report_list);
	if (report_count == 0) {
		report_instance = current_report;
	}
	report_count++;
  }
#line 10953 "parser.c" /* yacc.c:1646  */
    break;

  case 411:
#line 4759 "parser.y" /* yacc.c:1646  */
    {
	current_storage = CB_STORAGE_COMMUNICATION;
	check_headers_present (COBC_HD_DATA_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_COMMUNICATION_SECTION;
	/* add a compiler configuration if either */
	if (cb_std_define > CB_STD_85) {
		cb_verify (CB_UNCONFORMABLE, _ ("COMMUNICATION SECTION"));
	} else if (cb_verify (CB_OBSOLETE, _("COMMUNICATION SECTION"))) {
		CB_PENDING ("COMMUNICATION SECTION");
	}
  }
#line 10969 "parser.c" /* yacc.c:1646  */
    break;

  case 415:
#line 4780 "parser.y" /* yacc.c:1646  */
    {
	if (CB_VALID_TREE (current_cd)) {
		if (CB_VALID_TREE ((yyvsp[0]))) {
			cb_finalize_cd (current_cd, CB_FIELD ((yyvsp[0])));
		} else if (!current_cd->record) {
			cb_error (_("CD record missing"));
		}
	}
  }
#line 10983 "parser.c" /* yacc.c:1646  */
    break;

  case 416:
#line 4795 "parser.y" /* yacc.c:1646  */
    {
	/* CD internally defines a new file */
	if (CB_VALID_TREE ((yyvsp[0]))) {
		current_cd = cb_build_cd ((yyvsp[0]));

		CB_ADD_TO_CHAIN (CB_TREE (current_cd),
				 current_program->cd_list);
	} else {
		current_cd = NULL;
		/* TO-DO: Is this necessary? */
		if (current_program->cd_list) {
			current_program->cd_list
				= CB_CHAIN (current_program->cd_list);
		}
	}
	check_duplicate = 0;
  }
#line 11005 "parser.c" /* yacc.c:1646  */
    break;

  case 464:
#line 4903 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_DATA_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_WORKING_STORAGE_SECTION;
	current_storage = CB_STORAGE_WORKING;
  }
#line 11015 "parser.c" /* yacc.c:1646  */
    break;

  case 465:
#line 4909 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0])) {
		CB_FIELD_ADD (current_program->working_storage, CB_FIELD ((yyvsp[0])));
	}
  }
#line 11025 "parser.c" /* yacc.c:1646  */
    break;

  case 466:
#line 4918 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 11033 "parser.c" /* yacc.c:1646  */
    break;

  case 467:
#line 4922 "parser.y" /* yacc.c:1646  */
    {
	current_field = NULL;
	description_field = NULL;
	cb_clear_real_field ();
  }
#line 11043 "parser.c" /* yacc.c:1646  */
    break;

  case 468:
#line 4928 "parser.y" /* yacc.c:1646  */
    {
	struct cb_field *p;

	for (p = description_field; p; p = p->sister) {
		cb_validate_field (p);
	}
	(yyval) = CB_TREE (description_field);
  }
#line 11056 "parser.c" /* yacc.c:1646  */
    break;

  case 474:
#line 4948 "parser.y" /* yacc.c:1646  */
    {
	if (set_current_field ((yyvsp[-1]), (yyvsp[0]))) {
		YYERROR;
	}
  }
#line 11066 "parser.c" /* yacc.c:1646  */
    break;

  case 475:
#line 4954 "parser.y" /* yacc.c:1646  */
    {
	if (!qualifier) {
		current_field->flag_filler = 1;
	}
	if (!description_field) {
		description_field = current_field;
	}
  }
#line 11079 "parser.c" /* yacc.c:1646  */
    break;

  case 476:
#line 4963 "parser.y" /* yacc.c:1646  */
    {
	/* Free tree associated with level number */
	cobc_parse_free ((yyvsp[-2]));
	yyerrok;
	cb_unput_dot ();
	check_pic_duplicate = 0;
	check_duplicate = 0;
	current_field = cb_get_real_field ();
  }
#line 11093 "parser.c" /* yacc.c:1646  */
    break;

  case 477:
#line 4976 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 11101 "parser.c" /* yacc.c:1646  */
    break;

  case 480:
#line 4988 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_filler ();
	qualifier = NULL;
	keys_list = NULL;
	non_const_word = 0;
  }
#line 11112 "parser.c" /* yacc.c:1646  */
    break;

  case 482:
#line 4999 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
	qualifier = (yyvsp[0]);
	keys_list = NULL;
	non_const_word = 0;
  }
#line 11123 "parser.c" /* yacc.c:1646  */
    break;

  case 483:
#line 5009 "parser.y" /* yacc.c:1646  */
    {
	(yyval)= NULL;
  }
#line 11131 "parser.c" /* yacc.c:1646  */
    break;

  case 484:
#line 5013 "parser.y" /* yacc.c:1646  */
    {
	if (current_program->prog_type == CB_FUNCTION_TYPE) {
		cb_error (_("%s is invalid in a user FUNCTION"), "GLOBAL");
		(yyval)= NULL;
	} else {
		(yyval) = cb_null;
	}
  }
#line 11144 "parser.c" /* yacc.c:1646  */
    break;

  case 485:
#line 5024 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 11150 "parser.c" /* yacc.c:1646  */
    break;

  case 486:
#line 5025 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_build_const_length ((yyvsp[0])); }
#line 11156 "parser.c" /* yacc.c:1646  */
    break;

  case 487:
#line 5026 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_build_const_length ((yyvsp[0])); }
#line 11162 "parser.c" /* yacc.c:1646  */
    break;

  case 488:
#line 5028 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_build_const_length ((yyvsp[0])); }
#line 11168 "parser.c" /* yacc.c:1646  */
    break;

  case 489:
#line 5033 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 11176 "parser.c" /* yacc.c:1646  */
    break;

  case 490:
#line 5037 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int1;
  }
#line 11184 "parser.c" /* yacc.c:1646  */
    break;

  case 491:
#line 5041 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int2;
  }
#line 11192 "parser.c" /* yacc.c:1646  */
    break;

  case 492:
#line 5045 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int4;
  }
#line 11200 "parser.c" /* yacc.c:1646  */
    break;

  case 493:
#line 5049 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int (8);
  }
#line 11208 "parser.c" /* yacc.c:1646  */
    break;

  case 494:
#line 5053 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int ((int)sizeof(long));
  }
#line 11216 "parser.c" /* yacc.c:1646  */
    break;

  case 495:
#line 5057 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int ((int)sizeof(void *));
  }
#line 11224 "parser.c" /* yacc.c:1646  */
    break;

  case 496:
#line 5061 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int ((int)sizeof(float));
  }
#line 11232 "parser.c" /* yacc.c:1646  */
    break;

  case 497:
#line 5065 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int ((int)sizeof(double));
  }
#line 11240 "parser.c" /* yacc.c:1646  */
    break;

  case 498:
#line 5069 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int (4);
  }
#line 11248 "parser.c" /* yacc.c:1646  */
    break;

  case 499:
#line 5073 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int (8);
  }
#line 11256 "parser.c" /* yacc.c:1646  */
    break;

  case 500:
#line 5077 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int (16);
  }
#line 11264 "parser.c" /* yacc.c:1646  */
    break;

  case 501:
#line 5081 "parser.y" /* yacc.c:1646  */
    {
	yyerrok;
	cb_unput_dot ();
	check_pic_duplicate = 0;
	check_duplicate = 0;
	current_field = cb_get_real_field ();
  }
#line 11276 "parser.c" /* yacc.c:1646  */
    break;

  case 511:
#line 5113 "parser.y" /* yacc.c:1646  */
    {
	if (set_current_field ((yyvsp[-4]), (yyvsp[-3]))) {
		YYERROR;
	}

	if (cb_ref ((yyvsp[-1])) != cb_error_node) {
		error_if_invalid_level_for_renames ((yyvsp[-1]));
		current_field->redefines = CB_FIELD (cb_ref ((yyvsp[-1])));
	}

	if ((yyvsp[0])) {
		error_if_invalid_level_for_renames ((yyvsp[0]));
		current_field->rename_thru = CB_FIELD (cb_ref ((yyvsp[0])));
	} else {
		/* If there is no THRU clause, RENAMES acts like REDEFINES. */
		current_field->pic = current_field->redefines->pic;
	}

	cb_validate_renames_item (current_field);
  }
#line 11301 "parser.c" /* yacc.c:1646  */
    break;

  case 512:
#line 5137 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 11309 "parser.c" /* yacc.c:1646  */
    break;

  case 513:
#line 5141 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]) == cb_error_node ? NULL : (yyvsp[0]);
  }
#line 11317 "parser.c" /* yacc.c:1646  */
    break;

  case 514:
#line 5148 "parser.y" /* yacc.c:1646  */
    {
	if (set_current_field ((yyvsp[-1]), (yyvsp[0]))) {
		YYERROR;
	}
  }
#line 11327 "parser.c" /* yacc.c:1646  */
    break;

  case 515:
#line 5154 "parser.y" /* yacc.c:1646  */
    {
	cb_validate_88_item (current_field);
  }
#line 11335 "parser.c" /* yacc.c:1646  */
    break;

  case 516:
#line 5161 "parser.y" /* yacc.c:1646  */
    {
	cb_tree x;
	int	level;

	cobc_cs_check = 0;
	level = cb_get_level ((yyvsp[-4]));
	/* Free tree associated with level number */
	cobc_parse_free ((yyvsp[-4]));
	if (level != 1) {
		cb_error (_("CONSTANT item not at 01 level"));
	} else if ((yyvsp[0])) {
		if (cb_verify(cb_constant_01, "01 CONSTANT")) {
			x = cb_build_constant ((yyvsp[-3]), (yyvsp[0]));
			CB_FIELD (x)->flag_item_78 = 1;
			CB_FIELD (x)->flag_constant = 1;
			CB_FIELD (x)->level = 1;
			CB_FIELD (x)->values = (yyvsp[0]);
			cb_needs_01 = 1;
			if ((yyvsp[-1])) {
				CB_FIELD (x)->flag_is_global = 1;
			}
			/* Ignore return value */
			(void)cb_validate_78_item (CB_FIELD (x), 0);
		}
	}
  }
#line 11366 "parser.c" /* yacc.c:1646  */
    break;

  case 517:
#line 5188 "parser.y" /* yacc.c:1646  */
    {
	if (set_current_field ((yyvsp[-1]), (yyvsp[0]))) {
		YYERROR;
	}
  }
#line 11376 "parser.c" /* yacc.c:1646  */
    break;

  case 518:
#line 5195 "parser.y" /* yacc.c:1646  */
    {
	/* Reset to last non-78 item */
	current_field = cb_validate_78_item (current_field, 0);
  }
#line 11385 "parser.c" /* yacc.c:1646  */
    break;

  case 519:
#line 5203 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 11393 "parser.c" /* yacc.c:1646  */
    break;

  case 520:
#line 5207 "parser.y" /* yacc.c:1646  */
    { 
	(yyval) = CB_LIST_INIT(cb_build_const_from ((yyvsp[0])));
  }
#line 11401 "parser.c" /* yacc.c:1646  */
    break;

  case 521:
#line 5214 "parser.y" /* yacc.c:1646  */
    {
	current_field->values = (yyvsp[0]);
  }
#line 11409 "parser.c" /* yacc.c:1646  */
    break;

  case 522:
#line 5218 "parser.y" /* yacc.c:1646  */
    {
	current_field->values = CB_LIST_INIT (cb_build_const_start (current_field, (yyvsp[0])));
  }
#line 11417 "parser.c" /* yacc.c:1646  */
    break;

  case 523:
#line 5222 "parser.y" /* yacc.c:1646  */
    {
	current_field->values = CB_LIST_INIT (cb_build_const_next (current_field));
  }
#line 11425 "parser.c" /* yacc.c:1646  */
    break;

  case 524:
#line 5228 "parser.y" /* yacc.c:1646  */
    { (yyval) = CB_LIST_INIT ((yyvsp[0])); }
#line 11431 "parser.c" /* yacc.c:1646  */
    break;

  case 525:
#line 5229 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_list_add ((yyvsp[-1]), (yyvsp[0])); }
#line 11437 "parser.c" /* yacc.c:1646  */
    break;

  case 526:
#line 5233 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 11443 "parser.c" /* yacc.c:1646  */
    break;

  case 527:
#line 5234 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_build_alphanumeric_literal ("(", 1); }
#line 11449 "parser.c" /* yacc.c:1646  */
    break;

  case 528:
#line 5235 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_build_alphanumeric_literal (")", 1); }
#line 11455 "parser.c" /* yacc.c:1646  */
    break;

  case 529:
#line 5236 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_build_alphanumeric_literal ("+", 1); }
#line 11461 "parser.c" /* yacc.c:1646  */
    break;

  case 530:
#line 5237 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_build_alphanumeric_literal ("-", 1); }
#line 11467 "parser.c" /* yacc.c:1646  */
    break;

  case 531:
#line 5238 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_build_alphanumeric_literal ("*", 1); }
#line 11473 "parser.c" /* yacc.c:1646  */
    break;

  case 532:
#line 5239 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_build_alphanumeric_literal ("/", 1); }
#line 11479 "parser.c" /* yacc.c:1646  */
    break;

  case 533:
#line 5240 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_build_alphanumeric_literal ("&", 1); }
#line 11485 "parser.c" /* yacc.c:1646  */
    break;

  case 534:
#line 5241 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_build_alphanumeric_literal ("|", 1); }
#line 11491 "parser.c" /* yacc.c:1646  */
    break;

  case 535:
#line 5242 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_build_alphanumeric_literal ("^", 1); }
#line 11497 "parser.c" /* yacc.c:1646  */
    break;

  case 536:
#line 5247 "parser.y" /* yacc.c:1646  */
    {
	/* Required to check redefines */
	(yyval) = NULL;
  }
#line 11506 "parser.c" /* yacc.c:1646  */
    break;

  case 537:
#line 5253 "parser.y" /* yacc.c:1646  */
    {
	/* Required to check redefines */
	(yyval) = cb_true;
  }
#line 11515 "parser.c" /* yacc.c:1646  */
    break;

  case 551:
#line 5280 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("REDEFINES", SYN_CLAUSE_1, &check_pic_duplicate);
	if ((yyvsp[-2]) != NULL) {
		if (cb_relaxed_syntax_checks) {
			cb_warning_x (COBC_WARN_FILLER, (yyvsp[0]), _("REDEFINES clause should follow entry-name"));
		} else {
			cb_error_x ((yyvsp[0]), _("REDEFINES clause must follow entry-name"));
		}
	}

	current_field->redefines = cb_resolve_redefines (current_field, (yyvsp[0]));
	if (current_field->redefines == NULL) {
		current_field->flag_is_verified = 1;
		current_field->flag_invalid = 1;
		YYERROR;
	}
  }
#line 11537 "parser.c" /* yacc.c:1646  */
    break;

  case 552:
#line 5304 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("EXTERNAL", SYN_CLAUSE_2, &check_pic_duplicate);
	if (current_storage != CB_STORAGE_WORKING) {
		cb_error (_("%s not allowed here"), "EXTERNAL");
	} else if (current_field->level != 1 && current_field->level != 77) {
		cb_error (_("%s only allowed at 01/77 level"), "EXTERNAL");
	} else if (!qualifier) {
		cb_error (_("%s requires a data name"), "EXTERNAL");
#if	0	/* RXWRXW - Global/External */
	} else if (current_field->flag_is_global) {
		cb_error (_("%s and %s are mutually exclusive"), "GLOBAL", "EXTERNAL");
#endif
	} else if (current_field->flag_item_based) {
		cb_error (_("%s and %s are mutually exclusive"), "BASED", "EXTERNAL");
	} else if (current_field->redefines) {
		cb_error (_("%s and %s are mutually exclusive"), "EXTERNAL", "REDEFINES");
	} else if (current_field->flag_occurs) {
		cb_error (_("%s and %s are mutually exclusive"), "EXTERNAL", "OCCURS");
	} else {
		current_field->flag_external = 1;
		current_program->flag_has_external = 1;
	}
  }
#line 11565 "parser.c" /* yacc.c:1646  */
    break;

  case 553:
#line 5331 "parser.y" /* yacc.c:1646  */
    {
	current_field->ename = cb_to_cname (current_field->name);
  }
#line 11573 "parser.c" /* yacc.c:1646  */
    break;

  case 554:
#line 5335 "parser.y" /* yacc.c:1646  */
    {
	current_field->ename = cb_to_cname ((const char *)CB_LITERAL ((yyvsp[0]))->data);
  }
#line 11581 "parser.c" /* yacc.c:1646  */
    break;

  case 557:
#line 5348 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("GLOBAL", SYN_CLAUSE_3, &check_pic_duplicate);
	if (current_field->level != 1 && current_field->level != 77) {
		cb_error (_("%s only allowed at 01/77 level"), "GLOBAL");
	} else if (!qualifier) {
		cb_error (_("%s requires a data name"), "GLOBAL");
#if	0	/* RXWRXW - Global/External */
	} else if (current_field->flag_external) {
		cb_error (_("%s and %s are mutually exclusive"), "GLOBAL", "EXTERNAL");
#endif
	} else if (current_program->prog_type == CB_FUNCTION_TYPE) {
		cb_error (_("%s is invalid in a user FUNCTION"), "GLOBAL");
	} else if (current_storage == CB_STORAGE_LOCAL) {
		cb_error (_("%s not allowed here"), "GLOBAL");
	} else {
		current_field->flag_is_global = 1;
	}
  }
#line 11604 "parser.c" /* yacc.c:1646  */
    break;

  case 558:
#line 5373 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("PICTURE", SYN_CLAUSE_4, &check_pic_duplicate);
	current_field->pic = CB_PICTURE ((yyvsp[0]));
  }
#line 11613 "parser.c" /* yacc.c:1646  */
    break;

  case 561:
#line 5389 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_BINARY);
  }
#line 11621 "parser.c" /* yacc.c:1646  */
    break;

  case 562:
#line 5393 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_BINARY);
  }
#line 11629 "parser.c" /* yacc.c:1646  */
    break;

  case 563:
#line 5397 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_FLOAT);
  }
#line 11637 "parser.c" /* yacc.c:1646  */
    break;

  case 564:
#line 5401 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_DOUBLE);
  }
#line 11645 "parser.c" /* yacc.c:1646  */
    break;

  case 565:
#line 5405 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_PACKED);
  }
#line 11653 "parser.c" /* yacc.c:1646  */
    break;

  case 566:
#line 5409 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_BINARY);
  }
#line 11661 "parser.c" /* yacc.c:1646  */
    break;

  case 567:
#line 5413 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_COMP_5);
  }
#line 11669 "parser.c" /* yacc.c:1646  */
    break;

  case 568:
#line 5417 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_COMP_6);
  }
#line 11677 "parser.c" /* yacc.c:1646  */
    break;

  case 569:
#line 5421 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_COMP_X);
  }
#line 11685 "parser.c" /* yacc.c:1646  */
    break;

  case 570:
#line 5425 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_DISPLAY);
  }
#line 11693 "parser.c" /* yacc.c:1646  */
    break;

  case 571:
#line 5429 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_INDEX);
  }
#line 11701 "parser.c" /* yacc.c:1646  */
    break;

  case 572:
#line 5433 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_PACKED);
  }
#line 11709 "parser.c" /* yacc.c:1646  */
    break;

  case 573:
#line 5437 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_POINTER);
	current_field->flag_is_pointer = 1;
  }
#line 11718 "parser.c" /* yacc.c:1646  */
    break;

  case 574:
#line 5442 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_PROGRAM_POINTER);
	current_field->flag_is_pointer = 1;
  }
#line 11727 "parser.c" /* yacc.c:1646  */
    break;

  case 575:
#line 5447 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_HNDL);
  }
#line 11735 "parser.c" /* yacc.c:1646  */
    break;

  case 576:
#line 5451 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_HNDL_WINDOW);
  }
#line 11743 "parser.c" /* yacc.c:1646  */
    break;

  case 577:
#line 5455 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_HNDL_SUBWINDOW);
  }
#line 11751 "parser.c" /* yacc.c:1646  */
    break;

  case 578:
#line 5459 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_HNDL_FONT);
	CB_PENDING ("HANDLE OF FONT");
  }
#line 11760 "parser.c" /* yacc.c:1646  */
    break;

  case 579:
#line 5464 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_HNDL_THREAD);
  }
#line 11768 "parser.c" /* yacc.c:1646  */
    break;

  case 580:
#line 5468 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_HNDL_MENU);
	CB_PENDING ("HANDLE OF MENU");
  }
#line 11777 "parser.c" /* yacc.c:1646  */
    break;

  case 581:
#line 5473 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_HNDL_VARIANT);
  }
#line 11785 "parser.c" /* yacc.c:1646  */
    break;

  case 582:
#line 5477 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_HNDL_LM);
	CB_PENDING ("HANDLE OF LAYOUT-MANAGER");
  }
#line 11794 "parser.c" /* yacc.c:1646  */
    break;

  case 583:
#line 5482 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_SIGNED_SHORT);
  }
#line 11802 "parser.c" /* yacc.c:1646  */
    break;

  case 584:
#line 5486 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_SIGNED_INT);
  }
#line 11810 "parser.c" /* yacc.c:1646  */
    break;

  case 585:
#line 5490 "parser.y" /* yacc.c:1646  */
    {
#ifdef COB_32_BIT_LONG
	check_and_set_usage (CB_USAGE_SIGNED_INT);
#else
	check_and_set_usage (CB_USAGE_SIGNED_LONG);
#endif
  }
#line 11822 "parser.c" /* yacc.c:1646  */
    break;

  case 586:
#line 5498 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_UNSIGNED_SHORT);
  }
#line 11830 "parser.c" /* yacc.c:1646  */
    break;

  case 587:
#line 5502 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_UNSIGNED_INT);
  }
#line 11838 "parser.c" /* yacc.c:1646  */
    break;

  case 588:
#line 5506 "parser.y" /* yacc.c:1646  */
    {
#ifdef COB_32_BIT_LONG
	check_and_set_usage (CB_USAGE_UNSIGNED_INT);
#else
	check_and_set_usage (CB_USAGE_UNSIGNED_LONG);
#endif
  }
#line 11850 "parser.c" /* yacc.c:1646  */
    break;

  case 589:
#line 5514 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_SIGNED_CHAR);
  }
#line 11858 "parser.c" /* yacc.c:1646  */
    break;

  case 590:
#line 5518 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_UNSIGNED_CHAR);
  }
#line 11866 "parser.c" /* yacc.c:1646  */
    break;

  case 591:
#line 5522 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_SIGNED_SHORT);
  }
#line 11874 "parser.c" /* yacc.c:1646  */
    break;

  case 592:
#line 5526 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_UNSIGNED_SHORT);
  }
#line 11882 "parser.c" /* yacc.c:1646  */
    break;

  case 593:
#line 5530 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_SIGNED_INT);
  }
#line 11890 "parser.c" /* yacc.c:1646  */
    break;

  case 594:
#line 5534 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_UNSIGNED_INT);
  }
#line 11898 "parser.c" /* yacc.c:1646  */
    break;

  case 595:
#line 5538 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_SIGNED_LONG);
  }
#line 11906 "parser.c" /* yacc.c:1646  */
    break;

  case 596:
#line 5542 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_UNSIGNED_LONG);
  }
#line 11914 "parser.c" /* yacc.c:1646  */
    break;

  case 597:
#line 5546 "parser.y" /* yacc.c:1646  */
    {
#ifdef COB_32_BIT_LONG
	check_and_set_usage (CB_USAGE_SIGNED_INT);
#else
	check_and_set_usage (CB_USAGE_SIGNED_LONG);
#endif
  }
#line 11926 "parser.c" /* yacc.c:1646  */
    break;

  case 598:
#line 5554 "parser.y" /* yacc.c:1646  */
    {
#ifdef COB_32_BIT_LONG
	check_and_set_usage (CB_USAGE_UNSIGNED_INT);
#else
	check_and_set_usage (CB_USAGE_UNSIGNED_LONG);
#endif
  }
#line 11938 "parser.c" /* yacc.c:1646  */
    break;

  case 599:
#line 5562 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_FP_BIN32);
  }
#line 11946 "parser.c" /* yacc.c:1646  */
    break;

  case 600:
#line 5566 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_FP_BIN64);
  }
#line 11954 "parser.c" /* yacc.c:1646  */
    break;

  case 601:
#line 5570 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_FP_BIN128);
  }
#line 11962 "parser.c" /* yacc.c:1646  */
    break;

  case 602:
#line 5574 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_FP_DEC64);
  }
#line 11970 "parser.c" /* yacc.c:1646  */
    break;

  case 603:
#line 5578 "parser.y" /* yacc.c:1646  */
    {
	check_and_set_usage (CB_USAGE_FP_DEC128);
  }
#line 11978 "parser.c" /* yacc.c:1646  */
    break;

  case 604:
#line 5582 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("USAGE", SYN_CLAUSE_5, &check_pic_duplicate);
	CB_UNFINISHED ("USAGE NATIONAL");
  }
#line 11987 "parser.c" /* yacc.c:1646  */
    break;

  case 618:
#line 5617 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("SIGN", SYN_CLAUSE_6, &check_pic_duplicate);
	current_field->flag_sign_clause = 1;
	current_field->flag_sign_separate = ((yyvsp[0]) ? 1 : 0);
	current_field->flag_sign_leading  = 1;
  }
#line 11998 "parser.c" /* yacc.c:1646  */
    break;

  case 619:
#line 5624 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("SIGN", SYN_CLAUSE_6, &check_pic_duplicate);
	current_field->flag_sign_clause = 1;
	current_field->flag_sign_separate = ((yyvsp[0]) ? 1 : 0);
	current_field->flag_sign_leading  = 0;
  }
#line 12009 "parser.c" /* yacc.c:1646  */
    break;

  case 620:
#line 5638 "parser.y" /* yacc.c:1646  */
    {
	/* most of the field attributes are set when parsing the phrases */;
	setup_occurs ();
	setup_occurs_min_max ((yyvsp[-4]), (yyvsp[-3]));
  }
#line 12019 "parser.c" /* yacc.c:1646  */
    break;

  case 622:
#line 5647 "parser.y" /* yacc.c:1646  */
    {
	current_field->step_count = cb_get_int ((yyvsp[0]));
  }
#line 12027 "parser.c" /* yacc.c:1646  */
    break;

  case 623:
#line 5657 "parser.y" /* yacc.c:1646  */
    {
	/* most of the field attributes are set when parsing the phrases */;
	setup_occurs ();
	setup_occurs_min_max ((yyvsp[-4]), (yyvsp[-3]));
  }
#line 12037 "parser.c" /* yacc.c:1646  */
    break;

  case 624:
#line 5664 "parser.y" /* yacc.c:1646  */
    {
	current_field->flag_unbounded = 1;
	if (current_field->parent) {
		current_field->parent->flag_unbounded = 1;
	}
	current_field->depending = (yyvsp[-1]);
	/* most of the field attributes are set when parsing the phrases */;
	setup_occurs ();
	setup_occurs_min_max ((yyvsp[-6]), cb_int0);
  }
#line 12052 "parser.c" /* yacc.c:1646  */
    break;

  case 625:
#line 5676 "parser.y" /* yacc.c:1646  */
    {
	setup_occurs ();
	current_field->occurs_min = (yyvsp[-3]) ? cb_get_int ((yyvsp[-3])) : 0;
	if ((yyvsp[-2])) {
		current_field->occurs_max = cb_get_int ((yyvsp[-2]));
		if (current_field->occurs_max <= current_field->occurs_min) {
			cb_error (_("OCCURS TO must be greater than OCCURS FROM"));
		}
	} else {
		current_field->occurs_max = 0;
	}
	CB_PENDING("OCCURS DYNAMIC");
  }
#line 12070 "parser.c" /* yacc.c:1646  */
    break;

  case 626:
#line 5692 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 12076 "parser.c" /* yacc.c:1646  */
    break;

  case 627:
#line 5693 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 12082 "parser.c" /* yacc.c:1646  */
    break;

  case 628:
#line 5697 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 12088 "parser.c" /* yacc.c:1646  */
    break;

  case 629:
#line 5698 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 12094 "parser.c" /* yacc.c:1646  */
    break;

  case 630:
#line 5702 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 12100 "parser.c" /* yacc.c:1646  */
    break;

  case 631:
#line 5703 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[-1]); }
#line 12106 "parser.c" /* yacc.c:1646  */
    break;

  case 633:
#line 5708 "parser.y" /* yacc.c:1646  */
    {
	current_field->depending = (yyvsp[0]);
  }
#line 12114 "parser.c" /* yacc.c:1646  */
    break;

  case 635:
#line 5714 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_index ((yyvsp[0]), cb_zero, 0, current_field);
	CB_FIELD_PTR ((yyval))->special_index = 1U;
  }
#line 12123 "parser.c" /* yacc.c:1646  */
    break;

  case 637:
#line 5722 "parser.y" /* yacc.c:1646  */
    {
	/* current_field->initialized = 1; */
  }
#line 12131 "parser.c" /* yacc.c:1646  */
    break;

  case 640:
#line 5731 "parser.y" /* yacc.c:1646  */
    {
	if (!cb_relaxed_syntax_checks) {
		cb_error (_("INDEXED should follow ASCENDING/DESCENDING"));
	} else {
		cb_warning (warningopt, _("INDEXED should follow ASCENDING/DESCENDING"));
	}
  }
#line 12143 "parser.c" /* yacc.c:1646  */
    break;

  case 644:
#line 5745 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0])) {
		cb_tree		l;
		struct cb_key	*keys;
		int		i;
		int		nkeys;

		l = (yyvsp[0]);
		nkeys = cb_list_length ((yyvsp[0]));
		keys = cobc_parse_malloc (sizeof (struct cb_key) * nkeys);

		for (i = 0; i < nkeys; i++) {
			keys[i].dir = CB_PURPOSE_INT (l);
			keys[i].key = CB_VALUE (l);
			l = CB_CHAIN (l);
		}
		current_field->keys = keys;
		current_field->nkeys = nkeys;
	}
  }
#line 12168 "parser.c" /* yacc.c:1646  */
    break;

  case 647:
#line 5774 "parser.y" /* yacc.c:1646  */
    {
	cb_tree l;

	for (l = (yyvsp[0]); l; l = CB_CHAIN (l)) {
		CB_PURPOSE (l) = (yyvsp[-3]);
		if (qualifier && !CB_REFERENCE(CB_VALUE(l))->chain &&
		    strcasecmp (CB_NAME(CB_VALUE(l)), CB_NAME(qualifier))) {
			CB_REFERENCE(CB_VALUE(l))->chain = qualifier;
		}
	}
	keys_list = cb_list_append (keys_list, (yyvsp[0]));
	(yyval) = keys_list;
  }
#line 12186 "parser.c" /* yacc.c:1646  */
    break;

  case 648:
#line 5790 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (COB_ASCENDING); }
#line 12192 "parser.c" /* yacc.c:1646  */
    break;

  case 649:
#line 5791 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (COB_DESCENDING); }
#line 12198 "parser.c" /* yacc.c:1646  */
    break;

  case 652:
#line 5800 "parser.y" /* yacc.c:1646  */
    {
	current_field->index_list = (yyvsp[0]);
  }
#line 12206 "parser.c" /* yacc.c:1646  */
    break;

  case 653:
#line 5806 "parser.y" /* yacc.c:1646  */
    { (yyval) = CB_LIST_INIT ((yyvsp[0])); }
#line 12212 "parser.c" /* yacc.c:1646  */
    break;

  case 654:
#line 5808 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_list_add ((yyvsp[-1]), (yyvsp[0])); }
#line 12218 "parser.c" /* yacc.c:1646  */
    break;

  case 655:
#line 5813 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_index ((yyvsp[0]), cb_int1, 1U, current_field);
	CB_FIELD_PTR ((yyval))->special_index = 1U;
  }
#line 12227 "parser.c" /* yacc.c:1646  */
    break;

  case 656:
#line 5824 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("JUSTIFIED", SYN_CLAUSE_8, &check_pic_duplicate);
	current_field->flag_justified = 1;
  }
#line 12236 "parser.c" /* yacc.c:1646  */
    break;

  case 657:
#line 5835 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("SYNCHRONIZED", SYN_CLAUSE_9, &check_pic_duplicate);
	current_field->flag_synchronized = 1;
  }
#line 12245 "parser.c" /* yacc.c:1646  */
    break;

  case 658:
#line 5846 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("BLANK", SYN_CLAUSE_10, &check_pic_duplicate);
	current_field->flag_blank_zero = 1;
  }
#line 12254 "parser.c" /* yacc.c:1646  */
    break;

  case 659:
#line 5857 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("BASED", SYN_CLAUSE_11, &check_pic_duplicate);
	if (current_storage != CB_STORAGE_WORKING &&
	    current_storage != CB_STORAGE_LINKAGE &&
	    current_storage != CB_STORAGE_LOCAL) {
		cb_error (_("%s not allowed here"), "BASED");
	} else if (current_field->level != 1 && current_field->level != 77) {
		cb_error (_("%s only allowed at 01/77 level"), "BASED");
	} else if (!qualifier) {
		cb_error (_("%s requires a data name"), "BASED");
	} else if (current_field->flag_external) {
		cb_error (_("%s and %s are mutually exclusive"), "BASED", "EXTERNAL");
	} else if (current_field->redefines) {
		cb_error (_("%s and %s are mutually exclusive"), "BASED", "REDEFINES");
	} else if (current_field->flag_any_length) {
		cb_error (_("%s and %s are mutually exclusive"), "BASED", "ANY LENGTH");
	} else if (current_field->flag_occurs) {
		cb_error (_("%s and %s are mutually exclusive"), "BASED", "OCCURS");
	} else {
		current_field->flag_item_based = 1;
	}
  }
#line 12281 "parser.c" /* yacc.c:1646  */
    break;

  case 660:
#line 5885 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("VALUE", SYN_CLAUSE_12, &check_pic_duplicate);
	current_field->values = (yyvsp[0]);
  }
#line 12290 "parser.c" /* yacc.c:1646  */
    break;

  case 662:
#line 5893 "parser.y" /* yacc.c:1646  */
    { (yyval) = CB_LIST_INIT ((yyvsp[0])); }
#line 12296 "parser.c" /* yacc.c:1646  */
    break;

  case 663:
#line 5894 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_list_add ((yyvsp[-1]), (yyvsp[0])); }
#line 12302 "parser.c" /* yacc.c:1646  */
    break;

  case 664:
#line 5898 "parser.y" /* yacc.c:1646  */
    { (yyval) = CB_BUILD_PAIR ((yyvsp[-2]), (yyvsp[0])); }
#line 12308 "parser.c" /* yacc.c:1646  */
    break;

  case 667:
#line 5905 "parser.y" /* yacc.c:1646  */
    {
	if (current_field->level != 88) {
		cb_error (_("FALSE clause only allowed for 88 level"));
	}
	current_field->false_88 = CB_LIST_INIT ((yyvsp[0]));
  }
#line 12319 "parser.c" /* yacc.c:1646  */
    break;

  case 668:
#line 5917 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("ANY", SYN_CLAUSE_14, &check_pic_duplicate);
	if (current_field->flag_item_based) {
		cb_error (_("%s and %s are mutually exclusive"), "BASED", "ANY LENGTH");
	} else {
		current_field->flag_any_length = 1;
	}
  }
#line 12332 "parser.c" /* yacc.c:1646  */
    break;

  case 669:
#line 5926 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("ANY", SYN_CLAUSE_14, &check_pic_duplicate);
	if (current_field->flag_item_based) {
		cb_error (_("%s and %s are mutually exclusive"), "BASED", "ANY NUMERIC");
	} else {
		current_field->flag_any_length = 1;
		current_field->flag_any_numeric = 1;
	}
  }
#line 12346 "parser.c" /* yacc.c:1646  */
    break;

  case 671:
#line 5941 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_DATA_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_LOCAL_STORAGE_SECTION;
	current_storage = CB_STORAGE_LOCAL;
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "LOCAL-STORAGE");
	}
  }
#line 12359 "parser.c" /* yacc.c:1646  */
    break;

  case 672:
#line 5950 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0])) {
		current_program->local_storage = CB_FIELD ((yyvsp[0]));
	}
  }
#line 12369 "parser.c" /* yacc.c:1646  */
    break;

  case 674:
#line 5962 "parser.y" /* yacc.c:1646  */
    {
	check_headers_present (COBC_HD_DATA_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_LINKAGE_SECTION;
	current_storage = CB_STORAGE_LINKAGE;
  }
#line 12379 "parser.c" /* yacc.c:1646  */
    break;

  case 675:
#line 5968 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0])) {
		current_program->linkage_storage = CB_FIELD ((yyvsp[0]));
	}
  }
#line 12389 "parser.c" /* yacc.c:1646  */
    break;

  case 677:
#line 5979 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING("REPORT SECTION");
	current_storage = CB_STORAGE_REPORT;
	cb_clear_real_field ();
  }
#line 12399 "parser.c" /* yacc.c:1646  */
    break;

  case 681:
#line 5995 "parser.y" /* yacc.c:1646  */
    {
	if (CB_INVALID_TREE ((yyvsp[0]))) {
		YYERROR;
	} else {
		current_report = CB_REPORT (cb_ref ((yyvsp[0])));
	}
	check_duplicate = 0;
  }
#line 12412 "parser.c" /* yacc.c:1646  */
    break;

  case 685:
#line 6010 "parser.y" /* yacc.c:1646  */
    {
	yyerrok;
  }
#line 12420 "parser.c" /* yacc.c:1646  */
    break;

  case 686:
#line 6017 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("GLOBAL", SYN_CLAUSE_1, &check_duplicate);
	cb_error (_("GLOBAL is not allowed with RD"));
  }
#line 12429 "parser.c" /* yacc.c:1646  */
    break;

  case 687:
#line 6022 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("CODE", SYN_CLAUSE_2, &check_duplicate);
  }
#line 12437 "parser.c" /* yacc.c:1646  */
    break;

  case 690:
#line 6033 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("CONTROL", SYN_CLAUSE_3, &check_duplicate);
  }
#line 12445 "parser.c" /* yacc.c:1646  */
    break;

  case 692:
#line 6047 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("PAGE", SYN_CLAUSE_4, &check_duplicate);
	if (!current_report->heading) {
		current_report->heading = 1;
	}
	if (!current_report->first_detail) {
		current_report->first_detail = current_report->heading;
	}
	if (!current_report->last_control) {
		if (current_report->last_detail) {
			current_report->last_control = current_report->last_detail;
		} else if (current_report->footing) {
			current_report->last_control = current_report->footing;
		} else {
			current_report->last_control = current_report->lines;
		}
	}
	if (!current_report->last_detail && !current_report->footing) {
		current_report->last_detail = current_report->lines;
		current_report->footing = current_report->lines;
	} else if (!current_report->last_detail) {
		current_report->last_detail = current_report->footing;
	} else if (!current_report->footing) {
		current_report->footing = current_report->last_detail;
	}
	if (current_report->heading > current_report->first_detail ||
	    current_report->first_detail > current_report->last_control ||
	    current_report->last_control > current_report->last_detail ||
	    current_report->last_detail > current_report->footing) {
		cb_error (_("invalid %s clause"), "PAGE");
	}
  }
#line 12482 "parser.c" /* yacc.c:1646  */
    break;

  case 693:
#line 6083 "parser.y" /* yacc.c:1646  */
    {
	current_report->lines = cb_get_int ((yyvsp[0]));
  }
#line 12490 "parser.c" /* yacc.c:1646  */
    break;

  case 694:
#line 6087 "parser.y" /* yacc.c:1646  */
    {
	current_report->lines = cb_get_int ((yyvsp[-3]));
	current_report->columns = cb_get_int ((yyvsp[-1]));
  }
#line 12499 "parser.c" /* yacc.c:1646  */
    break;

  case 695:
#line 6092 "parser.y" /* yacc.c:1646  */
    {
	current_report->lines = cb_get_int ((yyvsp[-1]));
  }
#line 12507 "parser.c" /* yacc.c:1646  */
    break;

  case 703:
#line 6112 "parser.y" /* yacc.c:1646  */
    {
	current_report->heading = cb_get_int ((yyvsp[0]));
  }
#line 12515 "parser.c" /* yacc.c:1646  */
    break;

  case 704:
#line 6119 "parser.y" /* yacc.c:1646  */
    {
	current_report->first_detail = cb_get_int ((yyvsp[0]));
  }
#line 12523 "parser.c" /* yacc.c:1646  */
    break;

  case 705:
#line 6126 "parser.y" /* yacc.c:1646  */
    {
	current_report->last_control = cb_get_int ((yyvsp[0]));
  }
#line 12531 "parser.c" /* yacc.c:1646  */
    break;

  case 706:
#line 6133 "parser.y" /* yacc.c:1646  */
    {
	current_report->last_detail = cb_get_int ((yyvsp[0]));
  }
#line 12539 "parser.c" /* yacc.c:1646  */
    break;

  case 707:
#line 6140 "parser.y" /* yacc.c:1646  */
    {
	current_report->footing = cb_get_int ((yyvsp[0]));
  }
#line 12547 "parser.c" /* yacc.c:1646  */
    break;

  case 710:
#line 6151 "parser.y" /* yacc.c:1646  */
    {
	check_pic_duplicate = 0;
  }
#line 12555 "parser.c" /* yacc.c:1646  */
    break;

  case 730:
#line 6182 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("TYPE", SYN_CLAUSE_16, &check_pic_duplicate);
  }
#line 12563 "parser.c" /* yacc.c:1646  */
    break;

  case 743:
#line 6208 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("NEXT GROUP", SYN_CLAUSE_17, &check_pic_duplicate);
  }
#line 12571 "parser.c" /* yacc.c:1646  */
    break;

  case 744:
#line 6215 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("SUM", SYN_CLAUSE_19, &check_pic_duplicate);
  }
#line 12579 "parser.c" /* yacc.c:1646  */
    break;

  case 749:
#line 6231 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("PRESENT", SYN_CLAUSE_20, &check_pic_duplicate);
  }
#line 12587 "parser.c" /* yacc.c:1646  */
    break;

  case 751:
#line 6242 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("LINE", SYN_CLAUSE_21, &check_pic_duplicate);
  }
#line 12595 "parser.c" /* yacc.c:1646  */
    break;

  case 754:
#line 6254 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("COLUMN", SYN_CLAUSE_18, &check_pic_duplicate);
  }
#line 12603 "parser.c" /* yacc.c:1646  */
    break;

  case 766:
#line 6287 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("SOURCE", SYN_CLAUSE_22, &check_pic_duplicate);
  }
#line 12611 "parser.c" /* yacc.c:1646  */
    break;

  case 767:
#line 6294 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("GROUP", SYN_CLAUSE_23, &check_pic_duplicate);
  }
#line 12619 "parser.c" /* yacc.c:1646  */
    break;

  case 768:
#line 6301 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("USAGE", SYN_CLAUSE_24, &check_pic_duplicate);
  }
#line 12627 "parser.c" /* yacc.c:1646  */
    break;

  case 770:
#line 6310 "parser.y" /* yacc.c:1646  */
    {
	current_storage = CB_STORAGE_SCREEN;
	current_field = NULL;
	description_field = NULL;
	cb_clear_real_field ();
  }
#line 12638 "parser.c" /* yacc.c:1646  */
    break;

  case 771:
#line 6317 "parser.y" /* yacc.c:1646  */
    {
	struct cb_field *p;

	if (description_field) {
		for (p = description_field; p; p = p->sister) {
			cb_validate_field (p);
		}
		current_program->screen_storage = description_field;
		current_program->flag_screen = 1;
	}
  }
#line 12654 "parser.c" /* yacc.c:1646  */
    break;

  case 777:
#line 6342 "parser.y" /* yacc.c:1646  */
    {
	cb_tree	x;

	x = cb_build_field_tree ((yyvsp[-1]), (yyvsp[0]), current_field, current_storage,
				 current_file, 0);
	/* Free tree associated with level number */
	cobc_parse_free ((yyvsp[-1]));
	check_pic_duplicate = 0;
	if (CB_INVALID_TREE (x)) {
		YYERROR;
	}

	current_field = CB_FIELD (x);
	if (current_field->parent) {
		current_field->screen_foreg = current_field->parent->screen_foreg;
		current_field->screen_backg = current_field->parent->screen_backg;
		current_field->screen_prompt = current_field->parent->screen_prompt;
	}
  }
#line 12678 "parser.c" /* yacc.c:1646  */
    break;

  case 778:
#line 6362 "parser.y" /* yacc.c:1646  */
    {
	cob_flags_t	flags;

	if (current_field->parent) {
		flags = current_field->parent->screen_flag;
		flags &= ~COB_SCREEN_BLANK_LINE;
		flags &= ~COB_SCREEN_BLANK_SCREEN;
		flags &= ~COB_SCREEN_ERASE_EOL;
		flags &= ~COB_SCREEN_ERASE_EOS;
		flags &= ~COB_SCREEN_LINE_PLUS;
		flags &= ~COB_SCREEN_LINE_MINUS;
		flags &= ~COB_SCREEN_COLUMN_PLUS;
		flags &= ~COB_SCREEN_COLUMN_MINUS;

		flags = zero_conflicting_flags (current_field->screen_flag,
						flags);

		current_field->screen_flag |= flags;
	}

	if (current_field->screen_flag & COB_SCREEN_INITIAL) {
		if (!(current_field->screen_flag & COB_SCREEN_INPUT)) {
			cb_error (_("INITIAL specified on non-input field"));
		}
	}
	if (!qualifier) {
		current_field->flag_filler = 1;
	}

	if (likely (current_field)) {
		if (!description_field) {
			description_field = current_field;
		}
		if (current_field->flag_occurs
		    && !has_relative_pos (current_field)) {
			cb_error (_("relative LINE/COLUMN clause required with OCCURS"));
		}
	}
  }
#line 12722 "parser.c" /* yacc.c:1646  */
    break;

  case 779:
#line 6402 "parser.y" /* yacc.c:1646  */
    {
	/* Free tree associated with level number */
	cobc_parse_free ((yyvsp[-2]));
	yyerrok;
	cb_unput_dot ();
	check_pic_duplicate = 0;
	check_duplicate = 0;
#if	1	/* RXWRXW Screen field */
	if (current_field) {
		current_field->flag_is_verified = 1;
		current_field->flag_invalid = 1;
	}
#endif
	current_field = cb_get_real_field ();
  }
#line 12742 "parser.c" /* yacc.c:1646  */
    break;

  case 782:
#line 6426 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr_with_conflict ("BLANK LINE", COB_SCREEN_BLANK_LINE,
				       "BLANK SCREEN", COB_SCREEN_BLANK_SCREEN);
  }
#line 12751 "parser.c" /* yacc.c:1646  */
    break;

  case 783:
#line 6431 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr_with_conflict ("BLANK SCREEN", COB_SCREEN_BLANK_SCREEN,
				       "BLANK LINE", COB_SCREEN_BLANK_LINE);
  }
#line 12760 "parser.c" /* yacc.c:1646  */
    break;

  case 784:
#line 6436 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr ("BELL", COB_SCREEN_BELL);
  }
#line 12768 "parser.c" /* yacc.c:1646  */
    break;

  case 785:
#line 6440 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr ("BLINK", COB_SCREEN_BLINK);
  }
#line 12776 "parser.c" /* yacc.c:1646  */
    break;

  case 786:
#line 6444 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr_with_conflict ("ERASE EOL", COB_SCREEN_ERASE_EOL,
				       "ERASE EOS", COB_SCREEN_ERASE_EOS);
  }
#line 12785 "parser.c" /* yacc.c:1646  */
    break;

  case 787:
#line 6449 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr_with_conflict ("ERASE EOS", COB_SCREEN_ERASE_EOS,
				       "ERASE EOL", COB_SCREEN_ERASE_EOL);
  }
#line 12794 "parser.c" /* yacc.c:1646  */
    break;

  case 788:
#line 6454 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr_with_conflict ("HIGHLIGHT", COB_SCREEN_HIGHLIGHT,
				       "LOWLIGHT", COB_SCREEN_LOWLIGHT);
  }
#line 12803 "parser.c" /* yacc.c:1646  */
    break;

  case 789:
#line 6459 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr_with_conflict ("LOWLIGHT", COB_SCREEN_LOWLIGHT,
				       "HIGHLIGHT", COB_SCREEN_HIGHLIGHT);
  }
#line 12812 "parser.c" /* yacc.c:1646  */
    break;

  case 790:
#line 6464 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr ("REVERSE-VIDEO", COB_SCREEN_REVERSE);
  }
#line 12820 "parser.c" /* yacc.c:1646  */
    break;

  case 791:
#line 6468 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr ("UNDERLINE", COB_SCREEN_UNDERLINE);
  }
#line 12828 "parser.c" /* yacc.c:1646  */
    break;

  case 792:
#line 6472 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr ("OVERLINE", COB_SCREEN_OVERLINE);
	CB_PENDING ("OVERLINE");
  }
#line 12837 "parser.c" /* yacc.c:1646  */
    break;

  case 793:
#line 6477 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr ("GRID", COB_SCREEN_GRID);
	CB_PENDING ("GRID");
  }
#line 12846 "parser.c" /* yacc.c:1646  */
    break;

  case 794:
#line 6482 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr ("LEFTLINE", COB_SCREEN_LEFTLINE);
	CB_PENDING ("LEFTLINE");
  }
#line 12855 "parser.c" /* yacc.c:1646  */
    break;

  case 795:
#line 6487 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr_with_conflict ("AUTO", COB_SCREEN_AUTO,
				       "TAB", COB_SCREEN_TAB);
  }
#line 12864 "parser.c" /* yacc.c:1646  */
    break;

  case 796:
#line 6492 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr_with_conflict ("TAB", COB_SCREEN_TAB,
				       "AUTO", COB_SCREEN_AUTO);
  }
#line 12873 "parser.c" /* yacc.c:1646  */
    break;

  case 797:
#line 6497 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr_with_conflict ("SECURE", COB_SCREEN_SECURE,
				       "NO-ECHO", COB_SCREEN_NO_ECHO);
  }
#line 12882 "parser.c" /* yacc.c:1646  */
    break;

  case 798:
#line 6502 "parser.y" /* yacc.c:1646  */
    {
	if (cb_no_echo_means_secure) {
		set_screen_attr ("SECURE", COB_SCREEN_SECURE);
	} else {
		set_screen_attr_with_conflict ("NO-ECHO", COB_SCREEN_NO_ECHO,
					       "SECURE", COB_SCREEN_SECURE);
	}
  }
#line 12895 "parser.c" /* yacc.c:1646  */
    break;

  case 799:
#line 6511 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr ("REQUIRED", COB_SCREEN_REQUIRED);
  }
#line 12903 "parser.c" /* yacc.c:1646  */
    break;

  case 800:
#line 6515 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr ("FULL", COB_SCREEN_FULL);
  }
#line 12911 "parser.c" /* yacc.c:1646  */
    break;

  case 801:
#line 6519 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr ("PROMPT", COB_SCREEN_PROMPT);
	current_field->screen_prompt = (yyvsp[0]);
  }
#line 12920 "parser.c" /* yacc.c:1646  */
    break;

  case 802:
#line 6524 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr ("PROMPT", COB_SCREEN_PROMPT);
  }
#line 12928 "parser.c" /* yacc.c:1646  */
    break;

  case 803:
#line 6528 "parser.y" /* yacc.c:1646  */
    {
	set_screen_attr ("INITIAL", COB_SCREEN_INITIAL);
  }
#line 12936 "parser.c" /* yacc.c:1646  */
    break;

  case 804:
#line 6532 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("LINE", SYN_CLAUSE_16, &check_pic_duplicate);
  }
#line 12944 "parser.c" /* yacc.c:1646  */
    break;

  case 805:
#line 6536 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("COLUMN", SYN_CLAUSE_17, &check_pic_duplicate);
  }
#line 12952 "parser.c" /* yacc.c:1646  */
    break;

  case 806:
#line 6540 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("FOREGROUND-COLOR", SYN_CLAUSE_18, &check_pic_duplicate);
	current_field->screen_foreg = (yyvsp[0]);
  }
#line 12961 "parser.c" /* yacc.c:1646  */
    break;

  case 807:
#line 6545 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("BACKGROUND-COLOR", SYN_CLAUSE_19, &check_pic_duplicate);
	current_field->screen_backg = (yyvsp[0]);
  }
#line 12970 "parser.c" /* yacc.c:1646  */
    break;

  case 816:
#line 6558 "parser.y" /* yacc.c:1646  */
    {
	check_not_88_level ((yyvsp[0]));

	check_repeated ("USING", SYN_CLAUSE_20, &check_pic_duplicate);
	current_field->screen_from = (yyvsp[0]);
	current_field->screen_to = (yyvsp[0]);
	current_field->screen_flag |= COB_SCREEN_INPUT;
  }
#line 12983 "parser.c" /* yacc.c:1646  */
    break;

  case 817:
#line 6567 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("FROM", SYN_CLAUSE_21, &check_pic_duplicate);
	current_field->screen_from = (yyvsp[0]);
  }
#line 12992 "parser.c" /* yacc.c:1646  */
    break;

  case 818:
#line 6572 "parser.y" /* yacc.c:1646  */
    {
	check_not_88_level ((yyvsp[0]));

	check_repeated ("TO", SYN_CLAUSE_22, &check_pic_duplicate);
	current_field->screen_to = (yyvsp[0]);
	current_field->screen_flag |= COB_SCREEN_INPUT;
  }
#line 13004 "parser.c" /* yacc.c:1646  */
    break;

  case 827:
#line 6603 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0])) {
		current_field->screen_line = (yyvsp[0]);
	}
  }
#line 13014 "parser.c" /* yacc.c:1646  */
    break;

  case 828:
#line 6612 "parser.y" /* yacc.c:1646  */
    {
	/* Nothing */
  }
#line 13022 "parser.c" /* yacc.c:1646  */
    break;

  case 829:
#line 6616 "parser.y" /* yacc.c:1646  */
    {
	current_field->screen_flag |= COB_SCREEN_LINE_PLUS;
  }
#line 13030 "parser.c" /* yacc.c:1646  */
    break;

  case 830:
#line 6620 "parser.y" /* yacc.c:1646  */
    {
	current_field->screen_flag |= COB_SCREEN_LINE_MINUS;
  }
#line 13038 "parser.c" /* yacc.c:1646  */
    break;

  case 831:
#line 6627 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0])) {
		current_field->screen_column = (yyvsp[0]);
	}
  }
#line 13048 "parser.c" /* yacc.c:1646  */
    break;

  case 832:
#line 6636 "parser.y" /* yacc.c:1646  */
    {
	/* Nothing */
  }
#line 13056 "parser.c" /* yacc.c:1646  */
    break;

  case 833:
#line 6640 "parser.y" /* yacc.c:1646  */
    {
	current_field->screen_flag |= COB_SCREEN_COLUMN_PLUS;
  }
#line 13064 "parser.c" /* yacc.c:1646  */
    break;

  case 834:
#line 6644 "parser.y" /* yacc.c:1646  */
    {
	current_field->screen_flag |= COB_SCREEN_COLUMN_MINUS;
  }
#line 13072 "parser.c" /* yacc.c:1646  */
    break;

  case 835:
#line 6651 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("OCCURS", SYN_CLAUSE_23, &check_pic_duplicate);
	current_field->occurs_max = cb_get_int ((yyvsp[-1]));
	current_field->occurs_min = current_field->occurs_max;
	current_field->indexes++;
	current_field->flag_occurs = 1;
  }
#line 13084 "parser.c" /* yacc.c:1646  */
    break;

  case 836:
#line 6662 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING (_("GLOBAL screen items"));
  }
#line 13092 "parser.c" /* yacc.c:1646  */
    break;

  case 837:
#line 6671 "parser.y" /* yacc.c:1646  */
    {
	current_section = NULL;
	current_paragraph = NULL;
	check_pic_duplicate = 0;
	check_duplicate = 0;
	if (!current_program->entry_convention) {
		current_program->entry_convention = cb_int (CB_CONV_COBOL);
	}
  }
#line 13106 "parser.c" /* yacc.c:1646  */
    break;

  case 838:
#line 6681 "parser.y" /* yacc.c:1646  */
    {
	current_section = NULL;
	current_paragraph = NULL;
	check_pic_duplicate = 0;
	check_duplicate = 0;
	cobc_in_procedure = 1U;
	cb_set_system_names ();
	if ((yyvsp[-3])) {
		if (current_program->entry_convention) {
			cb_warning (COBC_WARN_FILLER, _("overriding convention specified in ENTRY-CONVENTION"));
		}
		current_program->entry_convention = (yyvsp[-3]);
	} else if (!current_program->entry_convention) {
		current_program->entry_convention = cb_int (CB_CONV_COBOL);
	}
	header_check |= COBC_HD_PROCEDURE_DIVISION;
  }
#line 13128 "parser.c" /* yacc.c:1646  */
    break;

  case 839:
#line 6699 "parser.y" /* yacc.c:1646  */
    {
	if (current_program->flag_main && !current_program->flag_chained && (yyvsp[-4])) {
		cb_error (_("executable program requested but PROCEDURE/ENTRY has USING clause"));
	}
	/* Main entry point */
	emit_entry (current_program->program_id, 0, (yyvsp[-4]), NULL);
	current_program->num_proc_params = cb_list_length ((yyvsp[-4]));
	if (current_program->source_name) {
		emit_entry (current_program->source_name, 1, (yyvsp[-4]), NULL);
	}
  }
#line 13144 "parser.c" /* yacc.c:1646  */
    break;

  case 840:
#line 6711 "parser.y" /* yacc.c:1646  */
    {
	if (current_paragraph) {
		if (current_paragraph->exit_label) {
			emit_statement (current_paragraph->exit_label);
		}
		emit_statement (cb_build_perform_exit (current_paragraph));
	}
	if (current_section) {
		if (current_section->exit_label) {
			emit_statement (current_section->exit_label);
		}
		emit_statement (cb_build_perform_exit (current_section));
	}
  }
#line 13163 "parser.c" /* yacc.c:1646  */
    break;

  case 841:
#line 6726 "parser.y" /* yacc.c:1646  */
    {
	cb_tree label;

	/* No PROCEDURE DIVISION header here */
	/* Only a statement is allowed as first element */
	/* Thereafter, sections/paragraphs may be used */
	check_pic_duplicate = 0;
	check_duplicate = 0;
	if (!current_program->entry_convention) {
		current_program->entry_convention = cb_int (CB_CONV_COBOL);
	}
	cobc_in_procedure = 1U;
	label = cb_build_reference ("MAIN SECTION");
	current_section = CB_LABEL (cb_build_label (label, NULL));
	current_section->flag_section = 1;
	current_section->flag_dummy_section = 1;
	current_section->flag_skip_label = !!skip_statements;
	current_section->flag_declaratives = !!in_declaratives;
	current_section->xref.skip = 1;
	CB_TREE (current_section)->source_file = cb_source_file;
	CB_TREE (current_section)->source_line = cb_source_line;
	emit_statement (CB_TREE (current_section));
	label = cb_build_reference ("MAIN PARAGRAPH");
	current_paragraph = CB_LABEL (cb_build_label (label, NULL));
	current_paragraph->flag_declaratives = !!in_declaratives;
	current_paragraph->flag_skip_label = !!skip_statements;
	current_paragraph->flag_dummy_paragraph = 1;
	current_paragraph->xref.skip = 1;
	CB_TREE (current_paragraph)->source_file = cb_source_file;
	CB_TREE (current_paragraph)->source_line = cb_source_line;
	emit_statement (CB_TREE (current_paragraph));
	cb_set_system_names ();
  }
#line 13201 "parser.c" /* yacc.c:1646  */
    break;

  case 843:
#line 6764 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 13209 "parser.c" /* yacc.c:1646  */
    break;

  case 844:
#line 6768 "parser.y" /* yacc.c:1646  */
    {
	call_mode = CB_CALL_BY_REFERENCE;
	size_mode = CB_SIZE_4;
  }
#line 13218 "parser.c" /* yacc.c:1646  */
    break;

  case 845:
#line 6773 "parser.y" /* yacc.c:1646  */
    {
	if (cb_list_length ((yyvsp[0])) > MAX_CALL_FIELD_PARAMS) {
		cb_error (_("number of parameters exceeds maximum %d"),
			  MAX_CALL_FIELD_PARAMS);
	}
	(yyval) = (yyvsp[0]);
  }
#line 13230 "parser.c" /* yacc.c:1646  */
    break;

  case 846:
#line 6781 "parser.y" /* yacc.c:1646  */
    {
	call_mode = CB_CALL_BY_REFERENCE;
	if (current_program->prog_type == CB_FUNCTION_TYPE) {
		cb_error (_("CHAINING invalid in user FUNCTION"));
	} else {
		current_program->flag_chained = 1;
	}
  }
#line 13243 "parser.c" /* yacc.c:1646  */
    break;

  case 847:
#line 6790 "parser.y" /* yacc.c:1646  */
    {
	if (cb_list_length ((yyvsp[0])) > MAX_CALL_FIELD_PARAMS) {
		cb_error (_("number of parameters exceeds maximum %d"),
			  MAX_CALL_FIELD_PARAMS);
	}
	(yyval) = (yyvsp[0]);
  }
#line 13255 "parser.c" /* yacc.c:1646  */
    break;

  case 848:
#line 6800 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 13261 "parser.c" /* yacc.c:1646  */
    break;

  case 849:
#line 6802 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_list_append ((yyvsp[-1]), (yyvsp[0])); }
#line 13267 "parser.c" /* yacc.c:1646  */
    break;

  case 850:
#line 6807 "parser.y" /* yacc.c:1646  */
    {
	cb_tree		x;
	struct cb_field	*f;

	x = cb_build_identifier ((yyvsp[0]), 0);
	if ((yyvsp[-1]) == cb_int1 && CB_VALID_TREE (x) && cb_ref (x) != cb_error_node) {
		f = CB_FIELD (cb_ref (x));
		f->flag_is_pdiv_opt = 1;
	}

	if (call_mode == CB_CALL_BY_VALUE
	    && CB_REFERENCE_P ((yyvsp[0]))
	    && CB_FIELD (cb_ref ((yyvsp[0])))->flag_any_length) {
		cb_error_x ((yyvsp[0]), _("ANY LENGTH items may only be BY REFERENCE formal parameters"));
	}

	(yyval) = CB_BUILD_PAIR (cb_int (call_mode), x);
	CB_SIZES ((yyval)) = size_mode;
  }
#line 13291 "parser.c" /* yacc.c:1646  */
    break;

  case 852:
#line 6831 "parser.y" /* yacc.c:1646  */
    {
	call_mode = CB_CALL_BY_REFERENCE;
  }
#line 13299 "parser.c" /* yacc.c:1646  */
    break;

  case 853:
#line 6835 "parser.y" /* yacc.c:1646  */
    {
	if (current_program->flag_chained) {
		cb_error (_("%s not allowed in CHAINED programs"), "BY VALUE");
	} else {
		CB_UNFINISHED (_("parameters passed BY VALUE"));
		call_mode = CB_CALL_BY_VALUE;
	}
  }
#line 13312 "parser.c" /* yacc.c:1646  */
    break;

  case 855:
#line 6848 "parser.y" /* yacc.c:1646  */
    {
	if (call_mode != CB_CALL_BY_VALUE) {
		cb_error (_("SIZE only allowed for BY VALUE items"));
	} else {
		size_mode = CB_SIZE_AUTO;
	}
  }
#line 13324 "parser.c" /* yacc.c:1646  */
    break;

  case 856:
#line 6856 "parser.y" /* yacc.c:1646  */
    {
	if (call_mode != CB_CALL_BY_VALUE) {
		cb_error (_("SIZE only allowed for BY VALUE items"));
	} else {
		size_mode = CB_SIZE_4;
	}
  }
#line 13336 "parser.c" /* yacc.c:1646  */
    break;

  case 857:
#line 6864 "parser.y" /* yacc.c:1646  */
    {
	if (call_mode != CB_CALL_BY_VALUE) {
		cb_error (_("SIZE only allowed for BY VALUE items"));
	} else {
		size_mode = CB_SIZE_AUTO | CB_SIZE_UNSIGNED;
	}
  }
#line 13348 "parser.c" /* yacc.c:1646  */
    break;

  case 858:
#line 6872 "parser.y" /* yacc.c:1646  */
    {
	if (size_mode) {
		size_mode |= CB_SIZE_UNSIGNED;
	}
  }
#line 13358 "parser.c" /* yacc.c:1646  */
    break;

  case 860:
#line 6882 "parser.y" /* yacc.c:1646  */
    {
	unsigned char *s = CB_LITERAL ((yyvsp[0]))->data;
	size_mode = 0;

	if (call_mode != CB_CALL_BY_VALUE) {
		cb_error (_("SIZE only allowed for BY VALUE items"));
	} else if (CB_LITERAL ((yyvsp[0]))->size != 1) {
		cb_error_x ((yyvsp[0]), _("invalid value for SIZE"));
	} else {
		size_mode = 0;
		switch (*s) {
		case '1':
			size_mode = CB_SIZE_1;
			break;
		case '2':
			size_mode = CB_SIZE_2;
			break;
		case '4':
			size_mode = CB_SIZE_4;
			break;
		case '8':
			size_mode = CB_SIZE_8;
			break;
		default:
			cb_error_x ((yyvsp[0]), _("invalid value for SIZE"));
			break;
		}
	}
  }
#line 13392 "parser.c" /* yacc.c:1646  */
    break;

  case 861:
#line 6915 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int0;
  }
#line 13400 "parser.c" /* yacc.c:1646  */
    break;

  case 862:
#line 6919 "parser.y" /* yacc.c:1646  */
    {
	if (call_mode != CB_CALL_BY_REFERENCE) {
		cb_error (_("OPTIONAL only allowed for BY REFERENCE items"));
		(yyval) = cb_int0;
	} else {
		(yyval) = cb_int1;
	}
  }
#line 13413 "parser.c" /* yacc.c:1646  */
    break;

  case 863:
#line 6931 "parser.y" /* yacc.c:1646  */
    {
	if (current_program->prog_type == CB_FUNCTION_TYPE) {
		cb_error (_("RETURNING clause is required for a FUNCTION"));
	}
  }
#line 13423 "parser.c" /* yacc.c:1646  */
    break;

  case 864:
#line 6937 "parser.y" /* yacc.c:1646  */
    {
	if (current_program->flag_main) {
		cb_error (_("RETURNING clause cannot be OMITTED for main program"));
	}
	if (current_program->prog_type == CB_FUNCTION_TYPE) {
		cb_error (_("RETURNING clause cannot be OMITTED for a FUNCTION"));
	}
	current_program->flag_void = 1;
  }
#line 13437 "parser.c" /* yacc.c:1646  */
    break;

  case 865:
#line 6947 "parser.y" /* yacc.c:1646  */
    {
	struct cb_field	*f;

	if (cb_ref ((yyvsp[0])) != cb_error_node) {
		f = CB_FIELD_PTR ((yyvsp[0]));
		/* standard rule: returning item is allocated in the
		   activating runtime element */
		if (f->storage != CB_STORAGE_LINKAGE) {
			cb_error (_("RETURNING item is not defined in LINKAGE SECTION"));
		} else if (f->level != 1 && f->level != 77) {
			cb_error (_("RETURNING item must have level 01"));
		} else if (f->flag_occurs) {
			cb_error (_("RETURNING item should not have OCCURS"));
		} else {
			if (current_program->prog_type == CB_FUNCTION_TYPE) {
				if (f->flag_any_length) {
					cb_error (_("function RETURNING item may not be ANY LENGTH"));
				}

				f->flag_is_returning = 1;
			}
			current_program->returning = (yyvsp[0]);
		}
	}
  }
#line 13467 "parser.c" /* yacc.c:1646  */
    break;

  case 867:
#line 6976 "parser.y" /* yacc.c:1646  */
    {
	in_declaratives = 1;
	emit_statement (cb_build_comment ("DECLARATIVES"));
  }
#line 13476 "parser.c" /* yacc.c:1646  */
    break;

  case 868:
#line 6982 "parser.y" /* yacc.c:1646  */
    {
	if (needs_field_debug) {
		start_debug = 1;
	}
	in_declaratives = 0;
	in_debugging = 0;
	if (current_paragraph) {
		if (current_paragraph->exit_label) {
			emit_statement (current_paragraph->exit_label);
		}
		emit_statement (cb_build_perform_exit (current_paragraph));
		current_paragraph = NULL;
	}
	if (current_section) {
		if (current_section->exit_label) {
			emit_statement (current_section->exit_label);
		}
		current_section->flag_fatal_check = 1;
		emit_statement (cb_build_perform_exit (current_section));
		current_section = NULL;
	}
	skip_statements = 0;
	emit_statement (cb_build_comment ("END DECLARATIVES"));
	check_unreached = 0;
  }
#line 13506 "parser.c" /* yacc.c:1646  */
    break;

  case 873:
#line 7020 "parser.y" /* yacc.c:1646  */
    {
	if (next_label_list) {
		cb_tree	plabel;
		char	name[32];

		snprintf (name, sizeof(name), "L$%d", next_label_id);
		plabel = cb_build_label (cb_build_reference (name), NULL);
		CB_LABEL (plabel)->flag_next_sentence = 1;
		emit_statement (plabel);
		current_program->label_list =
			cb_list_append (current_program->label_list, next_label_list);
		next_label_list = NULL;
		next_label_id++;
	}
	/* check_unreached = 0; */
	cb_end_statement();
  }
#line 13528 "parser.c" /* yacc.c:1646  */
    break;

  case 875:
#line 7039 "parser.y" /* yacc.c:1646  */
    {
	/* check_unreached = 0; */
	cb_end_statement();
  }
#line 13537 "parser.c" /* yacc.c:1646  */
    break;

  case 876:
#line 7050 "parser.y" /* yacc.c:1646  */
    {
	non_const_word = 0;
	check_unreached = 0;
	if (cb_build_section_name ((yyvsp[-1]), 0) == cb_error_node) {
		YYERROR;
	}

	/* Exit the last paragraph/section */
	if (current_paragraph) {
		if (current_paragraph->exit_label) {
			emit_statement (current_paragraph->exit_label);
		}
		emit_statement (cb_build_perform_exit (current_paragraph));
	}
	if (current_section) {
		if (current_section->exit_label) {
			emit_statement (current_section->exit_label);
		}
		emit_statement (cb_build_perform_exit (current_section));
	}
	if (current_program->flag_debugging && !in_debugging) {
		if (current_paragraph || current_section) {
			emit_statement (cb_build_comment (
					"DEBUGGING - Fall through"));
			emit_statement (cb_build_debug (cb_debug_contents,
					"FALL THROUGH", NULL));
		}
	}

	/* Begin a new section */
	current_section = CB_LABEL (cb_build_label ((yyvsp[-1]), NULL));
	current_section->flag_section = 1;
	/* Careful here, one negation */
	current_section->flag_real_label = !in_debugging;
	current_section->flag_declaratives = !!in_declaratives;
	current_section->flag_skip_label = !!skip_statements;
	CB_TREE (current_section)->source_file = cb_source_file;
	CB_TREE (current_section)->source_line = cb_source_line;
	current_paragraph = NULL;
  }
#line 13582 "parser.c" /* yacc.c:1646  */
    break;

  case 877:
#line 7092 "parser.y" /* yacc.c:1646  */
    {
	emit_statement (CB_TREE (current_section));
  }
#line 13590 "parser.c" /* yacc.c:1646  */
    break;

  case 880:
#line 7103 "parser.y" /* yacc.c:1646  */
    {
	cb_tree label;

	non_const_word = 0;
	check_unreached = 0;
	if (cb_build_section_name ((yyvsp[-1]), 1) == cb_error_node) {
		YYERROR;
	}

	/* Exit the last paragraph */
	if (current_paragraph) {
		if (current_paragraph->exit_label) {
			emit_statement (current_paragraph->exit_label);
		}
		emit_statement (cb_build_perform_exit (current_paragraph));
		if (current_program->flag_debugging && !in_debugging) {
			emit_statement (cb_build_comment (
					"DEBUGGING - Fall through"));
			emit_statement (cb_build_debug (cb_debug_contents,
					"FALL THROUGH", NULL));
		}
	}

	/* Begin a new paragraph */
	if (!current_section) {
		label = cb_build_reference ("MAIN SECTION");
		current_section = CB_LABEL (cb_build_label (label, NULL));
		current_section->flag_section = 1;
		current_section->flag_dummy_section = 1;
		current_section->flag_declaratives = !!in_declaratives;
		current_section->flag_skip_label = !!skip_statements;
		current_section->xref.skip = 1;
		CB_TREE (current_section)->source_file = cb_source_file;
		CB_TREE (current_section)->source_line = cb_source_line;
		emit_statement (CB_TREE (current_section));
	}
	current_paragraph = CB_LABEL (cb_build_label ((yyvsp[-1]), current_section));
	current_paragraph->flag_declaratives = !!in_declaratives;
	current_paragraph->flag_skip_label = !!skip_statements;
	current_paragraph->flag_real_label = !in_debugging;
	current_paragraph->segment = current_section->segment;
	CB_TREE (current_paragraph)->source_file = cb_source_file;
	CB_TREE (current_paragraph)->source_line = cb_source_line;
	emit_statement (CB_TREE (current_paragraph));
  }
#line 13640 "parser.c" /* yacc.c:1646  */
    break;

  case 881:
#line 7152 "parser.y" /* yacc.c:1646  */
    {
	non_const_word = 0;
	check_unreached = 0;
	if (cb_build_section_name ((yyvsp[0]), 0) != cb_error_node) {
		if (is_reserved_word (CB_NAME ((yyvsp[0])))) {
			cb_error_x ((yyvsp[0]), _("'%s' is not a statement"), CB_NAME ((yyvsp[0])));
		} else if (is_default_reserved_word (CB_NAME ((yyvsp[0])))) {
			cb_error_x ((yyvsp[0]), _("unknown statement '%s'; it may exist in another dialect"),
				    CB_NAME ((yyvsp[0])));
		} else {
			cb_error_x ((yyvsp[0]), _("unknown statement '%s'"), CB_NAME ((yyvsp[0])));
		}
	}
	YYERROR;
  }
#line 13660 "parser.c" /* yacc.c:1646  */
    break;

  case 882:
#line 7171 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 13668 "parser.c" /* yacc.c:1646  */
    break;

  case 883:
#line 7175 "parser.y" /* yacc.c:1646  */
    {
	int segnum = cb_get_int ((yyvsp[0]));
	
	(yyval) = NULL;
	if (cb_verify (cb_section_segments, "SECTION segment")) {
		if (segnum > 99) {
			cb_error (_("SECTION segment-number must be less than or equal to 99"));
		} else {
			if (in_declaratives && segnum > 49) {
				cb_error (_("SECTION segment-number in DECLARATIVES must be less than 50"));
			}
			if (!in_declaratives) {
				current_program->flag_segments = 1;
				current_section->segment = segnum;
			} else {
				/* Simon: old version did not allow segments in declaratives at all
					ToDo: check codegen for possible missing parts */
				CB_PENDING (_("SECTION segment within DECLARATIVES"));
			}
		}
	}
  }
#line 13695 "parser.c" /* yacc.c:1646  */
    break;

  case 884:
#line 7204 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = current_program->exec_list;
	current_program->exec_list = NULL;
	check_unreached = 0;
  }
#line 13705 "parser.c" /* yacc.c:1646  */
    break;

  case 885:
#line 7209 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_TREE (current_statement);
	current_statement = NULL;
  }
#line 13714 "parser.c" /* yacc.c:1646  */
    break;

  case 886:
#line 7214 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_list_reverse (current_program->exec_list);
	current_program->exec_list = (yyvsp[-2]);
	current_statement = CB_STATEMENT ((yyvsp[-1]));
  }
#line 13724 "parser.c" /* yacc.c:1646  */
    break;

  case 887:
#line 7222 "parser.y" /* yacc.c:1646  */
    {
	cb_tree label;

	if (!current_section) {
		label = cb_build_reference ("MAIN SECTION");
		current_section = CB_LABEL (cb_build_label (label, NULL));
		current_section->flag_section = 1;
		current_section->flag_dummy_section = 1;
		current_section->flag_skip_label = !!skip_statements;
		current_section->flag_declaratives = !!in_declaratives;
		current_section->xref.skip = 1;
		CB_TREE (current_section)->source_file = cb_source_file;
		CB_TREE (current_section)->source_line = cb_source_line;
		emit_statement (CB_TREE (current_section));
	}
	if (!current_paragraph) {
		label = cb_build_reference ("MAIN PARAGRAPH");
		current_paragraph = CB_LABEL (cb_build_label (label, NULL));
		current_paragraph->flag_declaratives = !!in_declaratives;
		current_paragraph->flag_skip_label = !!skip_statements;
		current_paragraph->flag_dummy_paragraph = 1;
		current_paragraph->xref.skip = 1;
		CB_TREE (current_paragraph)->source_file = cb_source_file;
		CB_TREE (current_paragraph)->source_line = cb_source_line;
		emit_statement (CB_TREE (current_paragraph));
	}
	if (check_headers_present (COBC_HD_PROCEDURE_DIVISION, 0, 0, 0) == 1) {
		if (current_program->prog_type == CB_PROGRAM_TYPE) {
			emit_entry (current_program->program_id, 0, NULL, NULL);
		}
	}
  }
#line 13761 "parser.c" /* yacc.c:1646  */
    break;

  case 888:
#line 7255 "parser.y" /* yacc.c:1646  */
    {
	cobc_cs_check = 0;
  }
#line 13769 "parser.c" /* yacc.c:1646  */
    break;

  case 889:
#line 7259 "parser.y" /* yacc.c:1646  */
    {
	cobc_cs_check = 0;
  }
#line 13777 "parser.c" /* yacc.c:1646  */
    break;

  case 945:
#line 7322 "parser.y" /* yacc.c:1646  */
    {
	if (cb_verify (cb_next_sentence_phrase, "NEXT SENTENCE")) {
		cb_tree label;
		char	name[32];

		begin_statement ("NEXT SENTENCE", 0);
		sprintf (name, "L$%d", next_label_id);
		label = cb_build_reference (name);
		next_label_list = cb_list_add (next_label_list, label);
		emit_statement (cb_build_goto (label, NULL));
	}
	check_unreached = 0;
  }
#line 13795 "parser.c" /* yacc.c:1646  */
    break;

  case 946:
#line 7336 "parser.y" /* yacc.c:1646  */
    {
	yyerrok;
	cobc_cs_check = 0;
  }
#line 13804 "parser.c" /* yacc.c:1646  */
    break;

  case 947:
#line 7347 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("ACCEPT", TERM_ACCEPT);
	cobc_cs_check = CB_CS_ACCEPT;
  }
#line 13813 "parser.c" /* yacc.c:1646  */
    break;

  case 949:
#line 7357 "parser.y" /* yacc.c:1646  */
    {
	  check_duplicate = 0;
	  check_line_col_duplicate = 0;
	  line_column = NULL;
  }
#line 13823 "parser.c" /* yacc.c:1646  */
    break;

  case 950:
#line 7363 "parser.y" /* yacc.c:1646  */
    {
	/* Check for invalid use of screen clauses */
	if (current_statement->attr_ptr
	    || (!is_screen_field ((yyvsp[-3])) && line_column)) {
		cb_verify_x ((yyvsp[-3]), cb_accept_display_extensions,
			     _("non-standard ACCEPT"));
	}

	if (cb_accept_update && !has_dispattr (COB_SCREEN_NO_UPDATE)) {
		set_dispattr (COB_SCREEN_UPDATE);
	}
	if (cb_accept_auto && !has_dispattr (COB_SCREEN_TAB)) {
		set_dispattr (COB_SCREEN_AUTO);
	}
	if ((yyvsp[-3]) == cb_null && current_statement->attr_ptr) {
		if (current_statement->attr_ptr->prompt) {
			emit_conflicting_clause_message ("ACCEPT OMITTED",
				_("PROMPT clause"));
		}
		if (current_statement->attr_ptr->size_is) {
			emit_conflicting_clause_message ("ACCEPT OMITTED",
				_("SIZE IS clause"));
		}
	}
	cobc_cs_check = 0;
	cb_emit_accept ((yyvsp[-3]), line_column, current_statement->attr_ptr);
  }
#line 13855 "parser.c" /* yacc.c:1646  */
    break;

  case 951:
#line 7391 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_accept_line_or_col ((yyvsp[-2]), 0);
  }
#line 13863 "parser.c" /* yacc.c:1646  */
    break;

  case 952:
#line 7395 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_accept_line_or_col ((yyvsp[-2]), 1);
  }
#line 13871 "parser.c" /* yacc.c:1646  */
    break;

  case 953:
#line 7399 "parser.y" /* yacc.c:1646  */
    {
	cobc_cs_check = 0;
	cb_emit_accept_date_yyyymmdd ((yyvsp[-3]));
  }
#line 13880 "parser.c" /* yacc.c:1646  */
    break;

  case 954:
#line 7404 "parser.y" /* yacc.c:1646  */
    {
	cobc_cs_check = 0;
	cb_emit_accept_date ((yyvsp[-2]));
  }
#line 13889 "parser.c" /* yacc.c:1646  */
    break;

  case 955:
#line 7409 "parser.y" /* yacc.c:1646  */
    {
	cobc_cs_check = 0;
	cb_emit_accept_day_yyyyddd ((yyvsp[-3]));
  }
#line 13898 "parser.c" /* yacc.c:1646  */
    break;

  case 956:
#line 7414 "parser.y" /* yacc.c:1646  */
    {
	cobc_cs_check = 0;
	cb_emit_accept_day ((yyvsp[-2]));
  }
#line 13907 "parser.c" /* yacc.c:1646  */
    break;

  case 957:
#line 7419 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_accept_day_of_week ((yyvsp[-2]));
  }
#line 13915 "parser.c" /* yacc.c:1646  */
    break;

  case 958:
#line 7423 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_accept_escape_key ((yyvsp[-3]));
  }
#line 13923 "parser.c" /* yacc.c:1646  */
    break;

  case 959:
#line 7427 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_accept_exception_status ((yyvsp[-3]));
  }
#line 13931 "parser.c" /* yacc.c:1646  */
    break;

  case 960:
#line 7431 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_accept_time ((yyvsp[-2]));
  }
#line 13939 "parser.c" /* yacc.c:1646  */
    break;

  case 961:
#line 7435 "parser.y" /* yacc.c:1646  */
    {
	cobc_cs_check = 0;
	cb_emit_accept_user_name ((yyvsp[-3]));
  }
#line 13948 "parser.c" /* yacc.c:1646  */
    break;

  case 962:
#line 7440 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_accept_command_line ((yyvsp[-2]));
  }
#line 13956 "parser.c" /* yacc.c:1646  */
    break;

  case 963:
#line 7444 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_accept_environment ((yyvsp[-3]));
  }
#line 13964 "parser.c" /* yacc.c:1646  */
    break;

  case 964:
#line 7448 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_get_environment ((yyvsp[-1]), (yyvsp[-4]));
  }
#line 13972 "parser.c" /* yacc.c:1646  */
    break;

  case 965:
#line 7452 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_accept_arg_number ((yyvsp[-2]));
  }
#line 13980 "parser.c" /* yacc.c:1646  */
    break;

  case 966:
#line 7456 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_accept_arg_value ((yyvsp[-3]));
  }
#line 13988 "parser.c" /* yacc.c:1646  */
    break;

  case 967:
#line 7460 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_accept_mnemonic ((yyvsp[-2]), (yyvsp[0]));
  }
#line 13996 "parser.c" /* yacc.c:1646  */
    break;

  case 968:
#line 7464 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_accept_name ((yyvsp[-2]), (yyvsp[0]));
  }
#line 14004 "parser.c" /* yacc.c:1646  */
    break;

  case 969:
#line 7468 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("ACCEPT MESSAGE COUNT");
  }
#line 14012 "parser.c" /* yacc.c:1646  */
    break;

  case 971:
#line 7476 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_null;
  }
#line 14020 "parser.c" /* yacc.c:1646  */
    break;

  case 977:
#line 7494 "parser.y" /* yacc.c:1646  */
    {
	  check_repeated ("FROM CRT", SYN_CLAUSE_2, &check_duplicate);
  }
#line 14028 "parser.c" /* yacc.c:1646  */
    break;

  case 978:
#line 7498 "parser.y" /* yacc.c:1646  */
    {
	  check_repeated ("MODE IS BLOCK", SYN_CLAUSE_3, &check_duplicate);
  }
#line 14036 "parser.c" /* yacc.c:1646  */
    break;

  case 980:
#line 7503 "parser.y" /* yacc.c:1646  */
    {
	check_repeated (_("TIME-OUT or BEFORE TIME clauses"), SYN_CLAUSE_4,
			&check_duplicate);
	set_attribs (NULL, NULL, NULL, (yyvsp[0]), NULL, NULL, 0);
  }
#line 14046 "parser.c" /* yacc.c:1646  */
    break;

  case 983:
#line 7517 "parser.y" /* yacc.c:1646  */
    {
	set_attr_with_conflict ("LINE", SYN_CLAUSE_1,
				_("AT screen-location"), SYN_CLAUSE_3, 1,
				&check_line_col_duplicate);

	if ((CB_LITERAL_P ((yyvsp[0])) && cb_get_int ((yyvsp[0])) == 0) || (yyvsp[0]) == cb_zero) {
		cb_verify (cb_accept_display_extensions, "LINE 0");
	}

	if (!line_column) {
		line_column = CB_BUILD_PAIR ((yyvsp[0]), cb_int0);
	} else {
		CB_PAIR_X (line_column) = (yyvsp[0]);
	}
  }
#line 14066 "parser.c" /* yacc.c:1646  */
    break;

  case 984:
#line 7533 "parser.y" /* yacc.c:1646  */
    {
	set_attr_with_conflict ("COLUMN", SYN_CLAUSE_2,
				_("AT screen-location"), SYN_CLAUSE_3, 1,
				&check_line_col_duplicate);

	if ((CB_LITERAL_P ((yyvsp[0])) && cb_get_int ((yyvsp[0])) == 0) || (yyvsp[0]) == cb_zero) {
		cb_verify (cb_accept_display_extensions, "COLUMN 0");
	}

	if (!line_column) {
		line_column = CB_BUILD_PAIR (cb_int0, (yyvsp[0]));
	} else {
		CB_PAIR_Y (line_column) = (yyvsp[0]);
	}
  }
#line 14086 "parser.c" /* yacc.c:1646  */
    break;

  case 985:
#line 7549 "parser.y" /* yacc.c:1646  */
    {
	set_attr_with_conflict (_("AT screen-location"), SYN_CLAUSE_3,
				_("LINE or COLUMN"), SYN_CLAUSE_1 | SYN_CLAUSE_2,
				1, &check_line_col_duplicate);

	cb_verify (cb_accept_display_extensions, "AT clause");

	line_column = (yyvsp[0]);
  }
#line 14100 "parser.c" /* yacc.c:1646  */
    break;

  case 986:
#line 7561 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 14106 "parser.c" /* yacc.c:1646  */
    break;

  case 987:
#line 7565 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 14112 "parser.c" /* yacc.c:1646  */
    break;

  case 988:
#line 7566 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 14118 "parser.c" /* yacc.c:1646  */
    break;

  case 989:
#line 7571 "parser.y" /* yacc.c:1646  */
    {
	cobc_cs_check = 0;
  }
#line 14126 "parser.c" /* yacc.c:1646  */
    break;

  case 990:
#line 7578 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("AUTO", SYN_CLAUSE_5, &check_duplicate);
	set_dispattr_with_conflict ("AUTO", COB_SCREEN_AUTO,
				    "TAB", COB_SCREEN_TAB);
  }
#line 14136 "parser.c" /* yacc.c:1646  */
    break;

  case 991:
#line 7584 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("TAB", SYN_CLAUSE_6, &check_duplicate);
	set_dispattr_with_conflict ("TAB", COB_SCREEN_TAB,
				    "AUTO", COB_SCREEN_AUTO);
  }
#line 14146 "parser.c" /* yacc.c:1646  */
    break;

  case 992:
#line 7590 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("BELL", SYN_CLAUSE_7, &check_duplicate);
	set_dispattr (COB_SCREEN_BELL);
  }
#line 14155 "parser.c" /* yacc.c:1646  */
    break;

  case 993:
#line 7595 "parser.y" /* yacc.c:1646  */
    {
        check_repeated ("BLINK", SYN_CLAUSE_8, &check_duplicate);
	set_dispattr (COB_SCREEN_BLINK);
  }
#line 14164 "parser.c" /* yacc.c:1646  */
    break;

  case 994:
#line 7600 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("CONVERSION", SYN_CLAUSE_9, &check_duplicate);
	CB_PENDING ("ACCEPT CONVERSION");
  }
#line 14173 "parser.c" /* yacc.c:1646  */
    break;

  case 995:
#line 7605 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("FULL", SYN_CLAUSE_10, &check_duplicate);
	set_dispattr (COB_SCREEN_FULL);
  }
#line 14182 "parser.c" /* yacc.c:1646  */
    break;

  case 996:
#line 7610 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("HIGHLIGHT", SYN_CLAUSE_11, &check_duplicate);
	set_dispattr_with_conflict ("HIGHLIGHT", COB_SCREEN_HIGHLIGHT,
				    "LOWLIGHT", COB_SCREEN_LOWLIGHT);
  }
#line 14192 "parser.c" /* yacc.c:1646  */
    break;

  case 997:
#line 7616 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("LEFTLINE", SYN_CLAUSE_12, &check_duplicate);
	set_dispattr (COB_SCREEN_LEFTLINE);
  }
#line 14201 "parser.c" /* yacc.c:1646  */
    break;

  case 998:
#line 7621 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("LOWER", SYN_CLAUSE_13, &check_duplicate);
	set_dispattr_with_conflict ("LOWER", COB_SCREEN_LOWER,
				    "UPPER", COB_SCREEN_UPPER);
  }
#line 14211 "parser.c" /* yacc.c:1646  */
    break;

  case 999:
#line 7627 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("LOWLIGHT", SYN_CLAUSE_14, &check_duplicate);
	set_dispattr_with_conflict ("LOWLIGHT", COB_SCREEN_LOWLIGHT,
				    "HIGHLIGHT", COB_SCREEN_HIGHLIGHT);
  }
#line 14221 "parser.c" /* yacc.c:1646  */
    break;

  case 1000:
#line 7633 "parser.y" /* yacc.c:1646  */
    {
	if (cb_no_echo_means_secure) {
		check_repeated ("SECURE", SYN_CLAUSE_20, &check_duplicate);
		set_dispattr (COB_SCREEN_SECURE);
	} else {
		check_repeated ("NO-ECHO", SYN_CLAUSE_15, &check_duplicate);
		set_dispattr_with_conflict ("NO-ECHO", COB_SCREEN_NO_ECHO,
					    "SECURE", COB_SCREEN_SECURE);
	}
  }
#line 14236 "parser.c" /* yacc.c:1646  */
    break;

  case 1001:
#line 7644 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("OVERLINE", SYN_CLAUSE_16, &check_duplicate);
	set_dispattr (COB_SCREEN_OVERLINE);
  }
#line 14245 "parser.c" /* yacc.c:1646  */
    break;

  case 1002:
#line 7649 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("PROMPT", SYN_CLAUSE_17, &check_duplicate);
	set_attribs (NULL, NULL, NULL, NULL, (yyvsp[0]), NULL, COB_SCREEN_PROMPT);
  }
#line 14254 "parser.c" /* yacc.c:1646  */
    break;

  case 1003:
#line 7654 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("PROMPT", SYN_CLAUSE_17, &check_duplicate);
	set_dispattr (COB_SCREEN_PROMPT);
  }
#line 14263 "parser.c" /* yacc.c:1646  */
    break;

  case 1004:
#line 7659 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("REQUIRED", SYN_CLAUSE_18, &check_duplicate);
	set_dispattr (COB_SCREEN_REQUIRED);
  }
#line 14272 "parser.c" /* yacc.c:1646  */
    break;

  case 1005:
#line 7664 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("REVERSE-VIDEO", SYN_CLAUSE_19, &check_duplicate);
	set_dispattr (COB_SCREEN_REVERSE);
  }
#line 14281 "parser.c" /* yacc.c:1646  */
    break;

  case 1006:
#line 7669 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("SECURE", SYN_CLAUSE_20, &check_duplicate);
	set_dispattr_with_conflict ("SECURE", COB_SCREEN_SECURE,
				    "NO-ECHO", COB_SCREEN_NO_ECHO);
  }
#line 14291 "parser.c" /* yacc.c:1646  */
    break;

  case 1007:
#line 7675 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("SIZE", SYN_CLAUSE_21, &check_duplicate);
	set_attribs (NULL, NULL, NULL, NULL, NULL, (yyvsp[0]), 0);
  }
#line 14300 "parser.c" /* yacc.c:1646  */
    break;

  case 1008:
#line 7680 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("SIZE", SYN_CLAUSE_21, &check_duplicate);
	set_attribs (NULL, NULL, NULL, NULL, NULL, (yyvsp[0]), 0);
  }
#line 14309 "parser.c" /* yacc.c:1646  */
    break;

  case 1009:
#line 7685 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("UNDERLINE", SYN_CLAUSE_22, &check_duplicate);
	set_dispattr (COB_SCREEN_UNDERLINE);
  }
#line 14318 "parser.c" /* yacc.c:1646  */
    break;

  case 1010:
#line 7690 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("NO UPDATE", SYN_CLAUSE_23, &check_duplicate);
	set_dispattr_with_conflict ("NO UPDATE", COB_SCREEN_NO_UPDATE,
				    "UPDATE", COB_SCREEN_UPDATE);
  }
#line 14328 "parser.c" /* yacc.c:1646  */
    break;

  case 1011:
#line 7696 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("UPDATE", SYN_CLAUSE_24, &check_duplicate);
	set_dispattr_with_conflict ("UPDATE", COB_SCREEN_UPDATE,
				    "NO UPDATE", COB_SCREEN_NO_UPDATE);
  }
#line 14338 "parser.c" /* yacc.c:1646  */
    break;

  case 1012:
#line 7702 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("UPPER", SYN_CLAUSE_25, &check_duplicate);
	set_dispattr_with_conflict ("UPPER", COB_SCREEN_UPPER,
				    "LOWER", COB_SCREEN_LOWER);
  }
#line 14348 "parser.c" /* yacc.c:1646  */
    break;

  case 1013:
#line 7708 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("FOREGROUND-COLOR", SYN_CLAUSE_26, &check_duplicate);
	set_attribs ((yyvsp[0]), NULL, NULL, NULL, NULL, NULL, 0);
  }
#line 14357 "parser.c" /* yacc.c:1646  */
    break;

  case 1014:
#line 7713 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("BACKGROUND-COLOR", SYN_CLAUSE_27, &check_duplicate);
	set_attribs (NULL, (yyvsp[0]), NULL, NULL, NULL, NULL, 0);
  }
#line 14366 "parser.c" /* yacc.c:1646  */
    break;

  case 1015:
#line 7718 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("SCROLL UP", SYN_CLAUSE_28, &check_duplicate);
	set_attribs_with_conflict (NULL, NULL, (yyvsp[0]), NULL, NULL, NULL,
				   "SCROLL UP", COB_SCREEN_SCROLL_UP,
				   "SCROLL DOWN", COB_SCREEN_SCROLL_DOWN);
  }
#line 14377 "parser.c" /* yacc.c:1646  */
    break;

  case 1016:
#line 7725 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("SCROLL DOWN", SYN_CLAUSE_19, &check_duplicate);
	set_attribs_with_conflict (NULL, NULL, (yyvsp[0]), NULL, NULL, NULL,
				   "SCROLL DOWN", COB_SCREEN_SCROLL_DOWN,
				   "SCROLL UP", COB_SCREEN_SCROLL_UP);
  }
#line 14388 "parser.c" /* yacc.c:1646  */
    break;

  case 1017:
#line 7732 "parser.y" /* yacc.c:1646  */
    {
	check_repeated (_("TIME-OUT or BEFORE TIME clauses"), SYN_CLAUSE_4,
			&check_duplicate);
	set_attribs (NULL, NULL, NULL, (yyvsp[0]), NULL, NULL, 0);
  }
#line 14398 "parser.c" /* yacc.c:1646  */
    break;

  case 1026:
#line 7758 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-2) - (0)]), ACCEPT);
  }
#line 14406 "parser.c" /* yacc.c:1646  */
    break;

  case 1027:
#line 7762 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), ACCEPT);
# if 0 /* activate only for debugging purposes for attribs */
	if (current_statement->attr_ptr) {
		print_bits (current_statement->attr_ptr->dispattrs);
	} else {
		fprintf(stderr, "No Attribs\n");
	}
#endif
  }
#line 14421 "parser.c" /* yacc.c:1646  */
    break;

  case 1028:
#line 7779 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("ADD", TERM_ADD);
  }
#line 14429 "parser.c" /* yacc.c:1646  */
    break;

  case 1030:
#line 7788 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_arithmetic ((yyvsp[-1]), '+', cb_build_binary_list ((yyvsp[-3]), '+'));
  }
#line 14437 "parser.c" /* yacc.c:1646  */
    break;

  case 1031:
#line 7792 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_arithmetic ((yyvsp[-1]), 0, cb_build_binary_list ((yyvsp[-4]), '+'));
  }
#line 14445 "parser.c" /* yacc.c:1646  */
    break;

  case 1032:
#line 7796 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_corresponding (cb_build_add, (yyvsp[-2]), (yyvsp[-4]), (yyvsp[-1]));
  }
#line 14453 "parser.c" /* yacc.c:1646  */
    break;

  case 1033:
#line 7800 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("ADD TABLE");
	cb_emit_tab_arithmetic (cb_build_add, (yyvsp[-4]), (yyvsp[-6]), (yyvsp[-3]), (yyvsp[-2]), (yyvsp[-1]));
  }
#line 14462 "parser.c" /* yacc.c:1646  */
    break;

  case 1035:
#line 7808 "parser.y" /* yacc.c:1646  */
    {
	cb_list_add ((yyvsp[-2]), (yyvsp[0]));
  }
#line 14470 "parser.c" /* yacc.c:1646  */
    break;

  case 1036:
#line 7815 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-2) - (0)]), ADD);
  }
#line 14478 "parser.c" /* yacc.c:1646  */
    break;

  case 1037:
#line 7819 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), ADD);
  }
#line 14486 "parser.c" /* yacc.c:1646  */
    break;

  case 1038:
#line 7829 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("ALLOCATE", 0);
	cobc_cs_check = CB_CS_ALLOCATE;
	current_statement->flag_no_based = 1;
  }
#line 14496 "parser.c" /* yacc.c:1646  */
    break;

  case 1040:
#line 7839 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_allocate ((yyvsp[-2]), (yyvsp[0]), NULL, (yyvsp[-1]));
  }
#line 14504 "parser.c" /* yacc.c:1646  */
    break;

  case 1041:
#line 7843 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0]) == NULL) {
		cb_error_x (CB_TREE (current_statement),
			    _("ALLOCATE CHARACTERS requires RETURNING clause"));
	} else {
		cb_emit_allocate (NULL, (yyvsp[0]), (yyvsp[-3]), (yyvsp[-1]));
	}
  }
#line 14517 "parser.c" /* yacc.c:1646  */
    break;

  case 1042:
#line 7854 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 14523 "parser.c" /* yacc.c:1646  */
    break;

  case 1043:
#line 7855 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 14529 "parser.c" /* yacc.c:1646  */
    break;

  case 1044:
#line 7863 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("ALTER", 0);
	cb_verify (cb_alter_statement, "ALTER");
  }
#line 14538 "parser.c" /* yacc.c:1646  */
    break;

  case 1048:
#line 7877 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_alter ((yyvsp[-3]), (yyvsp[0]));
  }
#line 14546 "parser.c" /* yacc.c:1646  */
    break;

  case 1051:
#line 7889 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("CALL", TERM_CALL);
	cobc_cs_check = CB_CS_CALL;
	call_nothing = 0;
	cobc_allow_program_name = 1;
	call_line_number = cb_source_line;
  }
#line 14558 "parser.c" /* yacc.c:1646  */
    break;

  case 1053:
#line 7902 "parser.y" /* yacc.c:1646  */
    {
	cobc_allow_program_name = 0;
  }
#line 14566 "parser.c" /* yacc.c:1646  */
    break;

  case 1054:
#line 7909 "parser.y" /* yacc.c:1646  */
    {
	int call_conv = 0;

	if (current_program->prog_type == CB_PROGRAM_TYPE
	    && !current_program->flag_recursive
	    && is_recursive_call ((yyvsp[-5]))) {
		cb_warning_x (COBC_WARN_FILLER, (yyvsp[-5]), _("recursive program call - assuming RECURSIVE attribute"));
		current_program->flag_recursive = 1;
	}
	call_conv = current_call_convention;
	if ((yyvsp[-7])) {
		if (CB_INTEGER_P ((yyvsp[-7]))) {
			call_conv |= CB_INTEGER ((yyvsp[-7]))->val;
			if (CB_INTEGER ((yyvsp[-7]))->val & CB_CONV_COBOL) {
				call_conv &= ~CB_CONV_STDCALL;
			} else {
				call_conv &= ~CB_CONV_COBOL;
			}
		} else {
			call_conv = cb_get_int((yyvsp[-7]));
		}
	}
	/* For CALL ... RETURNING NOTHING, set the call convention bit */
	if (call_nothing) {
		call_conv |= CB_CONV_NO_RET_UPD;
	}
	cb_emit_call ((yyvsp[-5]), (yyvsp[-2]), (yyvsp[-1]), CB_PAIR_X ((yyvsp[0])), CB_PAIR_Y ((yyvsp[0])),
		      cb_int (call_conv), (yyvsp[-6]), (yyvsp[-3]));
  }
#line 14600 "parser.c" /* yacc.c:1646  */
    break;

  case 1055:
#line 7942 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
	cobc_cs_check = 0;
  }
#line 14609 "parser.c" /* yacc.c:1646  */
    break;

  case 1056:
#line 7947 "parser.y" /* yacc.c:1646  */
    {
	if (current_call_convention & CB_CONV_COBOL) {
		(yyval) = cb_int (CB_CONV_STATIC_LINK | CB_CONV_COBOL);
	} else {
		(yyval) = cb_int (CB_CONV_STATIC_LINK);
	}
	cobc_cs_check = 0;
  }
#line 14622 "parser.c" /* yacc.c:1646  */
    break;

  case 1057:
#line 7956 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int (CB_CONV_STDCALL);
	cobc_cs_check = 0;
  }
#line 14631 "parser.c" /* yacc.c:1646  */
    break;

  case 1058:
#line 7961 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int (0);
	cobc_cs_check = 0;
  }
#line 14640 "parser.c" /* yacc.c:1646  */
    break;

  case 1059:
#line 7966 "parser.y" /* yacc.c:1646  */
    {
	cb_tree		x;

	x = cb_ref ((yyvsp[0]));
	if (CB_VALID_TREE (x)) {
		if (CB_SYSTEM_NAME(x)->token != CB_FEATURE_CONVENTION) {
			cb_error_x ((yyvsp[0]), _("invalid mnemonic name"));
			(yyval) = NULL;
		} else {
			(yyval) = CB_SYSTEM_NAME(x)->value;
		}
	} else {
		(yyval) = NULL;
	}
	cobc_cs_check = 0;
  }
#line 14661 "parser.c" /* yacc.c:1646  */
    break;

  case 1060:
#line 7986 "parser.y" /* yacc.c:1646  */
    {
	if (CB_LITERAL_P ((yyvsp[0]))) {
		cb_trim_program_id ((yyvsp[0]));
	}
  }
#line 14671 "parser.c" /* yacc.c:1646  */
    break;

  case 1061:
#line 7992 "parser.y" /* yacc.c:1646  */
    {
	cb_verify (cb_program_prototypes, _("CALL/CANCEL with program-prototype-name"));
	/* hack to push the prototype name */
	if ((yyvsp[0]) && CB_REFERENCE_P ((yyvsp[0]))) {
		if ((yyvsp[-1])) {
			cb_warning_x (COBC_WARN_FILLER, (yyvsp[-1]), _("id/literal ignored, using prototype name"));
		}
		(yyval) = (yyvsp[0]);
	} else if ((yyvsp[-1]) && CB_LITERAL_P ((yyvsp[-1]))) {
		(yyval) = (yyvsp[-1]);
	} else {
		cb_error (_("NESTED phrase is only valid with literal"));
		(yyval) = cb_error_node;
	}
  }
#line 14691 "parser.c" /* yacc.c:1646  */
    break;

  case 1062:
#line 8011 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 14699 "parser.c" /* yacc.c:1646  */
    break;

  case 1063:
#line 8016 "parser.y" /* yacc.c:1646  */
    {
	if (CB_LITERAL_P ((yyvsp[-1]))) {
		cb_trim_program_id ((yyvsp[-1]));
	}
	(yyval) = (yyvsp[-1]);
  }
#line 14710 "parser.c" /* yacc.c:1646  */
    break;

  case 1064:
#line 8026 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("NESTED phrase for CALL statement");
  }
#line 14718 "parser.c" /* yacc.c:1646  */
    break;

  case 1066:
#line 8034 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 14726 "parser.c" /* yacc.c:1646  */
    break;

  case 1067:
#line 8038 "parser.y" /* yacc.c:1646  */
    {
	call_mode = CB_CALL_BY_REFERENCE;
	size_mode = CB_SIZE_4;
  }
#line 14735 "parser.c" /* yacc.c:1646  */
    break;

  case 1068:
#line 8043 "parser.y" /* yacc.c:1646  */
    {
	if (cb_list_length ((yyvsp[0])) > MAX_CALL_FIELD_PARAMS) {
		cb_error_x (CB_TREE (current_statement),
			    _("number of parameters exceeds maximum %d"),
			    MAX_CALL_FIELD_PARAMS);
	}
	(yyval) = (yyvsp[0]);
  }
#line 14748 "parser.c" /* yacc.c:1646  */
    break;

  case 1069:
#line 8054 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 14754 "parser.c" /* yacc.c:1646  */
    break;

  case 1070:
#line 8056 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_list_append ((yyvsp[-1]), (yyvsp[0])); }
#line 14760 "parser.c" /* yacc.c:1646  */
    break;

  case 1071:
#line 8061 "parser.y" /* yacc.c:1646  */
    {
	if (call_mode != CB_CALL_BY_REFERENCE) {
		cb_error_x (CB_TREE (current_statement),
			    _("OMITTED only allowed when parameters are passed BY REFERENCE"));
	}
	(yyval) = CB_BUILD_PAIR (cb_int (call_mode), cb_null);
  }
#line 14772 "parser.c" /* yacc.c:1646  */
    break;

  case 1072:
#line 8069 "parser.y" /* yacc.c:1646  */
    {
	int	save_mode;

	save_mode = call_mode;
	if (call_mode != CB_CALL_BY_REFERENCE) {
		if (CB_FILE_P ((yyvsp[0])) || (CB_REFERENCE_P ((yyvsp[0])) &&
		    CB_FILE_P (CB_REFERENCE ((yyvsp[0]))->value))) {
			cb_error_x (CB_TREE (current_statement),
				    _("invalid file name reference"));
		} else if (call_mode == CB_CALL_BY_VALUE) {
			if (cb_category_is_alpha ((yyvsp[0]))) {
				cb_warning_x (COBC_WARN_FILLER, (yyvsp[0]),
					      _("BY CONTENT assumed for alphanumeric item"));
				save_mode = CB_CALL_BY_CONTENT;
			}
		}
	}
	(yyval) = CB_BUILD_PAIR (cb_int (save_mode), (yyvsp[0]));
	CB_SIZES ((yyval)) = size_mode;
	call_mode = save_mode;
  }
#line 14798 "parser.c" /* yacc.c:1646  */
    break;

  case 1074:
#line 8095 "parser.y" /* yacc.c:1646  */
    {
	call_mode = CB_CALL_BY_REFERENCE;
  }
#line 14806 "parser.c" /* yacc.c:1646  */
    break;

  case 1075:
#line 8099 "parser.y" /* yacc.c:1646  */
    {
	if (current_program->flag_chained) {
		cb_error_x (CB_TREE (current_statement),
			    _("%s not allowed in CHAINED programs"), "BY CONTENT");
	} else {
		call_mode = CB_CALL_BY_CONTENT;
	}
  }
#line 14819 "parser.c" /* yacc.c:1646  */
    break;

  case 1076:
#line 8108 "parser.y" /* yacc.c:1646  */
    {
	if (current_program->flag_chained) {
		cb_error_x (CB_TREE (current_statement),
			    _("%s not allowed in CHAINED programs"), "BY VALUE");
	} else {
		call_mode = CB_CALL_BY_VALUE;
	}
  }
#line 14832 "parser.c" /* yacc.c:1646  */
    break;

  case 1077:
#line 8120 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 14840 "parser.c" /* yacc.c:1646  */
    break;

  case 1078:
#line 8124 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 14848 "parser.c" /* yacc.c:1646  */
    break;

  case 1079:
#line 8128 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_null;
  }
#line 14856 "parser.c" /* yacc.c:1646  */
    break;

  case 1080:
#line 8132 "parser.y" /* yacc.c:1646  */
    {
	call_nothing = CB_CONV_NO_RET_UPD;
	(yyval) = cb_null;
  }
#line 14865 "parser.c" /* yacc.c:1646  */
    break;

  case 1081:
#line 8137 "parser.y" /* yacc.c:1646  */
    {
	struct cb_field	*f;

	if (cb_ref ((yyvsp[0])) != cb_error_node) {
		f = CB_FIELD_PTR ((yyvsp[0]));
		if (f->level != 1 && f->level != 77) {
			cb_error (_("RETURNING item must have level 01 or 77"));
			(yyval) = NULL;
		} else if (f->storage != CB_STORAGE_LINKAGE &&
			   !f->flag_item_based) {
			cb_error (_("RETURNING item must be a LINKAGE SECTION item or have BASED clause"));
			(yyval) = NULL;
		} else {
			(yyval) = cb_build_address ((yyvsp[0]));
		}
	} else {
		(yyval) = NULL;
	}
  }
#line 14889 "parser.c" /* yacc.c:1646  */
    break;

  case 1086:
#line 8170 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_BUILD_PAIR (NULL, NULL);
  }
#line 14897 "parser.c" /* yacc.c:1646  */
    break;

  case 1087:
#line 8174 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_BUILD_PAIR ((yyvsp[-1]), (yyvsp[0]));
  }
#line 14905 "parser.c" /* yacc.c:1646  */
    break;

  case 1088:
#line 8178 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0])) {
		cb_verify (cb_not_exception_before_exception,
			_("NOT EXCEPTION before EXCEPTION"));
	}
	(yyval) = CB_BUILD_PAIR ((yyvsp[0]), (yyvsp[-1]));
  }
#line 14917 "parser.c" /* yacc.c:1646  */
    break;

  case 1089:
#line 8189 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 14925 "parser.c" /* yacc.c:1646  */
    break;

  case 1090:
#line 8193 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 14933 "parser.c" /* yacc.c:1646  */
    break;

  case 1091:
#line 8200 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 14941 "parser.c" /* yacc.c:1646  */
    break;

  case 1092:
#line 8204 "parser.y" /* yacc.c:1646  */
    {
	cb_verify (cb_call_overflow, "ON OVERFLOW");
	(yyval) = (yyvsp[0]);
  }
#line 14950 "parser.c" /* yacc.c:1646  */
    break;

  case 1093:
#line 8212 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 14958 "parser.c" /* yacc.c:1646  */
    break;

  case 1094:
#line 8216 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 14966 "parser.c" /* yacc.c:1646  */
    break;

  case 1095:
#line 8223 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 14974 "parser.c" /* yacc.c:1646  */
    break;

  case 1096:
#line 8230 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-2) - (0)]), CALL);
  }
#line 14982 "parser.c" /* yacc.c:1646  */
    break;

  case 1097:
#line 8234 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), CALL);
  }
#line 14990 "parser.c" /* yacc.c:1646  */
    break;

  case 1098:
#line 8244 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("CANCEL", 0);
	cobc_allow_program_name = 1;
  }
#line 14999 "parser.c" /* yacc.c:1646  */
    break;

  case 1099:
#line 8249 "parser.y" /* yacc.c:1646  */
    {
	cobc_allow_program_name = 0;
  }
#line 15007 "parser.c" /* yacc.c:1646  */
    break;

  case 1100:
#line 8256 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_cancel ((yyvsp[0]));
  }
#line 15015 "parser.c" /* yacc.c:1646  */
    break;

  case 1101:
#line 8260 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_cancel ((yyvsp[0]));
  }
#line 15023 "parser.c" /* yacc.c:1646  */
    break;

  case 1103:
#line 8268 "parser.y" /* yacc.c:1646  */
    {
	cb_verify (cb_program_prototypes, _("CALL/CANCEL with program-prototype-name"));
  }
#line 15031 "parser.c" /* yacc.c:1646  */
    break;

  case 1104:
#line 8277 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("CLOSE", 0);
  }
#line 15039 "parser.c" /* yacc.c:1646  */
    break;

  case 1108:
#line 8290 "parser.y" /* yacc.c:1646  */
    {
	begin_implicit_statement ();
	cb_emit_close ((yyvsp[-1]), (yyvsp[0]));
  }
#line 15048 "parser.c" /* yacc.c:1646  */
    break;

  case 1109:
#line 8295 "parser.y" /* yacc.c:1646  */
    {
	begin_implicit_statement ();
	cb_emit_close ((yyvsp[-1]), (yyvsp[0]));
  }
#line 15057 "parser.c" /* yacc.c:1646  */
    break;

  case 1110:
#line 8302 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (COB_CLOSE_NORMAL); }
#line 15063 "parser.c" /* yacc.c:1646  */
    break;

  case 1111:
#line 8303 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (COB_CLOSE_UNIT); }
#line 15069 "parser.c" /* yacc.c:1646  */
    break;

  case 1112:
#line 8304 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (COB_CLOSE_UNIT_REMOVAL); }
#line 15075 "parser.c" /* yacc.c:1646  */
    break;

  case 1113:
#line 8305 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (COB_CLOSE_NO_REWIND); }
#line 15081 "parser.c" /* yacc.c:1646  */
    break;

  case 1114:
#line 8306 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (COB_CLOSE_LOCK); }
#line 15087 "parser.c" /* yacc.c:1646  */
    break;

  case 1115:
#line 8311 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("GRAPHICAL WINDOW");
	current_statement->name = "DISPLAY WINDOW";
  }
#line 15096 "parser.c" /* yacc.c:1646  */
    break;

  case 1116:
#line 8316 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[-1])) {
		cb_emit_close_window ((yyvsp[-2]));
	} else {
		cb_emit_destroy ((yyvsp[-2]));
	}
  }
#line 15108 "parser.c" /* yacc.c:1646  */
    break;

  case 1117:
#line 8326 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 15114 "parser.c" /* yacc.c:1646  */
    break;

  case 1118:
#line 8327 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int0; }
#line 15120 "parser.c" /* yacc.c:1646  */
    break;

  case 1119:
#line 8335 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("COMPUTE", TERM_COMPUTE);
  }
#line 15128 "parser.c" /* yacc.c:1646  */
    break;

  case 1121:
#line 8344 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_arithmetic ((yyvsp[-3]), 0, (yyvsp[-1]));
  }
#line 15136 "parser.c" /* yacc.c:1646  */
    break;

  case 1122:
#line 8351 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-2) - (0)]), COMPUTE);
  }
#line 15144 "parser.c" /* yacc.c:1646  */
    break;

  case 1123:
#line 8355 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), COMPUTE);
  }
#line 15152 "parser.c" /* yacc.c:1646  */
    break;

  case 1124:
#line 8365 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("COMMIT", 0);
	cb_emit_commit ();
  }
#line 15161 "parser.c" /* yacc.c:1646  */
    break;

  case 1125:
#line 8376 "parser.y" /* yacc.c:1646  */
    {
	size_t	save_unreached;

	/* Do not check unreached for CONTINUE */
	save_unreached = check_unreached;
	check_unreached = 0;
	begin_statement ("CONTINUE", 0);
	cb_emit_continue ();
	check_unreached = (unsigned int) save_unreached;
  }
#line 15176 "parser.c" /* yacc.c:1646  */
    break;

  case 1126:
#line 8393 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("DESTROY", 0);
	CB_PENDING ("GRAPHICAL CONTROL");
  }
#line 15185 "parser.c" /* yacc.c:1646  */
    break;

  case 1128:
#line 8402 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_destroy (NULL);
  }
#line 15193 "parser.c" /* yacc.c:1646  */
    break;

  case 1129:
#line 8409 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_destroy ((yyvsp[0]));
  }
#line 15201 "parser.c" /* yacc.c:1646  */
    break;

  case 1130:
#line 8419 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("DELETE", TERM_DELETE);
  }
#line 15209 "parser.c" /* yacc.c:1646  */
    break;

  case 1132:
#line 8428 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_delete ((yyvsp[-3]));
  }
#line 15217 "parser.c" /* yacc.c:1646  */
    break;

  case 1134:
#line 8436 "parser.y" /* yacc.c:1646  */
    {
	begin_implicit_statement ();
	cb_emit_delete_file ((yyvsp[0]));
  }
#line 15226 "parser.c" /* yacc.c:1646  */
    break;

  case 1135:
#line 8441 "parser.y" /* yacc.c:1646  */
    {
	begin_implicit_statement ();
	cb_emit_delete_file ((yyvsp[0]));
  }
#line 15235 "parser.c" /* yacc.c:1646  */
    break;

  case 1136:
#line 8449 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-2) - (0)]), DELETE);
  }
#line 15243 "parser.c" /* yacc.c:1646  */
    break;

  case 1137:
#line 8453 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), DELETE);
  }
#line 15251 "parser.c" /* yacc.c:1646  */
    break;

  case 1138:
#line 8463 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("DISABLE", 0);
  }
#line 15259 "parser.c" /* yacc.c:1646  */
    break;

  case 1142:
#line 8477 "parser.y" /* yacc.c:1646  */
    {
	  /* Add cb_verify for <= COBOL-85 */
  }
#line 15267 "parser.c" /* yacc.c:1646  */
    break;

  case 1148:
#line 8495 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("DISPLAY", TERM_DISPLAY);
	cobc_cs_check = CB_CS_DISPLAY;
	display_type = UNKNOWN_DISPLAY;
	is_first_display_item = 1;
  }
#line 15278 "parser.c" /* yacc.c:1646  */
    break;

  case 1150:
#line 8507 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_env_name ((yyvsp[-2]));
  }
#line 15286 "parser.c" /* yacc.c:1646  */
    break;

  case 1151:
#line 8511 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_env_value ((yyvsp[-2]));
  }
#line 15294 "parser.c" /* yacc.c:1646  */
    break;

  case 1152:
#line 8515 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_arg_number ((yyvsp[-2]));
  }
#line 15302 "parser.c" /* yacc.c:1646  */
    break;

  case 1153:
#line 8519 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_command_line ((yyvsp[-2]));
  }
#line 15310 "parser.c" /* yacc.c:1646  */
    break;

  case 1158:
#line 8530 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0]) != NULL) {
		error_if_different_display_type ((yyvsp[0]), NULL, NULL, NULL);
		cb_emit_display ((yyvsp[0]), NULL, cb_int1, NULL, NULL, 0,
				 display_type);
	}
  }
#line 15322 "parser.c" /* yacc.c:1646  */
    break;

  case 1159:
#line 8538 "parser.y" /* yacc.c:1646  */
    {
	set_display_type ((yyvsp[0]), NULL, NULL, NULL);
	cb_emit_display ((yyvsp[0]), NULL, cb_int1, NULL, NULL, 1,
			 display_type);
  }
#line 15332 "parser.c" /* yacc.c:1646  */
    break;

  case 1162:
#line 8552 "parser.y" /* yacc.c:1646  */
    {
	check_duplicate = 0;
	check_line_col_duplicate = 0;
	advancing_value = cb_int1;
	upon_value = NULL;
	line_column = NULL;
  }
#line 15344 "parser.c" /* yacc.c:1646  */
    break;

  case 1163:
#line 8560 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[-2]) == cb_null) {
		/* Emit DISPLAY OMITTED. */
		CB_UNFINISHED ("DISPLAY OMITTED");
		error_if_no_advancing_in_screen_display (advancing_value);
		(yyvsp[-2]) = cb_low;
	}

	/* Emit device or screen DISPLAY. */

	/*
	  Check that disp_list does not contain an invalid mix of fields.
	*/
	if (display_type == UNKNOWN_DISPLAY) {
		set_display_type ((yyvsp[-2]), upon_value, line_column,
				  current_statement->attr_ptr);
	} else {
		error_if_different_display_type ((yyvsp[-2]), upon_value,
						 line_column,
						 current_statement->attr_ptr);
	}

	if (display_type == SCREEN_DISPLAY
	    || display_type == FIELD_ON_SCREEN_DISPLAY) {
		error_if_no_advancing_in_screen_display (advancing_value);
	}

	cb_emit_display ((yyvsp[-2]), upon_value, advancing_value, line_column,
			 current_statement->attr_ptr,
			 is_first_display_item, display_type);

	is_first_display_item = 0;
  }
#line 15382 "parser.c" /* yacc.c:1646  */
    break;

  case 1164:
#line 8597 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 15390 "parser.c" /* yacc.c:1646  */
    break;

  case 1165:
#line 8601 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("DISPLAY OMITTED");
	(yyval) = cb_null;
  }
#line 15399 "parser.c" /* yacc.c:1646  */
    break;

  case 1168:
#line 8614 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("UPON", SYN_CLAUSE_1, &check_duplicate);
  }
#line 15407 "parser.c" /* yacc.c:1646  */
    break;

  case 1169:
#line 8618 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("NO ADVANCING", SYN_CLAUSE_2, &check_duplicate);
	advancing_value = cb_int0;
  }
#line 15416 "parser.c" /* yacc.c:1646  */
    break;

  case 1170:
#line 8623 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("MODE IS BLOCK", SYN_CLAUSE_3, &check_duplicate);
  }
#line 15424 "parser.c" /* yacc.c:1646  */
    break;

  case 1173:
#line 8632 "parser.y" /* yacc.c:1646  */
    {
	upon_value = cb_build_display_mnemonic ((yyvsp[0]));
  }
#line 15432 "parser.c" /* yacc.c:1646  */
    break;

  case 1174:
#line 8636 "parser.y" /* yacc.c:1646  */
    {
	upon_value = cb_build_display_name ((yyvsp[0]));
  }
#line 15440 "parser.c" /* yacc.c:1646  */
    break;

  case 1175:
#line 8640 "parser.y" /* yacc.c:1646  */
    {
	upon_value = cb_int0;
  }
#line 15448 "parser.c" /* yacc.c:1646  */
    break;

  case 1176:
#line 8644 "parser.y" /* yacc.c:1646  */
    {
	upon_value = cb_null;
  }
#line 15456 "parser.c" /* yacc.c:1646  */
    break;

  case 1179:
#line 8656 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("GRAPHICAL WINDOW");
	current_statement->name = "DISPLAY WINDOW";
  }
#line 15465 "parser.c" /* yacc.c:1646  */
    break;

  case 1180:
#line 8661 "parser.y" /* yacc.c:1646  */
    {
	check_duplicate = 0;
	check_line_col_duplicate = 0;
	line_column = NULL;
	upon_value = NULL; /* Hack: stores the POP-UP AREA */
  }
#line 15476 "parser.c" /* yacc.c:1646  */
    break;

  case 1181:
#line 8668 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_display_window (NULL, upon_value, (yyvsp[-3]), line_column,
			 current_statement->attr_ptr);
  }
#line 15485 "parser.c" /* yacc.c:1646  */
    break;

  case 1184:
#line 8681 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("GRAPHICAL WINDOW");
	current_statement->name = "DISPLAY FLOATING WINDOW";
  }
#line 15494 "parser.c" /* yacc.c:1646  */
    break;

  case 1185:
#line 8686 "parser.y" /* yacc.c:1646  */
    {
	check_duplicate = 0;
	check_line_col_duplicate = 0;
	line_column = NULL;
	upon_value = NULL; /* Hack: stores the POP-UP AREA */
  }
#line 15505 "parser.c" /* yacc.c:1646  */
    break;

  case 1186:
#line 8693 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[-5])) {
		/* TODO: set "CELL WIDTH" and "CELL HEIGHT" to "LABEL FONT" */
		/* if not set already */
	}
	cb_emit_display_window (cb_int0, upon_value, (yyvsp[-3]), line_column,
			 current_statement->attr_ptr);
  }
#line 15518 "parser.c" /* yacc.c:1646  */
    break;

  case 1187:
#line 8705 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("GRAPHICAL WINDOW");
	current_statement->name = "DISPLAY INITIAL WINDOW";
	check_duplicate = 0;
	check_line_col_duplicate = 0;
	line_column = NULL;
	upon_value = NULL; /* Hack: stores the POP-UP AREA */
  }
#line 15531 "parser.c" /* yacc.c:1646  */
    break;

  case 1188:
#line 8714 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[-3])) {
		/* TODO: set "CELL WIDTH" and "CELL HEIGHT" to "LABEL FONT" */
		/* if not set already */
	}
	cb_emit_display_window ((yyvsp[-4]), upon_value, NULL, line_column,
			 current_statement->attr_ptr);
  }
#line 15544 "parser.c" /* yacc.c:1646  */
    break;

  case 1189:
#line 8725 "parser.y" /* yacc.c:1646  */
    {(yyval) = cb_int1;}
#line 15550 "parser.c" /* yacc.c:1646  */
    break;

  case 1190:
#line 8726 "parser.y" /* yacc.c:1646  */
    {(yyval) = cb_int2;}
#line 15556 "parser.c" /* yacc.c:1646  */
    break;

  case 1191:
#line 8727 "parser.y" /* yacc.c:1646  */
    {(yyval) = cb_int3;}
#line 15562 "parser.c" /* yacc.c:1646  */
    break;

  case 1192:
#line 8731 "parser.y" /* yacc.c:1646  */
    {(yyval) = NULL;}
#line 15568 "parser.c" /* yacc.c:1646  */
    break;

  case 1193:
#line 8732 "parser.y" /* yacc.c:1646  */
    {(yyval) = cb_int1;}
#line 15574 "parser.c" /* yacc.c:1646  */
    break;

  case 1194:
#line 8737 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 15582 "parser.c" /* yacc.c:1646  */
    break;

  case 1195:
#line 8741 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 15590 "parser.c" /* yacc.c:1646  */
    break;

  case 1199:
#line 8756 "parser.y" /* yacc.c:1646  */
    {
	/* TODO: store */
  }
#line 15598 "parser.c" /* yacc.c:1646  */
    break;

  case 1204:
#line 8770 "parser.y" /* yacc.c:1646  */
    {
	if (upon_value) {
		emit_duplicate_clause_message("POP-UP AREA");
	}
	upon_value = (yyvsp[0]);
  }
#line 15609 "parser.c" /* yacc.c:1646  */
    break;

  case 1205:
#line 8780 "parser.y" /* yacc.c:1646  */
    {
	if (strcmp (current_statement->name, "DISPLAY WINDOW")) {
		cb_error_x ((yyvsp[-2]), _("HANDLE clause invalid for %s"), 
			current_statement->name);
		upon_value = cb_error_node;
	} else{
		if (upon_value) {
			emit_duplicate_clause_message("POP-UP AREA / HANDLE IN");
		}
		upon_value = (yyvsp[0]);
	}
  }
#line 15626 "parser.c" /* yacc.c:1646  */
    break;

  case 1206:
#line 8796 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("BELL", SYN_CLAUSE_4, &check_duplicate);
	set_dispattr (COB_SCREEN_BELL);
  }
#line 15635 "parser.c" /* yacc.c:1646  */
    break;

  case 1207:
#line 8801 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("BLANK LINE", SYN_CLAUSE_5, &check_duplicate);
	set_dispattr_with_conflict ("BLANK LINE", COB_SCREEN_BLANK_LINE,
				    "BLANK SCREEN", COB_SCREEN_BLANK_SCREEN);
  }
#line 15645 "parser.c" /* yacc.c:1646  */
    break;

  case 1208:
#line 8807 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("BLANK SCREEN", SYN_CLAUSE_6, &check_duplicate);
	set_dispattr_with_conflict ("BLANK SCREEN", COB_SCREEN_BLANK_SCREEN,
				    "BLANK LINE", COB_SCREEN_BLANK_LINE);
  }
#line 15655 "parser.c" /* yacc.c:1646  */
    break;

  case 1209:
#line 8813 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("BLINK", SYN_CLAUSE_7, &check_duplicate);
	set_dispattr (COB_SCREEN_BLINK);
  }
#line 15664 "parser.c" /* yacc.c:1646  */
    break;

  case 1210:
#line 8818 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("CONVERSION", SYN_CLAUSE_8, &check_duplicate);
	cb_warning (COBC_WARN_FILLER, _("ignoring CONVERSION"));
  }
#line 15673 "parser.c" /* yacc.c:1646  */
    break;

  case 1211:
#line 8823 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("ERASE EOL", SYN_CLAUSE_9, &check_duplicate);
	set_dispattr_with_conflict ("ERASE EOL", COB_SCREEN_ERASE_EOL,
				    "ERASE EOS", COB_SCREEN_ERASE_EOS);
  }
#line 15683 "parser.c" /* yacc.c:1646  */
    break;

  case 1212:
#line 8829 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("ERASE EOS", SYN_CLAUSE_10, &check_duplicate);
	set_dispattr_with_conflict ("ERASE EOS", COB_SCREEN_ERASE_EOS,
				    "ERASE EOL", COB_SCREEN_ERASE_EOL);
  }
#line 15693 "parser.c" /* yacc.c:1646  */
    break;

  case 1213:
#line 8835 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("HIGHLIGHT", SYN_CLAUSE_11, &check_duplicate);
	set_dispattr_with_conflict ("HIGHLIGHT", COB_SCREEN_HIGHLIGHT,
				    "LOWLIGHT", COB_SCREEN_LOWLIGHT);
  }
#line 15703 "parser.c" /* yacc.c:1646  */
    break;

  case 1214:
#line 8841 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("LOWLIGHT", SYN_CLAUSE_12, &check_duplicate);
	set_dispattr_with_conflict ("LOWLIGHT", COB_SCREEN_LOWLIGHT,
				    "HIGHLIGHT", COB_SCREEN_HIGHLIGHT);
  }
#line 15713 "parser.c" /* yacc.c:1646  */
    break;

  case 1215:
#line 8847 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("OVERLINE", SYN_CLAUSE_13, &check_duplicate);
	set_dispattr (COB_SCREEN_OVERLINE);
  }
#line 15722 "parser.c" /* yacc.c:1646  */
    break;

  case 1216:
#line 8852 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("REVERSE-VIDEO", SYN_CLAUSE_14, &check_duplicate);
	set_dispattr (COB_SCREEN_REVERSE);
  }
#line 15731 "parser.c" /* yacc.c:1646  */
    break;

  case 1217:
#line 8857 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("SIZE", SYN_CLAUSE_15, &check_duplicate);
	set_attribs (NULL, NULL, NULL, NULL, NULL, (yyvsp[0]), 0);
  }
#line 15740 "parser.c" /* yacc.c:1646  */
    break;

  case 1218:
#line 8862 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("UNDERLINE", SYN_CLAUSE_16, &check_duplicate);
	set_dispattr (COB_SCREEN_UNDERLINE);
  }
#line 15749 "parser.c" /* yacc.c:1646  */
    break;

  case 1219:
#line 8867 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("FOREGROUND-COLOR", SYN_CLAUSE_17, &check_duplicate);
	set_attribs ((yyvsp[0]), NULL, NULL, NULL, NULL, NULL, 0);
  }
#line 15758 "parser.c" /* yacc.c:1646  */
    break;

  case 1220:
#line 8872 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("BACKGROUND-COLOR", SYN_CLAUSE_18, &check_duplicate);
	set_attribs (NULL, (yyvsp[0]), NULL, NULL, NULL, NULL, 0);
  }
#line 15767 "parser.c" /* yacc.c:1646  */
    break;

  case 1221:
#line 8877 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("SCROLL UP", SYN_CLAUSE_19, &check_duplicate);
	set_attribs_with_conflict (NULL, NULL, (yyvsp[0]), NULL, NULL, NULL,
				   "SCROLL UP", COB_SCREEN_SCROLL_UP,
				   "SCROLL DOWN", COB_SCREEN_SCROLL_DOWN);
  }
#line 15778 "parser.c" /* yacc.c:1646  */
    break;

  case 1222:
#line 8884 "parser.y" /* yacc.c:1646  */
    {
	check_repeated ("SCROLL DOWN", SYN_CLAUSE_20, &check_duplicate);
	set_attribs_with_conflict (NULL, NULL, (yyvsp[0]), NULL, NULL, NULL,
				   "SCROLL DOWN", COB_SCREEN_SCROLL_DOWN,
				   "SCROLL UP", COB_SCREEN_SCROLL_UP);
  }
#line 15789 "parser.c" /* yacc.c:1646  */
    break;

  case 1223:
#line 8894 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-2) - (0)]), DISPLAY);
  }
#line 15797 "parser.c" /* yacc.c:1646  */
    break;

  case 1224:
#line 8898 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), DISPLAY);
  }
#line 15805 "parser.c" /* yacc.c:1646  */
    break;

  case 1225:
#line 8908 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("DIVIDE", TERM_DIVIDE);
  }
#line 15813 "parser.c" /* yacc.c:1646  */
    break;

  case 1227:
#line 8917 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_arithmetic ((yyvsp[-1]), '/', (yyvsp[-3]));
  }
#line 15821 "parser.c" /* yacc.c:1646  */
    break;

  case 1228:
#line 8921 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_arithmetic ((yyvsp[-1]), 0, cb_build_binary_op ((yyvsp[-3]), '/', (yyvsp[-5])));
  }
#line 15829 "parser.c" /* yacc.c:1646  */
    break;

  case 1229:
#line 8925 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_arithmetic ((yyvsp[-1]), 0, cb_build_binary_op ((yyvsp[-5]), '/', (yyvsp[-3])));
  }
#line 15837 "parser.c" /* yacc.c:1646  */
    break;

  case 1230:
#line 8929 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_divide ((yyvsp[-5]), (yyvsp[-7]), (yyvsp[-3]), (yyvsp[-1]));
  }
#line 15845 "parser.c" /* yacc.c:1646  */
    break;

  case 1231:
#line 8933 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_divide ((yyvsp[-7]), (yyvsp[-5]), (yyvsp[-3]), (yyvsp[-1]));
  }
#line 15853 "parser.c" /* yacc.c:1646  */
    break;

  case 1232:
#line 8940 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-2) - (0)]), DIVIDE);
  }
#line 15861 "parser.c" /* yacc.c:1646  */
    break;

  case 1233:
#line 8944 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), DIVIDE);
  }
#line 15869 "parser.c" /* yacc.c:1646  */
    break;

  case 1234:
#line 8954 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("ENABLE", 0);
  }
#line 15877 "parser.c" /* yacc.c:1646  */
    break;

  case 1236:
#line 8965 "parser.y" /* yacc.c:1646  */
    {
	check_unreached = 0;
	begin_statement ("ENTRY", 0);
  }
#line 15886 "parser.c" /* yacc.c:1646  */
    break;

  case 1238:
#line 8974 "parser.y" /* yacc.c:1646  */
    {
	if (current_program->nested_level) {
		cb_error (_("%s is invalid in nested program"), "ENTRY");
	} else if (current_program->prog_type == CB_FUNCTION_TYPE) {
		cb_error (_("%s is invalid in a user FUNCTION"), "ENTRY");
	} else if (cb_verify (cb_entry_statement, "ENTRY")) {
		if (!cobc_check_valid_name ((char *)(CB_LITERAL ((yyvsp[-1]))->data), ENTRY_NAME)) {
			emit_entry ((char *)(CB_LITERAL ((yyvsp[-1]))->data), 1, (yyvsp[0]), (yyvsp[-2]));
		}
	}
  }
#line 15902 "parser.c" /* yacc.c:1646  */
    break;

  case 1239:
#line 8992 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("EVALUATE", TERM_EVALUATE);
	eval_level++;
	if (eval_level >= EVAL_DEPTH) {
		cb_error (_("maximum evaluate depth exceeded (%d)"),
			  EVAL_DEPTH);
		eval_level = 0;
		eval_inc = 0;
		eval_inc2 = 0;
		YYERROR;
	} else {
		for (eval_inc = 0; eval_inc < EVAL_DEPTH; ++eval_inc) {
			eval_check[eval_level][eval_inc] = NULL;
		}
		eval_inc = 0;
		eval_inc2 = 0;
	}
  }
#line 15925 "parser.c" /* yacc.c:1646  */
    break;

  case 1241:
#line 9016 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_evaluate ((yyvsp[-1]), (yyvsp[0]));
	eval_level--;
  }
#line 15934 "parser.c" /* yacc.c:1646  */
    break;

  case 1242:
#line 9023 "parser.y" /* yacc.c:1646  */
    { (yyval) = CB_LIST_INIT ((yyvsp[0])); }
#line 15940 "parser.c" /* yacc.c:1646  */
    break;

  case 1243:
#line 9025 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_list_add ((yyvsp[-2]), (yyvsp[0])); }
#line 15946 "parser.c" /* yacc.c:1646  */
    break;

  case 1244:
#line 9030 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
	eval_check[eval_level][eval_inc++] = (yyvsp[0]);
	if (eval_inc >= EVAL_DEPTH) {
		cb_error (_("maximum evaluate depth exceeded (%d)"),
			  EVAL_DEPTH);
		eval_inc = 0;
		YYERROR;
	}
  }
#line 15961 "parser.c" /* yacc.c:1646  */
    break;

  case 1245:
#line 9041 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_true;
	eval_check[eval_level][eval_inc++] = NULL;
	if (eval_inc >= EVAL_DEPTH) {
		cb_error (_("maximum evaluate depth exceeded (%d)"),
			  EVAL_DEPTH);
		eval_inc = 0;
		YYERROR;
	}
  }
#line 15976 "parser.c" /* yacc.c:1646  */
    break;

  case 1246:
#line 9052 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_false;
	eval_check[eval_level][eval_inc++] = NULL;
	if (eval_inc >= EVAL_DEPTH) {
		cb_error (_("maximum evaluate depth exceeded (%d)"),
			  EVAL_DEPTH);
		eval_inc = 0;
		YYERROR;
	}
  }
#line 15991 "parser.c" /* yacc.c:1646  */
    break;

  case 1247:
#line 9066 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_list_add ((yyvsp[-1]), (yyvsp[0]));
  }
#line 15999 "parser.c" /* yacc.c:1646  */
    break;

  case 1248:
#line 9071 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 16007 "parser.c" /* yacc.c:1646  */
    break;

  case 1249:
#line 9077 "parser.y" /* yacc.c:1646  */
    { (yyval) = CB_LIST_INIT ((yyvsp[0])); }
#line 16013 "parser.c" /* yacc.c:1646  */
    break;

  case 1250:
#line 9079 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_list_add ((yyvsp[-1]), (yyvsp[0])); }
#line 16019 "parser.c" /* yacc.c:1646  */
    break;

  case 1251:
#line 9085 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_BUILD_CHAIN ((yyvsp[0]), (yyvsp[-1]));
	eval_inc2 = 0;
  }
#line 16028 "parser.c" /* yacc.c:1646  */
    break;

  case 1252:
#line 9094 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_BUILD_CHAIN ((yyvsp[0]), NULL);
	eval_inc2 = 0;
  }
#line 16037 "parser.c" /* yacc.c:1646  */
    break;

  case 1253:
#line 9102 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_LIST_INIT ((yyvsp[0]));
	eval_inc2 = 0;
  }
#line 16046 "parser.c" /* yacc.c:1646  */
    break;

  case 1254:
#line 9108 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_list_add ((yyvsp[-2]), (yyvsp[0]));
	eval_inc2 = 0;
  }
#line 16055 "parser.c" /* yacc.c:1646  */
    break;

  case 1255:
#line 9115 "parser.y" /* yacc.c:1646  */
    { (yyval) = CB_LIST_INIT ((yyvsp[0])); }
#line 16061 "parser.c" /* yacc.c:1646  */
    break;

  case 1256:
#line 9117 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_list_add ((yyvsp[-2]), (yyvsp[0])); }
#line 16067 "parser.c" /* yacc.c:1646  */
    break;

  case 1257:
#line 9122 "parser.y" /* yacc.c:1646  */
    {
	cb_tree	not0;
	cb_tree	e1;
	cb_tree	e2;
	cb_tree	x;
	cb_tree	parm1;

	not0 = cb_int0;
	e2 = (yyvsp[0]);
	x = NULL;
	parm1 = (yyvsp[-1]);
	if (eval_check[eval_level][eval_inc2]) {
		/* Check if the first token is NOT */
		/* It may belong to the EVALUATE, however see */
		/* below when it may be part of a partial expression */
		if (CB_PURPOSE_INT (parm1) == '!') {
			/* Pop stack if subject not TRUE / FALSE */
			not0 = cb_int1;
			x = parm1;
			parm1 = CB_CHAIN (parm1);
		}
		/* Partial expression handling */
		switch (CB_PURPOSE_INT (parm1)) {
		/* Relational conditions */
		case '<':
		case '>':
		case '[':
		case ']':
		case '~':
		case '=':
		/* Class conditions */
		case '9':
		case 'A':
		case 'L':
		case 'U':
		case 'P':
		case 'N':
		case 'O':
		case 'C':
			if (e2) {
				cb_error_x (e2, _("invalid THROUGH usage"));
				e2 = NULL;
			}
			not0 = CB_PURPOSE (parm1);
			if (x) {
				/* Rebind the NOT to the partial expression */
				parm1 = cb_build_list (cb_int ('!'), NULL, parm1);
			}
			/* Insert subject at head of list */
			parm1 = cb_build_list (cb_int ('x'),
					    eval_check[eval_level][eval_inc2], parm1);
			break;
		}
	}

	/* Build expr now */
	e1 = cb_build_expr (parm1);
	cb_terminate_cond ();
	cb_end_cond (e1);
	cb_save_cond ();
	cb_true_side ();

	eval_inc2++;
	(yyval) = CB_BUILD_PAIR (not0, CB_BUILD_PAIR (e1, e2));
  }
#line 16137 "parser.c" /* yacc.c:1646  */
    break;

  case 1258:
#line 9187 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_any; eval_inc2++; }
#line 16143 "parser.c" /* yacc.c:1646  */
    break;

  case 1259:
#line 9188 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_true; eval_inc2++; }
#line 16149 "parser.c" /* yacc.c:1646  */
    break;

  case 1260:
#line 9189 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_false; eval_inc2++; }
#line 16155 "parser.c" /* yacc.c:1646  */
    break;

  case 1261:
#line 9193 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 16161 "parser.c" /* yacc.c:1646  */
    break;

  case 1262:
#line 9194 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 16167 "parser.c" /* yacc.c:1646  */
    break;

  case 1263:
#line 9199 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-2) - (0)]), EVALUATE);
  }
#line 16175 "parser.c" /* yacc.c:1646  */
    break;

  case 1264:
#line 9203 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), EVALUATE);
  }
#line 16183 "parser.c" /* yacc.c:1646  */
    break;

  case 1265:
#line 9213 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("EXIT", 0);
	cobc_cs_check = CB_CS_EXIT;
  }
#line 16192 "parser.c" /* yacc.c:1646  */
    break;

  case 1266:
#line 9218 "parser.y" /* yacc.c:1646  */
    {
	cobc_cs_check = 0;
  }
#line 16200 "parser.c" /* yacc.c:1646  */
    break;

  case 1268:
#line 9227 "parser.y" /* yacc.c:1646  */
    {
	if (in_declaratives && use_global_ind) {
		cb_error_x (CB_TREE (current_statement),
			    _("EXIT PROGRAM is not allowed within a USE GLOBAL procedure"));
	}
	if (current_program->prog_type != CB_PROGRAM_TYPE) {
		cb_error_x (CB_TREE (current_statement),
			    _("EXIT PROGRAM not allowed within a FUNCTION"));
	}
	if (current_program->flag_main) {
		check_unreached = 0;
	} else {
		check_unreached = 1;
	}
	if ((yyvsp[0])) {
		if (!current_program->cb_return_code) {
			cb_error_x ((yyvsp[0]), _("RETURNING/GIVING not allowed for non-returning sources"));
		} else {
			cb_emit_move ((yyvsp[0]), CB_LIST_INIT (current_program->cb_return_code));
		}
	}
	current_statement->name = (const char *)"EXIT PROGRAM";
	cb_emit_exit (0);
  }
#line 16229 "parser.c" /* yacc.c:1646  */
    break;

  case 1269:
#line 9252 "parser.y" /* yacc.c:1646  */
    {
	if (in_declaratives && use_global_ind) {
		cb_error_x (CB_TREE (current_statement),
			    _("EXIT FUNCTION is not allowed within a USE GLOBAL procedure"));
	}
	if (current_program->prog_type != CB_FUNCTION_TYPE) {
		cb_error_x (CB_TREE (current_statement),
			    _("EXIT FUNCTION only allowed within a FUNCTION"));
	}
	check_unreached = 1;
	current_statement->name = (const char *)"EXIT FUNCTION";
	cb_emit_exit (0);
  }
#line 16247 "parser.c" /* yacc.c:1646  */
    break;

  case 1270:
#line 9266 "parser.y" /* yacc.c:1646  */
    {
	struct cb_perform	*p;
	cb_tree			plabel;
	char			name[64];

	if (!perform_stack) {
		cb_error_x (CB_TREE (current_statement),
			    _("EXIT PERFORM is only valid with inline PERFORM"));
	} else if (CB_VALUE (perform_stack) != cb_error_node) {
		p = CB_PERFORM (CB_VALUE (perform_stack));
		if (!p->cycle_label) {
			sprintf (name, "EXIT PERFORM CYCLE %d", cb_id);
			p->cycle_label = cb_build_reference (name);
			plabel = cb_build_label (p->cycle_label, NULL);
			CB_LABEL (plabel)->flag_begin = 1;
			CB_LABEL (plabel)->flag_dummy_exit = 1;
		}
		current_statement->name = (const char *)"EXIT PERFORM CYCLE";
		cb_emit_goto (CB_LIST_INIT (p->cycle_label), NULL);
	}
  }
#line 16273 "parser.c" /* yacc.c:1646  */
    break;

  case 1271:
#line 9288 "parser.y" /* yacc.c:1646  */
    {
	struct cb_perform	*p;
	cb_tree			plabel;
	char			name[64];

	if (!perform_stack) {
		cb_error_x (CB_TREE (current_statement),
			    _("EXIT PERFORM is only valid with inline PERFORM"));
	} else if (CB_VALUE (perform_stack) != cb_error_node) {
		p = CB_PERFORM (CB_VALUE (perform_stack));
		if (!p->exit_label) {
			sprintf (name, "EXIT PERFORM %d", cb_id);
			p->exit_label = cb_build_reference (name);
			plabel = cb_build_label (p->exit_label, NULL);
			CB_LABEL (plabel)->flag_begin = 1;
			CB_LABEL (plabel)->flag_dummy_exit = 1;
		}
		current_statement->name = (const char *)"EXIT PERFORM";
		cb_emit_goto (CB_LIST_INIT (p->exit_label), NULL);
	}
  }
#line 16299 "parser.c" /* yacc.c:1646  */
    break;

  case 1272:
#line 9310 "parser.y" /* yacc.c:1646  */
    {
	cb_tree	plabel;
	char	name[64];

	if (!current_section) {
		cb_error_x (CB_TREE (current_statement),
			    _("EXIT SECTION is only valid with an active SECTION"));
	} else {
		if (!current_section->exit_label) {
			sprintf (name, "EXIT SECTION %d", cb_id);
			current_section->exit_label = cb_build_reference (name);
			plabel = cb_build_label (current_section->exit_label, NULL);
			CB_LABEL (plabel)->flag_begin = 1;
			CB_LABEL (plabel)->flag_dummy_exit = 1;
		}
		current_statement->name = (const char *)"EXIT SECTION";
		cb_emit_goto (CB_LIST_INIT (current_section->exit_label), NULL);
	}
  }
#line 16323 "parser.c" /* yacc.c:1646  */
    break;

  case 1273:
#line 9330 "parser.y" /* yacc.c:1646  */
    {
	cb_tree	plabel;
	char	name[64];

	if (!current_paragraph) {
		cb_error_x (CB_TREE (current_statement),
			    _("EXIT PARAGRAPH is only valid with an active PARAGRAPH"));
	} else {
		if (!current_paragraph->exit_label) {
			sprintf (name, "EXIT PARAGRAPH %d", cb_id);
			current_paragraph->exit_label = cb_build_reference (name);
			plabel = cb_build_label (current_paragraph->exit_label, NULL);
			CB_LABEL (plabel)->flag_begin = 1;
			CB_LABEL (plabel)->flag_dummy_exit = 1;
		}
		current_statement->name = (const char *)"EXIT PARAGRAPH";
		cb_emit_goto (CB_LIST_INIT (current_paragraph->exit_label), NULL);
	}
  }
#line 16347 "parser.c" /* yacc.c:1646  */
    break;

  case 1274:
#line 9352 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 16353 "parser.c" /* yacc.c:1646  */
    break;

  case 1275:
#line 9353 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 16359 "parser.c" /* yacc.c:1646  */
    break;

  case 1276:
#line 9361 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("FREE", 0);
	current_statement->flag_no_based = 1;
  }
#line 16368 "parser.c" /* yacc.c:1646  */
    break;

  case 1278:
#line 9370 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_free ((yyvsp[0]));
  }
#line 16376 "parser.c" /* yacc.c:1646  */
    break;

  case 1279:
#line 9380 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("GENERATE", 0);
	CB_PENDING("GENERATE");
  }
#line 16385 "parser.c" /* yacc.c:1646  */
    break;

  case 1282:
#line 9396 "parser.y" /* yacc.c:1646  */
    {
	if (!current_paragraph->flag_statement) {
		current_paragraph->flag_first_is_goto = 1;
	}
	begin_statement ("GO TO", 0);
	save_debug = start_debug;
	start_debug = 0;
  }
#line 16398 "parser.c" /* yacc.c:1646  */
    break;

  case 1284:
#line 9409 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_goto ((yyvsp[-1]), (yyvsp[0]));
	start_debug = save_debug;
  }
#line 16407 "parser.c" /* yacc.c:1646  */
    break;

  case 1285:
#line 9417 "parser.y" /* yacc.c:1646  */
    {
	check_unreached = 1;
	(yyval) = NULL;
  }
#line 16416 "parser.c" /* yacc.c:1646  */
    break;

  case 1286:
#line 9422 "parser.y" /* yacc.c:1646  */
    {
	check_unreached = 0;
	(yyval) = (yyvsp[0]);
  }
#line 16425 "parser.c" /* yacc.c:1646  */
    break;

  case 1287:
#line 9433 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("GOBACK", 0);
	check_unreached = 1;
	if ((yyvsp[0])) {
		if (!current_program->cb_return_code) {
			cb_error_x ((yyvsp[0]), _("RETURNING/GIVING not allowed for non-returning sources"));
		} else {
			cb_emit_move ((yyvsp[0]), CB_LIST_INIT (current_program->cb_return_code));
		}
	}
	cb_emit_exit (1U);
  }
#line 16442 "parser.c" /* yacc.c:1646  */
    break;

  case 1288:
#line 9452 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("IF", TERM_IF);
  }
#line 16450 "parser.c" /* yacc.c:1646  */
    break;

  case 1290:
#line 9461 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_if ((yyvsp[(-1) - (5)]), (yyvsp[-3]), (yyvsp[0]));
  }
#line 16458 "parser.c" /* yacc.c:1646  */
    break;

  case 1291:
#line 9465 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_if ((yyvsp[(-1) - (3)]), NULL, (yyvsp[0]));
  }
#line 16466 "parser.c" /* yacc.c:1646  */
    break;

  case 1292:
#line 9469 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_if ((yyvsp[(-1) - (2)]), (yyvsp[0]), NULL);
  }
#line 16474 "parser.c" /* yacc.c:1646  */
    break;

  case 1293:
#line 9475 "parser.y" /* yacc.c:1646  */
    {
	cb_save_cond ();
  }
#line 16482 "parser.c" /* yacc.c:1646  */
    break;

  case 1294:
#line 9479 "parser.y" /* yacc.c:1646  */
    {
	cb_save_cond ();
  }
#line 16490 "parser.c" /* yacc.c:1646  */
    break;

  case 1295:
#line 9485 "parser.y" /* yacc.c:1646  */
    {
	  cb_true_side ();
  }
#line 16498 "parser.c" /* yacc.c:1646  */
    break;

  case 1296:
#line 9491 "parser.y" /* yacc.c:1646  */
    {
	  cb_false_side ();
  }
#line 16506 "parser.c" /* yacc.c:1646  */
    break;

  case 1297:
#line 9498 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-4) - (0)]), IF);
	cb_terminate_cond ();
  }
#line 16515 "parser.c" /* yacc.c:1646  */
    break;

  case 1298:
#line 9503 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-4) - (1)]), IF);
	cb_terminate_cond ();
  }
#line 16524 "parser.c" /* yacc.c:1646  */
    break;

  case 1299:
#line 9514 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("INITIALIZE", 0);
  }
#line 16532 "parser.c" /* yacc.c:1646  */
    break;

  case 1301:
#line 9523 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_initialize ((yyvsp[-4]), (yyvsp[-3]), (yyvsp[-2]), (yyvsp[-1]), (yyvsp[0]));
  }
#line 16540 "parser.c" /* yacc.c:1646  */
    break;

  case 1302:
#line 9529 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 16546 "parser.c" /* yacc.c:1646  */
    break;

  case 1303:
#line 9530 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_true; }
#line 16552 "parser.c" /* yacc.c:1646  */
    break;

  case 1304:
#line 9534 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 16558 "parser.c" /* yacc.c:1646  */
    break;

  case 1305:
#line 9535 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_true; }
#line 16564 "parser.c" /* yacc.c:1646  */
    break;

  case 1306:
#line 9536 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[-2]); }
#line 16570 "parser.c" /* yacc.c:1646  */
    break;

  case 1307:
#line 9541 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 16578 "parser.c" /* yacc.c:1646  */
    break;

  case 1308:
#line 9545 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 16586 "parser.c" /* yacc.c:1646  */
    break;

  case 1309:
#line 9552 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 16594 "parser.c" /* yacc.c:1646  */
    break;

  case 1310:
#line 9557 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_list_append ((yyvsp[-1]), (yyvsp[0]));
  }
#line 16602 "parser.c" /* yacc.c:1646  */
    break;

  case 1311:
#line 9564 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_BUILD_PAIR ((yyvsp[-3]), (yyvsp[0]));
  }
#line 16610 "parser.c" /* yacc.c:1646  */
    break;

  case 1312:
#line 9570 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (CB_CATEGORY_ALPHABETIC); }
#line 16616 "parser.c" /* yacc.c:1646  */
    break;

  case 1313:
#line 9571 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (CB_CATEGORY_ALPHANUMERIC); }
#line 16622 "parser.c" /* yacc.c:1646  */
    break;

  case 1314:
#line 9572 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (CB_CATEGORY_NUMERIC); }
#line 16628 "parser.c" /* yacc.c:1646  */
    break;

  case 1315:
#line 9573 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (CB_CATEGORY_ALPHANUMERIC_EDITED); }
#line 16634 "parser.c" /* yacc.c:1646  */
    break;

  case 1316:
#line 9574 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (CB_CATEGORY_NUMERIC_EDITED); }
#line 16640 "parser.c" /* yacc.c:1646  */
    break;

  case 1317:
#line 9575 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (CB_CATEGORY_NATIONAL); }
#line 16646 "parser.c" /* yacc.c:1646  */
    break;

  case 1318:
#line 9576 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (CB_CATEGORY_NATIONAL_EDITED); }
#line 16652 "parser.c" /* yacc.c:1646  */
    break;

  case 1319:
#line 9588 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 16660 "parser.c" /* yacc.c:1646  */
    break;

  case 1320:
#line 9592 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_true;
  }
#line 16668 "parser.c" /* yacc.c:1646  */
    break;

  case 1321:
#line 9601 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("INITIATE", 0);
	CB_PENDING("INITIATE");
  }
#line 16677 "parser.c" /* yacc.c:1646  */
    break;

  case 1323:
#line 9610 "parser.y" /* yacc.c:1646  */
    {
	begin_implicit_statement ();
	if ((yyvsp[0]) != cb_error_node) {
	}
  }
#line 16687 "parser.c" /* yacc.c:1646  */
    break;

  case 1324:
#line 9616 "parser.y" /* yacc.c:1646  */
    {
	begin_implicit_statement ();
	if ((yyvsp[0]) != cb_error_node) {
	}
  }
#line 16697 "parser.c" /* yacc.c:1646  */
    break;

  case 1325:
#line 9627 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("INSPECT", 0);
	inspect_keyword = 0;
  }
#line 16706 "parser.c" /* yacc.c:1646  */
    break;

  case 1335:
#line 9655 "parser.y" /* yacc.c:1646  */
    {
	previous_tallying_phrase = NO_PHRASE;
	cb_init_tallying ();
  }
#line 16715 "parser.c" /* yacc.c:1646  */
    break;

  case 1336:
#line 9660 "parser.y" /* yacc.c:1646  */
    {
	if (!(previous_tallying_phrase == CHARACTERS_PHRASE
	      || previous_tallying_phrase == VALUE_REGION_PHRASE)) {
		cb_error (_("TALLYING clause is incomplete"));
	} else {
		cb_emit_inspect ((yyvsp[-3]), (yyvsp[0]), TALLYING_CLAUSE);
	}

	(yyval) = (yyvsp[-3]);
  }
#line 16730 "parser.c" /* yacc.c:1646  */
    break;

  case 1337:
#line 9676 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_inspect ((yyvsp[-2]), (yyvsp[0]), REPLACING_CLAUSE);
	inspect_keyword = 0;
  }
#line 16739 "parser.c" /* yacc.c:1646  */
    break;

  case 1338:
#line 9686 "parser.y" /* yacc.c:1646  */
    {
	cb_tree		x;
	x = cb_build_converting ((yyvsp[-3]), (yyvsp[-1]), (yyvsp[0]));
	cb_emit_inspect ((yyvsp[-5]), x, CONVERTING_CLAUSE);
  }
#line 16749 "parser.c" /* yacc.c:1646  */
    break;

  case 1339:
#line 9695 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 16757 "parser.c" /* yacc.c:1646  */
    break;

  case 1340:
#line 9699 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_list_append ((yyvsp[-1]), (yyvsp[0]));
  }
#line 16765 "parser.c" /* yacc.c:1646  */
    break;

  case 1341:
#line 9706 "parser.y" /* yacc.c:1646  */
    {
	check_preceding_tallying_phrases (FOR_PHRASE);
	(yyval) = cb_build_tallying_data ((yyvsp[-1]));
  }
#line 16774 "parser.c" /* yacc.c:1646  */
    break;

  case 1342:
#line 9711 "parser.y" /* yacc.c:1646  */
    {
	check_preceding_tallying_phrases (CHARACTERS_PHRASE);
	(yyval) = cb_build_tallying_characters ((yyvsp[0]));
  }
#line 16783 "parser.c" /* yacc.c:1646  */
    break;

  case 1343:
#line 9716 "parser.y" /* yacc.c:1646  */
    {
	check_preceding_tallying_phrases (ALL_LEADING_TRAILING_PHRASES);
	(yyval) = cb_build_tallying_all ();
  }
#line 16792 "parser.c" /* yacc.c:1646  */
    break;

  case 1344:
#line 9721 "parser.y" /* yacc.c:1646  */
    {
	check_preceding_tallying_phrases (ALL_LEADING_TRAILING_PHRASES);
	(yyval) = cb_build_tallying_leading ();
  }
#line 16801 "parser.c" /* yacc.c:1646  */
    break;

  case 1345:
#line 9726 "parser.y" /* yacc.c:1646  */
    {
	check_preceding_tallying_phrases (ALL_LEADING_TRAILING_PHRASES);
	(yyval) = cb_build_tallying_trailing ();
  }
#line 16810 "parser.c" /* yacc.c:1646  */
    break;

  case 1346:
#line 9731 "parser.y" /* yacc.c:1646  */
    {
	check_preceding_tallying_phrases (VALUE_REGION_PHRASE);
	(yyval) = cb_build_tallying_value ((yyvsp[-1]), (yyvsp[0]));
  }
#line 16819 "parser.c" /* yacc.c:1646  */
    break;

  case 1347:
#line 9738 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 16825 "parser.c" /* yacc.c:1646  */
    break;

  case 1348:
#line 9739 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_list_append ((yyvsp[-1]), (yyvsp[0])); }
#line 16831 "parser.c" /* yacc.c:1646  */
    break;

  case 1349:
#line 9744 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_replacing_characters ((yyvsp[-1]), (yyvsp[0]));
	inspect_keyword = 0;
  }
#line 16840 "parser.c" /* yacc.c:1646  */
    break;

  case 1350:
#line 9749 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 16848 "parser.c" /* yacc.c:1646  */
    break;

  case 1352:
#line 9756 "parser.y" /* yacc.c:1646  */
    { inspect_keyword = 1; }
#line 16854 "parser.c" /* yacc.c:1646  */
    break;

  case 1353:
#line 9757 "parser.y" /* yacc.c:1646  */
    { inspect_keyword = 2; }
#line 16860 "parser.c" /* yacc.c:1646  */
    break;

  case 1354:
#line 9758 "parser.y" /* yacc.c:1646  */
    { inspect_keyword = 3; }
#line 16866 "parser.c" /* yacc.c:1646  */
    break;

  case 1355:
#line 9759 "parser.y" /* yacc.c:1646  */
    { inspect_keyword = 4; }
#line 16872 "parser.c" /* yacc.c:1646  */
    break;

  case 1356:
#line 9764 "parser.y" /* yacc.c:1646  */
    {
	switch (inspect_keyword) {
		case 1:
			(yyval) = cb_build_replacing_all ((yyvsp[-3]), (yyvsp[-1]), (yyvsp[0]));
			break;
		case 2:
			(yyval) = cb_build_replacing_leading ((yyvsp[-3]), (yyvsp[-1]), (yyvsp[0]));
			break;
		case 3:
			(yyval) = cb_build_replacing_first ((yyvsp[-3]), (yyvsp[-1]), (yyvsp[0]));
			break;
		case 4:
			(yyval) = cb_build_replacing_trailing ((yyvsp[-3]), (yyvsp[-1]), (yyvsp[0]));
			break;
		default:
			cb_error_x (CB_TREE (current_statement),
				    _("INSPECT missing ALL/FIRST/LEADING/TRAILING"));
			(yyval) = cb_build_replacing_all ((yyvsp[-3]), (yyvsp[-1]), (yyvsp[0]));
			break;
	}
  }
#line 16898 "parser.c" /* yacc.c:1646  */
    break;

  case 1357:
#line 9791 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_inspect_region_start ();
  }
#line 16906 "parser.c" /* yacc.c:1646  */
    break;

  case 1358:
#line 9795 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_list_add (cb_build_inspect_region_start (), (yyvsp[0]));
  }
#line 16914 "parser.c" /* yacc.c:1646  */
    break;

  case 1359:
#line 9799 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_list_add (cb_build_inspect_region_start (), (yyvsp[0]));
  }
#line 16922 "parser.c" /* yacc.c:1646  */
    break;

  case 1360:
#line 9803 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_list_add (cb_list_add (cb_build_inspect_region_start (), (yyvsp[-1])), (yyvsp[0]));
  }
#line 16930 "parser.c" /* yacc.c:1646  */
    break;

  case 1361:
#line 9807 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_list_add (cb_list_add (cb_build_inspect_region_start (), (yyvsp[-1])), (yyvsp[0]));
  }
#line 16938 "parser.c" /* yacc.c:1646  */
    break;

  case 1362:
#line 9814 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_BUILD_FUNCALL_1 ("cob_inspect_before", (yyvsp[0]));
  }
#line 16946 "parser.c" /* yacc.c:1646  */
    break;

  case 1363:
#line 9821 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_BUILD_FUNCALL_1 ("cob_inspect_after", (yyvsp[0]));
  }
#line 16954 "parser.c" /* yacc.c:1646  */
    break;

  case 1364:
#line 9830 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("MERGE", 0);
	current_statement->flag_merge = 1;
  }
#line 16963 "parser.c" /* yacc.c:1646  */
    break;

  case 1366:
#line 9842 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("MOVE", 0);
  }
#line 16971 "parser.c" /* yacc.c:1646  */
    break;

  case 1368:
#line 9850 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_move ((yyvsp[-2]), (yyvsp[0]));
  }
#line 16979 "parser.c" /* yacc.c:1646  */
    break;

  case 1369:
#line 9854 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_move_corresponding ((yyvsp[-2]), (yyvsp[0]));
  }
#line 16987 "parser.c" /* yacc.c:1646  */
    break;

  case 1370:
#line 9864 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("MULTIPLY", TERM_MULTIPLY);
  }
#line 16995 "parser.c" /* yacc.c:1646  */
    break;

  case 1372:
#line 9873 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_arithmetic ((yyvsp[-1]), '*', (yyvsp[-3]));
  }
#line 17003 "parser.c" /* yacc.c:1646  */
    break;

  case 1373:
#line 9877 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_arithmetic ((yyvsp[-1]), 0, cb_build_binary_op ((yyvsp[-5]), '*', (yyvsp[-3])));
  }
#line 17011 "parser.c" /* yacc.c:1646  */
    break;

  case 1374:
#line 9884 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-2) - (0)]), MULTIPLY);
  }
#line 17019 "parser.c" /* yacc.c:1646  */
    break;

  case 1375:
#line 9888 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), MULTIPLY);
  }
#line 17027 "parser.c" /* yacc.c:1646  */
    break;

  case 1376:
#line 9898 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("OPEN", 0);
  }
#line 17035 "parser.c" /* yacc.c:1646  */
    break;

  case 1380:
#line 9911 "parser.y" /* yacc.c:1646  */
    {
	cb_tree l;
	cb_tree x;

	if ((yyvsp[-3]) && (yyvsp[0])) {
		cb_error_x (CB_TREE (current_statement),
			    _("%s and %s are mutually exclusive"), "SHARING", _("LOCK clauses"));
	}
	if ((yyvsp[0])) {
		x = (yyvsp[0]);
	} else {
		x = (yyvsp[-3]);
	}

	for (l = (yyvsp[-1]); l; l = CB_CHAIN (l)) {
		if (CB_VALID_TREE (CB_VALUE (l))) {
			begin_implicit_statement ();
			cb_emit_open (CB_VALUE (l), (yyvsp[-4]), x);
		}
	}
  }
#line 17061 "parser.c" /* yacc.c:1646  */
    break;

  case 1381:
#line 9935 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (COB_OPEN_INPUT); }
#line 17067 "parser.c" /* yacc.c:1646  */
    break;

  case 1382:
#line 9936 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (COB_OPEN_OUTPUT); }
#line 17073 "parser.c" /* yacc.c:1646  */
    break;

  case 1383:
#line 9937 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (COB_OPEN_I_O); }
#line 17079 "parser.c" /* yacc.c:1646  */
    break;

  case 1384:
#line 9938 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (COB_OPEN_EXTEND); }
#line 17085 "parser.c" /* yacc.c:1646  */
    break;

  case 1385:
#line 9942 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 17091 "parser.c" /* yacc.c:1646  */
    break;

  case 1386:
#line 9943 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 17097 "parser.c" /* yacc.c:1646  */
    break;

  case 1387:
#line 9947 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 17103 "parser.c" /* yacc.c:1646  */
    break;

  case 1388:
#line 9948 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 17109 "parser.c" /* yacc.c:1646  */
    break;

  case 1389:
#line 9949 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (COB_LOCK_OPEN_EXCLUSIVE); }
#line 17115 "parser.c" /* yacc.c:1646  */
    break;

  case 1390:
#line 9951 "parser.y" /* yacc.c:1646  */
    {
	(void)cb_verify (CB_OBSOLETE, "REVERSED");
	(yyval) = NULL;
  }
#line 17124 "parser.c" /* yacc.c:1646  */
    break;

  case 1391:
#line 9962 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("PERFORM", TERM_PERFORM);
	/* Turn off field debug - PERFORM is special */
	save_debug = start_debug;
	start_debug = 0;
	cobc_cs_check = CB_CS_PERFORM;
  }
#line 17136 "parser.c" /* yacc.c:1646  */
    break;

  case 1393:
#line 9977 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_perform ((yyvsp[0]), (yyvsp[-2]), (yyvsp[-3]), (yyvsp[-1]));
	start_debug = save_debug;
	cobc_cs_check = 0;
  }
#line 17146 "parser.c" /* yacc.c:1646  */
    break;

  case 1394:
#line 9985 "parser.y" /* yacc.c:1646  */
    {
	CB_ADD_TO_CHAIN ((yyvsp[-1]), perform_stack);
	/* Restore field debug before inline statements */
	start_debug = save_debug;
	cobc_cs_check = 0;
  }
#line 17157 "parser.c" /* yacc.c:1646  */
    break;

  case 1395:
#line 9992 "parser.y" /* yacc.c:1646  */
    {
	perform_stack = CB_CHAIN (perform_stack);
	cb_emit_perform ((yyvsp[-4]), (yyvsp[-1]), (yyvsp[-5]), (yyvsp[-3]));
  }
#line 17166 "parser.c" /* yacc.c:1646  */
    break;

  case 1396:
#line 10000 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_perform ((yyvsp[-2]), NULL, (yyvsp[-3]), (yyvsp[-1]));
	start_debug = save_debug;
	cobc_cs_check = 0;
  }
#line 17176 "parser.c" /* yacc.c:1646  */
    break;

  case 1397:
#line 10009 "parser.y" /* yacc.c:1646  */
    {
	if (cb_relaxed_syntax_checks) {
		TERMINATOR_WARNING ((yyvsp[(-4) - (0)]), PERFORM);
	} else {
		TERMINATOR_ERROR ((yyvsp[(-4) - (0)]), PERFORM);
	}
  }
#line 17188 "parser.c" /* yacc.c:1646  */
    break;

  case 1398:
#line 10017 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-4) - (1)]), PERFORM);
  }
#line 17196 "parser.c" /* yacc.c:1646  */
    break;

  case 1399:
#line 10024 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), PERFORM);
  }
#line 17204 "parser.c" /* yacc.c:1646  */
    break;

  case 1400:
#line 10028 "parser.y" /* yacc.c:1646  */
    {
	if (cb_relaxed_syntax_checks) {
		TERMINATOR_WARNING ((yyvsp[(-2) - (1)]), PERFORM);
	} else {
		TERMINATOR_ERROR ((yyvsp[(-2) - (1)]), PERFORM);
	}
	/* Put the dot token back into the stack for reparse */
	cb_unput_dot ();
  }
#line 17218 "parser.c" /* yacc.c:1646  */
    break;

  case 1401:
#line 10041 "parser.y" /* yacc.c:1646  */
    {
	/* Return from $1 */
	CB_REFERENCE ((yyvsp[0]))->length = cb_true;
	CB_REFERENCE ((yyvsp[0]))->flag_decl_ok = 1;
	(yyval) = CB_BUILD_PAIR ((yyvsp[0]), (yyvsp[0]));
  }
#line 17229 "parser.c" /* yacc.c:1646  */
    break;

  case 1402:
#line 10048 "parser.y" /* yacc.c:1646  */
    {
	/* Return from $3 */
	CB_REFERENCE ((yyvsp[0]))->length = cb_true;
	CB_REFERENCE ((yyvsp[-2]))->flag_decl_ok = 1;
	CB_REFERENCE ((yyvsp[0]))->flag_decl_ok = 1;
	(yyval) = CB_BUILD_PAIR ((yyvsp[-2]), (yyvsp[0]));
  }
#line 17241 "parser.c" /* yacc.c:1646  */
    break;

  case 1403:
#line 10059 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_perform_once (NULL);
  }
#line 17249 "parser.c" /* yacc.c:1646  */
    break;

  case 1404:
#line 10063 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_perform_times ((yyvsp[-1]));
	current_program->loop_counter++;
  }
#line 17258 "parser.c" /* yacc.c:1646  */
    break;

  case 1405:
#line 10068 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_perform_forever (NULL);
  }
#line 17266 "parser.c" /* yacc.c:1646  */
    break;

  case 1406:
#line 10072 "parser.y" /* yacc.c:1646  */
    {
	cb_tree varying;

	if (!(yyvsp[0])) {
		(yyval) = cb_build_perform_forever (NULL);
	} else {
		if ((yyvsp[-2]) == CB_AFTER)
			cb_build_perform_after_until();
		varying = CB_LIST_INIT (cb_build_perform_varying (NULL, NULL, NULL, (yyvsp[0])));
		(yyval) = cb_build_perform_until ((yyvsp[-2]), varying);
	}
  }
#line 17283 "parser.c" /* yacc.c:1646  */
    break;

  case 1407:
#line 10085 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_perform_until ((yyvsp[-2]), (yyvsp[0]));
  }
#line 17291 "parser.c" /* yacc.c:1646  */
    break;

  case 1408:
#line 10091 "parser.y" /* yacc.c:1646  */
    { (yyval) = CB_BEFORE; }
#line 17297 "parser.c" /* yacc.c:1646  */
    break;

  case 1409:
#line 10092 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 17303 "parser.c" /* yacc.c:1646  */
    break;

  case 1410:
#line 10096 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 17309 "parser.c" /* yacc.c:1646  */
    break;

  case 1411:
#line 10097 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 17315 "parser.c" /* yacc.c:1646  */
    break;

  case 1412:
#line 10100 "parser.y" /* yacc.c:1646  */
    { (yyval) = CB_LIST_INIT ((yyvsp[0])); }
#line 17321 "parser.c" /* yacc.c:1646  */
    break;

  case 1413:
#line 10102 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_list_add ((yyvsp[-2]), (yyvsp[0])); }
#line 17327 "parser.c" /* yacc.c:1646  */
    break;

  case 1414:
#line 10107 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_perform_varying ((yyvsp[-6]), (yyvsp[-4]), (yyvsp[-2]), (yyvsp[0]));
  }
#line 17335 "parser.c" /* yacc.c:1646  */
    break;

  case 1415:
#line 10116 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("PURGE", 0);
  }
#line 17343 "parser.c" /* yacc.c:1646  */
    break;

  case 1416:
#line 10120 "parser.y" /* yacc.c:1646  */
    {
  }
#line 17350 "parser.c" /* yacc.c:1646  */
    break;

  case 1417:
#line 10128 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("READ", TERM_READ);
	cobc_cs_check = CB_CS_READ;
  }
#line 17359 "parser.c" /* yacc.c:1646  */
    break;

  case 1419:
#line 10138 "parser.y" /* yacc.c:1646  */
    {
	cobc_cs_check = 0;

	if (CB_VALID_TREE ((yyvsp[-6]))) {
		struct cb_file	*cf;

		cf = CB_FILE(cb_ref ((yyvsp[-6])));
		if ((yyvsp[-2]) && (cf->lock_mode & COB_LOCK_AUTOMATIC)) {
			cb_error_x (CB_TREE (current_statement),
				    _("LOCK clause invalid with file LOCK AUTOMATIC"));
		} else if ((yyvsp[-1]) &&
		      (cf->organization != COB_ORG_RELATIVE &&
		       cf->organization != COB_ORG_INDEXED)) {
			cb_error_x (CB_TREE (current_statement),
				    _("KEY clause invalid with this file type"));
		} else if (current_statement->handler_type == INVALID_KEY_HANDLER &&
			   (cf->organization != COB_ORG_RELATIVE &&
			    cf->organization != COB_ORG_INDEXED)) {
			cb_error_x (CB_TREE (current_statement),
				    _("INVALID KEY clause invalid with this file type"));
		} else {
			cb_emit_read ((yyvsp[-6]), (yyvsp[-5]), (yyvsp[-3]), (yyvsp[-1]), (yyvsp[-2]));
		}
	}
  }
#line 17389 "parser.c" /* yacc.c:1646  */
    break;

  case 1420:
#line 10166 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 17395 "parser.c" /* yacc.c:1646  */
    break;

  case 1421:
#line 10167 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 17401 "parser.c" /* yacc.c:1646  */
    break;

  case 1422:
#line 10172 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 17409 "parser.c" /* yacc.c:1646  */
    break;

  case 1423:
#line 10176 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int3;
  }
#line 17417 "parser.c" /* yacc.c:1646  */
    break;

  case 1424:
#line 10180 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 17425 "parser.c" /* yacc.c:1646  */
    break;

  case 1425:
#line 10184 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 17433 "parser.c" /* yacc.c:1646  */
    break;

  case 1428:
#line 10196 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("ADVANCING ON LOCK");
  }
#line 17441 "parser.c" /* yacc.c:1646  */
    break;

  case 1432:
#line 10209 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("RETRY");
	cobc_cs_check = 0;
  }
#line 17450 "parser.c" /* yacc.c:1646  */
    break;

  case 1438:
#line 10229 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 17458 "parser.c" /* yacc.c:1646  */
    break;

  case 1439:
#line 10233 "parser.y" /* yacc.c:1646  */
    {
   (yyval) = cb_int5;
  }
#line 17466 "parser.c" /* yacc.c:1646  */
    break;

  case 1440:
#line 10237 "parser.y" /* yacc.c:1646  */
    {
	/* TO-DO: Merge with RETRY phrase */
	(yyval) = cb_int4;
  }
#line 17475 "parser.c" /* yacc.c:1646  */
    break;

  case 1441:
#line 10244 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 17481 "parser.c" /* yacc.c:1646  */
    break;

  case 1442:
#line 10245 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 17487 "parser.c" /* yacc.c:1646  */
    break;

  case 1445:
#line 10255 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-2) - (0)]), READ);
  }
#line 17495 "parser.c" /* yacc.c:1646  */
    break;

  case 1446:
#line 10259 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), READ);
  }
#line 17503 "parser.c" /* yacc.c:1646  */
    break;

  case 1447:
#line 10269 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("READY TRACE", 0);
	cb_emit_ready_trace ();
  }
#line 17512 "parser.c" /* yacc.c:1646  */
    break;

  case 1448:
#line 10279 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("RECEIVE", TERM_RECEIVE);
  }
#line 17520 "parser.c" /* yacc.c:1646  */
    break;

  case 1462:
#line 10322 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-2) - (0)]), RECEIVE);
  }
#line 17528 "parser.c" /* yacc.c:1646  */
    break;

  case 1463:
#line 10326 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), RECEIVE);
  }
#line 17536 "parser.c" /* yacc.c:1646  */
    break;

  case 1464:
#line 10335 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("RELEASE", 0);
  }
#line 17544 "parser.c" /* yacc.c:1646  */
    break;

  case 1466:
#line 10343 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_release ((yyvsp[-1]), (yyvsp[0]));
  }
#line 17552 "parser.c" /* yacc.c:1646  */
    break;

  case 1467:
#line 10353 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("RESET TRACE", 0);
	cb_emit_reset_trace ();
  }
#line 17561 "parser.c" /* yacc.c:1646  */
    break;

  case 1468:
#line 10363 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("RETURN", TERM_RETURN);
  }
#line 17569 "parser.c" /* yacc.c:1646  */
    break;

  case 1470:
#line 10372 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_return ((yyvsp[-3]), (yyvsp[-1]));
  }
#line 17577 "parser.c" /* yacc.c:1646  */
    break;

  case 1471:
#line 10379 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-2) - (0)]), RETURN);
  }
#line 17585 "parser.c" /* yacc.c:1646  */
    break;

  case 1472:
#line 10383 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), RETURN);
  }
#line 17593 "parser.c" /* yacc.c:1646  */
    break;

  case 1473:
#line 10393 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("REWRITE", TERM_REWRITE);
	/* Special in debugging mode */
	save_debug = start_debug;
	start_debug = 0;
  }
#line 17604 "parser.c" /* yacc.c:1646  */
    break;

  case 1475:
#line 10405 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_rewrite ((yyvsp[-4]), (yyvsp[-3]), (yyvsp[-1]));
	start_debug = save_debug;
  }
#line 17613 "parser.c" /* yacc.c:1646  */
    break;

  case 1476:
#line 10413 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 17621 "parser.c" /* yacc.c:1646  */
    break;

  case 1478:
#line 10421 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int1;
  }
#line 17629 "parser.c" /* yacc.c:1646  */
    break;

  case 1479:
#line 10425 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int2;
  }
#line 17637 "parser.c" /* yacc.c:1646  */
    break;

  case 1480:
#line 10432 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-2) - (0)]), REWRITE);
  }
#line 17645 "parser.c" /* yacc.c:1646  */
    break;

  case 1481:
#line 10436 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), REWRITE);
  }
#line 17653 "parser.c" /* yacc.c:1646  */
    break;

  case 1482:
#line 10446 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("ROLLBACK", 0);
	cb_emit_rollback ();
  }
#line 17662 "parser.c" /* yacc.c:1646  */
    break;

  case 1483:
#line 10457 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("SEARCH", TERM_SEARCH);
  }
#line 17670 "parser.c" /* yacc.c:1646  */
    break;

  case 1485:
#line 10466 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_search ((yyvsp[-3]), (yyvsp[-2]), (yyvsp[-1]), (yyvsp[0]));
  }
#line 17678 "parser.c" /* yacc.c:1646  */
    break;

  case 1486:
#line 10471 "parser.y" /* yacc.c:1646  */
    {
	current_statement->name = (const char *)"SEARCH ALL";
	cb_emit_search_all ((yyvsp[-4]), (yyvsp[-3]), (yyvsp[-1]), (yyvsp[0]));
  }
#line 17687 "parser.c" /* yacc.c:1646  */
    break;

  case 1487:
#line 10478 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 17693 "parser.c" /* yacc.c:1646  */
    break;

  case 1488:
#line 10479 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 17699 "parser.c" /* yacc.c:1646  */
    break;

  case 1489:
#line 10484 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 17707 "parser.c" /* yacc.c:1646  */
    break;

  case 1490:
#line 10489 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 17715 "parser.c" /* yacc.c:1646  */
    break;

  case 1491:
#line 10496 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_LIST_INIT ((yyvsp[0]));
  }
#line 17723 "parser.c" /* yacc.c:1646  */
    break;

  case 1492:
#line 10500 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_list_add ((yyvsp[0]), (yyvsp[-1]));
  }
#line 17731 "parser.c" /* yacc.c:1646  */
    break;

  case 1493:
#line 10508 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_if_check_break ((yyvsp[-1]), (yyvsp[0]));
  }
#line 17739 "parser.c" /* yacc.c:1646  */
    break;

  case 1494:
#line 10515 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-2) - (0)]), SEARCH);
  }
#line 17747 "parser.c" /* yacc.c:1646  */
    break;

  case 1495:
#line 10519 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), SEARCH);
  }
#line 17755 "parser.c" /* yacc.c:1646  */
    break;

  case 1496:
#line 10529 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("SEND", 0);
  }
#line 17763 "parser.c" /* yacc.c:1646  */
    break;

  case 1498:
#line 10537 "parser.y" /* yacc.c:1646  */
    {
  }
#line 17770 "parser.c" /* yacc.c:1646  */
    break;

  case 1499:
#line 10540 "parser.y" /* yacc.c:1646  */
    {
  }
#line 17777 "parser.c" /* yacc.c:1646  */
    break;

  case 1502:
#line 10551 "parser.y" /* yacc.c:1646  */
    {
  }
#line 17784 "parser.c" /* yacc.c:1646  */
    break;

  case 1509:
#line 10571 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("SET", 0);
	set_attr_val_on = 0;
	set_attr_val_off = 0;
	cobc_cs_check = CB_CS_SET;
  }
#line 17795 "parser.c" /* yacc.c:1646  */
    break;

  case 1510:
#line 10578 "parser.y" /* yacc.c:1646  */
    {
	cobc_cs_check = 0;
  }
#line 17803 "parser.c" /* yacc.c:1646  */
    break;

  case 1519:
#line 10595 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int1; }
#line 17809 "parser.c" /* yacc.c:1646  */
    break;

  case 1520:
#line 10596 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int0; }
#line 17815 "parser.c" /* yacc.c:1646  */
    break;

  case 1521:
#line 10600 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int0; }
#line 17821 "parser.c" /* yacc.c:1646  */
    break;

  case 1522:
#line 10601 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int1; }
#line 17827 "parser.c" /* yacc.c:1646  */
    break;

  case 1523:
#line 10608 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_setenv ((yyvsp[-2]), (yyvsp[0]));
  }
#line 17835 "parser.c" /* yacc.c:1646  */
    break;

  case 1524:
#line 10617 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_set_attribute ((yyvsp[-2]), set_attr_val_on, set_attr_val_off);
  }
#line 17843 "parser.c" /* yacc.c:1646  */
    break;

  case 1527:
#line 10629 "parser.y" /* yacc.c:1646  */
    {
	bit_set_attr ((yyvsp[0]), COB_SCREEN_BELL);
  }
#line 17851 "parser.c" /* yacc.c:1646  */
    break;

  case 1528:
#line 10633 "parser.y" /* yacc.c:1646  */
    {
	bit_set_attr ((yyvsp[0]), COB_SCREEN_BLINK);
  }
#line 17859 "parser.c" /* yacc.c:1646  */
    break;

  case 1529:
#line 10637 "parser.y" /* yacc.c:1646  */
    {
	bit_set_attr ((yyvsp[0]), COB_SCREEN_HIGHLIGHT);
	check_not_highlight_and_lowlight (set_attr_val_on | set_attr_val_off,
					  COB_SCREEN_HIGHLIGHT);
  }
#line 17869 "parser.c" /* yacc.c:1646  */
    break;

  case 1530:
#line 10643 "parser.y" /* yacc.c:1646  */
    {
	bit_set_attr ((yyvsp[0]), COB_SCREEN_LOWLIGHT);
	check_not_highlight_and_lowlight (set_attr_val_on | set_attr_val_off,
					  COB_SCREEN_LOWLIGHT);
  }
#line 17879 "parser.c" /* yacc.c:1646  */
    break;

  case 1531:
#line 10649 "parser.y" /* yacc.c:1646  */
    {
	bit_set_attr ((yyvsp[0]), COB_SCREEN_REVERSE);
  }
#line 17887 "parser.c" /* yacc.c:1646  */
    break;

  case 1532:
#line 10653 "parser.y" /* yacc.c:1646  */
    {
	bit_set_attr ((yyvsp[0]), COB_SCREEN_UNDERLINE);
  }
#line 17895 "parser.c" /* yacc.c:1646  */
    break;

  case 1533:
#line 10657 "parser.y" /* yacc.c:1646  */
    {
	bit_set_attr ((yyvsp[0]), COB_SCREEN_LEFTLINE);
  }
#line 17903 "parser.c" /* yacc.c:1646  */
    break;

  case 1534:
#line 10661 "parser.y" /* yacc.c:1646  */
    {
	bit_set_attr ((yyvsp[0]), COB_SCREEN_OVERLINE);
  }
#line 17911 "parser.c" /* yacc.c:1646  */
    break;

  case 1535:
#line 10670 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_set_to ((yyvsp[-3]), cb_build_ppointer ((yyvsp[0])));
  }
#line 17919 "parser.c" /* yacc.c:1646  */
    break;

  case 1536:
#line 10674 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_set_to ((yyvsp[-2]), (yyvsp[0]));
  }
#line 17927 "parser.c" /* yacc.c:1646  */
    break;

  case 1537:
#line 10678 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_move (cb_build_length ((yyvsp[0])), (yyvsp[-4]));
  }
#line 17935 "parser.c" /* yacc.c:1646  */
    break;

  case 1538:
#line 10687 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_set_up_down ((yyvsp[-3]), (yyvsp[-2]), (yyvsp[0]));
  }
#line 17943 "parser.c" /* yacc.c:1646  */
    break;

  case 1541:
#line 10701 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_set_on_off ((yyvsp[-2]), (yyvsp[0]));
  }
#line 17951 "parser.c" /* yacc.c:1646  */
    break;

  case 1544:
#line 10715 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_set_true ((yyvsp[-2]));
  }
#line 17959 "parser.c" /* yacc.c:1646  */
    break;

  case 1545:
#line 10719 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_set_false ((yyvsp[-2]));
  }
#line 17967 "parser.c" /* yacc.c:1646  */
    break;

  case 1546:
#line 10728 "parser.y" /* yacc.c:1646  */
    {
	  cb_emit_set_last_exception_to_off ();
  }
#line 17975 "parser.c" /* yacc.c:1646  */
    break;

  case 1547:
#line 10737 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_set_thread_priority ((yyvsp[-3]), (yyvsp[0]));
	CB_PENDING ("THREAD");
  }
#line 17984 "parser.c" /* yacc.c:1646  */
    break;

  case 1548:
#line 10748 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("SORT", 0);
  }
#line 17992 "parser.c" /* yacc.c:1646  */
    break;

  case 1550:
#line 10756 "parser.y" /* yacc.c:1646  */
    {
	cb_tree		x;

	x = cb_ref ((yyvsp[-3]));
	if (CB_VALID_TREE (x)) {
		if (CB_INVALID_TREE ((yyvsp[-2]))) {
			if (CB_FILE_P (x)) {
				cb_error (_("file sort requires KEY phrase"));
			} else {
				/* FIXME: use key definition from OCCURS */
				cb_error (_("%s is not implemented"), _("table SORT without keys"));
			}
			(yyval) = NULL;
		} else {
			cb_emit_sort_init ((yyvsp[-3]), (yyvsp[-2]), (yyvsp[0]));
			(yyval)= (yyvsp[-3]);
		}
	} else {
		(yyval) = NULL;
	}
  }
#line 18018 "parser.c" /* yacc.c:1646  */
    break;

  case 1551:
#line 10778 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[-2]) && CB_VALID_TREE ((yyvsp[-6]))) {
		cb_emit_sort_finish ((yyvsp[-6]));
	}
  }
#line 18028 "parser.c" /* yacc.c:1646  */
    break;

  case 1552:
#line 10787 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 18036 "parser.c" /* yacc.c:1646  */
    break;

  case 1553:
#line 10792 "parser.y" /* yacc.c:1646  */
    {
	cb_tree l;
	cb_tree lparm;

	if ((yyvsp[0]) == NULL) {
		l = CB_LIST_INIT (NULL);
	} else {
		l = (yyvsp[0]);
	}
	lparm = l;
	for (; l; l = CB_CHAIN (l)) {
		CB_PURPOSE (l) = (yyvsp[-2]);
	}
	(yyval) = cb_list_append ((yyvsp[-4]), lparm);
  }
#line 18056 "parser.c" /* yacc.c:1646  */
    break;

  case 1554:
#line 10810 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 18062 "parser.c" /* yacc.c:1646  */
    break;

  case 1555:
#line 10811 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_list_add ((yyvsp[-1]), (yyvsp[0])); }
#line 18068 "parser.c" /* yacc.c:1646  */
    break;

  case 1557:
#line 10816 "parser.y" /* yacc.c:1646  */
    {
	/* The OC sort is a stable sort. ie. Dups are per default in order */
	/* Therefore nothing to do here */
  }
#line 18077 "parser.c" /* yacc.c:1646  */
    break;

  case 1558:
#line 10823 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_null; }
#line 18083 "parser.c" /* yacc.c:1646  */
    break;

  case 1559:
#line 10824 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_ref ((yyvsp[0])); }
#line 18089 "parser.c" /* yacc.c:1646  */
    break;

  case 1560:
#line 10829 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0]) && CB_FILE_P (cb_ref ((yyvsp[0])))) {
		cb_error (_("file sort requires USING or INPUT PROCEDURE"));
	}
  }
#line 18099 "parser.c" /* yacc.c:1646  */
    break;

  case 1561:
#line 10835 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[-2])) {
		if (!CB_FILE_P (cb_ref ((yyvsp[-2])))) {
			cb_error (_("USING invalid with table SORT"));
		} else {
			cb_emit_sort_using ((yyvsp[-2]), (yyvsp[0]));
		}
	}
  }
#line 18113 "parser.c" /* yacc.c:1646  */
    break;

  case 1562:
#line 10845 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[-4])) {
		if (!CB_FILE_P (cb_ref ((yyvsp[-4])))) {
			cb_error (_("INPUT PROCEDURE invalid with table SORT"));
		} else if (current_statement->flag_merge) {
			cb_error (_("INPUT PROCEDURE invalid with MERGE"));
		} else {
			cb_emit_sort_input ((yyvsp[0]));
		}
	}
	cobc_cs_check = 0;
  }
#line 18130 "parser.c" /* yacc.c:1646  */
    break;

  case 1563:
#line 10861 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[(-1) - (0)]) && CB_FILE_P (cb_ref ((yyvsp[(-1) - (0)])))) {
		cb_error (_("file sort requires GIVING or OUTPUT PROCEDURE"));
	}
  }
#line 18140 "parser.c" /* yacc.c:1646  */
    break;

  case 1564:
#line 10867 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[(-1) - (2)])) {
		if (!CB_FILE_P (cb_ref ((yyvsp[(-1) - (2)])))) {
			cb_error (_("GIVING invalid with table SORT"));
		} else {
			cb_emit_sort_giving ((yyvsp[(-1) - (2)]), (yyvsp[0]));
		}
	}
  }
#line 18154 "parser.c" /* yacc.c:1646  */
    break;

  case 1565:
#line 10877 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[(-1) - (4)])) {
		if (!CB_FILE_P (cb_ref ((yyvsp[(-1) - (4)])))) {
			cb_error (_("OUTPUT PROCEDURE invalid with table SORT"));
		} else {
			cb_emit_sort_output ((yyvsp[0]));
		}
	}
	cobc_cs_check = 0;
  }
#line 18169 "parser.c" /* yacc.c:1646  */
    break;

  case 1566:
#line 10894 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("START", TERM_START);
	start_tree = cb_int (COB_EQ);
  }
#line 18178 "parser.c" /* yacc.c:1646  */
    break;

  case 1568:
#line 10904 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[-1]) && !(yyvsp[-2])) {
		cb_error_x (CB_TREE (current_statement),
			    _("SIZE/LENGTH invalid here"));
	} else {
		cb_emit_start ((yyvsp[-3]), start_tree, (yyvsp[-2]), (yyvsp[-1]));
	}
  }
#line 18191 "parser.c" /* yacc.c:1646  */
    break;

  case 1569:
#line 10916 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 18199 "parser.c" /* yacc.c:1646  */
    break;

  case 1570:
#line 10920 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 18207 "parser.c" /* yacc.c:1646  */
    break;

  case 1571:
#line 10927 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 18215 "parser.c" /* yacc.c:1646  */
    break;

  case 1572:
#line 10931 "parser.y" /* yacc.c:1646  */
    {
	start_tree = (yyvsp[-1]);
	(yyval) = (yyvsp[0]);
  }
#line 18224 "parser.c" /* yacc.c:1646  */
    break;

  case 1573:
#line 10936 "parser.y" /* yacc.c:1646  */
    {
	start_tree = cb_int (COB_FI);
	(yyval) = NULL;
  }
#line 18233 "parser.c" /* yacc.c:1646  */
    break;

  case 1574:
#line 10941 "parser.y" /* yacc.c:1646  */
    {
	start_tree = cb_int (COB_LA);
	(yyval) = NULL;
  }
#line 18242 "parser.c" /* yacc.c:1646  */
    break;

  case 1575:
#line 10948 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (COB_EQ); }
#line 18248 "parser.c" /* yacc.c:1646  */
    break;

  case 1576:
#line 10949 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int ((yyvsp[-1]) ? COB_LE : COB_GT); }
#line 18254 "parser.c" /* yacc.c:1646  */
    break;

  case 1577:
#line 10950 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int ((yyvsp[-1]) ? COB_GE : COB_LT); }
#line 18260 "parser.c" /* yacc.c:1646  */
    break;

  case 1578:
#line 10951 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int ((yyvsp[-1]) ? COB_LT : COB_GE); }
#line 18266 "parser.c" /* yacc.c:1646  */
    break;

  case 1579:
#line 10952 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int ((yyvsp[-1]) ? COB_GT : COB_LE); }
#line 18272 "parser.c" /* yacc.c:1646  */
    break;

  case 1580:
#line 10953 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (COB_NE); }
#line 18278 "parser.c" /* yacc.c:1646  */
    break;

  case 1581:
#line 10958 "parser.y" /* yacc.c:1646  */
    {
	cb_error_x (CB_TREE (current_statement),
		    _("NOT EQUAL condition not allowed on START statement"));
  }
#line 18287 "parser.c" /* yacc.c:1646  */
    break;

  case 1584:
#line 10971 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-2) - (0)]), START);
  }
#line 18295 "parser.c" /* yacc.c:1646  */
    break;

  case 1585:
#line 10975 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), START);
  }
#line 18303 "parser.c" /* yacc.c:1646  */
    break;

  case 1586:
#line 10985 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("STOP RUN", 0);
  }
#line 18311 "parser.c" /* yacc.c:1646  */
    break;

  case 1587:
#line 10989 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_stop_run ((yyvsp[0]));
	check_unreached = 1;
	cobc_cs_check = 0;
  }
#line 18321 "parser.c" /* yacc.c:1646  */
    break;

  case 1588:
#line 10995 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("STOP", 0);
	cb_emit_display (CB_LIST_INIT ((yyvsp[0])), cb_int0, cb_int1, NULL,
			 NULL, 1, DEVICE_DISPLAY);
	cb_emit_accept (cb_null, NULL, NULL);
	cobc_cs_check = 0;
  }
#line 18333 "parser.c" /* yacc.c:1646  */
    break;

  case 1589:
#line 11003 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("STOP THREAD", 0);
	cb_emit_stop_thread ((yyvsp[0]));
	cobc_cs_check = 0;
	cb_warning_x (COBC_WARN_FILLER, (yyvsp[0]), _("%s is replaced by %s"), "STOP THREAD", "STOP RUN");
  }
#line 18344 "parser.c" /* yacc.c:1646  */
    break;

  case 1590:
#line 11013 "parser.y" /* yacc.c:1646  */
    {
	if (current_program->cb_return_code) {
		(yyval) = current_program->cb_return_code;
	} else {
		(yyval) = cb_int0;
	}
  }
#line 18356 "parser.c" /* yacc.c:1646  */
    break;

  case 1591:
#line 11021 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 18364 "parser.c" /* yacc.c:1646  */
    break;

  case 1592:
#line 11025 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 18372 "parser.c" /* yacc.c:1646  */
    break;

  case 1593:
#line 11029 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0])) {
		(yyval) = (yyvsp[0]);
	} else {
		(yyval) = cb_int1;
	}
  }
#line 18384 "parser.c" /* yacc.c:1646  */
    break;

  case 1594:
#line 11037 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0])) {
		(yyval) = (yyvsp[0]);
	} else {
		(yyval) = cb_int0;
	}
  }
#line 18396 "parser.c" /* yacc.c:1646  */
    break;

  case 1595:
#line 11048 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 18404 "parser.c" /* yacc.c:1646  */
    break;

  case 1596:
#line 11052 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 18412 "parser.c" /* yacc.c:1646  */
    break;

  case 1597:
#line 11059 "parser.y" /* yacc.c:1646  */
    {
	cb_verify (cb_stop_literal_statement, _("STOP literal"));
  }
#line 18420 "parser.c" /* yacc.c:1646  */
    break;

  case 1598:
#line 11063 "parser.y" /* yacc.c:1646  */
    {
	cb_verify (cb_stop_identifier_statement, _("STOP identifier"));
  }
#line 18428 "parser.c" /* yacc.c:1646  */
    break;

  case 1599:
#line 11069 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 18434 "parser.c" /* yacc.c:1646  */
    break;

  case 1600:
#line 11070 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_space; }
#line 18440 "parser.c" /* yacc.c:1646  */
    break;

  case 1601:
#line 11071 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_zero; }
#line 18446 "parser.c" /* yacc.c:1646  */
    break;

  case 1602:
#line 11072 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_quote; }
#line 18452 "parser.c" /* yacc.c:1646  */
    break;

  case 1603:
#line 11079 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("STRING", TERM_STRING);
	save_tree = NULL;
  }
#line 18461 "parser.c" /* yacc.c:1646  */
    break;

  case 1605:
#line 11089 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_string (save_tree, (yyvsp[-2]), (yyvsp[-1]));
  }
#line 18469 "parser.c" /* yacc.c:1646  */
    break;

  case 1608:
#line 11101 "parser.y" /* yacc.c:1646  */
    {
    if (!save_tree) {
		save_tree = CB_LIST_INIT ((yyvsp[-1]));
	} else {
		save_tree = cb_list_add (save_tree, (yyvsp[-1]));
	}
	if ((yyvsp[0])) {
		save_tree = cb_list_add (save_tree, (yyvsp[0]));
	}
  }
#line 18484 "parser.c" /* yacc.c:1646  */
    break;

  case 1609:
#line 11114 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 18490 "parser.c" /* yacc.c:1646  */
    break;

  case 1610:
#line 11116 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 18496 "parser.c" /* yacc.c:1646  */
    break;

  case 1611:
#line 11120 "parser.y" /* yacc.c:1646  */
    { (yyval) = CB_BUILD_PAIR (cb_int0, NULL); }
#line 18502 "parser.c" /* yacc.c:1646  */
    break;

  case 1612:
#line 11121 "parser.y" /* yacc.c:1646  */
    { (yyval) = CB_BUILD_PAIR ((yyvsp[0]), NULL); }
#line 18508 "parser.c" /* yacc.c:1646  */
    break;

  case 1613:
#line 11125 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 18514 "parser.c" /* yacc.c:1646  */
    break;

  case 1614:
#line 11126 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 18520 "parser.c" /* yacc.c:1646  */
    break;

  case 1615:
#line 11131 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-2) - (0)]), STRING);
  }
#line 18528 "parser.c" /* yacc.c:1646  */
    break;

  case 1616:
#line 11135 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), STRING);
  }
#line 18536 "parser.c" /* yacc.c:1646  */
    break;

  case 1617:
#line 11145 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("SUBTRACT", TERM_SUBTRACT);
  }
#line 18544 "parser.c" /* yacc.c:1646  */
    break;

  case 1619:
#line 11154 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_arithmetic ((yyvsp[-1]), '-', cb_build_binary_list ((yyvsp[-3]), '+'));
  }
#line 18552 "parser.c" /* yacc.c:1646  */
    break;

  case 1620:
#line 11158 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_arithmetic ((yyvsp[-1]), 0, cb_build_binary_list (CB_BUILD_CHAIN ((yyvsp[-3]), (yyvsp[-5])), '-'));
  }
#line 18560 "parser.c" /* yacc.c:1646  */
    break;

  case 1621:
#line 11162 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_corresponding (cb_build_sub, (yyvsp[-2]), (yyvsp[-4]), (yyvsp[-1]));
  }
#line 18568 "parser.c" /* yacc.c:1646  */
    break;

  case 1622:
#line 11166 "parser.y" /* yacc.c:1646  */
    {
	CB_PENDING ("SUBTRACT TABLE");
	cb_emit_tab_arithmetic (cb_build_sub, (yyvsp[-4]), (yyvsp[-6]), (yyvsp[-3]), (yyvsp[-2]), (yyvsp[-1]));
  }
#line 18577 "parser.c" /* yacc.c:1646  */
    break;

  case 1623:
#line 11174 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-2) - (0)]), SUBTRACT);
  }
#line 18585 "parser.c" /* yacc.c:1646  */
    break;

  case 1624:
#line 11178 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), SUBTRACT);
  }
#line 18593 "parser.c" /* yacc.c:1646  */
    break;

  case 1625:
#line 11188 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("SUPPRESS", 0);
	if (!in_declaratives) {
		cb_error_x (CB_TREE (current_statement),
			    _("SUPPRESS statement must be within DECLARATIVES"));
	}
	CB_PENDING("SUPPRESS");
  }
#line 18606 "parser.c" /* yacc.c:1646  */
    break;

  case 1628:
#line 11206 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("TERMINATE", 0);
	CB_PENDING("TERMINATE");
  }
#line 18615 "parser.c" /* yacc.c:1646  */
    break;

  case 1630:
#line 11215 "parser.y" /* yacc.c:1646  */
    {
	begin_implicit_statement ();
	if ((yyvsp[0]) != cb_error_node) {
	}
  }
#line 18625 "parser.c" /* yacc.c:1646  */
    break;

  case 1631:
#line 11221 "parser.y" /* yacc.c:1646  */
    {
	begin_implicit_statement ();
	if ((yyvsp[0]) != cb_error_node) {
	}
  }
#line 18635 "parser.c" /* yacc.c:1646  */
    break;

  case 1632:
#line 11232 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("TRANSFORM", 0);
  }
#line 18643 "parser.c" /* yacc.c:1646  */
    break;

  case 1634:
#line 11240 "parser.y" /* yacc.c:1646  */
    {
	cb_tree		x;

	x = cb_build_converting ((yyvsp[-2]), (yyvsp[0]), cb_build_inspect_region_start ());
	cb_emit_inspect ((yyvsp[-4]), x, TRANSFORM_STATEMENT);
  }
#line 18654 "parser.c" /* yacc.c:1646  */
    break;

  case 1635:
#line 11253 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("UNLOCK", 0);
  }
#line 18662 "parser.c" /* yacc.c:1646  */
    break;

  case 1637:
#line 11261 "parser.y" /* yacc.c:1646  */
    {
	if (CB_VALID_TREE ((yyvsp[-1]))) {
		if (CB_FILE (cb_ref ((yyvsp[-1])))->organization == COB_ORG_SORT) {
			cb_error_x (CB_TREE (current_statement),
				    _("UNLOCK invalid for SORT files"));
		} else {
			cb_emit_unlock ((yyvsp[-1]));
		}
	}
  }
#line 18677 "parser.c" /* yacc.c:1646  */
    break;

  case 1638:
#line 11277 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("UNSTRING", TERM_UNSTRING);
  }
#line 18685 "parser.c" /* yacc.c:1646  */
    break;

  case 1640:
#line 11288 "parser.y" /* yacc.c:1646  */
    {
	cb_emit_unstring ((yyvsp[-5]), (yyvsp[-4]), (yyvsp[-3]), (yyvsp[-2]), (yyvsp[-1]));
  }
#line 18693 "parser.c" /* yacc.c:1646  */
    break;

  case 1641:
#line 11294 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 18699 "parser.c" /* yacc.c:1646  */
    break;

  case 1642:
#line 11296 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 18705 "parser.c" /* yacc.c:1646  */
    break;

  case 1643:
#line 11300 "parser.y" /* yacc.c:1646  */
    { (yyval) = CB_LIST_INIT ((yyvsp[0])); }
#line 18711 "parser.c" /* yacc.c:1646  */
    break;

  case 1644:
#line 11302 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_list_add ((yyvsp[-2]), (yyvsp[0])); }
#line 18717 "parser.c" /* yacc.c:1646  */
    break;

  case 1645:
#line 11307 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_unstring_delimited ((yyvsp[-1]), (yyvsp[0]));
  }
#line 18725 "parser.c" /* yacc.c:1646  */
    break;

  case 1646:
#line 11313 "parser.y" /* yacc.c:1646  */
    { (yyval) = CB_LIST_INIT ((yyvsp[0])); }
#line 18731 "parser.c" /* yacc.c:1646  */
    break;

  case 1647:
#line 11315 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_list_add ((yyvsp[-1]), (yyvsp[0])); }
#line 18737 "parser.c" /* yacc.c:1646  */
    break;

  case 1648:
#line 11320 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_unstring_into ((yyvsp[-2]), (yyvsp[-1]), (yyvsp[0]));
  }
#line 18745 "parser.c" /* yacc.c:1646  */
    break;

  case 1649:
#line 11326 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 18751 "parser.c" /* yacc.c:1646  */
    break;

  case 1650:
#line 11327 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 18757 "parser.c" /* yacc.c:1646  */
    break;

  case 1651:
#line 11331 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 18763 "parser.c" /* yacc.c:1646  */
    break;

  case 1652:
#line 11332 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 18769 "parser.c" /* yacc.c:1646  */
    break;

  case 1653:
#line 11336 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 18775 "parser.c" /* yacc.c:1646  */
    break;

  case 1654:
#line 11337 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 18781 "parser.c" /* yacc.c:1646  */
    break;

  case 1655:
#line 11342 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-2) - (0)]), UNSTRING);
  }
#line 18789 "parser.c" /* yacc.c:1646  */
    break;

  case 1656:
#line 11346 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), UNSTRING);
  }
#line 18797 "parser.c" /* yacc.c:1646  */
    break;

  case 1657:
#line 11356 "parser.y" /* yacc.c:1646  */
    {
	skip_statements = 0;
	in_debugging = 0;
  }
#line 18806 "parser.c" /* yacc.c:1646  */
    break;

  case 1664:
#line 11374 "parser.y" /* yacc.c:1646  */
    {
	if (!in_declaratives) {
		cb_error (_("USE statement must be within DECLARATIVES"));
	} else if (!current_section) {
		cb_error (_("SECTION header missing before USE statement"));
	} else {
		current_section->flag_begin = 1;
		current_section->flag_return = 1;
		current_section->flag_declarative_exit = 1;
		current_section->flag_real_label = 1;
		current_section->flag_skip_label = 0;
		CB_EXCEPTION_ENABLE (COB_EC_I_O) = 1;
		if (use_global_ind) {
			current_section->flag_global = 1;
			current_program->global_list =
				cb_list_add (current_program->global_list,
					     CB_TREE (current_section));
		}
		emit_statement (cb_build_comment ("USE AFTER ERROR"));
	}
  }
#line 18832 "parser.c" /* yacc.c:1646  */
    break;

  case 1665:
#line 11399 "parser.y" /* yacc.c:1646  */
    {
	use_global_ind = 0;
  }
#line 18840 "parser.c" /* yacc.c:1646  */
    break;

  case 1666:
#line 11403 "parser.y" /* yacc.c:1646  */
    {
	if (current_program->prog_type == CB_FUNCTION_TYPE) {
		cb_error (_("%s is invalid in a user FUNCTION"), "GLOBAL");
	} else {
		use_global_ind = 1;
		current_program->flag_global_use = 1;
	}
  }
#line 18853 "parser.c" /* yacc.c:1646  */
    break;

  case 1667:
#line 11415 "parser.y" /* yacc.c:1646  */
    {
	cb_tree		l;

	for (l = (yyvsp[0]); l; l = CB_CHAIN (l)) {
		if (CB_VALID_TREE (CB_VALUE (l))) {
			setup_use_file (CB_FILE (cb_ref (CB_VALUE (l))));
		}
	}
  }
#line 18867 "parser.c" /* yacc.c:1646  */
    break;

  case 1668:
#line 11425 "parser.y" /* yacc.c:1646  */
    {
	current_program->global_handler[COB_OPEN_INPUT].handler_label = current_section;
	current_program->global_handler[COB_OPEN_INPUT].handler_prog = current_program;
  }
#line 18876 "parser.c" /* yacc.c:1646  */
    break;

  case 1669:
#line 11430 "parser.y" /* yacc.c:1646  */
    {
	current_program->global_handler[COB_OPEN_OUTPUT].handler_label = current_section;
	current_program->global_handler[COB_OPEN_OUTPUT].handler_prog = current_program;
  }
#line 18885 "parser.c" /* yacc.c:1646  */
    break;

  case 1670:
#line 11435 "parser.y" /* yacc.c:1646  */
    {
	current_program->global_handler[COB_OPEN_I_O].handler_label = current_section;
	current_program->global_handler[COB_OPEN_I_O].handler_prog = current_program;
  }
#line 18894 "parser.c" /* yacc.c:1646  */
    break;

  case 1671:
#line 11440 "parser.y" /* yacc.c:1646  */
    {
	current_program->global_handler[COB_OPEN_EXTEND].handler_label = current_section;
	current_program->global_handler[COB_OPEN_EXTEND].handler_prog = current_program;
  }
#line 18903 "parser.c" /* yacc.c:1646  */
    break;

  case 1672:
#line 11448 "parser.y" /* yacc.c:1646  */
    {
	cb_tree		plabel;
	char		name[64];

	cb_verify (cb_use_for_debugging, "USE FOR DEBUGGING");

	if (!in_declaratives) {
		cb_error (_("USE statement must be within DECLARATIVES"));
	} else if (current_program->nested_level) {
		cb_error (_("USE DEBUGGING not supported in contained program"));
	} else {
		in_debugging = 1;
		current_section->flag_begin = 1;
		current_section->flag_return = 1;
		current_section->flag_declarative_exit = 1;
		current_section->flag_real_label = 0;
		current_section->flag_is_debug_sect = 1;
		if (!needs_debug_item) {
			needs_debug_item = 1;
			cb_build_debug_item ();
		}
		if (!current_program->flag_debugging) {
			skip_statements = 1;
			current_section->flag_skip_label = 1;
		} else {
			current_program->flag_gen_debug = 1;
			sprintf (name, "EXIT SECTION %d", cb_id);
			plabel = cb_build_reference (name);
			plabel = cb_build_label (plabel, NULL);
			CB_LABEL (plabel)->flag_begin = 1;
			CB_LABEL (plabel)->flag_dummy_exit = 1;
			current_section->exit_label = plabel;
			emit_statement (cb_build_comment ("USE FOR DEBUGGING"));
		}
	}
  }
#line 18944 "parser.c" /* yacc.c:1646  */
    break;

  case 1675:
#line 11493 "parser.y" /* yacc.c:1646  */
    {
	cb_tree		l;
	cb_tree		x;
	cb_tree		z;

	if (current_program->flag_debugging) {
		CB_REFERENCE ((yyvsp[0]))->debug_section = current_section;
		CB_REFERENCE ((yyvsp[0]))->flag_debug_code = 1;
		CB_REFERENCE ((yyvsp[0]))->flag_all_debug = 0;

		z = CB_LIST_INIT ((yyvsp[0]));
		current_program->debug_list =
			cb_list_append (current_program->debug_list, z);
		/* Check backward refs to file/data names */
		/* Label refs will be checked later (forward/backward ref) */
		if (CB_WORD_COUNT ((yyvsp[0])) > 0) {
			l = CB_VALUE (CB_WORD_ITEMS ((yyvsp[0])));
			switch (CB_TREE_TAG (l)) {
			case CB_TAG_CD:
				CB_CD (l)->debug_section = current_section;
				CB_CD (l)->flag_field_debug = 1;
				break;
			case CB_TAG_FILE:
				CB_FILE (l)->debug_section = current_section;
				CB_FILE (l)->flag_fl_debug = 1;
				break;
			case CB_TAG_FIELD:
				x = cb_ref ((yyvsp[0]));
				if (CB_INVALID_TREE (x)) {
					break;
				}
				needs_field_debug = 1;
				CB_FIELD (x)->debug_section = current_section;
				CB_FIELD (x)->flag_field_debug = 1;
				CB_PURPOSE (z) = x;
				break;
			default:
				break;
			}
		}
	}
  }
#line 18991 "parser.c" /* yacc.c:1646  */
    break;

  case 1676:
#line 11536 "parser.y" /* yacc.c:1646  */
    {
	if (current_program->flag_debugging) {
		if (current_program->all_procedure) {
			cb_error (_("duplicate USE DEBUGGING ON ALL PROCEDURES"));
		} else {
			current_program->all_procedure = current_section;
		}
	}
  }
#line 19005 "parser.c" /* yacc.c:1646  */
    break;

  case 1677:
#line 11546 "parser.y" /* yacc.c:1646  */
    {
	cb_tree		x;

	if (current_program->flag_debugging) {
		/* Reference must be a data item */
		x = cb_ref ((yyvsp[0]));
		if (CB_INVALID_TREE (x) || !CB_FIELD_P (x)) {
			cb_error (_("invalid target for DEBUGGING ALL"));
		} else {
			needs_field_debug = 1;
			CB_FIELD (x)->debug_section = current_section;
			CB_FIELD (x)->flag_field_debug = 1;
			CB_FIELD (x)->flag_all_debug = 1;
			CB_REFERENCE ((yyvsp[0]))->debug_section = current_section;
			CB_REFERENCE ((yyvsp[0]))->flag_debug_code = 1;
			CB_REFERENCE ((yyvsp[0]))->flag_all_debug = 1;
			CB_CHAIN_PAIR (current_program->debug_list, x, (yyvsp[0]));
		}
	}
  }
#line 19030 "parser.c" /* yacc.c:1646  */
    break;

  case 1682:
#line 11576 "parser.y" /* yacc.c:1646  */
    {
	if (current_program->nested_level) {
		cb_error (_("%s is invalid in nested program"), "USE AT");
	}
  }
#line 19040 "parser.c" /* yacc.c:1646  */
    break;

  case 1683:
#line 11585 "parser.y" /* yacc.c:1646  */
    {
	emit_statement (cb_build_comment ("USE AT PROGRAM START"));
	/* emit_entry ("_START", 0, NULL, NULL); */
	CB_PENDING ("USE AT PROGRAM START");
  }
#line 19050 "parser.c" /* yacc.c:1646  */
    break;

  case 1684:
#line 11591 "parser.y" /* yacc.c:1646  */
    {
	emit_statement (cb_build_comment ("USE AT PROGRAM END"));
	/* emit_entry ("_END", 0, NULL, NULL); */
	CB_PENDING ("USE AT PROGRAM END");
  }
#line 19060 "parser.c" /* yacc.c:1646  */
    break;

  case 1685:
#line 11601 "parser.y" /* yacc.c:1646  */
    {
	current_section->flag_real_label = 1;
	emit_statement (cb_build_comment ("USE BEFORE REPORTING"));
	CB_PENDING ("USE BEFORE REPORTING");
  }
#line 19070 "parser.c" /* yacc.c:1646  */
    break;

  case 1686:
#line 11610 "parser.y" /* yacc.c:1646  */
    {
	current_section->flag_real_label = 1;
	emit_statement (cb_build_comment ("USE AFTER EXCEPTION CONDITION"));
	CB_PENDING ("USE AFTER EXCEPTION CONDITION");
  }
#line 19080 "parser.c" /* yacc.c:1646  */
    break;

  case 1689:
#line 11626 "parser.y" /* yacc.c:1646  */
    {
	begin_statement ("WRITE", TERM_WRITE);
	/* Special in debugging mode */
	save_debug = start_debug;
	start_debug = 0;
  }
#line 19091 "parser.c" /* yacc.c:1646  */
    break;

  case 1691:
#line 11638 "parser.y" /* yacc.c:1646  */
    {
	if (CB_VALID_TREE ((yyvsp[-5]))) {
		cb_emit_write ((yyvsp[-5]), (yyvsp[-4]), (yyvsp[-3]), (yyvsp[-1]));
	}
	start_debug = save_debug;
  }
#line 19102 "parser.c" /* yacc.c:1646  */
    break;

  case 1692:
#line 11647 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 19108 "parser.c" /* yacc.c:1646  */
    break;

  case 1693:
#line 11648 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 19114 "parser.c" /* yacc.c:1646  */
    break;

  case 1694:
#line 11653 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int0;
  }
#line 19122 "parser.c" /* yacc.c:1646  */
    break;

  case 1695:
#line 11657 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_write_advancing_lines ((yyvsp[-3]), (yyvsp[-1]));
  }
#line 19130 "parser.c" /* yacc.c:1646  */
    break;

  case 1696:
#line 11661 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_write_advancing_mnemonic ((yyvsp[-2]), (yyvsp[0]));
  }
#line 19138 "parser.c" /* yacc.c:1646  */
    break;

  case 1697:
#line 11665 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_write_advancing_page ((yyvsp[-2]));
  }
#line 19146 "parser.c" /* yacc.c:1646  */
    break;

  case 1698:
#line 11671 "parser.y" /* yacc.c:1646  */
    { (yyval) = CB_BEFORE; }
#line 19152 "parser.c" /* yacc.c:1646  */
    break;

  case 1699:
#line 11672 "parser.y" /* yacc.c:1646  */
    { (yyval) = CB_AFTER; }
#line 19158 "parser.c" /* yacc.c:1646  */
    break;

  case 1703:
#line 11683 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_WARNING ((yyvsp[(-2) - (0)]), WRITE);
  }
#line 19166 "parser.c" /* yacc.c:1646  */
    break;

  case 1704:
#line 11687 "parser.y" /* yacc.c:1646  */
    {
	TERMINATOR_CLEAR ((yyvsp[(-2) - (1)]), WRITE);
  }
#line 19174 "parser.c" /* yacc.c:1646  */
    break;

  case 1707:
#line 11701 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0])) {
		cb_verify (cb_not_exception_before_exception,
			_("NOT EXCEPTION before EXCEPTION"));
	}
  }
#line 19185 "parser.c" /* yacc.c:1646  */
    break;

  case 1708:
#line 11711 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 19193 "parser.c" /* yacc.c:1646  */
    break;

  case 1709:
#line 11715 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int1;
  }
#line 19201 "parser.c" /* yacc.c:1646  */
    break;

  case 1710:
#line 11722 "parser.y" /* yacc.c:1646  */
    {
	current_statement->handler_type = ACCEPT_HANDLER;
	current_statement->ex_handler = (yyvsp[0]);
  }
#line 19210 "parser.c" /* yacc.c:1646  */
    break;

  case 1715:
#line 11740 "parser.y" /* yacc.c:1646  */
    {
	current_statement->handler_type = ACCEPT_HANDLER;
	current_statement->not_ex_handler = (yyvsp[0]);
  }
#line 19219 "parser.c" /* yacc.c:1646  */
    break;

  case 1720:
#line 11756 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0])) {
		cb_verify (cb_not_exception_before_exception,
			_("NOT EXCEPTION before EXCEPTION"));
	}
  }
#line 19230 "parser.c" /* yacc.c:1646  */
    break;

  case 1721:
#line 11766 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 19238 "parser.c" /* yacc.c:1646  */
    break;

  case 1722:
#line 11770 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int1;
  }
#line 19246 "parser.c" /* yacc.c:1646  */
    break;

  case 1723:
#line 11777 "parser.y" /* yacc.c:1646  */
    {
	current_statement->handler_type = DISPLAY_HANDLER;
	current_statement->ex_handler = (yyvsp[0]);
  }
#line 19255 "parser.c" /* yacc.c:1646  */
    break;

  case 1726:
#line 11790 "parser.y" /* yacc.c:1646  */
    {
	current_statement->handler_type = DISPLAY_HANDLER;
	current_statement->not_ex_handler = (yyvsp[0]);
  }
#line 19264 "parser.c" /* yacc.c:1646  */
    break;

  case 1729:
#line 11802 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0])) {
		cb_verify (cb_not_exception_before_exception,
			_("NOT SIZE ERROR before SIZE ERROR"));
	}
  }
#line 19275 "parser.c" /* yacc.c:1646  */
    break;

  case 1730:
#line 11812 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 19283 "parser.c" /* yacc.c:1646  */
    break;

  case 1731:
#line 11816 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int1;
  }
#line 19291 "parser.c" /* yacc.c:1646  */
    break;

  case 1732:
#line 11823 "parser.y" /* yacc.c:1646  */
    {
	current_statement->handler_type = SIZE_ERROR_HANDLER;
	current_statement->ex_handler = (yyvsp[0]);
  }
#line 19300 "parser.c" /* yacc.c:1646  */
    break;

  case 1735:
#line 11836 "parser.y" /* yacc.c:1646  */
    {
	current_statement->handler_type = SIZE_ERROR_HANDLER;
	current_statement->not_ex_handler = (yyvsp[0]);
  }
#line 19309 "parser.c" /* yacc.c:1646  */
    break;

  case 1738:
#line 11848 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0])) {
		cb_verify (cb_not_exception_before_exception,
			_("NOT OVERFLOW before OVERFLOW"));
	}
  }
#line 19320 "parser.c" /* yacc.c:1646  */
    break;

  case 1739:
#line 11858 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 19328 "parser.c" /* yacc.c:1646  */
    break;

  case 1740:
#line 11862 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int1;
  }
#line 19336 "parser.c" /* yacc.c:1646  */
    break;

  case 1741:
#line 11869 "parser.y" /* yacc.c:1646  */
    {
	current_statement->handler_type = OVERFLOW_HANDLER;
	current_statement->ex_handler = (yyvsp[0]);
  }
#line 19345 "parser.c" /* yacc.c:1646  */
    break;

  case 1744:
#line 11882 "parser.y" /* yacc.c:1646  */
    {
	current_statement->handler_type = OVERFLOW_HANDLER;
	current_statement->not_ex_handler = (yyvsp[0]);
  }
#line 19354 "parser.c" /* yacc.c:1646  */
    break;

  case 1746:
#line 11894 "parser.y" /* yacc.c:1646  */
    {
	cb_verify (cb_not_exception_before_exception, "NOT AT END before AT END");
  }
#line 19362 "parser.c" /* yacc.c:1646  */
    break;

  case 1748:
#line 11903 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0])) {
		cb_verify (cb_not_exception_before_exception, "NOT AT END before AT END");
	}
  }
#line 19372 "parser.c" /* yacc.c:1646  */
    break;

  case 1749:
#line 11912 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 19380 "parser.c" /* yacc.c:1646  */
    break;

  case 1750:
#line 11916 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int1;
  }
#line 19388 "parser.c" /* yacc.c:1646  */
    break;

  case 1751:
#line 11923 "parser.y" /* yacc.c:1646  */
    {
	current_statement->handler_type = AT_END_HANDLER;
	current_statement->ex_handler = (yyvsp[0]);
  }
#line 19397 "parser.c" /* yacc.c:1646  */
    break;

  case 1754:
#line 11936 "parser.y" /* yacc.c:1646  */
    {
	current_statement->handler_type = AT_END_HANDLER;
	current_statement->not_ex_handler = (yyvsp[0]);
  }
#line 19406 "parser.c" /* yacc.c:1646  */
    break;

  case 1756:
#line 11947 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0])) {
		cb_verify (cb_not_exception_before_exception,
			_("NOT AT END-OF-PAGE before AT END-OF-PAGE"));
	}
  }
#line 19417 "parser.c" /* yacc.c:1646  */
    break;

  case 1757:
#line 11957 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 19425 "parser.c" /* yacc.c:1646  */
    break;

  case 1758:
#line 11961 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int1;
  }
#line 19433 "parser.c" /* yacc.c:1646  */
    break;

  case 1759:
#line 11968 "parser.y" /* yacc.c:1646  */
    {
	current_statement->handler_type = EOP_HANDLER;
	current_statement->ex_handler = (yyvsp[0]);
  }
#line 19442 "parser.c" /* yacc.c:1646  */
    break;

  case 1762:
#line 11981 "parser.y" /* yacc.c:1646  */
    {
	current_statement->handler_type = EOP_HANDLER;
	current_statement->not_ex_handler = (yyvsp[0]);
  }
#line 19451 "parser.c" /* yacc.c:1646  */
    break;

  case 1766:
#line 11997 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0])) {
		cb_verify (cb_not_exception_before_exception,
			_("NOT INVALID KEY before INVALID KEY"));
	}
  }
#line 19462 "parser.c" /* yacc.c:1646  */
    break;

  case 1767:
#line 12007 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 19470 "parser.c" /* yacc.c:1646  */
    break;

  case 1768:
#line 12011 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int1;
  }
#line 19478 "parser.c" /* yacc.c:1646  */
    break;

  case 1769:
#line 12018 "parser.y" /* yacc.c:1646  */
    {
	current_statement->handler_type = INVALID_KEY_HANDLER;
	current_statement->ex_handler = (yyvsp[0]);
  }
#line 19487 "parser.c" /* yacc.c:1646  */
    break;

  case 1772:
#line 12031 "parser.y" /* yacc.c:1646  */
    {
	current_statement->handler_type = INVALID_KEY_HANDLER;
	current_statement->not_ex_handler = (yyvsp[0]);
  }
#line 19496 "parser.c" /* yacc.c:1646  */
    break;

  case 1773:
#line 12041 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 19504 "parser.c" /* yacc.c:1646  */
    break;

  case 1774:
#line 12045 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int1;
	CB_PENDING ("THREAD");
  }
#line 19513 "parser.c" /* yacc.c:1646  */
    break;

  case 1775:
#line 12053 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 19521 "parser.c" /* yacc.c:1646  */
    break;

  case 1776:
#line 12057 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
	CB_PENDING ("THREAD");
  }
#line 19530 "parser.c" /* yacc.c:1646  */
    break;

  case 1777:
#line 12065 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 19538 "parser.c" /* yacc.c:1646  */
    break;

  case 1778:
#line 12069 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 19546 "parser.c" /* yacc.c:1646  */
    break;

  case 1779:
#line 12078 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_one;
  }
#line 19554 "parser.c" /* yacc.c:1646  */
    break;

  case 1780:
#line 12082 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[-1]);
  }
#line 19562 "parser.c" /* yacc.c:1646  */
    break;

  case 1781:
#line 12092 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_cond ((yyvsp[0]));
	cb_end_cond ((yyval));
  }
#line 19571 "parser.c" /* yacc.c:1646  */
    break;

  case 1782:
#line 12100 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_expr ((yyvsp[0]));
  }
#line 19579 "parser.c" /* yacc.c:1646  */
    break;

  case 1783:
#line 12106 "parser.y" /* yacc.c:1646  */
    {
	current_expr = NULL;
	cb_exp_line = cb_source_line;
  }
#line 19588 "parser.c" /* yacc.c:1646  */
    break;

  case 1784:
#line 12111 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_list_reverse (current_expr);
  }
#line 19596 "parser.c" /* yacc.c:1646  */
    break;

  case 1787:
#line 12122 "parser.y" /* yacc.c:1646  */
    { push_expr ('x', (yyvsp[0])); }
#line 19602 "parser.c" /* yacc.c:1646  */
    break;

  case 1790:
#line 12127 "parser.y" /* yacc.c:1646  */
    { push_expr ('x', cb_zero); }
#line 19608 "parser.c" /* yacc.c:1646  */
    break;

  case 1791:
#line 12129 "parser.y" /* yacc.c:1646  */
    { push_expr ('(', NULL); }
#line 19614 "parser.c" /* yacc.c:1646  */
    break;

  case 1792:
#line 12130 "parser.y" /* yacc.c:1646  */
    { push_expr (')', NULL); }
#line 19620 "parser.c" /* yacc.c:1646  */
    break;

  case 1793:
#line 12132 "parser.y" /* yacc.c:1646  */
    { push_expr ('+', NULL); }
#line 19626 "parser.c" /* yacc.c:1646  */
    break;

  case 1794:
#line 12133 "parser.y" /* yacc.c:1646  */
    { push_expr ('-', NULL); }
#line 19632 "parser.c" /* yacc.c:1646  */
    break;

  case 1795:
#line 12134 "parser.y" /* yacc.c:1646  */
    { push_expr ('*', NULL); }
#line 19638 "parser.c" /* yacc.c:1646  */
    break;

  case 1796:
#line 12135 "parser.y" /* yacc.c:1646  */
    { push_expr ('/', NULL); }
#line 19644 "parser.c" /* yacc.c:1646  */
    break;

  case 1797:
#line 12136 "parser.y" /* yacc.c:1646  */
    { push_expr ('^', NULL); }
#line 19650 "parser.c" /* yacc.c:1646  */
    break;

  case 1799:
#line 12139 "parser.y" /* yacc.c:1646  */
    { push_expr ('&', NULL); }
#line 19656 "parser.c" /* yacc.c:1646  */
    break;

  case 1800:
#line 12140 "parser.y" /* yacc.c:1646  */
    { push_expr ('|', NULL); }
#line 19662 "parser.c" /* yacc.c:1646  */
    break;

  case 1803:
#line 12149 "parser.y" /* yacc.c:1646  */
    { push_expr ('!', NULL); }
#line 19668 "parser.c" /* yacc.c:1646  */
    break;

  case 1804:
#line 12152 "parser.y" /* yacc.c:1646  */
    { push_expr ('C', (yyvsp[0])); }
#line 19674 "parser.c" /* yacc.c:1646  */
    break;

  case 1805:
#line 12154 "parser.y" /* yacc.c:1646  */
    { push_expr ('=', NULL); }
#line 19680 "parser.c" /* yacc.c:1646  */
    break;

  case 1806:
#line 12155 "parser.y" /* yacc.c:1646  */
    { push_expr ('>', NULL); }
#line 19686 "parser.c" /* yacc.c:1646  */
    break;

  case 1807:
#line 12156 "parser.y" /* yacc.c:1646  */
    { push_expr ('<', NULL); }
#line 19692 "parser.c" /* yacc.c:1646  */
    break;

  case 1808:
#line 12157 "parser.y" /* yacc.c:1646  */
    { push_expr (']', NULL); }
#line 19698 "parser.c" /* yacc.c:1646  */
    break;

  case 1809:
#line 12158 "parser.y" /* yacc.c:1646  */
    { push_expr ('[', NULL); }
#line 19704 "parser.c" /* yacc.c:1646  */
    break;

  case 1810:
#line 12159 "parser.y" /* yacc.c:1646  */
    { push_expr ('~', NULL); }
#line 19710 "parser.c" /* yacc.c:1646  */
    break;

  case 1811:
#line 12161 "parser.y" /* yacc.c:1646  */
    { push_expr ('O', NULL); }
#line 19716 "parser.c" /* yacc.c:1646  */
    break;

  case 1812:
#line 12162 "parser.y" /* yacc.c:1646  */
    { push_expr ('9', NULL); }
#line 19722 "parser.c" /* yacc.c:1646  */
    break;

  case 1813:
#line 12163 "parser.y" /* yacc.c:1646  */
    { push_expr ('A', NULL); }
#line 19728 "parser.c" /* yacc.c:1646  */
    break;

  case 1814:
#line 12164 "parser.y" /* yacc.c:1646  */
    { push_expr ('L', NULL); }
#line 19734 "parser.c" /* yacc.c:1646  */
    break;

  case 1815:
#line 12165 "parser.y" /* yacc.c:1646  */
    { push_expr ('U', NULL); }
#line 19740 "parser.c" /* yacc.c:1646  */
    break;

  case 1816:
#line 12168 "parser.y" /* yacc.c:1646  */
    { push_expr ('P', NULL); }
#line 19746 "parser.c" /* yacc.c:1646  */
    break;

  case 1817:
#line 12169 "parser.y" /* yacc.c:1646  */
    { push_expr ('N', NULL); }
#line 19752 "parser.c" /* yacc.c:1646  */
    break;

  case 1826:
#line 12199 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_LIST_INIT ((yyvsp[0]));
  }
#line 19760 "parser.c" /* yacc.c:1646  */
    break;

  case 1827:
#line 12203 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_list_add ((yyvsp[-2]), (yyvsp[0]));
  }
#line 19768 "parser.c" /* yacc.c:1646  */
    break;

  case 1831:
#line 12214 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_build_binary_op ((yyvsp[-2]), '+', (yyvsp[0])); }
#line 19774 "parser.c" /* yacc.c:1646  */
    break;

  case 1832:
#line 12215 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_build_binary_op ((yyvsp[-2]), '-', (yyvsp[0])); }
#line 19780 "parser.c" /* yacc.c:1646  */
    break;

  case 1833:
#line 12216 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 19786 "parser.c" /* yacc.c:1646  */
    break;

  case 1834:
#line 12220 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_build_binary_op ((yyvsp[-2]), '*', (yyvsp[0])); }
#line 19792 "parser.c" /* yacc.c:1646  */
    break;

  case 1835:
#line 12221 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_build_binary_op ((yyvsp[-2]), '/', (yyvsp[0])); }
#line 19798 "parser.c" /* yacc.c:1646  */
    break;

  case 1836:
#line 12222 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 19804 "parser.c" /* yacc.c:1646  */
    break;

  case 1837:
#line 12227 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_binary_op ((yyvsp[-2]), '^', (yyvsp[0]));
  }
#line 19812 "parser.c" /* yacc.c:1646  */
    break;

  case 1838:
#line 12230 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 19818 "parser.c" /* yacc.c:1646  */
    break;

  case 1839:
#line 12234 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 19824 "parser.c" /* yacc.c:1646  */
    break;

  case 1840:
#line 12235 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_build_binary_op (cb_zero, '-', (yyvsp[0])); }
#line 19830 "parser.c" /* yacc.c:1646  */
    break;

  case 1841:
#line 12236 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 19836 "parser.c" /* yacc.c:1646  */
    break;

  case 1842:
#line 12239 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[-1]); }
#line 19842 "parser.c" /* yacc.c:1646  */
    break;

  case 1843:
#line 12240 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 19848 "parser.c" /* yacc.c:1646  */
    break;

  case 1844:
#line 12251 "parser.y" /* yacc.c:1646  */
    {
	if (current_linage > 1) {
		cb_error (_("LINAGE-COUNTER must be qualified here"));
		(yyval) = cb_error_node;
	} else if (current_linage == 0) {
		cb_error (_("invalid LINAGE-COUNTER usage"));
		(yyval) = cb_error_node;
	} else {
		(yyval) = linage_file->linage_ctr;
	}
  }
#line 19864 "parser.c" /* yacc.c:1646  */
    break;

  case 1845:
#line 12263 "parser.y" /* yacc.c:1646  */
    {
	if (CB_FILE_P (cb_ref ((yyvsp[0])))) {
		(yyval) = CB_FILE (cb_ref ((yyvsp[0])))->linage_ctr;
	} else {
		cb_error_x ((yyvsp[0]), _("'%s' is not a file name"), CB_NAME ((yyvsp[0])));
		(yyval) = cb_error_node;
	}
  }
#line 19877 "parser.c" /* yacc.c:1646  */
    break;

  case 1846:
#line 12272 "parser.y" /* yacc.c:1646  */
    {
	if (report_count > 1) {
		cb_error (_("LINE-COUNTER must be qualified here"));
		(yyval) = cb_error_node;
	} else if (report_count == 0) {
		cb_error (_("invalid LINE-COUNTER usage"));
		(yyval) = cb_error_node;
	} else {
		(yyval) = report_instance->line_counter;
	}
  }
#line 19893 "parser.c" /* yacc.c:1646  */
    break;

  case 1847:
#line 12284 "parser.y" /* yacc.c:1646  */
    {
	if (CB_REPORT_P (cb_ref ((yyvsp[0])))) {
		(yyval) = CB_REPORT (cb_ref ((yyvsp[0])))->line_counter;
	} else {
		cb_error_x ((yyvsp[0]), _("'%s' is not a report name"), CB_NAME ((yyvsp[0])));
		(yyval) = cb_error_node;
	}
  }
#line 19906 "parser.c" /* yacc.c:1646  */
    break;

  case 1848:
#line 12293 "parser.y" /* yacc.c:1646  */
    {
	if (report_count > 1) {
		cb_error (_("PAGE-COUNTER must be qualified here"));
		(yyval) = cb_error_node;
	} else if (report_count == 0) {
		cb_error (_("invalid PAGE-COUNTER usage"));
		(yyval) = cb_error_node;
	} else {
		(yyval) = report_instance->page_counter;
	}
  }
#line 19922 "parser.c" /* yacc.c:1646  */
    break;

  case 1849:
#line 12305 "parser.y" /* yacc.c:1646  */
    {
	if (CB_REPORT_P (cb_ref ((yyvsp[0])))) {
		(yyval) = CB_REPORT (cb_ref ((yyvsp[0])))->page_counter;
	} else {
		cb_error_x ((yyvsp[0]), _("'%s' is not a report name"), CB_NAME ((yyvsp[0])));
		(yyval) = cb_error_node;
	}
  }
#line 19935 "parser.c" /* yacc.c:1646  */
    break;

  case 1850:
#line 12319 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 19941 "parser.c" /* yacc.c:1646  */
    break;

  case 1851:
#line 12321 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_list_append ((yyvsp[-1]), (yyvsp[0])); }
#line 19947 "parser.c" /* yacc.c:1646  */
    break;

  case 1852:
#line 12326 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_BUILD_PAIR ((yyvsp[0]), (yyvsp[-1]));
  }
#line 19955 "parser.c" /* yacc.c:1646  */
    break;

  case 1853:
#line 12334 "parser.y" /* yacc.c:1646  */
    { cb_build_identifier ((yyvsp[0]), 0); }
#line 19961 "parser.c" /* yacc.c:1646  */
    break;

  case 1854:
#line 12341 "parser.y" /* yacc.c:1646  */
    {
	if (!CB_FILE_P (cb_ref ((yyvsp[0])))) {
		(yyval) = (yyvsp[0]);
	} else {
		cb_error_x ((yyvsp[0]), _("%s requires a record name as subject"),
			current_statement->name);
		(yyval) = cb_error_node;
	}
  }
#line 19975 "parser.c" /* yacc.c:1646  */
    break;

  case 1855:
#line 12351 "parser.y" /* yacc.c:1646  */
    {
	if (CB_FILE_P (cb_ref ((yyvsp[0])))) {
		(yyval) = (yyvsp[0]);
	} else {
		cb_error_x ((yyvsp[0]), _("'%s' is not a file name"), CB_NAME ((yyvsp[0])));
		(yyval) = cb_error_node;
	}
  }
#line 19988 "parser.c" /* yacc.c:1646  */
    break;

  case 1856:
#line 12365 "parser.y" /* yacc.c:1646  */
    {
	cb_tree x;

	x = cb_ref ((yyvsp[0]));
	if (!CB_FIELD_P (x)) {
		(yyval) = cb_error_node;
	} else if (!CB_FIELD (x)->index_list) {
		cb_error_x ((yyvsp[0]), _("'%s' not indexed"), cb_name ((yyvsp[0])));
		listprint_suppress ();
		cb_error_x (x, _("'%s' defined here"), cb_name (x));
		listprint_restore ();
		(yyval) = cb_error_node;
	} else {
		(yyval) = (yyvsp[0]);
	}
  }
#line 20009 "parser.c" /* yacc.c:1646  */
    break;

  case 1857:
#line 12387 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_LIST_INIT ((yyvsp[0]));
  }
#line 20017 "parser.c" /* yacc.c:1646  */
    break;

  case 1858:
#line 12391 "parser.y" /* yacc.c:1646  */
    {
	cb_tree		l;

	if (CB_VALID_TREE ((yyvsp[0]))) {
		for (l = (yyvsp[-1]); l; l = CB_CHAIN (l)) {
			if (CB_VALID_TREE (CB_VALUE (l)) &&
			    !strcasecmp (CB_NAME ((yyvsp[0])), CB_NAME (CB_VALUE (l)))) {
				cb_error_x ((yyvsp[0]), _("multiple reference to '%s' "),
					    CB_NAME ((yyvsp[0])));
				break;
			}
		}
		if (!l) {
			(yyval) = cb_list_add ((yyvsp[-1]), (yyvsp[0]));
		}
	}
  }
#line 20039 "parser.c" /* yacc.c:1646  */
    break;

  case 1859:
#line 12412 "parser.y" /* yacc.c:1646  */
    {
	if (CB_FILE_P (cb_ref ((yyvsp[0])))) {
		(yyval) = (yyvsp[0]);
	} else {
		cb_error_x ((yyvsp[0]), _("'%s' is not a file name"), CB_NAME ((yyvsp[0])));
		(yyval) = cb_error_node;
	}
  }
#line 20052 "parser.c" /* yacc.c:1646  */
    break;

  case 1860:
#line 12424 "parser.y" /* yacc.c:1646  */
    {
	if (CB_CD_P (cb_ref ((yyvsp[0])))) {
		(yyval) = (yyvsp[0]);
	} else {
		cb_error_x ((yyvsp[0]), _("'%s' is not a CD name"), CB_NAME ((yyvsp[0])));
		(yyval) = cb_error_node;
	}
  }
#line 20065 "parser.c" /* yacc.c:1646  */
    break;

  case 1861:
#line 12465 "parser.y" /* yacc.c:1646  */
    {
	if (CB_REPORT_P (cb_ref ((yyvsp[0])))) {
		(yyval) = (yyvsp[0]);
	} else {
		cb_error_x ((yyvsp[0]), _("'%s' is not a report name"), CB_NAME ((yyvsp[0])));
		(yyval) = cb_error_node;
	}
  }
#line 20078 "parser.c" /* yacc.c:1646  */
    break;

  case 1862:
#line 12478 "parser.y" /* yacc.c:1646  */
    { (yyval) = CB_LIST_INIT ((yyvsp[0])); }
#line 20084 "parser.c" /* yacc.c:1646  */
    break;

  case 1863:
#line 12480 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_list_add ((yyvsp[-1]), (yyvsp[0])); }
#line 20090 "parser.c" /* yacc.c:1646  */
    break;

  case 1864:
#line 12484 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 20096 "parser.c" /* yacc.c:1646  */
    break;

  case 1865:
#line 12490 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 20102 "parser.c" /* yacc.c:1646  */
    break;

  case 1866:
#line 12492 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_list_add ((yyvsp[-1]), (yyvsp[0])); }
#line 20108 "parser.c" /* yacc.c:1646  */
    break;

  case 1867:
#line 12497 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
	CB_REFERENCE ((yyval))->offset = CB_TREE (current_section);
	CB_REFERENCE ((yyval))->flag_in_decl = !!in_declaratives;
	CB_REFERENCE ((yyval))->section = current_section;
	CB_REFERENCE ((yyval))->paragraph = current_paragraph;
	CB_ADD_TO_CHAIN ((yyval), current_program->label_list);
  }
#line 20121 "parser.c" /* yacc.c:1646  */
    break;

  case 1870:
#line 12511 "parser.y" /* yacc.c:1646  */
    {
	CB_REFERENCE ((yyvsp[-2]))->chain = (yyvsp[0]);
  }
#line 20129 "parser.c" /* yacc.c:1646  */
    break;

  case 1871:
#line 12518 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_reference ((char *)(CB_LITERAL ((yyvsp[0]))->data));
	(yyval)->source_file = (yyvsp[0])->source_file;
	(yyval)->source_line = (yyvsp[0])->source_line;
  }
#line 20139 "parser.c" /* yacc.c:1646  */
    break;

  case 1872:
#line 12528 "parser.y" /* yacc.c:1646  */
    { (yyval) = CB_LIST_INIT ((yyvsp[0])); }
#line 20145 "parser.c" /* yacc.c:1646  */
    break;

  case 1873:
#line 12529 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_list_add ((yyvsp[-1]), (yyvsp[0])); }
#line 20151 "parser.c" /* yacc.c:1646  */
    break;

  case 1874:
#line 12534 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
	CB_ADD_TO_CHAIN ((yyval), current_program->reference_list);
  }
#line 20160 "parser.c" /* yacc.c:1646  */
    break;

  case 1875:
#line 12542 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
	CB_ADD_TO_CHAIN ((yyval), current_program->reference_list);
  }
#line 20169 "parser.c" /* yacc.c:1646  */
    break;

  case 1876:
#line 12550 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_LIST_INIT ((yyvsp[0]));
  }
#line 20177 "parser.c" /* yacc.c:1646  */
    break;

  case 1877:
#line 12554 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_list_add ((yyvsp[-1]), (yyvsp[0]));
  }
#line 20185 "parser.c" /* yacc.c:1646  */
    break;

  case 1878:
#line 12561 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
	CB_REFERENCE((yyval))->flag_optional = 1;
	CB_ADD_TO_CHAIN ((yyval), current_program->reference_list);
  }
#line 20195 "parser.c" /* yacc.c:1646  */
    break;

  case 1881:
#line 12577 "parser.y" /* yacc.c:1646  */
    {
	if (CB_WORD_COUNT ((yyvsp[0])) > 0) {
		redefinition_error ((yyvsp[0]));
		(yyval) = cb_error_node;
	} else {
		(yyval) = (yyvsp[0]);
	}
  }
#line 20208 "parser.c" /* yacc.c:1646  */
    break;

  case 1882:
#line 12586 "parser.y" /* yacc.c:1646  */
    {
	yyclearin;
	yyerrok;
	(yyval) = cb_error_node;
  }
#line 20218 "parser.c" /* yacc.c:1646  */
    break;

  case 1883:
#line 12597 "parser.y" /* yacc.c:1646  */
    {
	if (CB_REFERENCE ((yyvsp[0]))->flag_duped || CB_WORD_COUNT ((yyvsp[0])) > 0) {
		redefinition_error ((yyvsp[0]));
		(yyval) = NULL;
	} else {
		CB_WORD_COUNT ((yyvsp[0]))++;
		(yyval) = (yyvsp[0]);
	}
  }
#line 20232 "parser.c" /* yacc.c:1646  */
    break;

  case 1884:
#line 12614 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_LIST_INIT ((yyvsp[0]));
  }
#line 20240 "parser.c" /* yacc.c:1646  */
    break;

  case 1885:
#line 12618 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_list_add ((yyvsp[-1]), (yyvsp[0]));
  }
#line 20248 "parser.c" /* yacc.c:1646  */
    break;

  case 1888:
#line 12627 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_address ((yyvsp[0]));
  }
#line 20256 "parser.c" /* yacc.c:1646  */
    break;

  case 1889:
#line 12633 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 20262 "parser.c" /* yacc.c:1646  */
    break;

  case 1890:
#line 12634 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 20268 "parser.c" /* yacc.c:1646  */
    break;

  case 1891:
#line 12639 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_LIST_INIT ((yyvsp[0]));
  }
#line 20276 "parser.c" /* yacc.c:1646  */
    break;

  case 1892:
#line 12643 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_list_add ((yyvsp[-1]), (yyvsp[0]));
  }
#line 20284 "parser.c" /* yacc.c:1646  */
    break;

  case 1900:
#line 12663 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_length ((yyvsp[0]));
  }
#line 20292 "parser.c" /* yacc.c:1646  */
    break;

  case 1901:
#line 12667 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_length ((yyvsp[0]));
  }
#line 20300 "parser.c" /* yacc.c:1646  */
    break;

  case 1902:
#line 12671 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_length ((yyvsp[0]));
  }
#line 20308 "parser.c" /* yacc.c:1646  */
    break;

  case 1903:
#line 12675 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_ppointer ((yyvsp[0]));
  }
#line 20316 "parser.c" /* yacc.c:1646  */
    break;

  case 1904:
#line 12679 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_address ((yyvsp[0]));
  }
#line 20324 "parser.c" /* yacc.c:1646  */
    break;

  case 1905:
#line 12683 "parser.y" /* yacc.c:1646  */
    {
	cb_tree		x;
	cb_tree		switch_id;

	x = cb_ref ((yyvsp[0]));
	if (CB_VALID_TREE (x)) {
		if (CB_SYSTEM_NAME (x)->category != CB_SWITCH_NAME) {
			cb_error_x ((yyvsp[0]), _("invalid mnemonic identifier"));
			(yyval) = cb_error_node;
		} else {
			switch_id = cb_int (CB_SYSTEM_NAME (x)->token);
			(yyval) = CB_BUILD_FUNCALL_1 ("cob_switch_value", switch_id);
		}
	} else {
		(yyval) = cb_error_node;
	}
  }
#line 20346 "parser.c" /* yacc.c:1646  */
    break;

  case 1906:
#line 12704 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_LIST_INIT ((yyvsp[0]));
  }
#line 20354 "parser.c" /* yacc.c:1646  */
    break;

  case 1907:
#line 12708 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_list_add ((yyvsp[-1]), (yyvsp[0]));
  }
#line 20362 "parser.c" /* yacc.c:1646  */
    break;

  case 1915:
#line 12725 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_length ((yyvsp[0]));
  }
#line 20370 "parser.c" /* yacc.c:1646  */
    break;

  case 1916:
#line 12729 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_length ((yyvsp[0]));
  }
#line 20378 "parser.c" /* yacc.c:1646  */
    break;

  case 1917:
#line 12733 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_length ((yyvsp[0]));
  }
#line 20386 "parser.c" /* yacc.c:1646  */
    break;

  case 1922:
#line 12750 "parser.y" /* yacc.c:1646  */
    {
	error_if_not_usage_display_or_nonnumeric_lit ((yyvsp[0]));
  }
#line 20394 "parser.c" /* yacc.c:1646  */
    break;

  case 1923:
#line 12757 "parser.y" /* yacc.c:1646  */
    {
	error_if_not_usage_display_or_nonnumeric_lit ((yyvsp[0]));
  }
#line 20402 "parser.c" /* yacc.c:1646  */
    break;

  case 1929:
#line 12775 "parser.y" /* yacc.c:1646  */
    {
	check_not_88_level ((yyvsp[0]));
  }
#line 20410 "parser.c" /* yacc.c:1646  */
    break;

  case 1931:
#line 12783 "parser.y" /* yacc.c:1646  */
    {
	check_not_88_level ((yyvsp[0]));
  }
#line 20418 "parser.c" /* yacc.c:1646  */
    break;

  case 1934:
#line 12792 "parser.y" /* yacc.c:1646  */
    {
	check_not_88_level ((yyvsp[0]));
  }
#line 20426 "parser.c" /* yacc.c:1646  */
    break;

  case 1937:
#line 12801 "parser.y" /* yacc.c:1646  */
    {
	check_not_88_level ((yyvsp[0]));
  }
#line 20434 "parser.c" /* yacc.c:1646  */
    break;

  case 1939:
#line 12806 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_zero;
  }
#line 20442 "parser.c" /* yacc.c:1646  */
    break;

  case 1940:
#line 12813 "parser.y" /* yacc.c:1646  */
    {
	check_not_88_level ((yyvsp[0]));
  }
#line 20450 "parser.c" /* yacc.c:1646  */
    break;

  case 1942:
#line 12821 "parser.y" /* yacc.c:1646  */
    {
	check_not_88_level ((yyvsp[0]));
  }
#line 20458 "parser.c" /* yacc.c:1646  */
    break;

  case 1944:
#line 12829 "parser.y" /* yacc.c:1646  */
    {
	check_not_88_level ((yyvsp[0]));
  }
#line 20466 "parser.c" /* yacc.c:1646  */
    break;

  case 1947:
#line 12839 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_build_identifier ((yyvsp[0]), 0); }
#line 20472 "parser.c" /* yacc.c:1646  */
    break;

  case 1948:
#line 12843 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_build_identifier ((yyvsp[0]), 1); }
#line 20478 "parser.c" /* yacc.c:1646  */
    break;

  case 1949:
#line 12847 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 20484 "parser.c" /* yacc.c:1646  */
    break;

  case 1950:
#line 12848 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[-1]); }
#line 20490 "parser.c" /* yacc.c:1646  */
    break;

  case 1951:
#line 12853 "parser.y" /* yacc.c:1646  */
    {
	error_if_not_usage_display_or_nonnumeric_lit ((yyvsp[0]));
  }
#line 20498 "parser.c" /* yacc.c:1646  */
    break;

  case 1952:
#line 12860 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0]) != cb_error_node
	    && cb_tree_category ((yyvsp[0])) != CB_CATEGORY_NUMERIC) {
		cb_error_x ((yyvsp[0]), _("'%s' is not numeric"), cb_name ((yyvsp[0])));
	}
  }
#line 20509 "parser.c" /* yacc.c:1646  */
    break;

  case 1953:
#line 12870 "parser.y" /* yacc.c:1646  */
    {
	int     reference_to_existing_object;

	if (CB_REFERENCE_P ((yyvsp[0])) && (CB_FIELD_P (cb_ref ((yyvsp[0])))
				    || CB_FILE_P (cb_ref ((yyvsp[0]))))) {
		(yyval) = cb_build_identifier ((yyvsp[0]), 0);
	} else {
		reference_to_existing_object =
			CB_REFERENCE_P ((yyvsp[0])) && cb_ref ((yyvsp[0])) != cb_error_node;
		if (!CB_REFERENCE_P ((yyvsp[0])) || reference_to_existing_object) {
			cb_error_x ((yyvsp[0]), _("'%s' is not a field or file"), cb_name ((yyvsp[0])));
		}
		(yyval) = cb_error_node;
	}
  }
#line 20529 "parser.c" /* yacc.c:1646  */
    break;

  case 1954:
#line 12889 "parser.y" /* yacc.c:1646  */
    {
	int     reference_to_existing_object;

	if (CB_REFERENCE_P ((yyvsp[0])) && CB_FIELD_P (cb_ref ((yyvsp[0])))) {
		(yyval) = cb_build_identifier ((yyvsp[0]), 0);
	} else {
		reference_to_existing_object =
			CB_REFERENCE_P ((yyvsp[0])) && cb_ref ((yyvsp[0])) != cb_error_node;
		if (!CB_REFERENCE_P ((yyvsp[0])) || reference_to_existing_object) {
			cb_error_x ((yyvsp[0]), _("'%s' is not a field"), cb_name ((yyvsp[0])));
		}
		(yyval) = cb_error_node;
	}
  }
#line 20548 "parser.c" /* yacc.c:1646  */
    break;

  case 1955:
#line 12907 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[-2]);
	if (start_debug) {
		cb_check_field_debug ((yyvsp[-2]));
	}
  }
#line 20559 "parser.c" /* yacc.c:1646  */
    break;

  case 1956:
#line 12914 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[-1]);
	if (start_debug) {
		cb_check_field_debug ((yyvsp[-1]));
	}
  }
#line 20570 "parser.c" /* yacc.c:1646  */
    break;

  case 1957:
#line 12921 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[-1]);
	if (start_debug) {
		cb_check_field_debug ((yyvsp[-1]));
	}
  }
#line 20581 "parser.c" /* yacc.c:1646  */
    break;

  case 1958:
#line 12928 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
	if (start_debug) {
		cb_check_field_debug ((yyvsp[0]));
	}
  }
#line 20592 "parser.c" /* yacc.c:1646  */
    break;

  case 1959:
#line 12938 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_LIST_INIT ((yyvsp[0]));
  }
#line 20600 "parser.c" /* yacc.c:1646  */
    break;

  case 1960:
#line 12942 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_list_add ((yyvsp[-1]), (yyvsp[0]));
  }
#line 20608 "parser.c" /* yacc.c:1646  */
    break;

  case 1961:
#line 12949 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_identifier ((yyvsp[0]), 0);
  }
#line 20616 "parser.c" /* yacc.c:1646  */
    break;

  case 1962:
#line 12956 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[-2]);
	if (CB_REFERENCE_P ((yyvsp[-2]))) {
		CB_REFERENCE ((yyvsp[-2]))->flag_target = 1;
	}
	if (start_debug) {
		cb_check_field_debug ((yyvsp[-2]));
	}
  }
#line 20630 "parser.c" /* yacc.c:1646  */
    break;

  case 1963:
#line 12966 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[-1]);
	if (CB_REFERENCE_P ((yyvsp[-1]))) {
		CB_REFERENCE ((yyvsp[-1]))->flag_target = 1;
	}
	if (start_debug) {
		cb_check_field_debug ((yyvsp[-1]));
	}
  }
#line 20644 "parser.c" /* yacc.c:1646  */
    break;

  case 1964:
#line 12976 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[-1]);
	if (CB_REFERENCE_P ((yyvsp[-1]))) {
		CB_REFERENCE ((yyvsp[-1]))->flag_target = 1;
	}
	if (start_debug) {
		cb_check_field_debug ((yyvsp[-1]));
	}
  }
#line 20658 "parser.c" /* yacc.c:1646  */
    break;

  case 1965:
#line 12986 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
	if (CB_REFERENCE_P ((yyvsp[0]))) {
		CB_REFERENCE ((yyvsp[0]))->flag_target = 1;
	}
	if (start_debug) {
		cb_check_field_debug ((yyvsp[0]));
	}
  }
#line 20672 "parser.c" /* yacc.c:1646  */
    break;

  case 1966:
#line 12999 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 20680 "parser.c" /* yacc.c:1646  */
    break;

  case 1967:
#line 13003 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[-2]);
	CB_REFERENCE ((yyvsp[-2]))->chain = (yyvsp[0]);
  }
#line 20689 "parser.c" /* yacc.c:1646  */
    break;

  case 1968:
#line 13011 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[-3]);
	CB_REFERENCE ((yyvsp[-3]))->subs = cb_list_reverse ((yyvsp[-1]));
  }
#line 20698 "parser.c" /* yacc.c:1646  */
    break;

  case 1969:
#line 13019 "parser.y" /* yacc.c:1646  */
    {
	CB_REFERENCE ((yyvsp[-4]))->offset = (yyvsp[-2]);
  }
#line 20706 "parser.c" /* yacc.c:1646  */
    break;

  case 1970:
#line 13023 "parser.y" /* yacc.c:1646  */
    {
	CB_REFERENCE ((yyvsp[-5]))->offset = (yyvsp[-3]);
	CB_REFERENCE ((yyvsp[-5]))->length = (yyvsp[-1]);
  }
#line 20715 "parser.c" /* yacc.c:1646  */
    break;

  case 1971:
#line 13033 "parser.y" /* yacc.c:1646  */
    {
	if (cb_tree_category ((yyvsp[0])) != CB_CATEGORY_NUMERIC
	    || CB_LITERAL ((yyvsp[0]))->sign < 0
	    || CB_LITERAL ((yyvsp[0]))->scale) {
		cb_error (_("non-negative integer value expected"));
		(yyval) = cb_build_numeric_literal(-1, "1", 0);
	} else {
		(yyval) = (yyvsp[0]);
	}
  }
#line 20730 "parser.c" /* yacc.c:1646  */
    break;

  case 1972:
#line 13047 "parser.y" /* yacc.c:1646  */
    {
	int	n;

	if (cb_tree_category ((yyvsp[0])) != CB_CATEGORY_NUMERIC) {
		cb_error (_("integer value expected"));
		(yyval) = cb_int1;
	} else if (CB_LITERAL ((yyvsp[0]))->sign || CB_LITERAL ((yyvsp[0]))->scale) {
		cb_error (_("integer value expected"));
		(yyval) = cb_int1;
	} else {
		n = cb_get_int ((yyvsp[0]));
		if (n < 1 || n > 256) {
			cb_error (_("invalid symbolic integer"));
			(yyval) = cb_int1;
		} else {
			(yyval) = (yyvsp[0]);
		}
	}
  }
#line 20754 "parser.c" /* yacc.c:1646  */
    break;

  case 1973:
#line 13070 "parser.y" /* yacc.c:1646  */
    {
	int	n;

	if (cb_tree_category ((yyvsp[0])) != CB_CATEGORY_NUMERIC
	    || CB_LITERAL ((yyvsp[0]))->sign
	    || CB_LITERAL ((yyvsp[0]))->scale) {
		cb_error (_("unsigned positive integer value expected"));
		(yyval) = cb_int1;
	} else {
		n = cb_get_int ((yyvsp[0]));
		if (n < 1) {
			cb_error (_("unsigned positive integer value expected"));
			(yyval) = cb_int1;
		} else {
			(yyval) = (yyvsp[0]);
		}
	}
  }
#line 20777 "parser.c" /* yacc.c:1646  */
    break;

  case 1974:
#line 13092 "parser.y" /* yacc.c:1646  */
    {
	int	n;

	if (cb_tree_category ((yyvsp[0])) == CB_CATEGORY_NUMERIC) {
		if (CB_LITERAL ((yyvsp[0]))->sign || CB_LITERAL ((yyvsp[0]))->scale) {
			cb_error (_("integer value expected"));
		} else {
			n = cb_get_int ((yyvsp[0]));
			if (n < 1 || n > 256) {
				cb_error (_("invalid CLASS value"));
			}
		}
	}
	(yyval) = (yyvsp[0]);
  }
#line 20797 "parser.c" /* yacc.c:1646  */
    break;

  case 1975:
#line 13107 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_space; }
#line 20803 "parser.c" /* yacc.c:1646  */
    break;

  case 1976:
#line 13108 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_zero; }
#line 20809 "parser.c" /* yacc.c:1646  */
    break;

  case 1977:
#line 13109 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_quote; }
#line 20815 "parser.c" /* yacc.c:1646  */
    break;

  case 1978:
#line 13110 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_high; }
#line 20821 "parser.c" /* yacc.c:1646  */
    break;

  case 1979:
#line 13111 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_low; }
#line 20827 "parser.c" /* yacc.c:1646  */
    break;

  case 1980:
#line 13112 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_null; }
#line 20833 "parser.c" /* yacc.c:1646  */
    break;

  case 1981:
#line 13117 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 20841 "parser.c" /* yacc.c:1646  */
    break;

  case 1982:
#line 13121 "parser.y" /* yacc.c:1646  */
    {
	struct cb_literal	*l;

	if (CB_LITERAL_P ((yyvsp[0]))) {
		/* We must not alter the original definition */
		l = cobc_parse_malloc (sizeof(struct cb_literal));
		*l = *(CB_LITERAL((yyvsp[0])));
		l->all = 1;
		(yyval) = CB_TREE (l);
	} else {
		(yyval) = (yyvsp[0]);
	}
  }
#line 20859 "parser.c" /* yacc.c:1646  */
    break;

  case 1983:
#line 13138 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 20867 "parser.c" /* yacc.c:1646  */
    break;

  case 1984:
#line 13142 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_concat_literals ((yyvsp[-2]), (yyvsp[0]));
  }
#line 20875 "parser.c" /* yacc.c:1646  */
    break;

  case 1985:
#line 13148 "parser.y" /* yacc.c:1646  */
    { (yyval) = (yyvsp[0]); }
#line 20881 "parser.c" /* yacc.c:1646  */
    break;

  case 1986:
#line 13149 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_space; }
#line 20887 "parser.c" /* yacc.c:1646  */
    break;

  case 1987:
#line 13150 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_zero; }
#line 20893 "parser.c" /* yacc.c:1646  */
    break;

  case 1988:
#line 13151 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_quote; }
#line 20899 "parser.c" /* yacc.c:1646  */
    break;

  case 1989:
#line 13152 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_high; }
#line 20905 "parser.c" /* yacc.c:1646  */
    break;

  case 1990:
#line 13153 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_low; }
#line 20911 "parser.c" /* yacc.c:1646  */
    break;

  case 1991:
#line 13154 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_null; }
#line 20917 "parser.c" /* yacc.c:1646  */
    break;

  case 1992:
#line 13161 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_intrinsic ((yyvsp[-1]), NULL, (yyvsp[0]), 0);
  }
#line 20925 "parser.c" /* yacc.c:1646  */
    break;

  case 1993:
#line 13165 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_intrinsic ((yyvsp[-4]), CB_LIST_INIT ((yyvsp[-2])), (yyvsp[0]), 0);
  }
#line 20933 "parser.c" /* yacc.c:1646  */
    break;

  case 1994:
#line 13169 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_intrinsic ((yyvsp[-4]), (yyvsp[-2]), (yyvsp[0]), 0);
  }
#line 20941 "parser.c" /* yacc.c:1646  */
    break;

  case 1995:
#line 13173 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_intrinsic ((yyvsp[-4]), (yyvsp[-2]), (yyvsp[0]), 0);
  }
#line 20949 "parser.c" /* yacc.c:1646  */
    break;

  case 1996:
#line 13177 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_intrinsic ((yyvsp[-3]), (yyvsp[-1]), NULL, 0);
  }
#line 20957 "parser.c" /* yacc.c:1646  */
    break;

  case 1997:
#line 13181 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_intrinsic ((yyvsp[-3]), (yyvsp[-1]), NULL, 0);
  }
#line 20965 "parser.c" /* yacc.c:1646  */
    break;

  case 1998:
#line 13185 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_intrinsic ((yyvsp[-4]), (yyvsp[-2]), (yyvsp[0]), 0);
  }
#line 20973 "parser.c" /* yacc.c:1646  */
    break;

  case 1999:
#line 13189 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_intrinsic ((yyvsp[-4]), (yyvsp[-2]), (yyvsp[0]), 0);
  }
#line 20981 "parser.c" /* yacc.c:1646  */
    break;

  case 2000:
#line 13193 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_intrinsic ((yyvsp[-4]), (yyvsp[-2]), (yyvsp[0]), 0);
  }
#line 20989 "parser.c" /* yacc.c:1646  */
    break;

  case 2001:
#line 13197 "parser.y" /* yacc.c:1646  */
    {
	  (yyval) = cb_build_intrinsic ((yyvsp[-4]), (yyvsp[-2]), (yyvsp[0]), 0);
  }
#line 20997 "parser.c" /* yacc.c:1646  */
    break;

  case 2002:
#line 13201 "parser.y" /* yacc.c:1646  */
    {
	  (yyval) = cb_build_intrinsic ((yyvsp[-4]), (yyvsp[-2]), (yyvsp[0]), 0);
  }
#line 21005 "parser.c" /* yacc.c:1646  */
    break;

  case 2003:
#line 13205 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_intrinsic ((yyvsp[-1]), (yyvsp[0]), NULL, 0);
  }
#line 21013 "parser.c" /* yacc.c:1646  */
    break;

  case 2004:
#line 13209 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_build_intrinsic ((yyvsp[-1]), (yyvsp[0]), NULL, 1);
  }
#line 21021 "parser.c" /* yacc.c:1646  */
    break;

  case 2014:
#line 13234 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 21029 "parser.c" /* yacc.c:1646  */
    break;

  case 2015:
#line 13238 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_BUILD_PAIR ((yyvsp[-2]), NULL);
  }
#line 21037 "parser.c" /* yacc.c:1646  */
    break;

  case 2016:
#line 13242 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = CB_BUILD_PAIR ((yyvsp[-3]), (yyvsp[-1]));
  }
#line 21045 "parser.c" /* yacc.c:1646  */
    break;

  case 2017:
#line 13249 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 21053 "parser.c" /* yacc.c:1646  */
    break;

  case 2018:
#line 13253 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[-1]);
  }
#line 21061 "parser.c" /* yacc.c:1646  */
    break;

  case 2019:
#line 13257 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 21069 "parser.c" /* yacc.c:1646  */
    break;

  case 2020:
#line 13264 "parser.y" /* yacc.c:1646  */
    {
	cb_tree	x;

	x = CB_LIST_INIT ((yyvsp[0]));
	(yyval) = cb_list_add (x, cb_int0);
  }
#line 21080 "parser.c" /* yacc.c:1646  */
    break;

  case 2021:
#line 13271 "parser.y" /* yacc.c:1646  */
    {
	cb_tree	x;

	x = CB_LIST_INIT ((yyvsp[-2]));
	(yyval) = cb_list_add (x, cb_int1);
  }
#line 21091 "parser.c" /* yacc.c:1646  */
    break;

  case 2022:
#line 13278 "parser.y" /* yacc.c:1646  */
    {
	cb_tree	x;

	x = CB_LIST_INIT ((yyvsp[-2]));
	(yyval) = cb_list_add (x, cb_int2);
  }
#line 21102 "parser.c" /* yacc.c:1646  */
    break;

  case 2023:
#line 13287 "parser.y" /* yacc.c:1646  */
    {
	suppress_data_exceptions = 1;
  }
#line 21110 "parser.c" /* yacc.c:1646  */
    break;

  case 2024:
#line 13291 "parser.y" /* yacc.c:1646  */
    {
	suppress_data_exceptions = 0;
	(yyval) = CB_LIST_INIT ((yyvsp[0]));
  }
#line 21119 "parser.c" /* yacc.c:1646  */
    break;

  case 2025:
#line 13299 "parser.y" /* yacc.c:1646  */
    {
	cb_tree	x;

	x = CB_LIST_INIT ((yyvsp[0]));
	(yyval) = cb_list_add (x, cb_null);
  }
#line 21130 "parser.c" /* yacc.c:1646  */
    break;

  case 2026:
#line 13306 "parser.y" /* yacc.c:1646  */
    {
	cb_tree	x;

	x = CB_LIST_INIT ((yyvsp[-2]));
	(yyval) = cb_list_add (x, (yyvsp[0]));
  }
#line 21141 "parser.c" /* yacc.c:1646  */
    break;

  case 2027:
#line 13316 "parser.y" /* yacc.c:1646  */
    {
	cb_tree	x;

	x = CB_LIST_INIT ((yyvsp[0]));
	(yyval) = cb_list_add (x, cb_null);
  }
#line 21152 "parser.c" /* yacc.c:1646  */
    break;

  case 2028:
#line 13323 "parser.y" /* yacc.c:1646  */
    {
	cb_tree	x;

	x = CB_LIST_INIT ((yyvsp[-2]));
	(yyval) = cb_list_add (x, cb_ref ((yyvsp[0])));
  }
#line 21163 "parser.c" /* yacc.c:1646  */
    break;

  case 2029:
#line 13333 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_list_add ((yyvsp[0]), cb_int0);
  }
#line 21171 "parser.c" /* yacc.c:1646  */
    break;

  case 2030:
#line 13337 "parser.y" /* yacc.c:1646  */
    {
	const int	num_args = cb_list_length ((yyvsp[-2]));

	if (num_args == 4) {
		cb_error_x ((yyvsp[-2]), _("cannot specify offset and SYSTEM-OFFSET at the same time"));
	}

	(yyval) = cb_list_add ((yyvsp[-2]), cb_int1);
  }
#line 21185 "parser.c" /* yacc.c:1646  */
    break;

  case 2031:
#line 13350 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_list_add ((yyvsp[0]), cb_int0);
  }
#line 21193 "parser.c" /* yacc.c:1646  */
    break;

  case 2032:
#line 13354 "parser.y" /* yacc.c:1646  */
    {
	const int	num_args = cb_list_length ((yyvsp[-2]));

	if (num_args == 3) {
		cb_error_x ((yyvsp[-2]), _("cannot specify offset and SYSTEM-OFFSET at the same time"));
	}

	(yyval) = cb_list_add ((yyvsp[-2]), cb_int1);
  }
#line 21207 "parser.c" /* yacc.c:1646  */
    break;

  case 2033:
#line 13368 "parser.y" /* yacc.c:1646  */
    {
	non_const_word = 1;
  }
#line 21215 "parser.c" /* yacc.c:1646  */
    break;

  case 2034:
#line 13376 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int0; }
#line 21221 "parser.c" /* yacc.c:1646  */
    break;

  case 2035:
#line 13377 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int1; }
#line 21227 "parser.c" /* yacc.c:1646  */
    break;

  case 2036:
#line 13381 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int0; }
#line 21233 "parser.c" /* yacc.c:1646  */
    break;

  case 2037:
#line 13382 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int1; }
#line 21239 "parser.c" /* yacc.c:1646  */
    break;

  case 2038:
#line 13386 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 21245 "parser.c" /* yacc.c:1646  */
    break;

  case 2039:
#line 13387 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int1; }
#line 21251 "parser.c" /* yacc.c:1646  */
    break;

  case 2040:
#line 13392 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 21259 "parser.c" /* yacc.c:1646  */
    break;

  case 2041:
#line 13396 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 21267 "parser.c" /* yacc.c:1646  */
    break;

  case 2042:
#line 13403 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
  }
#line 21275 "parser.c" /* yacc.c:1646  */
    break;

  case 2043:
#line 13407 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 21283 "parser.c" /* yacc.c:1646  */
    break;

  case 2044:
#line 13414 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int0; }
#line 21289 "parser.c" /* yacc.c:1646  */
    break;

  case 2045:
#line 13415 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int1; }
#line 21295 "parser.c" /* yacc.c:1646  */
    break;

  case 2046:
#line 13416 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int2; }
#line 21301 "parser.c" /* yacc.c:1646  */
    break;

  case 2047:
#line 13420 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 21307 "parser.c" /* yacc.c:1646  */
    break;

  case 2048:
#line 13421 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_true; }
#line 21313 "parser.c" /* yacc.c:1646  */
    break;

  case 2049:
#line 13425 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int (cb_flag_optional_file); }
#line 21319 "parser.c" /* yacc.c:1646  */
    break;

  case 2050:
#line 13426 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int1; }
#line 21325 "parser.c" /* yacc.c:1646  */
    break;

  case 2051:
#line 13427 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int0; }
#line 21331 "parser.c" /* yacc.c:1646  */
    break;

  case 2052:
#line 13432 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int0;
  }
#line 21339 "parser.c" /* yacc.c:1646  */
    break;

  case 2053:
#line 13436 "parser.y" /* yacc.c:1646  */
    {
	if ((yyvsp[0])) {
		(yyval) = (yyvsp[0]);
	} else {
		(yyval) = default_rounded_mode;
	}
	cobc_cs_check = 0;
  }
#line 21352 "parser.c" /* yacc.c:1646  */
    break;

  case 2054:
#line 13448 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = NULL;
	cobc_cs_check = 0;
  }
#line 21361 "parser.c" /* yacc.c:1646  */
    break;

  case 2055:
#line 13453 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
	cobc_cs_check = 0;
  }
#line 21370 "parser.c" /* yacc.c:1646  */
    break;

  case 2056:
#line 13461 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int (COB_STORE_ROUND | COB_STORE_AWAY_FROM_ZERO);
  }
#line 21378 "parser.c" /* yacc.c:1646  */
    break;

  case 2057:
#line 13465 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int (COB_STORE_ROUND | COB_STORE_NEAR_AWAY_FROM_ZERO);
  }
#line 21386 "parser.c" /* yacc.c:1646  */
    break;

  case 2058:
#line 13469 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int (COB_STORE_ROUND | COB_STORE_NEAR_EVEN);
  }
#line 21394 "parser.c" /* yacc.c:1646  */
    break;

  case 2059:
#line 13473 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int (COB_STORE_ROUND | COB_STORE_NEAR_TOWARD_ZERO);
  }
#line 21402 "parser.c" /* yacc.c:1646  */
    break;

  case 2060:
#line 13477 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int (COB_STORE_ROUND | COB_STORE_PROHIBITED);
  }
#line 21410 "parser.c" /* yacc.c:1646  */
    break;

  case 2061:
#line 13481 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int (COB_STORE_ROUND | COB_STORE_TOWARD_GREATER);
  }
#line 21418 "parser.c" /* yacc.c:1646  */
    break;

  case 2062:
#line 13485 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int (COB_STORE_ROUND | COB_STORE_TOWARD_LESSER);
  }
#line 21426 "parser.c" /* yacc.c:1646  */
    break;

  case 2063:
#line 13489 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = cb_int (COB_STORE_ROUND | COB_STORE_TRUNCATION);
  }
#line 21434 "parser.c" /* yacc.c:1646  */
    break;

  case 2064:
#line 13495 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 21440 "parser.c" /* yacc.c:1646  */
    break;

  case 2065:
#line 13496 "parser.y" /* yacc.c:1646  */
    { (yyval) = cb_int1; }
#line 21446 "parser.c" /* yacc.c:1646  */
    break;

  case 2066:
#line 13500 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 21452 "parser.c" /* yacc.c:1646  */
    break;

  case 2067:
#line 13502 "parser.y" /* yacc.c:1646  */
    {
	cb_tree	x;

	x = CB_LIST_INIT ((yyvsp[-3]));
	(yyval) = cb_list_add (x, (yyvsp[-1]));
  }
#line 21463 "parser.c" /* yacc.c:1646  */
    break;

  case 2068:
#line 13511 "parser.y" /* yacc.c:1646  */
    { (yyval) = NULL; }
#line 21469 "parser.c" /* yacc.c:1646  */
    break;

  case 2069:
#line 13513 "parser.y" /* yacc.c:1646  */
    {
	(yyval) = (yyvsp[0]);
  }
#line 21477 "parser.c" /* yacc.c:1646  */
    break;

  case 2070:
#line 13522 "parser.y" /* yacc.c:1646  */
    {
	cobc_repeat_last_token = 1;
  }
#line 21485 "parser.c" /* yacc.c:1646  */
    break;

  case 2071:
#line 13526 "parser.y" /* yacc.c:1646  */
    {
	cobc_repeat_last_token = 1;
  }
#line 21493 "parser.c" /* yacc.c:1646  */
    break;

  case 2072:
#line 13530 "parser.y" /* yacc.c:1646  */
    {
	cobc_repeat_last_token = 0;
  }
#line 21501 "parser.c" /* yacc.c:1646  */
    break;


#line 21505 "parser.c" /* yacc.c:1646  */
      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYEMPTY : YYTRANSLATE (yychar);

  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (YY_("syntax error"));
#else
# define YYSYNTAX_ERROR yysyntax_error (&yymsg_alloc, &yymsg, \
                                        yyssp, yytoken)
      {
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = YYSYNTAX_ERROR;
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == 1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = (char *) YYSTACK_ALLOC (yymsg_alloc);
            if (!yymsg)
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = 2;
              }
            else
              {
                yysyntax_error_status = YYSYNTAX_ERROR;
                yymsgp = yymsg;
              }
          }
        yyerror (yymsgp);
        if (yysyntax_error_status == 2)
          goto yyexhaustedlab;
      }
# undef YYSYNTAX_ERROR
#endif
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYTERROR;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  yystos[yystate], yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#if !defined yyoverflow || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  yystos[*yyssp], yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  return yyresult;
}
#line 13714 "parser.y" /* yacc.c:1906  */

