/*
  INES (INstall EDMA System) Uninstaller version 0.0.0
  Copyright (C) 1998-2005 David Martnez Oliveira
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; see the file COPYING.  If not, write to
  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <signal.h>
#include <time.h>
#include <unistd.h>

#include <edma.h>

/* Constants */
#define VERSION "0.1.0"
#define COPYRIGHT "(c) David Martnez Oliveira"

typedef EChar my_string[80];

int main(int argc,char *argv[])
{
  int       i,n,id,n_depend;
  my_string aux;
  my_string aux1;
  my_string module_name;
  my_string namespace;
  EChar     idf_name[1024];
  EPChar    the_path;
  EChar     module_fname[1024];

  printf ("%s", "\nINES (INstall EDMA System) Class Unregister");
  printf ("\nVersion %s", VERSION);
  printf ("\n%s\n", COPYRIGHT);

  if (argc != 2) 
    {
      printf ("%s", "\nWrong parameter number");
      printf ("%s", "\nUsage: ines_uninstaller EDMA_CLASS_NAME\n\n");
      exit(1);
    }
  
  /* Initialize EDMA System */
  EDMAInit();
  printf ("%s", "\n---------------------------------------------------");
  printf ("%s", "\nEDMA System up");
  printf ("%s", "\nINES (INstaller EDMA System) Uninstaller ready");
  printf ("%s", "\n---------------------------------------------------");
  printf ("\n + Looking for Class %s...", argv[1]);
  
  id = edma_get_class_id (argv[1]);
  if (id == -1) 
    {
      printf ("%s", "\n - Can't locate class. Aborting");
      EDMAEnd ();
      exit (1);
    }

  printf (" Class located with id %d", id);
  i = edma_get_class_module (id, module_name);
  if (i == -1) 
    {
      printf ("%s", "\n - Error looking for Module Name");
      EDMAEnd ();
      exit (1);
    }

  /* Get IDF file location */
  the_path = edma_get_system_path ();
  
  /* XXX: Change bellow for snprintf */
  strcpy (idf_name, the_path);
  strcat (idf_name, "share/edma/idf/");
  edma_get_class_namespace (id, namespace);
  strcat (idf_name, namespace);
  strcat (idf_name, "/");
  strcat (idf_name, argv[1]);
  strcat (idf_name, ".idf");
  printf ("\n + IDF file should be in : %s", idf_name);
  n = edma_get_num_reg_classes();
  printf ("\n + Looking for Module Dependences : (%s)", module_name);
  printf ("\n   Looking in %d classes", n);
  n_depend = 0;
  for (i = 0; i < n; i++) 
    {
      edma_get_class_module (i, aux);
      edma_get_class_name (i, aux1);
      if (strcmp (aux, module_name) == 0) 
	{
	  printf ("\n   * Class %s depends on module %s", aux1, module_name);
	  n_depend++;
	}
    }
  
  if (n_depend == 1) 
    { /* Only one class in the module */
      printf ("%s", "\n + No dependences... Uninstall is safe");
      printf ("%s", "\n   + Testing file existence ...");
      if ((ESint32) edma_smet3 ("FILESYSTEM", "TestFile", idf_name) != 1) 
	{
	  printf ("%s", "\n     - Can't find IDF file... Aborting");
	  EDMAEnd ();
	  exit (1);
	}
      printf ("%s", " OK");
      printf ("%s", "\n   + Freeing Class from EDMA register ...");
      
      i = 0;
      i = edma_del_stock_class (argv[1]);
      if (i == -1) 
	{
	  printf ("\n   - Can't Delete Class");
	  EDMAEnd ();
	  exit (1);
	}
      printf ("%s", "\n   + Class deleted from shared memory");
    
      printf ("\n + Class %s Succesfuly unregistered", argv[1]);
      printf ("%s", "\n*** To completly wipe out the class from your system:");
      printf ("\n*** Delete IDF file : %s", idf_name);
      printf ("\n*** Remove shared library %s and related links", module_name);
      printf ("\n***   Shared lib: %s\n", module_fname);
    }
  else 
    {
      printf ("\n * There are %d dependences on this class/module", n_depend);
    }
  
  printf ("%s", "\n----------------------------------------------------");
  free (the_path);
  EDMAEnd ();

  return 0;
}











