#include <stdio.h>
#include <edma.h>


ESint32 EDMAPROC my_func (OBJID IdObj)
{
  edma_printf ("[Main App] Invoked Met1 on SUPER_CLASS object");
  return 0;
}

int main (int argc, char *argv[])
{
  OBJID		id, id1;
  POBJ          pObj;
  
  EDMAInit();
  id = edma_new_obj ("SUBCLASS1");
  id1 = edma_upcast_obj (id, "SUPER_CLASS");
  
  edma_printf ("%s", "----------------------------------------------");
  edma_printf ("%s", "-> Running method 'Met1' on object");
  edma_met3 (id, "Met1");
  edma_printf ("%s", "-> Running method 'SUPER_CLASS>Met1' on object");
  edma_met3 (id, "SUPER_CLASS>Met1");
  edma_obj_report (id);
  edma_obj_report (id1);
  edma_printf ("%s", "Press any key to continue....");
  getchar();
  
  edma_printf ("%s", "----------------------------------------------");
  edma_printf ("%s", "** Override Met1 on SUPER_CLASS with function in main app");

  edma_printf ("%s", "-> Running: edma_over_met (id, \"SUPER_CLASS>Met1\", NULL, my_func);");
  edma_over_met (id, "SUPER_CLASS>Met1", NULL, (PPROC)my_func);
  edma_printf ("%s", "-> Running method 'SUPER_CLASS>Met1' on object");  
  edma_met3 (id, "SUPER_CLASS>Met1");
  edma_obj_report (id1);
  edma_printf ("%s", "----------------------------------------------");
  edma_printf ("%s", "Press any key to continue....");
  getchar();
  
  edma_printf ("%s", "** Running original Met1 on SUPER_CLASS");
  edma_printf ("%s", "-> Running method 'SUPER_CLASS>Met1' on object");  
  edma_old_met3 (id, "SUPER_CLASS>Met1");

  edma_printf ("%s", "Press any key to continue....");
  getchar();

  edma_printf ("%s", "----------------------------------------------");
  edma_printf ("%s", "** Removing override on Met1 on SUPER_CLASS");
  edma_restore_met (id, "SUPER_CLASS>Met1");
  edma_printf ("%s", "-> Running method 'SUPER_CLASS>Met1' on object");  
  edma_met3 (id, "SUPER_CLASS>Met1");
  edma_printf ("%s", "Press any key to continue....");
  getchar();

  edma_printf ("%s", "----------------------------------------------");
  edma_printf ("%s", "** Override Met1 on SUPER_CLASS with Met2 on SUBCLASS1 (over_met3)");

  printf ("-------------------------------------------\n");

  edma_over_met3 (id, "SUPER_CLASS>Met1", "Met2");
  printf ("-------------------------------------------\n");

  edma_met3 (id, "SUPER_CLASS>Met1");
  printf ("-------------------------------------------\n");
  edma_old_met3 (id, "SUPER_CLASS>Met1");
  printf ("-------------------------------------------\n");
  edma_obj_report (id1);
  printf ("-------------------------------------------\n");
  edma_printf ("%s", "Press any key to continue....");
  getchar();

  edma_printf ("%s", "----------------------------------------------");
  edma_printf ("%s", "** Restore Met1 on SUPER_CLASS");

  edma_restore_met (id, "SUPER_CLASS>Met1");
  edma_met3 (id, "SUPER_CLASS>Met1");
  edma_met3 (id, "Met2");
  edma_obj_report (id1);
  edma_printf ("%s", "Press any key to continue....");
  getchar();
  edma_printf ("%s", "----------------------------------------------");

  edma_free_obj (id);
  edma_printf ("%s", "----------------------------------------------");
  EDMAEnd();
}
