/*
    inh_test Version 0.0
    Copyright (C) 1998-1999 David Martnez Oliveira
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.    

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; see the file COPYING.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <edma.h>

main(int argc,char *argv[])
{
  OBJID            id;

  if (argc != 2)
    {
      fprintf (stderr, "Incorrect number of parameters\n");
      fprintf (stderr, "Try: %s CLASS_NAME\n", argv[0]);
      return -1;
    }

  /* Initialize EDMA System*/
  EDMAInit();

  edma_printf ("****[ Create simple object of class '%s']****", argv[1]);
  id = edma_new_obj (argv[1]);
  if (id == -1)
    {
      edma_printf ("%s", "Can't create object. Aborting\n");
      EDMAEnd();
      return -1;
    }
  edma_obj_report (id);
 
  edma_printf ("%s", "\n");
  edma_printf ("%s", "==== BEGIN::[Subobject Tree] =========================================");
  edma_show_subobjects_down (id, "[The Object]", 0);
  edma_printf ("%s", "====== END::[Subobject Tree] =========================================\n");
  edma_printf ("%s", "==== BEGIN::[Superobject Tree] =======================================");
  edma_show_subobjects_up (id, "[The Object]", 0);
  edma_printf ("%s", "====== END::[Superobject Tree] =======================================\n");

  edma_printf ("%s", "==== BEGIN: Object Interface =========================================");
  edma_show_object_interface (id);

  edma_printf ("****[Destroy '%s' object]****\n", argv[1]);
  edma_free_obj (id);
  /* Shutdown EDMA Suystem */
  EDMAEnd();
  return 0;
}
