/*
    anna_interp_test Version 0.0
    Copyright (C) 1998-1999 David Martnez Oliveira
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.    

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; see the file COPYING.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <signal.h>
#include <time.h>
#include <unistd.h>

#include <edma.h>

main(int argc,char *argv[])
{
  ESint32          i;
  OBJID            id;
  OBJID            id_sc;

  /* Initialize EDMA System*/
  EDMAInit();

  /* Put your C code here */
  printf ("\nANNA SIU Proxy Test\n");
  printf ("===================\n");
  if ((id = edma_new_obj ("ANNA_PYTHON_INTERP"))==-1)  {
    printf ("Can't create SUPER_CLASS object");
    EDMAEnd();
    exit(1);
  }
  edma_met3 (id, "Initialize");
  edma_met3 (id, "Run_SimpleString", "print 'Hello World from Python!!!'");

  edma_met3 (id, "Run_SimpleString", "my_obj = edma.new_obj (\"REALIZATION\")");
  edma_met3 (id, "Run_SimpleString", "edma.met3 (my_obj, 'met1', 'si', ('Hello World!', 125))");
  edma_met3 (id, "Run_SimpleString", "edma.met3 (my_obj, 'met2', 's', ('Hello Again!', ))");
  edma_met3 (id, "Run_SimpleString", "edma.free_obj (my_obj)");
  edma_printf ("--------------------------------------------------------\n");
  edma_printf ("Running test.py script\n");
  edma_met3 (id, "Run_Script", "./test.py");
  edma_printf ("\n---------------------------------------------------------\n");
  edma_met3 (id,"Finalize");

  edma_free_obj (id);

  /* Shutdown EDMA Suystem */
  EDMAEnd();
  return 0;
}

