#include <stdio.h>
#include <string.h>

#include <edma.h>

int main (int argc, char *argv[])
{
  OBJID		id;
  EDMAT_BUFFER  wbuf, rbuf;
  ESint32       len;
  
  EDMAInit();
  id = edma_new_obj ("MEMORY_STREAM");
  edma_buffer_alloc (&wbuf, 20);
  edma_buffer_alloc (&rbuf, 50);
  memcpy (wbuf.dat, "Hello World!!!", 14);
  printf ("Init\n");
  len = 14;
  edma_met3 (id, "write", wbuf, &len);
  edma_met3 (id, "write", wbuf, &len);
  len = 60;

  edma_met3 (id, "rewind");
  edma_met3 (id, "read", &rbuf, &len);
  printf ("%ld bytes read. buffer is: %s\n", len, rbuf.dat);

  edma_met3 (id, "read", &rbuf, &len);
  printf ("%ld bytes read. buffer is: %s\n", len, rbuf.dat);

  printf ("=======================================================\n");
  edma_free_obj (id);
  EDMAEnd();
}
