#include <stdio.h>
#include <edma.h>

void EDMAPROC tl_handler1 (OBJID id)
{
  edma_printf_obj (id, "Handler 1");
}

void EDMAPROC tl_handler2 (OBJID id)
{
  edma_printf_obj (id, "Handler 2");
}

void EDMAPROC m1_handler1 (OBJID id)
{
  edma_printf_obj (id, "Handler 1");
}

void EDMAPROC m2_handler2 (OBJID id)
{
  edma_printf_obj (id, "Handler 2");
}

int
main ()
{
  CLASSID    cid;
  OBJID      id, id1, e;

  EDMAInit();

  //cid = edma_get_local_class_id ();
  cid = edma_idf_get_free_class_id (EDMA_LOCAL_CLASS);

  edma_idf_set_class_name (cid, "TOP_LEVEL");
  edma_idf_set_class_namespace (cid, "LOCAL");
  edma_idf_set_class_version (cid, 0, 0);

  edma_add_local_class_method (cid, "handler1", "", (PPROC) tl_handler1, 0, 0, 0);
  edma_add_local_class_method (cid, "handler2", "", (PPROC) tl_handler2, 0, 0, 0);

  //edma_local_class_finish (cid);
  edma_idf_set_class_id (cid);

  //cid = edma_get_local_class_id ();
  cid = edma_idf_get_free_class_id (EDMA_LOCAL_CLASS);

  edma_idf_set_class_name (cid, "MEDIUM1");
  edma_idf_set_class_namespace (cid, "LOCAL");
  edma_idf_set_class_version (cid, 0, 0);

  edma_add_local_class_method (cid, "handler1", "", (PPROC) m1_handler1, 0, 0, 0);

  edma_add_local_class_superclass_by_name (cid, "TOP_LEVEL", "CHILD", "PARENT");

  //edma_local_class_finish (cid);
  edma_idf_set_class_id (cid);

  //cid = edma_get_local_class_id ();
  cid = edma_idf_get_free_class_id (EDMA_LOCAL_CLASS);

  edma_idf_set_class_name (cid, "MEDIUM2");
  edma_idf_set_class_namespace (cid, "LOCAL");
  edma_idf_set_class_version (cid, 0, 0);

  edma_add_local_class_method (cid, "handler2", "", (PPROC) m2_handler2, 0, 0, 0);

  edma_add_local_class_superclass_by_name (cid, "TOP_LEVEL", "CHILD", "PARENT");

  //edma_local_class_finish (cid);
  edma_idf_set_class_id (cid);

  //cid = edma_get_local_class_id ();
  //cid = edma_idf_get_free_class_id (EDMA_LOCAL_CLASS);

  id = edma_new_obj ("MEDIUM1");
  id1 = edma_new_obj ("MEDIUM2");

  EDMA_TRY
    {
      edma_met3 (id, "handler1");
      edma_met3 (id, "handler2");
      edma_met3 (id1, "handler1");
      edma_met3 (id1, "handler2");
      edma_met3 (id1, "handler3");
    }
  EDMA_CATCH (e)
    {
      edma_printf ("Handler not found");
      edma_met3 (e, "brief");
    }
  EDMA_TRY_END;

  edma_free_obj (id);
  edma_free_obj (id1);

  EDMAEnd();
}
