#include <stdio.h>
#include <edma.h>

ESint32 EDMAPROC
something1 (OBJID id)
{
  edma_printf_obj (id, "Operation 1");
  return 0;
}

ESint32 EDMAPROC
something2 (OBJID id)
{
  edma_printf_obj (id, "Operation 2");
  return 0;
}

ESint32 EDMAPROC
impl1_1 (OBJID id)
{
  edma_printf_obj (id, "Operation 1");
  return 0;
}

ESint32 EDMAPROC
impl1_2 (OBJID id)
{
  edma_printf_obj (id, "Operation 2");
  return 0;
}

ESint32 EDMAPROC
impl2_1 (OBJID id)
{
  edma_printf_obj (id, "Operation 1");
  return 0;
}

ESint32 EDMAPROC
impl2_2 (OBJID id)
{
  edma_printf_obj (id, "Operation 2");
  return 0;
}

int
main()
{
  OBJID     id;
  CLASSID   cid;


  EDMAInit();
  //cid = edma_get_local_class_id ();
  cid = edma_idf_get_free_class_id (EDMA_LOCAL_CLASS);

  edma_idf_set_class_name (cid, "SOMETHING");
  edma_idf_set_class_namespace (cid, "LOCAL");
  edma_idf_set_class_version (cid, 0, 0);

  edma_add_local_class_method (cid, "operation1", "", (PPROC) something1, 0, 0, 0);
  edma_add_local_class_method (cid, "operation2", "", (PPROC) something2, 0, 0, 0);

  //edma_local_class_finish (cid);
  edma_idf_set_class_id (cid);

  //cid = edma_get_local_class_id ();
  cid = edma_idf_get_free_class_id (EDMA_LOCAL_CLASS);

  edma_idf_set_class_name (cid, "IMPL1");
  edma_idf_set_class_namespace (cid, "LOCAL");
  edma_idf_set_class_version (cid, 0, 0);

  edma_add_local_class_method (cid, "operation1", "", (PPROC) impl1_1, 0, 0, 0);
  edma_add_local_class_method (cid, "operation2", "", (PPROC) impl1_2, 0, 0, 0);

  //edma_add_local_class_superclass_by_name (cid, "SOMETHING", "IMP", "SUPER");
  edma_add_local_class_superclass_by_name (cid, "SOMETHING", "SUPER", "IMP");

  //edma_local_class_finish (cid);
  edma_idf_set_class_id (cid);

  //cid = edma_get_local_class_id ();
  cid = edma_idf_get_free_class_id (EDMA_LOCAL_CLASS);

  edma_idf_set_class_name (cid, "IMPL2");
  edma_idf_set_class_namespace (cid, "LOCAL");
  edma_idf_set_class_version (cid, 0, 0);

  edma_add_local_class_method (cid, "operation1", "", (PPROC) impl2_1, 0, 0, 0);
  edma_add_local_class_method (cid, "operation2", "", (PPROC) impl2_2, 0, 0, 0);

  //edma_add_local_class_superclass_by_name (cid, "SOMETHING", "IMP", "SUPER");
  edma_add_local_class_superclass_by_name (cid, "SOMETHING", "SUPER", "IMP");

  //edma_local_class_finish (cid);
  edma_idf_set_class_id (cid);

  id = edma_new_obj ("SOMETHING");
  // Specialize
  edma_printf ("Specialize 'SOMETHING' to implementation 1");
  edma_met3 (id, "IMPL1@IMP|SUPER<operation1");
  edma_met3 (id, "operation2");
  edma_obj_report (id);

  edma_printf ("Change implementation");

  /******************************************************************/
  /* When anchor points are reversed (see comented lined above on class
   * definition when adding superclass), the program crashes if there is
   * another GNU/EDMA process running 
   */
  /******************************************************************/

  // On overwrite we can specify uplink name
  //edma_met3 (id, "IMPL2@!IMP|SUPER<operation1");
  edma_met3 (id, "IMPL2@!IMP<operation1");
  edma_met3 (id, "operation2");
  edma_obj_report (id);

  edma_free_obj (id);
  EDMAEnd();

}
