#include <stdio.h>
#include <edma.h>

ESint32 EDMAPROC
set_person_name (OBJID id, EPChar name)
{
  edma_wprop3 (id, "name", name);
  return 0;
}

ESint32 EDMAPROC 
get_person_name (OBJID id, EPChar name)
{
  edma_rprop3 (id, "name", name);

  return 0;
}

ESint32 EDMAPROC
whoareu (OBJID id)
{
  edma_met3 (id, "display");
  return 0;
}

int
main ()
{
  OBJID    id;
  CLASSID  cid;

  EDMAInit ();

  edma_printf ("%s", "+ Creating class PERSON_ADAPTER");
  //cid = edma_get_local_class_id ();
  cid = edma_idf_get_free_class_id (EDMA_LOCAL_CLASS);

  edma_idf_set_class_name (cid, "PERSON_ADAPTOR");
  edma_idf_set_class_namespace (cid, "LOCAL");
  edma_idf_set_class_version (cid, 0, 0);

  //edma_add_local_class_property (cid, "title", DT_EZSTRING, E_L, 0);
  edma_add_local_class_method (cid, "set_name", "Z", (PPROC) set_person_name, 0, 0, 0);
  edma_add_local_class_method (cid, "get_name", "rZ", (PPROC) get_person_name, 0, 0, 0);

  edma_add_local_class_method (cid, "who_are_you", "", (PPROC) whoareu, 0, 0, 0);
  
  //edma_local_class_finish (cid);
  edma_idf_set_class_id (cid);

  edma_printf ("%s", "+ Creating 'PERSON' instance");
  id = edma_new_obj ("PERSON");

  edma_printf ("%s", "+ Attaching PERSON_ADAPTOR to PERSON object");
  edma_add_subclass (id, cid, "ADAPTOR", "TARGET");
  edma_printf ("%s", "+ Accesing PERSON using New Interface. New Clientes");
  edma_met3 (id, "set_name", "John Smith");
  edma_met3 (id, "who_are_you");
  edma_printf ("%s", "\n+ Accessing PERSON Using Old Interface. Old Clientes");
  edma_met3 (id, "display");
  edma_printf ("%s", "\n");
  

  edma_free_obj (id);

  EDMAEnd ();
  return 0;
}
