#include <stdio.h>
#include <edma.h>

typedef EChar  MY_STRING[EDMA_CLASS_NAME_LEN];

#define WALL 1
#define DOOR 2
#define ROOM 3

ESint32 EDMAPROC
create_maze (OBJID id, EDMAT_BUFFER buf)
{
  MY_STRING   *parts;
  OBJID       r1, r2;

  parts = (MY_STRING*)buf.Dat;
  r1 = edma_new_obj (parts[ROOM]);
  r2 = edma_new_obj (parts[ROOM]);
}

int
main ()
{
  OBJID         id;
  CLASSID       cid;
  EDMAT_BUFFER  buf;

  EDMAInit ();
  //cid = edma_get_local_class_id ();
  cid = edma_idf_get_free_class_id (EDMA_LOCAL_CLASS);

  edma_idf_set_class_name (cid, "AFACTORY");
  edma_idf_set_class_namespace (cid, "LOCAL");
  edma_idf_set_class_version (cid, 0, 0);
  
  edma_add_local_class_property (cid, "title", DT_EZSTRING, E_L, 0);
  edma_add_local_class_method (cid, "produce", "A", (PPROC) create_maze, 0, 0, 0);
  
  //edma_local_class_finish (cid);
  edma_idf_set_class_id (cid);

  /* Fill-in Maze Parts */
  

  EDMAEnd ();
}
