/*
    pap_test Version 0.0
    Copyright (C) 1998-1999 David Martnez Oliveira
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.    

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; see the file COPYING.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <signal.h>
#include <time.h>
#include <unistd.h>

#include <edma.h>

main(int argc,char *argv[])
{
  ESint32          res;
  OBJID            id;
  OBJID            id_sc,id_sc1;

  /* Initialize EDMA System*/
  EDMAInit();

  /* Put your C code here */
  printf ("\n Preferer Anchor Point Test\n");
  printf ("+ Creating NFILE object...\n");
  if ((id = edma_new_obj ("NFILE"))==-1)  {
    printf ("Can't create SUBCLASE2 object");
    EDMAEnd();
    exit(1);
  }
  printf ("Object Report for NFILE object\n");
  edma_obj_report (id);
  printf ("--------------------------------\n");

  printf ("+ Upcasting object NFILE to STREAM...\n");
  id_sc1 = edma_upcast_obj (id, "STREAM");
  printf ("Object Report for STREAM superobject\n");
  edma_obj_report (id_sc1);
  edma_show_subobjects_down (id_sc1, "****", 0);
  printf ("--------------------------------------\n");

  edma_free_obj (id);

  /* Shutdown EDMA Suystem */
  EDMAEnd();
  return 0;
}
