/*
 * EDMA: Entorno de Desarrollo Modular y Abierto
 * Object Oriented and Componetware Framework
 * Copyright (C) 1998, 2002, 2003, 2004  David Martnez Oliveira
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.

 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/ 

#include <stdio.h>
#include <edma.h>

int main (int argc, char *argv[])
{
  OBJID		id, id1;
  
  EDMAInit();

  /* Simple Object Creation */
  id = edma_new_obj ("HELLO_WORLD");
  edma_obj_report (id);
  edma_free_obj (id);


  /* Single Static Inheritance*/
  id = edma_new_obj ("GRADUATE");
  edma_obj_report (id);
  edma_free_obj (id);


  /* SIU PROXY doesn't exists*/
  id = edma_new_obj ("UNKNOWN_PROXY:HELLO_WORLD");
  edma_obj_report (id);
  edma_free_obj (id);

  EDMAEnd();
}
