/*
    inner_test1 Version 0.0
    Copyright (C) 1998-1999 David Martnez Oliveira
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.    

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; see the file COPYING.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <signal.h>
#include <time.h>
#include <unistd.h>

#include <edma.h>

main(int argc,char *argv[])
{
  OBJID            id, id1;
  OBJID            id_sc,id_sc1;
  POBJ             pObj;

  /* Initialize EDMA System*/
  EDMAInit();
  
  /* Put your C code here */
  edma_print ("\nINNER Inheritance Test\n");
  edma_print ("==> Creating object of class GRADUATE_INNER1");
  if ((id = edma_new_obj ("GRADUATE_INNER1")) == -1)  
    {
      edma_print ("**ERR** Can't create object of class 'PERSON_INNER'");
      EDMAEnd();
      exit(1);
    }
  edma_wprop3 (id, "name", "John Smith");
  edma_wprop3 (id, "degree", "PhD Computer Science");
  id1 = edma_upcast_obj (id, "PERSON_INNER");
  edma_met3 (id1, ".display");
  printf ("\n---------------------------------------\n");
  edma_show_subobjects_down (id1, "***", 0);
  printf ("\n---------------------------------------\n");
  printf ("**** Adding new GRADUATE_INNER1 subobject\n");
  printf ("---------------------------------------\n");
  
  //edma_wprop3 (id, "GRADUATE_INNER1@INNER<degree", "M.S");

  /* Causes a segmentation fault... must be fixed 
   * Segmentation fault happens in edma_show_subobjects_up*/
  //edma_wprop3 (id, "GRADUATE_INNER1<degree", "M.S");

  /* Don't attach the new object because SUPER anchor point already exists
   * Should it link with the existing anchor point?
   * We need to enumerate the possible cases*/
  //edma_wprop3 (id, "GRADUATE_INNER1@INNER|SUPER<degree", "M.S");
  edma_wprop3 (id, "GRADUATE_INNER1@INNER|SUPER1<degree", "M.S Electrical Engineering");
  edma_met3 (id1, ".display");
  printf ("\n---------------------------------------\n");
  edma_show_subobjects_down (id1, "***", 0);
  printf ("\n---------------------------------------\n");
  id1 = edma_downcast_obj (id, "INNER");
  edma_show_subobjects_up (id1, "***", 0);
  printf ("\n::edma_free_obj ---------------------------------------\n");
  edma_free_obj (id);

  printf ("\n\n==========================================================\n");
  printf ("Main -----------------------------------------------------\n");
  printf ("==========================================================\n");
  /* Shutdown EDMA Suystem */
  EDMAEnd();
  return 0;
}
