/*
    com_like_iface Version 0.0
    Copyright (C) 1998-1999 David Martnez Oliveira
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.    

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; see the file COPYING.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
/*
 * Simple example about how to map a single object in a way similar to
 * XX-COM systems.
 *
 * We are using GNU/EDMA edma_new_obj instead of a factory
 */
#include <edma.h>

typedef struct HELLO_WORLD_iface_t
{
  ESint32 (*born)(OBJID);
  ESint32 (*rip)(OBJID);
  EPVoid  (*say)(OBJID);
} IHELLO_WORLD;

int 
main ()
{
  OBJID     id;
  IHELLO_WORLD *iface;

  EDMAInit();

  id = edma_new_obj ("HELLO_WORLD");

  edma_printf ("Object %ld of class 'HELLO_WORLD' has %d methods",
	       id, edma_get_all_met_func (id, (PPROC**)&iface));

  iface->say(id);
  
  edma_free_obj (id);
  EDMAEnd();

}
