/*
    shallow_clonning Version 0.0
    Copyright (C) 1998-1999 David Martnez Oliveira
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.    

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; see the file COPYING.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <signal.h>
#include <time.h>
#include <unistd.h>

#include <edma.h>

int
main(int argc,char *argv[])
{
  OBJID            id, id_clon;
  OBJID            id_sc, id_sc1;
  POBJ             pObj;
  EChar            str[80];

  /* Initialize EDMA System*/
  EDMAInit();

  /* TEST 1:
   * An object with two superclasses.
   * 
   * Both superclasses must be destroyed when the main object is free
   */

  if ((id = edma_new_obj ("AP_TEST")) == -1)  
    {
      EDMAEnd();
      exit(1);
    }
  edma_wprop3 (id, "Id", "BASE");


  /* Attach a superobject */
  edma_met3 (id, "GAP@SUPER2>gap");
  edma_wprop3 (id, "HELLO_WORLD@SUPER1>str", "SUPER1");

  edma_met3 (id, "GAP@INNER2<gap");
  edma_wprop3 (id, "HELLO_WORLD@INNER1<str", "INNER1");

  id_sc = edma_cast_obj (id, "SUPER1");
  id_sc1 = edma_cast_obj (id, "SUPER2");
  edma_met3 (id_sc, "display");
  edma_met3 (id, "display");
  
  /* Show object reports */
  edma_printf ("%s", "********** Show current object information *******");
  edma_obj_report (id);
  edma_obj_report (id_sc);
  edma_obj_report (id_sc1);

  edma_show_subobjects_up (id, "BOTTOM", 2);
  printf ("%s", "-----------------------------------------------------\n");
  edma_show_subobjects_down (id_sc, "SUPERCLASS_1", 2);
  printf ("%s", "-----------------------------------------------------\n");
  edma_show_subobjects_down (id_sc1, "SUPERCLASS_2", 2);
  printf ("%s", "\n-----------------------------------------------------\n");
  printf ("%s", "Press a key to clone this object struct.....\n");
  printf ("%s", "-----------------------------------------------------\n");

  getchar ();

  id_clon = edma_shallow_clone_obj (id);
  /* Show object reports */
  edma_printf ("%s", "********** Show CLON object information *******");
  edma_obj_report (id_clon);
  edma_obj_report (id_sc);
  edma_obj_report (id_sc1);

  edma_show_subobjects_up (id_clon, "BOTTOM", 2);
  printf ("%s", "-----------------------------------------------------\n");
  edma_show_subobjects_down (id_sc, "SUPERCLASS_1", 2);
  printf ("%s", "-----------------------------------------------------\n");
  edma_show_subobjects_down (id_sc1, "SUPERCLASS_2", 2);
  printf ("%s", "\n-----------------------------------------------------\n");
  printf ("%s", "\n-----------------------------------------------------\n");

  edma_met3 (id, "display");
  edma_met3 (id_clon, "display");
  
  edma_wprop3 (id_clon, "Id", "CLONED!!!");
  edma_met3 (id, "display");
  edma_met3 (id_clon, "display");
  
  edma_free_obj (id);
  edma_free_obj (id_clon);

  printf ("%s", "\n-----------------------------------------------------\n");
  /* Shutdown EDMA Suystem */
  EDMAEnd();
  return 0;
}
